#include <glib/gi18n.h>
#include <glib.h>
#include <alsa/asoundlib.h>
#include "apl.h"
#include "apl-main.h"
#include "apl-internal.h"
#include "apl-arkamys.h"
#include "apl-libArkamysAiviImx-handler.h"


#define apl_arkamys_request_new(req)  {req = g_malloc0(sizeof(ReqItem));\
            if(!req)\
            {\
                pr_critical("invalid request object \n");\
            }} \


#define apl_arkamys_request_delete(req){\
    if(req)\
    {\
        if(req->data)\
        {\
            g_free(req->data);\
            req->data = (void*)NULL;\
        }\
        pr_message("delete request object for property -> %d\n", req->RequestedParameter );\
        req->RequestedParameter = 0;\
        req->ReqType = REQ_TYPE_UNDEF;\
        req->pparam = (ArkParamList* )NULL;\
        g_free(req);\
        req = (ReqItem*)NULL;\
    }}\

#define  apl_arkamys_request_remove(req){\
    if(req)\
    {\
        if(req->data)\
        {\
            g_free(req->data);\
            req->data = (void*)NULL;\
        }\
        pr_message("remove request object for property -> %d\n", req->RequestedParameter);\
        req->RequestedParameter = 0;\
        req->ReqType = REQ_TYPE_UNDEF;\
        req->pparam = (ArkParamList* )NULL;\
    }}\


typedef struct _mydata
{
    /* thread safe instance processing and parameter manipulation*/
    GMutex      lock;

    /* module specifical data */
    tAplI32                 this_switch;
    aplmodstate             this_switch_state;
    aplmodstate             last_state;
    tAplI32                 ArkProcessCallCount;
    SetGetParamReqList      SetGetReqList;
    NotificationTable       NotifyTbl;
    aplAudioSamples_desc*   buf_desc;
    tAplI32                 mparam_aplArkamysSwitch;            /*  0x0200   WB,(tAplI32)*/
    tAplU16                 mparam_aplFrameShiftIn;             /*  10       WB,(tAplU16)*/
    tAplU16                 mparam_aplSampleRateIn;             /*  11       WB,(tAplU16)*/
    tAplU16                 mparam_aplChannelCntIn;             /*  12       WB,(tAplU16)*/
    tAplU16                 mparam_aplAudioPcmFormatIn;         /*  13       WB,(tAplU16)*/
    tAplU16                 mparam_aplFrameShiftOut;            /*  20       WB,(tAplU16)*/
    tAplU16                 mparam_aplSampleRateOut;            /*  21       WB,(tAplU16)*/
    tAplU16                 mparam_aplChannelCntOut;            /*  22       WB,(tAplU16)*/
    tAplU16                 mparam_aplAudioPcmFormatOut;        /*  23       WB,(tAplU16)*/

    /* last error */
    int                     last_error;
    aplmodstate             ark_lib_state;



    /* arkamys library specifical parameter */
    /* arkamys specific */
    tAplCfg*                paplCfg;
    ARKAMYS_HANDLE          ark_hdl;
}mydata;


LOCAL mydata*   module_data_inst = (mydata*)NULL;
LOCAL tAplBool  create_own_stream_buffer = aplFALSE;
LOCAL volatile  int lock_request_queue = 0;
LOCAL volatile  tAplI32 lock_request_queue_cnt = 0;



static ArkParamList arkparamcfg[] =
{
    {aplArkamysByPassActivate       , 100             , 0             , PARAM_ADRESS_UNDEF, 4               , aplFALSE, APL_PARAM_VARIABLE},
    {aplArkamysEolData              , 100             , 2             , PARAM_ADRESS_UNDEF, PARAM_SIZE_UNDEF, aplFALSE, APL_PARAM_VARIABLE},
    {aplArkamysSetData              , BLOCK_ID_UNDEF  , PARAM_ID_UNDEF, PARAM_ADRESS_UNDEF, PARAM_SIZE_UNDEF, aplFALSE, APL_PARAM_VARIABLE},
    {aplArkamysGetData              , BLOCK_ID_UNDEF  , PARAM_ID_UNDEF, PARAM_ADRESS_UNDEF, PARAM_SIZE_UNDEF, aplFALSE, APL_PARAM_VARIABLE},
    {aplArkamysReadData             , BLOCK_ID_UNDEF  , PARAM_ID_UNDEF, PARAM_ADRESS_UNDEF, PARAM_SIZE_UNDEF, aplFALSE, APL_PARAM_VARIABLE},
    {aplArkamysAmbienceSelect       , 100             , 3             , PARAM_ADRESS_UNDEF, 4               , aplFALSE, APL_PARAM_VARIABLE},
    {aplArkamysAvcActivate          , 1               , 0 /*3,v 1.6*/ , PARAM_ADRESS_UNDEF, 4               , aplFALSE, APL_PARAM_VARIABLE},
    {aplArkamysInputLevelDeviation  , 100             , 4             , PARAM_ADRESS_UNDEF, 4               , aplFALSE, APL_PARAM_VARIABLE},
    {aplArkamysCurrentSpeed         , 100/*18,v 1.6*/ , 8 /*3,v 1.6*/ , PARAM_ADRESS_UNDEF, 4               , aplFALSE, APL_PARAM_VARIABLE},
    {aplArkamysCurrentVolumeStep    , 100/*4,v 1.6*/  , 6             , PARAM_ADRESS_UNDEF, 4               , aplFALSE, APL_PARAM_VARIABLE},
    {aplArkamysCurrVolAttenuation   , 100/*4,v 1.6*/  , 7             , PARAM_ADRESS_UNDEF, 4               , aplFALSE, APL_PARAM_VARIABLE},
    {aplArkamysLibraryVersion       , 100             , 1             , PARAM_ADRESS_UNDEF, 12              , aplFALSE, APL_PARAM_VARIABLE},
    {aplArkamysLevelLoss            , 100             , 5             , PARAM_ADRESS_UNDEF, 4               , aplFALSE, APL_PARAM_CONSTANT /*APL_PARAM_VARIABLE v 1.6*/},
    {aplArkamysWriteMultiFrame      , BLOCK_ID_UNDEF  , PARAM_ID_UNDEF, PARAM_ADRESS_UNDEF, PARAM_SIZE_UNDEF, aplFALSE, APL_PARAM_VARIABLE /*APL_PARAM_VARIABLE v 1.6*/}
};


#define APL_ARKAMYS_PARAM_MAX ARRAYSIZE(arkparamcfg)

static ArkAmbienceMap AmbienceTable[AUDPROC_FI_AMBIENCE_MAX] =
{
    {AUDPROC_FI_AMBIENCE_NATURAL    , ARK_AMBIENCE_NATURAL  },
    {AUDPROC_FI_AMBIENCE_LOUNGE     , ARK_AMBIENCE_LOUNGE   },
    {AUDPROC_FI_AMBIENCE_LIVE       , ARK_AMBIENCE_LIVE     },
    {AUDPROC_FI_AMBIENCE_CLUB       , ARK_AMBIENCE_CLUB     },
    {AUDPROC_FI_AMBIENCE_DEMO_MODE  , ARK_AMBIENCE_DEMO_MOD }
};

#if 0
LOCAL tAplI32 apl_arkamys_lock_request_queue(void)
{

    lock_request_queue = 1;
    lock_request_queue_cnt++;

    pr_message("lock request queue with count -> %d\n", lock_request_queue_cnt);

    return lock_request_queue_cnt;
}

LOCAL tAplI32 apl_arkamys_unlock_request_queue(void)
{

    lock_request_queue = 0;
    if(lock_request_queue_cnt)
        lock_request_queue_cnt--;

    pr_message("unlock request queue with count -> %d\n", lock_request_queue_cnt);

    return lock_request_queue_cnt;
}
#endif


LOCAL tAplI32 apl_arkamys_get_ambience(unsigned char preset)
{
    int i;
    ArkAmbienceMap  *p;

    pr_debug("ENTER\n");

    if(preset > AUDPROC_FI_AMBIENCE_MAX)
        return (tAplI32)AUDPROC_FI_AMBIENCE_MAX;

    pr_debug("search entry for preset:%d \n", preset);

    for(i = 0, p = AmbienceTable; i < ARK_AMBIENCE_MAX; i++, p++)
    {
        if(p->ark_id == preset)
        {
            pr_debug("found user ambience selection:%d matching with ark lib select %d\n", p->audproc_id, preset);
            return p->audproc_id;
        }
    }

    return ARK_AMBIENCE_MAX;
}

LOCAL tAplU8 apl_arkamys_get_preset(tAplU8 user_id)
{
    int i;
    ArkAmbienceMap* p;

    pr_debug("ENTER\n");

    if(user_id > AUDPROC_FI_AMBIENCE_MAX)
        return AUDPROC_FI_AMBIENCE_MAX;


    pr_debug("search entry for ambience:%d\n", user_id);

    for(i = 0, p = AmbienceTable; i < AUDPROC_FI_AMBIENCE_MAX; i++, p++)
    {
        if(user_id == p->audproc_id)
        {
            pr_debug("found ambiance select:%d matching with preset:%d\n", p->audproc_id, p->ark_id);
            return p->ark_id;
        }
    }

    pr_debug("no entry found \n");
    return AUDPROC_FI_AMBIENCE_MAX;
}


LOCAL ArkParamList*  apl_arkamys_get_ark_param_cfg(tAplI32 aplparameter)
{
    ArkParamList *p = (ArkParamList*)NULL;

    pr_debug("ENTERED\n");


    unsigned int i;
    for(i = 0, p = arkparamcfg;  i <  APL_ARKAMYS_PARAM_MAX ; i++, p++)
    {
        if(aplparameter == p->aplparameter)
        {
            pr_debug("found entry at idx->%d for paramter->%d, type->%d, size->%d\n", i, aplparameter, p->aplparamtype, p->size);
            return p;
        }
    }

    pr_warning("no entry found for the requested paramter(%d)\n", aplparameter);

    return (ArkParamList*)NULL;
}


LOCAL void  apl_arkamys_print_ark_param_cfg(void)
{
    ArkParamList *p = (ArkParamList*)NULL;
    int lvl_save = 0;
    pr_debug("ENTERED\n");

    lvl_save = log_level;

    if(log_level < 2)
    {
        log_level = 2;
    }

    unsigned int i;
    for(i = 0, p = arkparamcfg;  i <  APL_ARKAMYS_PARAM_MAX ; i++, p++)
    {

        pr_debug("parameter struct[%d]: aplparameter->%d \n", i, p->aplparameter);
        pr_debug("parameter struct[%d]: arkblockid->%d \n", i, p->arkblockid);
        pr_debug("parameter struct[%d]: arkparamid->%d \n", i, p->arkparamid);
        pr_debug("parameter struct[%d]: size->%d \n", i, p->size);
        pr_debug("parameter struct[%d]: aplparamtype->%d \n", i, p->aplparamtype);
    }


    log_level = lvl_save;

    return;
}

LOCAL APL_STATUS  apl_arkamys_change_mod_state(mydata* mdata, aplmodstate state)
{

    pr_debug("ENTERED\n");

    if(!mdata)
    {
        pr_debug("module data pointer is NULL\n");
        return APL_ERR_NULL_POINTER;
    }

    /* protection section : todo  */
    aplmodstate prev_state      = mdata->this_switch_state;
    mdata->this_switch_state    = state;
    pr_message("change arkamys module instance from  prev(%d) to new(%d)\n", prev_state, state);

    if(state == apl_state_running)
        (void)audproc_apl_lib_arkamys_aivi_imx_handler_start();
    else if(state == apl_state_stop)
        (void)audproc_apl_lib_arkamys_aivi_imx_handler_stop(mdata->ArkProcessCallCount);
    else
    {
        /* do nohing */
    }
    /* protection section */


    return APL_ERR_OK;
}

LOCAL aplmodstate  apl_arkamys_get_mod_state(mydata* mdata)
{

    pr_debug("ENTERED\n");

    if(!mdata)
    {
        pr_debug("module data pointer is NULL\n");
        return apl_state_undefined;
    }

    /* protection section : todo  */
    aplmodstate curr_state = mdata->this_switch_state;
    pr_debug("current arkamys module instance state(%d)\n", curr_state);
    /* protection section */


    return curr_state;
}



LOCAL   APL_STATUS apl_arkamys_request_set_req_type_initialize
(
    tAplInt     iDataID,
    const void* data,
    tAplU32     ulSize,
    ReqItem*    pp
)
{

    pr_message("initialize a SET_REQ request object for parameter -> %d \n", iDataID);

    if(!pp)
        return APL_ERR_NULL_POINTER;

    pp->ReqType             = REQ_TYPE_SET_REQ;
    pp->RequestedParameter  = (tAplU32)iDataID;
    pp->pparam              = apl_arkamys_get_ark_param_cfg(iDataID);


    pp->data = g_malloc0(ulSize * sizeof(tAplU8));
    if(pp->data && data )
    {
        memcpy(pp->data, data , ulSize);
    }
    return APL_ERR_OK;
}


LOCAL   APL_STATUS apl_arkamys_request_flush_cmd_req_type_initialize
(
    ReqItem*    pp
)
{

    pr_message("initialize a CMD_FLUSH request object\n");

    if(!pp)
        return APL_ERR_NULL_POINTER;

    pp->ReqType             = REQ_TYPE_CMD_FLUSH;
    pp->RequestedParameter  = 0;
    pp->pparam              = NULL;


    return APL_ERR_OK;
}

LOCAL   APL_STATUS apl_arkamys_request_read_data_req_type_initialize
(
    tAplInt     iDataID,
    const void* data,
    tAplU32     ulSize,
    ReqItem*    pp
)
{
    pr_message("initialize a READ_DATA_REQ request object for parameter -> %d \n", iDataID);

    if(!pp)
        return APL_ERR_NULL_POINTER;

    pp->ReqType             = REQ_TYPE_READ_DATA_REQ;
    pp->RequestedParameter  = (tAplU32)iDataID;
    pp->pparam              = apl_arkamys_get_ark_param_cfg(iDataID);

    if(pp->pparam)
        pp->pparam->size    = ulSize;

    if(!data)
    {
        pr_warning("invalid data frame\n");
        return APL_ERR_NULL_POINTER;
    }

    pp->data = g_malloc0(ulSize * sizeof(tAplU8));
    if(pp->data && data)
    {
        pr_debug("setup data container and copy data frame\n");
        memcpy(pp->data, data , ulSize);
    }
    return APL_ERR_OK;
}

LOCAL   APL_STATUS apl_arkamys_request_write_data_req_type_initialize
(
    tAplInt     iDataID,
    const void* data,
    tAplU32     ulSize,
    ReqItem*    pp
)
{
    pr_message("initialize a WRITE_DATA_REQ request object for parameter -> %d \n", iDataID);

    if(!pp)
        return APL_ERR_NULL_POINTER;

    pp->ReqType             = REQ_TYPE_SET_REQ;
    pp->RequestedParameter  = (tAplU32)iDataID;
    pp->pparam              = apl_arkamys_get_ark_param_cfg(iDataID);

    if(pp->pparam)
        pp->pparam->size    = ulSize;

    pp->data = g_malloc0(ulSize * sizeof(tAplU8));
    if(pp->data && data)
        memcpy(pp->data, data , ulSize);

    return APL_ERR_OK;
}

LOCAL   APL_STATUS apl_arkamys_request_eol_data_req_type_initialize
(
    tAplInt     iDataID,
    const void* data,
    tAplU32     ulSize,
    ReqItem*    pp
)
{
    pr_message("initialize a EOL_DATA_REQ request object for parameter -> %d \n", iDataID);

    if(!pp)
        return APL_ERR_NULL_POINTER;

    pp->ReqType             = REQ_TYPE_SET_REQ;
    pp->RequestedParameter  = (tAplU32)iDataID;
    pp->pparam              = apl_arkamys_get_ark_param_cfg(iDataID);

    if(pp->pparam)
        pp->pparam->size    = ulSize;

    pp->data = g_malloc0(ulSize * sizeof(tAplU8));
    if(pp->data && data)
        memcpy(pp->data, data , ulSize);

    return APL_ERR_OK;
}

LOCAL   APL_STATUS apl_arkamys_request_get_result_type_initialize
(
    tAplInt     iDataID,
    void*       data,
    tAplU32     ulSize,
    ReqItem*    pp
)
{
    pr_message("initialize a GET_RESULT_REQ request object for parameter -> %d \n", iDataID);

    if(!pp)
        return APL_ERR_NULL_POINTER;

    pp->ReqType             = REQ_TYPE_GET_RESULT;
    pp->RequestedParameter  = (tAplU32)iDataID;
    pp->pparam              = apl_arkamys_get_ark_param_cfg(iDataID);
    pp->pparam->size        = ulSize;
    pp->data                = g_malloc0(ulSize * sizeof(tAplU8));

    if(pp->data && data)
        memcpy(pp->data, data , ulSize);

    return APL_ERR_OK;
}

LOCAL   APL_STATUS apl_arkamys_request_get_req_type_initialize
(
    tAplInt     iDataID,
    ReqItem*    pp
)
{
    pr_message("initialize a GET_REQ request object for parameter -> %d \n", iDataID);

    if(!pp)
        return APL_ERR_NULL_POINTER;

    pp->ReqType             = REQ_TYPE_GET_REQ;
    pp->RequestedParameter  = (tAplU32)iDataID;
    pp->pparam              = apl_arkamys_get_ark_param_cfg(iDataID);

    return APL_ERR_OK;
}

/*******************************************************************************
*
* FUNCTION: apl_arkamys_add_notification
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL APL_STATUS apl_arkamys_add_notification
(
    mydata*     mdata,
    tAplInt     iDataID,
    tAplAction  aplAct
)
{
    pr_debug("ENTERED\n");

    if(!mdata)
    {
        pr_debug("apl instance structure not available \n");
        return APL_ERR_NULL_POINTER;
    }


    if(!mdata->NotifyTbl.NotList)
        return APL_ERR_NULL_POINTER;

    if((mdata->NotifyTbl.NotCnt + 1) == D_MAX_ARK_NOTIFY_CNT)
    {
        pr_debug("max number of pending notification is reached\n");
        return APL_ERR_OK;
    }

    tAplU8 NotificationCnt = mdata->NotifyTbl.NotCnt;

    mdata->NotifyTbl.NotList[NotificationCnt].NotifyParameter = (tAplU32)iDataID;
    mdata->NotifyTbl.NotList[NotificationCnt].ActType = aplAct ;

    mdata->NotifyTbl.NotCnt++;

   /* add new notification */
    pr_message("add new notification for parameter(%d) with requested action(%d), current notification count(%d)\n", iDataID, aplAct,mdata->NotifyTbl.NotCnt );

    return APL_ERR_OK;
}




LOCAL inline APL_STATUS  apl_arkamys_request_add_new(mydata* mdata, ReqItem* Req)
{

    if(!Req || !mdata)
    {
        pr_warning("input parameter are invalid\n");
        return APL_ERR_NULL_POINTER;
    }
    if(mdata->SetGetReqList.ReqCnt == D_MAX_ARK_PARAM_CNT)
  {
        pr_warning("request list full \n");
    return APL_ERR_PARAM_CNT;
  }

    pr_debug("ENTERED with current req count -> %d \n", mdata->SetGetReqList.ReqCnt);

    ReqItem* p = (ReqItem*)NULL;
    int i = 0;


    /* search a free request position in the queue*/
    for(p = &mdata->SetGetReqList.ReqList[0]; i < D_MAX_ARK_PARAM_CNT; p++, i++)
    {
        if(p->ReqType == REQ_TYPE_UNDEF)
        {
            pr_debug("found a free position at index -> %d\n", i);

            /* fill request item instance*/
            p->RequestedParameter  = Req->RequestedParameter;
            p->ReqType             = Req->ReqType;
            p->pparam              = Req->pparam;

            pr_debug("parameter struct: aplparameter->%d \n", p->pparam->aplparameter);
            pr_debug("parameter struct: arkblockid->%d \n", p->pparam->arkblockid);
            pr_debug("parameter struct: arkparamid->%d \n", p->pparam->arkparamid);
            pr_debug("parameter struct: size->%d \n", p->pparam->size);
            pr_debug("parameter struct: aplparamtype->%d \n", p->pparam->aplparamtype);


            if(Req->data)
            {
                if(!p->pparam)
                {
                    pr_warning("no valid parameter structure\n");

          /*release list item */
          p->ReqType = REQ_TYPE_UNDEF;
          p->RequestedParameter = 0;
          p->pparam = (ArkParamList* )NULL;

                    return APL_ERR_NULL_POINTER;
                }

                pr_debug("size of the paramter -> %d \n", p->pparam->size);
                p->data = g_malloc0(p->pparam->size * sizeof(tAplU8));
                if(p->data)
                    memcpy(p->data, Req->data , p->pparam->size);
            }

            /* add new pending request  */
            mdata->SetGetReqList.ReqCnt++;
            pr_message("add new request type(%d) for parameter(%d) in request list, new request count(%d) \n", Req->ReqType, Req->RequestedParameter, mdata->SetGetReqList.ReqCnt);

            break;
        }
    }
    return APL_ERR_OK;
}


LOCAL inline APL_STATUS  apl_arkamys_request_delete_all(mydata* mdata)
{

    if(!mdata)
    {
        pr_warning("input parameter are invalid\n");
        return APL_ERR_NULL_POINTER;
    }
    if(mdata->SetGetReqList.ReqCnt == D_MAX_ARK_PARAM_CNT)
  {
        pr_warning("request list full \n");
    return APL_ERR_PARAM_CNT;
  }

    pr_message("ENTERED with current req count -> %d \n", mdata->SetGetReqList.ReqCnt);

    ReqItem* p = (ReqItem*)NULL;
    int i = 0;


    /* search a free request position in the queue*/
    for(p = &mdata->SetGetReqList.ReqList[0]; i < D_MAX_ARK_PARAM_CNT; p++, i++)
    {
    /*release list item */
    p->ReqType = REQ_TYPE_UNDEF;
    p->RequestedParameter = 0;
    p->pparam = (ArkParamList* )NULL;

    if(p->data)
    {
      g_free(p->data);
            p->data = NULL;
        }

    }

  mdata->SetGetReqList.ReqCnt = 0;

  pr_message("EXIT \n");

    return APL_ERR_OK;
}

/*******************************************************************************
*
* FUNCTION: apl_arkamys_audiolevelloss
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL APL_STATUS apl_arkamys_audiolevelloss(mydata* mdata, tAplBool DoNotify)
{
    APL_STATUS      status  = APL_ERR_OK;
    ReqItem*        newReq = (ReqItem*)NULL;

    pr_message("ENTERED\n");


    if(!mdata)
    {
        pr_debug("apl instance structure not available \n");
        return APL_ERR_NULL_POINTER;
    }

    ArkParamList* p =  apl_arkamys_get_ark_param_cfg(aplArkamysLevelLoss);
    if(p)
    {
        /* get current level loss value */
        if(p->aplparamtype == APL_PARAM_VARIABLE)
        {
            apl_arkamys_request_new(newReq);
            status = apl_arkamys_request_get_result_type_initialize(aplArkamysLevelLoss, (void*)NULL, p->size, newReq);
            if(!status)
                status = audproc_apl_lib_arkamys_aivi_imx_handler_Get( (int)p->arkblockid, (int)p->arkparamid,(int)p->size, (unsigned char*)newReq->data);

            if(!status)
                status = apl_arkamys_request_add_new(mdata, newReq);
            apl_arkamys_request_delete(newReq);
        }
        if(!DoNotify)
        {
            pr_debug("leave w/0 notification\n");
            return APL_ERR_OK;
        }
        /* the parameter has to be updated by client */
        if(status == ARKAMYS_NO_ERROR)
        {
            pr_message("notify property by application\n");
            status = apl_arkamys_add_notification(mdata, aplArkamysLevelLoss, APL_ACT_GET_PARAM);
        }
    }
    else
    {
        pr_warning("parameter(%d) not defined\n", aplArkamysLevelLoss);
        status = APL_ERR_INVALID_PARAM_ID;
    }
    return status;
}

/*******************************************************************************
*
* FUNCTION: apl_arkamys_request_execute

*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL APL_STATUS  apl_arkamys_request_execute(mydata* mdata, ReqItem* req, tAplU16 req_mask)
{
    APL_STATUS     err = APL_ERR_OK;
    tAplBool       DoNotify = aplFALSE;
    ReqItem*       newReq = (ReqItem*)NULL;

    pr_message("ENTERED\n");

    if(!mdata)
    {
        pr_debug("apl instance structure not available \n");
        return APL_ERR_NULL_POINTER;
    }
    if(!req)
    {
        pr_warning("request not valid\n");
        return APL_ERR_NULL_POINTER;
    }

    if(!(req_mask & req->ReqType))
    {
        pr_message("ReqType -> %d not included in the request mask -> %d \n", req->ReqType, req_mask);
        return APL_ERR_INVALID_REQ_MASK;
    }

    pr_message("proceed to new request for property -> %d from type -> %d\n", req->RequestedParameter, req->ReqType);

    if(req->ReqType == REQ_TYPE_CMD_FLUSH)
    {
        pr_message("call flush\n");

        err = audproc_apl_lib_arkamys_aivi_imx_handler_Flush();
    err = apl_arkamys_add_notification(mdata, aplArkamysFlush, APL_ACT_SYNC_PARAM);

        return err;
    }
    if(!req->RequestedParameter)
    {
        pr_warning("request not valid\n");
        return APL_ERR_OK;
    }

    if(mdata->this_switch_state == apl_state_running)
        DoNotify = aplTRUE;

    ArkParamList* p =  apl_arkamys_get_ark_param_cfg((tAplI32)req->RequestedParameter);
    if(p)
    {
        tAplU32         arkblockid;
        tAplU32         arkparamid;
        unsigned char*  data;
        tAplI32         arkparamsize;
        tAplU8          nbwrtcmd;

        if(req->ReqType == REQ_TYPE_SET_REQ)
        {
            if(req->RequestedParameter == aplArkamysSetData)
            {
                /* data field in the tuning communication protocol version 1.04
                 * ---------------------------------------------------------------------------------------
                 * | BlockId : 4 Bytes | ParameterId : 4 Bytes : Data Length : 4 Bytes | data : n Bytes  |
                 * ---------------------------------------------------------------------------------------
                 */

                if(p->size < D_ARKAMYS_WRITE_FRAME_SIZE_MIN)
                {
                    pr_warning("write frame size(%d) should be bigger as %d\n", p->size, D_ARKAMYS_WRITE_FRAME_SIZE_MIN );
                    return APL_ERR_SIZE_ONLY;
                }

                unsigned char* data_in = (unsigned char*)req->data;

                if(!data_in)
                {
                    pr_warning("data container pointer is NULL\n");
                    return APL_ERR_NULL_POINTER;
                }

                memcpy((void*)&arkblockid,  (void*)data_in, 4);
                memcpy((void*)&arkparamid,  (void*)&data_in[4], 4);
                memcpy((void*)&arkparamsize,        (void*)&data_in[8], 4);
                data = &data_in[12];

                err = audproc_apl_lib_arkamys_aivi_imx_handler_Set((int)arkblockid,(int)arkparamid,arkparamsize, data);
                if(err)
                {
                    /* failure with respect to arkamys call */
                    pr_warning("err with respect to ArkamysAiviImxSet call err:%d\n", err);
                    mdata->last_error = err;
                    p->size = 0;
                }

                /* add notification */
                if(!err)
                    (void)apl_arkamys_audiolevelloss(mdata, DoNotify);

                /* send notification to calling thread whatever err during call or not */
                (void)apl_arkamys_add_notification(mdata, aplArkamysSetData, APL_ACT_SYNC_PARAM);
            }
            /* new */
            else if(req->RequestedParameter == aplArkamysWriteMultiFrame)
            {
                /* data field in the tuning communication protocol version 1.15
                 * -> complet data field pass through the application
                 * ------------------------------------------------------
                 * | Nb write command: 1 Bytes | N * command data fiedl |
                 * ------------------------------------------------------
                 * --> Single command data field
                 * ---------------------------------------------------------------------------------------
                 * | BlockId : 4 Bytes | ParameterId : 4 Bytes : Data Length : 4 Bytes | data : n Bytes  |
                 * ---------------------------------------------------------------------------------------
                 */

                if(p->size < D_ARKAMYS_WRITE_FRAME_SIZE_MIN)
                {
                    pr_warning("write frame size(%d) should be bigger as %d\n", p->size, D_ARKAMYS_WRITE_FRAME_SIZE_MIN );
                    return APL_ERR_SIZE_ONLY;
                }

                unsigned char* data_in = (unsigned char*)req->data;

                if(!data_in)
                {
                    pr_warning("data container pointer is NULL\n");
                    return APL_ERR_NULL_POINTER;
                }

                /* retrieve number of command to write */
                memcpy((void*)&nbwrtcmd,  (void*)data_in, 1);

                if(!nbwrtcmd)
                {
                    pr_warning("data container pointer is NULL\n");
                    return APL_ERR_MODULE_ARKAMYS_INVALID_WRT_CMD_NB;
                }

                unsigned int idx_cmd = 1;
                arkparamsize = 0;

                while(nbwrtcmd)
                {

                    /* out of array check */
                    pr_debug("next command frame -> %d, position -> %u , max size -> %d \n", nbwrtcmd, idx_cmd, p->size);

                    APL_ARK_INC_AND_CHECK_PTR(idx_cmd, ARK_PARAM_CMD_COUNT, p->size );
                    memcpy((void*)&arkblockid,  (void*)&data_in[idx_cmd], ARK_PARAM_SIZE_BLOCK_ID);
                    APL_ARK_INC_AND_CHECK_PTR(idx_cmd, ARK_PARAM_SIZE_BLOCK_ID,  p->size );
                    memcpy((void*)&arkparamid,  (void*)&data_in[idx_cmd], ARK_PARAM_SIZE_PARAM_ID);
                    APL_ARK_INC_AND_CHECK_PTR(idx_cmd, ARK_PARAM_SIZE_PARAM_ID, p->size );
                    memcpy((void*)&arkparamsize,        (void*)&data_in[idx_cmd], ARK_PARAM_SIZE_SIZE_PARAM);
                    APL_ARK_INC_AND_CHECK_PTR(idx_cmd, ARK_PARAM_SIZE_SIZE_PARAM, p->size );
                    data = &data_in[idx_cmd];
                    APL_ARK_INC_AND_CHECK_PTR(idx_cmd, (guint)arkparamsize , p->size );

                    err = audproc_apl_lib_arkamys_aivi_imx_handler_Set( (int)arkblockid, (int)arkparamid,  arkparamsize, data);
                    if(err)
                    {
                        /* the execution of the arkamys set function has failed */
                        pr_warning("err with respect to ArkamysAiviImxSet call err:%d\n", err);
                        mdata->last_error = err;
                        p->size = 0;

                        break; /* terminate the while loop */
                    }

                    nbwrtcmd--;
                }


                /* send notification to calling thread whatever err during call or not */
                (void)apl_arkamys_add_notification(mdata, aplArkamysWriteMultiFrame, APL_ACT_SYNC_PARAM);
            }

            else
            {
                arkblockid      = p->arkblockid;
                arkparamid      = p->arkparamid;
                arkparamsize    = (tAplI32)p->size;


                /* consider special case of the ambiance where translation to preset values is required*/
                if(req->RequestedParameter == aplArkamysAmbienceSelect)
                {
                    tAplU8 value;
                    memcpy((void*)&value, req->data, 1);

                    if(value > AUDPROC_FI_AMBIENCE_MAX)
                    {
                        pr_warning("ambience selection:%d out of range\n", value);
                        return APL_ERR_ILLEGAL_SET_PARAM;
                    }
                    tAplU8 preset = apl_arkamys_get_preset(value);
                    err = audproc_apl_lib_arkamys_aivi_imx_handler_Set(ARK_BLOCK_ID_AMBIENCE, ARK_PARAM_ID_AMBIENCE, ARK_PARAM_SIZE_AMBIENCE,(unsigned char*)&preset);
                }
                else if(req->RequestedParameter == aplArkamysAvcActivate) /* ticket NCG3D-119120 */
                {
                    tAplU32 value, _data;
                    memcpy((void*)&value, req->data, 4);

                    pr_message("aplArkamysAvcActivate -> %d \n", value);
                    if(value) /*AGC enable */
                    {
                        _data = (tAplU32)ARK_AVC_ENABLE;
                        pr_message("set ARK_AVC_ENABLE -> %d \n", _data);
                    }
                    else /*AGC disable */
                    {
                        _data = (tAplU32)ARK_AVC_DISABLE;
                        pr_message("set ARK_AVC_DISABLE -> %d \n", _data);
                    }
                    err = audproc_apl_lib_arkamys_aivi_imx_handler_Set((int)arkblockid, (int)arkparamid,  arkparamsize, (unsigned char*)&_data);
                }
                else
                {
                    err = audproc_apl_lib_arkamys_aivi_imx_handler_Set((int)arkblockid, (int)arkparamid,  arkparamsize, (unsigned char*)req->data);
                }

                /* after eol data are loaded, the leveloss is recalculated to notify to client applciation  */
                if(!err && (req->RequestedParameter == aplArkamysEolData))
                {
                    (void)apl_arkamys_audiolevelloss(mdata, aplTRUE);

                    if(module_data_inst)
                        module_data_inst->ark_lib_state = apl_state_eol_loaded;
                }

            }

        }
        else if(req->ReqType == REQ_TYPE_GET_REQ)
        {
            apl_arkamys_request_new(newReq);

            arkblockid      = p->arkblockid;
            arkparamid      = p->arkparamid;
            arkparamsize    = (tAplI32)p->size;
            if(req->RequestedParameter == aplArkamysAmbienceSelect)
            {
                unsigned char adata;
                err = audproc_apl_lib_arkamys_aivi_imx_handler_Get(ARK_BLOCK_ID_AMBIENCE, ARK_PARAM_ID_AMBIENCE, ARK_PARAM_SIZE_AMBIENCE, &adata);

                /* convert to ambience select */
                if(!err)
                {
                    tAplI32 value = apl_arkamys_get_ambience(adata);
                    if(value == AUDPROC_FI_AMBIENCE_MAX)
                        err = APL_ERR_ILLEGAL_SET_PARAM;

                    if(!err)
                    {
                        pr_debug("stores ambience current setting:%d\n", value);
                        (void)apl_arkamys_request_get_result_type_initialize(aplArkamysAmbienceSelect, (void*)&value, (tAplU32)arkparamsize, newReq);
                        (void)apl_arkamys_request_add_new(mdata, newReq);
                    }
                }
            }
            else
            {
                err = apl_arkamys_request_get_result_type_initialize((tAplInt)req->RequestedParameter, (void*)NULL, (tAplU32)arkparamsize, newReq);
                if(!err)
                    err = audproc_apl_lib_arkamys_aivi_imx_handler_Get((int)arkblockid, (int)arkparamid,  arkparamsize, (unsigned char*)newReq->data);
                if(!err)
                    err = apl_arkamys_request_add_new(mdata, newReq);
            }

            /* add notification */
            if(DoNotify)
            {
                err = apl_arkamys_add_notification(mdata, (tAplInt)req->RequestedParameter, APL_ACT_SYNC_PARAM);
            }
            apl_arkamys_request_delete(newReq);
        }
        else if(req->ReqType == REQ_TYPE_READ_DATA_REQ)
        {
            if(req->RequestedParameter == aplArkamysReadData)
            {

                apl_arkamys_request_new(newReq);

                /* data field in the tuning communication protocol version 1.04
                 * ---------------------------------------------------------------------
                 * | BlockId : 4 Bytes | ParameterId : 4 Bytes : Data Length : 4 Bytes |
                 * ---------------------------------------------------------------------
                 */

                if(p->size < D_ARKAMYS_READ_FRAME_SIZE_MIN)
                {
                    pr_warning("read frame size(%d) should be bigger as %d\n", p->size, D_ARKAMYS_WRITE_FRAME_SIZE_MIN);
                    return APL_ERR_SIZE_ONLY;
                }

                unsigned char* data_in = (unsigned char*)req->data;
                if(!data_in)
                {
                    pr_warning("data container pointer is NULL\n");
                    return APL_ERR_NULL_POINTER;
                }

                memcpy((void*)&arkblockid,  (void*)data_in, 4);
                memcpy((void*)&arkparamid,  (void*)&data_in[4], 4);
                memcpy((void*)&arkparamsize,(void*)&data_in[8], 4);

                err = apl_arkamys_request_get_result_type_initialize(aplArkamysReadData, (void*)NULL, (guint32)arkparamsize, newReq);

                if(!err)
                    err = audproc_apl_lib_arkamys_aivi_imx_handler_Get((int)arkblockid, (int)arkparamid,  arkparamsize, (unsigned char*)newReq->data);
                if(!err)
                    err = apl_arkamys_request_add_new(mdata, newReq);
                if(err)
                {
                    /* failure with respect to arkamys call */
                    pr_warning("err with respect to ArkamysAiviImxGet call err:%d\n", err);
                    mdata->last_error = err;
                    p->size = 0;
                }
                else
                {
          /* print data element only for debug purpose */
                    int j;
                    unsigned char* data_out = (unsigned char*)req->data;
                    for (j = 0; j < arkparamsize; j++)
                        pr_debug("read value for blockid:%d, paramid:%d, data[%d}: %d\n", arkblockid,arkparamid,j, data_out[j]);
        }

        /* always notify client */
        err = apl_arkamys_add_notification(mdata, aplArkamysReadData, APL_ACT_SYNC_PARAM);

                apl_arkamys_request_delete(newReq);
            }
        }
        else
        {
            /* do nothing */
        }

    }
    else
        pr_warning("the parameter %d is no configured \n", req->RequestedParameter);

    pr_message("EXIT\n");

    return err;
}




LOCAL inline tAplBool  apl_arkamys_request_copy_pending_result(mydata* mdata, tAplDataID paramid, void* dest, tAplU32* size)
{

    tAplBool avail = aplFALSE;


    pr_message("ENTER GET_RESULT request for the property -> %d \n", paramid);


    if(!mdata)
        return aplFALSE;

    if(!mdata->SetGetReqList.ReqCnt)
    {
        pr_message("no request available in the request list\n");
        return avail;
    }

    ReqItem* p = (ReqItem*)NULL;
    int i = 0;

    //ArkParamList* pp = apl_arkamys_get_ark_param_cfg(Req->RequestedParameter);

    /* serch free request position in the queue*/
    for(p = &mdata->SetGetReqList.ReqList[0]; i < D_MAX_ARK_PARAM_CNT; p++, i++)
    {
        if(    (p->ReqType == REQ_TYPE_GET_RESULT)
            && (p->RequestedParameter == paramid))
        {
            /* copy element */

            if(p->data)
      {
                memcpy(dest, p->data, p->pparam->size);
        *size = p->pparam->size;
        pr_message("return a result request type(%d) for parameter(%d) with size(%d) \n", REQ_TYPE_GET_RESULT, paramid, *size);
        pr_message("current request count -> %d \n", mdata->SetGetReqList.ReqCnt);
        avail = aplTRUE;
      }
      else
            {
                pr_warning("no result data available for the property -> paramid %d \n", paramid);
                //return APL_ERR_NULL_POINTER;
            }

            //*size = p->pparam->size;

            /* add new pending request  */
            mdata->SetGetReqList.ReqCnt--;

            //pr_message("return a result request type(%d) for parameter(%d) with size(%d) \n", REQ_TYPE_GET_RESULT, paramid, *size);
      //pr_message("current request count -> %d \n", mdata->SetGetReqList.ReqCnt);

            /* release request */
            apl_arkamys_request_remove(p);

            //avail = aplTRUE;

            break;
        }
    }

    if(!avail)
        pr_message("no GET_RESULT request available for the property -> %d \n", paramid);

    return avail;
}


LOCAL inline APL_STATUS  apl_arkamys_add_new_wait_request(mydata* mdata, ReqItem* Req)
{

    if(!Req || !mdata)
        return APL_ERR_NULL_POINTER;

    if(mdata->SetGetReqList.WaitReqCnt == D_MAX_ARK_PARAM_CNT)
        return APL_ERR_PARAM_CNT;

    /* add a new wait request always at the end of the list */
    ReqItem* p = &mdata->SetGetReqList.WaitReqList[mdata->SetGetReqList.WaitReqCnt];

    /* fill request item instance*/
    p->RequestedParameter  = Req->RequestedParameter;
    p->ReqType             = Req->ReqType;
    p->pparam              = Req->pparam;

    p->data = g_malloc0(p->pparam->size * sizeof(tAplU8));
    if(p->data)
    {
        pr_message("wait request data was copied\n");
        memcpy(p->data, Req->data , p->pparam->size);
    }

    /* add new pending request  */
    mdata->SetGetReqList.WaitReqCnt++;

    pr_message("add new request type(%d) for parameter(%d) in wait request list, new request count(%d) \n", Req->ReqType, Req->RequestedParameter, mdata->SetGetReqList.WaitReqCnt);


    return APL_ERR_OK;
}


LOCAL inline APL_STATUS  apl_arkamys_copy_wait_request(mydata* mdata)
{
    APL_STATUS     err = APL_ERR_OK;


    if(!mdata->SetGetReqList.WaitReqCnt)
        return APL_ERR_OK;


    pr_message("copy %d wait request in the working request list\n", mdata->SetGetReqList.WaitReqCnt);


    while(mdata->SetGetReqList.WaitReqCnt)
    {
        mdata->SetGetReqList.WaitReqCnt--;

        ReqItem* wReq = &mdata->SetGetReqList.WaitReqList[mdata->SetGetReqList.WaitReqCnt];

        err = apl_arkamys_request_add_new(mdata, wReq );
        if(err == APL_ERR_PARAM_CNT)
        {
            mdata->SetGetReqList.WaitReqCnt++;
            pr_message("exc request list full \n");
            break;
        }
    }

    return err;
}


/*******************************************************************************
*
* FUNCTION: apl_arkamys_request_append
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL APL_STATUS  apl_arkamys_request_append(mydata* mdata, ReqItem* Req)//, tAplBool IsSyncReq)
{
    APL_STATUS     err = APL_ERR_OK;

    pr_message("ENTERED\n");

    if(!mdata)
    {
        pr_warning("apl instance structure not available \n");
        return APL_ERR_NULL_POINTER;
    }

    if(!Req)
    {
        pr_warning("request not valid\n");
        return APL_ERR_NULL_POINTER;
    }

    if(lock_request_queue)
    {
        pr_message("the request queue is locked, save the new request in the wait list\n");

        err = apl_arkamys_add_new_wait_request(mdata, Req );

        return err;
    }

    if((mdata->SetGetReqList.ReqCnt+1) == D_MAX_ARK_PARAM_CNT)
    {
        pr_warning("max number of pending request is reached\n");
        return APL_ERR_OK;
    }

    if(mdata->SetGetReqList.ReqList)
    {
        //(void)apl_arkamys_lock_request_queue();

        /* first step : transfert all pending waiting request stored in the wait list to the working list*/
        err = apl_arkamys_copy_wait_request(mdata);

        /* now add the new request in the list */
        err = apl_arkamys_request_add_new(mdata, Req );
        if(err == APL_ERR_PARAM_CNT)
            pr_warning("max number of pending request is reached\n");


        //(void)apl_arkamys_unlock_request_queue();
    }
    else
        return APL_ERR_NULL_POINTER;


    return err;
}

/*******************************************************************************
*
* FUNCTION: apl_arkamys_set_property
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL   APL_STATUS   apl_arkamys_set_property
(
    void* data,
    tAplInt iDataID,
    tAplU32 ulSize,
    const void* pData
)
{
    tAplBool    IsNewReq         = aplTRUE;
    tAplBool    IsSyncReq        = aplFALSE;
    APL_STATUS  status           = APL_ERR_OK;
    ArkParamList* p              = (ArkParamList*)NULL;
    ReqItem     *pp        = (ReqItem*)NULL;


    pr_message("ENTERED\n");


    mydata* mdata = (mydata*)data;

    if(!mdata)
    {
        pr_warning(" NULL data pointer \n");
        return APL_ERR_NULL_POINTER;
    }

    if(!pData)
    {
        pr_warning("pData pointer is NULL \n");
        return APL_ERR_NULL_POINTER;
    }

    if(mdata->this_switch != aplArkamysSwitch)
        return APL_ERR_MODULE_NOT_INITIALIZED;


    if(iDataID == aplArkamysResetLastError)
    {
        mdata->last_error = APL_ERR_OK;
        return APL_ERR_OK;
    }

    p =  apl_arkamys_get_ark_param_cfg(iDataID);
    if(!p)
    {
        pr_warning("the parameter %d is not configured \n", iDataID);
        return APL_ERR_INVALID_PARAM_ID;

    }

    /* property set can be done within the calling thread context*/
    if(mdata->this_switch_state != apl_state_running)
        IsSyncReq = aplTRUE;

     /*todo: set mutex */
    g_mutex_lock(&mdata->lock);

    apl_arkamys_request_new(pp);

    switch(iDataID)
    {
        case aplArkamysSwitch:
            memcpy((void*)&(mdata->mparam_aplArkamysSwitch), pData , ulSize);
            break;
        case aplArkamysEolData:
        {
            status = apl_arkamys_request_eol_data_req_type_initialize(iDataID, pData, ulSize, pp);
            break;
        }
        case aplArkamysSetData:
        case aplArkamysWriteMultiFrame:
        {
            status = apl_arkamys_request_write_data_req_type_initialize(iDataID, pData, ulSize, pp);
            break;
        }
        case aplArkamysReadData:
        {
            status = apl_arkamys_request_read_data_req_type_initialize(iDataID, pData, ulSize, pp);
            break;
        }
        case aplArkamysByPassActivate:
        case aplArkamysAvcActivate:
        case aplArkamysAmbienceSelect:
        case aplArkamysInputLevelDeviation:
        case aplArkamysCurrentSpeed:
        case aplArkamysCurrentVolumeStep:
        case aplArkamysCurrVolAttenuation:
#ifdef D_AUDPROC_TEST_ARKAMYS  // only for testing because ther are not get properties as per arkamys spec.
        case aplArkamysLevelLoss:
        case aplArkamysLibraryVersion:
#endif
        {
            if(ulSize != p->size)
            {
                pr_warning("the requested size(%d) of the parameter(%d) is not matching with the configured size(%d) \n", ulSize, iDataID, p->size );
                g_mutex_unlock(&mdata->lock);
                return  APL_ERR_PARAM_SIZE;
            }

            status = apl_arkamys_request_set_req_type_initialize(iDataID, pData, ulSize, pp);

            break;
        }
        default:
            IsNewReq = aplFALSE;
            break;
    }


    /* new request */
    if(IsNewReq && !status)
    {
        if(IsSyncReq)
        {
            status = apl_arkamys_request_execute(mdata, pp, (REQ_TYPE_SET_REQ | REQ_TYPE_READ_DATA_REQ));
        }
        else
            (void)apl_arkamys_request_append(mdata, pp);
    }

    apl_arkamys_request_delete(pp);

    g_mutex_unlock(&mdata->lock);

    pr_debug("EXIT\n");

    return status;
}



/*******************************************************************************
*
* FUNCTION: apl_arkamys_request_async_iter
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL APL_STATUS  apl_arkamys_request_async_iter(mydata* mdata)
{
    APL_STATUS     err = APL_ERR_OK;

    if(!mdata)
    {
        pr_warning("apl instance structure not available \n");
        return APL_ERR_NULL_POINTER;
    }

    if(lock_request_queue)
    {
        pr_message("the request queue is locked\n");
        return APL_ERR_OK;
    }

    if(!mdata->SetGetReqList.ReqCnt)
    {
        pr_debug_data("no new request\n");
        return APL_ERR_OK; // no request pending
    }

    if(mdata->SetGetReqList.ReqList)
    {
        unsigned int i=0;
        ReqItem* p = (ReqItem*)NULL;


        /* todo: set mutex */
        g_mutex_lock(&mdata->lock);
        //(void)apl_arkamys_lock_request_queue();

        /* first step : transfert all pending waiting request in the working list*/
        (void)apl_arkamys_copy_wait_request(mdata);

        pr_message("%d requests pending \n", mdata->SetGetReqList.ReqCnt);


    for(p = &mdata->SetGetReqList.ReqList[0]; i < D_MAX_ARK_PARAM_CNT; p++, i++)
    {
      if((p->ReqType == REQ_TYPE_UNDEF) || (p->ReqType == REQ_TYPE_GET_RESULT))
      {
        pr_debug("do not execute this req type -> %d \n", p->ReqType);
        continue;
      }

      err = apl_arkamys_request_execute(mdata, p, (REQ_TYPE_SET_REQ | REQ_TYPE_READ_DATA_REQ | REQ_TYPE_CMD_FLUSH | REQ_TYPE_GET_REQ ));
      if(err)
        pr_warning("the execution of the request from type(%d), leads to failure in the execution with err -> %d\n", p->ReqType, err );

      /* remove request from the list */
      apl_arkamys_request_remove(p);
      mdata->SetGetReqList.ReqCnt--;

      pr_message("current pending request count -> %d \n", mdata->SetGetReqList.ReqCnt);

      /* no request pending, break iteration  */
      if(!mdata->SetGetReqList.ReqCnt)
        break;
    }

        g_mutex_unlock(&mdata->lock);
       //(void)apl_arkamys_unlock_request_queue();

    }
    else
        return APL_ERR_NULL_POINTER;


    return APL_ERR_OK;
}





/*******************************************************************************
*
* FUNCTION: apl_arkamys_prepare
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL APL_STATUS apl_arkamys_prepare(void*  data, void* mdata)//,  const tAplCfg* paplCfg)
{
    unsigned int   i;
    APL_STATUS     err = APL_ERR_OK;

    pr_debug("ENTERED\n");

    struct aplMainStruct*   aplh = (struct aplMainStruct*)data;

    if(!aplh)
    {
        pr_debug("apl instance structure not available \n");
        return APL_ERR_NULL_POINTER;
    }

    if(!module_data_inst)
    {
        pr_debug("no arkamys module instance available \n");
        return APL_ERR_NULL_POINTER;
    }

    if(!module_data_inst->buf_desc)
    {
        pr_debug(" module stream buffer descriptor not available \n");
        return APL_ERR_NULL_POINTER;
    }

    /* configuration data buffer available, copy a reference */
    if(aplh->file.pData)
    {
        pr_debug(" copy reference configuration sdata buffer \n");
        module_data_inst->paplCfg = &aplh->file;
    }

    /* initialize arkamys intern data  */
    module_data_inst->mparam_aplFrameShiftIn        = aplh->par_aplFrameShiftIn;
    module_data_inst->mparam_aplSampleRateIn        = aplh->par_aplSampleRateIn;
    module_data_inst->mparam_aplChannelCntIn        = aplh->par_aplChannelCntIn;
    module_data_inst->mparam_aplAudioPcmFormatIn    = aplh->par_aplAudioPcmFormatIn;
    module_data_inst->mparam_aplFrameShiftOut       = aplh->par_aplFrameShiftOut;
    module_data_inst->mparam_aplSampleRateOut       = aplh->par_aplSampleRateOut;
    module_data_inst->mparam_aplChannelCntOut       = aplh->par_aplChannelCntOut;
    module_data_inst->mparam_aplAudioPcmFormatOut   = aplh->par_aplAudioPcmFormatOut;



    /* arkamys library specifical parameter   */


    /* initialize arkamys stream buffer */
    module_data_inst->buf_desc->apl_stream_nb_ch    = aplh->par_aplChannelCntOut;
    module_data_inst->buf_desc->apl_audio_format    = (snd_pcm_format_t)aplh->par_aplAudioPcmFormatOut;
    module_data_inst->buf_desc->apl_sample_rate     = aplh->par_aplSampleRateOut;
    module_data_inst->buf_desc->apl_period_size     = aplh->par_aplFrameShiftOut;

    /* init set parameter request list  */
    if(!module_data_inst->SetGetReqList.ReqList)
    {
       module_data_inst->SetGetReqList.ReqList = g_malloc0(D_MAX_ARK_PARAM_CNT * sizeof(ReqItem));
       module_data_inst->SetGetReqList.ReqCnt = 0;
    }
    /* init set parameter request list  */
    if(!module_data_inst->SetGetReqList.WaitReqList)
    {
       module_data_inst->SetGetReqList.WaitReqList = g_malloc0(D_MAX_ARK_PARAM_CNT * sizeof(ReqItem));
       module_data_inst->SetGetReqList.WaitReqCnt = 0;
    }

    /* init nitication table  */
    if(!module_data_inst->NotifyTbl.NotList)
    {
       module_data_inst->NotifyTbl.NotList = g_malloc0(D_MAX_ARK_NOTIFY_CNT * sizeof(NotifyItem));
       module_data_inst->NotifyTbl.NotCnt = 0;
    }

    /* create streaming buffer */
    if(create_own_stream_buffer)
    {
        if(!module_data_inst->buf_desc->apl_stream_nb_ch)
            return APL_ERR_INVALID_CHANNEL_NUMBER;

        for(i = 0; i < module_data_inst->buf_desc->apl_stream_nb_ch; i++)
        {
            if(module_data_inst->buf_desc->apl_audio_format == SND_PCM_FORMAT_S16_LE)
            {
                pr_debug("create s16 stream buffer[%d] with size(%d)\n", i, module_data_inst->buf_desc->apl_period_size);
                module_data_inst->buf_desc->s16audiosamples[i] = g_malloc0(module_data_inst->buf_desc->apl_period_size * sizeof(short));
            }
            else if(module_data_inst->buf_desc->apl_audio_format == SND_PCM_FORMAT_S32_LE)
            {
                pr_debug("create s32 stream buffer[%d] with size(%d)\n", i, module_data_inst->buf_desc->apl_period_size);
                module_data_inst->buf_desc->s32audiosamples[i] = g_malloc0(module_data_inst->buf_desc->apl_period_size * sizeof(long));
            }
            else
            {
                pr_debug("streaming format mismatch \n");
                return APL_ERR_AUDIO_STREAM_FORMAT_MISMATCH;
            }
        }
    }


    /* instance is now in prepare state  */
    module_data_inst->this_switch_state     = apl_state_prepared;
    module_data_inst->last_state            = apl_state_prepared;
    module_data_inst->ArkProcessCallCount   = 0;

    (void)mdata;
    return err;
}


/*******************************************************************************
*
* FUNCTION: apl_arkamys_command
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL APL_STATUS apl_arkamys_command(void* data, tAplCmd cmd)
{
    APL_STATUS      err         = APL_ERR_OK;
    tAplBool        IsSyncReq   = aplFALSE;
    tAplBool        IsNewReq    = aplFALSE;
    ReqItem         *req        = (ReqItem*)NULL;

    pr_debug("ENTERED\n");

    if(!data)
    {
        pr_debug("module data pointer is NULL\n");
        return APL_ERR_NULL_POINTER;
    }

    mydata* mdata = (mydata*)data;

    if(apl_state_running >= apl_arkamys_get_mod_state(mdata))
        IsSyncReq = aplTRUE;

    switch(cmd)
    {
        case aplCmdFlush:
        {
            /* first change state of this instance and prevent processing
             * todo: protection section (mutex) ?
             * flush in process thread if state is at least **running**
             * or synchroneously within this calling thread
             */
            apl_arkamys_request_new(req);
            err = apl_arkamys_request_flush_cmd_req_type_initialize(req);
            IsNewReq    = aplTRUE;
            break;
        }
        case aplCmdStartAudProc:
        {
            err = apl_arkamys_change_mod_state(mdata, apl_state_running);
            //(void)apl_internal_log_item(apl_log_arkamys_calls, "first call of ArkamysAiviImxProcess \n");
            break;
        }
        case aplCmdStopAudProc:
        {
            err = apl_arkamys_change_mod_state(mdata, apl_state_stop); //apl_state_running_nop);
           //(void)apl_internal_log_item(apl_log_arkamys_calls, "suspend call of ArkamysAiviImxProcess after %d trials \n", mdata->ArkProcessCallCount );
            mdata->ArkProcessCallCount = 0;
            break;
        }
        case aplCmdDeleteAllRequest:
        {
        apl_arkamys_request_delete_all(mdata);
            break;
        }

        default:
            break;
    }

    if(IsNewReq)
    {
        if(IsSyncReq)
            err = apl_arkamys_request_execute(mdata, req , REQ_TYPE_CMD_FLUSH );

        else
            (void)apl_arkamys_request_append(mdata, req);
    }

    apl_arkamys_request_delete(req);

    return err;
}

/*******************************************************************************
*
* FUNCTION: apl_arkamys_get_buffer
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL aplAudioSamples_desc* apl_arkamys_get_buffer(void* data)
{
    pr_debug_data("ENTERED\n");

    if(!data)
    {
        pr_warning("module data pointer is NULL\n");
        return (aplAudioSamples_desc*)NULL;
    }

    mydata* mdata = (mydata*)data;

    /* currently only one instance supported */
    if(mdata->this_switch != aplArkamysSwitch)
        return (aplAudioSamples_desc*)NULL;

    return mdata->buf_desc;
}
/*******************************************************************************
*
* FUNCTION: apl_arkamys_final
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL APL_STATUS apl_arkamys_finalize(void* data)
{
    unsigned int    i;
    ArkParamList   *p = (ArkParamList*)NULL;
    APL_STATUS       err = APL_ERR_OK;

    pr_message("ENTERED\n");

    if(!data)
    {
        pr_debug("module data pointer is NULL\n");
        return APL_ERR_MODULE_NOT_INITIALIZED;
    }

    mydata* mdata = (mydata*)data;

    if(mdata->buf_desc)
    {
        /* delete streaming buffer */
        if(create_own_stream_buffer)
        {
            for(i = 0; i < mdata->buf_desc->apl_stream_nb_ch; i++)
            {
                if(mdata->buf_desc->apl_audio_format == SND_PCM_FORMAT_S16_LE)
                {
                    short int* s16buf = mdata->buf_desc->s16audiosamples[i];
                    if(s16buf)
                    {
                        g_free(s16buf);
                        s16buf = (short int*)NULL;
                    }
                }
                else if(mdata->buf_desc->apl_audio_format == SND_PCM_FORMAT_S32_LE)
                {
                    long int* s32buf = mdata->buf_desc->s32audiosamples[i];
                    if(s32buf)
                    {
                        g_free(s32buf);
                        s32buf = (long int*)NULL;
                    }
                }
            }
        }
        g_free(mdata->buf_desc);
        mdata->buf_desc = NULL;
    }


     /* remove request table  */
    if(mdata->SetGetReqList.ReqList)
    {
        for(int i = 0; i < D_MAX_ARK_PARAM_CNT; i++ )
        {
            if(mdata->SetGetReqList.ReqList[i].data)
                g_free(mdata->SetGetReqList.ReqList[i].data);
            mdata->SetGetReqList.ReqList[i].data = NULL;
        }
        g_free(mdata->SetGetReqList.ReqList);
        mdata->SetGetReqList.ReqCnt = 0;
        mdata->SetGetReqList.ReqList = (ReqItem*)NULL;
    }

    if(mdata->SetGetReqList.WaitReqList)
    {
        for(int i = 0; i < D_MAX_ARK_PARAM_CNT; i++ )
        {
            if(mdata->SetGetReqList.WaitReqList[i].data)
                g_free(mdata->SetGetReqList.WaitReqList[i].data);
            mdata->SetGetReqList.WaitReqList[i].data = NULL;
        }
        g_free(mdata->SetGetReqList.WaitReqList);
        mdata->SetGetReqList.WaitReqCnt = 0;
        mdata->SetGetReqList.WaitReqList = (ReqItem*)NULL;
    }

    /* remove nitication table  */
    if(mdata->NotifyTbl.NotList)
    {
        g_free(mdata->NotifyTbl.NotList);
        mdata->NotifyTbl.NotCnt = 0;
        mdata->NotifyTbl.NotList = (NotifyItem*)NULL;
    }

    /* remove paramter container */
    for(i = 0, p = arkparamcfg;  i <  APL_ARKAMYS_PARAM_MAX ; i++, p++)
    {
        pr_debug("free structure parameter: %d\n",  p->aplparameter);
        if(p->data)
        {
            g_free(p->data);
            p->data = (void*)NULL;
        }
    }
    g_mutex_clear(&mdata->lock);

    err = audproc_apl_lib_arkamys_aivi_imx_handler_finalize();

    g_free(mdata);
    mdata = (mydata*)NULL;

    /**/
    module_data_inst = (mydata*)NULL;

    return err;
}

/*******************************************************************************
*
* FUNCTION: apl_arkamys_get_property
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL APL_STATUS   apl_arkamys_get_property
(
    void* data,
    tAplDataID iDataID,
    tAplU32* pulSize,
    void* pData
)
{
    APL_STATUS  status              = APL_ERR_OK;
    tAplBool    IsSyncReq           = aplFALSE;
    ArkParamList* p                 = (ArkParamList*)NULL;
    ReqItem     *pp                 = (ReqItem*)NULL;

    pr_message("ENTERED\n");

    if(!data)
        return APL_ERR_MODULE_NOT_INITIALIZED;

    if(!pulSize || !pData )
    {
        pr_warning("pData or pulSize pointer are NULL \n");
        return APL_ERR_NULL_POINTER;
    }

    mydata* mdata = (mydata*)data;

    if(mdata->this_switch != aplArkamysSwitch)
        return APL_ERR_MODULE_NOT_INITIALIZED;

    if(iDataID == aplArkamysGetLastError)
    {
        if(!mdata->last_error) /* no error */
        {
            *pulSize = 0;
        }
        else /* return last error */
        {
            *pulSize = 4;
            memcpy(pData, (void*)&mdata->last_error, 4);
        }

        return APL_ERR_OK;
    }
    else if(iDataID == aplArkamysSwitchState)
    {
        *pulSize = sizeof(tAplI32);
        memcpy(pData, (void*)&mdata->this_switch_state, *pulSize);
        return APL_ERR_OK;
    }
    else if(iDataID == aplArkamysLibraryState)
    {
        *pulSize = sizeof(tAplI32);
        memcpy(pData, (void*)&mdata->ark_lib_state, *pulSize);
        return APL_ERR_OK;
    }

    p =  apl_arkamys_get_ark_param_cfg(iDataID);
    if(!p)
    {
        pr_warning("the parameter %d is not configured \n", iDataID);
        return APL_ERR_INVALID_PARAM_ID;
    }

    /* parameter is coanstant, return init value */
    if(p->aplparamtype == APL_PARAM_CONSTANT)
    {
        if(p->data)
        {
            *pulSize = p->size;
            memcpy(pData, p->data, p->size);

            if(*pulSize <= 4)
            {
                int ivalue = 0;
                memcpy((void*)&ivalue, pData, *pulSize);
                pr_debug("return constant value(%d) from parameter(%d) with size(%d) \n", ivalue, iDataID, *pulSize);
            }
            else
                pr_debug("return constant parameter(%d) with size(%d)\n", iDataID, *pulSize);
        }
        return APL_ERR_OK;
    }

    /* property set can be done within the calling thread context*/
    if(mdata->this_switch_state != apl_state_running)
        IsSyncReq = aplTRUE;

    /*todo: set mutex */
    g_mutex_lock(&mdata->lock);

    /*check wether an value for the property is already available */
    if(apl_arkamys_request_copy_pending_result(mdata, iDataID, pData, pulSize))
    {
        pr_message("return get result for the property -> %d with size -> %d \n", iDataID, *pulSize);
        g_mutex_unlock(&mdata->lock);
        return APL_ERR_OK;
    }

    switch(iDataID)
    {
        case aplArkamysSwitch:
        {
            *pulSize = sizeof(tAplI32);
            memcpy(pData, (void*)&mdata->mparam_aplArkamysSwitch, *pulSize);
            break;
        }

#ifdef D_AUDPROC_TEST_ARKAMYS  // only for testing because ther are not get properties as per arkamys spec.
        case aplArkamysAvcActivate:
        case aplArkamysByPassActivate:
        case aplArkamysInputLevelDeviation:
        case aplArkamysCurrentSpeed:
        case aplArkamysCurrentVolumeStep:
        case aplArkamysAmbienceSelect:
        case aplArkamysCurrVolAttenuation:
#endif
        case aplArkamysLevelLoss:
        case aplArkamysLibraryVersion:
        {
            apl_arkamys_request_new(pp);

            status = apl_arkamys_request_get_req_type_initialize(iDataID, pp);
            if(status)
            {
                pr_warning("fails to initialize a GET request for the parameter -> %d\n", iDataID);
                g_mutex_unlock(&mdata->lock);
                return status;
            }
            if(IsSyncReq)
            {
                status = apl_arkamys_request_execute(mdata, pp , REQ_TYPE_GET_REQ);
                if(!status)
                {
                    if(apl_arkamys_request_copy_pending_result(mdata, iDataID, pData, pulSize))
                    {
                        pr_message("return get result for the property -> %d with size -> %d \n", iDataID, *pulSize);
                        apl_arkamys_request_delete(pp);
                        g_mutex_unlock(&mdata->lock);
                        return APL_ERR_OK;
                    }
                }
            }
            else// if(!p->data)
            {
                (void)apl_arkamys_request_append(mdata, pp);
                *pulSize = 0;
            }
            break;
        }
        default:
            break;
    }
    apl_arkamys_request_delete(pp);
    g_mutex_unlock(&mdata->lock);

    return status;
}


#if 0
LOCAL  APL_STATUS FlushAudioProcess
(
    int**          pOut,
    int            numberOfSamplesPerChannel
)
{
    unsigned int i ;
    long int*       s32obuf;


    //pr_message("ENTERED\n");

    if(!(*pOut))
    {
        pr_debug(" error NULL pointer output array buffer\n");
        return APL_ERR_NULL_POINTER;
    }

    if(!numberOfSamplesPerChannel)
    {
        pr_debug("error number sample(%d)\n", numberOfSamplesPerChannel);
        return APL_ERR_PARAM_SIZE;
    }

    unsigned int max_ch_cnt = 4;


    for( i = 0; i < max_ch_cnt ; i++)
    {

        s32obuf = (long int*)pOut[i];

        if(!s32obuf)
        {
            pr_debug("pointer of the out_stream_s32_buffer[%d]is NULL\n", i);
        }
        else
        {
            pr_debug("flush %d s32 sample in out_stream_s32_buffer[%d]\n", numberOfSamplesPerChannel, i);
            memset((void*)s32obuf, 0, (size_t)numberOfSamplesPerChannel * sizeof(long int));
        }
    }

    //pr_debug("EXIT\n");

    return APL_ERR_OK;
}
#endif

/*******************************************************************************
*
* FUNCTION: apl_arkamys_process
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL APL_STATUS apl_arkamys_process
(
    void* data,
    const aplAudioSamples_desc* inAudio
)
{
    APL_STATUS      status  = APL_ERR_OK;


    pr_debug_data("ENTERED\n");

    if(!data)
        return APL_ERR_MODULE_NOT_INITIALIZED;

    if(!inAudio)
    {
        pr_debug(" input buffer descriptor not available\n");
        return APL_ERR_NULL_POINTER;
    }

    module_desc*            this_module = (module_desc*)data;
    mydata*                 mdata = this_module->data;


    /*************************************
     * process audio with arkamys library
     */


    /*************************************
     * 1: set first parameter if any request pending
     */

    status = apl_arkamys_request_async_iter(mdata);


    /************************************
     * 2: process new audio frame
     */

    status = audproc_apl_lib_arkamys_aivi_imx_handler_ImxProcess((int**)inAudio->s32audiosamples, (int**)mdata->buf_desc->s32audiosamples, mdata->mparam_aplFrameShiftIn);
    mdata->ArkProcessCallCount++;

    if(mdata->this_switch_state == apl_state_running)
    {
        if(mdata->last_state != mdata->this_switch_state)
        {
            pr_message("call ArkamysAiviImxProcess() now, state change from %d to %d \n", mdata->last_state, mdata->this_switch_state);
            mdata->last_state = mdata->this_switch_state;

            //(void)audproc_apl_lib_arkamys_aivi_imx_handler_start();
        }
    }
    else
    {
        if(mdata->last_state != mdata->this_switch_state)
        {
            //pr_message("call FlushAudioProcess() now, state change from %d to %d \n", mdata->last_state, mdata->this_switch_state);
            mdata->last_state = mdata->this_switch_state;
            //(void)audproc_apl_lib_arkamys_aivi_imx_handler_stop(mdata->ArkProcessCallCount);
            mdata->ArkProcessCallCount = 0;
        }
    }

    return status;
}

/*******************************************************************************
*
* FUNCTION: apl_arkamys_process
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
LOCAL tAplBool apl_arkamys_notification
(
    void*       data,
    tAplInt*    piDataID,
    tAplAction* paplAct
)
{
    tAplBool isNotify = aplTRUE;

    pr_debug_data("ENTERED\n");

    if(!data)
        return aplFALSE;

    mydata* mdata = (mydata*)data;

    if(mdata->this_switch != aplArkamysSwitch)
        return aplFALSE;

    if(!mdata->NotifyTbl.NotCnt)
        return aplFALSE;

    mdata->NotifyTbl.NotCnt--;

    tAplU8 NotificationCnt = mdata->NotifyTbl.NotCnt;


    *piDataID = (tAplInt)mdata->NotifyTbl.NotList[NotificationCnt].NotifyParameter;
    *paplAct  = mdata->NotifyTbl.NotList[NotificationCnt].ActType;

    /* return notification */
    pr_message("pending notification for parameter(%d) with requested action(%d)\n", *piDataID, *paplAct);

    return isNotify;
}


/*******************************************************************************
*
* FUNCTION: apl_arkamys_initialize
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
EXPORT module_desc* apl_arkamys_initialize(void)
{
    pr_debug("ENTERED\n");

    module_desc*  this_modul_desc = g_malloc0(sizeof(module_desc));
    APL_STATUS    status = APL_ERR_OK ;

    if(!this_modul_desc)
    {
        pr_critical("fails while allocating memory for new module descriptor\n");
        return (module_desc*)NULL;
    }

    this_modul_desc->associated_switch          = aplArkamysSwitch;
    this_modul_desc->state                      = apl_state_setup;
    this_modul_desc->aplopmode                  = APL_OM_PROD_CONS;
    this_modul_desc->apl_module_command         = apl_arkamys_command;
    this_modul_desc->apl_module_prepare         = apl_arkamys_prepare;
    this_modul_desc->apl_module_process         = apl_arkamys_process;
    this_modul_desc->apl_module_finalize        = apl_arkamys_finalize;
    this_modul_desc->apl_module_get_buffer      = apl_arkamys_get_buffer;
    this_modul_desc->apl_module_get_property    = apl_arkamys_get_property;
    this_modul_desc->apl_module_set_property    = apl_arkamys_set_property;
    this_modul_desc->apl_module_notification    = apl_arkamys_notification;

    this_modul_desc->next        = (void*)NULL;
    this_modul_desc->prev        = (void*)NULL;

    module_data_inst = g_malloc0(sizeof(mydata));

    if(!module_data_inst)
    {
        pr_critical("fails while allocating memory for new buffer descriptor\n");
        return (module_desc*)NULL;
    }

    module_data_inst->this_switch = aplArkamysSwitch;
    module_data_inst->buf_desc = g_malloc0(sizeof(aplAudioSamples_desc));
    module_data_inst->last_error = APL_ERR_OK;
    module_data_inst->ark_lib_state = apl_state_undefined;
    create_own_stream_buffer = aplTRUE;

    /* setup stream audio buffer in buffer descriptor
     * not required in thsi module because not new audio data are processed
     * buffer pointer s16/s32audiosamplesinput hold a pointer of the input streaming buffer
     * so it can be return with the function call get_buffer()
     */

    g_mutex_init(&module_data_inst->lock);


    /* create arkamys library instance */
    status  = audproc_apl_lib_arkamys_aivi_imx_handler_init();
    if(status)
        pr_critical("failure while open arkamys library instance:(%d)\n", status);
    else
        module_data_inst->ark_lib_state = apl_state_initialized;

    /* initilialize constant parameter  */
    ArkParamList* p =  apl_arkamys_get_ark_param_cfg(aplArkamysLevelLoss);

    if(p->aplparamtype == APL_PARAM_CONSTANT)
    {
        if(!p->data)
        {
            p->data = g_malloc0(p->size * sizeof(tAplU8));

            /*initilialize aplArkamysLevelLoss */
            if(p->data)
            {
                memset(p->data,0,4);
                pr_debug(" create data container for parameter(%d) of size(%d)\n", aplArkamysLevelLoss, p->size );
            }

        }
    }

    /* print configuration table */
    apl_arkamys_print_ark_param_cfg();

    this_modul_desc->data = (void*)module_data_inst;


    return this_modul_desc;
}


/*******************************************************************************
*
* FUNCTION: apl_arkamys_is_inst_available
*
* DESCRIPTION: function to set extended data
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
EXPORT tAplBool apl_arkamys_is_inst_available(tAplI32 aplswitch)
{
    tAplBool status = aplFALSE;

    pr_debug("ENTERED\n");

    if(!module_data_inst)
        return status;

    if(module_data_inst->this_switch == aplswitch)
    {
        pr_debug(" the module arkamys is available for switch: %d\n", aplswitch);
        status = aplTRUE;
    }
    return status;
}
