
#include "apl.h"
#include <stdio.h>


#ifndef __APL_MAIN_H__
#define __APL_MAIN_H__


#define LOG_LVL_PER_ENV
#define LOG_REDIREC_TO_TTFIS
#define D_TRACE_BUF_SIZE 300


#ifdef LOG_LVL_PER_ENV

extern int       log_level;
extern char     trace_buf[D_TRACE_BUF_SIZE];
extern tAplStCfg*  m_AplLib;
extern tAplBool    log_journal_enable;

#ifdef LOG_REDIREC_TO_TTFIS

#define pr_debug(fmtstr, args...){\
        if(log_level >= 2)\
        {\
            struct timespec ts;\
            clock_gettime(CLOCK_MONOTONIC, &ts);\
            if(m_AplLib)\
            {\
                if(m_AplLib->AplTracecb)\
                {\
                    memset(trace_buf,0,D_TRACE_BUF_SIZE);\
                    sprintf(trace_buf,"APL_DBG_TIME [%05u,%lu]:%s: " fmtstr, (unsigned int)ts.tv_sec, (unsigned long int)ts.tv_nsec, __FUNCTION__, ##args);\
                    m_AplLib->AplTracecb((tAplU8)log_level, trace_buf); \
                }\
            }\
      if(log_journal_enable)\
        g_print("APL_DBG_TIME [%05u,%lu]:%s: " fmtstr, (unsigned int)ts.tv_sec, (unsigned long int)ts.tv_nsec, __FUNCTION__, ##args);\
    }}\


#define pr_debug_data(fmtstr, args...){\
        if(log_level >= 3)\
        {\
            struct timespec ts;\
            clock_gettime(CLOCK_MONOTONIC, &ts);\
            if(m_AplLib)\
            {\
                if(m_AplLib->AplTracecb)\
                {\
                    memset(trace_buf,0,D_TRACE_BUF_SIZE);\
                    sprintf(trace_buf,"APL_DBG_DATA_TIME [%05u,%lu]:%s: " fmtstr, (unsigned int)ts.tv_sec, (unsigned long int)ts.tv_nsec, __FUNCTION__, ##args);\
                    m_AplLib->AplTracecb((tAplU8)log_level, trace_buf); \
                }\
            }\
      if(log_journal_enable)\
        g_print("APL_DBG_DATA_TIME [%05u,%lu]:%s: " fmtstr, (unsigned int)ts.tv_sec, (unsigned long int)ts.tv_nsec, __FUNCTION__, ##args);\
    }}\


#define pr_message(fmtstr, args...){\
        if(log_level >= 1)\
        {\
            struct timespec ts;\
            clock_gettime(CLOCK_MONOTONIC, &ts);\
            if(m_AplLib)\
            {\
                if(m_AplLib->AplTracecb)\
                {\
                    memset(trace_buf,0,D_TRACE_BUF_SIZE);\
                    sprintf(trace_buf,"APL_MSG_TIME [%05u,%lu]:%s: " fmtstr, (unsigned int)ts.tv_sec, (unsigned long int)ts.tv_nsec, __FUNCTION__, ##args);\
                    m_AplLib->AplTracecb((tAplU8)log_level, trace_buf); \
                }\
            }\
      if(log_journal_enable)\
        g_print("APL_MSG_TIME [%05u,%lu]:%s: " fmtstr, (unsigned int)ts.tv_sec, (unsigned long int)ts.tv_nsec, __FUNCTION__, ##args);\
    }}\

#define pr_warning(fmtstr, args...){\
        struct timespec ts;\
        clock_gettime(CLOCK_MONOTONIC, &ts);\
        if(m_AplLib)\
        {\
            if(m_AplLib->AplTracecb)\
            {\
                memset(trace_buf,0,D_TRACE_BUF_SIZE);\
                sprintf(trace_buf,"APL_WARN_TIME [%05u,%lu]:%s: " fmtstr, (unsigned int)ts.tv_sec, (unsigned long int)ts.tv_nsec, __FUNCTION__, ##args);\
                m_AplLib->AplTracecb((tAplU8)4, trace_buf); \
            }\
        }\
    if(log_journal_enable)\
      g_warning("%s: " fmtstr, __FUNCTION__, ##args);\
    }\

#else //LOG_REDIREC_TO_TTFIS

#define pr_debug(fmtstr, args...)\
        if(log_level >= 2)\
            g_print("APL_DBG:%s: " fmtstr, __FUNCTION__, ##args)


#define pr_debug_data(fmtstr, args...)\
        if(log_level >= 3)\
            g_print("APL_DBG:%s: " fmtstr, __FUNCTION__, ##args)

#define pr_message(fmtstr, args...)\
        if(log_level >= 1)\
        {\
            struct timespec ts;\
            clock_gettime(CLOCK_MONOTONIC, &ts); \
            g_print("APL_MSG_TIME [%05u,%lu]:%s: " fmtstr, (unsigned int)ts.tv_sec, (unsigned long int)ts.tv_nsec, __FUNCTION__, ##args); \
        }

#endif //LOG_REDIREC_TO_TTFIS
#else  //LOG_LVL_PER_ENV

#define pr_debug(fmtstr, args...) \
        g_debug("%s: " fmtstr, __FUNCTION__, ##args)
#define pr_message(fmtstr, args...) \
        g_message("%s: " fmtstr, __FUNCTION__, ##arg)
#endif //LOG_LVL_PER_ENV

#ifndef LOG_REDIREC_TO_TTFIS
#define pr_warning(fmtstr, args...) \
        g_warning("%s: " fmtstr, __FUNCTION__, ##args)
#endif
#define pr_critical(fmtstr, args...) \
        g_critical("%s: " fmtstr, __FUNCTION__, ##args)
#define pr_error(fmtstr, args...) \
        g_error("%s: " fmtstr, __FUNCTION__, ##args)



#define ARRAYSIZE(x)  (sizeof(x)/sizeof(x[0]))


#define EXPORT
#define LOCAL static

#define APL_MAX_NB_MODUL 5






/*******************************************************************************
              STRUCTURE DEFINITION
*******************************************************************************/

typedef enum _apllogitem
{
    apl_log_arkamys_calls = 1 ,
    apl_log_main

}apllogitem;


typedef enum _taplparamtype
{
    APL_PARAM_VARIABLE = 0,
    APL_PARAM_CONSTANT
}taplparamtype;


typedef struct _record_desc
{
    tAplI32          module_id;
    char*            file_name;
    FILE*            file_in_pcm;
    FILE*            file_out_pcm;
    size_t           rdata;
    size_t           wdata;
    long int         rpos;
    guint8           in_rec_active;
    guint8           out_rec_active;
    guint8           read_from_file_active;
    guint8           init;
}aplrecord_desc;

typedef struct _module_desc
{
    tAplI32                 associated_switch;
    tAplU8                  inst_nb;
    aplmodstate             state;
    tAplOpMode              aplopmode;
    APL_STATUS              (*apl_module_command)(void* /* data*/, tAplCmd /*cmd*/ );
    APL_STATUS              (*apl_module_prepare)(void* /* data, expected struct aplMainStruct */, void* /* data */); //, const tAplCfg* /*paplCfg*/);
    APL_STATUS              (*apl_module_process)(void* /* module_desc* */, const aplAudioSamples_desc* /* inAudio */); //, aplAudioSamples_desc*);
    APL_STATUS              (*apl_module_finalize)(void* /* data */);
    aplAudioSamples_desc*   (*apl_module_get_buffer)(void* /* data */);
    APL_STATUS              (*apl_module_get_property)(void* /* data */, tAplDataID /*iDataID*/,tAplU32* /*pulSize*/, void* /*pData*/);
    APL_STATUS              (*apl_module_set_property)(void* /* data */, tAplInt /*iDataID*/, tAplU32 /*ulSize*/, const void* /*pData*/);
    tAplBool                (*apl_module_notification)(void* /* data */, tAplInt* /*piDataID*/, tAplAction* /*paplAct*/);
    void*                   prev;
    void*                   next;
    gboolean                first_mod;
    gboolean                last_mod;
    void*                   data;
}module_desc;

struct aplMainStruct
{
    /* instance description data section */
    int             instance;
    gchar*          name;
    tAplBool        init;
    tAplBool        start;
    module_desc*    mdesc; //[APL_MAX_NB_MODUL];
    tAplDataID*     mlistcon;
    tAplU32         mlistsize;



    /*********************************
     * parameter instance container  *
     ********************************/

    /* audio streaming description */
    tAplU16  par_aplFrameShiftIn;
    tAplU16  par_aplSampleRateIn;
    tAplU16  par_aplChannelCntIn;
    tAplU16  par_aplAudioPcmFormatIn;
    tAplU16  par_aplFrameShiftOut;
    tAplU16  par_aplSampleRateOut;
    tAplU16  par_aplChannelCntOut;
    tAplU16  par_aplAudioPcmFormatOut;


    /* Module specific parameter */

    /* Arkamys*/
    tAplI32  par_aplArkamysSwitch;
    tAplI32  par_aplArkamysAvcActivate; //Switch;
    tAplI32  par_aplArkamysReverbActivate; //Switch;
    tAplI32  par_aplArkamysBassExciterActivate; //Switch;
    tAplI32  par_aplArkamysByPassActivate; //Switch;
    tAplI32  par_aplArkamysAmbienceSelect; //Switch;
    tAplI32* par_aplArkamysEolData;
    tAplI32  par_aplArkamysInputLevelDeviation; //Switch;
    tAplI32  par_aplArkamysCurrentSpeed; //Switch;
    tAplI32  par_aplArkamysCurrentVolumeStep; //Switch;


    /* micro level */
    tAplI32  par_aplMicLvlWatchSwitch;
    tAplI16  par_aplMicLvl;
    tAplU16  par_aplMicLvlWatchRefInt;
    tAplI32  par_aplMicLvlWatchStartStop;
    tAplI32  par_aplMicLvlOperationMode;

    /* pcm copy */
    tAplI32           par_aplPcmCopySwitch;
    tAplBindingMatrix par_aplAudioChannelBinding;

    /* volume */
    tAplI32 par_aplvolumeSwitch;

    /* cope configuration file */
    tAplCfg file;

    /* thread safe instance processing and parameter manipulation*/
    GMutex      lock;

    /* audio streaming recording */
    tAplU32    apl_internal_rec_mode_select;

    /**************************
     * function stack variables
     */
    unsigned int            i;
    unsigned int            j;
    short int*              s16ibuf;
    short int*              s16obuf;
    long int*               s32ibuf;
    long int*               s32obuf;
    unsigned int            sample_cnt;
    unsigned int            stream_cnt;
    tAplBool                isBinding;
    APL_STATUS              status;
    aplAudioSamples_desc*   minAudio;
    module_desc*            pm_last;
    unsigned int            ich;
    unsigned int            och;

};




/********************
 *  API
 *********************/



#endif // __APL_MAIN_H__

