/*
 * apl-internal.h
 *
 * Patrick Rey   23.10.2015
 */

#ifndef __APL_INTERNAL_H__
#define __APL_INTERNAL_H__

/********************
 *  API
 *********************/

extern  void            apl_internal_init(void);
extern  void            apl_internal_finalize(void);

extern APL_STATUS       apl_internal_apl_set_data(struct aplMainStruct*   hApl, const tAplDataID    DataID, tAplInt   iChannel,const unsigned int iSize, const void*  pData);
extern APL_STATUS       apl_internal_apl_get_data( struct aplMainStruct*   hApl, const tAplDataID    DataID, tAplInt  iChannel, unsigned int* pSize, void*    pData);
extern APL_STATUS       apl_internal_s16AudioTransfert(aplAudioSamples_desc*   inAudio,   aplAudioSamples_desc*   outAudio); //, gboolean can_swap);
extern APL_STATUS       apl_internal_is16os32AudioTransfert(aplAudioSamples_desc*   inAudio,  const aplAudioSamples_desc*   outAudio);
extern APL_STATUS       apl_internal_s32AudioTransfert(aplAudioSamples_desc*   inAudio,  aplAudioSamples_desc*   outAudio); //, gboolean can_swap);
extern APL_STATUS       apl_internal_is32os16AudioTransfert(aplAudioSamples_desc*   inAudio, const aplAudioSamples_desc*   outAudio);
extern APL_STATUS       apl_internal_attach_module(module_desc** module_chain, module_desc* module_attachment);

/* module specifical functions */
extern  module_desc*    apl_internal_find_module(const struct aplMainStruct*   hApl, tAplI32     module);
extern  module_desc*    apl_internal_last_module(const struct aplMainStruct*   aplh);
extern  APL_STATUS      apl_internal_attach_module_list(module_desc** module_chain, module_desc*** module_list, tAplU32 list_size);
extern  APL_STATUS      apl_internal_clean_prev_module_list(module_desc*** curr_list, tAplU32 curr_list_size, module_desc*** new_list, tAplU32 new_list_size);
extern  APL_STATUS      apl_internal_print_current_module_list(const struct aplMainStruct*   aplh);
extern  tAplU32         apl_internal_module_list_count(const struct aplMainStruct*   aplh);
extern  tAplU32         apl_internal_get_module_list(const struct aplMainStruct*    aplh, module_desc***   module_list);
extern  APL_STATUS      apl_internal_print_module_desc(const aplAudioSamples_desc* buf_desc, const char* buffer_name);
extern  APL_STATUS      apl_internal_log_init(apllogitem item);
extern  APL_STATUS      apl_internal_log_finalize(void);
extern  APL_STATUS      apl_internal_log_item(apllogitem item, gchar* format,...);
extern  APL_STATUS      apl_internal_log_item_data(apllogitem item, tAplI32 size, unsigned char* data, tAplBool datadir);


/* recording API */
extern tAplU32          apl_internal_rec_init(unsigned int mode_select);
extern void             apl_internal_rec_reinit(void);
extern APL_STATUS       apl_internal_stream_rec_file_write(unsigned int mode_select,  module_desc* mod, const aplAudioSamples_desc* RecAudio);

#endif // __APL_INTERNAL_H__
