/*******************************************************************************
* FILE : audproc-recording.c
*
* SW-COMPONENT :
*
* DESCRIPTION :
*
* AUTHOR : Patrick Rey
*
* COPYRIGHT :
*
* HISTORY : 02.11.2017
* Initial version
*******************************************************************************/



/*******************************************************************************
              DEFINES
*******************************************************************************/


static const char      *D_MICRO_RECORD_FILE_OUT_PCM     = "/tmp/mic_audproc_rec_out";
static const char      *D_MICRO_RECORD_FILE_IN_PCM      = "/tmp/mic_audproc_rec_in";
static const char      *D_INFO_RECORD_FILE_OUT_PCM      = "/tmp/info_audproc_rec_out";
static const char      *D_INFO_RECORD_FILE_IN_PCM       = "/tmp/info_audproc_rec_in";
static const char      *D_ENT_RECORD_FILE_IN_PCM        = "/tmp/ent_audproc_rec_in";
static const char      *D_ENT_RECORD_FILE_OUT_PCM       = "/tmp/ent_audproc_rec_out";
/*******************************************************************************
              GENERATED CODE HEADERS
*******************************************************************************/

#include <glib/gi18n.h>
#include <glib-object.h>
#include "audproc-common-defs.h"
#include <alsa/asoundlib.h>
#include "audproc-apl-handler.h"
#include "audproc-alsa.h"
#include "audproc-service.h"
#include "audproc-recording.h"
#include "audproc-audio-rts-handler.h"
#include "audproc-configuration.h"




#define D_RTS_NB_INST_MAX       40 //20
#define D_AUDPROC_RAM_REC_SIZE_MAX 6000000


/* Needed for Trace */
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define SPM_UNIT_TESTS // solve warning
#include "audproc-audioprocess-trace.h"
#include "etg_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AUDPROC
#include "trcGenProj/Header/audproc-recording.c.trc.h"
#endif



typedef struct _wave_header
{
    unsigned int num_samples;
    unsigned int num_bytes;
    unsigned int  sample_rate;
    unsigned int  bytes_per_sample;
    unsigned int  num_channels;
}wave_header;

/*******************************************************************************
              VARIABLE DECLARATIONS
*******************************************************************************/

record_desc             mic_rec_desc = {0};
record_desc             ent_rec_desc = {0};
record_desc             info_rec_desc = {0};
static char*            srec_stream_selec = (char*)NULL;
static gboolean         export_cap_as_wave_format = TRUE;
static gboolean         export_pb_as_wave_format = TRUE;
static int              export_record_index = 0;


/*******************************************************************************
              STATIC FUNTIONS DECLARATIONS
*******************************************************************************/


/******************
 * micro recording
 */

static int audproc_audio_rts_mic_rec_file_open(void)
{
    int err = AUDPROC_ERR_OK;

    pr_message("ENTERED\n");


    mic_rec_desc.rdata = 0;
    mic_rec_desc.wdata = 0;
    mic_rec_desc.rpos = 0;
    mic_rec_desc.wr_data_out_ptr  = 0;
    mic_rec_desc.wr_data_in_ptr    = 0;
    mic_rec_desc.start_stop_rec_in = TRUE;
    mic_rec_desc.start_stop_rec_out = TRUE;

    return err;
}

int audproc_audio_recording_mic_rec_file_reopen(audproc_alsa_stream_cfg* data)
{
    int err = AUDPROC_ERR_OK;
    unsigned int i = 0;

    pr_debug("ENTERED\n");

    if(!mic_rec_desc.init)
        return AUDPROC_ERR_OK;



    mic_rec_desc.rdata = 0;
    mic_rec_desc.wdata = 0;
    mic_rec_desc.rpos = 0;

    /* store first in a RAM Buffer */
    if(mic_rec_desc.in_rec_active)
    {
        if(mic_rec_desc.AudRamBufChannels_in)
        {
            // free firts the channel buffer
            for (i = 0; i < mic_rec_desc.astream->indev.audproc_nb_ch ; i++ )
            {
                if(mic_rec_desc.AudRamBufChannels_in[i])
                {
                    g_free(mic_rec_desc.AudRamBufChannels_in[i]);
                    mic_rec_desc.AudRamBufChannels_in[i] = (guint8*)NULL;
                }
            }
            g_free(mic_rec_desc.AudRamBufChannels_in);
            mic_rec_desc.AudRamBufChannels_in = (guint8**)NULL;
        }

        /* create buffer */

        pr_message("create %d ram record input buffer\n", mic_rec_desc.astream->indev.audproc_nb_ch );
        mic_rec_desc.AudRamBufChannels_in = (guint8**)g_malloc0(mic_rec_desc.astream->indev.audproc_nb_ch);

        if(mic_rec_desc.AudRamBufChannels_in)
        {
            // free firts the channel buffer
            for (i = 0; i < mic_rec_desc.astream->indev.audproc_nb_ch ; i++ )
            {
                mic_rec_desc.AudRamBufChannels_in[i] = (guint8*)g_malloc0(D_AUDPROC_RAM_REC_SIZE_MAX);
                if(mic_rec_desc.AudRamBufChannels_in[i])
                    pr_message("create ram record buffer channel_%d from %d bytes", i, D_AUDPROC_RAM_REC_SIZE_MAX );
            }
        }
    }

    if(mic_rec_desc.out_rec_active)
    {
        if(mic_rec_desc.AudRamBufChannels_out)
        {
            // free firts the channel buffer
            for (i = 0; i < mic_rec_desc.astream->outdev.audproc_nb_ch ; i++ )
            {
                if(mic_rec_desc.AudRamBufChannels_out[i])
                {
                    g_free(mic_rec_desc.AudRamBufChannels_out[i]);
                    mic_rec_desc.AudRamBufChannels_out[i] = (guint8*)NULL;
                }
            }
            g_free(mic_rec_desc.AudRamBufChannels_out);
            mic_rec_desc.AudRamBufChannels_out = (guint8**)NULL;
        }

        /* create buffer */

        pr_message("create %d ram record output buffer\n", mic_rec_desc.astream->outdev.audproc_nb_ch );
        mic_rec_desc.AudRamBufChannels_out = (guint8**)g_malloc0(mic_rec_desc.astream->outdev.audproc_nb_ch * sizeof(guint8**));

        if(mic_rec_desc.AudRamBufChannels_out)
        {
            // free firts the channel buffer
            for (i = 0; i < mic_rec_desc.astream->outdev.audproc_nb_ch ; i++ )
            {
                mic_rec_desc.AudRamBufChannels_out[i] = (guint8*)g_malloc0(D_AUDPROC_RAM_REC_SIZE_MAX);
                if(mic_rec_desc.AudRamBufChannels_out[i])
                    pr_message("create ram record buffer channel_%d from %d bytes\n", i, D_AUDPROC_RAM_REC_SIZE_MAX );
            }
        }
    }

    mic_rec_desc.wr_data_out_ptr  = 0;
    mic_rec_desc.wr_data_in_ptr    = 0;
    mic_rec_desc.start_stop_rec_in = TRUE;
    mic_rec_desc.start_stop_rec_out = TRUE;

    /* store start record time */
    clock_gettime(CLOCK_MONOTONIC, &mic_rec_desc.rec_in_time_start_record);
    clock_gettime(CLOCK_MONOTONIC, &mic_rec_desc.rec_out_time_start_record);


    mic_rec_desc.rec_in_dev = g_strdup(data->indev.audproc_dev_name);
    pr_message("capture device name-> %s\n", mic_rec_desc.rec_in_dev ? mic_rec_desc.rec_in_dev : "DEV_UNDEF");
    mic_rec_desc.rec_out_dev = g_strdup(data->outdev.audproc_dev_name);
    pr_message("playback device name-> %s\n", mic_rec_desc.rec_out_dev ? mic_rec_desc.rec_out_dev : "DEV_UNDEF");


    return err;
}


int audproc_audio_recording_mic_pb_write(void * buffer[], guint nb_byte_2_cpy)
{
    int err = AUDPROC_ERR_OK;
    unsigned int i = 0;

    pr_debug("ENTERED\n");


    if(!nb_byte_2_cpy)
    {
        pr_critical("number of byte to copy is NULL \n");
        return AUDPROC_ERR_OK;
    }

    guint data_size = nb_byte_2_cpy;


    if(!mic_rec_desc.start_stop_rec_out)
    {
        pr_debug("max size (%d) of the Ram Buffer was exceeded \n", D_AUDPROC_RAM_REC_SIZE_MAX);
    }
    else
    {
        if((mic_rec_desc.wr_data_out_ptr + data_size) >=  D_AUDPROC_RAM_REC_SIZE_MAX)
        {
            /* store start record time */
            clock_gettime(CLOCK_MONOTONIC, &mic_rec_desc.rec_out_time_stop_record);
            mic_rec_desc.start_stop_rec_out = FALSE;
        }
        else
        {
            for (i = 0; i < mic_rec_desc.astream->outdev.audproc_nb_ch ; i++ )
            {
                guint8* dest = mic_rec_desc.AudRamBufChannels_out[i];
                guint8* src =  (guint8*)buffer[i];

                if(dest && src)
                    memcpy((void*)&dest[mic_rec_desc.wr_data_out_ptr], (void*)src, data_size);
                else
                    pr_warning("audio channel_buffer_%d is invalid\n", i);
            }
            mic_rec_desc.wr_data_out_ptr += data_size;
            pr_debug("write %d_bytes in the %d Ram channel_Buffer with current size:%d\n", data_size, mic_rec_desc.astream->outdev.audproc_nb_ch, mic_rec_desc.wr_data_out_ptr);
        }
    }

    return err;
}

int audproc_audio_recording_mic_cap_write(void * buffer[], guint nb_byte_2_cpy)
{
    int err = AUDPROC_ERR_OK;
    unsigned int i = 0;

    pr_debug("ENTERED\n");


    if(!nb_byte_2_cpy)
    {
        pr_critical("number of byte to copy is NULL \n");
        return AUDPROC_ERR_OK;
    }

    guint data_size = nb_byte_2_cpy;


    if(!mic_rec_desc.start_stop_rec_in)
    {
        pr_debug("max size (%d) of the Ram Buffer was exceeded \n", D_AUDPROC_RAM_REC_SIZE_MAX);
    }
    else
    {
        if((mic_rec_desc.wr_data_in_ptr + data_size) >=  D_AUDPROC_RAM_REC_SIZE_MAX)
        {
            /* store start record time */
            clock_gettime(CLOCK_MONOTONIC, &mic_rec_desc.rec_in_time_stop_record);
            mic_rec_desc.start_stop_rec_in = FALSE;
        }
        else
        {
            for (i = 0; i < mic_rec_desc.astream->indev.audproc_nb_ch ; i++ )
            {
                guint8* dest = mic_rec_desc.AudRamBufChannels_in[i];
                guint8* src =  (guint8*)buffer[i];

                if(dest && src)
                    memcpy((void*)&dest[mic_rec_desc.wr_data_in_ptr], (void*)src, data_size);
                else
                    pr_warning("audio channel_buffer_%d is invalid \n", i);
            }
            mic_rec_desc.wr_data_in_ptr += data_size;
            pr_debug("write %d_bytes in the %d Ram channel_Buffer with current size:%d\n", data_size, mic_rec_desc.astream->indev.audproc_nb_ch, mic_rec_desc.wr_data_in_ptr);
        }
    }
    return err;
}

/*********
 * entertainment recording
 */


static int audproc_audio_rts_ent_rec_file_open(void)
{
    int err = AUDPROC_ERR_OK;

    pr_message("ENTERED\n");


    ent_rec_desc.rdata = 0;
    ent_rec_desc.wdata = 0;
    ent_rec_desc.rpos = 0;
    ent_rec_desc.wr_data_out_ptr  = 0;
    ent_rec_desc.wr_data_in_ptr    = 0;
    ent_rec_desc.start_stop_rec_in = TRUE;
    ent_rec_desc.start_stop_rec_out = TRUE;

    return err;
}

int audproc_audio_recording_ent_rec_file_reopen(audproc_alsa_stream_cfg* data)
{
    int err = AUDPROC_ERR_OK;
    unsigned int i = 0;

    pr_debug("ENTERED\n");

    if(!ent_rec_desc.init)
        return AUDPROC_ERR_OK;



    ent_rec_desc.rdata = 0;
    ent_rec_desc.wdata = 0;
    ent_rec_desc.rpos = 0;

    /* store first in a RAM Buffer */
    if(ent_rec_desc.in_rec_active)
    {
        if(ent_rec_desc.AudRamBufChannels_in)
        {
            // free firts the channel buffer
            for (i = 0; i < ent_rec_desc.astream->indev.audproc_nb_ch ; i++ )
            {
                if(ent_rec_desc.AudRamBufChannels_in[i])
                {
                    g_free(ent_rec_desc.AudRamBufChannels_in[i]);
                    ent_rec_desc.AudRamBufChannels_in[i] = (guint8*)NULL;
                }
            }
            g_free(ent_rec_desc.AudRamBufChannels_in);
            ent_rec_desc.AudRamBufChannels_in = (guint8**)NULL;
        }

        /* create buffer */

        pr_message("create %d ram record input buffer\n", ent_rec_desc.astream->indev.audproc_nb_ch );
        ent_rec_desc.AudRamBufChannels_in = (guint8**)g_malloc0(ent_rec_desc.astream->indev.audproc_nb_ch);

        if(ent_rec_desc.AudRamBufChannels_in)
        {
            // free firts the channel buffer
            for (i = 0; i < ent_rec_desc.astream->indev.audproc_nb_ch ; i++ )
            {
                ent_rec_desc.AudRamBufChannels_in[i] = (guint8*)g_malloc0(D_AUDPROC_RAM_REC_SIZE_MAX);
                if(ent_rec_desc.AudRamBufChannels_in[i])
                {
                    pr_message("create ram record buffer channel_%d from %d bytes", i, D_AUDPROC_RAM_REC_SIZE_MAX );
                }
            }
        }
    }

    if(ent_rec_desc.out_rec_active)
    {
        if(ent_rec_desc.AudRamBufChannels_out)
        {
            // free firts the channel buffer
            for (i = 0; i < ent_rec_desc.astream->outdev.audproc_nb_ch ; i++ )
            {
                if(ent_rec_desc.AudRamBufChannels_out[i])
                {
                    g_free(ent_rec_desc.AudRamBufChannels_out[i]);
                    ent_rec_desc.AudRamBufChannels_out[i] = (guint8*)NULL;
                }
            }
            g_free(ent_rec_desc.AudRamBufChannels_out);
            ent_rec_desc.AudRamBufChannels_out = (guint8**)NULL;
        }

        /* create buffer */

        pr_message("create %d ram record output buffer\n", ent_rec_desc.astream->outdev.audproc_nb_ch );
        ent_rec_desc.AudRamBufChannels_out = (guint8**)g_malloc0(ent_rec_desc.astream->outdev.audproc_nb_ch * sizeof(guint8**));

        if(ent_rec_desc.AudRamBufChannels_out)
        {
            // free firts the channel buffer
            for (i = 0; i < ent_rec_desc.astream->outdev.audproc_nb_ch ; i++ )
            {
                ent_rec_desc.AudRamBufChannels_out[i] = (guint8*)g_malloc0(D_AUDPROC_RAM_REC_SIZE_MAX);
                if(ent_rec_desc.AudRamBufChannels_out[i])
                {
                    pr_message("create ram record buffer channel_%d from %d bytes\n", i, D_AUDPROC_RAM_REC_SIZE_MAX );
                }
            }
        }
    }

    ent_rec_desc.wr_data_out_ptr  = 0;
    ent_rec_desc.wr_data_in_ptr    = 0;
    ent_rec_desc.start_stop_rec_in = TRUE;
    ent_rec_desc.start_stop_rec_out = TRUE;

    /* store start record time */
    clock_gettime(CLOCK_MONOTONIC, &ent_rec_desc.rec_in_time_start_record);
    clock_gettime(CLOCK_MONOTONIC, &ent_rec_desc.rec_out_time_start_record);

    ent_rec_desc.rec_in_dev = g_strdup(data->indev.audproc_dev_name);
    pr_message("capture device name-> %s\n", ent_rec_desc.rec_in_dev ? ent_rec_desc.rec_in_dev : "DEV_UNDEF");
    ent_rec_desc.rec_out_dev = g_strdup(data->outdev.audproc_dev_name);
    pr_message("playback device name-> %s\n", ent_rec_desc.rec_in_dev ? ent_rec_desc.rec_in_dev : "DEV_UNDEF");

    return err;
}


int audproc_audio_recording_ent_pb_write(void * buffer[], guint nb_byte_2_cpy)
{
    int err = AUDPROC_ERR_OK;
    unsigned int i = 0;

    pr_debug("ENTERED\n");


    if(!nb_byte_2_cpy)
    {
        pr_critical("number of byte to copy is NULL \n");
        return AUDPROC_ERR_OK;
    }

    guint data_size = nb_byte_2_cpy;


    if(!ent_rec_desc.start_stop_rec_out)
    {
        pr_debug("max size (%d) of the Ram Buffer was exceeded \n", D_AUDPROC_RAM_REC_SIZE_MAX);
    }
    else
    {
        if((ent_rec_desc.wr_data_out_ptr + data_size) >=  D_AUDPROC_RAM_REC_SIZE_MAX)
        {
            /* store start record time */
            clock_gettime(CLOCK_MONOTONIC, &ent_rec_desc.rec_out_time_stop_record);
            ent_rec_desc.start_stop_rec_out = FALSE;
        }
        else
        {
            for (i = 0; i < ent_rec_desc.astream->outdev.audproc_nb_ch ; i++ )
            {
                guint8* dest = ent_rec_desc.AudRamBufChannels_out[i];
                guint8* src =  (guint8*)buffer[i];

                if(dest && src)
                    memcpy((void*)&dest[ent_rec_desc.wr_data_out_ptr], (void*)src, data_size);
                else
                {
                    pr_warning("audio channel_buffer_%d is invalid\n", i);
                }
            }
            ent_rec_desc.wr_data_out_ptr += data_size;
            pr_debug("write %d_bytes in the %d Ram channel_Buffer with current size:%d\n", data_size, ent_rec_desc.astream->outdev.audproc_nb_ch, ent_rec_desc.wr_data_out_ptr);
        }
    }

    return err;
}

int audproc_audio_recording_ent_cap_write(void * buffer[], guint nb_byte_2_cpy)
{
    int err = AUDPROC_ERR_OK;
    unsigned int i = 0;

    pr_debug("ENTERED\n");


    if(!nb_byte_2_cpy)
    {
        pr_critical("number of byte to copy is NULL \n");
        return AUDPROC_ERR_OK;
    }

    guint data_size = nb_byte_2_cpy;


    if(!ent_rec_desc.start_stop_rec_in)
    {
        pr_debug("max size (%d) of the Ram Buffer was exceeded \n", D_AUDPROC_RAM_REC_SIZE_MAX);
    }
    else
    {
        if((ent_rec_desc.wr_data_in_ptr + data_size) >=  D_AUDPROC_RAM_REC_SIZE_MAX)
        {
            /* store start record time */
            clock_gettime(CLOCK_MONOTONIC, &ent_rec_desc.rec_in_time_stop_record);
            ent_rec_desc.start_stop_rec_in = FALSE;
        }
        else
        {
            for (i = 0; i < ent_rec_desc.astream->indev.audproc_nb_ch ; i++ )
            {
                guint8* dest = ent_rec_desc.AudRamBufChannels_in[i];
                guint8* src =  (guint8*)buffer[i];

                if(dest && src)
                    memcpy((void*)&dest[ent_rec_desc.wr_data_in_ptr], (void*)src, data_size);
                else
                {
                    pr_warning("audio channel_buffer_%d is invalid \n", i);
                }
            }
            ent_rec_desc.wr_data_in_ptr += data_size;
            pr_debug("write %d_bytes in the %d Ram channel_Buffer with current size:%d\n", data_size, ent_rec_desc.astream->indev.audproc_nb_ch, ent_rec_desc.wr_data_in_ptr);
            //pr_debug("number of bytes writen in the Ram Buffers: %d\n", ent_rec_desc.wr_data_in_ptr);
        }
    }
    return err;
}

/********** end ent recording functions *********/

/*********
 * info  recording
 */

static int audproc_audio_rts_info_rec_file_open(void)
{
    int err = AUDPROC_ERR_OK;

    pr_message("ENTERED\n");


    info_rec_desc.rdata = 0;
    info_rec_desc.wdata = 0;
    info_rec_desc.rpos = 0;
    info_rec_desc.wr_data_out_ptr  = 0;
    info_rec_desc.wr_data_in_ptr    = 0;
    info_rec_desc.start_stop_rec_in = TRUE;
    info_rec_desc.start_stop_rec_out = TRUE;

    return err;
}

int audproc_audio_recording_info_rec_file_reopen(audproc_alsa_stream_cfg* data)
{
    int err = AUDPROC_ERR_OK;
    unsigned int i = 0;

    pr_debug("ENTERED\n");
    ETG_TRACE_USR3(("[audproc_audio_recording_info_rec_file_reopen]: ENTERED"));

    if(!info_rec_desc.init)
        return AUDPROC_ERR_OK;



    info_rec_desc.rdata = 0;
    info_rec_desc.wdata = 0;
    info_rec_desc.rpos = 0;

    /* store first in a RAM Buffer */
    if(info_rec_desc.in_rec_active)
    {
        if(info_rec_desc.AudRamBufChannels_in)
        {
            // free firts the channel buffer
            for (i = 0; i < info_rec_desc.astream->indev.audproc_nb_ch ; i++ )
            {
                if(info_rec_desc.AudRamBufChannels_in[i])
                {
                    g_free(info_rec_desc.AudRamBufChannels_in[i]);
                    info_rec_desc.AudRamBufChannels_in[i] = (guint8*)NULL;
                }
            }
            g_free(info_rec_desc.AudRamBufChannels_in);
            info_rec_desc.AudRamBufChannels_in = (guint8**)NULL;
        }

        /* create buffer */

        pr_message("create %d ram record input buffer\n", info_rec_desc.astream->indev.audproc_nb_ch );
        info_rec_desc.AudRamBufChannels_in = (guint8**)g_malloc0(info_rec_desc.astream->indev.audproc_nb_ch);

        if(info_rec_desc.AudRamBufChannels_in)
        {
            // free firts the channel buffer
            for (i = 0; i < info_rec_desc.astream->indev.audproc_nb_ch ; i++ )
            {
                info_rec_desc.AudRamBufChannels_in[i] = (guint8*)g_malloc0(D_AUDPROC_RAM_REC_SIZE_MAX);
                if(info_rec_desc.AudRamBufChannels_in[i])
                    pr_message("create ram record buffer channel_%d from %d bytes", i, D_AUDPROC_RAM_REC_SIZE_MAX );
            }
        }

        ETG_TRACE_USR3(("[audproc_audio_recording_info_rec_file_reopen]: capture dev recording is active"));
    }

    if(info_rec_desc.out_rec_active)
    {
        if(info_rec_desc.AudRamBufChannels_out)
        {
            // free firts the channel buffer
            for (i = 0; i < info_rec_desc.astream->outdev.audproc_nb_ch ; i++ )
            {
                if(info_rec_desc.AudRamBufChannels_out[i])
                {
                    g_free(info_rec_desc.AudRamBufChannels_out[i]);
                    info_rec_desc.AudRamBufChannels_out[i] = (guint8*)NULL;
                }
            }
            g_free(info_rec_desc.AudRamBufChannels_out);
            info_rec_desc.AudRamBufChannels_out = (guint8**)NULL;
        }

        /* create buffer */

        pr_message("create %d ram record output buffer\n", info_rec_desc.astream->outdev.audproc_nb_ch );
        info_rec_desc.AudRamBufChannels_out = (guint8**)g_malloc0(info_rec_desc.astream->outdev.audproc_nb_ch * sizeof(guint8**));

        if(info_rec_desc.AudRamBufChannels_out)
        {
            // free firts the channel buffer
            for (i = 0; i < info_rec_desc.astream->outdev.audproc_nb_ch ; i++ )
            {
                info_rec_desc.AudRamBufChannels_out[i] = (guint8*)g_malloc0(D_AUDPROC_RAM_REC_SIZE_MAX);
                if(info_rec_desc.AudRamBufChannels_out[i])
                    pr_message("create ram record buffer channel_%d from %d bytes\n", i, D_AUDPROC_RAM_REC_SIZE_MAX );
            }
        }

        ETG_TRACE_USR3(("[audproc_audio_recording_info_rec_file_reopen]: playback dev recording is active"));
    }

    info_rec_desc.wr_data_out_ptr  = 0;
    info_rec_desc.wr_data_in_ptr    = 0;
    info_rec_desc.start_stop_rec_in = TRUE;
    info_rec_desc.start_stop_rec_out = TRUE;

    /* store start record time */
    clock_gettime(CLOCK_MONOTONIC, &info_rec_desc.rec_in_time_start_record);
    clock_gettime(CLOCK_MONOTONIC, &info_rec_desc.rec_out_time_start_record);

    info_rec_desc.rec_in_dev = g_strdup(data->indev.audproc_dev_name);
    info_rec_desc.rec_out_dev = g_strdup(data->outdev.audproc_dev_name);


    return err;
}


int audproc_audio_recording_info_pb_write(void * buffer[], guint nb_byte_2_cpy)
{
    int err = AUDPROC_ERR_OK;
    unsigned int i = 0;

    pr_debug("ENTERED\n");

    if(!buffer)
    {
        pr_critical("invalid stream buffer array \n");
        return AUDPROC_ERR_OK;
    }

    if(!nb_byte_2_cpy)
    {
        pr_critical("number of byte to copy is NULL \n");
        return AUDPROC_ERR_OK;
    }

    guint data_size = nb_byte_2_cpy;


    if(!info_rec_desc.start_stop_rec_out)
    {
        pr_debug("max size (%d) of the Ram Buffer was exceeded \n", D_AUDPROC_RAM_REC_SIZE_MAX);
    }
    else
    {
        if((info_rec_desc.wr_data_out_ptr + data_size) >=  D_AUDPROC_RAM_REC_SIZE_MAX)
        {
            /* store start record time */
            clock_gettime(CLOCK_MONOTONIC, &info_rec_desc.rec_out_time_stop_record);
            info_rec_desc.start_stop_rec_out = FALSE;
        }
        else
        {
            for (i = 0; i < info_rec_desc.astream->outdev.audproc_nb_ch ; i++ )
            {
                guint8* dest = info_rec_desc.AudRamBufChannels_out[i];
                guint8* src =  (guint8*)buffer[i];

                if(dest && src)
                    memcpy((void*)&dest[info_rec_desc.wr_data_out_ptr], (void*)src, data_size);
                else
                {
                    pr_warning("audio channel_buffer_%d is invalid\n", i);
                }
            }
            info_rec_desc.wr_data_out_ptr += data_size;
            pr_debug("write %d_bytes in the %d Ram channel_Buffer with current size:%d\n", data_size, info_rec_desc.astream->outdev.audproc_nb_ch, info_rec_desc.wr_data_out_ptr);
        }
    }

    return err;
}

int audproc_audio_recording_info_cap_write(void * buffer[], guint nb_byte_2_cpy)
{
    int err = AUDPROC_ERR_OK;
    unsigned int i = 0;

    pr_debug("ENTERED\n");

    if(!buffer)
    {
        pr_critical("invalid stream buffer array \n");
        return AUDPROC_ERR_OK;
    }

    if(!nb_byte_2_cpy)
    {
        pr_critical("number of byte to copy is NULL \n");
        return AUDPROC_ERR_OK;
    }

    guint data_size = nb_byte_2_cpy;


    if(!info_rec_desc.start_stop_rec_in)
    {
        pr_debug("max size (%d) of the Ram Buffer was exceeded \n", D_AUDPROC_RAM_REC_SIZE_MAX);
    }
    else
    {
        if((info_rec_desc.wr_data_in_ptr + data_size) >=  D_AUDPROC_RAM_REC_SIZE_MAX)
        {
            /* store start record time */
            clock_gettime(CLOCK_MONOTONIC, &info_rec_desc.rec_in_time_stop_record);
            info_rec_desc.start_stop_rec_in = FALSE;
        }
        else
        {
            for (i = 0; i < info_rec_desc.astream->indev.audproc_nb_ch ; i++ )
            {
                guint8* dest = info_rec_desc.AudRamBufChannels_in[i];
                guint8* src =  (guint8*)buffer[i];

                if(dest && src)
                    memcpy((void*)&dest[info_rec_desc.wr_data_in_ptr], (void*)src, data_size);
                else
                    pr_warning("audio channel_buffer_%d is invalid \n", i);
            }
            info_rec_desc.wr_data_in_ptr += data_size;
            pr_debug("write %d_bytes in the %d Ram channel_Buffer with current size:%d\n", data_size, info_rec_desc.astream->indev.audproc_nb_ch, info_rec_desc.wr_data_in_ptr);
        }
    }
    return err;
}

/**************  end recording info recording functions ************************/


void audproc_audio_recording_stop(void)
{

    if (  !g_strcmp0(srec_stream_selec, "1")
        ||!g_strcmp0(srec_stream_selec, "2")
        ||!g_strcmp0(srec_stream_selec, "3"))  // record playback stream only
    {
        /*entertainemnt sources*/
        ent_rec_desc.out_rec_active = 0;
        ent_rec_desc.in_rec_active = 0;

        /*voice sources*/
        mic_rec_desc.out_rec_active = 0;
        mic_rec_desc.in_rec_active = 0;

        /*info sources*/
        info_rec_desc.out_rec_active = 0;
        info_rec_desc.in_rec_active = 0;
    }
    else
    {
        /* do nothing */
    }

    return;
}

void audproc_audio_recording_restart(void)
{
    if (!g_strcmp0(srec_stream_selec, "1"))  // record playback stream only
    {
        ent_rec_desc.out_rec_active = 1;
        ent_rec_desc.in_rec_active = 0;
        ent_rec_desc.start_stop_rec_out = TRUE;

        mic_rec_desc.out_rec_active = 1;
        mic_rec_desc.in_rec_active = 0;
        mic_rec_desc.start_stop_rec_out = TRUE;

        info_rec_desc.out_rec_active = 1;
        info_rec_desc.in_rec_active = 0;
        info_rec_desc.start_stop_rec_out = TRUE;
    }
    else if (!g_strcmp0(srec_stream_selec, "2"))  // record capture stream only
    {
        ent_rec_desc.out_rec_active = 0;
        ent_rec_desc.in_rec_active = 1;
        ent_rec_desc.start_stop_rec_out = TRUE;

        mic_rec_desc.out_rec_active = 0;
        mic_rec_desc.in_rec_active = 1;
        mic_rec_desc.start_stop_rec_out = TRUE;

        info_rec_desc.out_rec_active = 1;
        info_rec_desc.in_rec_active = 0;
        info_rec_desc.start_stop_rec_out = TRUE;
    }
    else if (!g_strcmp0(srec_stream_selec, "3"))  // record capture and playback
    {
        ent_rec_desc.out_rec_active = 1;
        ent_rec_desc.in_rec_active = 1;
        ent_rec_desc.start_stop_rec_out = TRUE;

        mic_rec_desc.out_rec_active = 1;
        mic_rec_desc.in_rec_active = 1;
        mic_rec_desc.start_stop_rec_out = TRUE;

        info_rec_desc.out_rec_active = 1;
        info_rec_desc.in_rec_active = 0;
        info_rec_desc.start_stop_rec_out = TRUE;
    }
    else
    {
        /* no defined */

    }
    return;
}


static void audproc_write_little_endian(unsigned int word, int num_bytes, FILE *wav_file)
{
    unsigned buf;
    while(num_bytes>0)
    {
        buf = word & 0xff;
        pr_debug("write byte_%d:%d",num_bytes, buf);
        fwrite(&buf, 1,1, wav_file);
        num_bytes--;
        word >>= 8;
    }
}

/* information about the WAV file format from
    http://ccrma.stanford.edu/courses/422/projects/WaveFormat/
 */

static void audproc_write_wav(char* filename, wave_header* wav_infos, guint8** data)
{
    FILE* wav_file;
    unsigned int sample_rate, num_channels, bytes_per_sample, byte_rate ;
    size_t i, wdata;    /* counter for samples */
    unsigned int wr_pt = 0;
    unsigned int num_samples;

    pr_message("ENTERED\n");

    if(!filename || !wav_infos || !data)
        return;


    num_channels        = wav_infos->num_channels;   /* monoaural */
    pr_debug("wav_infos->num_channels: %d", wav_infos->num_channels);
    bytes_per_sample    = wav_infos->bytes_per_sample;
    pr_debug("wav_infos->bytes_per_sample: %d", wav_infos->bytes_per_sample);
    sample_rate         = wav_infos->sample_rate;
    pr_debug("wav_infos->sample_rate: %d", wav_infos->sample_rate);
    num_samples         = wav_infos->num_samples;
    pr_debug("wav_infos->num_samples: %d", wav_infos->num_samples);
    byte_rate = sample_rate * num_channels * bytes_per_sample;
    pr_debug("byte_rate: %d", byte_rate);


    wav_file = fopen(filename, "w");
    if(!wav_file)
    {
        pr_warning("fails to open wav aoutput record file\n");
        return;
    }


    /* write RIFF header */
    fwrite("RIFF", 1, 4, wav_file);
    audproc_write_little_endian(36 + bytes_per_sample * num_samples * num_channels, 4, wav_file);
    fwrite("WAVE", 1, 4, wav_file);

    /* write fmt  subchunk */
    fwrite("fmt ", 1, 4, wav_file);
    audproc_write_little_endian(16, 4, wav_file);   /* SubChunk1Size is 16 */
    audproc_write_little_endian(1, 2, wav_file);    /* PCM is format 1 */
    audproc_write_little_endian(num_channels, 2, wav_file);
    audproc_write_little_endian(sample_rate, 4, wav_file);
    audproc_write_little_endian(byte_rate, 4, wav_file);
    audproc_write_little_endian( num_channels * bytes_per_sample, 2, wav_file);  /* block align */
    audproc_write_little_endian( 8 * bytes_per_sample, 2, wav_file);  /* bits/sample */

    /* write data subchunk */
    fwrite("data", 1, 4, wav_file);
    audproc_write_little_endian(bytes_per_sample * num_samples * num_channels, 4, wav_file);

    wr_pt = 0;

    pr_debug("wav_infos->num_bytes: %d", wav_infos->num_bytes);

    while(wr_pt < wav_infos->num_bytes)
    {
        for (i = 0; i < num_channels ; i++ )
        {
            guint8* audio = data[i];
            if(audio)
                wdata = fwrite((void*)&audio[wr_pt], (size_t)1, bytes_per_sample, wav_file);
            else
            {
                pr_warning("audio channel_buffer_%lu is invalid \n", i);
            }
        }
        wr_pt += bytes_per_sample;
    }

    fclose(wav_file);
    (void)wdata;
}

static void audproc_audio_rts_handler_export_cap_dev_recording(record_desc* rec, const char* file_prefix)
{

    gchar*  pfound = NULL;
    gchar   key[] = ":";
    wave_header wav_infos = {0};
    unsigned int     i = 0;

    pr_message("ENTERED\n");


    if(!rec || !file_prefix)
    {
        pr_warning("NULL parameter\n");
        return;
    }

    if(rec->in_rec_active)
    {

        if(!rec->rec_in_dev)
        {
            pr_message("NULL capture device string \n");
            return;
        }

        pr_message("exporte audio recording in files\n");

        if(rec->start_stop_rec_in)
        {
            clock_gettime(CLOCK_MONOTONIC, &rec->rec_in_time_stop_record);
            rec->start_stop_rec_out = FALSE;
        }

        memset(rec->rec_file_name,0,300);
        memset(&wav_infos,0, sizeof(wav_infos));


        /* audio editor support wav header only up to 2 channel,
           export in pcm format if nb of channel > 2
        */
        if(rec->astream->indev.audproc_nb_ch > 2)
            export_cap_as_wave_format = FALSE;


        if (!export_cap_as_wave_format)
        {
            /*create out file:
                "prefix"_"devicename"_"x"ch_"y"kHz_%s_LE_"index".pcm
            */
            sprintf(rec->rec_file_name, "%s_%s_%dch_%dkHz_%s_LE_%d.pcm",  file_prefix,
                                                                       rec->rec_in_dev,
                                                                       rec->astream->indev.audproc_nb_ch,
                                                                       (rec->astream->indev.audproc_rate / 1000),
                                                                       (rec->astream->indev.audproc_format == SND_PCM_FORMAT_S16_LE) ? "S16" : "S32",
                                                                       export_record_index);

            #if 0
            sprintf(rec->rec_file_name, "%s_%s_rec_start[%05u,%lu]_rec_stop[%05u,%lu].pcm", file_prefix,
                                                                                                    rec->rec_in_dev,
                                                                                                    (unsigned int)rec->rec_in_time_start_record.tv_sec,
                                                                                                    (unsigned long int)rec->rec_in_time_start_record.tv_nsec,
                                                                                                    (unsigned int)rec->rec_in_time_stop_record.tv_sec,
                                                                                                    (unsigned long int)rec->rec_in_time_stop_record.tv_nsec);

            #endif

            pr_debug("record file:%s\n",rec->rec_file_name);

            /* replace ":" charactere with "_"*/
            pfound = strpbrk (rec->rec_file_name, key);
            while (pfound != NULL)
            {
                *pfound = 0x5F;  /* "_" */
                pfound = strpbrk (pfound+1,key);
            }
        }

        if(export_cap_as_wave_format)
        {
            /*create out file:
                "prefix"_"devicename"_"x"ch_"y"kHz_%s_LE_"index".wav
            */
            sprintf(rec->rec_file_name, "%s_%s_%dch_%dkHz_%s_LE_%d.wav",  file_prefix,
                                                                       rec->rec_in_dev,
                                                                       rec->astream->indev.audproc_nb_ch,
                                                                       (rec->astream->indev.audproc_rate / 1000),
                                                                       (rec->astream->indev.audproc_format == SND_PCM_FORMAT_S16_LE) ? "S16" : "S32",
                                                                       export_record_index);
#if 0
            /*create out file*/
            sprintf(rec->rec_file_name, "%s_%s_rec_start[%05u,%lu]_rec_stop[%05u,%lu].wav", file_prefix,
                                                                                                rec->rec_in_dev,
                                                                                                (unsigned int)rec->rec_in_time_start_record.tv_sec,
                                                                                                (unsigned long int)rec->rec_in_time_start_record.tv_nsec,
                                                                                                (unsigned int)rec->rec_in_time_stop_record.tv_sec,
                                                                                                (unsigned long int)rec->rec_in_time_stop_record.tv_nsec);

#endif
            pr_debug("record file:%s\n",rec->rec_file_name);

            /* replace ":" charactere with "_"*/
            pfound = strpbrk (rec->rec_file_name, key);
            while (pfound != NULL)
            {
                *pfound = 0x5F;  /* "_" */
                pfound = strpbrk (pfound+1,key);
            }


            /* wave infos structure */
            wav_infos.num_bytes            = rec->wr_data_in_ptr ;
            wav_infos.sample_rate          = rec->astream->indev.audproc_rate;
            if(rec->astream->indev.audproc_format == SND_PCM_FORMAT_S16_LE)
                wav_infos.bytes_per_sample = 2;
            else if(rec->astream->indev.audproc_format == SND_PCM_FORMAT_S32_LE || rec->astream->indev.audproc_format == SND_PCM_FORMAT_S24_LE )
                wav_infos.bytes_per_sample = 4;
            wav_infos.num_channels         = rec->astream->indev.audproc_nb_ch;
            wav_infos.num_samples          = wav_infos.num_bytes / wav_infos.bytes_per_sample ;

            /* wave infos structure */
            pr_message("write %d_Bytes in cap_record_file:%s", wav_infos.num_bytes , rec->rec_file_name? rec->rec_file_name: "NOT_DEFINED");
            pr_message("************** print wav header infos ***************\n");
            pr_message("wav_infos.num_bytes         : %d\n", wav_infos.num_bytes );
            pr_message("wav_infos.sample_rate       : %d\n", wav_infos.sample_rate );
            pr_message("wav_infos.bytes_per_sample  : %d\n", wav_infos.bytes_per_sample );
            pr_message("wav_infos.num_channels      : %d\n", wav_infos.num_channels );
            pr_message("wav_infos.num_samples       : %d\n", wav_infos.num_samples );
            pr_message("************** print wav header infos ***************\n");


            /* create wave file */
            audproc_write_wav(rec->rec_file_name, &wav_infos, rec->AudRamBufChannels_in);
        }
        else
        {
            rec->file_in_pcm = fopen (rec->rec_file_name,"a");
            if(!rec->file_in_pcm)
            {
                pr_warning("could not open record file:%s\n", rec->rec_file_name);
                return;
            }
            fseek(rec->file_in_pcm, 0, SEEK_SET);

            /* now export data to file */
            unsigned int wr_pt = 0;
            unsigned int bpc = 0;
            if(rec->astream->indev.audproc_format == SND_PCM_FORMAT_S16_LE)
                bpc = 2;
            else if(rec->astream->indev.audproc_format == SND_PCM_FORMAT_S32_LE || rec->astream->indev.audproc_format == SND_PCM_FORMAT_S24_LE )
                bpc = 4;

            while(wr_pt < rec->wr_data_in_ptr)
            {
                for (i = 0; i < rec->astream->indev.audproc_nb_ch ; i++ )
                {
                    guint8* audio_in = rec->AudRamBufChannels_in[i];
                    if(audio_in)
                        rec->wdata = fwrite((void*)&audio_in[wr_pt], (size_t)1, bpc, rec->file_in_pcm);
                    else
                        pr_warning("audio channel_buffer_%d is invalid\n", i);
                }
                wr_pt += bpc;
            }

            pr_debug("exporte audio recording from cap dev. in a files with size %d\n", rec->wr_data_in_ptr);

            /* close now file handle */
            if(NULL != rec->file_in_pcm)
                fclose (rec->file_in_pcm);
        }

    }

    /* recover default setting */
    export_cap_as_wave_format = TRUE;

    return;
}
static void audproc_audio_rts_handler_export_pb_dev_recording(record_desc* rec, const char* file_prefix)
{

    gchar*  pfound = NULL;
    gchar   key[] = ":";
    wave_header wav_infos = {0};
    unsigned int     i = 0;


    pr_message("ENTERED\n");

    if(!rec || !file_prefix)
    {
        pr_message("NULL parameter\n");
        return;
    }

    if(rec->out_rec_active)
    {

        if(!rec->rec_out_dev)
        {
            pr_message("NULL playback device string\n");
            return;
        }

        pr_message("exporte audio recording in files\n");

        if(rec->start_stop_rec_in)
        {
            clock_gettime(CLOCK_MONOTONIC, &rec->rec_out_time_stop_record);
            rec->start_stop_rec_out = FALSE;
        }

        memset(rec->rec_file_name,0,300);
        memset(&wav_infos,0, sizeof(wav_infos));

        /* audio editor support wav header only up to 2 channel,
           export in pcm format if nb of channel > 2
        */
        if(rec->astream->outdev.audproc_nb_ch > 2)
            export_pb_as_wave_format = FALSE;

        if(!export_pb_as_wave_format)
        {
            /*create out file:
                "prefix"_"devicename"_"x"ch_"y"kHz_%s_LE_"index".pcm
            */
            sprintf(rec->rec_file_name, "%s_%s_%dch_%dkHz_%s_LE_%d.pcm",  file_prefix,
                                                                       rec->rec_out_dev,
                                                                       rec->astream->outdev.audproc_nb_ch,
                                                                       (rec->astream->outdev.audproc_rate / 1000),
                                                                       (rec->astream->outdev.audproc_format == SND_PCM_FORMAT_S16_LE) ? "S16" : "S32",
                                                                       export_record_index);
#if 0
            /*create out file*/
            sprintf(rec->rec_file_name, "%s_%s_rec_start[%05u,%lu]_rec_stop[%05u,%lu].pcm", file_prefix,
                                                                                                    rec->rec_out_dev,
                                                                                                    (unsigned int)rec->rec_out_time_start_record.tv_sec,
                                                                                                    (unsigned long int)rec->rec_out_time_start_record.tv_nsec,
                                                                                                    (unsigned int)rec->rec_out_time_stop_record.tv_sec,
                                                                                                    (unsigned long int)rec->rec_out_time_stop_record.tv_nsec);
#endif

            pr_debug("record file:%s\n",rec->rec_file_name);

            /* replace ":" charactere with "_"*/
            pfound = strpbrk (rec->rec_file_name, key);
            while (pfound != NULL)
            {
                *pfound = 0x5F;  /* "_" */
                pfound = strpbrk (pfound+1,key);
            }
        }

        if(export_pb_as_wave_format)
        {
            /*create out file:
                "prefix"_"devicename"_"x"ch_"y"kHz_%s_LE_"index".wav
            */
            sprintf(rec->rec_file_name, "%s_%s_%dch_%dkHz_%s_LE_%d.wav",  file_prefix,
                                                                       rec->rec_out_dev,
                                                                       rec->astream->outdev.audproc_nb_ch,
                                                                       (rec->astream->outdev.audproc_rate / 1000),
                                                                       (rec->astream->outdev.audproc_format == SND_PCM_FORMAT_S16_LE) ? "S16" : "S32",
                                                                       export_record_index);
#if 0
           /*create out file*/
            sprintf(rec->rec_file_name, "%s_%s_rec_start[%05u,%lu]_rec_stop[%05u,%lu].wav", file_prefix,
                                                                                                    rec->rec_out_dev,
                                                                                                    (unsigned int)rec->rec_out_time_start_record.tv_sec,
                                                                                                    (unsigned long int)rec->rec_out_time_start_record.tv_nsec,
                                                                                                    (unsigned int)rec->rec_out_time_stop_record.tv_sec,
                                                                                                    (unsigned long int)rec->rec_out_time_stop_record.tv_nsec);
#endif

            pr_debug("record file:%s\n",rec->rec_file_name);

            /* replace ":" charactere with "_"*/
            pfound = strpbrk (rec->rec_file_name, key);
            while (pfound != NULL)
            {
                *pfound = 0x5F;  /* "_" */
                pfound = strpbrk (pfound+1,key);
            }


            /* wave infos structure */
            wav_infos.num_bytes            = rec->wr_data_out_ptr ;
            pr_message("write %d_Bytes in pb_record_file:%s", wav_infos.num_bytes , rec->rec_file_name? rec->rec_file_name: "NOT_DEFINED");

            wav_infos.sample_rate          = rec->astream->outdev.audproc_rate;
            if(rec->astream->outdev.audproc_format == SND_PCM_FORMAT_S16_LE)
                wav_infos.bytes_per_sample = 2;
            else if(rec->astream->indev.audproc_format == SND_PCM_FORMAT_S32_LE || rec->astream->indev.audproc_format == SND_PCM_FORMAT_S24_LE )
                wav_infos.bytes_per_sample = 4;
            wav_infos.num_channels         = rec->astream->outdev.audproc_nb_ch;
            wav_infos.num_samples          = wav_infos.num_bytes / wav_infos.bytes_per_sample ;

            pr_message("************** print wav header infos ***************\n");
            pr_message("wav_infos.num_bytes         : %d\n", wav_infos.num_bytes );
            pr_message("wav_infos.sample_rate       : %d\n", wav_infos.sample_rate );
            pr_message("wav_infos.bytes_per_sample  : %d\n", wav_infos.bytes_per_sample );
            pr_message("wav_infos.num_channels      : %d\n", wav_infos.num_channels );
            pr_message("wav_infos.num_samples       : %d\n", wav_infos.num_samples );
            pr_message("************** print wav header infos ***************\n");

            /* create wave file */
            audproc_write_wav(rec->rec_file_name, &wav_infos, rec->AudRamBufChannels_out);
        }
        else
        {

            rec->file_out_pcm = fopen (rec->rec_file_name,"a");
            if(!rec->file_out_pcm)
            {
                pr_warning("could not open record file:%s\n", rec->rec_file_name);
                return;
            }
            fseek(rec->file_out_pcm, 0, SEEK_SET);

            /* now export data to file */
            unsigned int wr_pt = 0;
            size_t bpc = 0;
            if(rec->astream->outdev.audproc_format == SND_PCM_FORMAT_S16_LE)
                bpc = 2;
            else if(rec->astream->indev.audproc_format == SND_PCM_FORMAT_S32_LE || rec->astream->indev.audproc_format == SND_PCM_FORMAT_S24_LE )
                bpc = 4;

            while(wr_pt < rec->wr_data_out_ptr)
            {
                for (i = 0; i < rec->astream->outdev.audproc_nb_ch ; i++ )
                {
                    guint8* audio_out = rec->AudRamBufChannels_out[i];
                    if(audio_out)
                        rec->wdata = fwrite((void*)&audio_out[wr_pt], (size_t)1, bpc, rec->file_out_pcm);
                    else
                        pr_warning("audio channel_buffer_%d is invalid\n", i);
                }
                wr_pt = wr_pt + (guint)bpc;
            }

            pr_message("write %lu_Bytes in pb_record_file:%s", rec->wdata , rec->rec_file_name? rec->rec_file_name: "NOT_DEFINED");


            /* close now file handle */
            if(NULL != rec->file_out_pcm)
                fclose (rec->file_out_pcm);
        }
    }

    /* recover default setting */
    export_pb_as_wave_format = TRUE;

    return;
}


void audproc_audio_recording_export(audproc_source_type src_type, snd_pcm_stream_t stream_type)
{
    pr_message("request rec export src_type -> %d, stream_type -> %d \n", src_type, stream_type );

    switch(src_type)
    {
        case AUD_PROC_SRC_TYPE_VOICE:
        {
            if(stream_type == SND_PCM_STREAM_CAPTURE)
                audproc_audio_rts_handler_export_cap_dev_recording(&mic_rec_desc, D_MICRO_RECORD_FILE_IN_PCM);
            else
                audproc_audio_rts_handler_export_pb_dev_recording(&mic_rec_desc, D_MICRO_RECORD_FILE_OUT_PCM);

            break;
        }
        case AUD_PROC_SRC_TYPE_INFO:
        {
            if(stream_type == SND_PCM_STREAM_CAPTURE)
                audproc_audio_rts_handler_export_cap_dev_recording(&info_rec_desc, D_INFO_RECORD_FILE_IN_PCM);
            else
                audproc_audio_rts_handler_export_pb_dev_recording(&info_rec_desc, D_INFO_RECORD_FILE_OUT_PCM);

            break;
        }
        case AUD_PROC_SRC_TYPE_ENT:
        default:
        {
            if(stream_type == SND_PCM_STREAM_CAPTURE)
                audproc_audio_rts_handler_export_cap_dev_recording(&ent_rec_desc, D_ENT_RECORD_FILE_IN_PCM);
            else
                audproc_audio_rts_handler_export_pb_dev_recording(&ent_rec_desc, D_ENT_RECORD_FILE_OUT_PCM);

            break;
        }
    }

  return;
}

void audproc_audio_recording_init(void)
{


    pr_message("ENTERED\n");


    /* default export as wav file */
    export_cap_as_wave_format = TRUE;

    if(!ent_rec_desc.init)
    {

        memset(&ent_rec_desc,0 ,sizeof(record_desc));

        srec_stream_selec = getenv("AUDPROC_REC_ENT_STREAM_TO_FILE");

        if(srec_stream_selec)
        {
            pr_message("FEAT AUDPROC_REC_ENT_STREAM_TO_FILE = %s\n", srec_stream_selec);
        }

        if (!g_strcmp0(srec_stream_selec, "1"))  // record playback stream only
        {
            audproc_audio_rts_ent_rec_file_open();
            ent_rec_desc.out_rec_active = 1;
            ent_rec_desc.in_rec_active = 0;
            ent_rec_desc.init = 0;
        }
        else if (!g_strcmp0(srec_stream_selec, "2"))  // record capture stream only
        {
            audproc_audio_rts_ent_rec_file_open();
            ent_rec_desc.out_rec_active = 0;
            ent_rec_desc.in_rec_active = 1;
            ent_rec_desc.init = 0;
        }
        else if (!g_strcmp0(srec_stream_selec, "3"))  // record capture and playback
        {
            audproc_audio_rts_ent_rec_file_open();
            ent_rec_desc.out_rec_active = 1;
            ent_rec_desc.in_rec_active = 1;
            ent_rec_desc.init = 0;
        }

        else
        {
            /* no defined */

        }
    }


    if(!mic_rec_desc.init)
    {

        /* initialize module member variable  */
        memset(&mic_rec_desc,0 ,sizeof(record_desc));


        const char* sRec_mic_stream = getenv("AUDPROC_REC_MIC_STREAM_TO_FILE");

        if(sRec_mic_stream)
        {
            pr_message("FEAT AUDPROC_REC_MIC_STREAM_TO_FILE = %s\n", sRec_mic_stream);
        }

        if (!g_strcmp0(sRec_mic_stream, "1"))  // record playback stream only
        {
            audproc_audio_rts_mic_rec_file_open(); ;
            mic_rec_desc.out_rec_active = 1;
            mic_rec_desc.in_rec_active = 0;
            mic_rec_desc.init = 0;
        }
        else if (!g_strcmp0(sRec_mic_stream, "2"))  // record capture stream only
        {
            audproc_audio_rts_mic_rec_file_open();
            mic_rec_desc.out_rec_active = 0;
            mic_rec_desc.in_rec_active = 1;
            mic_rec_desc.init = 0;
        }
        else if (!g_strcmp0(sRec_mic_stream, "3"))  // record capture and playback
        {
            audproc_audio_rts_mic_rec_file_open(); ;
            mic_rec_desc.out_rec_active = 1;
            mic_rec_desc.in_rec_active = 1;
            mic_rec_desc.init = 0;
        }

        else
        {
            /* no defined */

        }
    }

    if(!info_rec_desc.init)
    {

        /* initialize module member variable  */
        memset(&info_rec_desc,0 ,sizeof(record_desc));


        const char* sRec_info_stream = getenv("AUDPROC_REC_INFO_STREAM_TO_FILE");

        if(sRec_info_stream)
        {
            pr_message("FEAT AUDPROC_REC_INFO_STREAM_TO_FILE = %s\n", sRec_info_stream);
        }

        if (!g_strcmp0(sRec_info_stream, "1"))  // record playback stream only
        {
            audproc_audio_rts_info_rec_file_open(); ;
            info_rec_desc.out_rec_active = 1;
            info_rec_desc.in_rec_active = 0;
            info_rec_desc.init = 0;
        }
        else if (!g_strcmp0(sRec_info_stream, "2"))  // record capture stream only
        {
            audproc_audio_rts_info_rec_file_open();
            info_rec_desc.out_rec_active = 0;
            info_rec_desc.in_rec_active = 1;
            info_rec_desc.init = 0;
        }
        else if (!g_strcmp0(sRec_info_stream, "3"))  // record capture and playback
        {
            audproc_audio_rts_info_rec_file_open(); ;
            info_rec_desc.out_rec_active = 1;
            info_rec_desc.in_rec_active = 1;
            info_rec_desc.init = 0;
        }

        else
        {
            /* no defined */

        }
    }

    export_record_index = 0;

    return;
}

void audproc_audio_recording_next_record(void)
{
    export_record_index++;
    return;
}
