/*******************************************************************************
* FILE : audproc-configuration.c
*
* SW-COMPONENT :
*
* DESCRIPTION :
*
* AUTHOR : Patrick Rey
*
* COPYRIGHT : (C)
*
* HISTORY : 07.08.2015
* Initial version
*******************************************************************************/





/*******************************************************************************
              GENERATED CODE HEADERS
*******************************************************************************/

#include <glib/gi18n.h>
#include <glib-object.h>
#include <sched.h>
#include "audproc-common-defs.h"
#include "audproc-object.h"
#include "audproc-apl-handler.h"
#include "audproc-alsa.h"
#include "audproc-service.h"
#include "audproc-configuration.h"
#include "audproc-configuration-data.h"
#include "audproc-datapool-access.h"
#include "audproc-audio-rts-handler.h"

/* Needed for Trace */
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "audproc-audioprocess-trace.h"
#include "etg_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AUDPROC_CONFIG
#include "trcGenProj/Header/audproc-configuration.c.trc.h"
#endif

/*******************************************************************************
              DEFINES
*******************************************************************************/
#define     D_AUDPROC_CFG_FILE "/etc/audio/audproc.cfg"
#define     LINE_SIZE_MAX 500
static const gint32 AR_CFG_INIT_VALUE       = (gint32)-1;
static const gint16 AR_CFG_INIT_VALUE_I16   = (gint16)-1;
static const gint8  AR_CFG_INIT_VALUE_I8   = (gint8)-1;
#define     AR_CFG_SR_48       (gint32)48000
#define     AR_CFG_SR_16       (gint32)16000
#define     AR_CFG_INIT_TO_MAX_MS  (gint16)1000
#define     D_BINDING_SUPPORT_DISABLED

static char*        str_ar_search = "ar.";
static char*        str_cfg_start = "{";
static char*        str_cfg_end = "}";
static char*        str_ar_devin = "dev_in";
static char*        str_ar_devout = "dev_out";
static char*        str_ar_devlp = "dev_lp";
static char*        str_ar_sr = "sample_rate";
static char*        str_ar_in_ps = "in_period_size";
static char*        str_ar_in_prefill = "in_prefill";
static char*        str_ar_in_stout = "in_start_tout";
static char*        str_ar_in_strtout = "in_stream_tout";
static char*        str_ar_out_ps = "out_period_size";
static char*        str_ar_out_prefill = "out_prefill";
static char*        str_ar_out_stout = "out_start_tout";
static char*        str_ar_out_strtout = "out_stream_tout";
static char*        str_ar_lp_ps = "lp_period_size";
static char*        str_ar_lp_prefill = "lp_prefill";
static char*        str_ar_lp_stout = "lp_start_tout";
static char*        str_ar_lp_strtout = "lp_stream_tout";
/*new*/
static char*        str_ar_in_pcm_format = "in_pcm_format";
static char*        str_ar_out_pcm_format = "out_pcm_format";
static char*        str_ar_lp_pcm_format = "lp_pcm_format";
/*new 14.09.2016*/
static char*        str_ar_proc_ps = "proc_period_size";
static char*        str_ar_fct_start_tout = "fct_start_tout";
/*new 10.01.2017*/
static char*        str_ar_in_create_on_start = "in_create_on_start";
static char*        str_ar_out_create_on_start = "out_create_on_start";
static char*        str_ar_lp_create_on_start = "lp_create_on_start";

/*******************************************************************************
              type definition
*******************************************************************************/
typedef struct _audproc_route_cfg
{
    char*               ar_name;
    guint8              source_id;
    char*               dev_in;
    char*               dev_out;
    char*               dev_lp;
    gint32              sample_rate;  // kHz
    gint32              in_period_size;  // ms
    gint32              in_prefill_ms; /* output prefill in ms*/
    gint16              in_startup_tout_ms; /* output prefill in ms*/
    gint16              in_stream_tout_ms; /* output prefill in ms*/
    snd_pcm_format_t    in_pcm_format;
    gint8               in_create_on_start;
    gint32              out_period_size;  // ms
    gint32              out_prefill_ms; /* output prefill in ms*/
    gint16              out_startup_tout_ms; /* output prefill in ms*/
    gint16              out_stream_tout_ms; /* output prefill in ms*/
    snd_pcm_format_t    out_pcm_format;
    gint8               out_create_on_start;
    gint32              lp_period_size;  // ms
    gint32              lp_prefill_ms; /* output prefill in ms*/
    gint16              lp_startup_tout_ms; /* output prefill in ms*/
    gint16              lp_stream_tout_ms; /* output prefill in ms*/
    snd_pcm_format_t    lp_pcm_format;
    gint8               lp_create_on_start;
    gint32              proc_period_size;  // ms
    glong               fct_start_audio_tout_ms;  // ms
}audproc_route_cfg;

typedef struct _audproc_cfg
{
    FILE*                       file_audproc_cfg;
    audproc_route_cfg*          ar_cfg_list;
    guint32                     ar_cfg_nb;
}audproc_cfg;




/*******************************************************************************
              static variable
*******************************************************************************/

static system_cfg sys_cfg;
static char data[LINE_SIZE_MAX];    /* Record read from the file.    */
static audproc_cfg  apc;
static gboolean is_audproc_cfg = FALSE;
static audproc_alsa_stream_cfg* audproc_cfg_new = (audproc_alsa_stream_cfg*)NULL;
static gboolean audproc_configuration_enable_reconfig_plausibility = FALSE;

/* table of audproc_ error codes */
static const AudioMode AUDPROC_AUDIO_MODE_table[] = {

 /* apl specifical error*/
  AUDPROC_AUDIO_MODE(D_AUDIO_MODE_CLASSIC),
  AUDPROC_AUDIO_MODE(D_AUDIO_MODE_CLASSIC_PREMIUM_1),
  AUDPROC_AUDIO_MODE(D_AUDIO_MODE_CLASSIC_PREMIUM_2),
  AUDPROC_AUDIO_MODE(D_AUDIO_MODE_AUDITORIUM),
  AUDPROC_AUDIO_MODE(D_AUDIO_MODE_AUDITORIUM_PREMIUM_1),
  AUDPROC_AUDIO_MODE(D_AUDIO_MODE_AUDITORIUM_PREMIUM_2),
  AUDPROC_AUDIO_MODE(D_AUDIO_MODE_PREMIUM),
  AUDPROC_AUDIO_MODE(D_AUDIO_MODE_EOL_RELOAD),
  AUDPROC_AUDIO_MODE(D_AUDIO_MODE_UNDEFINED),
};

#define AUDPROC_AUDIO_MODES ARRAYSIZE(AUDPROC_AUDIO_MODE_table)

const gchar *audproc_configuration_audio_mode_str(guint8 audiomode)
{
  unsigned int i;
  const AudioMode *pd;
  static const gchar audproc_unknown_audiomode[] = "Unknown AUDPROC audiomode";

  for (i = 0, pd = AUDPROC_AUDIO_MODE_table; i < AUDPROC_AUDIO_MODES; i++, pd++) {
    if (pd->audiomode == audiomode)
      return pd->str;
  }
  return audproc_unknown_audiomode;
}

/*******************************************************************************
*
* FUNCTION: audproc_configuration_get_configuration
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
static audproc_cfg_id audproc_configuration_get_configuration(guint8 src)
{
    struct _audproc_alsa_stream_cfg* p = (struct _audproc_alsa_stream_cfg*) NULL;

    p = audproc_configuration_get_route_cfg(src);
    if(!p)
    {
        pr_debug("no configuration available for source(%d)\n", src);
        return AUDPROC_CFG_DEFAULT;
    }

    pr_debug("found configuration(%d) for source(%d)\n",p->audcfg.audproc_aud_cfg_id, src);
    return p->audcfg.audproc_aud_cfg_id;
}

/*******************************************************************************
*
* FUNCTION: audproc_configuration_get_inst_name
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
const gchar* audproc_configuration_get_inst_name(guint8 src)
{
    struct _audproc_alsa_stream_cfg* pd = (struct _audproc_alsa_stream_cfg*) NULL;
    guint i ;

    for(i = 0, pd = sys_cfg.audcfg; i < sys_cfg.cfglength; i++, pd++)
    {
        if(pd->source_id == src)
        {
            if(!pd->available)
            {
                pr_debug("source(%d) is not available\n", src);
                return (gchar*)NULL;
            }

            pr_debug("src(%d) apl instance name is: %s\n",src, pd->audcfg.audproc_apl_inst_name);
            return pd->audcfg.audproc_apl_inst_name;
        }
    }

    return (gchar*)NULL;
}

/*******************************************************************************
*
* FUNCTION: audproc_service_get_param_infos
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
const struct aplParameter* audproc_configuration_get_param_infos(guint32 param_id)
{
    const struct aplParameter *p;
    unsigned int param_idx = 0;


    for(param_idx = 0, p = apl_parm_table; param_idx < APL_PARAM_TABLE_SIZE; param_idx++, p++)
    {
        if(p->apl_data_id == (gint)param_id)
            return p;
    }

    return (struct aplParameter*)NULL;
}

/*******************************************************************************
*
* FUNCTION: audproc_service_get_param_infos
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
const struct aplParameter* audproc_configuration_get_param_table(void)
{
    return (struct aplParameter*)apl_parm_table;
}

/*******************************************************************************
*
* FUNCTION: audproc_service_get_param_infos
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
guint audproc_configuration_get_param_table_size(void)
{
    pr_debug("number of configured parameter (%lu)\n", APL_PARAM_TABLE_SIZE);
    return (guint)APL_PARAM_TABLE_SIZE;
}


/*******************************************************************************
*
* FUNCTION: audproc_configuration_load_arkamys_configuration
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
static int audproc_configuration_load_arkamys_configuration(guint8 src)
{
    int                         err = AUDPROC_ERR_OK;
    audproc_alsa_stream_cfg*    pd = (audproc_alsa_stream_cfg*)NULL;
    gint32                      aplswitch = aplTRUE;
    guint32            u32value=0;
    AplState*                   aplinst =  (AplState*)NULL;

    pr_message("ENTERED\n");
    ETG_TRACE_USR3(("[audproc_configuration_load_arkamys_configuration]: ENTERED"));

    if(!src)
    {
        /* take default source */
        pd = audproc_configuration_get_route_cfg(AUD_PROC_SRC_ENT3);      /*-> auditorium configuration */
        if(!pd)
            pd = audproc_configuration_get_route_cfg(AUD_PROC_SRC_ENT5);    /*-> classic configuration */
    }
    else
        pd = audproc_configuration_get_route_cfg(src);

    if(!pd)
    {
        pr_warning("No configuration available \n");
        ETG_TRACE_USR1(("[audproc_configuration_load_arkamys_configuration]: No configuration available"));
        return AUDPROC_ERR_SRC_CFG_NOT_AVAILABLE;
    }

    /* create APL instance */
    aplinst = audproc_apl_handler_create_instance(APL_INSTANCE_STR_ARKAMYS_FCTS, APL_INIT_PREPARE_INST); //pd->audcfg.audproc_apl_inst_name, APL_INIT_PREPARE_INST);

    if(!aplinst)
    {
        pr_warning("fail while creating a new apl instance for the source APL_INSTANCE_STR_ARKAMYS_FCTS \n");
        ETG_TRACE_USR1(("[audproc_configuration_load_arkamys_configuration]: fail while creating a new apl instance for the source APL_INSTANCE_STR_ARKAMYS_FCTS"));
        return AUDPROC_ERR_SRC_CFG_NOT_AVAILABLE;
    }

    /* check instance state */
    if(aplinst->AplInitState == APL_INIT_FINALIZE_INST)
    {
        pr_debug("the initialization of this instance was already finalized\n");
        ETG_TRACE_USR1(("[audproc_configuration_load_arkamys_configuration]: the initialization of this instance was already finalized"));
        return AUDPROC_ERR_OK;
    }


    u32value = pd->proc_frame_size; //indev.audproc_period_frames;
    err = audproc_apl_handler_set_data(aplinst, aplFrameShiftIn, 0, sizeof(tAplU16),(void*) &u32value);

    if (!err)
    {
        u32value = pd->indev.audproc_rate;
        err = audproc_apl_handler_set_data(aplinst, aplSampleRateIn, 0, sizeof(tAplU16),(void*) &u32value);
    }

    if (!err)
    {
        u32value = pd->indev.audproc_nb_ch;
        err = audproc_apl_handler_set_data(aplinst, aplChannelCntIn, 0, sizeof(tAplU16),(void*) &u32value);
    }

    if (!err)
    {
        u32value = pd->indev.audproc_format;
        err = audproc_apl_handler_set_data(aplinst, aplAudioPcmFormatIn, 0, sizeof(tAplU16),(void*) &u32value);
    }


    if (!err)
    {
        u32value = pd->proc_frame_size; //outdev.audproc_period_frames;
        err = audproc_apl_handler_set_data(aplinst, aplFrameShiftOut, 0, sizeof(tAplU16),(void*) &u32value);
    }


    if (!err)
    {
        u32value = pd->outdev.audproc_rate;
        err = audproc_apl_handler_set_data(aplinst, aplSampleRateOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

        if (!err)
    {
        u32value = pd->outdev.audproc_nb_ch;
        err = audproc_apl_handler_set_data(aplinst, aplChannelCntOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

    if (!err)
    {
        u32value = pd->outdev.audproc_format;
        err = audproc_apl_handler_set_data(aplinst, aplAudioPcmFormatOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

    if (!err)
    {
        aplswitch = aplSwitchON;
        err = audproc_apl_handler_set_data(aplinst, aplArkamysSwitch, 0, sizeof(tAplI32),(void*) &aplswitch );

    }

    /* finalize apl initialization */
    err = audproc_apl_handler_initialize(APL_INSTANCE_STR_ARKAMYS_FCTS, NULL) ; //pd->audcfg.audproc_apl_inst_name, NULL);



    /* auditorium configuration is available */
    if(sys_cfg.audioMode == D_AUDIO_MODE_AUDITORIUM)
    {
        /*load eol data */
        if (!err)
        {
            guint32 size;
            unsigned char * eol_data = audproc_datapool_access_get_eol_dataset(&size);

            if(size && eol_data)
            {
                err = audproc_apl_handler_set_data(aplinst, aplArkamysEolData, 0, size,(void*)eol_data );

                /* send level loss */
                if(!err)
                {
                    pr_message("send level loss notification here\n");
                    err = audproc_service_send_notification(aplArkamysLevelLoss, APL_ACT_GET_PARAM);
                }
            }
            else
            {
                ETG_TRACE_USR1(("[audproc_configuration_load_arkamys_configuration]: no arkamys eol datapool available"));
                pr_warning("no arkamys eol datapool available\n");
            }
        }
    }
    else if(sys_cfg.audioMode == D_AUDIO_MODE_CLASSIC) /* classic */
    {
        /* set bypass  */
        if (!err)
        {
            aplswitch = aplSwitchON;
            err = audproc_apl_handler_set_data(aplinst, aplArkamysByPassActivate, 0, sizeof(tAplI32),(void*) &aplswitch );
        }
    }
    else
    {
        /* do nothing */
    }


    ETG_TRACE_USR3(("[audproc_configuration_load_arkamys_configuration]: EXIT"));

    return err ;
}

/*******************************************************************************
*
* FUNCTION: audproc_configuration_load_loopback_configuration
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
static int audproc_configuration_load_loopback_configuration(guint8 src)
{
    int                         err = AUDPROC_ERR_OK;
    audproc_alsa_stream_cfg*    pd = (audproc_alsa_stream_cfg*)NULL;
    gint32                      aplswitch = aplTRUE;
    guint32                     u32value = 0;
    AplState*                   aplinst =  (AplState*)NULL;

    pr_message("ENTERED\n");

    pd = audproc_configuration_get_route_cfg(src);

    if(!pd)
    {
        pr_debug("No configuration available for the source:%d\n", src);
        return AUDPROC_ERR_SRC_CFG_NOT_AVAILABLE;
    }


    /* create APL instance */
    aplinst = audproc_apl_handler_create_instance(APL_INSTANCE_STR_AUDIO_LOOPBACK_FCTS, APL_INIT_PREPARE_INST);


    if(!aplinst)
    {
        pr_debug("fail while creating a new apl instance for the source AUD_PROC_SRC_MICIN \n");
        return AUDPROC_ERR_SRC_CFG_NOT_AVAILABLE;
    }

    /* check instance state */
    if(aplinst->AplInitState == APL_INIT_FINALIZE_INST)
    {
        pr_debug("the initialization of this instance was already finalized\n");
        return AUDPROC_ERR_OK;
    }


    /* create instance pcm copy module */

    aplswitch = aplSwitchON;
    err = audproc_apl_handler_set_data(aplinst, aplPcmCopySwitch, 0, sizeof(tAplI32),(void*) &aplswitch );


    /* config stream parameter */

    if (!err)
    {
        u32value = pd->proc_frame_size;
        err = audproc_apl_handler_set_data(aplinst, aplPcmCopyFrameShiftOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

    if (!err)
    {
        u32value = pd->outdev.audproc_rate;
        err = audproc_apl_handler_set_data(aplinst, aplPcmCopyampleRateOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

        if (!err)
    {
        u32value = pd->outdev.audproc_nb_ch;
        err = audproc_apl_handler_set_data(aplinst, aplPcmCopyChannelCntOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

    if (!err)
    {
        u32value = pd->outdev.audproc_format;
        err = audproc_apl_handler_set_data(aplinst, aplPcmCopyAudioPcmFormatOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

    /* set binding properties */

    if (!err)
    {
       err = audproc_apl_handler_set_data(aplinst, aplAudioChannelBinding, 0, (unsigned int)(sizeof(tAplBinding) * pd->audbinding->bindingnb),(void*) &pd->audbinding->audbind );
    }

    if (!err)
    {
        err = audproc_apl_handler_set_data(aplinst, aplInRoutingChannelCnt, 0, (sizeof(tAplU8)),(void*) &pd->audbinding->inchannelnb );
    }

    if (!err)
    {
        err = audproc_apl_handler_set_data(aplinst, aplOutRoutingChannelCnt, 0, (sizeof(tAplU8)),(void*) &pd->audbinding->outchannelnb );
    }

    if (!err)
    {
        err = audproc_apl_handler_set_data(aplinst, aplNbBinding, 0, (sizeof(tAplU8)),(void*) &pd->audbinding->bindingnb );
    }


    /* finalize apl initialization */
    err = audproc_apl_handler_initialize(APL_INSTANCE_STR_AUDIO_LOOPBACK_FCTS, NULL);


    return err ;
}

/*******************************************************************************
*
* FUNCTION: audproc_configuration_load_ent_loopback_configuration
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
static int audproc_configuration_load_ent_loopback_configuration(guint8 src)
{
    int                         err = AUDPROC_ERR_OK;
    audproc_alsa_stream_cfg*    pd = (audproc_alsa_stream_cfg*)NULL;
    gint32                      aplswitch = aplTRUE;
    guint32                     u32value = 0;
    AplState*                   aplinst =  (AplState*)NULL;

    pr_message("ENTERED\n");

    pd = audproc_configuration_get_route_cfg(src);

    if(!pd)
    {
        pr_debug("No configuration available for the source:%d\n", src);
        return AUDPROC_ERR_SRC_CFG_NOT_AVAILABLE;
    }


    /* create APL instance */
    aplinst = audproc_apl_handler_create_instance(APL_INSTANCE_STR_AUDIO_ENT_LOOPBACK_FCTS, APL_INIT_PREPARE_INST);


    if(!aplinst)
    {
        pr_debug("fail while creating a new apl instance for the source AUD_PROC_SRC_MICIN \n");
        return AUDPROC_ERR_SRC_CFG_NOT_AVAILABLE;
    }

    /* check instance state */
    if(aplinst->AplInitState == APL_INIT_FINALIZE_INST)
    {
        pr_debug("the initialization of this instance was already finalized\n");
        return AUDPROC_ERR_OK;
    }


    /* create instance pcm copy module */

    aplswitch = aplSwitchON;
    err = audproc_apl_handler_set_data(aplinst, aplPcmCopySwitch, 0, sizeof(tAplI32),(void*) &aplswitch );


    /* config stream parameter */

    if (!err)
    {
        u32value = pd->proc_frame_size;
        err = audproc_apl_handler_set_data(aplinst, aplPcmCopyFrameShiftOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

    if (!err)
    {
        u32value = pd->outdev.audproc_rate;
        err = audproc_apl_handler_set_data(aplinst, aplPcmCopyampleRateOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

        if (!err)
    {
        u32value = pd->outdev.audproc_nb_ch;
        err = audproc_apl_handler_set_data(aplinst, aplPcmCopyChannelCntOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

    if (!err)
    {
        u32value = pd->outdev.audproc_format;
        err = audproc_apl_handler_set_data(aplinst, aplPcmCopyAudioPcmFormatOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

    /* set binding properties */

#ifndef D_BINDING_SUPPORT_DISABLED
    if (!err)
    {
        err = audproc_apl_handler_set_data(aplinst, aplAudioChannelBinding, 0, (sizeof(tAplBinding) * pd->audbinding->bindingnb),(void*) &pd->audbinding->audbind );
    }

    if (!err)
    {
        err = audproc_apl_handler_set_data(aplinst, aplInRoutingChannelCnt, 0, (sizeof(tAplU8)),(void*) &pd->audbinding->inchannelnb );
    }

    if (!err)
    {
        err = audproc_apl_handler_set_data(aplinst, aplOutRoutingChannelCnt, 0, (sizeof(tAplU8)),(void*) &pd->audbinding->outchannelnb );
    }

    if (!err)
    {
        err = audproc_apl_handler_set_data(aplinst, aplNbBinding, 0, (sizeof(tAplU8)),(void*) &pd->audbinding->bindingnb );
    }
#endif

    /* finalize apl initialization */
    err = audproc_apl_handler_initialize(APL_INSTANCE_STR_AUDIO_ENT_LOOPBACK_FCTS, NULL);


    return err ;
}

/*******************************************************************************
*
* FUNCTION: audproc_configuration_load_voice_loopback_configuration
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
static int audproc_configuration_load_voice_loopback_configuration(guint8 src)
{
    int                         err = AUDPROC_ERR_OK;
    audproc_alsa_stream_cfg*    pd = (audproc_alsa_stream_cfg*)NULL;
    gint32                      aplswitch = aplTRUE;
    guint32                     u32value = 0;
    AplState*                   aplinst =  (AplState*)NULL;

    pr_message("ENTERED\n");

    pd = audproc_configuration_get_route_cfg(src);

    if(!pd)
    {
        pr_debug("No configuration available for the source:%d\n", src);
        return AUDPROC_ERR_SRC_CFG_NOT_AVAILABLE;
    }


    /* create APL instance */
    aplinst = audproc_apl_handler_create_instance(APL_INSTANCE_STR_AUDIO_VOICE_LOOPBACK_FCTS, APL_INIT_PREPARE_INST);


    if(!aplinst)
    {
        pr_debug("fail while creating a new apl instance for the source AUD_PROC_SRC_MICIN \n");
        return AUDPROC_ERR_SRC_CFG_NOT_AVAILABLE;
    }

    /* check instance state */
    if(aplinst->AplInitState == APL_INIT_FINALIZE_INST)
    {
        pr_debug("the initialization of this instance was already finalized\n");
        return AUDPROC_ERR_OK;
    }


    /* create instance pcm copy module */

    aplswitch = aplSwitchON;
    err = audproc_apl_handler_set_data(aplinst, aplPcmCopySwitch, 0, sizeof(tAplI32),(void*) &aplswitch );


    /* config stream parameter */

    if (!err)
    {
        u32value = pd->proc_frame_size;
        err = audproc_apl_handler_set_data(aplinst, aplPcmCopyFrameShiftOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

    if (!err)
    {
        u32value= pd->outdev.audproc_rate;
        err = audproc_apl_handler_set_data(aplinst, aplPcmCopyampleRateOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

        if (!err)
    {
        u32value = pd->outdev.audproc_nb_ch;
        err = audproc_apl_handler_set_data(aplinst, aplPcmCopyChannelCntOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

    if (!err)
    {
        u32value = pd->outdev.audproc_format;
        err = audproc_apl_handler_set_data(aplinst, aplPcmCopyAudioPcmFormatOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

    /* set binding properties */

    if (!err)
    {
        err = audproc_apl_handler_set_data(aplinst, aplAudioChannelBinding, 0, (unsigned int)(sizeof(tAplBinding) * pd->audbinding->bindingnb),(void*) &pd->audbinding->audbind );
    }

    if (!err)
    {
        err = audproc_apl_handler_set_data(aplinst, aplInRoutingChannelCnt, 0, (sizeof(tAplU8)),(void*) &pd->audbinding->inchannelnb );
    }

    if (!err)
    {
        err = audproc_apl_handler_set_data(aplinst, aplOutRoutingChannelCnt, 0, (sizeof(tAplU8)),(void*) &pd->audbinding->outchannelnb );
    }

    if (!err)
    {
        err = audproc_apl_handler_set_data(aplinst, aplNbBinding, 0, (sizeof(tAplU8)),(void*) &pd->audbinding->bindingnb );
    }


    /* finalize apl initialization */
    err = audproc_apl_handler_initialize(APL_INSTANCE_STR_AUDIO_VOICE_LOOPBACK_FCTS, NULL);


    return err ;
}

/*******************************************************************************
*
* FUNCTION: audproc_configuration_load_info_loopback_configuration
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
static int audproc_configuration_load_info_loopback_configuration(guint8 src)
{
    int                         err = AUDPROC_ERR_OK;
    audproc_alsa_stream_cfg*    pd = (audproc_alsa_stream_cfg*)NULL;
    gint32                      aplswitch = aplTRUE;
    guint32                     u32value = 0;
    AplState*                   aplinst =  (AplState*)NULL;

    pr_message("ENTERED\n");

    pd = audproc_configuration_get_route_cfg(src);

    if(!pd)
    {
        pr_debug("No configuration available for the source:%d\n", src);
        return AUDPROC_ERR_SRC_CFG_NOT_AVAILABLE;
    }


    /* create APL instance */
    aplinst = audproc_apl_handler_create_instance(APL_INSTANCE_STR_AUDIO_INFO_LOOPBACK_FCTS, APL_INIT_PREPARE_INST); //pd->audcfg.audproc_apl_inst_name, APL_INIT_PREPARE_INST);


    if(!aplinst)
    {
        pr_debug("fail while creating a new apl instance for the source AUD_PROC_SRC_MICIN \n");
        return AUDPROC_ERR_SRC_CFG_NOT_AVAILABLE;
    }

    /* check instance state */
    if(aplinst->AplInitState == APL_INIT_FINALIZE_INST)
    {
        pr_debug("the initialization of this instance was already finalized\n");
        return AUDPROC_ERR_OK;
    }


    /* create instance pcm copy module */

    aplswitch = aplSwitchON;
    err = audproc_apl_handler_set_data(aplinst, aplPcmCopySwitch, 0, sizeof(tAplI32),(void*) &aplswitch );


    /* config stream parameter */

    if (!err)
    {
        u32value = pd->proc_frame_size;
        err = audproc_apl_handler_set_data(aplinst, aplPcmCopyFrameShiftOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

    if (!err)
    {
        u32value = pd->outdev.audproc_rate;
        err = audproc_apl_handler_set_data(aplinst, aplPcmCopyampleRateOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

        if (!err)
    {
        u32value = pd->outdev.audproc_nb_ch;
        err = audproc_apl_handler_set_data(aplinst, aplPcmCopyChannelCntOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

    if (!err)
    {
        u32value = pd->outdev.audproc_format;
        err = audproc_apl_handler_set_data(aplinst, aplPcmCopyAudioPcmFormatOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

    /* set binding properties */

#ifndef D_BINDING_SUPPORT_DISABLED
    if (!err)
    {
        err = audproc_apl_handler_set_data(aplinst, aplAudioChannelBinding, 0, (sizeof(tAplBinding) * pd->audbinding->bindingnb),(void*) &pd->audbinding->audbind );
    }

    if (!err)
    {
        err = audproc_apl_handler_set_data(aplinst, aplInRoutingChannelCnt, 0, (sizeof(tAplU8)),(void*) &pd->audbinding->inchannelnb );
    }

    if (!err)
    {
        err = audproc_apl_handler_set_data(aplinst, aplOutRoutingChannelCnt, 0, (sizeof(tAplU8)),(void*) &pd->audbinding->outchannelnb );
    }

    if (!err)
    {
        err = audproc_apl_handler_set_data(aplinst, aplNbBinding, 0, (sizeof(tAplU8)),(void*) &pd->audbinding->bindingnb );
    }
#endif


    /* finalize apl initialization */
    err = audproc_apl_handler_initialize(APL_INSTANCE_STR_AUDIO_INFO_LOOPBACK_FCTS, NULL);


    return err ;
}
/*******************************************************************************
*
* FUNCTION: audproc_configuration_load_micro_level_monitoring_configuration
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
static int audproc_configuration_load_micro_level_monitoring_configuration(guint8 src)
{
    int                         err = AUDPROC_ERR_OK;
    audproc_alsa_stream_cfg*    pd = (audproc_alsa_stream_cfg*)NULL;
    tAplI32                     aplswitch = aplSwitchON;
    tAplI16                     i16value = 0;
    tAplU32            u32value = 0;
    AplState*                   aplinst =  (AplState*)NULL;

    pr_debug("ENTERED\n");

    pd = audproc_configuration_get_route_cfg(src);

    if(!pd)
    {
        pr_debug("No configuration available for the source:%d\n", src);
        return AUDPROC_ERR_SRC_CFG_NOT_AVAILABLE;
    }

    int state = audproc_apl_handler_is_instance(APL_INSTANCE_STR_MICRO_LEVEL_MONITORING_FCTS);

    if(state == APL_NO_INST)
    {
        /* create APL instance */
        aplinst = audproc_apl_handler_create_instance(APL_INSTANCE_STR_MICRO_LEVEL_MONITORING_FCTS, APL_INIT_PREPARE_INST);

        if(!aplinst)
            return AUDPROC_ERR_SRC_CFG_NOT_AVAILABLE;
    }
    else
        aplinst = audproc_apl_handler_get_instance(APL_INSTANCE_STR_MICRO_LEVEL_MONITORING_FCTS);

    /******************
     * APL configuration
     */


    /* capture stream - IN */

    u32value = pd->proc_frame_size; //indev.audproc_period_frames;// 64;
    err = audproc_apl_handler_set_data(aplinst, aplFrameShiftIn, 0, sizeof(tAplU16),(void*) &u32value);

    if (!err)
    {
        u32value = pd->indev.audproc_rate;// 16000;
        err = audproc_apl_handler_set_data(aplinst, aplSampleRateIn, 0, sizeof(tAplU16),(void*) &u32value);
    }

    if (!err)
    {
        u32value = pd->indev.audproc_nb_ch;// 1;
        err = audproc_apl_handler_set_data(aplinst, aplChannelCntIn, 0, sizeof(tAplU16),(void*) &u32value);
    }

    if (!err)
    {
        u32value = pd->indev.audproc_format;// SND_PCM_FORMAT_S16_LE ;
        err = audproc_apl_handler_set_data(aplinst, aplAudioPcmFormatIn, 0, sizeof(tAplU16),(void*) &u32value);
    }

    /* playback stream - OUT */

    if (!err)
    {
        u32value = pd->proc_frame_size; //outdev.audproc_period_frames;// 64;
        err = audproc_apl_handler_set_data(aplinst, aplFrameShiftOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

    if (!err)
    {
        u32value = pd->outdev.audproc_rate;// 16000;
        err = audproc_apl_handler_set_data(aplinst, aplSampleRateOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

    if (!err)
    {
        u32value = pd->outdev.audproc_nb_ch;// 1
        err = audproc_apl_handler_set_data(aplinst, aplChannelCntOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

    if (!err)
    {
        u32value = pd->outdev.audproc_format;// SND_PCM_FORMAT_S16_LE
        err = audproc_apl_handler_set_data(aplinst, aplAudioPcmFormatOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

    /* module configuration */

    if (!err)
    {
        aplswitch = aplSwitchON;
        err = audproc_apl_handler_set_data(aplinst, aplMicLvlWatchSwitch, 0, sizeof(tAplI32),(void*) &aplswitch );
    }

    if (!err)
    {
        aplswitch = aplFALSE;
        err = audproc_apl_handler_set_data(aplinst, aplMicLvlWatchStartStop, 0, sizeof(tAplI32),(void*) &aplswitch );
    }

    if (!err)
    {
        aplswitch = (tAplI32)APL_OM_PROD_CONS;
        err = audproc_apl_handler_set_data(aplinst, aplMicLvlOperationMode, 0, sizeof(tAplI32),(void*) &aplswitch );
    }

    if (!err)
    {
        i16value = 0;
        err = audproc_apl_handler_set_data(aplinst, aplMicLvl, 0, sizeof(tAplI16),(void*) &i16value );
    }
    if (!err)
    {
        u32value = 200;
        err = audproc_apl_handler_set_data(aplinst, aplMicLvlWatchRefInt, 0, sizeof(tAplU16),(void*) &u32value);
    }


    /* finalize APL initialization */
    err = audproc_apl_handler_initialize(APL_INSTANCE_STR_MICRO_LEVEL_MONITORING_FCTS, NULL);

    pr_debug("EXIT\n");

    return err;
}


/*******************************************************************************
*
* FUNCTION: audproc_configuration_load_micro_level_measurement_configuration
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
static int audproc_configuration_load_micro_level_measurement_configuration(guint8 src)
{
    int                         err = AUDPROC_ERR_OK;
    audproc_alsa_stream_cfg*    pd = (audproc_alsa_stream_cfg*)NULL;
    tAplI32                     aplswitch = aplSwitchON;
    tAplI16                     i16value = 0;
    tAplU32            u32value = 0;
    AplState*                   aplinst =  (AplState*)NULL;

    pr_debug("ENTERED\n");

    pd = audproc_configuration_get_route_cfg(src);

    if(!pd)
    {
        pr_debug("No configuration available  AUD_PROC_SRC_MICIN \n");
        return AUDPROC_ERR_SRC_CFG_NOT_AVAILABLE;
    }

    int state = audproc_apl_handler_is_instance(APL_INSTANCE_STR_MICRO_MEASURE_FCTS);

    if(state == APL_NO_INST)
    {
        /* create APL instance */
        aplinst = audproc_apl_handler_create_instance(APL_INSTANCE_STR_MICRO_MEASURE_FCTS, APL_INIT_PREPARE_INST);

        if(!aplinst)
            return AUDPROC_ERR_SRC_CFG_NOT_AVAILABLE;
    }
    else
        aplinst = audproc_apl_handler_get_instance(APL_INSTANCE_STR_MICRO_MEASURE_FCTS);

    /******************
     * APL configuration
     */


    /* capture stream - IN */

    u32value = pd->indev.audproc_period_frames;// 64;
    err = audproc_apl_handler_set_data(aplinst, aplFrameShiftIn, 0, sizeof(tAplU16),(void*) &u32value);

    if (!err)
    {
        u32value = pd->indev.audproc_rate;// 16000;
        err = audproc_apl_handler_set_data(aplinst, aplSampleRateIn, 0, sizeof(tAplU16),(void*) &u32value);
    }

    if (!err)
    {
        u32value = pd->indev.audproc_nb_ch;// 1;
        err = audproc_apl_handler_set_data(aplinst, aplChannelCntIn, 0, sizeof(tAplU16),(void*) &u32value);
    }

    if (!err)
    {
        u32value = pd->indev.audproc_format;// SND_PCM_FORMAT_S16_LE ;
        err = audproc_apl_handler_set_data(aplinst, aplAudioPcmFormatIn, 0, sizeof(tAplU16),(void*) &u32value);
    }

    /* playback stream - OUT */

    if (!err)
    {
        u32value = pd->outdev.audproc_period_frames;// 64;
        err = audproc_apl_handler_set_data(aplinst, aplFrameShiftOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

    if (!err)
    {
        u32value = pd->outdev.audproc_rate;// 16000;
        err = audproc_apl_handler_set_data(aplinst, aplSampleRateOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

    if (!err)
    {
        u32value = pd->outdev.audproc_nb_ch;// 1
        err = audproc_apl_handler_set_data(aplinst, aplChannelCntOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

    if (!err)
    {
        u32value = pd->outdev.audproc_format;// SND_PCM_FORMAT_S16_LE
        err = audproc_apl_handler_set_data(aplinst, aplAudioPcmFormatOut, 0, sizeof(tAplU16),(void*) &u32value);
    }

    /* module configuration */

    if (!err)
    {
        aplswitch = aplSwitchON;
        err = audproc_apl_handler_set_data(aplinst, aplMicLvlWatchSwitch, 0, sizeof(tAplI32),(void*) &aplswitch );
    }

    if (!err)
    {
        aplswitch = aplFALSE;
        err = audproc_apl_handler_set_data(aplinst, aplMicLvlWatchStartStop, 0, sizeof(tAplI32),(void*) &aplswitch );
    }

    if (!err)
    {
        aplswitch = (tAplI32)APL_OM_CONS_ONLY;
        err = audproc_apl_handler_set_data(aplinst, aplMicLvlOperationMode, 0, sizeof(tAplI32),(void*) &aplswitch );
    }

    if (!err)
    {
        i16value = 0;
        err = audproc_apl_handler_set_data(aplinst, aplMicLvl, 0, sizeof(tAplI16),(void*) &i16value );
    }
    if (!err)
    {
        u32value = 200;
        err = audproc_apl_handler_set_data(aplinst, aplMicLvlWatchRefInt, 0, sizeof(tAplU16),(void*) &u32value);
    }


    /* finalize APL initialization */
    err = audproc_apl_handler_initialize(APL_INSTANCE_STR_MICRO_MEASURE_FCTS, NULL);

    pr_debug("EXIT\n");

    return err;
}

#define D_START_PERIOD_SIZE 64
#define D_START_PERIOD_SIZE_INC 32
#define D_LAST_PERIOD_SIZE 1024


static gboolean audproc_configuration_resize_period( int* in_period)
{
    int v_tmp, v_diff, v_near;
    int h_per, per_check, v_prev ;
    gboolean change = FALSE;

    v_tmp = 0;

    if(!in_period)
        return FALSE;

    h_per = v_prev = *in_period;

    /* exception value */
    if(h_per ==  160)
        return FALSE;



    if(h_per < D_START_PERIOD_SIZE)
    {
        h_per  = D_START_PERIOD_SIZE;
        change =  TRUE;
    }


    if(!change)
    {

        /* check plausibility value of the period_size */
        per_check = D_START_PERIOD_SIZE;

        while(per_check <= D_LAST_PERIOD_SIZE)
        {

            //pr_debug("per_check(%d),h_per(%d), v_prev(%d)\n", per_check, h_per, v_prev );
            if(per_check  == h_per)
            {
                change = FALSE;
                break;
            }
            else if(per_check > h_per)
            {
                if(!v_tmp)
                {
                    h_per = per_check;
                    change = TRUE;
                    break;
                }
                else
                {
                    v_diff = per_check - v_tmp;
                    v_near = per_check %  h_per;
                    if((v_diff /2 ) > v_near)
                        h_per = per_check;
                    else
                        h_per = v_tmp;

                    change = TRUE;
                    //pr_debug("v_near(%d),v_diff(%d),per_check(%d),v_tmp(%d)\n", v_near, v_diff, per_check, v_tmp );
                    break;
                }
            }
            else
                v_tmp = per_check;

            per_check += D_START_PERIOD_SIZE_INC;
        }
    }

    *in_period = h_per;

    if(change)
    {
        pr_debug("change period (%d) to (%d)\n", v_prev, h_per );
    }
    else
    {
        pr_debug("period (%d) is available\n", v_prev);
    }
    return change;
}

static void audproc_configuration_init_audproc_cfg(audproc_route_cfg** p) /*todo*/
{
    audproc_route_cfg* ar = *p;

    ar->ar_name                 = (char*)NULL;
    ar->source_id               = AUD_PROC_SRC_DEFAULT;
    pr_debug("source_id init value set to %d\n", ar->source_id);
    ar->dev_in                  = (char*)NULL;
    ar->dev_out                 = (char*)NULL;
    ar->dev_lp                  = (char*)NULL;
    ar->sample_rate             = AR_CFG_INIT_VALUE;
    pr_debug("sample_rate init value set to %d\n", ar->sample_rate);
    ar->in_period_size          = AR_CFG_INIT_VALUE;
    ar->in_prefill_ms           = AR_CFG_INIT_VALUE;
    ar->in_startup_tout_ms      = AR_CFG_INIT_VALUE_I16;
    ar->in_stream_tout_ms       = AR_CFG_INIT_VALUE_I16;
    pr_debug("in_startup_tout_ms init value set to %d\n", ar->in_startup_tout_ms);
    ar->in_pcm_format           = SND_PCM_FORMAT_UNKNOWN;
    ar->in_create_on_start      = AR_CFG_INIT_VALUE_I8;
    pr_debug("in_pcm_format init value set to %d\n", ar->in_pcm_format);
    ar->out_period_size         = AR_CFG_INIT_VALUE;
    ar->out_prefill_ms          = AR_CFG_INIT_VALUE;
    ar->out_startup_tout_ms     = AR_CFG_INIT_VALUE_I16;
    ar->out_stream_tout_ms      = AR_CFG_INIT_VALUE_I16;
    ar->out_pcm_format          = SND_PCM_FORMAT_UNKNOWN;
    ar->out_create_on_start     = AR_CFG_INIT_VALUE_I8;
    ar->lp_period_size          = AR_CFG_INIT_VALUE;
    ar->lp_prefill_ms           = AR_CFG_INIT_VALUE;
    ar->lp_startup_tout_ms      = AR_CFG_INIT_VALUE_I16;
    ar->lp_stream_tout_ms       = AR_CFG_INIT_VALUE_I16;
    ar->lp_pcm_format           = SND_PCM_FORMAT_UNKNOWN;
    ar->lp_create_on_start      = AR_CFG_INIT_VALUE_I8;
    ar->proc_period_size        = AR_CFG_INIT_VALUE;
    ar->fct_start_audio_tout_ms = AR_CFG_INIT_VALUE;

    return;
}


static void audproc_configuration_check_new_audproc_cfg(audproc_route_cfg** p)
{
    audproc_route_cfg* ar = *p;
    int v_tmp;

    ETG_TRACE_USR4(("[audproc_configuration_check_new_audproc_cfg]: ENTERED"));

    //ar->ar_name       = (char*)NULL;
    if( ar->source_id == AUD_PROC_SRC_ENT1
        ||ar->source_id == AUD_PROC_SRC_ENT2
        ||ar->source_id == AUD_PROC_SRC_ENT3
        ||ar->source_id == AUD_PROC_SRC_ENT4
        ||ar->source_id == AUD_PROC_SRC_ENT5
        ||ar->source_id == AUD_PROC_SRC_ENT6
        ||ar->source_id == AUD_PROC_SRC_ENT7
        ||ar->source_id == AUD_PROC_SRC_ENT8
        ||ar->source_id == AUD_PROC_SRC_ENT9
        ||ar->source_id == AUD_PROC_SRC_ENT10
        ||ar->source_id == AUD_PROC_SRC_ENT11
        ||ar->source_id == AUD_PROC_SRC_ENT12
        ||ar->source_id == AUD_PROC_SRC_ENT13
        ||ar->source_id == AUD_PROC_SRC_ENT14
        ||ar->source_id == AUD_PROC_SRC_ENT15
        ||ar->source_id == AUD_PROC_SRC_ENT16
        ||ar->source_id == AUD_PROC_SRC_ENT17
        ||ar->source_id == AUD_PROC_SRC_MICIN_1
        ||ar->source_id == AUD_PROC_SRC_MICIN_2
        ||ar->source_id == AUD_PROC_SRC_VOICE1
        ||ar->source_id == AUD_PROC_SRC_LOOPBACK)
    {
        pr_debug("new configuration for route: %d\n", ar->source_id);
    }
    else
    {
        pr_debug("route id (%d) not available, this route is disabled \n", ar->source_id);
        ar->source_id = AUD_PROC_SRC_DEFAULT;
    }

    if(!ar->dev_in)
    {
        pr_debug("capture device not changed \n");
    }
    else
    {
        pr_debug("set capture device name (%s)\n", ar->dev_in);
    }

    if(!ar->dev_out)
    {
        pr_debug("playback device not changed \n");
    }
    else
    {
        pr_debug("set playback device name (%s)\n", ar->dev_out);
    }

    if(!ar->dev_lp)
    {
        pr_debug("loopback device not changed \n");
    }
    else
    {
        pr_debug("set loopback device name (%s)\n", ar->dev_lp);
    }


    if(    ar->sample_rate != AR_CFG_INIT_VALUE
        && ar->sample_rate != AR_CFG_SR_48
        && ar->sample_rate != AR_CFG_SR_16)
    {
        /* support only SR 48kHz*/
        pr_debug("force sample rate from (%d) to default value (%d) \n", ar->sample_rate, AR_CFG_SR_48);
        ar->sample_rate = AR_CFG_SR_48;
    }

    /* check format */
    if(ar->in_pcm_format == SND_PCM_FORMAT_UNKNOWN)
    {
        pr_debug("capture device format (%d) not changed  \n", ar->in_pcm_format);
    }
    else if(   ar->in_pcm_format != SND_PCM_FORMAT_S16_LE
            && ar->in_pcm_format != SND_PCM_FORMAT_S32_LE
            && ar->in_pcm_format != SND_PCM_FORMAT_S24_LE)
    {
        pr_debug("set capture device from set value(%d) to default format(%d)\n", ar->in_pcm_format, SND_PCM_FORMAT_S32_LE);
        ar->in_pcm_format = SND_PCM_FORMAT_S32_LE;
    }
    else
    {
        pr_debug("capture device format is: %d\n", ar->in_pcm_format);
    }

    if(ar->out_pcm_format == SND_PCM_FORMAT_UNKNOWN)
    {
        pr_debug("playback device format (%d) not changed  \n", ar->out_pcm_format);
    }
    else if(   ar->out_pcm_format != SND_PCM_FORMAT_S16_LE
            && ar->out_pcm_format != SND_PCM_FORMAT_S32_LE)
    {
        pr_debug("set playback device from set value(%d) to default format(%d)\n", ar->out_pcm_format, SND_PCM_FORMAT_S32_LE);
        ar->out_pcm_format = SND_PCM_FORMAT_S32_LE;
    }
    else
    {
        pr_debug("playback device format is: %d\n", ar->out_pcm_format);
    }

    if(ar->lp_pcm_format == SND_PCM_FORMAT_UNKNOWN)
    {
        pr_debug("loopaback device format (%d) not changed  \n", ar->lp_pcm_format);
    }
    else if(   ar->lp_pcm_format != SND_PCM_FORMAT_S16_LE
            && ar->lp_pcm_format != SND_PCM_FORMAT_S32_LE)
    {
        pr_debug("set loopback device from set value(%d) to default format(%d)\n", ar->lp_pcm_format, SND_PCM_FORMAT_S32_LE);
        ar->lp_pcm_format = SND_PCM_FORMAT_S32_LE;
    }
    else
    {
        pr_debug("loopaback device format is: %d\n", ar->lp_pcm_format);
    }


    /* check init time out */
    if(  ar->in_startup_tout_ms == AR_CFG_INIT_VALUE)
    {
        pr_debug("init time out (%d) capture device not changed\n",ar->in_startup_tout_ms );
    }
    else if(ar->in_startup_tout_ms > AR_CFG_INIT_TO_MAX_MS)
    {
        pr_debug("init time out capture device required config(%d) change to (%d)\n", ar->in_startup_tout_ms, 50);
        ar->in_startup_tout_ms = 50;
    }
    else
    {
        pr_debug("capture device init time out is: %d\n", ar->in_startup_tout_ms);
    }

    if(ar->out_startup_tout_ms == AR_CFG_INIT_VALUE)
    {
        pr_debug("init time out (%d) playback device not changed\n",ar->out_startup_tout_ms );
    }
    else if(ar->out_startup_tout_ms > AR_CFG_INIT_TO_MAX_MS)
    {
        pr_debug("init time out playback device required config(%d) change to (%d)\n", ar->out_startup_tout_ms, 50);
        ar->out_startup_tout_ms = 50;
    }
    else
    {
        pr_debug("playback device init time out is: %d\n", ar->out_startup_tout_ms);
    }

    if(ar->lp_startup_tout_ms == AR_CFG_INIT_VALUE)
    {
        pr_debug("init time out (%d) loopback device not changed\n",ar->lp_startup_tout_ms );
    }
    else if(ar->lp_startup_tout_ms > AR_CFG_INIT_TO_MAX_MS)
    {
        pr_debug("init time out loopback device required config(%d) change to (%d)\n", ar->lp_startup_tout_ms, 50);
        ar->lp_startup_tout_ms = 50;
    }
    else
    {
        pr_debug("loopback device init time out is: %d\n", ar->lp_startup_tout_ms);
    }

    if(ar->in_period_size == AR_CFG_INIT_VALUE )
    {
        pr_debug("period size capture device not changed\n");
    }
    else
    {
        if(ar->out_period_size != AR_CFG_INIT_VALUE)
        {
            v_tmp = ar->in_period_size;

            if(audproc_configuration_resize_period(&ar->in_period_size))
            {
                pr_critical("********* readjust new configuration for route: %d **************\n", ar->source_id);
                pr_critical("change capture device period size from (%d) to (%d)\n", v_tmp, ar->in_period_size);
            }

            v_tmp = ar->out_period_size;

            if(audproc_configuration_resize_period(&ar->out_period_size))
            {
                pr_critical("********* readjust new configuration for route: %d **************\n", ar->source_id);
                pr_critical("change capture device period size from (%d) to (%d)\n", v_tmp, ar->out_period_size);
            }

            if(ar->out_period_size == ar->in_period_size)
            {
                pr_debug("set capture device periode and playback device periode size to : %d\n", ar->out_period_size);
            }
            else if(   (ar->out_period_size > ar->in_period_size)
                    && (ar->out_period_size % ar->in_period_size)!= 0)
            {
                pr_critical("********* readjust new configuration for route: %d **************\n", ar->source_id);
                pr_critical("capture(%d) and playback(%d) device period size are not entire to each other\n", ar->in_period_size, ar->out_period_size);
            }
            else if(   (ar->in_period_size > ar->out_period_size)
                    && (ar->in_period_size % ar->out_period_size)!= 0)
            {
                pr_critical("********* readjust new configuration for route: %d **************\n", ar->source_id);
                pr_critical("capture(%d) and playback(%d) device period size are not entire to each other\n", ar->in_period_size, ar->out_period_size);
            }
            else
            {
                /*td*/
            }
        }
        else
        {
            pr_debug("capture periode size not changed \n" );
        }
    }

    if(ar->in_prefill_ms == AR_CFG_INIT_VALUE)
    {
        pr_debug("prefill capture device not changed\n");
    }

    if(ar->out_period_size == AR_CFG_INIT_VALUE)
    {
        pr_debug("period size playback device not changed\n");
    }

    if(ar->out_prefill_ms == AR_CFG_INIT_VALUE)
    {
        pr_debug("prefill playback device not changed\n");
    }

    if(ar->lp_period_size == AR_CFG_INIT_VALUE)
    {
        pr_debug("period size loopback device not changed\n");
    }

    if(ar->lp_prefill_ms == AR_CFG_INIT_VALUE)
    {
        pr_debug("prefill loopback device not changed\n");
    }

    return;
}


static gboolean audproc_configuration_parse_audproc_cfg(void)
{

    guint32 ar_cnt = 0;
    char strtest[100];
    audproc_route_cfg* ar = (audproc_route_cfg*)NULL;
    gboolean ar_cfg_found = FALSE;
    gboolean ar_cfg_start = FALSE;
    char *string_ptr_1 = (char*)NULL;
    char *string_ptr_2 = (char*)NULL;

    pr_debug("ENTERED\n");

    /* open input test file */
    apc.file_audproc_cfg = fopen (D_AUDPROC_CFG_FILE,"r");

    if(!apc.file_audproc_cfg)
    {
        pr_warning("No configurationfile available\n");
        return FALSE;
    }

    fseek(apc.file_audproc_cfg, 0, SEEK_SET);

    apc.ar_cfg_nb = 0;

    while (feof(apc.file_audproc_cfg) == 0)
    {
        fgets(data, LINE_SIZE_MAX, apc.file_audproc_cfg);  /* Read next record      */
        {
            if(NULL != strstr(data, "#ar."))
            {
                /* config commented out */
                pr_message("the configuration was disabled with character #\n");
            }
            else if( NULL != strstr(data, str_ar_search))
            {
                apc.ar_cfg_nb++;
            }
            else
            {
                /* do nothing */
            }
            memset(data,0, LINE_SIZE_MAX);
        }
    }

    pr_debug("number of audio route configuration entries: %d\n", apc.ar_cfg_nb);

    /* parse and store configuration data */

    apc.ar_cfg_list = (audproc_route_cfg*)g_malloc0(apc.ar_cfg_nb * sizeof(audproc_route_cfg));


    fseek(apc.file_audproc_cfg, 0, SEEK_SET);

    if(apc.ar_cfg_list)
    {
        ar = &apc.ar_cfg_list[0];

        pr_debug("parse configuration route : %d\n", 0);

        audproc_configuration_init_audproc_cfg(&ar); /*todo*/

        while(feof(apc.file_audproc_cfg) == 0)
        {

            fgets(data, LINE_SIZE_MAX, apc.file_audproc_cfg);  /* Read next record      */
            {
                if( NULL != strstr(data, str_ar_search))
                {
                    string_ptr_1 = strtok (data,". ");
                    string_ptr_2 = strtok (NULL," #");
                    ar->ar_name = strdup(string_ptr_2);

                    if(!string_ptr_1)
                    {
                        pr_warning("invalid configuratin audioroute item syntax, should be \"ar. + route name e.g AUD_PROC_SRC_ENT1\"\n");
                    }
                    else if(NULL != strstr(string_ptr_1, "#"))
                    {
                        pr_warning("this a comment line \n");
                    }
                    else if(ar->ar_name)
                    {
                        ar_cfg_found = TRUE;


                        if(!string_ptr_2)
                        {
                            pr_warning("route name is missing\n");
                        }
                        else
                        {
                            pr_message("start new audio route configuration for audioroute -> %s\n", ar->ar_name);// string_ptr_2);
                            ar->source_id = audproc_service_str_src(ar->ar_name); //string_ptr_2);
                        }
                    }
                    else
                    {
                        pr_warning("invalid string \"%s\"\n", string_ptr_1);
                    }
                }
                else if( ar_cfg_found && (NULL != strstr(data, str_cfg_start)))
                {
                    ar_cfg_start = TRUE;
                    pr_message("start new audio route configuration for source_id(%d)\n", ar->source_id);
                    continue;
                }

                /**********************************************************
                 * here the audio routing table configuration is retrieved
                 **********************************************************/
                if(ar_cfg_start)
                {
                    memset(strtest, 0 , 100);
                    string_ptr_1 = strtok (data,": ");
                    string_ptr_2 = strtok (NULL," #(");

                    if(!string_ptr_1)
                    {
                        pr_warning("invalid parameter string\n");
                    }
                    else if(NULL != strstr(string_ptr_1, "#"))
                    {
                        pr_warning("this is a comment line \n");
                    }
                    else if(NULL != strstr(string_ptr_1, str_ar_devin))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }

                        sscanf(string_ptr_2,"%s", strtest );
                        ar->dev_in = g_strdup(strtest);
                        if(ar->dev_in)
                        {
                            pr_debug("dev_in:%s\n", ar->dev_in );
                        }
                    }
                    else if (NULL != strstr(string_ptr_1, str_ar_devout))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }
                        sscanf(string_ptr_2,"%s", strtest );
                        ar->dev_out = g_strdup(strtest);
                        if(ar->dev_out)
                            pr_debug("dev_out:%s\n", ar->dev_out );
                    }
                    else if(NULL != strstr(string_ptr_1, str_ar_devlp))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }
                        sscanf(string_ptr_2,"%s", strtest );
                        ar->dev_lp = g_strdup(strtest);
                        if(ar->dev_lp)
                            pr_debug("dev_lp:%s\n", ar->dev_lp );
                    }
                    else if(NULL != strstr(string_ptr_1, str_ar_sr))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }
                        sscanf(string_ptr_2,"%d", &ar->sample_rate);
                        pr_debug("proc_sample_rate: %d\n", ar->sample_rate );
                    }
                    else if(NULL != strstr(string_ptr_1, str_ar_in_ps))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }
                        sscanf(string_ptr_2,"%d", &ar->in_period_size);
                        pr_debug("in_period_size: %d\n", ar->in_period_size );
                    }
                    else if(NULL != strstr(string_ptr_1, str_ar_in_prefill))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }
                        sscanf(string_ptr_2,"%d", &ar->in_prefill_ms);
                        pr_debug("in_prefill_ms: %d\n", ar->in_prefill_ms );
                    }
                    else if(NULL != strstr(string_ptr_1, str_ar_in_stout))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }
                        //sscanf(string_ptr_2,"%d", &ar->in_startup_tout_ms);
                        sscanf(string_ptr_2,"%hi", &ar->in_startup_tout_ms);
                        //pr_debug("in_startup_tout_ms: %hi\n", ar->in_startup_tout_ms );
                        pr_debug("in_startup_tout_ms: %d\n", ar->in_startup_tout_ms );
                    }
                    else if(NULL != strstr(string_ptr_1, str_ar_in_strtout))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }
                        sscanf(string_ptr_2,"%hi", &ar->in_stream_tout_ms);
                        pr_debug("in_stream_tout_ms: %d\n", ar->in_stream_tout_ms );
                        ETG_TRACE_USR4(("[audproc_configuration_parse_audproc_cfg]: in_stream_tout_ms: %d\n", ar->in_stream_tout_ms ));
                    }
                    else if(NULL != strstr(string_ptr_1, str_ar_out_ps))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }
                        sscanf(string_ptr_2,"%d", &ar->out_period_size);
                        pr_debug("out_period_size: %d\n", ar->out_period_size );
                    }
                    else if(NULL != strstr(string_ptr_1, str_ar_out_prefill))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }
                        sscanf(string_ptr_2,"%d", &ar->out_prefill_ms);
                        pr_debug("out_prefill_ms: %d\n", ar->out_prefill_ms );
                    }
                    else if(NULL != strstr(string_ptr_1, str_ar_out_stout))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }
                        //sscanf(string_ptr_2,"%hi", &ar->out_startup_tout_ms);
                        sscanf(string_ptr_2,"%hi", &ar->out_startup_tout_ms); //short integer specifier
                        pr_debug("out_startup_tout_ms: %d\n", ar->out_startup_tout_ms );
                    }
                    else if(NULL != strstr(string_ptr_1, str_ar_out_strtout))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }
                        sscanf(string_ptr_2,"%hi", &ar->out_stream_tout_ms);
                        pr_debug("out_stream_tout_ms: %d\n", ar->out_stream_tout_ms );
                        ETG_TRACE_USR4(("[audproc_configuration_parse_audproc_cfg]: out_stream_tout_ms: %d\n", ar->out_stream_tout_ms));
                    }
                    else if(NULL != strstr(string_ptr_1, str_ar_lp_ps))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }
                        sscanf(string_ptr_2,"%d", &ar->lp_period_size);
                        pr_debug("lp_period_size: %d\n", ar->lp_period_size );
                    }
                    else if(NULL != strstr(string_ptr_1, str_ar_lp_prefill))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }
                        sscanf(string_ptr_2,"%d", &ar->lp_prefill_ms);
                        pr_debug("lp_prefill_ms: %d\n", ar->lp_prefill_ms );
                    }
                    else if(NULL != strstr(string_ptr_1, str_ar_lp_stout))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }
                        //sscanf(string_ptr_2,"%hi", &ar->lp_startup_tout_ms);
                        sscanf(string_ptr_2,"%hi", &ar->lp_startup_tout_ms);//short integer specifier
                        pr_debug("lp_startup_tout_ms: %d\n", ar->lp_startup_tout_ms );
                    }
                    else if(NULL != strstr(string_ptr_1, str_ar_lp_strtout))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }
                        sscanf(string_ptr_2,"%hi", &ar->lp_stream_tout_ms);
                        pr_debug("lp_stream_tout_ms: %d\n", ar->lp_stream_tout_ms );
                        ETG_TRACE_USR4(("[audproc_configuration_parse_audproc_cfg]: lp_stream_tout_ms: %d\n", ar->lp_stream_tout_ms ));
                    }
                    /*new - 07062016 */
                    else if(NULL != strstr(string_ptr_1, str_ar_in_pcm_format))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }
                        //sscanf(string_ptr_2,"%d", &ar->in_pcm_format);
                        gint16 i16var = 0;
                        sscanf(string_ptr_2,"%hi", &i16var);//sscanf(string_ptr_2,"%d", &i16var);
                        ar->in_pcm_format = (snd_pcm_format_t)i16var;
                        pr_debug("in_pcm_format: %d\n", ar->in_pcm_format );
                        ETG_TRACE_USR4(("[audproc_configuration_parse_audproc_cfg]: in_pcm_format: %d\n", ar->in_pcm_format));
                    }
                    else if(NULL != strstr(string_ptr_1, str_ar_out_pcm_format))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }
                        gint16 i16var = 0;
                        sscanf(string_ptr_2,"%hi", &i16var);//sscanf(string_ptr_2,"%d", &i16var);
                        ar->out_pcm_format = (snd_pcm_format_t)i16var;
                        pr_debug("out_pcm_format: %d\n", ar->out_pcm_format );
                        ETG_TRACE_USR4(("[audproc_configuration_parse_audproc_cfg]: out_pcm_format: %d\n", ar->out_pcm_format));
                    }
                    else if(NULL != strstr(string_ptr_1, str_ar_lp_pcm_format))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }
                        gint16 i16var = 0;
                        sscanf(string_ptr_2,"%hi", &i16var);//sscanf(string_ptr_2,"%d", &i16var);
                        ar->lp_pcm_format = (snd_pcm_format_t)i16var;
                        pr_debug("in_pcm_format: %d\n", ar->lp_pcm_format );
                        //sscanf(string_ptr_2,"%d", &ar->lp_pcm_format);
                        ETG_TRACE_USR4(("[audproc_configuration_parse_audproc_cfg]: in_pcm_format: %d\n", ar->lp_pcm_format));
                    }
                    else if(NULL != strstr(string_ptr_1, str_ar_proc_ps))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }
                        sscanf(string_ptr_2,"%d", &ar->proc_period_size);
                        pr_debug("proc_period_size: %d\n", ar->proc_period_size );
                    }
                    else if(NULL != strstr(string_ptr_1, str_ar_fct_start_tout))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }
                        //sscanf(string_ptr_2,"%li", &ar->fct_start_audio_tout_ms);
                        sscanf(string_ptr_2,"%ld", &ar->fct_start_audio_tout_ms);
                        //pr_debug("fct_start_audio_tout_ms: %li\n", ar->fct_start_audio_tout_ms );
                        pr_debug("fct_start_audio_tout_ms: %ld\n", ar->fct_start_audio_tout_ms );
                    }
                    else if(NULL != strstr(string_ptr_1, str_ar_in_create_on_start))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }
//                        sscanf(string_ptr_2,"%c", &ar->in_create_on_start);
                        sscanf(string_ptr_2,"%d", &ar->in_create_on_start);
                        pr_debug("in_create_on_start: %d\n", ar->in_create_on_start );
                    }
                    else if(NULL != strstr(string_ptr_1, str_ar_out_create_on_start))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }
                        //sscanf(string_ptr_2,"%c", &ar->out_create_on_start);
                        sscanf(string_ptr_2,"%d", &ar->out_create_on_start);
                        pr_debug("out_create_on_start: %d\n", ar->out_create_on_start );
                    }
                    else if(NULL != strstr(string_ptr_1, str_ar_lp_create_on_start))
                    {
                        if(!string_ptr_2)
                        {
                            pr_warning("invalid parameter value\n");
                            continue;
                        }
                        //sscanf(string_ptr_2,"%c", &ar->lp_create_on_start);
                        sscanf(string_ptr_2,"%d", &ar->lp_create_on_start);
                        pr_debug("lp_create_on_start: %d\n", ar->lp_create_on_start );
                    }
                    else if(NULL != strstr(string_ptr_1, str_cfg_end))
                    {
                        ar_cfg_start = FALSE;
                        ar_cnt++;
                        ar_cfg_found = FALSE;

                        if(ar_cnt < apc.ar_cfg_nb)
                        {
                            ar = &apc.ar_cfg_list[ar_cnt];
                            pr_debug("parse configuration route : %d\n", ar_cnt);
                            audproc_configuration_init_audproc_cfg(&ar); /*todo*/
                        }
                    }
                    else
                    {
                        pr_warning("invalid string \"%s\"\n", string_ptr_1);
                    }
                }
            }
        }
    }
    else
        return FALSE;

    pr_message("successfull walk through %d audio route configuration entries\n", apc.ar_cfg_nb);

    return TRUE;
}


static audproc_alsa_stream_cfg*  audproc_configuration_get_route_cfg_ext(guint8 src, audproc_alsa_stream_cfg* src_cfg, guint32 length )
{
    audproc_alsa_stream_cfg* pd = (audproc_alsa_stream_cfg*)NULL;
    guint i = 0;


    pr_debug(" return config struct from source(%d) upon %d element", src, length );

    for(i = 0, pd = src_cfg; i < length; i++, pd++)
    {
        pr_debug("try fit search source(%d) with element(%d) with source_id(%d)", src, i, pd->source_id);
        if(pd->source_id == src)
        {
            #ifndef D_MAKE_AUDPROC_SRC_ID_AVAILABLE_PER_AUDPROC_CFG
            if(!pd->available)
            {
                pr_warning("source(%d) is not available\n", src);
                return (audproc_alsa_stream_cfg*)NULL;
            }
            #endif

            pr_debug("return configuration of sourceId(%d): %s\n", src, audproc_service_src_str(src));
            pr_debug("--> capture   dev: name(%s), nb_ch(%d)\n", pd->indev.audproc_dev_name, pd->indev.audproc_nb_ch);
            pr_debug("--> capture   dev: sr(%d), framesize(%d), prefill(%d)\n", pd->indev.audproc_rate, pd->indev.audproc_period_frames, pd->indev.audproc_prefill_ms);
            pr_debug("--> playback  dev: name(%s), nb_ch(%d)\n", pd->outdev.audproc_dev_name, pd->outdev.audproc_nb_ch);
            pr_debug("--> playback  dev: sr(%d), framesize(%d), , prefill(%d)\n", pd->outdev.audproc_rate, pd->outdev.audproc_period_frames, pd->outdev.audproc_prefill_ms);

            return pd;
        }
    }

    return (audproc_alsa_stream_cfg*)NULL;;
}

static audproc_alsa_stream_cfg* audproc_configuration_dup_static_cfg
(
    audproc_alsa_stream_cfg* dest,
    audproc_alsa_stream_cfg* src,
    guint32                  nb
)
{
    if(!dest || !src || !nb)
        return (audproc_alsa_stream_cfg*)NULL;

    guint i = 0;

    for(i = 0; i < nb; i++)
    {
        dest->source_id                                  = src->source_id;
        dest->available                                  = FALSE; //src->available;  -> new
        dest->create_route_on_init                       = src->create_route_on_init;
        dest->indev.audproc_dev_name                     = g_strdup(src->indev.audproc_dev_name);   /* input stream from internal source or ADR3 */
        dest->indev.audproc_nb_ch                        = src->indev.audproc_nb_ch;
        dest->indev.audproc_str_ch_map                   = src->indev.audproc_str_ch_map;
        dest->indev.audproc_dir                          = src->indev.audproc_dir;              /*SND_PCM_STREAM_PLAYBACK*/
        dest->indev.audproc_rate                         = src->indev.audproc_rate;              /*any, e.g. 8000-192000*/
        dest->indev.audproc_period_frames                = src->indev.audproc_period_frames;      /*e.g. 64/128/256/512*/
        dest->indev.audproc_format                       = src->indev.audproc_format;             /*format*/
        dest->indev.audproc_prefill_ms                   = src->indev.audproc_prefill_ms;           /*format*/
        dest->indev.audproc_startup_tout_ms              = src->indev.audproc_startup_tout_ms;      /*format*/
        dest->indev.audproc_stream_tout_ms               = src->indev.audproc_stream_tout_ms;
        dest->indev.audproc_create_on_start              = src->indev.audproc_create_on_start;      /*format*/
        dest->outdev.audproc_dev_name                    = g_strdup(src->outdev.audproc_dev_name);  /* input stream from internal source or ADR3 */
        dest->outdev.audproc_nb_ch                       = src->outdev.audproc_nb_ch;
        dest->outdev.audproc_str_ch_map                  = src->outdev.audproc_str_ch_map;
        dest->outdev.audproc_dir                         = src->outdev.audproc_dir;              /*SND_PCM_STREAM_PLAYBACK*/
        dest->outdev.audproc_rate                        = src->outdev.audproc_rate;              /*any, e.g. 8000-192000*/
        dest->outdev.audproc_period_frames               = src->outdev.audproc_period_frames;      /*e.g. 64/128/256/512*/
        dest->outdev.audproc_format                      = src->outdev.audproc_format;             /*format*/
        dest->outdev.audproc_prefill_ms                  = src->outdev.audproc_prefill_ms;           /*format*/
        dest->outdev.audproc_startup_tout_ms             = src->outdev.audproc_startup_tout_ms;     /*format*/
        dest->outdev.audproc_stream_tout_ms              = src->outdev.audproc_stream_tout_ms;
        dest->outdev.audproc_create_on_start             = src->outdev.audproc_create_on_start;      /*format*/
        dest->lpdev.audproc_dev_name                     = g_strdup(src->lpdev.audproc_dev_name);   /* input stream from internal source or ADR3 */
        dest->lpdev.audproc_nb_ch                        = src->lpdev.audproc_nb_ch;
        dest->lpdev.audproc_str_ch_map                   = src->lpdev.audproc_str_ch_map;
        dest->lpdev.audproc_dir                          = src->lpdev.audproc_dir;              /*SND_PCM_STREAM_PLAYBACK*/
        dest->lpdev.audproc_rate                         = src->lpdev.audproc_rate;              /*any, e.g. 8000-192000*/
        dest->lpdev.audproc_period_frames                = src->lpdev.audproc_period_frames;      /*e.g. 64/128/256/512*/
        dest->lpdev.audproc_format                       = src->lpdev.audproc_format;             /*format*/
        dest->lpdev.audproc_prefill_ms                   = src->lpdev.audproc_prefill_ms;           /*format*/
        dest->lpdev.audproc_startup_tout_ms              = src->lpdev.audproc_startup_tout_ms;      /*format*/
        dest->indev.audproc_stream_tout_ms               = src->indev.audproc_stream_tout_ms;
        dest->lpdev.audproc_create_on_start              = src->lpdev.audproc_create_on_start;      /*format*/
        dest->audbinding                                 = src->audbinding;
        dest->audcfg                                     = src->audcfg;
        dest->audproc_close_on_stop                      = src->audproc_close_on_stop;         /* output prefill in ms*/
        dest->proc_frame_size                            = src->proc_frame_size;           /*e.g. 64/128/256/512*/
        dest->audproc_start_time_out_ms                  = src->audproc_start_time_out_ms;       /*e.g. 1000*/
        dest->audproc_rts_log_cb                         = src->audproc_rts_log_cb;       /*e.g. 1000*/
        src++;
        dest++;
    }

    return dest;
}




static int audproc_configuration_audio_routes_reconfig(void)
{
    int err = AUDPROC_ERR_OK;
    int val_cfg_count = 0;

    /* set new audio route list */
    audproc_cfg_new =  (audproc_alsa_stream_cfg*)g_malloc0(sys_cfg.cfglength * sizeof(audproc_alsa_stream_cfg));

    if(!audproc_cfg_new)
    {
        pr_warning("audio route reconfig fails\n");
        err = AUDPROC_ERR_AR_RECONGIF_FAILURE;
    }
    else
    {
        /* duplicate static configuration */
        (void*)audproc_configuration_dup_static_cfg(audproc_cfg_new, sys_cfg.audcfg, sys_cfg.cfglength);


        audproc_route_cfg* pd = (audproc_route_cfg*)NULL;
        guint i = 0;


        for(i = 0, pd = apc.ar_cfg_list; i < apc.ar_cfg_nb; i++, pd++)
        {

            pr_message("try reconfig for source(%d), list element nb:%d from max:%d  \n", pd->source_id, (i + 1), apc.ar_cfg_nb);

            audproc_alsa_stream_cfg* p =  audproc_configuration_get_route_cfg_ext(pd->source_id, audproc_cfg_new, sys_cfg.cfglength);

            if(p)
            {
                /* route available per configuration */
                #ifdef D_MAKE_AUDPROC_SRC_ID_AVAILABLE_PER_AUDPROC_CFG
                p->available = TRUE;
                pr_message("the source id:%s was made available per audproc.cfg file\n", audproc_service_src_str(pd->source_id));
                #else
                if(!p->available)
                {
                    /* make this source available per audproc.cfg */
                    pr_warning("the source id:%s is not available\n", audproc_service_src_str(pd->source_id));
                    continue;
                }
                #endif

                /* check the new parameter */
                if(audproc_configuration_enable_reconfig_plausibility)
                    audproc_configuration_check_new_audproc_cfg(&pd);

                if(pd->sample_rate != AR_CFG_INIT_VALUE)
                    p->indev.audproc_rate               = (guint)pd->sample_rate;
                if(pd->in_period_size != AR_CFG_INIT_VALUE)
                    p->indev.audproc_period_frames      = (guint)pd->in_period_size;
                if(pd->in_prefill_ms != AR_CFG_INIT_VALUE)
                    p->indev.audproc_prefill_ms         = (guint)pd->in_prefill_ms;
                if(pd->in_startup_tout_ms != AR_CFG_INIT_VALUE)
                    p->indev.audproc_startup_tout_ms    = pd->in_startup_tout_ms;
                ETG_TRACE_USR4(("[audproc_configuration_audio_routes_reconfig]: check configuration of in_stream_tout_ms->%d\n", pd->in_stream_tout_ms));
                if(pd->in_stream_tout_ms != AR_CFG_INIT_VALUE)
                {
                    p->indev.audproc_stream_tout_ms    = pd->in_stream_tout_ms;
                    ETG_TRACE_USR4(("[audproc_configuration_audio_routes_reconfig]: reconfigures in_stream_tout_ms->%d\n", pd->in_stream_tout_ms));
                }
                ETG_TRACE_USR4(("[audproc_configuration_audio_routes_reconfig]: check configuration of in_pcm_format->%d\n", pd->in_pcm_format));
                if(pd->in_pcm_format != SND_PCM_FORMAT_UNKNOWN)
                {
                    ETG_TRACE_USR4(("[audproc_configuration_audio_routes_reconfig]: reconfigures in_pcm_format->%d\n", pd->in_pcm_format));
                    p->indev.audproc_format          = pd->in_pcm_format;
                }
                if(pd->in_create_on_start != AR_CFG_INIT_VALUE_I8)
                    p->indev.audproc_create_on_start          = (guint8)pd->in_create_on_start;
                if(pd->sample_rate != AR_CFG_INIT_VALUE)
                    p->outdev.audproc_rate              = (guint)pd->sample_rate;
                if(pd->out_period_size != AR_CFG_INIT_VALUE)
                    p->outdev.audproc_period_frames     = (guint)pd->out_period_size;
                if(pd->out_prefill_ms != AR_CFG_INIT_VALUE)
                    p->outdev.audproc_prefill_ms        = (guint)pd->out_prefill_ms;
                if(pd->out_startup_tout_ms != AR_CFG_INIT_VALUE)
                    p->outdev.audproc_startup_tout_ms   = pd->out_startup_tout_ms;
                ETG_TRACE_USR4(("[audproc_configuration_audio_routes_reconfig]: check configuration of out_stream_tout_ms->%d\n", pd->out_stream_tout_ms));
                if(pd->out_stream_tout_ms != AR_CFG_INIT_VALUE)
                {
                    ETG_TRACE_USR4(("[audproc_configuration_audio_routes_reconfig]: reconfigures out_stream_tout_ms->%d\n", pd->out_stream_tout_ms));
                    p->outdev.audproc_stream_tout_ms   = pd->out_stream_tout_ms;
                }
                ETG_TRACE_USR4(("[audproc_configuration_audio_routes_reconfig]: check configuration of out_pcm_format->%d\n", pd->out_pcm_format));
                if(pd->out_pcm_format != SND_PCM_FORMAT_UNKNOWN)
                {
                    ETG_TRACE_USR4(("[audproc_configuration_audio_routes_reconfig]: reconfigures out_pcm_format->%d\n", pd->out_pcm_format));
                    p->outdev.audproc_format         = pd->out_pcm_format;
                }
                if(pd->out_create_on_start != AR_CFG_INIT_VALUE_I8)
                    p->outdev.audproc_create_on_start          = (guint8)pd->out_create_on_start;
                if(pd->sample_rate != AR_CFG_INIT_VALUE)
                    p->lpdev.audproc_rate                = (guint)pd->sample_rate;
                if(pd->lp_period_size != AR_CFG_INIT_VALUE)
                    p->lpdev.audproc_period_frames       = (guint)pd->lp_period_size;
                if(pd->lp_prefill_ms != AR_CFG_INIT_VALUE)
                    p->lpdev.audproc_prefill_ms          = (guint)pd->lp_prefill_ms;
                if(pd->lp_startup_tout_ms != AR_CFG_INIT_VALUE)
                    p->lpdev.audproc_startup_tout_ms     = pd->lp_startup_tout_ms;
                if(pd->lp_stream_tout_ms != AR_CFG_INIT_VALUE)
                    p->lpdev.audproc_stream_tout_ms     = pd->lp_stream_tout_ms;
                ETG_TRACE_USR4(("[audproc_configuration_audio_routes_reconfig]: check configuration of lp_pcm_format->%d\n", pd->lp_pcm_format));
                if(pd->lp_pcm_format != SND_PCM_FORMAT_UNKNOWN)
                {
                    ETG_TRACE_USR4(("[audproc_configuration_audio_routes_reconfig]: reconfigures lp_pcm_format->%d\n", pd->lp_pcm_format));
                    p->lpdev.audproc_format          = pd->lp_pcm_format;
                }
                if(pd->lp_create_on_start != AR_CFG_INIT_VALUE_I8)
                    p->lpdev.audproc_create_on_start          = (guint8)pd->lp_create_on_start;
                if(pd->proc_period_size != AR_CFG_INIT_VALUE)
                    p->proc_frame_size       = (guint)pd->proc_period_size;
                if(pd->fct_start_audio_tout_ms != AR_CFG_INIT_VALUE)
                    p->audproc_start_time_out_ms       = (guint)pd->fct_start_audio_tout_ms;


                if(pd->dev_in)
                {
                    if(p->indev.audproc_dev_name)
                        g_free((char*)p->indev.audproc_dev_name);
                    p->indev.audproc_dev_name = g_strdup(pd->dev_in);
                }

                if(pd->dev_out)
                {
                    if(p->outdev.audproc_dev_name)
                        g_free((char*)p->outdev.audproc_dev_name);
                    p->outdev.audproc_dev_name = g_strdup(pd->dev_out);
                }

                if(pd->dev_lp)
                {
                    if(p->lpdev.audproc_dev_name)
                        g_free((char*)p->lpdev.audproc_dev_name);
                    p->lpdev.audproc_dev_name = g_strdup(pd->dev_lp);
                }


                pr_debug("new configuration of sourceId(%d): %s\n",     p->source_id, audproc_service_src_str(p->source_id));
                pr_debug("--> capture   dev: name(%s), nb_ch(%d)\n",    p->indev.audproc_dev_name, p->indev.audproc_nb_ch);
                pr_debug("--> capture   dev: sample_rate(%d)\n",        p->indev.audproc_rate);
                pr_debug("--> capture   dev: framesize(%d)\n",          p->indev.audproc_period_frames);
                pr_debug("--> capture   dev: prefill_ms(%d)\n",         p->indev.audproc_prefill_ms);
                pr_debug("--> capture   dev: start_tout_ms(%d)\n",      p->indev.audproc_startup_tout_ms);
                pr_debug("--> capture   dev: pcm_formats(%d)\n",        p->indev.audproc_format);
                pr_debug("--> capture  dev: create_on_start(%d)\n",     p->indev.audproc_create_on_start);
                pr_debug("--> playback  dev: name(%s), nb_ch(%d)\n",    p->outdev.audproc_dev_name, p->outdev.audproc_nb_ch);
                pr_debug("--> playback  dev: sample_rate(%d)\n",        p->outdev.audproc_rate);
                pr_debug("--> playback  dev: framesize(%d)\n",          p->outdev.audproc_period_frames);
                pr_debug("--> playback  dev: prefill_ms(%d)\n",         p->outdev.audproc_prefill_ms);
                pr_debug("--> playback  dev: start_tout_ms(%d)\n",      p->outdev.audproc_startup_tout_ms);
                pr_debug("--> playback  dev: pcm_formats(%d)\n",        p->outdev.audproc_format);
                pr_debug("--> playback  dev: create_on_start(%d)\n",    p->outdev.audproc_create_on_start);
                pr_debug("--> loopback  dev: name(%s), nb_ch(%d)\n",    p->lpdev.audproc_dev_name, p->outdev.audproc_nb_ch);
                pr_debug("--> loopback  dev: sample_rate(%d)\n",        p->lpdev.audproc_rate);
                pr_debug("--> loopback  dev: framesize(%d)\n",          p->lpdev.audproc_period_frames);
                pr_debug("--> loopback  dev: prefill_ms(%d)\n",         p->lpdev.audproc_prefill_ms);
                pr_debug("--> loopback  dev: start_tout_ms(%d)\n",      p->lpdev.audproc_startup_tout_ms);
                pr_debug("--> loopback  dev: pcm_formats(%d)\n",        p->lpdev.audproc_format);
                pr_debug("--> loopback  dev: create_on_start(%d)\n",    p->lpdev.audproc_create_on_start);
                pr_debug("--> processing unit framesize(%d)\n",         p->proc_frame_size);

                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:new configuration of sourceId(%d): %s\n",     p->source_id, audproc_service_src_str(p->source_id)));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> capture   dev: name(%s)\n",               p->indev.audproc_dev_name));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> capture   nb_ch(%d)\n",                   p->indev.audproc_nb_ch));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> capture   dev: sample_rate(%d)\n",        p->indev.audproc_rate));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> capture   dev: framesize(%d)\n",          p->indev.audproc_period_frames));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> capture   dev: prefill_ms(%d)\n",         p->indev.audproc_prefill_ms));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> capture   dev: start_tout_ms(%d)\n",      p->indev.audproc_startup_tout_ms));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> capture   dev: stream_tout_ms(%d)\n",     p->indev.audproc_stream_tout_ms));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> capture   dev: pcm_formats(%d)\n",        p->indev.audproc_format));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> capture   dev: create_on_start(%d)\n",    p->indev.audproc_create_on_start));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> playback  dev: name(%s)",                 p->outdev.audproc_dev_name));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> playback  nb_ch(%d)\n",                   p->outdev.audproc_nb_ch));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> playback  dev: sample_rate(%d)\n",        p->outdev.audproc_rate));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> playback  dev: framesize(%d)\n",          p->outdev.audproc_period_frames));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> playback  dev: prefill_ms(%d)\n",         p->outdev.audproc_prefill_ms));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> playback  dev: start_tout_ms(%d)\n",      p->outdev.audproc_startup_tout_ms));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> playback   dev: stream_tout_ms(%d)\n",    p->outdev.audproc_stream_tout_ms));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> playback  dev: pcm_formats(%d)\n",        p->outdev.audproc_format));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> playback  dev: create_on_start(%d)\n",    p->outdev.audproc_create_on_start));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> loopback  dev: name(%s)\n",               p->lpdev.audproc_dev_name));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> loopback  nb_ch(%d)\n",                   p->lpdev.audproc_nb_ch));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> loopback  dev: sample_rate(%d)\n",        p->lpdev.audproc_rate));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> loopback  dev: framesize(%d)\n",          p->lpdev.audproc_period_frames));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> loopback  dev: prefill_ms(%d)\n",         p->lpdev.audproc_prefill_ms));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> loopback  dev: start_tout_ms(%d)\n",      p->lpdev.audproc_startup_tout_ms));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> loopback   dev: stream_tout_ms(%d)\n",    p->lpdev.audproc_stream_tout_ms));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> loopback  dev: pcm_formats(%d)\n",        p->lpdev.audproc_format));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> loopback  dev: create_on_start(%d)\n",    p->lpdev.audproc_create_on_start));
                ETG_TRACE_USR3(("[audproc_configuration_audio_routes_reconfig]:--> processing unit framesize(%d)\n",         p->proc_frame_size));


                pr_message("new configuration, current count -> %d \n", val_cfg_count);
                val_cfg_count++;
            }
            else
            {
                pr_message("not included in the base configuration\n");
            }
        }

        pr_message("number of route configured -> %d \n", val_cfg_count);
        /* overload audio configuration with new one */
        sys_cfg.audcfg    = audproc_cfg_new;
    }

    return err;
}



/*******************************************************************************
*
* FUNCTION: audproc_configuration_get_audio_mode
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int   audproc_configuration_get_audio_mode(void)
{
    pr_message("current active audio mode: %d \n", sys_cfg.audioMode);
    return (int)sys_cfg.audioMode;
}

/*******************************************************************************
*
* FUNCTION: audproc_configuration_set_audio_mode_classic
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int   audproc_configuration_set_audio_mode_classic(void)
{
    int     err = AUDPROC_ERR_OK;

    pr_message("ENTERED\n");
    ETG_TRACE_USR4(("[audproc_configuration_set_audio_mode_classic}: ENTERED "));

    if(sys_cfg.audioMode == D_AUDIO_MODE_CLASSIC)
    {
        pr_warning("current audio is classic\n");
        return err;
    }


    /* is an classic apl instance available */
    AplState* aplinst = audproc_apl_handler_get_instance(APL_INSTANCE_STR_AUDIO_LOOPBACK_FCTS);

    /* set classic audio mode  */
    sys_cfg.audioMode = D_AUDIO_MODE_CLASSIC;

    if(aplinst)
    {
        pr_warning("the classic configuration is already activated\n");
    }
    else
    {
        /* stop all sources remove all resources */
        audproc_service_finalize();

        /* now reinitiaze */
        audproc_service_init(TRUE, D_AUDIO_MODE_CLASSIC);

    }

    return err;
}

/*******************************************************************************
*
* FUNCTION: audproc_configuration_set_audio_mode_auditorium
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int   audproc_configuration_set_audio_mode_auditorium(void)
{
    int     err = AUDPROC_ERR_OK;


    pr_message("ENTERED\n");
    ETG_TRACE_USR3(("[audproc_configuration_set_audio_mode_auditorium}: ENTERED "));

    if(sys_cfg.audioMode == D_AUDIO_MODE_AUDITORIUM)
    {
        pr_warning("current audio mode is Auditorium\n");
        ETG_TRACE_USR1(("[audproc_configuration_set_audio_mode_auditorium}: the current active audio mode is Auditorium, no change is done"));
        return err;
    }

    /* is an apl instance available */
    AplState* aplinst = audproc_apl_handler_get_instance(APL_INSTANCE_STR_ARKAMYS_FCTS);

    sys_cfg.audioMode = D_AUDIO_MODE_AUDITORIUM;

    if(aplinst)
    {
        /* set the eol datapool as available for the auditorium mode */
        audproc_datapool_access_eol_set_auditorium_avail();

        /*load eol data */
        guint32 size;
        unsigned char * eol_data = audproc_datapool_access_get_eol_dataset(&size);

        ETG_TRACE_USR1(("[audproc_configuration_set_audio_mode_auditorium}: return eol data set with size -> %d", size));

        if(size && eol_data)
        {
            err = audproc_apl_handler_set_data(aplinst, aplArkamysEolData, 0, size,(void*)eol_data );

            if(!err)
                ETG_TRACE_USR1(("[audproc_configuration_set_audio_mode_auditorium}: eol dataset is set at apl arkamys module"));
        }
    }
    else
    {
        /* stop all sources remove all resources */
        audproc_service_finalize();

        /* now reinitialize */
        audproc_service_init(TRUE, D_AUDIO_MODE_AUDITORIUM);

       /* set the eol datapool as available for the auditorium mode */
        audproc_datapool_access_eol_set_auditorium_avail();
    }


    ETG_TRACE_USR3(("[audproc_configuration_set_audio_mode_auditorium}: EXIT "));
    return err;
}

/*******************************************************************************
*
* FUNCTION: audproc_configuration_set_audio_mode_premium
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int   audproc_configuration_set_audio_mode_premium(void)
{
    int err = AUDPROC_ERR_OK;

    pr_message("ENTERED, currently not supported \n");

    return err;
}

/*******************************************************************************
*
* FUNCTION: audproc_configuration_set_audio_mode_eol_reload
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int   audproc_configuration_set_audio_mode_eol_reload(void)
{
    int     err = AUDPROC_ERR_OK;

    pr_message("ENTERED\n");

    err = audproc_datapool_access_eol_reload_dataset();
    if(err)
    {
        pr_warning("fails to reload dataset with error:%d\n", err);
        return err;
    }

    /* is an apl instance available? */
    AplState* aplinst = audproc_apl_handler_get_instance(APL_INSTANCE_STR_ARKAMYS_FCTS);

    if(aplinst)
    {
        /* set ByPassMode */
        /*load eol data */
        guint32 size;

        unsigned char * eol_data = audproc_datapool_access_get_eol_dataset(&size);

        if(size && eol_data)
            err = audproc_apl_handler_set_data(aplinst, aplArkamysEolData, 0, size,(void*)eol_data );

    }
    else
        err = audproc_configuration_load_arkamys_configuration(AUD_PROC_SRC_DEFAULT);

    return err;
}

/*******************************************************************************
*
* FUNCTION: audproc_configuration_get_route_cfg_max
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
gint   audproc_configuration_get_route_cfg_nb_max(void)
{
    pr_debug("number of route configuration(%d)\n", sys_cfg.cfglength);
    return (gint)sys_cfg.cfglength;
}

/*******************************************************************************
*
* FUNCTION: audproc_configuration_get_route_cfg
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
audproc_alsa_stream_cfg*  audproc_configuration_get_route_cfg(guint8 src)
{
    audproc_alsa_stream_cfg* pd = (audproc_alsa_stream_cfg*)NULL;
    guint i = 0;


    for(i = 0, pd = sys_cfg.audcfg; i < sys_cfg.cfglength; i++, pd++)
    {
        if(pd->source_id == src)
        {
            if(!pd->available)
            {
                pr_debug("source(%d) is not available\n", src);
                return (audproc_alsa_stream_cfg*)NULL;
            }

            pr_debug("return configuration of sourceId(%d): %s\n", src, audproc_service_src_str(src));
            pr_debug("--> capture   dev: name(%s), nb_ch(%d)\n", pd->indev.audproc_dev_name, pd->indev.audproc_nb_ch);
            pr_debug("--> capture   dev: sr(%d), framesize(%d), prefill(%d)\n", pd->indev.audproc_rate, pd->indev.audproc_period_frames, pd->indev.audproc_prefill_ms);
            pr_debug("--> playback  dev: name(%s), nb_ch(%d)\n", pd->outdev.audproc_dev_name, pd->outdev.audproc_nb_ch);
            pr_debug("--> playback  dev: sr(%d), framesize(%d), prefill(%d)\n", pd->outdev.audproc_rate, pd->outdev.audproc_period_frames, pd->outdev.audproc_prefill_ms);

            return pd;
        }
    }

    return (audproc_alsa_stream_cfg*)NULL;
}


/*******************************************************************************
*
* FUNCTION: audproc_configuration_get_route_cfg_per_idx
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
audproc_alsa_stream_cfg*  audproc_configuration_get_route_cfg_list_idx(guint idx)
{
    audproc_alsa_stream_cfg* pd = (audproc_alsa_stream_cfg*)NULL;

    if(idx >= sys_cfg.cfglength )
    {
        pr_warning("no route configuration available for idx(%d)\n", idx);
    }
    else
    {
        pd = &sys_cfg.audcfg[idx]; //&audproc_cfg_classic[idx];

        if(!pd->available)
        {
            pr_debug("source(%d) is not available\n", pd->source_id);
            return (audproc_alsa_stream_cfg*)NULL;
        }

        pr_message("return configuration of sourceId(%d): %s\n",  pd->source_id, audproc_service_src_str(pd->source_id));
        pr_message("--> capture   dev: name(%s), nb_ch(%d)\n",    pd->indev.audproc_dev_name, pd->indev.audproc_nb_ch);
        pr_message("--> capture   dev: sr(%d), framesize(%d), prefill(%d)\n",  pd->indev.audproc_rate, pd->indev.audproc_period_frames, pd->indev.audproc_prefill_ms);
        pr_message("--> playback  dev: name(%s), nb_ch(%d)\n",    pd->outdev.audproc_dev_name, pd->outdev.audproc_nb_ch);
        pr_message("--> playback  dev: sr(%d), framesize(%d), prefill(%d)\n",  pd->outdev.audproc_rate, pd->outdev.audproc_period_frames, pd->outdev.audproc_prefill_ms);

    }

    return pd;
}


/*******************************************************************************
*
* FUNCTION: audproc_configuration_look_up_src_table
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int audproc_configuration_look_up_src_table
(
    guint8  in_src,
    guint8* search_src_def,
    gboolean search_src_conf_versus_int
)

{
    const  audproc_audsrc_lookup* pd = (audproc_audsrc_lookup*)NULL;
    guint i = 0;
    int err = AUDPROC_ERR_AP_NO_SOURCE_TRANSLATION_AVAILABLE;

    *search_src_def = 0;

    for(i = 0, pd = sys_cfg.audsrcmap; i < sys_cfg.audsrclength; i++, pd++)
    {
        if(search_src_conf_versus_int)
        {
            if(pd->midw_audsrc_fi == in_src)
            {
                pr_debug("found an internal source definition associated to configured source(%d) -> %d\n",  pd->audproc_audsrc_def, in_src);

                *search_src_def = pd->audproc_audsrc_def;
                err = AUDPROC_ERR_OK;

                break;
            }
        }
        else
        {
            if(pd->audproc_audsrc_def == in_src)
            {
                pr_debug("found an configured source definition associated to intern source(%d) -> %d\n",  pd->midw_audsrc_fi, in_src);

                *search_src_def = pd->midw_audsrc_fi;
                err = AUDPROC_ERR_OK;

                break;
            }
        }
    }

    if(err == AUDPROC_ERR_AP_NO_SOURCE_TRANSLATION_AVAILABLE)
    {
        pr_debug("No translation conf. found for the requested internal source(%d)\n", in_src);
    }

    return err;
}


/*******************************************************************************
*
* FUNCTION: audproc_configuration_look_up_flat_req
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int audproc_configuration_look_up_flat_req
(
    guint8    in_src,
    gboolean*   is_set_flat
)

{
    const  audproc_audsrc_lookup* pd = (audproc_audsrc_lookup*)NULL;
    guint i = 0;
    int err = AUDPROC_ERR_AP_NO_SOURCE_TRANSLATION_AVAILABLE;


    for(i = 0, pd = sys_cfg.audsrcmap; i < sys_cfg.audsrclength; i++, pd++)
    {
        if(pd->midw_audsrc_fi == in_src)
        {
            pr_message("set flat(%d) for source(%d) \n",  in_src, pd->audproc_is_set_to_flat);

            *is_set_flat = pd->audproc_is_set_to_flat;
            err = AUDPROC_ERR_OK;

            break;
        }
    }

    return err;
}

/*******************************************************************************
*
* FUNCTION: audproc_configuration_get_src_id_from_capture_dev
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int  audproc_configuration_get_src_id_from_capture_dev
(
    gchar*  audproc_alsa_capture_dev,   /* in */
    guint8* audproc_src_id              /* out */
)
{
    audproc_alsa_stream_cfg* pd = (audproc_alsa_stream_cfg*)NULL;
    guint i = 0;

    if(!audproc_alsa_capture_dev || !audproc_src_id)
    {
        pr_warning("NULL pointer device name\n");
        return AUDPROC_ERR_NULL_POINTER;
    }


    for(i = 0, pd = sys_cfg.audcfg; i < sys_cfg.cfglength; i++, pd++)
    {

        if(pd)
        {
            if(!g_strcmp0(pd->indev.audproc_dev_name, audproc_alsa_capture_dev))
            {
                if(!pd->available)
                {
                    pr_debug("capture device(%s) is not available\n", audproc_alsa_capture_dev);
                    return AUDPROC_ERR_SRC_CFG_NOT_AVAILABLE; //AUDPROC_ERR_CONFID_NOT_AVAILABLE;
                }

                pr_debug("return configuration of sourceId(%d): %s\n", pd->source_id, audproc_service_src_str(pd->source_id));
                pr_debug("--> capture   dev: name(%s), nb_ch(%d)\n", pd->indev.audproc_dev_name, pd->indev.audproc_nb_ch);
                pr_debug("--> capture   dev: sr(%d), framesize(%d), prefill(%d)\n", pd->indev.audproc_rate, pd->indev.audproc_period_frames, pd->indev.audproc_prefill_ms);
                pr_debug("--> playback  dev: name(%s), nb_ch(%d)\n", pd->outdev.audproc_dev_name, pd->outdev.audproc_nb_ch);
                pr_debug("--> playback  dev: sr(%d), framesize(%d), prefill(%d)\n", pd->outdev.audproc_rate, pd->outdev.audproc_period_frames, pd->outdev.audproc_prefill_ms);

                *audproc_src_id = pd->source_id;

                return AUDPROC_ERR_OK;
            }
        }
        else
            break;
    }

    return AUDPROC_ERR_SRC_CFG_NOT_AVAILABLE;
}


/*******************************************************************************
*
* FUNCTION: audproc_configuration_set_configuration_by_cfg_id
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int audproc_configuration_set_configuration_by_cfg_id(audproc_cfg_id cfgid)
{
    int err = AUDPROC_ERR_OK;

    pr_message("ENTERED: configuration id:%d \n", cfgid);
    ETG_TRACE_USR3(("[audproc_configuration_set_configuration_by_cfg_id]: ENTERED with cfgid -> %d",cfgid));

    switch(cfgid)
    {
        case AUDPROC_CFG_MICRO_LEVEL_MONITORING:
            err = audproc_configuration_load_micro_level_monitoring_configuration(AUD_PROC_SRC_VOICE1);
            break;
        case AUDPROC_CFG_MICRO_LEVEL_MEASUREMENT:
            err = audproc_configuration_load_micro_level_measurement_configuration(AUD_PROC_SRC_MICIN_1);
            break;
        case AUDPROC_CFG_ARKAMYS_PROCESSING:
            err = audproc_configuration_load_arkamys_configuration(AUD_PROC_SRC_ENT3);
            break;
        case AUDPROC_CFG_AUDIO_ENT_LOOPBACK:
            audproc_configuration_load_ent_loopback_configuration(AUD_PROC_SRC_ENT3);
            break;
        case AUDPROC_CFG_AUDIO_VOICE_LOOPBACK:
            audproc_configuration_load_voice_loopback_configuration(AUD_PROC_SRC_VOICE2);
            break;
        case AUDPROC_CFG_AUDIO_INFO_LOOPBACK:
            audproc_configuration_load_info_loopback_configuration(AUD_PROC_SRC_INFO1);
            break;
        case AUDPROC_CFG_AUDIO_LOOPBACK:
        case AUDPROC_CFG_DEFAULT:
        default:
            err = audproc_configuration_load_loopback_configuration(AUD_PROC_SRC_ENT3);
            break;
    }

    pr_message("EXIT \n");
    ETG_TRACE_USR3(("[audproc_configuration_set_configuration_by_cfg_id]: EXIT"));

    return err;
}


/*******************************************************************************
*
* FUNCTION: audproc_configuration_set_configuration_by_apl_inst
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int audproc_configuration_set_configuration_by_apl_inst(const gchar*    apl_instance_name)
{
    int err = AUDPROC_ERR_OK;

    pr_debug("ENTERED\n");

    if(!apl_instance_name)
        return AUDPROC_ERR_NO_INSTANCE_AVAILABLE;

    if (!g_strcmp0(apl_instance_name, APL_INSTANCE_STR_ARKAMYS_FCTS))
        err = audproc_configuration_load_arkamys_configuration(AUD_PROC_SRC_ENT3);
    else if (!g_strcmp0(apl_instance_name, APL_INSTANCE_STR_MICRO_LEVEL_MONITORING_FCTS))
        err = audproc_configuration_load_micro_level_monitoring_configuration(AUD_PROC_SRC_VOICE1);
    else if (!g_strcmp0(apl_instance_name, APL_INSTANCE_STR_MICRO_MEASURE_FCTS))
        err = audproc_configuration_load_micro_level_measurement_configuration(AUD_PROC_SRC_MICIN_1);
    else if (!g_strcmp0(apl_instance_name, APL_INSTANCE_STR_AUDIO_LOOPBACK_FCTS))
        err = audproc_configuration_load_loopback_configuration(AUD_PROC_SRC_ENT3);
    else if (!g_strcmp0(apl_instance_name, APL_INSTANCE_STR_AUDIO_ENT_LOOPBACK_FCTS))
        err = audproc_configuration_load_ent_loopback_configuration(AUD_PROC_SRC_ENT3);
    else if (!g_strcmp0(apl_instance_name, APL_INSTANCE_STR_AUDIO_VOICE_LOOPBACK_FCTS))
        err = audproc_configuration_load_voice_loopback_configuration(AUD_PROC_SRC_ENT3);
    else if (!g_strcmp0(apl_instance_name, APL_INSTANCE_STR_AUDIO_INFO_LOOPBACK_FCTS))
        err = audproc_configuration_load_info_loopback_configuration(AUD_PROC_SRC_ENT3);
    else
    {
        /* do nothing */
        pr_warning("the requetsed apl instance definition: %s is not available\n", apl_instance_name );
    }

    pr_debug("EXIT \n");

    return err;
}




/*******************************************************************************
*
* FUNCTION: audproc_configuration_set_configuration
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int audproc_configuration_set_configuration(guint8 src)
{
    int err = AUDPROC_ERR_OK;
    audproc_cfg_id  cfg = AUDPROC_CFG_DEFAULT;

    pr_message("ENTERED: source:%d \n", src);


    cfg = audproc_configuration_get_configuration(src);


    switch(cfg)
    {
        case AUDPROC_CFG_MICRO_LEVEL_MONITORING:
            audproc_configuration_load_micro_level_monitoring_configuration(src);
            break;
        case AUDPROC_CFG_MICRO_LEVEL_MEASUREMENT:
            audproc_configuration_load_micro_level_measurement_configuration(src);
            break;
        case AUDPROC_CFG_ARKAMYS_PROCESSING:
            audproc_configuration_load_arkamys_configuration(src);
            break;
        case AUDPROC_CFG_AUDIO_ENT_LOOPBACK:
            audproc_configuration_load_ent_loopback_configuration(src);
            break;
        case AUDPROC_CFG_AUDIO_VOICE_LOOPBACK:
            audproc_configuration_load_voice_loopback_configuration(src);
            break;
        case AUDPROC_CFG_AUDIO_INFO_LOOPBACK:
            audproc_configuration_load_info_loopback_configuration(src);
            break;
        case AUDPROC_CFG_AUDIO_LOOPBACK:
        case AUDPROC_CFG_DEFAULT:
        default:
            audproc_configuration_load_loopback_configuration(src);
            break;
    }

    pr_message("EXIT \n");

    return err;
}


/*******************************************************************************
*
* FUNCTION: audproc_configuration_init
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int audproc_configuration_init(gboolean isReconfig, guint8 audioMode)
{
    int err = AUDPROC_ERR_OK;

    /* read environemnt variable, specifical to the configuration module*/
    const char* sEnable_ar_reconfig_plausibilty  = getenv("AUDPROC_ENABLE_AR_RECONFIG_PLAUSIBILITY");

    if(sEnable_ar_reconfig_plausibilty)
        pr_message("FEAT AUDPROC_ENABLE_AR_RECONFIG_PLAUSIBILITY = %s\n", sEnable_ar_reconfig_plausibilty);

    audproc_configuration_enable_reconfig_plausibility = FALSE;

    if (!g_strcmp0(sEnable_ar_reconfig_plausibilty, "1"))
    {
        audproc_configuration_enable_reconfig_plausibility = TRUE;
    }
    else //default
    {
        audproc_configuration_enable_reconfig_plausibility = FALSE;
    }


    /***********************************************
     * load datappol configuration data
     */
#ifndef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX
    audproc_datapool_access_init();
#endif


    /*********************************************************
     * take configurationm from audioproc.cfg over if present
     */
    FILE  *paudcfg = fopen(D_AUDPROC_CFG_FILE, "r");

    if(NULL == paudcfg)
    {
        is_audproc_cfg = FALSE;
    }
    else
    {
        pr_message("read audio configuration from audproc.cfg file\n");
        is_audproc_cfg = audproc_configuration_parse_audproc_cfg();
        fclose(paudcfg);
    }

    memset(&sys_cfg,0, sizeof(system_cfg));

    /********************************
     * retrieve system configuration
     * - PD and CD check
     * - eol loading
     * - validity check
     */

    if(isReconfig)
        sys_cfg.audioMode = audioMode;
    else
        sys_cfg.audioMode = audproc_datapool_access_get_audio_audio_mode();


    if(sys_cfg.audioMode == D_AUDIO_MODE_AUDITORIUM)
    {
        pr_message("Auditorium configuration is available\n");
        sys_cfg.audcfg          = audproc_cfg_auditorium;
        sys_cfg.cfglength       = AUD_PROC_SRC_SOURCE_AUDITORIUM_MAX;
        sys_cfg.audsrcmap       = (audproc_audsrc_lookup*)audproc_audsrc_lookup_table_auditorium;
        sys_cfg.audsrclength    = APL_AUD_SRC_TABLE_AUDITORIUM_SIZE;
    }
    else if (sys_cfg.audioMode == D_AUDIO_MODE_CLASSIC) // classic
    {
        pr_message("Classic configuration is available\n");
        sys_cfg.audcfg          = audproc_cfg_classic;
        sys_cfg.cfglength       = AUD_PROC_SRC_SOURCE_CLASSIC_MAX;
        sys_cfg.audsrcmap       = (audproc_audsrc_lookup*)audproc_audsrc_lookup_table_classic;
        sys_cfg.audsrclength    = APL_AUD_SRC_TABLE_CLASSIC_SIZE;
    }
    else if (sys_cfg.audioMode == D_AUDIO_MODE_WEB_CONTAINER)
    {
        pr_message("web container configuration is available\n");
        sys_cfg.audcfg          = audproc_cfg_web_container;
        sys_cfg.cfglength       = AUD_PROC_SRC_SOURCE_WEB_CONTAINER_MAX;
        sys_cfg.audsrcmap       = (audproc_audsrc_lookup*)audproc_audsrc_lookup_table_web_container;
        sys_cfg.audsrclength    = APL_AUD_SRC_TABLE_WEB_CONTAINER_SIZE;
    }
    else
    {
        /* do nothing */
    }

    /*************************************************
     * overload static audio configuration
     * with the one in audproc.cfg file if available
     */
    if(is_audproc_cfg)
    {
        err = audproc_configuration_audio_routes_reconfig();
    }

    return err;
}


/*******************************************************************************
*
* FUNCTION: audproc_configuration_print_configuration
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
void  audproc_configuration_print_configuration(void)
{

    const  audproc_audsrc_lookup* pd = (audproc_audsrc_lookup*)NULL;
    guint i = 0;


    pr_message("active audio mode : %s\n", audproc_configuration_audio_mode_str(sys_cfg.audioMode) );
    pr_message("*********** Translation Table[%d] midw_src_fi <-> audproc_route[%d]*********\n", sys_cfg.audsrclength, sys_cfg.cfglength );
    /* print MdwSrId to Audproce srcId translation table */

    if(!sys_cfg.audsrcmap)
    {
        pr_critical("NULL Pointer of sys_cfg.audsrcmap\n");
    }

    for(i = 0, pd = sys_cfg.audsrcmap; i < sys_cfg.audsrclength; i++, pd++)
    {
        if(pd)
        {
            pr_message("Translation Table[%d].midw_audsrc_fi_id:    %d\n", i, pd->midw_audsrc_fi);
            pr_message("Translation Table[%d].midw_audsrc_fi_name:  %s\n", i, pd->midw_audsrc_fi_name);
            pr_message("Translation Table[%d].audproc_route_id:     %d\n", i, pd->audproc_audsrc_def);
            pr_message("Translation Table[%d].audproc_route_name:   %s\n", i, audproc_service_src_str(pd->audproc_audsrc_def));
            audproc_alsa_stream_cfg* p = audproc_configuration_get_route_cfg(pd->audproc_audsrc_def);
            if(p)
            {
                pr_message("Translation Table[%d].capture_device_name:  %s\n", i, p->indev.audproc_dev_name);
                pr_message("Translation Table[%d].playback_device_name: %s\n", i, p->outdev.audproc_dev_name);
                pr_message("Translation Table[%d].loopback_device_name: %s\n", i, p->lpdev.audproc_dev_name);
            }
            else
            {
                pr_message("Translation Table[%d].audproc_route:        DISABLED_PER_CFG\n",i);
            }

            pr_message("Translation Table[%d].set_to_flat:          %d\n", i, pd->audproc_is_set_to_flat);
        }
        else
            return;

        pr_message("********************************************************************\n");
    }
}

/*******************************************************************************
*
* FUNCTION: audproc_configuration_finalize
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int audproc_configuration_finalize(void)
{
    int err = AUDPROC_ERR_OK;
    guint i = 0;
    audproc_alsa_stream_cfg* p = (audproc_alsa_stream_cfg*)NULL;


    pr_message("ENTERED\n");


    if(audproc_cfg_new)
    {
        if(sys_cfg.cfglength)
        {
            for(i = 0, p = audproc_cfg_new ; i < sys_cfg.cfglength; i++, p++)
            {
                pr_debug("release configuration data[%d] from[%d]\n", i, sys_cfg.cfglength);
                if(p)
                {
                    if(p->indev.audproc_dev_name)
                        g_free((char*)p->indev.audproc_dev_name);
                    if(p->outdev.audproc_dev_name)
                        g_free((char*)p->outdev.audproc_dev_name);
                    if(p->lpdev.audproc_dev_name)
                        g_free((char*)p->lpdev.audproc_dev_name);
                }
                else
                    return AUDPROC_ERR_NULL_POINTER;
            }
        }

        g_free(audproc_cfg_new);
        audproc_cfg_new = NULL;
    }

    return err;
}
/*******************************************************************************
*
* FUNCTION: audproc_configuration_test_miclvl_300ms
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
void    audproc_configuration_test_miclvl_300ms(void)
{
    tAplU16      u16value = 1000;

    pr_debug("ENTERED: timeout(%d ms)\n", u16value);

    AplState*    aplinst = audproc_apl_handler_get_instance(APL_INSTANCE_STR_MICRO_LEVEL_MONITORING_FCTS);

    if(aplinst)
        (void)audproc_apl_handler_set_data(aplinst, aplMicLvlWatchRefInt, 0, sizeof(tAplU16),(void*) &u16value );
    return;
}
