/*******************************************************************************
* FILE : audproc-audio-rts-handler.c
*
* SW-COMPONENT :
*
* DESCRIPTION :
*
* AUTHOR : Patrick Rey
*
* COPYRIGHT :
*
* HISTORY : 07.08.2015
* Initial version
*******************************************************************************/



/*******************************************************************************
              GENERATED CODE HEADERS
*******************************************************************************/

#include <glib/gi18n.h>
#include <glib-object.h>
#include "audproc-common-defs.h"
#include <alsa/asoundlib.h>
#include "audproc-apl-handler.h"
#include "audproc-alsa.h"
#include "audproc-service.h"
#include "audproc-recording.h"
#include "audproc-audio-rts-handler.h"
#include "audproc-configuration.h"




/*******************************************************************************
              DEFINES
*******************************************************************************/

#define D_RTS_NB_INST_MAX       20
#define D_NB_TEST_STEP_MAX      100
#define S_AUDPROC_RTS_TEST      "/tmp/audproc_rts_performance_write" //.txt"
#define S_AUDPROC_RTS_READ_TEST "/tmp/audproc_rts_performance_read" //.txt"
#define D_MAX_STREAMS 6
#define D_MAX_DEVS    3



/* Needed for Trace */
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define SPM_UNIT_TESTS // solve warning
#include "audproc-audioprocess-trace.h"
#include "etg_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AUDPROC_RTS
#include "trcGenProj/Header/audproc-audio-rts-handler.c.trc.h"
#endif

/*******************************************************************************
              STRUCTURE DEFINITION
*******************************************************************************/
typedef struct _rts_time_test
{
    struct timespec fct_call_complete_time;
}rts_time_test;


/*******************************************************************************
              VARIABLE DECLARATIONS
*******************************************************************************/

static rts_inst_desc*   rts_inst_list[D_RTS_NB_INST_MAX]={0};
static GMutex           m_rts_lock;
static rts_time_test*   ptstub = (rts_time_test*)NULL;     /* write calls */
static rts_time_test*   readcall = (rts_time_test*)NULL;   /* read calls */
static gint             audproc_audio_rts_test_next_step = 0;
static gint             audproc_audio_rts_test_index = 0;
static gchar            audproc_read_perf_file_name[300];
static gchar            audproc_write_perf_file_name[300];
static gint             audproc_audio_rts_read_call_track_next_step = 0;
static gint             ecnr_audio_rts_nb_step = 0;
static GString*         test_fct_name;
static GString*         test_fct_read_name;
static gint             isreadperform = 0;
static gint             iswriteperform = 0;
//static struct timespec  ecnr_audio_rts_read_enter_time = {0};
//static struct timespec  ecnr_audio_rts_read_return_time = {0};
//static struct timespec  ecnr_audio_rts_read_last_ok_time = {0};

record_desc      mic_rec_desc;
record_desc      ent_rec_desc;
record_desc      info_rec_desc;

/*************************
 * RTS log
 **************************/

#ifdef D_ENABLE_RTS_LOG_CB
#define AUDPROC_AUDIO_RTS_LOG_LIMIT 200
static void audproc_audio_rts_log_cb_voice(const char* msg)
{
    if(!msg)
    {
        /* do nothing */
        return;
    }

    /* split message if bigger as AUDPROC_AUDIO_RTS_LOG_LIMIT */
  gulong logLength = strlen(msg);
  GString *logmsg;

  while (logLength > AUDPROC_AUDIO_RTS_LOG_LIMIT)
  {
    int actualLimit = AUDPROC_AUDIO_RTS_LOG_LIMIT - 1;
    for (; actualLimit >= 0; actualLimit--)
    {
      if ((msg[actualLimit] == 0x0a) || msg[actualLimit] == 0x0d)
        break;
    }

    logmsg = g_string_new (NULL);

    if(actualLimit < 0)
      actualLimit = AUDPROC_AUDIO_RTS_LOG_LIMIT;

    g_string_append_len(logmsg, msg, actualLimit);

    ETG_TRACE_USR4(("[RTS_LIB_MSG]: %s", logmsg->str ));

    logLength = logLength - (gulong)actualLimit;

    msg = msg + actualLimit;
    g_string_free(logmsg, TRUE);
  }


    ETG_TRACE_USR4(("[RTS_LIB_MSG]:[SRC_VOICE}: %s", msg ));

    return;
}

static void audproc_audio_rts_log_cb_ent(const char* msg)
{
    if(!msg)
    {
        /* do nothing */
        return;
    }
    /* split message if bigger as AUDPROC_AUDIO_RTS_LOG_LIMIT */
  gulong logLength = strlen(msg);
  GString *logmsg;

  while (logLength > AUDPROC_AUDIO_RTS_LOG_LIMIT)
  {
    int actualLimit = AUDPROC_AUDIO_RTS_LOG_LIMIT - 1;
    for (; actualLimit >= 0; actualLimit--)
    {
      if ((msg[actualLimit] == 0x0a) || msg[actualLimit] == 0x0d)
        break;
    }

    logmsg = g_string_new (NULL);

    if(actualLimit < 0)
      actualLimit = AUDPROC_AUDIO_RTS_LOG_LIMIT;

    g_string_append_len(logmsg, msg, actualLimit);

    ETG_TRACE_USR4(("[RTS_LIB_MSG]: %s", logmsg->str ));

    logLength = logLength - (gulong)actualLimit;

    msg = msg + actualLimit;
    g_string_free(logmsg, TRUE);

  }

    ETG_TRACE_USR4(("[RTS_LIB_MSG]:[SRC_ENT]: %s", msg ));

    return;
}

static void audproc_audio_rts_log_cb_info(const char* msg)
{
    if(!msg)
    {
        /* do nothing */
        return;
    }

    /* split message if bigger as AUDPROC_AUDIO_RTS_LOG_LIMIT */
  gulong logLength = strlen(msg);
  GString *logmsg;

  while (logLength > AUDPROC_AUDIO_RTS_LOG_LIMIT)
  {
    int actualLimit = AUDPROC_AUDIO_RTS_LOG_LIMIT - 1;
    for (; actualLimit >= 0; actualLimit--)
    {
      if ((msg[actualLimit] == 0x0a) || msg[actualLimit] == 0x0d)
        break;
    }

    logmsg = g_string_new (NULL);

    if(actualLimit < 0)
      actualLimit = AUDPROC_AUDIO_RTS_LOG_LIMIT;

    g_string_append_len(logmsg, msg, actualLimit);

    ETG_TRACE_USR4(("[RTS_LIB_MSG]: %s", logmsg->str ));

    logLength = logLength - (gulong)actualLimit;

    msg = msg + actualLimit;
    g_string_free(logmsg, TRUE);
  }

    ETG_TRACE_USR4(("[RTS_LIB_MSG]:[SRC_INFO}: %s", msg ));

    return;
}
#endif

/*******************************************************************************
*
* FUNCTION:
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
static void audproc_audio_rts_handler_print_config_data(trts_cfg* rts_cfg)
{
    guint i =0;
    trts_cfgadev_imp* d;
    trts_cfgstream* s;
    gchar s_dev_info_print[300];

    if(rts_cfg)
    {
        pr_message("device num = %d, stream num = %d, prefill level= %d ",rts_cfg->num_adevs,rts_cfg->num_streams, rts_cfg->prefill_ms);
        ETG_TRACE_USR3(("[audproc_audio_rts_handler_print_config_data]: device num = %d, stream num = %d, prefill level= %d ",rts_cfg->num_adevs,rts_cfg->num_streams, rts_cfg->prefill_ms));

        if(rts_cfg->adevs)
        {
            for (i=0 ; i < rts_cfg->num_adevs ; i++)
            {
                d = (trts_cfgadev_imp*)&rts_cfg->adevs[i];
                pr_message("adevs[%d] :: dev name:%s, dir: %d, rate: %d, period_frames: %d, format:%d, startup_tout:%d, stream_tout:%d",
                                    i, d->pcmname,d->dir,d->rate,d->period_frames,d->format, d->startup_tout,  d->stream_tout);

                memset(s_dev_info_print,0,300);
                sprintf(s_dev_info_print, "adevs[%d] :: dev name:%s, dir: %d, rate: %d, period_frames: %d, format:%d, startup_tout:%d, stream_tout:%d",
                                    i, d->pcmname,d->dir,d->rate,d->period_frames,d->format, d->startup_tout,  d->stream_tout);

                ETG_TRACE_USR3(("[audproc_audio_rts_handler_print_config_data]: %s",s_dev_info_print));
            }

            for (i=0; i < rts_cfg->num_streams;i++)
            {
                s=&rts_cfg->streams[i];
                pr_message("streams[%d] :: adev Idx: %d, channel: %d", i, s->adevidx,s->channel);
                ETG_TRACE_USR3(("[audproc_audio_rts_handler_print_config_data]: streams[%d] :: adev Idx: %d, channel: %d", i, s->adevidx,s->channel));
            }
        }
        else
        {
            pr_message(" No rts device configuration available \n");
            ETG_TRACE_USR3(("[audproc_audio_rts_handler_print_config_data]: No rts device configuration available \n"));
        }
    }
    else
    {
        pr_message(" No rts configuration available \n");
        ETG_TRACE_USR3(("[audproc_audio_rts_handler_print_config_data]: No rts device configuration available \n"));
    }
}



static rts_inst_desc* audproc_audio_rts_handler_get_dev_descriptor(audproc_alsa_state* state, gint16 dev_dir)
{

    rts_inst_desc*      p =  (rts_inst_desc*)NULL;
    int                 i;
    guint               dir;
    trts_cfgadev_imp*   ad = (trts_cfgadev_imp*)NULL;
    char*               dev_name;
    guint               prefill;

    pr_debug("ENTERED");

    if(!state)
        return   (rts_inst_desc*)NULL;

    if(!state->adevs)
        return   (rts_inst_desc*)NULL;

    if(dev_dir == D_CONV_CAPTURE_DEVICE)
    {
        dir         = ADEV_CAPTURE_IN;
        ad          = &state->adevs[ADEV_CAPTURE_IN];
        dev_name    = g_strdup(state->audproc_stream_data->indev.audproc_dev_name);
        prefill     = state->cap_prefill_ms;
    }
    else if(dev_dir == D_CONV_PLAYBACK_DEVICE)
    {
        dir         = ADEV_PLAYBACK_OUT;
        ad          = &state->adevs[ADEV_PLAYBACK_OUT];
        dev_name    = g_strdup(state->audproc_stream_data->outdev.audproc_dev_name);
        prefill     = state->pb_prefill_ms;
    }
    else if(dev_dir == D_CONV_LOOPBACK_DEVICE)
    {
        dir         = ADEV_LOOPBACK_OUT;
        ad          = &state->adevs[ADEV_LOOPBACK_OUT];
        dev_name    = g_strdup(state->audproc_stream_data->lpdev.audproc_dev_name);
        prefill     = state->lp_prefill_ms;
    }
    else
    {
        pr_warning("requested dev direction(%d) not supported\n", dev_dir);
        return (rts_inst_desc*)NULL;
    }

    pr_debug("*************search device descriptor ***************** \n");
    pr_debug("device name                   :%s\n", dev_name );
    pr_debug("device dir                    :%d\n", dir );
    pr_debug("device stream period frame    :%d\n", ad->period_frames );
    pr_debug("device stream format          :%d\n", ad->format );
    pr_debug("device prefill                :%d\n", prefill );

    for( i = 0; i < D_RTS_NB_INST_MAX; i++)
    {
        p = rts_inst_list[i];

        if(p)
        {
            if(!g_strcmp0(p->dev_name, dev_name))
            {
                pr_debug("********compare device descriptor *************** \n");
                pr_debug("device name                   :%s\n", p->dev_name );
                pr_debug("device dir                    :%d\n", dir );
                pr_debug("device stream period frame    :%d\n", p->adevs[dir].period_frames );
                pr_debug("device stream format          :%d\n", p->adevs[dir].format );
                pr_debug("device prefill                :%d\n", p->rtsdata->prefill_ms );

                if(    (p->adevs[dir].period_frames == ad->period_frames)
                    && (p->adevs[dir].format        == ad->format)
                    && (p->rtsdata->prefill_ms    == prefill))
                {
                    pr_message("found descriptor of device \"%s\"\n", dev_name);
                    ETG_TRACE_USR3(("[audproc_audio_rts_handler_get_dev_descriptor]: found descriptor of device \"%s\"", dev_name));
                    if(dev_name)
                        g_free(dev_name);
                    return p;
                }
                else
                {
                    pr_message("descriptor not matching \n");
                }
            }
        }
    }

    if(dev_name)
        g_free(dev_name);

    return   (rts_inst_desc*)NULL;
}



static rts_inst_desc* audproc_audio_rts_handler_is_dev_open(const char* adev, gint16 dev_dir )
{

    rts_inst_desc*      p =  (rts_inst_desc*)NULL;
    int i;


    if(!adev)
        return   (rts_inst_desc*)NULL;

    pr_message("ENTERED, check device %s\n", adev);
    ETG_TRACE_USR3(("[audproc_audio_rts_handler_is_dev_open]: ENTERED, check device %s", adev));

    for( i = 0; i < D_RTS_NB_INST_MAX; i++)
    {
        p = rts_inst_list[i];
        if(p)
        {
            pr_debug("check device \"%s\", active_state:%d, dir: %d\n", p->dev_name, p->isActive, p->dev_dir );
            if(!g_strcmp0(p->dev_name, adev))
            {
                if(     p->isActive
                    && (p->dev_dir == dev_dir))
                {
                    pr_message("the device \"%s\" is open\n",adev);
                    ETG_TRACE_USR3(("[audproc_audio_rts_handler_is_dev_open]: the device \"%s\" is open", adev));
                    return p;
                }
            }
        }
    }

    return   (rts_inst_desc*)NULL;
}

static int audproc_audio_rts_handler_desc_close_dev(rts_inst_desc* desc, gboolean force_close)
{
    int err = AUDPROC_ERR_OK;

    pr_debug("ENTERED");
    ETG_TRACE_USR3(("[audproc_audio_rts_handler_desc_close_dev]: ENTERED"));

    g_mutex_lock(&m_rts_lock);

    if(!desc)
    {
        pr_critical("device descriptor not available\n");
        err = AUDPROC_ERR_NULL_POINTER; //return AUDPROC_ERR_NULL_POINTER;
    }

    //g_mutex_lock(&m_rts_lock);

    if(!err)
    {
        if(desc->rts_handle != NULL && desc->isActive)
        {
            pr_debug("rts_destroy device \"%s\" with handle(%p)\n", desc->dev_name, desc->rts_handle);

            err = rts_destroy(desc->rts_handle);
            if(err)
                pr_critical("rts_destroy device \"%s\" failed with error(%d)\n", desc->dev_name, err);

            desc->rts_handle    = NULL;
            desc->isActive      = FALSE;
            desc->isCloseforced = force_close;

            pr_message("close instance of device -> \"%s\" \n", desc->dev_name);
            ETG_TRACE_USR3(("[audproc_audio_rts_handler_desc_close_dev]: close instance of device -> \"%s\" ", desc->dev_name));

        }
        else
        {
            pr_warning("current rts handle:%p and isActive:%d , rts_destroy is not called\n",desc->rts_handle, desc->isActive);
        }
    }

    g_mutex_unlock(&m_rts_lock);

    return   err;
}

void audproc_audio_rts_handler_print_audio_route_config(void)
{

    rts_inst_desc*      p =  (rts_inst_desc*)NULL;
    int i;


    for( i = 0; i < D_RTS_NB_INST_MAX; i++)
    {
        p = rts_inst_list[i];
        if(p)
        {
            pr_message("---- audio_route_nr_%d_top ----\n", i);
            pr_message("- dev_name:    %s \n", p->dev_name);
            pr_message("- isActive:    %d \n", p->isActive);
            pr_message("- rts_handle:  %p \n", p->rts_handle);
            pr_message("- dev_dir:     %d \n", p->dev_dir);

            audproc_audio_rts_handler_print_config_data(p->rtsdata);

            pr_message("---- audio_route_nr_%d_end ----\n", i);
        }
    }

}

/*******************************************************************************
*
* FUNCTION: audproc_audio_rts_handler_performance_test_init
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
void audproc_audio_rts_handler_performance_test_init(gint nb_test_step)
{

    if(!isreadperform && !iswriteperform)
        return;

    pr_message("ENTER\n");

    if(isreadperform) //  fct_name_to_test)
    {
        pr_message("TEST ENTER for function %s with %d step\n", "rts_read", nb_test_step);
    }

    if(iswriteperform) //  fct_name_to_test)
    {
        pr_message("TEST ENTER for function %s with %d step\n", "rts_write", nb_test_step);
    }

    if(!ptstub && !readcall)
    {
        if(!nb_test_step)
            ecnr_audio_rts_nb_step = D_NB_TEST_STEP_MAX;
        else
            ecnr_audio_rts_nb_step = nb_test_step;

        if(iswriteperform)
            ptstub = g_malloc0( (gsize)ecnr_audio_rts_nb_step * sizeof(rts_time_test));

        if(isreadperform)
            readcall = g_malloc0( (gsize)ecnr_audio_rts_nb_step * sizeof(rts_time_test));
    }


    if(isreadperform)
    {
        test_fct_read_name = g_string_new (NULL);
        g_string_append(test_fct_read_name, "rts_read");
    }

    if(iswriteperform)
    {
        test_fct_name = g_string_new (NULL);
        g_string_append(test_fct_name, "rts_write");
    }
    else
    {
        /* do nothing */
    }
    audproc_audio_rts_test_next_step = 0;
    audproc_audio_rts_read_call_track_next_step = 0;
    audproc_audio_rts_test_index++;


    return;
}

/*******************************************************************************
*
* FUNCTION: audproc_audio_rts_handler_performance_test_terminate
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
void audproc_audio_rts_handler_performance_test_terminate
(
    guint8              audproc_this_src,
    audproc_source_type audproc_this_src_type,
    char*               capdev,
    char*               pbdev
)
{
    rts_time_test* pd = (rts_time_test*)NULL;
    rts_time_test* pn = (rts_time_test*)NULL;
    gint i = 0;
    glong exec_time = 0;
    const char* dev_undef = "adevUndef";
    char* pdev = (char*)NULL;

    /* create a bsd file with dp element */
    FILE*   fd_bsd;   /* pointer to config data file */

    if(!isreadperform && !iswriteperform)
        return;

    pr_message("ENTER\n");

    /* evaluate all result and write in a file */
    if(iswriteperform)
    {

        if(pbdev)
            pdev = pbdev;
        else
            pdev = (char *)dev_undef;

        memset(audproc_read_perf_file_name,0,300);
        if(audproc_this_src_type == AUD_PROC_SRC_TYPE_ENT)
            sprintf(audproc_read_perf_file_name, "%s_src_ent_%d_%s_rec_%d.txt", S_AUDPROC_RTS_TEST, audproc_this_src, pdev, audproc_audio_rts_test_index);
        else if(audproc_this_src_type == AUD_PROC_SRC_TYPE_VOICE)
            sprintf(audproc_read_perf_file_name, "%s_src_voice_%d_%s_rec_%d.txt", S_AUDPROC_RTS_TEST, audproc_this_src, pdev, audproc_audio_rts_test_index);
        else if(audproc_this_src_type == AUD_PROC_SRC_TYPE_INFO)
            sprintf(audproc_read_perf_file_name, "%s_src_info_%d_%s_rec_%d.txt", S_AUDPROC_RTS_TEST, audproc_this_src, pdev, audproc_audio_rts_test_index);
        else
        {
            /*do nothing */
        }

        fd_bsd = fopen (audproc_read_perf_file_name,"a+");



        if(!test_fct_name)
        {
            pr_message("No Result available\n");
            fclose(fd_bsd);
            return;
        }

        if(test_fct_name->str)
        {
            pr_message("TEST EXIT for function %s with %d step\n", test_fct_name->str, audproc_audio_rts_test_next_step);
        }

        if(!ptstub || !audproc_audio_rts_test_next_step)
        {
            pr_message("No Result available\n");
            fclose(fd_bsd);
            return;
        }

        for(i = 0; i < audproc_audio_rts_test_next_step; i++)
        {

            if(i == audproc_audio_rts_test_next_step)
            {
                pr_message("terminate test with %d step \n", audproc_audio_rts_test_next_step);
                break;
            }
            pd = &ptstub[i];
            pn = pd;


            if(fd_bsd)
                fprintf (fd_bsd,"%d %s COMPLETE time : [%05u,%lu]\n", (i+1), (test_fct_name->str)? test_fct_name->str :"NULL", (unsigned int)pd->fct_call_complete_time.tv_sec, (unsigned long int)pd->fct_call_complete_time.tv_nsec);

            if( (i + 2) <  audproc_audio_rts_test_next_step)
            {
                pn++;

                if(pd->fct_call_complete_time.tv_sec == pn->fct_call_complete_time.tv_sec)
                {
                    exec_time = pn->fct_call_complete_time.tv_nsec - pd->fct_call_complete_time.tv_nsec;
                }
                else /* next second*/
                {
                    exec_time = (1000000000 - pd->fct_call_complete_time.tv_nsec) + pn->fct_call_complete_time.tv_nsec;
                }

                if(fd_bsd)
                    fprintf (fd_bsd,"%d %s call EXEC time : [%ld]\n", (i+1), (test_fct_name->str)? test_fct_name->str :"NULL", exec_time);
            }
        }


        if (NULL != fd_bsd)
        {
            fclose(fd_bsd);
        }

        g_string_free(test_fct_name, TRUE);
        if(ptstub)
        {
            g_free(ptstub);
            ptstub = NULL;
        }
    }

    if(isreadperform)
    {
        if(capdev)
            pdev = capdev;
        else
            pdev = (char *)dev_undef;

        memset(audproc_write_perf_file_name,0,300);
        if(audproc_this_src_type == AUD_PROC_SRC_TYPE_ENT)
            sprintf(audproc_write_perf_file_name, "%s_src_ent_%d_%s_rec_%d.txt", S_AUDPROC_RTS_READ_TEST, audproc_this_src, pdev, audproc_audio_rts_test_index);
        else if(audproc_this_src_type == AUD_PROC_SRC_TYPE_VOICE)
            sprintf(audproc_write_perf_file_name, "%s_src_voice_%d_%s_rec_%d.txt", S_AUDPROC_RTS_READ_TEST, audproc_this_src, pdev, audproc_audio_rts_test_index);
        else if(audproc_this_src_type == AUD_PROC_SRC_TYPE_INFO)
            sprintf(audproc_write_perf_file_name, "%s_src_info_%d_%s_rec_%d.txt", S_AUDPROC_RTS_READ_TEST, audproc_this_src, pdev, audproc_audio_rts_test_index);
        else
        {
            /*do nothing */
        }

        fd_bsd = fopen (audproc_write_perf_file_name,"a+");

        if(!test_fct_read_name)
        {
            pr_message("No Result available\n");
            fclose(fd_bsd);
            return;
        }

        if(test_fct_read_name->str)
        {
            pr_message("TEST EXIT for function %s with %d step\n", test_fct_read_name->str, audproc_audio_rts_read_call_track_next_step);
        }

        if(!readcall || !audproc_audio_rts_read_call_track_next_step)
        {
            pr_message("No Result available\n");
            fclose(fd_bsd);
            return;
        }

        i = 0;

        for(i = 0; i < audproc_audio_rts_read_call_track_next_step; i++) //, pd++)
        {

            if(i == audproc_audio_rts_read_call_track_next_step)
            {
                pr_message("terminate test with %d step \n", audproc_audio_rts_read_call_track_next_step);
                break;
            }
            pd = &readcall[i];
            pn = pd;

            //if(pd)
            //{
                if(fd_bsd)
                    fprintf (fd_bsd,"%d %s COMPLETE time : [%05u,%lu]\n", (i+1), (test_fct_read_name->str)? test_fct_read_name->str :"NULL", (unsigned int)pd->fct_call_complete_time.tv_sec, (unsigned long int)pd->fct_call_complete_time.tv_nsec);

                if( (i + 2) <  audproc_audio_rts_read_call_track_next_step)
                {
                    pn++;

                    if(pd->fct_call_complete_time.tv_sec == pn->fct_call_complete_time.tv_sec)
                    {
                        exec_time = pn->fct_call_complete_time.tv_nsec - pd->fct_call_complete_time.tv_nsec;
                    }
                    else /* next second*/
                    {
                        exec_time = (1000000000 - pd->fct_call_complete_time.tv_nsec) + pn->fct_call_complete_time.tv_nsec;
                    }

                    if(fd_bsd)
                        fprintf (fd_bsd,"%d %s call EXEC time : [%ld]\n", (i+1), (test_fct_read_name->str)? test_fct_read_name->str :"NULL", exec_time);
                }
            //}
            //else
            //    pr_message("No Result available - 2\n");
        }


        if (NULL != fd_bsd)
        {
            fclose(fd_bsd);
        }

        g_string_free(test_fct_read_name, TRUE);
        if(readcall)
        {
            g_free(readcall);
            readcall = NULL;
        }
    }

    return;
}

inline static void audproc_audio_rts_handler_performance_write_complet_timestamp(void)
{

    if(!ptstub  || (audproc_audio_rts_test_next_step >= ecnr_audio_rts_nb_step))
        return;

    rts_time_test* p = &ptstub[audproc_audio_rts_test_next_step++];

    clock_gettime(CLOCK_MONOTONIC, &p->fct_call_complete_time);
    return;
}


inline static void audproc_audio_rts_handler_performance_read_complet_timestamp(void)
{

    if(!readcall  || (audproc_audio_rts_read_call_track_next_step >= ecnr_audio_rts_nb_step))
        return;

    rts_time_test* p = &readcall[audproc_audio_rts_read_call_track_next_step++];

    clock_gettime(CLOCK_MONOTONIC, &p->fct_call_complete_time);
    return;
}


/*******************************************************************************
*
* FUNCTION: audproc_audio_rts_handler_create_this
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
static int audproc_audio_rts_handler_create_this(rts_inst_desc* desc)
{
    gint err = AUDPROC_ERR_OK;

    pr_debug("ENTER");

    if(!desc)
    {
        pr_critical("desc structure pointer not initialized\n");
        return AUDPROC_ERR_NULL_POINTER;
    }

    if(!desc->rtsdata)
    {
        pr_warning("no structure rts structure initialized\n");
        return  AUDPROC_ERR_NULL_POINTER;
    }

    g_mutex_lock(&m_rts_lock);

    /* write though the alsa devices*/
    err = rts_create(&desc->rts_handle, desc->rtsdata);

    if(err)
    {
        if(err == -38)
        {
            /* ignore this failure */
            pr_warning("ignore err  %d", err);
            err = 0;
        }
        else
        {
            pr_critical("fail to create rts instance with err : %d", err);
        }
    }

    g_mutex_unlock(&m_rts_lock);
    pr_debug("EXIT");

    return err;
}


static int  audproc_audio_rts_handler_release_this_instance(rts_inst_desc*  p)
{
    pr_debug("ENTERED");

    if(!p)
        return AUDPROC_ERR_NULL_POINTER;

    if(p->dev_name)
    {
        pr_debug("free device descriptor %s\n", p->dev_name);
        g_free(p->dev_name);
    }

    if(p->adevs)
    {
        g_free((gpointer)p->adevs->pcmname);
        p->adevs->pcmname = NULL;

        g_free(p->adevs);
        p->adevs = NULL;
    }

    if(p->streamdefs)
    {
        g_free(p->streamdefs);
        p->streamdefs = NULL;
    }

    if(p->rtsdata)
    {
        g_free(p->rtsdata);
        p->rtsdata = NULL;
    }

    g_free(p);


    return AUDPROC_ERR_OK;
}




static rts_inst_desc* audproc_audio_rts_handler_create_inst_desc(audproc_alsa_state* state, const gchar* instance_name, gint16 dev_dir, unsigned int prefill_ms, trts_logcb cb)
{

    int err = AUDPROC_ERR_OK;
    rts_inst_desc*      p =  (rts_inst_desc*)NULL;
    rts_inst_desc*      new =  (rts_inst_desc*)NULL;
    guint i, j;
    guint rts_inst_idx;


    pr_message("setup rts instance for device: \"%s\" \n", instance_name?instance_name:"NULL");

    if(!instance_name || !state )
        return (rts_inst_desc*)NULL;

    /* search for instance for the configured devices and configuration */
    for( rts_inst_idx = 0; rts_inst_idx <= D_RTS_NB_INST_MAX; rts_inst_idx++)
    {
        if(rts_inst_idx >= D_RTS_NB_INST_MAX)
        {
            pr_warning("rts instance index out of bound\n");
            return (rts_inst_desc*)NULL;
        }
        p = rts_inst_list[rts_inst_idx];
        if(!p)
        {
            /* create new rts descriptor */
            new = g_malloc0(sizeof(rts_inst_desc));

            if(new)
            {
                new->dev_name       = g_strdup(instance_name);
                new->dev_dir        = dev_dir;
                new->isActive       = FALSE;
                new->isCloseforced  = FALSE;

                pr_message("create new rts descriptor with device \"%s\" \n",instance_name?instance_name:"NULL");
                break;
            }
        }
    }


    if(!new)
    return (rts_inst_desc*)NULL;


    /* create rts data structure*/
    new->rtsdata = g_malloc0(sizeof(trts_cfg));
    new->adevs   = g_malloc0(D_MAX_DEVS * sizeof(trts_cfgadev_imp));

    if(new->adevs)
    {
        if(dev_dir == D_CONV_CAPTURE_DEVICE)
        {
            new->adevs[ADEV_CAPTURE_IN].pcmname          = g_strdup(instance_name);
            new->adevs[ADEV_CAPTURE_IN].dir              = SND_PCM_STREAM_CAPTURE;
            new->adevs[ADEV_CAPTURE_IN].rate             = state->adevs[ADEV_CAPTURE_IN].rate;
            new->adevs[ADEV_CAPTURE_IN].period_frames    = state->adevs[ADEV_CAPTURE_IN].period_frames; //128;  /* 8ms period */
            new->adevs[ADEV_CAPTURE_IN].format           = state->adevs[ADEV_CAPTURE_IN].format; //ND_PCM_FORMAT_S32_LE;
            new->adevs[ADEV_CAPTURE_IN].startup_tout     = state->adevs[ADEV_CAPTURE_IN].startup_tout; //100; /* 100 ms timeout*/
            new->adevs[ADEV_CAPTURE_IN].stream_tout      = state->adevs[ADEV_CAPTURE_IN].stream_tout; //100; /* 100 ms timeout*/


            pr_message("set capture device : pcmname(%s), dir(%d), rate(%d), period_frames(%d), format(%d), startup_tout(%d), stream_tout(%d)\n",\
                new->adevs[ADEV_CAPTURE_IN].pcmname,\
                new->adevs[ADEV_CAPTURE_IN].dir, \
                new->adevs[ADEV_CAPTURE_IN].rate, \
                new->adevs[ADEV_CAPTURE_IN].period_frames, \
                new->adevs[ADEV_CAPTURE_IN].format, \
                new->adevs[ADEV_CAPTURE_IN].startup_tout, \
                new->adevs[ADEV_CAPTURE_IN].stream_tout);


        }
        else if(dev_dir == D_CONV_PLAYBACK_DEVICE)
        {
            new->adevs[ADEV_PLAYBACK_OUT].pcmname          = g_strdup(instance_name);
            new->adevs[ADEV_PLAYBACK_OUT].dir              = SND_PCM_STREAM_PLAYBACK;
            new->adevs[ADEV_PLAYBACK_OUT].rate             = state->adevs[ADEV_PLAYBACK_OUT].rate;
            new->adevs[ADEV_PLAYBACK_OUT].period_frames    = state->adevs[ADEV_PLAYBACK_OUT].period_frames; //128;  /* 8ms period */
            new->adevs[ADEV_PLAYBACK_OUT].format           = state->adevs[ADEV_PLAYBACK_OUT].format; //ND_PCM_FORMAT_S32_LE;
            new->adevs[ADEV_PLAYBACK_OUT].startup_tout     = state->adevs[ADEV_PLAYBACK_OUT].startup_tout; //100; /* 100 ms timeout*/
            new->adevs[ADEV_PLAYBACK_OUT].stream_tout      = state->adevs[ADEV_PLAYBACK_OUT].stream_tout; //100; /* 100 ms timeout*/

            pr_message("set playback device : pcmname(%s), dir(%d), rate(%d), period_frames(%d), format(%d), startup_tout(%d), stream_tout(%d)\n",\
                new->adevs[ADEV_PLAYBACK_OUT].pcmname,\
                new->adevs[ADEV_PLAYBACK_OUT].dir, \
                new->adevs[ADEV_PLAYBACK_OUT].rate, \
                new->adevs[ADEV_PLAYBACK_OUT].period_frames, \
                new->adevs[ADEV_PLAYBACK_OUT].format, \
                new->adevs[ADEV_PLAYBACK_OUT].startup_tout, \
                new->adevs[ADEV_PLAYBACK_OUT].stream_tout);
        }
        else if(dev_dir == D_CONV_LOOPBACK_DEVICE)
        {
            new->adevs[ADEV_LOOPBACK_OUT].pcmname          = g_strdup(instance_name);
            new->adevs[ADEV_LOOPBACK_OUT].dir              = SND_PCM_STREAM_PLAYBACK;
            new->adevs[ADEV_LOOPBACK_OUT].rate             = state->adevs[ADEV_LOOPBACK_OUT].rate;
            new->adevs[ADEV_LOOPBACK_OUT].period_frames    = state->adevs[ADEV_LOOPBACK_OUT].period_frames; //128;  /* 8ms period */
            new->adevs[ADEV_LOOPBACK_OUT].format           = state->adevs[ADEV_LOOPBACK_OUT].format; //ND_PCM_FORMAT_S32_LE;
            new->adevs[ADEV_LOOPBACK_OUT].startup_tout     = state->adevs[ADEV_LOOPBACK_OUT].startup_tout; //100; /* 100 ms timeout*/
            new->adevs[ADEV_LOOPBACK_OUT].stream_tout      = state->adevs[ADEV_LOOPBACK_OUT].stream_tout; //100; /* 100 ms timeout*/

            pr_message("set pcmname(%s), dir(%d), rate(%d), period_frames(%d), format(%d), startup_tout(%d), stream_tout(%d)\n", \
                new->adevs[D_CONV_LOOPBACK_DEVICE].pcmname,\
                new->adevs[D_CONV_LOOPBACK_DEVICE].dir, \
                new->adevs[D_CONV_LOOPBACK_DEVICE].rate, \
                new->adevs[D_CONV_LOOPBACK_DEVICE].period_frames, \
                new->adevs[D_CONV_LOOPBACK_DEVICE].format, \
                new->adevs[D_CONV_LOOPBACK_DEVICE].startup_tout, \
                new->adevs[D_CONV_LOOPBACK_DEVICE].stream_tout);


        }
    }


    /* initiate rts configuration structure */
    new->rtsdata->features    = state->rtsdata->features;
    new->rtsdata->num_adevs   = 3;
    new->rtsdata->prefill_ms  = prefill_ms; //state->rtsdata->prefill_ms;
#ifdef D_ENABLE_RTS_LOG_CB
    new->rtsdata->log_callback  = cb;
    ETG_TRACE_USR4(("[audproc_audio_rts_handler_create_inst_desc]: registry RTS library Loggger callback function"));
#endif

    new->streamdefs = g_malloc0(D_MAX_STREAMS * sizeof(trts_cfgstream));

    /* configures capture streams*/
    if(dev_dir == D_CONV_CAPTURE_DEVICE)
    {
        j = 0;
        for(i = 0; i < state->rtsdata->num_streams; i++)
        {
            if(state->streamdefs[i].adevidx == (int)ADEV_CAPTURE_IN)
            {
                new->streamdefs[j].adevidx = (int)ADEV_CAPTURE_IN;
                new->streamdefs[j].channel = state->streamdefs[i].channel;
                pr_message("set for capture stream[%d], devidx(%d), channel(%d)\n", j,\
                                                                               new->streamdefs[j].adevidx,\
                                                                               new->streamdefs[j].channel);
                j++;
            }
        }

        new->rtsdata->num_streams = j;
    }

    /* configures playback  streams*/
    else if(dev_dir == D_CONV_PLAYBACK_DEVICE)
    {
        j = 0;
        for(i = 0; i < state->rtsdata->num_streams; i++)
        {

            if(state->streamdefs[i].adevidx == (int)ADEV_PLAYBACK_OUT)
            {
                new->streamdefs[j].adevidx = (int)ADEV_PLAYBACK_OUT;
                new->streamdefs[j].channel = state->streamdefs[i].channel;
                pr_message("set for playback stream[%d], devidx(%d), channel(%d)\n", j,\
                                                                               new->streamdefs[j].adevidx,\
                                                                               new->streamdefs[j].channel);
                j++;
            }
        }
        new->rtsdata->num_streams = j;
    }

    /* configures playback  streams*/
    else if(dev_dir == D_CONV_LOOPBACK_DEVICE)
    {
        j = 0;
        for(i = 0; i < state->rtsdata->num_streams; i++)
        {

            if(state->streamdefs[i].adevidx == (int)ADEV_LOOPBACK_OUT)
            {
                new->streamdefs[j].adevidx = (int)ADEV_LOOPBACK_OUT;
                new->streamdefs[j].channel = state->streamdefs[i].channel;
                pr_message("set for loopback stream[%d], devidx(%d), channel(%d)\n", j,\
                                                                               new->streamdefs[j].adevidx,\
                                                                               new->streamdefs[j].channel);
                j++;
            }
        }
        new->rtsdata->num_streams = j;
    }

    new->rtsdata->adevs       = (trts_cfgadev*)new->adevs;
    new->rtsdata->streams     = new->streamdefs;

    pr_message("set num_stream(%d), num_adevs(%d), prefill_ms(%d)\n", new->rtsdata->num_streams,\
                                                                      new->rtsdata->num_adevs, \
                                                                      new->rtsdata->prefill_ms);


    /* create new rts instance */
    err = audproc_audio_rts_handler_create_this(new);
    if(!err)
    {
        state->rts_read_cnt = 0;
        state->rts_write_cnt = 0;
        state->rts_read_err_occured = FALSE;
        state->rts_write_err_occured = FALSE;

        new->isActive = TRUE;

        /*store new instance */
        rts_inst_list[rts_inst_idx] = new;
        pr_message("store rts desciptor for device: %s, direction: %d, prefill: %d ", new->dev_name, dev_dir, prefill_ms);

        audproc_audio_rts_handler_print_config_data(new->rtsdata);

        return new;
    }
    else
    {
        /* instance creation fails, release all resources */
        err = audproc_audio_rts_handler_release_this_instance(new);
        if(err)
        {
            pr_warning("fails to release rts descriptor \n");
        }
    }

    return (rts_inst_desc*)NULL;
}



/*******************************************************************************
*
* FUNCTION: audproc_audio_rts_handler_create_new_inst_desc
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int audproc_audio_rts_handler_create_new_inst_desc(audproc_alsa_state* state, const gchar* instance_name, gint16 dev_dir, unsigned int prefill_ms, trts_logcb cb)
{
    int err = AUDPROC_ERR_OK;
    rts_inst_desc*      p =  (rts_inst_desc*)NULL;
    rts_inst_desc*      active_dev_desc =  (rts_inst_desc*)NULL;


    /* search for instance for the configured devices and configuration */
    p = audproc_audio_rts_handler_get_dev_descriptor(state, dev_dir);
    if(p)
    {
        pr_message("a rts instance for the device: \"%s\" is already available\n", instance_name);
        ETG_TRACE_USR3(("[audproc_audio_rts_handler_create_new_inst_desc]: a rts instance for the device: \"%s\" is already available", instance_name));
    }
    else /* rts instance for this device is not available, create a new one */
    {
        active_dev_desc = audproc_audio_rts_handler_is_dev_open(instance_name, dev_dir);
        if(active_dev_desc)
        {
            err = audproc_audio_rts_handler_desc_close_dev(active_dev_desc, FALSE);
        }
        /* now create a new descriptor and open device  */
        p = audproc_audio_rts_handler_create_inst_desc(state, instance_name, dev_dir, prefill_ms, cb);
        if(p)
        {
            pr_message("new rts instance for the device: \"%s\" \n", instance_name);
            ETG_TRACE_USR3(("[audproc_audio_rts_handler_create_new_inst_desc]: new rts instance for the device: \"%s\"", instance_name));

            if(dev_dir == D_CONV_PLAYBACK_DEVICE)
            {
                state->rts_pb_hdl = p->rts_handle;
                state->rts_pb_desc = p;
                pr_message("rts_pb_hdl ->%p\n",state->rts_pb_hdl );
                pr_message("rts_pb_desc->%p\n",state->rts_pb_desc );
            }
            else if(dev_dir == D_CONV_CAPTURE_DEVICE)
            {
                state->rts_cap_hdl = p->rts_handle;
                state->rts_cap_desc = p;
            }
            else if(dev_dir == D_CONV_LOOPBACK_DEVICE)
            {
                state->rts_lp_hdl = p->rts_handle;
                state->rts_lp_desc = p;
            }
            else
            {
                /* do nothing */
            }
        }
        else
        {
            /*fails to create a device descriptor */
            err = AUDPROC_ERR_RTS_DEVICE_INSTANCE_CREATION_FAILS;
        }
    }

    return err;
}

void audproc_audio_rts_handler_performance_init(void)
{
    /* performance test */
    const char* sRec_rts_read_write = getenv("AUDPROC_RTS_PERFORMANCE_AVAILABLE");

    if(sRec_rts_read_write)
    {
        pr_message("FEAT AUDPROC_RTS_PERFORMANCE_AVAILABLE = %s\n", sRec_rts_read_write);
    }

    if (!g_strcmp0(sRec_rts_read_write, "1"))  // record read stream only
    {
        isreadperform = 1;
        iswriteperform = 0;
    }
    else if (!g_strcmp0(sRec_rts_read_write, "2"))  // record playback stream only
    {
        isreadperform = 0;
        iswriteperform = 1;
    }
    else if (!g_strcmp0(sRec_rts_read_write, "3"))  // record playback / read  streams
    {
        isreadperform   = 1;
        iswriteperform  = 1;
    }
    else
    {
        /* do nothing */
        isreadperform  = 0;
        iswriteperform = 0;
    }
}

static void audproc_audio_rts_handler_cb_init(void)
{
    int                    cfgidx;
    audproc_alsa_stream_cfg*        ps = (audproc_alsa_stream_cfg*)NULL;

    pr_message("ENTERED");


    /* walk through the configuration */
    gint nb_route_max = audproc_configuration_get_route_cfg_nb_max();


    for(cfgidx = 0; cfgidx < nb_route_max; cfgidx++)
    {
        ps = audproc_configuration_get_route_cfg_list_idx((guint)cfgidx);
        if(!ps)
        {
            pr_warning("no streaming configuration available for cfgidx(%d)\n", cfgidx);
            continue;
        }
        else
        {
            /*set rts log callback fucntion */
            if(ps->audcfg.audproc_this_src_type == AUD_PROC_SRC_TYPE_ENT)
            {
                ps->audproc_rts_log_cb = audproc_audio_rts_log_cb_ent;
            }
            else if(ps->audcfg.audproc_this_src_type == AUD_PROC_SRC_TYPE_VOICE)
            {
                ps->audproc_rts_log_cb = audproc_audio_rts_log_cb_voice;
            }
            else if(ps->audcfg.audproc_this_src_type == AUD_PROC_SRC_TYPE_INFO)
            {
                ps->audproc_rts_log_cb = audproc_audio_rts_log_cb_info;
            }
            else
            {
                /* do nothing */
            }
        }
    }

    return;
}

/*******************************************************************************
*
* FUNCTION: audproc_audio_rts_handler_init
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int  audproc_audio_rts_handler_init(void)
{

    pr_message("ENTERED\n");


    /* create instance liste */
    memset(rts_inst_list,0 ,D_RTS_NB_INST_MAX * sizeof(rts_inst_desc*));

    /*initialize mutex */
    g_mutex_init(&m_rts_lock);

    /* init recording feature */
    audproc_audio_recording_init();

    /* init performance test */
    audproc_audio_rts_handler_performance_init();

#ifdef D_ENABLE_RTS_LOG_CB
    /* init rts log callback */
    audproc_audio_rts_handler_cb_init();
#endif

    return AUDPROC_ERR_OK;
}

/*******************************************************************************
*
* FUNCTION: audproc_audio_rts_handler_finalize
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int  audproc_audio_rts_handler_finalize(void)
{
    rts_inst_desc*      p =  (rts_inst_desc*)NULL;
    unsigned int i;

    pr_message("ENTERED\n");

    /* search for instance for the configured devices and configuration */
    for( i = 0; i < D_RTS_NB_INST_MAX; i++)
    {
        p = rts_inst_list[i];
        if(p)
        {

            /* destroy rts instance */
            (void)audproc_audio_rts_handler_desc_close_dev(p, FALSE);

            if(p->dev_name)
            {
                pr_debug("free device descriptor \"%s\"\n", p->dev_name);
                g_free(p->dev_name);
            }

            if(p->adevs)
            {
                g_free((gpointer)p->adevs->pcmname);
                p->adevs->pcmname = NULL;

                g_free(p->adevs);
                p->adevs = NULL;
            }

            if(p->streamdefs)
            {
                g_free(p->streamdefs);
                p->streamdefs = NULL;
            }

            if(p->rtsdata)
            {
                g_free(p->rtsdata);
                p->rtsdata = NULL;
            }

            g_free(p);
            rts_inst_list[i] = (rts_inst_desc*)NULL;
        }
    }

    /* free ent record structures */
    if(ent_rec_desc.in_rec_active)
    {
        if(ent_rec_desc.AudRamBufChannels_in)
        {
            // free first the channel buffer
            for (i = 0; i < ent_rec_desc.astream->indev.audproc_nb_ch ; i++ )
            {
                if(ent_rec_desc.AudRamBufChannels_in[i])
                {
                    g_free(ent_rec_desc.AudRamBufChannels_in[i]);
                    ent_rec_desc.AudRamBufChannels_in[i] = (guint8*)NULL;
                }
            }
            g_free(ent_rec_desc.AudRamBufChannels_in);
            ent_rec_desc.AudRamBufChannels_in = (guint8**)NULL;
        }

        if(ent_rec_desc.AudRamBufChannels_out)
        {
            // free firts the channel buffer
            for (i = 0; i < ent_rec_desc.astream->outdev.audproc_nb_ch ; i++ )
            {
                if(ent_rec_desc.AudRamBufChannels_out[i])
                {
                    g_free(ent_rec_desc.AudRamBufChannels_out[i]);
                    ent_rec_desc.AudRamBufChannels_out[i] = (guint8*)NULL;
                }
            }
            g_free(ent_rec_desc.AudRamBufChannels_out);
            ent_rec_desc.AudRamBufChannels_out = (guint8**)NULL;
        }

        if(ent_rec_desc.astream)
        {
           g_free(ent_rec_desc.astream);
           ent_rec_desc.astream = NULL;
        }
    }

    /* free micro record structures */
    if(mic_rec_desc.in_rec_active)
    {
        if(mic_rec_desc.AudRamBufChannels_in)
        {
            // free firts the channel buffer
            for (i = 0; i < mic_rec_desc.astream->indev.audproc_nb_ch ; i++ )
            {
                if(mic_rec_desc.AudRamBufChannels_in[i])
                {
                    g_free(mic_rec_desc.AudRamBufChannels_in[i]);
                    mic_rec_desc.AudRamBufChannels_in[i] = (guint8*)NULL;
                }
            }
            g_free(mic_rec_desc.AudRamBufChannels_in);
            mic_rec_desc.AudRamBufChannels_in = (guint8**)NULL;
        }

        if(mic_rec_desc.AudRamBufChannels_out)
        {
            // free firts the channel buffer
            for (i = 0; i < mic_rec_desc.astream->outdev.audproc_nb_ch ; i++ )
            {
                if(mic_rec_desc.AudRamBufChannels_out[i])
                {
                    g_free(mic_rec_desc.AudRamBufChannels_out[i]);
                    mic_rec_desc.AudRamBufChannels_out[i] = (guint8*)NULL;
                }
            }
            g_free(mic_rec_desc.AudRamBufChannels_out);
            mic_rec_desc.AudRamBufChannels_out = (guint8**)NULL;
        }


        if(mic_rec_desc.astream)
        {
           g_free(mic_rec_desc.astream);
           mic_rec_desc.astream = NULL;
        }
    }

    /* free micro record structures */
    if(info_rec_desc.in_rec_active)
    {
        if(info_rec_desc.AudRamBufChannels_in)
        {
            // free firts the channel buffer
            for (i = 0; i < info_rec_desc.astream->indev.audproc_nb_ch ; i++ )
            {
                if(info_rec_desc.AudRamBufChannels_in[i])
                {
                    g_free(info_rec_desc.AudRamBufChannels_in[i]);
                    info_rec_desc.AudRamBufChannels_in[i] = (guint8*)NULL;
                }
            }
            g_free(info_rec_desc.AudRamBufChannels_in);
            info_rec_desc.AudRamBufChannels_in = (guint8**)NULL;
        }

        if(info_rec_desc.AudRamBufChannels_out)
        {
            // free firts the channel buffer
            for (i = 0; i < info_rec_desc.astream->outdev.audproc_nb_ch ; i++ )
            {
                if(info_rec_desc.AudRamBufChannels_out[i])
                {
                    g_free(info_rec_desc.AudRamBufChannels_out[i]);
                    info_rec_desc.AudRamBufChannels_out[i] = (guint8*)NULL;
                }
            }
            g_free(info_rec_desc.AudRamBufChannels_out);
            info_rec_desc.AudRamBufChannels_out = (guint8**)NULL;
        }


        if(info_rec_desc.astream)
        {
           g_free(info_rec_desc.astream);
           info_rec_desc.astream = NULL;
        }
    }
    g_mutex_clear(&m_rts_lock);

    pr_message("rts related resources are freed");

    return AUDPROC_ERR_OK;
}

/*******************************************************************************
*
* FUNCTION: audproc_audio_rts_handler_recreate_ext
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int audproc_audio_rts_handler_recreate_ext(audproc_alsa_state* state, gboolean log, gint16 dev_dir, gboolean restore_state)
{
    gint err = AUDPROC_ERR_OK;
    rts_inst_desc*      active_dev_desc =  (rts_inst_desc*)NULL;
    rts_inst_desc*      desc =  (rts_inst_desc*)NULL;

    pr_message("ENTERED");
    ETG_TRACE_USR3(("[audproc_audio_rts_handler_recreate]: ENTERED"));

    if(!state)
    {
        pr_critical("state structure pointer not initialized\n");
        return AUDPROC_ERR_NULL_POINTER;
    }




    /********************************
    * first destroy current instance
    */
    if(dev_dir == D_CONV_PLAYBACK_DEVICE)
    {
        active_dev_desc = audproc_audio_rts_handler_is_dev_open(state->audproc_stream_data->outdev.audproc_dev_name, dev_dir);
        if(active_dev_desc)
            err = audproc_audio_rts_handler_desc_close_dev(active_dev_desc, FALSE);
        state->rts_pb_hdl = NULL;
        pr_message("rts_pb_hdl->%p\n",state->rts_pb_hdl );
    }
    else if(dev_dir == D_CONV_CAPTURE_DEVICE)
    {
        active_dev_desc = audproc_audio_rts_handler_is_dev_open(state->audproc_stream_data->indev.audproc_dev_name, dev_dir);
        if(active_dev_desc)
            err = audproc_audio_rts_handler_desc_close_dev(active_dev_desc, FALSE);
        state->rts_cap_hdl = NULL;
        pr_message("rts_cap_hdl->%p\n",state->rts_cap_hdl );
    }

    if(err)
    {
        /* log failor only */
        pr_debug("fails to destroy the instance of the playback device\n");
    }


    if(dev_dir == D_CONV_PLAYBACK_DEVICE)
    {
        if(!state->rts_pb_hdl)
        {
            desc = audproc_audio_rts_handler_get_dev_descriptor(state, dev_dir);

            if(!desc)
            {
                pr_critical("no device descriptor found for \"%s\"\n", state->audproc_stream_data->outdev.audproc_dev_name);
                return AUDPROC_ERR_NULL_POINTER;
            }

            if(restore_state && !desc->isCloseforced)
            {
                pr_message("the request to restore the device instance \"%s\" is denied because during the close_force request, the device instance was already released\n", state->audproc_stream_data->outdev.audproc_dev_name);
                ETG_TRACE_USR3(("[audproc_audio_rts_handler_recreate]: the request to restore the device instance \"%s\" is denied because during the close_force request, the device instance was already released", state->audproc_stream_data->outdev.audproc_dev_name));
                return AUDPROC_ERR_OK;
            }

            err = rts_create(&desc->rts_handle, desc->rtsdata);
            if(!err)
            {
                state->rts_pb_hdl = desc->rts_handle;
                pr_message("rts_pb_hdl->%p\n",state->rts_pb_hdl);
                desc->isActive = TRUE;
                desc->isCloseforced = FALSE;

                pr_message("rts_create playback device \"%s\" with handle(%p)\n",state->audproc_stream_data->outdev.audproc_dev_name, state->rts_pb_hdl);
                ETG_TRACE_USR3(("[audproc_audio_rts_handler_recreate]: recreate instance of pb device -> \"%s\" ", state->audproc_stream_data->outdev.audproc_dev_name));
            }
            else
            {
                pr_critical("rts_create playback device \"%s\" failed with error(%d)\n", state->audproc_stream_data->outdev.audproc_dev_name, err);
            }
        }
        else
        {
            pr_warning("rts instance of the playback device \"%s\" is already active, no recreate was performed\n", state->audproc_stream_data->outdev.audproc_dev_name);
        }
    }
    else if(dev_dir == D_CONV_CAPTURE_DEVICE)
    {
        if(!state->rts_cap_hdl)
        {
            desc = audproc_audio_rts_handler_get_dev_descriptor(state, dev_dir);
            if(!desc)
            {
                pr_critical("no device descriptor found for \"%s\"\n", state->audproc_stream_data->indev.audproc_dev_name);
                return AUDPROC_ERR_NULL_POINTER;
            }

            if(restore_state && !desc->isCloseforced)
            {
                pr_message("the request to restore the device instance \"%s\" is denied because during the close_force request, the device instance was already released\n", state->audproc_stream_data->outdev.audproc_dev_name);
                ETG_TRACE_USR3(("[audproc_audio_rts_handler_recreate]: the request to restore the device instance \"%s\" is denied because during the close_force request, the device instance was already released", state->audproc_stream_data->outdev.audproc_dev_name));
                return AUDPROC_ERR_OK;
            }

            err = rts_create(&desc->rts_handle, desc->rtsdata);
            if(!err)
            {
                state->rts_cap_hdl = desc->rts_handle;
                desc->isActive = TRUE;
                desc->isCloseforced = FALSE;

                pr_message("rts_create capture device with handle(%p)\n",state->rts_cap_hdl);
                ETG_TRACE_USR3(("[audproc_audio_rts_handler_recreate]: recreate instance of cap device -> \"%s\" ", state->audproc_stream_data->indev.audproc_dev_name));
            }
            else
            {
                pr_critical("rts_create capture device failed with error(%d)\n", err);
            }
        }
        else
        {
            pr_warning("rts instance of the capture device %s active, no recreate was performed\n", state->audproc_stream_data->indev.audproc_dev_name);
        }
    }
    else
    {
      /* do nothing */
    }

    //To resove Gen4 Prio2 Compiler warnings
    (void)log;

    pr_debug("EXIT\n");

    return err;
}

/*******************************************************************************
*
* FUNCTION: audproc_audio_rts_handler_close
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int audproc_audio_rts_handler_close(audproc_alsa_state* state, const gchar* dev_name, gint16 dev_dir)
{
    int                 err = AUDPROC_ERR_OK;
    rts_inst_desc*      active_dev_desc =  (rts_inst_desc*)NULL;


    if(!dev_name)
        return AUDPROC_ERR_NULL_POINTER;

    pr_message("ENTERED, close device:\"%s\" \n", dev_name);

    if(!state)
    {
        pr_critical("state structure pointer not initialized\n");
        return AUDPROC_ERR_NULL_POINTER;
    }


    /* search for instance for the configured devices and configuration */
    active_dev_desc = audproc_audio_rts_handler_get_dev_descriptor(state, dev_dir);
    if(active_dev_desc)
    {
        err = audproc_audio_rts_handler_desc_close_dev(active_dev_desc, FALSE);
        if(!err)
        {
            if(dev_dir == D_CONV_PLAYBACK_DEVICE)
            {
                state->rts_pb_hdl = NULL;
                pr_message("rts_pb_hdl->%p\n",state->rts_pb_hdl );
            }
            else if(dev_dir == D_CONV_CAPTURE_DEVICE)
                state->rts_cap_hdl = NULL;
            else
            {
                /* do nothing */
            }
        }
    }

    if(err)
    {
        /* fails to destroy instance  */
        pr_debug("fails to destroy the instance of the playback device\n");
    }
    else
    {
        pr_warning("not available rts instance for the device: \"%s\" \n", dev_name);
    }

    return err;
}


/*******************************************************************************
*
* FUNCTION: audproc_audio_rts_handler_force_close
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int audproc_audio_rts_handler_force_close(audproc_alsa_state* state, const gchar* dev_name, gint16 dev_dir)
{
    int                 err = AUDPROC_ERR_OK;
    rts_inst_desc*      active_dev_desc =  (rts_inst_desc*)NULL;


    if(!dev_name)
        return AUDPROC_ERR_NULL_POINTER;

    pr_message("ENTERED, close device:\"%s\" \n", dev_name);

    if(!state)
    {
        pr_critical("state structure pointer not initialized\n");
        return AUDPROC_ERR_NULL_POINTER;
    }


    /* search for instance for the configured devices and configuration */
    active_dev_desc = audproc_audio_rts_handler_get_dev_descriptor(state, dev_dir);
    if(active_dev_desc)
    {
        err = audproc_audio_rts_handler_desc_close_dev(active_dev_desc, TRUE);
        if(!err)
        {
            if(dev_dir == D_CONV_PLAYBACK_DEVICE)
            {
                state->rts_pb_hdl = NULL;
                pr_message("rts_pb_hdl->%p\n",state->rts_pb_hdl );
            }
            else if(dev_dir == D_CONV_CAPTURE_DEVICE)
                state->rts_cap_hdl = NULL;
            else
            {
                /* do nothing */
            }
        }
    }

    if(err)
    {
        /* fails to destroy instance  */
        pr_debug("fails to destroy the instance of the playback device\n");
    }
    else
    {
        pr_warning("not available rts instance for the device: \"%s\" \n", dev_name);
    }

    return err;
}

/*******************************************************************************
*
* FUNCTION: audproc_audio_rts_handler_ent_reset
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int audproc_audio_rts_handler_ent_reset(audproc_alsa_state* state)
{
    int                         err = AUDPROC_ERR_OK;
    audproc_alsa_stream_cfg*    pd = (audproc_alsa_stream_cfg*)NULL;
    gboolean                    force_new_create = FALSE;

    pr_message("ENTERED\n");
    ETG_TRACE_USR3(("[audproc_audio_rts_handler_ent_reset]: ENTERED"));

    if(!state)
    {
        pr_critical("state structure pointer not initialized\n");
        return AUDPROC_ERR_NULL_POINTER;
    }

    g_mutex_lock(&state->lock);

    /*******************************
     * initialize audio recording
     */
    if(   (state->audproc_stream_data->source_id == AUD_PROC_SRC_ENT1)
        ||(state->audproc_stream_data->source_id == AUD_PROC_SRC_ENT2)
        ||(state->audproc_stream_data->source_id == AUD_PROC_SRC_ENT3)
        ||(state->audproc_stream_data->source_id == AUD_PROC_SRC_ENT4)
        ||(state->audproc_stream_data->source_id == AUD_PROC_SRC_ENT5)
        ||(state->audproc_stream_data->source_id == AUD_PROC_SRC_ENT6)
        ||(state->audproc_stream_data->source_id == AUD_PROC_SRC_ENT7)
        ||(state->audproc_stream_data->source_id == AUD_PROC_SRC_ENT8)
        ||(state->audproc_stream_data->source_id == AUD_PROC_SRC_ENT9)
        ||(state->audproc_stream_data->source_id == AUD_PROC_SRC_ENT10)
        ||(state->audproc_stream_data->source_id == AUD_PROC_SRC_ENT11)
        ||(state->audproc_stream_data->source_id == AUD_PROC_SRC_ENT12)
        ||(state->audproc_stream_data->source_id == AUD_PROC_SRC_ENT13)
        ||(state->audproc_stream_data->source_id == AUD_PROC_SRC_ENT14)
        ||(state->audproc_stream_data->source_id == AUD_PROC_SRC_ENT15)
        ||(state->audproc_stream_data->source_id == AUD_PROC_SRC_ENT16)
        ||(state->audproc_stream_data->source_id == AUD_PROC_SRC_ENT17)
    )
    {

        if(ent_rec_desc.out_rec_active || ent_rec_desc.in_rec_active)
        {
            pr_debug("configure recording of entertainment source: %d\n", state->audproc_stream_data->source_id);
            pd = (audproc_alsa_stream_cfg*)audproc_configuration_get_route_cfg(state->audproc_stream_data->source_id);
            if(ent_rec_desc.astream)
                g_free(ent_rec_desc.astream);
            ent_rec_desc.astream = g_malloc0(sizeof(audproc_alsa_stream_cfg));
            memcpy((void*)ent_rec_desc.astream, (void*)pd, sizeof(audproc_alsa_stream_cfg));

            ent_rec_desc.init = 1;
            audproc_audio_recording_next_record();
            (void)audproc_audio_recording_ent_rec_file_reopen(state->audproc_stream_data);

            /* reset recording in APL */
            (void)audproc_apl_handler_command(state->aplStr, aplCmdResetRecording);
        }
    }
    else
    {
        /* do nothing */
    }

    state->rts_read_cnt = 0;
    state->rts_write_cnt = 0;
    state->rts_read_err_occured = FALSE;
    state->rts_write_err_occured = FALSE;

    g_mutex_unlock(&state->lock);


    /* now reset rts handler */
    audproc_alsa_adev_cfg* cap = (audproc_alsa_adev_cfg*)&state->audproc_stream_data->indev;
    if(cap)
    {
        pr_message("-------------- capture device current state --------------\n");
        pr_message("- audproc_create_on_start      : %d\n",cap->audproc_create_on_start);
        pr_message("- rts_cap_hdl                  : %p\n",state->rts_cap_hdl);
        if(state->rts_cap_desc)
        {
            pr_message("- isActive                 : %d\n",state->rts_cap_desc->isActive);
            pr_message("- rts_cap_desc->rts_handle : %p\n",state->rts_cap_desc->rts_handle);
            if(state->rts_cap_desc->dev_name)
            {
                pr_message("- rts_cap_desc->dev_name   : %s\n",state->rts_cap_desc->dev_name);
            }
        }
        else
        {
            pr_message("device descriptor invalid, state->rts_cap_desc(%p)\n", state->rts_cap_desc);

            rts_inst_desc*      desc =  (rts_inst_desc*)NULL;

            desc = audproc_audio_rts_handler_get_dev_descriptor(state, D_CONV_CAPTURE_DEVICE);
            if(!desc)
            {
                force_new_create = TRUE;
            }
            else
            {
                state->rts_cap_desc = desc;
                state->rts_cap_hdl  = desc->rts_handle;

                pr_message("- rts_cap_hdl                    : %p\n",state->rts_cap_hdl);
                if(state->rts_cap_desc)
                {
                    pr_message("- isActive                   : %d\n",state->rts_cap_desc->isActive);
                    pr_message("- rts_cap_desc->rts_handle   : %p\n",state->rts_cap_desc->rts_handle);
                    if(state->rts_cap_desc->dev_name)
                    {
                        pr_message("- rts_cap_desc->dev_name : %s\n",state->rts_cap_desc->dev_name);
                    }
                }
            }
        }
        pr_message("-----------------------------------------------------------\n");

        if(  (cap->audproc_create_on_start == AUD_PROC_DEVICE_OPEN_AT_STR_START_CLOSE_AT_STR_END)
           ||(cap->audproc_create_on_start == AUD_PROC_DEVICE_RECREATE_AT_STR_START_ONLY)
           || force_new_create)
        {
            err = audproc_audio_rts_handler_recreate(state, FALSE, D_CONV_CAPTURE_DEVICE);
        }
        else
        {
            pr_message("do nothing\n");
        }
    }

    audproc_alsa_adev_cfg* pb = (audproc_alsa_adev_cfg*)&state->audproc_stream_data->outdev;
    if(pb)
    {
        pr_message("-------------- playback device current state --------------\n");
        pr_message("- audproc_create_on_start       : %d\n",pb->audproc_create_on_start);
        pr_message("- rts_pb_hdl                    : %p\n",state->rts_pb_hdl);
        if(state->rts_pb_desc)
        {
            pr_message("- isActive                  : %d\n",state->rts_pb_desc->isActive);
            pr_message("- rts_pb_desc->rts_handle   : %p\n",state->rts_pb_desc->rts_handle);
            if(state->rts_pb_desc->dev_name)
            {
                pr_message("- rts_pb_desc->dev_name : %s\n",state->rts_pb_desc->dev_name);
            }
        }
        else
        {
            pr_message("device descriptor invalid, state->rts_pb_desc(%p)\n", state->rts_pb_desc);

            rts_inst_desc*      desc =  (rts_inst_desc*)NULL;

            desc = audproc_audio_rts_handler_get_dev_descriptor(state, D_CONV_PLAYBACK_DEVICE);
            if(!desc)
            {
                force_new_create = TRUE;
            }
            else
            {
                state->rts_pb_desc = desc;
                state->rts_pb_hdl  = desc->rts_handle;

                pr_message("- rts_pb_hdl                    : %p\n",state->rts_pb_hdl);
                if(state->rts_pb_desc)
                {
                    pr_message("- isActive                  : %d\n",state->rts_pb_desc->isActive);
                    pr_message("- rts_pb_desc->rts_handle   : %p\n",state->rts_pb_desc->rts_handle);
                    if(state->rts_pb_desc->dev_name)
                    {
                        pr_message("- rts_pb_desc->dev_name : %s\n",state->rts_pb_desc->dev_name);
                    }
                }
            }
        }
        pr_message("-----------------------------------------------------------\n");

        if(  (pb->audproc_create_on_start == AUD_PROC_DEVICE_OPEN_AT_STR_START_CLOSE_AT_STR_END)
           ||(pb->audproc_create_on_start == AUD_PROC_DEVICE_RECREATE_AT_STR_START_ONLY)
           || force_new_create)
        {
            err = audproc_audio_rts_handler_recreate(state, FALSE, D_CONV_PLAYBACK_DEVICE);
        }
        else
        {
            pr_message("do nothing\n");
        }
    }

    audproc_audio_rts_handler_clear_xrun(state);


    return err;
}

/*******************************************************************************
*
* FUNCTION: audproc_audio_rts_handler_voice_reset
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int audproc_audio_rts_handler_voice_reset(audproc_alsa_state* state)
{
    int                         err = AUDPROC_ERR_OK;
    audproc_alsa_stream_cfg*    pd = (audproc_alsa_stream_cfg*)NULL;

    pr_debug("entered");

    if(!state)
    {
        pr_critical("state structure pointer not initialized\n");
        return AUDPROC_ERR_NULL_POINTER;
    }

    g_mutex_lock(&state->lock);

    if(state->rts_pb_hdl || state->rts_cap_hdl)
    {

        /* recording in file recover */
        if(    state->audproc_stream_data->source_id == AUD_PROC_SRC_VOICE1
            || state->audproc_stream_data->source_id == AUD_PROC_SRC_VOICE2)
        {
            if(mic_rec_desc.in_rec_active || mic_rec_desc.out_rec_active)
            {
                pr_message("configure recording of voice source: %d\n",state->audproc_stream_data->source_id );

                pd = (audproc_alsa_stream_cfg*)audproc_configuration_get_route_cfg(state->audproc_stream_data->source_id);
                if(mic_rec_desc.astream)
                    g_free(mic_rec_desc.astream);
                mic_rec_desc.astream = g_malloc0(sizeof(audproc_alsa_stream_cfg));
                memcpy((void*)mic_rec_desc.astream, (void*)pd, sizeof(audproc_alsa_stream_cfg));

                mic_rec_desc.init = 1;
                audproc_audio_recording_next_record();
                (void)audproc_audio_recording_mic_rec_file_reopen(state->audproc_stream_data);
            }
        }
        else
        {
            /* do nothing */
        }

        state->rts_read_cnt = 0;
        state->rts_write_cnt = 0;
        state->rts_read_err_occured = FALSE;
        state->rts_write_err_occured = FALSE;
    }
    else
        pr_warning("rts handle is NULL, rts_destroy is not called\n");

    g_mutex_unlock(&state->lock);

    /* now reset rts handler */

    audproc_alsa_adev_cfg* cap = (audproc_alsa_adev_cfg*)&state->audproc_stream_data->indev;
    if(cap->audproc_create_on_start)
        err = audproc_audio_rts_handler_recreate(state, FALSE, D_CONV_CAPTURE_DEVICE);
    audproc_alsa_adev_cfg* pb = (audproc_alsa_adev_cfg*)&state->audproc_stream_data->outdev;
    if(pb->audproc_create_on_start)
        err = audproc_audio_rts_handler_recreate(state, FALSE, D_CONV_PLAYBACK_DEVICE);

    audproc_audio_rts_handler_clear_xrun(state);
    //err = audproc_audio_rts_handler_recover(state);

    return err;
}

/*******************************************************************************
*
* FUNCTION: audproc_audio_rts_handler_info_reset
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int audproc_audio_rts_handler_info_reset(audproc_alsa_state* state)
{
    int                         err = AUDPROC_ERR_OK;
    audproc_alsa_stream_cfg*    pd = (audproc_alsa_stream_cfg*)NULL;

    pr_debug("entered");

    if(!state)
    {
        pr_critical("state structure pointer not initialized\n");
        return AUDPROC_ERR_NULL_POINTER;
    }

    g_mutex_lock(&state->lock);

    if(state->rts_pb_hdl || state->rts_cap_hdl)
    {

        /* recording in file recover */
        if(    state->audproc_stream_data->source_id == AUD_PROC_SRC_INFO1
            || state->audproc_stream_data->source_id == AUD_PROC_SRC_INFO2
            || state->audproc_stream_data->source_id == AUD_PROC_SRC_INFO3
            || state->audproc_stream_data->source_id == AUD_PROC_SRC_VOICE2
            || state->audproc_stream_data->source_id == AUD_PROC_SRC_ENT16
            || state->audproc_stream_data->source_id == AUD_PROC_SRC_ENT17)
        {
            if(info_rec_desc.in_rec_active || info_rec_desc.out_rec_active)
            {
                pr_message("configure recording of voice source: %d\n",state->audproc_stream_data->source_id );

                pd = (audproc_alsa_stream_cfg*)audproc_configuration_get_route_cfg(state->audproc_stream_data->source_id);
                if(info_rec_desc.astream)
                    g_free(info_rec_desc.astream);
                info_rec_desc.astream = g_malloc0(sizeof(audproc_alsa_stream_cfg));
                memcpy((void*)info_rec_desc.astream, (void*)pd, sizeof(audproc_alsa_stream_cfg));

                info_rec_desc.init = 1;
                audproc_audio_recording_next_record();
                (void)audproc_audio_recording_info_rec_file_reopen(state->audproc_stream_data);
            }
        }
        else
        {
            /* do nothing */
        }
        state->rts_read_cnt = 0;
        state->rts_write_cnt = 0;
        state->rts_read_err_occured = FALSE;
        state->rts_write_err_occured = FALSE;
    }
    else
        pr_warning("rts handle is NULL, rts_destroy is not called\n");

    g_mutex_unlock(&state->lock);

    /* now reset rts handler */

    audproc_alsa_adev_cfg* cap = (audproc_alsa_adev_cfg*)&state->audproc_stream_data->indev;
    if(cap->audproc_create_on_start)
        err = audproc_audio_rts_handler_recreate(state, FALSE, D_CONV_CAPTURE_DEVICE);
    audproc_alsa_adev_cfg* pb = (audproc_alsa_adev_cfg*)&state->audproc_stream_data->outdev;
    if(pb->audproc_create_on_start)
        err = audproc_audio_rts_handler_recreate(state, FALSE, D_CONV_PLAYBACK_DEVICE);

    audproc_audio_rts_handler_clear_xrun(state);

    /* now reset rts handler */
    //err = audproc_audio_rts_handler_recover(state);

    return err;
}



/*******************************************************************************
*
* FUNCTION: audproc_audio_rts_handler_read
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int audproc_audio_rts_handler_read
(
    audproc_alsa_state  *inst,
    void                *buffer[],
    audproc_source_type src_type
)
{
    //int err = AUDPROC_ERR_OK;

    pr_debug("ENTERED\n");


    if(!inst)
    {
        pr_critical("state structure pointer not initialized\n");
        return AUDPROC_ERR_NULL_POINTER;
    }


    inst->rts_err_r_s = AUDPROC_ERR_OK;


    if(inst->rts_cap_hdl)
    {
        clock_gettime(CLOCK_MONOTONIC, &inst->rts_read_enter_time);
        inst->rts_err_r_s = rts_read(inst->rts_cap_hdl, buffer);
        ETG_TRACE_USR4(("[audproc_audio_rts_handler_read]: call rts_read() -> err(%d)", inst->rts_err_r_s));
    }


    inst->rts_read_cnt++;

    /* record read calls for performance test */
    if(isreadperform)
        audproc_audio_rts_handler_performance_read_complet_timestamp();

    /* error and XRUN detection */
    if(audproc_audio_rts_handler_get_xrun(inst, &inst->rts_curr_xrun_num_r_s, D_CONV_CAPTURE_DEVICE))
    {
        pr_warning("%d XRUNS have occurred after %d reads \n", inst->rts_curr_xrun_num_r_s, inst->rts_read_cnt);
        ETG_TRACE_USR3(("[audproc_audio_rts_handler_read]: %d XRUNS have occurred after %d reads ", inst->rts_curr_xrun_num_r_s, inst->rts_read_cnt));
    }

    if(inst->rts_err_r_s)
    {
        if(!inst->rts_read_err_occured)
        {
            clock_gettime(CLOCK_MONOTONIC, &inst->rts_read_fail_time);

            pr_warning("audio capture fails with err = %d after %d reads  \n", inst->rts_err_r_s, inst->rts_read_cnt);
            ETG_TRACE_USR3(("[audproc_audio_rts_handler_read]: audio capture fails with err = %d after %d reads ", inst->rts_err_r_s, inst->rts_read_cnt));
            ETG_TRACE_USR3(("[audproc_audio_rts_handler_read]: audproc_last_ok_read[%05u,%lu]", (unsigned int)inst->rts_read_last_ok_time.tv_sec,
                                                                                          (unsigned long int)inst->rts_read_last_ok_time.tv_nsec));
            ETG_TRACE_USR3(("[audproc_audio_rts_handler_read]: audproc_read_enter[%05u,%lu]", (unsigned int)inst->rts_read_enter_time.tv_sec,
                                                                                        (unsigned long int)inst->rts_read_enter_time.tv_nsec));
            ETG_TRACE_USR3(("[audproc_audio_rts_handler_read]: audproc_read_fails[%05u,%lu]", (unsigned int)inst->rts_read_fail_time.tv_sec,
                                                                                        (unsigned long int)inst->rts_read_fail_time.tv_nsec));
            inst->rts_read_err_occured = TRUE;

            inst->rts_curr_xrun_num_r_s = 0;
            if(audproc_audio_rts_handler_get_xrun(inst, &inst->rts_curr_xrun_num_r_s, D_CONV_CAPTURE_DEVICE))
            {
                pr_warning("%d XRUNS have occurred after %d reads \n", inst->rts_curr_xrun_num_r_s, inst->rts_read_cnt);
                ETG_TRACE_USR3(("[audproc_audio_rts_handler_read]: %d XRUNS have occurred after %d reads ", inst->rts_curr_xrun_num_r_s, inst->rts_read_cnt));
            }
        }
    }
    else
    {
        /* store time last ok read */
        clock_gettime(CLOCK_MONOTONIC, &inst->rts_read_last_ok_time);

        if(inst->rts_read_err_occured) /* reset read error flag */
        {
            inst->rts_read_err_occured = FALSE;
            pr_message("read is now available again after %d_read \n", inst->rts_read_cnt);
            ETG_TRACE_USR3(("[audproc_audio_rts_handler_read]: read is now available again after %d_read ", inst->rts_read_cnt));
        }
    }


    /* recording */
    if(    (src_type == AUD_PROC_SRC_TYPE_ENT)
        && !inst->rts_err_r_s
        && ent_rec_desc.init)
    {
        if(ent_rec_desc.in_rec_active)
        {
            guint byte_nb_2_cpy = 0;
            if(ent_rec_desc.astream->indev.audproc_format == SND_PCM_FORMAT_S16_LE)
                byte_nb_2_cpy = ent_rec_desc.astream->indev.audproc_period_frames * 2;
            else if(ent_rec_desc.astream->indev.audproc_format == SND_PCM_FORMAT_S32_LE || ent_rec_desc.astream->indev.audproc_format == SND_PCM_FORMAT_S24_LE)
                byte_nb_2_cpy = ent_rec_desc.astream->indev.audproc_period_frames * 4;
            else
            {
                /*do nothing */
            }
            pr_debug("stream_format = %d, stream_sample_nb = %d, byte_2_cpy = %d\n", ent_rec_desc.astream->indev.audproc_format,
                                                                                       ent_rec_desc.astream->indev.audproc_period_frames,
                                                                                       byte_nb_2_cpy);
            (void)audproc_audio_recording_ent_cap_write(buffer, byte_nb_2_cpy);
        }
    }

    /* write audio frame recording file  */
    if(    (src_type == AUD_PROC_SRC_TYPE_VOICE)
        && !inst->rts_err_r_s
        && mic_rec_desc.init)
    {
        if(mic_rec_desc.in_rec_active)
        {
            guint byte_nb_2_cpy = 0;
            if(mic_rec_desc.astream->indev.audproc_format == SND_PCM_FORMAT_S16_LE)
                byte_nb_2_cpy = mic_rec_desc.astream->indev.audproc_period_frames * 2;
            else if(ent_rec_desc.astream->indev.audproc_format == SND_PCM_FORMAT_S32_LE || ent_rec_desc.astream->indev.audproc_format == SND_PCM_FORMAT_S24_LE)
                byte_nb_2_cpy = mic_rec_desc.astream->indev.audproc_period_frames * 4;
            else
            {
                /*do nothing */
            }
            pr_debug("stream_format = %d, stream_sample_nb = %d, byte_2_cpy = %d\n", mic_rec_desc.astream->indev.audproc_format,
                                                                                       mic_rec_desc.astream->indev.audproc_period_frames,
                                                                                       byte_nb_2_cpy);
            (void)audproc_audio_recording_mic_cap_write(buffer, byte_nb_2_cpy);
        }
    }

    /* write audio frame recording file  */
    if((src_type == AUD_PROC_SRC_TYPE_INFO)
        && !inst->rts_err_r_s
        && info_rec_desc.init)
    {
        if(info_rec_desc.in_rec_active)
        {
            guint byte_nb_2_cpy = 0;

            ETG_TRACE_USR4(("[audproc_audio_rts_handler_read]: enter INFO source recording "));

            if(info_rec_desc.astream->indev.audproc_format == SND_PCM_FORMAT_S16_LE)
                byte_nb_2_cpy = info_rec_desc.astream->indev.audproc_period_frames * 2;
            else if(info_rec_desc.astream->indev.audproc_format == SND_PCM_FORMAT_S32_LE || info_rec_desc.astream->indev.audproc_format == SND_PCM_FORMAT_S24_LE)
                byte_nb_2_cpy = info_rec_desc.astream->indev.audproc_period_frames * 4;
            else
            {
                /*do nothing */
            }
            pr_debug("stream_format = %d, stream_sample_nb = %d, byte_2_cpy = %d\n", info_rec_desc.astream->indev.audproc_format,
                                                                                       info_rec_desc.astream->indev.audproc_period_frames,
                                                                                       byte_nb_2_cpy);
            (void)audproc_audio_recording_info_cap_write(buffer, byte_nb_2_cpy);
        }
    }

    else
    {
        /*do nothing */
    }

    if(!inst->rts_err_r_s)
        ETG_TRACE_USR4(("[audproc_audio_rts_handler_read]: %d frames readen successfully ", inst->rts_read_cnt));

    //pr_debug("entered");

    return inst->rts_err_r_s;
}

/*******************************************************************************
*
* FUNCTION: audproc_audio_rts_handler_Loop_write
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int audproc_audio_rts_handler_Loop_write(audproc_alsa_state* inst, void * buffer[])
{
    int err = AUDPROC_ERR_OK;

    pr_debug("ENTERED\n");


    if(!inst)
    {
        pr_critical("state structure pointer not initialized\n");
        return AUDPROC_ERR_NULL_POINTER;
    }


    if(inst->rts_lp_hdl)
    {
        err = rts_write(inst->rts_lp_hdl, buffer);
  }

    return err;
}
/*******************************************************************************
*
* FUNCTION: audproc_audio_rts_handler_write
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int audproc_audio_rts_handler_write
(
    audproc_alsa_state*     inst,
    void*                   buffer[],
    audproc_source_type     src_type,
    gboolean                silence
)
{
    //int err = AUDPROC_ERR_OK;

    pr_debug("ENTERED\n");

    /* increment read counter*/
    if(!inst)
    {
        pr_critical("state structure pointer not initialized\n");
        return AUDPROC_ERR_NULL_POINTER;
    }

    inst->rts_err_w_s = AUDPROC_ERR_OK;

#ifdef D_RTS_WRITE_WORK_AROUND
rewrite:
#endif
    if(inst->rts_pb_hdl)
    {
        clock_gettime(CLOCK_MONOTONIC, &inst->rts_write_enter_time);
        inst->rts_err_w_s = rts_write(inst->rts_pb_hdl, buffer);
        pr_debug("rts_write with handel: %p \n", inst->rts_pb_hdl);
    }
    else
    {
        pr_critical("invalide playback device rts instance\n");
        return AUDPROC_ERR_RTS_HANDLE_INVALID;
    }


    inst->rts_write_cnt++;


    if(iswriteperform)
        audproc_audio_rts_handler_performance_write_complet_timestamp();

    /* error and XRUN detection */
    if(audproc_audio_rts_handler_get_xrun(inst, &inst->rts_curr_xrun_num_w_s, D_CONV_PLAYBACK_DEVICE))
    {
        pr_warning("%d XRUNS have occurred after %d writes \n", inst->rts_curr_xrun_num_w_s, inst->rts_write_cnt);
        ETG_TRACE_USR3(("[audproc_audio_rts_handler_write]: %d XRUNS have occurred after %d writes ", inst->rts_curr_xrun_num_w_s, inst->rts_write_cnt));
        /* workaround : a rts_write8) in underrun state lead to ignore the buffer
        which take care to recover from error state */
        #ifdef D_RTS_WRITE_WORK_AROUND
        goto rewrite;
        #endif
    }

    if(inst->rts_err_w_s != AUDPROC_ERR_OK)
    {
        if(!inst->rts_write_err_occured)
        {
            clock_gettime(CLOCK_MONOTONIC, &inst->rts_write_fail_time);

            pr_warning("audio playback fails with err = %d after %d writes  \n", inst->rts_err_w_s, inst->rts_write_cnt);
            ETG_TRACE_USR3(("[audproc_audio_rts_handler_write]: audio playback fails with err = %d after %d writes ", inst->rts_err_w_s, inst->rts_write_cnt));
            ETG_TRACE_USR3(("[audproc_audio_rts_handler_write]: audproc_last_ok_write[%05u,%lu]", (unsigned int)inst->rts_write_last_ok_time.tv_sec,
                                                                                          (unsigned long int)inst->rts_write_last_ok_time.tv_nsec));
            ETG_TRACE_USR3(("[audproc_audio_rts_handler_write]: audproc_write_enter[%05u,%lu]", (unsigned int)inst->rts_write_enter_time.tv_sec,
                                                                                        (unsigned long int)inst->rts_write_enter_time.tv_nsec));
            ETG_TRACE_USR3(("[audproc_audio_rts_handler_write]: audproc_write_fails[%05u,%lu]", (unsigned int)inst->rts_write_fail_time.tv_sec,
                                                                                        (unsigned long int)inst->rts_write_fail_time.tv_nsec));


            inst->rts_write_err_occured = TRUE;

            inst->rts_curr_xrun_num_w_s = 0;
            if(audproc_audio_rts_handler_get_xrun(inst, &inst->rts_curr_xrun_num_w_s, D_CONV_PLAYBACK_DEVICE))
            {
                pr_warning("%d XRUNS have occurred after %d writes \n", inst->rts_curr_xrun_num_w_s, inst->rts_write_cnt);
                ETG_TRACE_USR3(("[audproc_audio_rts_handler_write]: %d XRUNS have occurred after %d writes ", inst->rts_curr_xrun_num_w_s, inst->rts_write_cnt));
            }
        }
    }
    else
    {
        clock_gettime(CLOCK_MONOTONIC, &inst->rts_write_last_ok_time);

        if(inst->rts_write_err_occured) /* reset read error flag */
        {
            inst->rts_write_err_occured = FALSE;
        }
    }


    /* recording */
    if(    (src_type == AUD_PROC_SRC_TYPE_ENT)
        && !inst->rts_err_w_s
        && ent_rec_desc.init)
    {
        if(ent_rec_desc.out_rec_active)
        {
            guint byte_nb_2_cpy = 0;
            if(ent_rec_desc.astream->outdev.audproc_format == SND_PCM_FORMAT_S16_LE)
                byte_nb_2_cpy = ent_rec_desc.astream->outdev.audproc_period_frames * 2;
            else if(ent_rec_desc.astream->indev.audproc_format == SND_PCM_FORMAT_S32_LE || ent_rec_desc.astream->indev.audproc_format == SND_PCM_FORMAT_S24_LE)
                byte_nb_2_cpy = ent_rec_desc.astream->outdev.audproc_period_frames * 4;
            else
            {
                /*do nothing */
            }
            (void)audproc_audio_recording_ent_pb_write(buffer, byte_nb_2_cpy);
        }
    }

    /* write audio frame recording file  */
    if(    (src_type == AUD_PROC_SRC_TYPE_VOICE)
        && !inst->rts_err_w_s
        && mic_rec_desc.init)
    {
        if(mic_rec_desc.out_rec_active)
        {
            guint byte_nb_2_cpy = 0;
            if(mic_rec_desc.astream->outdev.audproc_format == SND_PCM_FORMAT_S16_LE)
                byte_nb_2_cpy = mic_rec_desc.astream->outdev.audproc_period_frames * 2;
            else if(mic_rec_desc.astream->outdev.audproc_format == SND_PCM_FORMAT_S32_LE)
                byte_nb_2_cpy = mic_rec_desc.astream->outdev.audproc_period_frames * 4;
            else
            {
                /*do nothing */
            }
            (void)audproc_audio_recording_mic_pb_write(buffer, byte_nb_2_cpy);
        }
    }

    /* write audio frame recording file  */
    if(    (src_type == AUD_PROC_SRC_TYPE_INFO)
        && !inst->rts_err_w_s
        && info_rec_desc.init)
    {
        if(info_rec_desc.out_rec_active)
        {
            guint byte_nb_2_cpy = 0;
            ETG_TRACE_USR4(("[audproc_audio_rts_handler_write]: enter INFO source recording "));

            if(info_rec_desc.astream->outdev.audproc_format == SND_PCM_FORMAT_S16_LE)
                byte_nb_2_cpy = info_rec_desc.astream->outdev.audproc_period_frames * 2;
            else if(info_rec_desc.astream->indev.audproc_format == SND_PCM_FORMAT_S32_LE || info_rec_desc.astream->indev.audproc_format == SND_PCM_FORMAT_S24_LE)
                byte_nb_2_cpy = info_rec_desc.astream->outdev.audproc_period_frames * 4;
            else
            {
                /*do nothing */
            }
            (void)audproc_audio_recording_info_pb_write(buffer, byte_nb_2_cpy);
        }
    }
    else
    {
        /*do nothing */
    }

    if(!inst->rts_err_w_s)
    {
        if(!silence)
        {
            ETG_TRACE_USR4(("[audproc_audio_rts_handler_write]: %d frames written successfully ", inst->rts_write_cnt));
        }
        else
        {
            ETG_TRACE_USR4(("[audproc_audio_rts_handler_write]: %d silence frames written successfully ", inst->rts_write_cnt));
        }
    }

    return inst->rts_err_w_s;
}


/*******************************************************************************
*
* FUNCTION: ecnr_audio_rts_handler_recover
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int audproc_audio_rts_handler_recover(audproc_alsa_state* inst, gint16 dev_dir)
{
    //int err = AUDPROC_ERR_OK;

    pr_debug("entered");
    //ETG_TRACE_USR3(("[audproc_audio_rts_handler_recover]: try to recover %s device", (dev_dir == D_CONV_PLAYBACK_DEVICE) ? "PLAYBACK_DEVICE" : "CAPTURE_DEVICE"));

    if(!inst)
    {
        pr_critical("state structure pointer not initialized\n");
        return AUDPROC_ERR_NULL_POINTER;
    }

    inst->rts_err_rv_s = AUDPROC_ERR_OK;

    if(dev_dir == D_CONV_PLAYBACK_DEVICE)
    {
        if(inst->rts_pb_hdl != NULL)
        {
            pr_debug("rts_recover playback device with handle(%p)\n", inst->rts_pb_hdl);

            g_mutex_lock(&inst->lock);

            inst->rts_err_rv_s = rts_recover(inst->rts_pb_hdl);
            if(inst->rts_err_rv_s)
            {
                pr_warning("rts_recover playback device failed with error(%d)\n", inst->rts_err_rv_s);
                ETG_TRACE_USR3(("[audproc_audio_rts_handler_recover]: rts_recover playback device failed with error(%d)",  inst->rts_err_rv_s));
            }
            #ifdef D_ONLY_FOR_DEBUG
            else
            {
                pr_debug("pb dev instance was recovered\n");
                ETG_TRACE_USR3(("[audproc_audio_rts_handler_recover]: pb dev instance was recovered"));
            }
            #endif
            g_mutex_unlock(&inst->lock);

        }
    }
    else if(dev_dir == D_CONV_CAPTURE_DEVICE)
    {
        if(inst->rts_cap_hdl != NULL)
        {
            pr_debug("rts_recover capture device with handle(%p)\n", inst->rts_cap_hdl);

            g_mutex_lock(&inst->lock);

            inst->rts_err_rv_s = rts_recover(inst->rts_cap_hdl);
            if(inst->rts_err_rv_s)
            {
                pr_warning("rts_recover capture device failed with error(%d)\n", inst->rts_err_rv_s);
                ETG_TRACE_USR3(("[audproc_audio_rts_handler_recover]: rts_recover capture device failed with error(%d)",  inst->rts_err_rv_s));
            }
            #ifdef D_ONLY_FOR_DEBUG
            else
            {
                pr_debug("cap dev instance was recovered\n");
                ETG_TRACE_USR3(("[audproc_audio_rts_handler_recover]: cap dev instance was recovered"));
            }
            #endif
            g_mutex_unlock(&inst->lock);

        }
    }
    else
    {
        pr_warning("rts handle is NULL, rts_destroy is not called\n");
    }

    return inst->rts_err_rv_s;
}


/*******************************************************************************
*
* FUNCTION: audproc_audio_rts_handler_statistic_get
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int audproc_audio_rts_handler_statistic_get(trts_stat *stat)
{

    pr_debug("entered");

    trts_stat state = *stat;

    state.num_xruns = 0;

    /* implement to do */

    (void)stat;
    (void)state;
    return AUDPROC_ERR_OK;
}

/*******************************************************************************
*
* FUNCTION: audproc_audio_rts_handler_get_xrun
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
gboolean  audproc_audio_rts_handler_get_xrun(audproc_alsa_state* inst, unsigned int *xrun, gint16 dev_dir)
{
    int err = AUDPROC_ERR_OK;
    trts_stat stat= {0};

    if(!xrun)
    {
        pr_warning("NULL parameter pointer\n");
        return FALSE;
    }

    if(!inst)
    {
        pr_critical("state structure pointer not initialized\n");
        return FALSE;
    }

    if(dev_dir == D_CONV_PLAYBACK_DEVICE)
    {
        if(inst->rts_pb_hdl)
        {
            err = rts_statistic(inst->rts_pb_hdl, &stat);
        }

        if(!err)
        {
            if(stat.num_xruns != (guint)inst->rts_xrun_pb_count )
            {

                /* xrun count has changed */
                *xrun = stat.num_xruns;
                inst->rts_xrun_pb_count = (int)stat.num_xruns;
                pr_message("new XRUN count -> %d \n", stat.num_xruns);
                ETG_TRACE_USR3(("[audproc_audio_rts_handler_get_xrun]: new XRUN count -> %d", stat.num_xruns));
                return TRUE;
            }
        }

        /* wenn FALSE, always return the last xrun count */
        *xrun = (guint)inst->rts_xrun_pb_count ;
    }
    else if(dev_dir == D_CONV_CAPTURE_DEVICE)
    {
        if(inst->rts_cap_hdl)
        {
            err = rts_statistic(inst->rts_cap_hdl, &stat);
        }

        if(!err)
        {
            if(stat.num_xruns != (guint)inst->rts_xrun_cap_count )
            {

                /* xrun count has changed */
            	*xrun = stat.num_xruns;
            	inst->rts_xrun_cap_count = (int)stat.num_xruns;
                return TRUE;
            }
        }

        /* wenn FALSE, always return the last xrun count */
        *xrun = (guint)inst->rts_xrun_cap_count ;
    }

    return FALSE;
}

/*******************************************************************************
*
* FUNCTION: audproc_audio_rts_handler_clear_xrun
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: sse error
*
*******************************************************************************/
int audproc_audio_rts_handler_clear_xrun(audproc_alsa_state* inst)
{
    int err = AUDPROC_ERR_OK;
    trts_stat stat= {0};


    if(!inst)
    {
        pr_critical("state structure pointer not initialized\n");
        return AUDPROC_ERR_NULL_POINTER;
    }

    if(inst->rts_pb_hdl)
    {

        inst->rts_xrun_pb_count = 0;
        stat.clear = 1;
        err = rts_statistic(inst->rts_pb_hdl, &stat);
        if(err)
        {
            pr_warning("fails to clear rts statistic for playback device\n");
        }
    }

    if(inst->rts_cap_hdl)
    {

        inst->rts_xrun_cap_count = 0;
        stat.clear = 1;
        err = rts_statistic(inst->rts_cap_hdl, &stat);
        if(err)
        {
            pr_warning("fails to clear rts statistic for capture device\n");
        }
    }

    return err;
}

