 /*
 * audproc-alsa.h
 *
 * Author     : Patrick Rey
 * Date       : 07.08.2015
 * description: porting from qwa-alsa.h to G3g
 *
 *
 */

#ifndef __AUDPROC_STREAM_BUFFER_H__
#define __AUDPROC_STREAM_BUFFER_H__


/***************************************
 * section include engines definitions
 */

#include "apl.h"

/*******************************************
 * section include ADIT RTS API definition
 */

extern int       audproc_stream_buffer_init(void);
extern int       audproc_stream_buffer_finalize(void);
extern int       audproc_stream_buffer_desc_init(aplAudioSamples_desc* this_buf, const aplAudioSamples_desc* init_buf);
extern int       audproc_stream_buffer_desc_reinit(aplAudioSamples_desc* this_buf);
extern int       audproc_stream_buffer_add_new_frame(aplAudioSamples_desc* this_buf, aplAudioSamples_desc* in_buf );
extern int       audproc_stream_buffer_frame_is_consumed(aplAudioSamples_desc* this_buf);
extern int       audproc_stream_buffer_lock(aplAudioSamples_desc* this_buf);
extern int       audproc_stream_buffer_unlock(aplAudioSamples_desc* this_buf);
extern gboolean  audproc_stream_buffer_is_frame_pending_avail(aplAudioSamples_desc* this_buf);


#endif //__AUDPROC_STREAM_BUFFER_H__
