/************************************************************
 * audproc-state-machine.h
 *
 * Author   : Patrick Rey
 * Date     : 03.10.2016
 * Version  : init
 *
 */


#ifndef __AUDPROC_STATE_MACHINE_H__
#define __AUDPROC_STATE_MACHINE_H__



/*******************************************************
 *                  Define definitons                  *
 ******************************************************/

#define AUD_PROC_MAX_STATE_ELEMENT 20
#define AUD_PROC_MAX_STATE_MACHINE 20 //10




/*******************************************************
 *                  Data type definitons                  *
 ******************************************************/

typedef struct _audproc_as_desc
{
    audproc_audio_state     code; // tQwaInt code;
    const  char*            str;
}audproc_as_desc;



#define AUDPROC_AUDIO_STATE(name) { name, #name }


typedef enum _audproc_state_type
{
    AUDPROC_STATE_TYPE_UNDEFINED_STATE,
    AUDPROC_STATE_TYPE_MAIN_STATE,
    AUDPROC_STATE_TYPE_SUB_STATE
}audproc_state_type;

typedef struct _audproc_state_element
{
    audproc_state_type                  this_state_elem_type;
    guint8                              this_main_state;
    guint8                              this_sub_state;
    struct _audproc_state_element**     associated_state_elem_list;

    gint (*audproc_service_this_state_change_cond)       (guint8 /* state */, gint* /*pargptr*/, gint /*nargs*/);
    gint (*audproc_service_this_state_transition_action) (guint8 /* state */, gint* /*pargptr*/, gint /*nargs*/);
    gint (*audproc_service_this_state_action)            (guint8 /* state */, gint* /*pargptr*/, gint /*nargs*/);

}audproc_state_element;


typedef struct _audproc_state_machine
{
    audproc_state_element**     state_liste;
    gboolean                    config_lock;
    audproc_audio_state         current_state;
    guint8                      this_inst;
    char*                       this_inst_name;
    int                         err;

    /* request control members*/
    gboolean                    is_state_change_request_pending;
    audproc_state_type          requested_new_state;
    audproc_state_element*      current_state_elem;
    audproc_state_element*      new_state_elem;
    gint*                       args;
    gint                        nargs;
}audproc_state_machine;


/*******************************************************
 *                  Module Methods                     *
 ******************************************************/
extern void                     audproc_state_machine_init(void);
extern void                     audproc_state_machine_finalize(void);


/*******************************************************
 *                  state machine setup                *
 ******************************************************/

extern guint8                   audproc_state_machine_create_new(const char* instance_name);
extern gint                     audproc_state_machine_config_begin(guint8 sm_inst);
extern gint                     audproc_state_machine_config_end(guint8 sm_inst);
extern gint                     audproc_state_machine_add_main_state(guint8 sm_inst, gint8 this_main_s, void* fct_state_action);
extern gint                     audproc_state_machine_add_main_state_connections(guint8 sm_inst, gint8 this_main_s, gint8 next_main_s, void* fct_chg_cond, void* fct_tr_act);
extern gint                     audproc_state_machine_add_sub_state(guint8 sm_inst, gint8 this_main_s, gint8 this_sub_s, void* fct_state_action);
extern gint                     audproc_state_machine_add_sub_state_connections(guint8 sm_inst, gint8 this_sub_s, gint8 next_state, void* fct_chg_cond, void* fct_tr_act);

/*******************************************************
 *                  run time methods                   *
 ******************************************************/
extern gint                     audproc_state_machine_trigger_new_state(guint8 sm_inst, audproc_audio_state state, gint** args, gint nargs); //va_list *pargptr, gint nargs);

/*******************************************************
 *                  Properties                         *
 ******************************************************/
extern audproc_audio_state      audproc_state_machine_get_audio_state(guint8 sm_inst);
extern guint8                   audproc_state_machine_get_instance_per_name(char* instance_name);
extern audproc_state_machine*   audproc_state_machine_get_instance(guint8 sm_inst);

/*******************************************************
 *                  Methods Help functions             *
 ******************************************************/
extern const char*              audproc_audio_state_str(audproc_audio_state code);

#endif  // __AUDPROC_STATE_MACHINE_H__
