/************************************************************
 * audproc-service.h
 *
 * Author   : Patrick Rey
 * Date     : 07.08.2015
 * Version  : init
 *
 */


#ifndef __AUDPROC_SERVICE_H__
#define __AUDPROC_SERVICE_H__


#include "apl.h"

#define AUDPROC_SERVICE_MAX_READ_BUFFER_SIZE 16000

struct AudprocError
{
    int     code;
    const   gchar *str;
};

struct AudprocSource
{
    guint8          src;
    const   gchar *str;
};

struct AudprocActivity
{
    audproc_source_activity     activity;
    const   gchar               *str;
};

struct audproc_instance_object
{
    /* service properties */
    audproc_source_type         audproc_this_src_type;
    guint8                      audproc_this_src;
    audproc_alsa_state*         audproc_audio_instance;

    /* service states*/
    gboolean                    audproc_is_this_src_active;
    gboolean                    audproc_is_initialized;
    gboolean                    audproc_is_apl_instance_created;
    gboolean                    audproc_is_streaming_started;
    gboolean                    audproc_is_streaming_running_state;  /* used instead of audproc_is_streaming_started to monitor audio process activity*/
    audproc_audio_state         audproc_astate;
    guint8                      audproc_sm_inst;
};


/*******************************************************
 *                  Module functions                   *
 ******************************************************/
extern void                 audproc_service_init(gboolean isReconfig, guint8 audioMode);
extern gboolean             audproc_service_finalize(void);
extern  GQuark              audproc_service_object_error_quark(void);
extern  const gchar*        audproc_service_error_str(int code);
extern  gboolean            audproc_service_report_error(int status, const gchar * dbus_msg, GError ** error);
extern  audproc_type        audproc_service_get_array_type(audproc_type in_type);
extern gboolean             audproc_service_handle_quit_loop (gpointer user_data);
extern gboolean             audproc_service_add_new_instance (struct audproc_instance_object* new_inst);
extern struct audproc_instance_object* audproc_service_create_new_instance (guchar source);

/*******************************************************
 *                  Service Methods                    *
 ******************************************************/
extern int                  audproc_service_do_initialize(guchar AudprocSourceId, gchar* cfgfilesrc);
extern int                  audproc_service_do_start_streaming(guchar AudprocSourceId);
extern int                  audproc_service_do_stop_streaming(guchar AudprocSourceId);
extern int                  audproc_service_do_select_active_source(audproc_source_select_Mode  AudprocSourceSelectMode, guchar   AudprocSourceId, gchar* AudprocAlsaDev);
extern int                  audproc_service_do_source_activity(guchar AudprocSource, guchar AudprocSourceActivity);
extern int                  audproc_service_do_destroy(guchar AudprocSourceId);
extern int                  audproc_service_do_create(void);
extern int                  audproc_service_do_mute(void);
extern int                  audproc_service_do_set_param(guchar AudprocSourceId, guint32 param_id, audproc_type data_type, const GValue* param);
extern int                  audproc_service_do_get_param(guchar AudprocSourceId, guint32 param_id, audproc_type data_type, GValue* param);
extern int                  audproc_service_do_set_debug_mode(enum eAudprocDebugMode mode);
extern int                  audproc_service_do_read_data(guchar AudprocSourceId, guint32 param_id, GArray *ReadInfos, GArray **data);
extern int                  audproc_service_do_write_data(guchar AudprocSourceId, guint32 param_id, GArray *data, GArray **result);
extern int                  audproc_service_send_notification(tAplDataID param_Id, tAplAction param_action);
extern void                 audproc_service_loopback_activate(gboolean LoopbackAct);
extern int                  audproc_service_change_audio_state(audproc_source_type src_type, audproc_audio_state  astate, gint  nargs, ... );
extern guint8               audproc_service_create_new_state_machine(audproc_source_type src_type, const char* sm_name);
extern int                  audproc_service_set_up_state_machine(audproc_source_type src_type);
extern audproc_audio_state  audproc_service_get_audio_state(audproc_source_type src_type);
extern void          audproc_service_delete_all_apl_request(void);


/*******************************************************
 *                  Service Properties                 *
 ******************************************************/
extern const struct aplParameter*       audproc_service_get_param_infos(guint16 param_id);
extern struct audproc_instance_object*  audproc_service_get_active_type_src (audproc_source_type src_type);
extern struct audproc_instance_object*  audproc_service_get_first_type_src_occurence (audproc_source_type src_type);

/*******************************************************
 *                  service Help functions             *
 ******************************************************/
extern const gchar*                     audproc_service_src_str(guint8 src);
extern     guint8           audproc_service_str_src(const gchar* src_str);


#endif  // __AUDPROC_SERVICE_H__
