 /*
 * audproc-recording.h
 *
 * Author : Patrick Rey
 * Date: 02.11.2017
 *
 *
 */

#ifndef __AUDPROC_RECORDING_H__
#define __AUDPROC_RECORDING_H__



/*******************************************************************************
              STRUCTURE DEFINITION
*******************************************************************************/
typedef struct _record_desc
{
    FILE*                       file_in_pcm;
    FILE*                       file_out_pcm;
    gchar*                      rec_in_dev;
    gchar*                      rec_out_dev;
    gchar                       rec_file_name[300];
    struct timespec             rec_in_time_start_record;
    struct timespec             rec_in_time_stop_record;
    struct timespec             rec_out_time_start_record;
    struct timespec             rec_out_time_stop_record;
    size_t                      rdata;
    size_t                      wdata;
    long int                    rpos;
    audproc_alsa_stream_cfg*    astream;
    guint8                      in_rec_active;
    guint8                      out_rec_active;
    guint8                      init;

    /*audio buffer */
    guint8**                    AudRamBufChannels_out;
    guint8**                    AudRamBufChannels_in;
    guint                       wr_data_out_ptr;
    gboolean                    start_stop_rec_out;
    guint                       wr_data_in_ptr;
    gboolean                    start_stop_rec_in;
}record_desc;


extern record_desc      mic_rec_desc;
extern record_desc      ent_rec_desc;
extern record_desc      info_rec_desc;


extern void audproc_audio_recording_init(void);
extern void audproc_audio_recording_export(audproc_source_type src_type, snd_pcm_stream_t stream_type);
extern void audproc_audio_recording_restart(void);
extern void audproc_audio_recording_stop(void);
extern void audproc_audio_recording_next_record(void);
extern int  audproc_audio_recording_ent_cap_write(void * buffer[], guint nb_byte_2_cpy);
extern int  audproc_audio_recording_mic_cap_write(void * buffer[], guint nb_byte_2_cpy);
extern int  audproc_audio_recording_info_cap_write(void * buffer[], guint nb_byte_2_cpy);
extern int  audproc_audio_recording_ent_pb_write(void * buffer[], guint nb_byte_2_cpy);
extern int  audproc_audio_recording_mic_pb_write(void * buffer[], guint nb_byte_2_cpy);
extern int  audproc_audio_recording_info_pb_write(void * buffer[], guint nb_byte_2_cpy);
extern int  audproc_audio_recording_ent_rec_file_reopen(audproc_alsa_stream_cfg* data);
extern int  audproc_audio_recording_mic_rec_file_reopen(audproc_alsa_stream_cfg* data);
extern int  audproc_audio_recording_info_rec_file_reopen(audproc_alsa_stream_cfg* data);








#endif //__AUDPROC_RECORDING_H__

