/*
 * audproc-configuration.h
 *
 * Patrick Rey   06.08.2015
 */

#ifndef __AUDPROC_CONFIGURATION_H__
#define __AUDPROC_CONFIGURATION_H__


/*******************************************************************************
              DEFINES
*******************************************************************************/


/*******************************************************************************
              type definition
*******************************************************************************/

typedef struct _system_cfg
{
    guint8                      audioMode;
    audproc_alsa_stream_cfg*    audcfg;
    guint                       cfglength;
    audproc_audsrc_lookup*      audsrcmap;
    guint                       audsrclength;
}system_cfg;

typedef struct _AudioMode
{
    guint8     audiomode;
    const   gchar *str;
}AudioMode;

#define AUDPROC_AUDIO_MODE(name) { name, #name }


/****************************************
 *  Module functions                    *
 ****************************************/


/* return size of configuration buffer, return 0 if there is no available configuration to the passed ConfigId  */
extern int                          audproc_configuration_set_configuration(guint8 src);
extern int                          audproc_configuration_set_configuration_by_cfg_id(audproc_cfg_id cfgid);
extern int                          audproc_configuration_init(gboolean isReconfig, guint8 audioMode);
extern int                          audproc_configuration_finalize(void);
extern audproc_alsa_stream_cfg*     audproc_configuration_get_route_cfg(guint8 src);
extern gint                         audproc_configuration_get_route_cfg_nb_max(void);
extern const gchar*                 audproc_configuration_get_inst_name(guint8 src);
extern audproc_alsa_stream_cfg*     audproc_configuration_get_route_cfg_list_idx(guint idx);
extern const struct aplParameter*   audproc_configuration_get_param_infos(guint32 param_id);
extern const struct aplParameter*   audproc_configuration_get_param_table(void);
extern guint                        audproc_configuration_get_param_table_size(void);
extern int                          audproc_configuration_look_up_src_table(guint8 in_src, guint8* search_src_def, gboolean search_src_conf_versus_int);
extern int                          audproc_configuration_look_up_flat_req(guint8 in_src, gboolean* is_set_flat);
extern int                          audproc_configuration_get_src_id_from_capture_dev(gchar*  audproc_alsa_capture_dev /*in*/, guint8* audproc_src_id/*out*/);
extern int                          audproc_configuration_set_audio_mode_classic(void);
extern int                          audproc_configuration_set_audio_mode_auditorium(void);
extern int                          audproc_configuration_set_audio_mode_premium(void);
extern int                          audproc_configuration_set_audio_mode_eol_reload(void);
extern int                          audproc_configuration_get_audio_mode(void);
extern void                         audproc_configuration_print_configuration(void);




/* test functions*/

extern void                         audproc_configuration_test_miclvl_300ms(void);


#endif // __AUDPROC_CONFIGURATION_H__
