/*
 * main.cpp
 *
 *  Created on: Sep 13, 2012
 *      Author: rjk2hi
 */

#include "g3g_dbus.h"
#include "audmgr_main.h"
#include "audmgr_clienthandler.h"
#include <vector>
#include <iostream>
#include <limits>
#include <unistd.h>

using namespace std;

#define MAX_TEST_OPTIONS (18)

void vPrintTestOptions(void);
void testhandler(int choice);

/* test handlers */
bool bHandleConnect(void);
bool bHandleDisConnect(void);
bool bHandleSetVolume(void);
bool bHandleSetSinkMuteState(void);
bool bHandleSetMainSinkSoundProperty(void);
bool bHandleSetMainSourceSoundProperty(void);
bool bHandleSetSystemProperty(void);
bool bHandleGetListMainConnections(void);
bool bHandleGetListMainSinks(void);
bool bHandleGetListMainSources(void);
bool bHandleGetListMainSinkSoundProperties(void);
bool bHandleGetListMainSourceSoundProperties(void);
bool bHandleGetListSourceClasses(void);
bool bHandleGetListSinkClasses(void);
bool bHandleGetListSystemProperties(void);
bool bHandleGetTimingInformation(void);
bool bHandleVolumeStep(void);
bool bHandleDoubleConnect(void);

audmgr_main objMain;

int main()
{
  //Invoke Start App
  objMain.bStartApp();

  //Applications main loop here
  while(!objMain.bAppClosed())
  {
    int choice = 0;
    vPrintTestOptions();//Print test options
    cin >> choice;

    if (cin.fail())
    {
      cout << "ERROR -- You did not enter an integer";

      // get rid of failure state
      cin.clear();

      // discard 'bad' character(s)
      cin.ignore(std::numeric_limits<std::streamsize>::max(), '\n');
      continue;
    }
    if(choice > MAX_TEST_OPTIONS)
    {
      cout<<"Invalid Option"<<endl;
      continue;
    }
    else
    {
      if(objMain.m_ptrProxy != NULL)
      {
        testhandler(choice);
        sleep(1);
      }
    }
  }
  return 0;
}

void testhandler(int choice)
{
  int counter = 0;
  bool bSuccess = false;

  for(counter =0; counter < 3 ; counter++)
  {
    switch(choice)
    {
    case 1: bSuccess = bHandleConnect(); break;
    case 2: bSuccess = bHandleDisConnect(); break;
    case 3: bSuccess = bHandleSetVolume(); break;
  case 4: bSuccess = bHandleVolumeStep(); break;
    case 5: bSuccess = bHandleSetSinkMuteState(); break;
    case 6: bSuccess = bHandleSetMainSinkSoundProperty(); break;
    case 7: bSuccess = bHandleSetMainSourceSoundProperty(); break;
    case 8: bSuccess = bHandleSetSystemProperty(); break;
    case 9: bSuccess = bHandleGetListMainConnections(); break;
    case 10: bSuccess = bHandleGetListMainSinks(); break;
    case 11: bSuccess = bHandleGetListMainSources(); break;
    case 12: bSuccess = bHandleGetListMainSinkSoundProperties(); break;
    case 13: bSuccess = bHandleGetListMainSourceSoundProperties(); break;
    case 14: bSuccess = bHandleGetListSourceClasses(); break;
    case 15: bSuccess = bHandleGetListSinkClasses(); break;
    case 16: bSuccess = bHandleGetListSystemProperties(); break;
    case 17: bSuccess = bHandleGetTimingInformation(); break;
    case 18: bSuccess = bHandleDoubleConnect(); break;
    case 0 : bSuccess = true; raise(SIGTERM);break;
    default: bSuccess = true; break;
    }
    if(bSuccess)
      break;
  }
}

void vPrintTestOptions()
{
  cout<<endl<<"List of Options "<<endl;
  cout<<"1. Connect"<<endl;
  cout<<"2. Disconnect"<<endl;
  cout<<"3. SetVolume"<<endl;
  cout<<"4. VolumeStep"<<endl;
  cout<<"5. SetSinkMuteState"<<endl;
  cout<<"6. SetMainSinkSoundProperty"<<endl;
  cout<<"7. SetMainSourceSoundProperty"<<endl;
  cout<<"8. SetSystemProperty"<<endl;
  cout<<"9. GetListMainConnections"<<endl;
  cout<<"10. GetListMainSinks"<<endl;
  cout<<"11. GetListMainSources"<<endl;
  cout<<"12. GetListMainSinkSoundProperties"<<endl;
  cout<<"13. GetListMainSourceSoundProperties"<<endl;
  cout<<"14. GetListSourceClasses"<<endl;
  cout<<"15. GetListSinkClasses"<<endl;
  cout<<"16. GetListSystemProperties"<<endl;
  cout<<"17. GetTimingInformation"<<endl;

  cout<<"18. DoubleConnect"<<endl;
  cout<<"Choice (0 - Exit) : ";
}

uint16_t LastConnectionId = 0;
bool bHandleConnect()
{
  uint16_t srcId, sinkId;
  cout << "Enter Source ID : ";
  cin >> srcId;

  cout << "Enter Sink ID : ";
  cin >> sinkId;

  int16_t result = 0;

  objMain.m_ptrProxy->Connect(srcId,sinkId,result,LastConnectionId);
  cout << endl<< "Result "<<result<<", Connection ID : "<< LastConnectionId<<endl;

  return true;
}
bool bHandleDoubleConnect()
{
  uint16_t srcId_1, srcId_2, sinkId;
  cout << "Enter Source ID_1 : ";
  cin >> srcId_1;

  cout << "Enter Source ID_2 : ";
  cin >> srcId_2;

  cout << "Enter Sink ID : ";
  cin >> sinkId;

  int16_t result = 0;

  objMain.m_ptrProxy->Connect(srcId_1,sinkId,result,LastConnectionId);
  cout << endl<< "Result "<<result<<", Connection ID : "<< LastConnectionId<<endl;

  objMain.m_ptrProxy->Connect(srcId_2,sinkId,result,LastConnectionId);
  cout << endl<< "Result "<<result<<", Connection ID : "<< LastConnectionId<<endl;

  return true;
}
bool bHandleDisConnect()
{
  uint16_t ConnectionId;
  int16_t result;


  if(LastConnectionId)
  {
  cout << "Last Connection Id : "<< LastConnectionId<<endl;
  }
  cout << "Enter Connection ID to be disconnected : "<<endl;
  cin >> ConnectionId;

  objMain.m_ptrProxy->Disconnect(ConnectionId, result);

  cout << endl<< "Result "<< result<<endl;
  return true;
}
bool bHandleSetVolume()
{
  uint16_t sinkid,mode;

  int16_t  volume, result;

  cout << "Enter Sink ID : ";
  cin>> sinkid;

  cout << "Enter Mode (1-Increment in steps,2-Decrement in steps, 3-Set absolute value): ";
  cin>> mode;

  cout << "Enter Value  : ";
  cin>> volume;

  objMain.m_ptrProxy->SetVolume(sinkid,mode,volume,result);

  cout <<endl<<"Result "<<result <<endl;

  return true;
}
bool bHandleSetSinkMuteState()
{
  uint16_t sinkid;
  int16_t mutestate, result;
  cout <<"Enter Sink Id :";
  cin >> sinkid;
  cout <<"MS_MUTE - 1, MS_UNMUTE - 2"<<endl;
  cout <<"Enter Desired Mute State : "<<endl;
  cin >> mutestate;

  objMain.m_ptrProxy->SetSinkMuteState(sinkid,mutestate,result);

  cout <<endl<<"Result "<<result <<endl;

  return true;
}
bool bHandleSetMainSinkSoundProperty()
{
  uint16_t sinkid;
  generic_container<int16_t,int16_t> soundProperty;
  int16_t result;

  cout <<"Enter Sink ID :";
  cin >> sinkid;
  cout<<"Enter Sink Sound Property Type:";
  cin >> soundProperty.first;
  cout<<"Enter Sink Sound Property Value:";
  cin >> soundProperty.second;

  objMain.m_ptrProxy->SetMainSinkSoundProperty(sinkid,soundProperty,result);

  cout <<endl<<"Result "<<result <<endl;

  return true;
}
bool bHandleSetMainSourceSoundProperty()
{
  uint16_t sourceid;
  generic_container<int16_t,int16_t> soundProperty;
  int16_t result;

  cout <<"Enter Source ID :";
  cin >> sourceid;
  cout<<"Enter Source Sound Property Type:";
  cin >> soundProperty.first;
  cout<<"Enter Source Sound Property Value:";
  cin >> soundProperty.second;

  objMain.m_ptrProxy->SetMainSourceSoundProperty(sourceid,soundProperty,result);

  cout <<endl<<"Result "<<result <<endl;

  return true;
}
bool bHandleSetSystemProperty()
{
  generic_container< dbus_int16_t ,dbus_int16_t  > Property;
  dbus_int16_t result;

  cout<<"Enter System Property Type:";
  cin >> Property.first;
  cout<<"Enter System Property Value:";
  cin >> Property.second;

  objMain.m_ptrProxy->SetSystemProperty(Property,result);
  cout <<endl<<"Result "<<result <<endl;

  return true;
}
bool bHandleGetListMainConnections()
{
  dbus_int16_t result;
  std::vector< generic_container< dbus_uint16_t ,dbus_uint16_t ,dbus_uint16_t ,dbus_int16_t ,dbus_int16_t  >  > listConnections;
  objMain.m_ptrProxy->GetListMainConnections(result,listConnections);
  cout <<endl<<"Result "<<result <<endl;

  for(vector<generic_container< dbus_uint16_t ,dbus_uint16_t ,dbus_uint16_t ,dbus_int16_t ,dbus_int16_t  > >::iterator it = listConnections.begin(); it != listConnections.end(); it++)
  {
    cout<< "Connection ID  : "<<it->first<<endl;
    cout<< "sourceID    : "<<it->second<<endl;
    cout<< "sinkID      : "<<it->third<<endl;
    cout<< "delay      : "<<it->fourth<<endl;
    cout<< "connectionState : "<<it->fifth<<endl<<endl;
  }

  return true;
}
bool bHandleGetListMainSinks()
{
  dbus_int16_t result = 0;
  std::vector< generic_container<uint16_t, std::string, generic_container<int16_t,int16_t>, int16_t,int16_t,uint16_t > > listsinks;
  objMain.m_ptrProxy->GetListMainSinks(result,listsinks);
  cout <<endl<<"Result "<<result <<endl;

  for(vector< generic_container<uint16_t, std::string, generic_container<int16_t,int16_t>, int16_t,int16_t,uint16_t > >::iterator it = listsinks.begin(); it!= listsinks.end(); it++)
  {
    cout<< "Sink ID          : "<<it->first<<endl;
    cout<< "Sink Name        : "<<it->second<<endl;
    cout<< "Sink Availaility State  : "<<it->third.first<<endl;
    cout<< "Sink Availaility Reason  : "<<it->third.second<<endl;
    cout<< "volume          : "<<it->fourth<<endl;
    cout<< "muteState        : "<<it->fifth<<endl;
    cout<< "sinkClassID        : "<<it->sixth<<endl<<endl;
  }
  return true;
}
bool bHandleGetListMainSources()
{
  dbus_int16_t result;
  std::vector< generic_container< dbus_uint16_t ,std::string ,generic_container< dbus_int16_t ,dbus_int16_t  > ,dbus_uint16_t  >  >  listMainSources;
  objMain.m_ptrProxy->GetListMainSources(result,listMainSources);
  cout <<endl<<"Result "<<result <<endl;

  for(vector< generic_container< dbus_uint16_t ,std::string ,generic_container< dbus_int16_t ,dbus_int16_t  > ,dbus_uint16_t  >  >::iterator it = listMainSources.begin(); it != listMainSources.end(); it++)
  {
    cout<< "Source ID          : "<<it->first<<endl;
    cout<< "Source Name          : "<<it->second<<endl;
    cout<< "Source Availaility State  : "<<it->third.first<<endl;
    cout<< "Source Availaility Reason  : "<<it->third.second<<endl;
    cout<< "sourceClassID        : "<<it->fourth<<endl<<endl;
  }

  return true;
}
bool bHandleGetListMainSinkSoundProperties()
{
  dbus_uint16_t sinkID;
  dbus_int16_t result;
  std::vector< generic_container< dbus_int16_t ,dbus_int16_t  >  > listSoundProperties;

  cout <<"Enter Sink ID :";
  cin >> sinkID;

  objMain.m_ptrProxy->GetListMainSinkSoundProperties(sinkID,result,listSoundProperties);
  cout <<endl<<"Result "<<result <<endl;

  for(vector< generic_container< dbus_int16_t ,dbus_int16_t  >  >::iterator it = listSoundProperties.begin(); it != listSoundProperties.end();it++)
  {
    cout<<"Property Type  :"<<it->first<<endl;
    cout<<"Property Value :"<<it->second<<endl<<endl;
  }
  return true;
}
bool bHandleGetListMainSourceSoundProperties()
{
  dbus_uint16_t sourceID;
  dbus_int16_t result;
  std::vector< generic_container< dbus_int16_t ,dbus_int16_t  >  > listSoundProperties;

  cout <<"Enter Source ID :";
  cin >> sourceID;

  objMain.m_ptrProxy->GetListMainSourceSoundProperties(sourceID,result,listSoundProperties);
  cout <<endl<<"Result "<<result <<endl;

  for(vector< generic_container< dbus_int16_t ,dbus_int16_t  >  >::iterator it = listSoundProperties.begin(); it != listSoundProperties.end();it++)
  {
    cout<<"Property Type  :"<<it->first<<endl;
    cout<<"Property Value :"<<it->second<<endl<<endl;
  }
  return true;
}
bool bHandleGetListSourceClasses()
{
  dbus_int16_t result;
  std::vector< generic_container< dbus_uint16_t ,std::string ,std::vector< generic_container< dbus_int16_t ,dbus_int16_t  >  >  >  > listSourceClasses;
  objMain.m_ptrProxy->GetListSourceClasses(result,listSourceClasses);
  cout <<endl<<"Result "<<result <<endl;

  for(std::vector< generic_container< dbus_uint16_t ,std::string ,std::vector< generic_container< dbus_int16_t ,dbus_int16_t  >  >  >  >::iterator it = listSourceClasses.begin(); it != listSourceClasses.end(); it++)
  {
    cout<<"Source Class ID      :"<<it->first<<endl;
    cout<<"Source Class Name    :"<<it->second<<endl;
    for(std::vector< generic_container< dbus_int16_t ,dbus_int16_t  >  >::iterator itt = it->third.begin(); itt != it->third.end();itt++)
    {
      cout<<"Class Property :"<<itt->first<<", Value :"<<itt->second<<endl;
    }
  }
  return true;
}
bool bHandleGetListSinkClasses()
{
  dbus_int16_t result;
  std::vector< generic_container< dbus_uint16_t ,std::string ,std::vector< generic_container< dbus_int16_t ,dbus_int16_t  >  >  >  > listSinkClasses;
  objMain.m_ptrProxy->GetListSinkClasses(result,listSinkClasses);
  cout <<endl<<"Result "<<result <<endl;

  for(std::vector< generic_container< dbus_uint16_t ,std::string ,std::vector< generic_container< dbus_int16_t ,dbus_int16_t  >  >  >  >::iterator it = listSinkClasses.begin(); it != listSinkClasses.end(); it++)
  {
    cout<<"Sink Class ID      :"<<it->first<<endl;
    cout<<"Sink Class Name      :"<<it->second<<endl;
    for(std::vector< generic_container< dbus_int16_t ,dbus_int16_t  >  >::iterator itt = it->third.begin(); itt != it->third.end();itt++)
    {
      cout<<"Class Property :"<<itt->first<<", Value :"<<itt->second<<endl;
    }
  }
  return true;
}
bool bHandleGetListSystemProperties()
{
  dbus_int16_t result;
  std::vector< generic_container< dbus_int16_t ,dbus_int16_t  >  > listSystemProperties;

  objMain.m_ptrProxy->GetListSystemProperties(result,listSystemProperties);
  cout <<endl<<"Result "<<result <<endl;

  for(vector< generic_container< dbus_int16_t ,dbus_int16_t  >  >::iterator it = listSystemProperties.begin(); it != listSystemProperties.end(); it++)
  {
    cout<<"System Property Type :"<<it->first <<",Value:"<<it->second<<endl;
  }
  return true;
}

bool bHandleGetTimingInformation()
{
  dbus_uint16_t mainConnectionID;
  dbus_int16_t  result;
  dbus_int16_t  delay;

  cout<<"Enter Main Connection ID :";
  cin >> mainConnectionID;

  objMain.m_ptrProxy->GetTimingInformation(mainConnectionID,result,delay);
  cout <<endl<<"Result "<<result <<endl;

  cout <<"Delay in Milliseconds: "<<delay<<endl;

  return true;
}

bool bHandleVolumeStep()
{
  uint16_t sinkID;

  int16_t  volumeStep, result;

  cout << "Enter Sink ID : ";
  cin>> sinkID;


  cout << "Enter Volume Step  : ";
  cin>> volumeStep;

  objMain.m_ptrProxy->VolumeStep(sinkID, volumeStep, result);

  cout <<endl<<"Result "<<result <<endl;

  return true;
}
//End of file

