/*
 * testapp_dbusobject.cpp
 *
 *  Created on: Sep 12, 2012
 *      Author: rjk2hi
 */

#include "g3g_dbus.h"
#include <vector>
#include <iostream>
#include <string>
#include <iostream>     // std::cout
#include <new>          // std::bad_alloc

#include "audmgr_proxy.h"
audmgrproxy::audmgrproxy(g3g_dbusconnection* rfConnection,const char* sNodeName, const char* sObjectPath, const char* sInterfaceName)
:g3g_dbusobjectproxy::g3g_dbusobjectproxy(rfConnection,sNodeName, sObjectPath,sInterfaceName)
{
#ifdef DEBUG_ENABLE
  std::cout<<"Constructor of Test App Dbus proxy invoked "<<std::endl;
#endif
  m_SignalTable["NumberOfMainConnectionsChanged"] = &audmgrproxy::_NumberOfMainConnectionsChanged;
  m_SignalTable["SinkAdded"] = &audmgrproxy::_SinkAdded;
  m_SignalTable["SinkRemoved"] = &audmgrproxy::_SinkRemoved;
  m_SignalTable["SourceAdded"] = &audmgrproxy::_SourceAdded;
  m_SignalTable["SourceRemoved"] = &audmgrproxy::_SourceRemoved;
  m_SignalTable["NumberOfSinkClassesChanged"] = &audmgrproxy::_NumberOfSinkClassesChanged;
  m_SignalTable["NumberOfSourceClassesChanged"] = &audmgrproxy::_NumberOfSourceClassesChanged;

  //VVD
  m_SignalTable["NewMainConnection"] = &audmgrproxy::_NewMainConnection;
  m_SignalTable["RemovedMainConnection"] = &audmgrproxy::_RemovedMainConnection;

  m_SignalTable["MainConnectionStateChanged"] = &audmgrproxy::_MainConnectionStateChanged;
  m_SignalTable["MainSinkSoundPropertyChanged"] = &audmgrproxy::_MainSinkSoundPropertyChanged;
  m_SignalTable["MainSourceSoundPropertyChanged"] = &audmgrproxy::_MainSourceSoundPropertyChanged;
  m_SignalTable["SinkAvailabilityChanged"] = &audmgrproxy::_SinkAvailabilityChanged;
  m_SignalTable["SourceAvailabilityChanged"] = &audmgrproxy::_SourceAvailabilityChanged;
  m_SignalTable["VolumeChanged"] = &audmgrproxy::_VolumeChanged;
  m_SignalTable["SinkMuteStateChanged"] = &audmgrproxy::_SinkMuteStateChanged;
  m_SignalTable["SystemPropertyChanged"] = &audmgrproxy::_SystemPropertyChanged;
  m_SignalTable["TimingInformationChanged"] = &audmgrproxy::_TimingInformationChanged;

  //Invoke bSetup Function of server
  bSetup();
}

audmgrproxy::~audmgrproxy()
{
}

DBusHandlerResult audmgrproxy::eDispatch_Signal(g3g_dbusmessage *msg)
{
  if(NULL == msg)
    return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;

  std::map<std::string, SigCallback>::iterator it = m_SignalTable.find(msg->getMemberName());

  if(it != m_SignalTable.end())
  {
#ifdef DEBUG_ENABLE
    std::cout<<"<SIGNAL>"<<msg->getMemberName()<<std::endl;
#endif
    SigCallback fptr = (SigCallback)it->second;

    if(fptr != NULL)
    {
      (this->*fptr)(msg);
    }

    return DBUS_HANDLER_RESULT_HANDLED;
  }
  //ToDo : Check if dbus_message_unref has to be called here

  return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}

/***************************************************************************
 * Signal Handlers
 ***************************************************************************/
/*
 * Signal handler for signal > NumberOfMainConnectionsChanged
 */
void audmgrproxy::_NumberOfMainConnectionsChanged(g3g_dbusmessage *msg)
{
    (void)msg;
  NumberOfMainConnectionsChanged();
}

void audmgrproxy::_SinkAdded(g3g_dbusmessage *msg)
{
  generic_container<uint16_t,std::string,generic_container<int16_t,int16_t>,int16_t,int16_t,uint16_t> newSink;
  newSink.first = 0;
  newSink.second = "";
  newSink.third.first = 0;
  newSink.third.second = 0;
  newSink.fourth = 0;
  newSink.fifth = 0;
  newSink.sixth = 0;
  if(msg->bRecurseSubContainer())
  {
    newSink.first = msg->getUInt16();
    newSink.second = msg->getString();
    if(msg->bRecurseSubContainer())
    {
      newSink.third.first = msg->getInt16();
      newSink.third.second = msg->getInt16();
      msg->bCloseSubContainer_ReadFinished();
    }
    newSink.fourth = msg->getInt16();
    newSink.fifth = msg->getInt16();
    newSink.sixth = msg->getUInt16();

    msg->bCloseSubContainer_ReadFinished();
  }
  SinkAdded(newSink);
}
void audmgrproxy::_SinkRemoved(g3g_dbusmessage *msg)
{
  uint16_t removedSinkID;
  removedSinkID = msg->getUInt16();

  SinkRemoved(removedSinkID);
}
void audmgrproxy::_SourceAdded(g3g_dbusmessage *msg)
{
  generic_container<uint16_t, std::string,generic_container<int16_t,int16_t>,uint16_t> newSource;
  newSource.first = 0;
  newSource.second = "";
  newSource.third.first = 0;
  newSource.third.second = 0;
  newSource.fourth = 0;
  if(msg->bRecurseSubContainer())
  {
    newSource.first = msg->getUInt16();
    newSource.second = msg->getString();
    if(msg->bRecurseSubContainer())
    {
      newSource.third.first = msg->getInt16();
      newSource.third.second = msg->getInt16();
      msg->bCloseSubContainer_ReadFinished();
    }
    newSource.fourth = msg->getUInt16();
    msg->bCloseSubContainer_ReadFinished();
  }
  SourceAdded(newSource);
}

void audmgrproxy::_SourceRemoved(g3g_dbusmessage *msg)
{
  uint16_t removedSourceID;
  removedSourceID = msg->getUInt16();
  SourceRemoved(removedSourceID);
}
void audmgrproxy::_NumberOfSinkClassesChanged(g3g_dbusmessage *msg)
{
  (void)msg;
  NumberOfSinkClassesChanged();
}
void audmgrproxy::_NumberOfSourceClassesChanged(g3g_dbusmessage *msg)
{
  (void)msg;
  NumberOfSourceClassesChanged();
}
//VVD
void audmgrproxy::_NewMainConnection(g3g_dbusmessage *msg)
{
  generic_container<dbus_uint16_t ,dbus_uint16_t ,dbus_uint16_t ,dbus_int16_t ,dbus_int16_t> mainConnection;

  mainConnection.first = 0;
  mainConnection.second = 0;
  mainConnection.third = 0;
  mainConnection.fourth = 0;
  mainConnection.fifth = 0;

  if(msg->bRecurseSubContainer())
  {
    mainConnection.first = msg->getUInt16();
    mainConnection.second = msg->getUInt16();
    mainConnection.third = msg->getUInt16();
    mainConnection.fourth = msg->getInt16();
    mainConnection.fifth = msg->getInt16();
      msg->bCloseSubContainer_ReadFinished();
  }

  NewMainConnection(mainConnection);
}
void audmgrproxy::_RemovedMainConnection(g3g_dbusmessage *msg)
{
  uint16_t connectionID = 0;
  connectionID = msg->getUInt16();
  RemovedMainConnection(connectionID);
}
void audmgrproxy::_MainConnectionStateChanged(g3g_dbusmessage *msg)
{
  uint16_t connectionID = 0;
  int16_t connectionState = 0;

  connectionID = msg->getUInt16();
  connectionState = msg->getInt16();

  MainConnectionStateChanged(connectionID,connectionState);
}

void audmgrproxy::_MainSinkSoundPropertyChanged(g3g_dbusmessage *msg)
{
  uint16_t sinkID;
  generic_container<int16_t,int16_t> SoundProperty;
  SoundProperty.first = 0;
  SoundProperty.second = 0;
  sinkID = msg->getUInt16();
  if(msg->bRecurseSubContainer())
  {
    SoundProperty.first = msg->getInt16();
    SoundProperty.second = msg->getInt16();
    msg->bCloseSubContainer_ReadFinished();
  }
  MainSinkSoundPropertyChanged(sinkID,SoundProperty);
}
void audmgrproxy::_MainSourceSoundPropertyChanged(g3g_dbusmessage *msg)
{
  uint16_t sourceID;
  generic_container<int16_t,int16_t> SoundProperty;
  SoundProperty.first = 0;
  SoundProperty.second = 0;
  sourceID = msg->getUInt16();
  if(msg->bRecurseSubContainer())
  {
    SoundProperty.first = msg->getInt16();
    SoundProperty.second = msg->getInt16();
    msg->bCloseSubContainer_ReadFinished();
  }
  MainSourceSoundPropertyChanged(sourceID,SoundProperty);
}
void audmgrproxy::_SinkAvailabilityChanged(g3g_dbusmessage *msg)
{
  uint16_t sinkID;
  generic_container<int16_t,int16_t> availability ;
  availability.first = 0;
  availability.second = 0;
  sinkID = msg->getUInt16();
  if(msg->bRecurseSubContainer())
  {
    availability.first = msg->getInt16();
    availability.second = msg->getInt16();
    msg->bCloseSubContainer_ReadFinished();
  }
  SinkAvailabilityChanged(sinkID,availability);
}
void audmgrproxy::_SourceAvailabilityChanged(g3g_dbusmessage *msg)
{
  uint16_t sourceID;
  generic_container<int16_t,int16_t> availability;
  availability.first = 0;
  availability.second = 0;
  sourceID = msg->getUInt16();
  if(msg->bRecurseSubContainer())
  {
    availability.first = msg->getInt16();
    availability.second = msg->getInt16();
    msg->bCloseSubContainer_ReadFinished();
  }
  SourceAvailabilityChanged(sourceID,availability);
}
void audmgrproxy::_VolumeChanged(g3g_dbusmessage *msg)
{
  uint16_t sinkID;
  int16_t volume;

  sinkID = msg->getUInt16();
  volume = msg->getInt16();

  VolumeChanged(sinkID,volume);
}
void audmgrproxy::_SinkMuteStateChanged(g3g_dbusmessage *msg)
{
  uint16_t sinkID;
  int16_t muteState;

  sinkID = msg->getUInt16();
  muteState = msg->getInt16();
  SinkMuteStateChanged(sinkID,muteState);
}
void audmgrproxy::_SystemPropertyChanged(g3g_dbusmessage *msg)
{
  generic_container<int16_t,int16_t> SystemProperty;// = {0,0};
  SystemProperty.first = 0;
  SystemProperty.second = 0;
  if(msg->bRecurseSubContainer())
  {
    SystemProperty.first = msg->getInt16();
    SystemProperty.second = msg->getInt16();
    msg->bCloseSubContainer_ReadFinished();
  }
  SystemPropertyChanged(SystemProperty);
}
void audmgrproxy::_TimingInformationChanged(g3g_dbusmessage *msg)
{
  uint16_t mainConnection;
  int16_t u16time;
  mainConnection = msg->getUInt16();
  u16time = msg->getInt16();
  TimingInformationChanged(mainConnection,u16time);
}

/***************************************************************************
 * Methods
 ***************************************************************************/
bool audmgrproxy::Connect(const uint16_t& sourceID, const uint16_t& sinkID, int16_t& result, uint16_t& mainConnectionID)
{
  //Init method call
  //try catch used to handle "std::bad_alloc"
  try {
    g3g_dbusmessage* method_call = m_oMsgHandler.CreateMethodCall(std::string("Connect"));

    //Add parameters to the message
    method_call->append(sourceID);
    method_call->append(sinkID);
    try {
      //Call send method
      g3g_dbusmessage* method_reply = m_oMsgHandler.sendMethodCall(method_call);

  //Parse the response
  if(method_reply != NULL)
  {
    //Read arguments in the same order as XML file
    result = method_reply->getInt16();
    mainConnectionID = method_reply->getUInt16();

    method_reply->FreeDBusMessage();
    delete method_reply;

        //free the method_call memory
        delete method_call;

        return true;
      }
    } catch (...) {
      //Nothing to do just catching exception
    }
    delete method_call;
  }

  catch (...) {
    //Nothing to do just catching exception
  }
  return false;
}

bool audmgrproxy::Disconnect(uint16_t& mainConnectionID, int16_t& result)
{
  //Init method call
  //try catch used to handle "std::bad_alloc"
  try {
    g3g_dbusmessage* method_call = m_oMsgHandler.CreateMethodCall(std::string("Disconnect"));

    //Add parameters to the message
    method_call->append(mainConnectionID);
    try {

  //Call send method
  g3g_dbusmessage* method_reply = m_oMsgHandler.sendMethodCall(method_call);

  //Parse the response
  if(method_reply != NULL)
  {
    //Read arguments in the same order as XML file
    result = method_reply->getInt16();

        method_reply->FreeDBusMessage();
        delete method_reply;

        //free the method_call memory
        delete method_call;
        return true;
      }
    } catch (...) {
      //Nothing to do just catching exception
    }
    delete method_call;

  } catch (...) {
    //Nothing to do just catching exception
  }
  return true;
}

bool audmgrproxy::SetVolume(uint16_t& sinkID,uint16_t& Mode, int16_t& value, int16_t& result)
{
  //Init method call
  //try catch used to handle "std::bad_alloc"
  try {
    g3g_dbusmessage* method_call = m_oMsgHandler.CreateMethodCall(std::string("SetVolume"));

  //Add parameters to the message
  method_call->append(sinkID);
  method_call->append(Mode);
  method_call->append(value);

    try {
      //Call send method
      g3g_dbusmessage* method_reply = m_oMsgHandler.sendMethodCall(method_call);

  //Parse the response
  if(method_reply != NULL)
  {
    //Read arguments in the same order as XML file
    result = method_reply->getInt16();

        method_reply->FreeDBusMessage();
        delete method_reply;
        delete method_call;
        return true;
      }
    }

    catch (...) {
      //Nothing to do just catching exception
    }
    delete method_call;
  } catch (...) {
    //Nothing to do just catching exception
  }
  return false;
}

bool audmgrproxy::VolumeStep(uint16_t& sinkID, int16_t& value, int16_t& result)
{
  //Init method call
  //try catch used to handle "std::bad_alloc"
  try {
    g3g_dbusmessage* method_call = m_oMsgHandler.CreateMethodCall(std::string("VolumeStep"));

  //Add parameters to the message
  method_call->append(sinkID);
  method_call->append(value);

    try {
      //Call send method
      g3g_dbusmessage* method_reply = m_oMsgHandler.sendMethodCall(method_call);

  //Parse the response
  if(method_reply != NULL)
  {
    //Read arguments in the same order as XML file
    result = method_reply->getInt16();

        method_reply->FreeDBusMessage();
        delete method_reply;

        //free the method_call memory
        delete method_call;
        return true;
      }
    } catch (...) {
      //Nothing to do just catching exception
    }
    //free the method_call memory
    delete method_call;
  } catch (...) {
    //Nothing to do just catching exception
  }
  return false;
}

bool audmgrproxy::SetSinkMuteState(uint16_t& sinkID, int16_t& muteState,int16_t& result)
{
  //Init method call
  //try catch used to handle "std::bad_alloc"
  try {
    g3g_dbusmessage* method_call = m_oMsgHandler.CreateMethodCall(std::string("SetSinkMuteState"));

  //Add parameters to the message
  method_call->append(sinkID);
  method_call->append(muteState);

    try {
      //Call send method
      g3g_dbusmessage* method_reply = m_oMsgHandler.sendMethodCall(method_call);

  //Parse the response
  if(method_reply != NULL)
  {
    //Read arguments in the same order as XML file
    result = method_reply->getInt16();

        method_reply->FreeDBusMessage();
        delete method_reply;

        //free the method_call memory
        delete method_call;
        return true;
      }
    } catch (...) {
      //Nothing to do just catching exception
    }
    delete method_call;

  }

  catch (...) {
    //Nothing to do just catching exception
  }
  //free the method_call memory
  return false;
}

bool audmgrproxy::SetMainSinkSoundProperty(uint16_t& sinkID, generic_container<int16_t,int16_t>& soundProperty,int16_t& result)
{
  //Init method call
  g3g_dbusmessage* method_call = m_oMsgHandler.CreateMethodCall(std::string("SetMainSinkSoundProperty"));

  if (method_call != NULL) {
    //Add parameters to the message
    method_call->append(sinkID);

  method_call->bCreateSubContainer(CONTAINER_TYPE_STRUCT, NULL);
  method_call->append(soundProperty.first);
  method_call->append(soundProperty.second);
  method_call->bCloseSubContainer_WriteFinished();

  //Call send method
  g3g_dbusmessage* method_reply = m_oMsgHandler.sendMethodCall(method_call);

  //Parse the response
  if(method_reply != NULL)
  {
    //Read arguments in the same order as XML file
    result = method_reply->getInt16();

      method_reply->FreeDBusMessage();
      delete method_reply;
      //free the method_call memory
      delete method_call;
      return true;
    }
    delete method_call;
  }
  return false;
}

bool audmgrproxy::SetMainSourceSoundProperty(uint16_t& sourceID, generic_container<int16_t,int16_t>& soundProperty,int16_t& result)
{
  //Init method call
  g3g_dbusmessage* method_call = m_oMsgHandler.CreateMethodCall(std::string("SetMainSourceSoundProperty"));

  if (method_call != NULL) {
    //Add parameters to the message
    method_call->append(sourceID);

  method_call->bCreateSubContainer(CONTAINER_TYPE_STRUCT, NULL);
  method_call->append(soundProperty.first);
  method_call->append(soundProperty.second);
  method_call->bCloseSubContainer_WriteFinished();

  //Call send method
  g3g_dbusmessage* method_reply = m_oMsgHandler.sendMethodCall(method_call);

  //Parse the response
  if(method_reply != NULL)
  {
    //Read arguments in the same order as XML file
    result = method_reply->getInt16();

      method_reply->FreeDBusMessage();
      delete method_reply;
      //free the method_call memory
      delete method_call;
      return true;
    }
    delete method_call;
  }

  return false;
}
bool audmgrproxy::SetSystemProperty(generic_container< dbus_int16_t ,dbus_int16_t  >& Property, dbus_int16_t & result)
{
  //Init method call
  g3g_dbusmessage* method_call = m_oMsgHandler.CreateMethodCall(std::string("SetSystemProperty"));

  if (method_call != NULL) {
    //Add parameters to the message
    method_call->bCreateSubContainer(CONTAINER_TYPE_STRUCT, NULL);
    method_call->append(Property.first);
    method_call->append(Property.second);
    method_call->bCloseSubContainer_WriteFinished();

  //Call send method
  g3g_dbusmessage* method_reply = m_oMsgHandler.sendMethodCall(method_call);

  //Parse the response
  if(method_reply != NULL)
  {
    //Read arguments in the same order as XML file
    result = method_reply->getInt16();

      method_reply->FreeDBusMessage();
      delete method_reply;

      //free the method_call memory
      delete method_call;
      return true;
    }
    delete method_call;
  }
  return false;
}

bool audmgrproxy::GetListMainConnections(dbus_int16_t & result, std::vector< generic_container< dbus_uint16_t ,dbus_uint16_t ,dbus_uint16_t ,dbus_int16_t ,dbus_int16_t  >  > & listConnections)
{
  //Init method call
  g3g_dbusmessage* method_call = m_oMsgHandler.CreateMethodCall(std::string("GetListMainConnections"));

  //Add parameters to the message
//Call send method
  g3g_dbusmessage* method_reply = NULL;

  if (method_call != NULL)
    method_reply = m_oMsgHandler.sendMethodCall(method_call);

  //Parse the response
  if (method_reply != NULL) {
    //Read arguments in the same order as XML file
    result = method_reply->getInt16();

    if (method_reply->bRecurseSubContainer()) {
      while (!method_reply->bSubContainerEnd()) {
        if (method_reply->bRecurseSubContainer()) {
          generic_container<dbus_uint16_t, dbus_uint16_t,
              dbus_uint16_t, dbus_int16_t, dbus_int16_t> temp;
          temp.first = method_reply->getUInt16();
          temp.second = method_reply->getUInt16();
          temp.third = method_reply->getUInt16();
          temp.fourth = method_reply->getInt16();
          temp.fifth = method_reply->getInt16();

          listConnections.push_back(temp);

          method_reply->bCloseSubContainer_ReadFinished();
        }
      }
      method_reply->bCloseSubContainer_ReadFinished();
    }
    method_reply->FreeDBusMessage();
    delete method_reply;

    //method_call->FreeDBusMessage();
    delete method_call;

    return true;
  }

  //method_call->FreeDBusMessage();
  delete method_call;

  return false;
}

bool audmgrproxy::GetListMainSinks(int16_t result, std::vector< generic_container<uint16_t, std::string, generic_container<int16_t,int16_t>, int16_t,int16_t,uint16_t > > &resp)
{
  //Init method call
  g3g_dbusmessage* method_call = m_oMsgHandler.CreateMethodCall(std::string("GetListMainSinks"));

  //Append args
  if (method_call != NULL) {
    //Call send method
    g3g_dbusmessage* method_reply = m_oMsgHandler.sendMethodCall(method_call);

  //Parse the response
  if(method_reply != NULL)
  {
    //Read arguments in the same order as XML file
    result = method_reply->getInt16();
    (void)result;
    if(method_reply->bRecurseSubContainer())//Array
    {
      while(!method_reply->bSubContainerEnd())
      {
        if(method_reply->bRecurseSubContainer())//Structure level 1
        {
          while(!method_reply->bSubContainerEnd())
          {
            generic_container<uint16_t, std::string, generic_container<int16_t,int16_t>, int16_t,int16_t,uint16_t > temp;
            temp.first = method_reply->getUInt16();
            temp.second = method_reply->getString();

            //Open Sub Container
            if(method_reply->bRecurseSubContainer())//structure level 2
            {
              while(!method_reply->bSubContainerEnd())
              {
                temp.third.first = method_reply->getInt16();
                temp.third.second = method_reply->getInt16();
              }
              method_reply->bCloseSubContainer_ReadFinished();
            }
            temp.fourth = method_reply->getInt16();
            temp.fifth  = method_reply->getInt16();
            temp.sixth  = method_reply->getUInt16();

              //Parsing complete
              resp.push_back(temp);
            }
            method_reply->bCloseSubContainer_ReadFinished();
          }
        }
        method_reply->bCloseSubContainer_ReadFinished();
      }
      method_reply->FreeDBusMessage();
      delete method_reply;
      //free the method_call memory
      delete method_call;
      return true;
    }
    delete method_call;
  }
  return false;
}

bool audmgrproxy::GetListMainSources(dbus_int16_t & result, std::vector< generic_container< dbus_uint16_t ,std::string ,generic_container< dbus_int16_t ,dbus_int16_t  > ,dbus_uint16_t  >  > & listMainSources)
{
  //Init method call
  g3g_dbusmessage* method_call = m_oMsgHandler.CreateMethodCall(std::string("GetListMainSources"));

  //Append args
  if (method_call != NULL) {
    //Call send method
    g3g_dbusmessage* method_reply = m_oMsgHandler.sendMethodCall(method_call);

  //Parse the response
  if(method_reply != NULL)
  {
    result = method_reply->getInt16();

    if(method_reply->bRecurseSubContainer())//Array
    {
      while(!method_reply->bSubContainerEnd())
      {
        generic_container< dbus_uint16_t ,std::string ,generic_container< dbus_int16_t ,dbus_int16_t  > ,dbus_uint16_t  > temp;
        if(method_reply->bRecurseSubContainer())
        {
          temp.first = method_reply->getUInt16();
          temp.second = method_reply->getString();
          if(method_reply->bRecurseSubContainer())
          {
            temp.third.first = method_reply->getInt16();
            temp.third.second = method_reply->getInt16();
            method_reply->bCloseSubContainer_ReadFinished();
          }
          temp.fourth = method_reply->getUInt16();
          method_reply->bCloseSubContainer_ReadFinished();
        }
        listMainSources.push_back(temp);
      }
      method_reply->bCloseSubContainer_ReadFinished();
    }

      method_reply->FreeDBusMessage();
      delete method_reply;

      //free the method_call memory
      delete method_call;
      return true;
    }
    delete method_call;
  }
  return false;
}
bool audmgrproxy::GetListMainSinkSoundProperties(dbus_uint16_t & sinkID, dbus_int16_t & result, std::vector< generic_container< dbus_int16_t ,dbus_int16_t  >  > & listSoundProperties)
{
  //Init method call
  g3g_dbusmessage* method_call = m_oMsgHandler.CreateMethodCall(std::string("GetListMainSinkSoundProperties"));

  if (method_call != NULL) {
    //Append args
    method_call->append(sinkID);

  //Call send method
  g3g_dbusmessage* method_reply = m_oMsgHandler.sendMethodCall(method_call);

  //Parse the response
  if(method_reply != NULL)
  {
    result = method_reply->getInt16();
    if(method_reply->bRecurseSubContainer())//Array
    {
      while(!method_reply->bSubContainerEnd())
      {
        generic_container< dbus_int16_t ,dbus_int16_t  > temp;
    temp.first = 0;
    temp.second = 0;
        if(method_reply->bRecurseSubContainer())
        {
          temp.first = method_reply->getInt16();
          temp.second = method_reply->getInt16();
          method_reply->bCloseSubContainer_ReadFinished();
        }
        listSoundProperties.push_back(temp);
      }
      method_reply->bCloseSubContainer_ReadFinished();
    }
    method_reply->FreeDBusMessage();
    delete method_reply;
      //free the method_call memory
      delete method_call;
    return true;
  }
    delete method_call;
  }
  return false;
}
bool audmgrproxy::GetListMainSourceSoundProperties(dbus_uint16_t & sourceID, dbus_int16_t & result, std::vector< generic_container< dbus_int16_t ,dbus_int16_t  >  > & listSoundProperties)
{
  //Init method call
  g3g_dbusmessage* method_call = m_oMsgHandler.CreateMethodCall(std::string("GetListMainSourceSoundProperties"));

  if (method_call != NULL) {
    //Append args
    method_call->append(sourceID);

  //Call send method
  g3g_dbusmessage* method_reply = m_oMsgHandler.sendMethodCall(method_call);

    //Parse the response
    if (method_reply != NULL) {
      result = method_reply->getInt16();
      if (method_reply->bRecurseSubContainer())  //Array
      {
        while (!method_reply->bSubContainerEnd()) {
          generic_container<dbus_int16_t, dbus_int16_t> temp;
          temp.first = 0;
          temp.second = 0;
          if (method_reply->bRecurseSubContainer()) {
            temp.first = method_reply->getInt16();
            temp.second = method_reply->getInt16();
            method_reply->bCloseSubContainer_ReadFinished();
          }
          listSoundProperties.push_back(temp);
        }
        method_reply->bCloseSubContainer_ReadFinished();
      }
      method_reply->FreeDBusMessage();
      delete method_reply;
      //free the method_call memory
      delete method_call;

      return true;
    }
    delete method_call;
  }
  return false;
}
bool audmgrproxy::GetListSourceClasses(dbus_int16_t & result, std::vector< generic_container< dbus_uint16_t ,std::string ,std::vector< generic_container< dbus_int16_t ,dbus_int16_t  >  >  >  > & listSourceClasses)
{
  //Init method call
  g3g_dbusmessage* method_call = m_oMsgHandler.CreateMethodCall(std::string("GetListSourceClasses"));

  //Append args
  if (method_call != NULL) {
    //Call send method
    g3g_dbusmessage* method_reply = m_oMsgHandler.sendMethodCall(method_call);

  //Parse the response
  if(method_reply != NULL)
  {
    result = method_reply->getInt16();
    if(method_reply->bRecurseSubContainer())//Array
    {
      while(!method_reply->bSubContainerEnd())
      {
        generic_container< dbus_uint16_t ,std::string ,std::vector< generic_container< dbus_int16_t ,dbus_int16_t  >  >  > temp;
        if(method_reply->bRecurseSubContainer())
        {
          temp.first = method_reply->getUInt16();
          temp.second = method_reply->getString();
          if(method_reply->bRecurseSubContainer())
          {
            while(!method_reply->bSubContainerEnd())
            {
              generic_container< dbus_int16_t ,dbus_int16_t  > temp2;
        temp2.first = 0;
        temp2.second = 0;
              if(method_reply->bRecurseSubContainer())
              {
                temp2.first = method_reply->getInt16();
                temp2.second = method_reply->getInt16();
                method_reply->bCloseSubContainer_ReadFinished();
              }
              temp.third.push_back(temp2);
            }
            method_reply->bCloseSubContainer_ReadFinished();
          }
          method_reply->bCloseSubContainer_ReadFinished();
        }
        listSourceClasses.push_back(temp);
      }
      method_reply->bCloseSubContainer_ReadFinished();
    }
    method_reply->FreeDBusMessage();
    delete method_reply;
      //free the method_call memory
      delete method_call;
    return true;
  }
    delete method_call;
  }
  return false;
}

bool audmgrproxy::GetListSinkClasses(dbus_int16_t & result, std::vector< generic_container< dbus_uint16_t ,std::string ,std::vector< generic_container< dbus_int16_t ,dbus_int16_t  >  >  >  > & listSinkClasses)
{
  //Init method call
  g3g_dbusmessage* method_call = m_oMsgHandler.CreateMethodCall(std::string("GetListSinkClasses"));

  //Append args
  if (method_call != NULL) {
  //Call send method
  g3g_dbusmessage* method_reply = m_oMsgHandler.sendMethodCall(method_call);

  //Parse the response
  if(method_reply != NULL)
  {
    result = method_reply->getInt16();
    if(method_reply->bRecurseSubContainer())//Array
    {
      while(!method_reply->bSubContainerEnd())
      {
        generic_container< dbus_uint16_t ,std::string ,std::vector< generic_container< dbus_int16_t ,dbus_int16_t  >  >  > temp;
        if(method_reply->bRecurseSubContainer())
        {
          temp.first = method_reply->getUInt16();
          temp.second = method_reply->getString();
          if(method_reply->bRecurseSubContainer())
          {
            while(!method_reply->bSubContainerEnd())
            {
              generic_container< dbus_int16_t ,dbus_int16_t  > temp2;
        temp2.first =0;
        temp2.second =0;
              if(method_reply->bRecurseSubContainer())
              {
                temp2.first = method_reply->getInt16();
                temp2.second = method_reply->getInt16();
                method_reply->bCloseSubContainer_ReadFinished();
              }
              temp.third.push_back(temp2);
            }
            method_reply->bCloseSubContainer_ReadFinished();
          }
          method_reply->bCloseSubContainer_ReadFinished();
        }
        listSinkClasses.push_back(temp);
      }
      method_reply->bCloseSubContainer_ReadFinished();
    }
    method_reply->FreeDBusMessage();
    delete method_reply;
      //free the method_call memory
      delete method_call;
    return true;
  }
    delete method_call;
  }
  return false;
}

bool audmgrproxy::GetListSystemProperties(dbus_int16_t & result, std::vector< generic_container< dbus_int16_t ,dbus_int16_t  >  > & listSystemProperties)
{
  //Init method call
  g3g_dbusmessage* method_call = m_oMsgHandler.CreateMethodCall(std::string("GetListSystemProperties"));

  //Append args
  if (method_call != NULL) {
  //Call send method
  g3g_dbusmessage* method_reply = m_oMsgHandler.sendMethodCall(method_call);

  //Parse the response
  if(method_reply != NULL)
  {
    result = method_reply->getInt16();
    if(method_reply->bRecurseSubContainer())//Array
    {
      while(!method_reply->bSubContainerEnd())
      {
        generic_container< dbus_int16_t ,dbus_int16_t  > temp;
    temp.first = 0;
    temp.second = 0;
        if(method_reply->bRecurseSubContainer())
        {
          temp.first = method_reply->getInt16();
          temp.second = method_reply->getInt16();
          method_reply->bCloseSubContainer_ReadFinished();
        }
        listSystemProperties.push_back(temp);
      }
      method_reply->bCloseSubContainer_ReadFinished();
    }
    method_reply->FreeDBusMessage();
    delete method_reply;
      //free the method_call memory
      delete method_call;
    return true;
  }
    delete method_call;
  }
  return false;
}
bool audmgrproxy::GetTimingInformation(dbus_uint16_t & mainConnectionID, dbus_int16_t & result, dbus_int16_t & delay)
{
  //Init method call
  try {
  g3g_dbusmessage* method_call = m_oMsgHandler.CreateMethodCall(std::string("GetTimingInformation"));

  //Append args
  method_call->append(mainConnectionID);

    try {
  //Call send method
  g3g_dbusmessage* method_reply = m_oMsgHandler.sendMethodCall(method_call);

  //Parse the response
  if(method_reply != NULL)
  {
    result = method_reply->getInt16();
    delay = method_reply->getInt16();

    method_reply->FreeDBusMessage();
    delete method_reply;
        delete method_call;
        return true;
      }
    } catch (...) {
      //Nothing to do just catching exception
    }
    delete method_call;
  }

  catch (...) {
    //Nothing to do just catching exception
  }
  return false;
}
