/*
 * clienhandler_audiomanager.cpp
 *
 *  Created on: Oct 21, 2011
 *      Author: ranjit
 */

#include "audmgr_clienthandler.h"

#include <iostream>
using namespace std;

audmgr_clienthandler::audmgr_clienthandler(g3g_dbusconnection* rfConnection,const char* sNodeName, const char* sObjectPath, const char* sInterfaceName)
: audmgrproxy(rfConnection,sNodeName,sObjectPath,sInterfaceName)
{
  //We have invoked base class ructor ... so be happy you dont have to do anything :-)
  cout<<"Client Handler Instance Created"<<endl;
}

/*
 * Signal Handlers
 */
void audmgr_clienthandler::NumberOfMainConnectionsChanged()
{
    cout<<"[ NumberOfMainConnectionsChanged called ] =>";
}

#if 0
struct am_SinkType_s
{

public:
  am_sinkID_t sinkID;
  std::string name;
  am_Availability_s availability;
  am_mainVolume_t volume;
  am_MuteState_e muteState;
  am_sinkClass_t sinkClassID;
};

struct am_Availability_s
{

public:
  am_Availablility_e availability;
  am_AvailabilityReason_e availabilityReason;

};
enum am_Availablility_e
  {
    A_UNKNOWN = 0,
    A_AVAILABLE = 1,
    A_UNAVAILABLE = 2,
    A_MAX
  };
enum am_AvailabilityReason_e
{
  AR_UNKNOWN = 0,
  AR_GENIVI_NEWMEDIA = 1,
  AR_GENIVI_SAMEMEDIA = 2,
  AR_GENIVI_NOMEDIA = 3,
  AR_GENIVI_TEMPERATURE = 4,
  AR_GENIVI_VOLTAGE = 5,
  AR_GENIVI_ERRORMEDIA = 6,
  AR_MAX
};
enum am_MuteState_e
{
  MS_UNKNOWN = 0,
  MS_MUTED = 1,
  MS_UNMUTED = 2,
  MS_MAX
};
#endif

void audmgr_clienthandler::SinkAdded(generic_container< uint16_t, std::string, generic_container< int16_t, int16_t >, int16_t, int16_t, uint16_t >& newSink)
{
  //1. Sink ID
  cout<< "Sink ID "<< newSink.first<<endl;

  //2. Sink Name
  cout<< "Sink Name "<< newSink.second << endl;

  /* Availability */
  //3. Current Availability State
  cout<< "Current Availability State "<< newSink.third.first <<" : ";

  switch(newSink.third.first)
  {
  case 1 : cout<<"A_AVAILABLE"; break;//The source / sink is available
  case 2 : cout<<"A_UNAVAILABLE";break;//The source / sink is not available
  default: cout<<"A_UNKNOWN";break;// Unknown
  }
  cout<<endl;

  //4. Current Availability Reason
  cout<< "Current Availability Reason "<< newSink.third.second <<" : ";
  switch(newSink.third.second)
  {
  case 1: cout<<"AR_GENIVI_NEWMEDIA"; break;//availability changed because an new media was entered
  case 2: cout<<"AR_GENIVI_SAMEMEDIA"; break;//availability changed because the same media was entered
  case 3: cout<<"AR_GENIVI_NOMEDIA"; break;//availability changed because there is no media
  case 4: cout<<"AR_GENIVI_TEMPERATURE"; break;//availability changed because of a temperature event
  case 5: cout<<"AR_GENIVI_VOLTAGE"; break;//availability changed because of a voltage event
  case 6: cout<<"AR_GENIVI_ERRORMEDIA"; break;//availability changed because of fatal errors reading or accessing media
  default: cout<<"AR_UNKNOWN"; break;
  }
  cout<<endl;

  //5. Volume
  cout<< "Volume "<< newSink.fourth <<endl;

  //6. Mute State
  cout<< "Mute State "<< newSink.fifth<<" : ";
  switch(newSink.fifth)
  {
  case 1: cout<<"MS_MUTED";break; //Sink State Muted
  case 2: cout<<"MS_UNMUTED";break; //Sink State Unmuted
  default: cout<<"MS_UNKNOWN";break;//Sink Mute state Unknown
  }
  cout<<endl;

  //7. Sink Class ID
  cout<< "Sink Class ID" << newSink.sixth <<endl;
}
void audmgr_clienthandler::SinkRemoved( uint16_t& removedSinkID)
{
  //1. Sink ID
  cout<< "Audio Sink with Sink ID "<< removedSinkID <<" removed"<<endl;
}

#if 0
struct am_SourceType_s
{

public:
  am_sourceID_t sourceID;
  std::string name;
  am_Availability_s availability;
  am_sourceClass_t sourceClassID;
};
#endif
void audmgr_clienthandler::SourceAdded( generic_container< uint16_t, std::string, generic_container< int16_t, int16_t >, uint16_t >& newSource)
{

  //1. Source ID
  cout<<"Source ID "<< newSource.first<<endl;

  //2. Source Name
  cout<<"Source Name "<< newSource.second<<endl;

  /* Availability */
  //3. Current Availability State
  cout<< "Current Availability State "<< newSource.third.first <<" : ";

  switch(newSource.third.first)
  {
  case 1 : cout<<"A_AVAILABLE"; break;//The source / sink is available
  case 2 : cout<<"A_UNAVAILABLE";break;//The source / sink is not available
  default: cout<<"A_UNKNOWN";break;// Unknown
  }
  cout<<endl;

  //4. Current Availability Reason
  cout<< "Current Availability Reason "<< newSource.third.second <<" : ";
  switch(newSource.third.second)
  {
  case 1: cout<<"AR_GENIVI_NEWMEDIA"; break;//availability changed because an new media was entered
  case 2: cout<<"AR_GENIVI_SAMEMEDIA"; break;//availability changed because the same media was entered
  case 3: cout<<"AR_GENIVI_NOMEDIA"; break;//availability changed because there is no media
  case 4: cout<<"AR_GENIVI_TEMPERATURE"; break;//availability changed because of a temperature event
  case 5: cout<<"AR_GENIVI_VOLTAGE"; break;//availability changed because of a voltage event
  case 6: cout<<"AR_GENIVI_ERRORMEDIA"; break;//availability changed because of fatal errors reading or accessing media
  default: cout<<"AR_UNKNOWN"; break;
  }
  cout<<endl;

  //5. Source Class ID
  cout<<"Source Class ID "<<newSource.fourth<<endl;
}
void audmgr_clienthandler::SourceRemoved( uint16_t& removedSourceID)
{
  //1. Source ID
  cout<< "Audio Source with Source ID "<< removedSourceID <<" removed"<<endl;
}

void audmgr_clienthandler::NumberOfSinkClassesChanged()
{
}

void audmgr_clienthandler::NumberOfSourceClassesChanged()
{
}

#if 0
enum am_ConnectionState_e
{
  CS_UNKNOWN = 0,
  CS_CONNECTING = 1,
  CS_CONNECTED = 2,
  CS_DISCONNECTING = 3,
  CS_DISCONNECTED = 4,
  CS_SUSPENDED = 5,
  CS_MAX
};
#endif

//VVD
void audmgr_clienthandler::NewMainConnection(generic_container<dbus_uint16_t ,dbus_uint16_t ,dbus_uint16_t ,dbus_int16_t ,dbus_int16_t>& NewMainConnectionList)
{
  cout<<"[ NewMainConnection ] =>";
  //1. Connection ID
  cout<<"Connection ID :"<< NewMainConnectionList.first;

  //2. Source ID
  cout<<", Source ID :"<< NewMainConnectionList.second;

  //3. SinkID
  cout<<", Sink ID :"<< NewMainConnectionList.third;

  //4. Delay
  cout<<", Delay :"<< NewMainConnectionList.fourth;

  //5. Connection Status
  cout<< ", Status :";
  switch(NewMainConnectionList.fifth)
  {
    case 1: cout<<"CS_CONNECTING";break;//connection is just building up
    case 2: cout<<"CS_CONNECTED";break;//the connection is ready to be used
    case 3: cout<<"CS_DISCONNECTING";break;//the connection is in the course to be knocked down
    case 4: cout<<"CS_DISCONNECTED";break;//only relevant for connectionStatechanged. Is sent after the connection was removed
    case 5: cout<<"CS_SUSPENDED";break;//connection is still build up but unused at the moment
    default: cout<<"CS_UNKNOWN";break;
  }
  cout <<endl;
}
void audmgr_clienthandler::RemovedMainConnection(uint16_t& connectionID)
{
  cout<<"[ RemovedMainConnection ] =>";
  //1. Connection ID
  cout<<"Connection ID :"<< connectionID;
  cout <<endl;
}

void audmgr_clienthandler::MainConnectionStateChanged( uint16_t& connectionID,  int16_t& connectionState)
{
  //1. Connection ID
  cout<<"Connection ID "<< connectionID;

  //2. Connection Status
  cout<< " Status ";
  switch(connectionState)
  {
  case 1: cout<<"CS_CONNECTING";break;//connection is just building up
  case 2: cout<<"CS_CONNECTED";break;//the connection is ready to be used
  case 3: cout<<"CS_DISCONNECTING";break;//the connection is in the course to be knocked down
  case 4: cout<<"CS_DISCONNECTED";break;//only relevant for connectionStatechanged. Is sent after the connection was removed
  case 5: cout<<"CS_SUSPENDED";break;//connection is still build up but unused at the moment
  default: cout<<"CS_UNKNOWN";break;
  }
  cout <<endl;
}
#if 0
struct am_MainSoundProperty_s
{
public:
  /**
   * the type of the property
   */
  am_MainSoundPropertyType_e type;
  /**
   * the actual value
   */
  int16_t value;
};

  enum am_MainSoundPropertyType_e
  {
    /**************************************************************************
     * default
     */
    MSP_UNKNOWN = 0,
    /**
     * Bass setting to absolute value
     */
    MSP_SOUND_BASS = 1,
    /**
     * Bass setting with relative steps. Modifies property MSP_SOUND_BASS
     */
    MSP_SOUND_BASS_RELATIVE = 2,
    /**
     * Middle setting to absolute value
     */
    MSP_SOUND_MIDDLE = 3,
    /**
     * Middle setting with relative steps. Modifies property MSP_SOUND_MIDDLE
     */
    MSP_SOUND_MIDDLE_RELATIVE = 4,
    /**
     * Treble setting to absolute value
     */
    MSP_SOUND_TREBLE = 5,
    /**
     * Treble setting with relative steps. Modifies property MSP_SOUND_TREBLE
     */
    MSP_SOUND_TREBLE_RELATIVE = 6,
    /**
     * Loudness setting to absolute value
     */
    MSP_SOUND_LOUDNESS = 7,
    /**
     * Loudness setting with relative steps. Modifies property MSP_SOUND_LOUDNESS
     */
    MSP_SOUND_LOUDNESS_RELATIVE = 8,
    /**
     * Balance setting to absolute value
     */
    MSP_SOUND_BALANCE = 9,
    /**
     * Balance setting with relative steps. Modifies property MSP_SOUND_BALANCE
     */
    MSP_SOUND_BALANCE_RELATIVE = 10,
    /**
     * Fader setting to absolute value
     */
    MSP_SOUND_FADER = 11,
    /**
     * Fader setting with relative steps. Modifies property MSP_SOUND_FADER
     */
    MSP_SOUND_FADER_RELATIVE = 12,
    /**
     * Dynamic compression. Possible values defined as AM_MSP_DYN_COMPRESSION_*
     */
    MSP_SOUND_DYN_COMPRESSION = 13,
    /**
     * Equalizer Presets. Possible values defined as AM_MSP_EQU_PRESET_*
     */
    MSP_EQUALIZER_PRESET = 14,
    /**
     * Speed dependent volume: Possible values defined as AM_MSP_SDV_*
     */
    MSP_SPEED_DEPENDENT_VOLUME = 15,
    /**
     * Microphone connection status. Possible values defined as
     */
    MSP_MIC_STATUS_CONNECTION = 16,
    /**
     * Microphone level. Possible values defined as
     */
    MSP_MIC_STATUS_LEVEL = 17,
    /**
     * Sound optimization. Possible values defined as AM_MSP_SND_OPTI_*
     */
    MSP_SOUND_OPTIMIZATION = 18,
    /**
     * Room effect. Possible values defined as
     */
    MSP_SOUND_ROOM_EFFECT = 19,
    /**
     * Aux In level. Possible values defined as AM_MSP_LVL_AUX_IN_*
     */
    MSP_LEVEL_AUX_IN = 20,
    /**
     * Beep level. Possible values defined as
     */
    MSP_LEVEL_BEEP = 21,
    /**
     * Center speaker level. Possible values defined as
     */
    MSP_LEVEL_CENTER = 22,
    /**
     * Subwoofer level. Possible values defined as
     */
    MSP_LEVEL_SUBWOOFER = 23,
    /**
     * Surround Setting. Possible values defined as
     */
    MSP_SETTING_SURROUND = 24,
    /**
     * Audio Mode
     */
    MSP_MODE_AUDIO = 25,
    MSP_MAX
  };

#endif

void audmgr_clienthandler::MainSinkSoundPropertyChanged( uint16_t& sinkID,  generic_container< int16_t, int16_t >& SoundProperty)
{
  //1. Sink ID
  cout<<"Sink ID "<<sinkID<<endl;

  //2. Sound Property Type
  cout<<"Property Type: "<<SoundProperty.first<<" : ";
  //Examples only ... to be changed later...
  switch(SoundProperty.first)
  {
  case 1: cout<<" MSP_SOUND_BASS";break;
  case 2: cout<<" MSP_SOUND_BASS_RELATIVE";break;
  case 3: cout<<" MSP_SOUND_MIDDLE";break;
  case 4: cout<<" MSP_SOUND_MIDDLE_RELATIVE";break;
  case 5: cout<<" MSP_SOUND_TREBLE";break;
  case 6: cout<<" MSP_SOUND_TREBLE_RELATIVE";break;
  case 7: cout<<" MSP_SOUND_LOUDNESS";break;
  case 8: cout<<" MSP_SOUND_LOUDNESS_RELATIVE";break;
  case 9: cout<<" MSP_SOUND_BALANCE";break;
  case 10: cout<<" MSP_SOUND_BALANCE_RELATIVE";break;
  case 11: cout<<" MSP_SOUND_FADER";break;
  case 12: cout<<" MSP_SOUND_FADER_RELATIVE";break;
  case 13: cout<<" MSP_SOUND_DYN_COMPRESSION";break;
  case 14: cout<<" MSP_EQUALIZER_PRESET";break;
  case 15: cout<<" MSP_SPEED_DEPENDENT_VOLUME";break;
  case 16: cout<<" MSP_MIC_STATUS_CONNECTION";break;
  case 17: cout<<" MSP_MIC_STATUS_LEVEL";break;
  case 18: cout<<" MSP_SOUND_OPTIMIZATION";break;
  case 19: cout<<" MSP_SOUND_ROOM_EFFECT";break;
  case 20: cout<<" MSP_LEVEL_AUX_IN";break;
  case 21: cout<<" MSP_LEVEL_BEEP";break;
  case 22: cout<<" MSP_LEVEL_CENTER";break;
  case 23: cout<<" MSP_LEVEL_SUBWOOFER";break;
  case 24: cout<<" MSP_SETTING_SURROUND";break;
  case 25: cout<<" MSP_MODE_AUDIO";break;
  default:cout<<" MSP_UNKNOWN";break;
  }
  cout<<endl;

  //3. Actual Vaule
  cout << "Actual Vaule "<< SoundProperty.second<<endl;
}

void audmgr_clienthandler::MainSourceSoundPropertyChanged( uint16_t& sourceID,  generic_container< int16_t, int16_t >& SoundProperty)
{
  //1. Source ID
  cout<<"Source ID "<<sourceID;

  //2. Sound Property Type
  cout<<"Property Type: "<<SoundProperty.first<<" : ";
  //Examples only ... to be changed later...
  switch(SoundProperty.first)
  {
  case 1: cout<<" MSP_EXAMPLE_TREBLE";break;
  case 2: cout<<" MSP_EXAMPLE_MID";break;
  case 3: cout<<" MSP_EXAMPLE_BASS";break;
  default:cout<<" MSP_UNKNOWN";break;
  }
  cout<<endl;

  //3. Actual Vaule
  cout << "Actual Vaule "<< SoundProperty.second<<endl;

}
void audmgr_clienthandler::SinkAvailabilityChanged( uint16_t& sinkID,  generic_container< int16_t, int16_t >& availability)
{


  //1. Sink ID
  cout<<"Sink ID "<<sinkID<<endl;

  /* Availability */
  //2. Current Availability State
  cout<< "Current Availability State "<< availability.first <<" : ";

  switch(availability.first)
  {
  case 1 : cout<<"A_AVAILABLE"; break;//The source / sink is available
  case 2 : cout<<"A_UNAVAILABLE";break;//The source / sink is not available
  default: cout<<"A_UNKNOWN";break;// Unknown
  }
  cout<<endl;

  //3. Current Availability Reason
  cout<< "Current Availability Reason "<< availability.second <<" : ";
  switch(availability.second)
  {
  case 1: cout<<"AR_GENIVI_NEWMEDIA"; break;//availability changed because an new media was entered
  case 2: cout<<"AR_GENIVI_SAMEMEDIA"; break;//availability changed because the same media was entered
  case 3: cout<<"AR_GENIVI_NOMEDIA"; break;//availability changed because there is no media
  case 4: cout<<"AR_GENIVI_TEMPERATURE"; break;//availability changed because of a temperature event
  case 5: cout<<"AR_GENIVI_VOLTAGE"; break;//availability changed because of a voltage event
  case 6: cout<<"AR_GENIVI_ERRORMEDIA"; break;//availability changed because of fatal errors reading or accessing media
  default: cout<<"AR_UNKNOWN"; break;
  }
  cout<<endl;
}

void audmgr_clienthandler::SourceAvailabilityChanged( uint16_t& sourceID,  generic_container< int16_t, int16_t >& availability)
{
  //1. Source ID
  cout<<"Source ID "<<sourceID<<endl;

  /* Availability */
  //2. Current Availability State
  cout<< "Current Availability State "<< availability.first <<" : ";

  switch(availability.first)
  {
  case 1 : cout<<"A_AVAILABLE"; break;//The source / sink is available
  case 2 : cout<<"A_UNAVAILABLE";break;//The source / sink is not available
  default: cout<<"A_UNKNOWN";break;// Unknown
  }
  cout<<endl;

  //3. Current Availability Reason
  cout<< "Current Availability Reason "<< availability.second <<" : ";
  switch(availability.second)
  {
  case 1: cout<<"AR_GENIVI_NEWMEDIA"; break;//availability changed because an new media was entered
  case 2: cout<<"AR_GENIVI_SAMEMEDIA"; break;//availability changed because the same media was entered
  case 3: cout<<"AR_GENIVI_NOMEDIA"; break;//availability changed because there is no media
  case 4: cout<<"AR_GENIVI_TEMPERATURE"; break;//availability changed because of a temperature event
  case 5: cout<<"AR_GENIVI_VOLTAGE"; break;//availability changed because of a voltage event
  case 6: cout<<"AR_GENIVI_ERRORMEDIA"; break;//availability changed because of fatal errors reading or accessing media
  default: cout<<"AR_UNKNOWN"; break;
  }
  cout<<endl;

}
void audmgr_clienthandler::VolumeChanged(uint16_t& sinkID, int16_t& volume)
{
  //1. Sink ID
  cout<<"Sink ID "<< sinkID<<" : ";

  //2. Volume
  cout<<"Current Volume "<<volume<<endl;
}
void audmgr_clienthandler::SinkMuteStateChanged(uint16_t& sinkID, int16_t& muteState)
{
  //1. Sink ID
  cout<<"Sink ID "<< sinkID<<" : ";

  //2. Mute State
  cout<< "Mute State "<< muteState<<" : ";
  switch(muteState)
  {
  case 1: cout<<"MS_MUTED";break; //Sink State Muted
  case 2: cout<<"MS_UNMUTED";break; //Sink State Unmuted
  default: cout<<"MS_UNKNOWN";break;//Sink Mute state Unknown
  }
  cout<<endl;
}
#if 0
struct am_SystemProperty_s
{

public:
  /**
   * the type that is set
   */
  am_SystemPropertyType_e type;
  /**
   * the value
   */
  int16_t value;

};

/**
 * describes the different system properties. Project specific
 */
  enum am_SystemPropertyType_e
  {
    /**
     * default
     */
    SYP_UNKNOWN = 0,
    /**
     * Beep. Different beeps can be started with this
     */
    SYP_BEEP = 1,
    /**
     * Fader status active
     */
    SYP_FADER_STATUS_ACTIVE = 2,
    /**
     * Volume mode for main1 stream
     */
    SYP_VOLMODE_STREAM_MAIN_1 = 3,
    /**
     * Volume mode for Mix1 stream
     */
    SYP_VOLMODE_STREAM_MIX_1 = 4,
    SYP_MAX
  };
#endif

void audmgr_clienthandler::SystemPropertyChanged(generic_container< int16_t, int16_t >& SystemProperty)
{
  //1. Property Type
  cout<<"System Property Type"<<SystemProperty.first<<":";
  switch(SystemProperty.first)
  {
  case 1: cout<<"SYP_BEEP"; break;
  case 2: cout<<"SYP_FADER_STATUS_ACTIVE"; break;
  case 3: cout<<"SYP_VOLMODE_STREAM_MAIN_1"; break;
  case 4: cout<<"SYP_VOLMODE_STREAM_MIX_1"; break;
  default:cout<<"SYP_UNKNOWN"; break;
  }
  //2. Property Value
  cout<<",Current Value "<<SystemProperty.second<<endl;
}

void audmgr_clienthandler::TimingInformationChanged(uint16_t& mainConnection, int16_t& u16Time)
{
  //1. Connection ID for which Timing Information has changed
  cout<<"Connection ID "<<mainConnection<<endl;

  //2. Offset time being used for the connection
  cout<<"Offset (in ms) "<< u16Time<<endl;
}

