/*
 * clienthandle_audiomanager.h
 *
 *  Created on: Oct 21, 2011
 *      Author: ranjit
 */

#ifndef DEMONSTRATOR_H_
#define DEMONSTRATOR_H_

#include "g3g_dbus.h"
#include "audmgr_proxy.h"

class audmgr_clienthandler
: public audmgrproxy
{
public:

  audmgr_clienthandler(g3g_dbusconnection* rfConnection,const char* sNodeName, const char* sObjectPath, const char* sInterfaceName);
  //No need to override any methods as they are handled in the base class

  //Signals here
    virtual void NumberOfMainConnectionsChanged();
    virtual void SinkAdded(generic_container<uint16_t,std::string,generic_container<int16_t,int16_t>,int16_t,int16_t,uint16_t>& newSink);
    virtual void SinkRemoved(uint16_t& removedSinkID);
    virtual void SourceAdded(generic_container<uint16_t,std::string,generic_container<int16_t,int16_t>,uint16_t>& newSource);
    virtual void SourceRemoved(uint16_t& removedSourceID);
    virtual void NumberOfSinkClassesChanged();
    virtual void NumberOfSourceClassesChanged();

    //VVD
    virtual void NewMainConnection(generic_container<dbus_uint16_t ,dbus_uint16_t ,dbus_uint16_t ,dbus_int16_t ,dbus_int16_t>& NewMainConnection);
    virtual void RemovedMainConnection(uint16_t& connectionID);

    virtual void MainConnectionStateChanged(uint16_t& connectionID, int16_t& connectionState);
    virtual void MainSinkSoundPropertyChanged(uint16_t& sinkID, generic_container<int16_t,int16_t>& SoundProperty);
    virtual void MainSourceSoundPropertyChanged(uint16_t& sourceID, generic_container<int16_t,int16_t>& SoundProperty);
    virtual void SinkAvailabilityChanged(uint16_t& sinkID, generic_container<int16_t,int16_t>& availability);
    virtual void SourceAvailabilityChanged(uint16_t& sourceID, generic_container<int16_t,int16_t>& availability);
    virtual void VolumeChanged(uint16_t& sinkID,int16_t& volume);
    virtual void SinkMuteStateChanged(uint16_t& sinkID,int16_t& muteState);
    virtual void SystemPropertyChanged(generic_container<int16_t,int16_t>& availability);
    virtual void TimingInformationChanged(uint16_t& mainConnection,int16_t& time);
};


#endif /* DEMONSTRATOR_H_ */
