/************************************************************************
 *FILE:           amcontrol_clienthandler_LCM.cpp
 *SW-COMPONENT:   AmControllerPlugin
 *DESCRIPTION:    ClientHandler for LCM
 *AUTHOR:         Parusharam J (RBEI/ECV3) <Parusharam.J@in.bosch.com>
 *COPYRIGHT:      RBEI
 *HISTORY:
 *08.10.2015      Rev 1.0     Parusharam J (RBEI/ECV3)  Initial Revision
 ************************************************************************/

#include "include/audiomanagertypes.h"

/* Include message framework (AMT, msgfw) */
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_TYPES
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_SERVICEINFO
#include "spm_fi_if.h"

#include "amcontrol_clienthandler_LCM.h"
#include "CAmControlSenderBase.h"
//#include "CAmDltWrapper.h"

#include "controllerplugin_Trace.h"
#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include <etrace_if.h>
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AMCONTROLLERPLUGIN
#include "trcGenProj/Header/amcontrol_clienthandler_LCM.cpp.trc.h"
#endif

#include "AudioStack/clGeniviAudioCtrlAdapter.h"
using namespace AudioStack;

/************************************************************************
* FUNCTION     : amcontrol_clienthandler_LCM
* DESCRIPTION  : Contructor
* PARAMETER    : CAmControlSenderBase&, am::IAmControlReceiverShadow&, am::IAmControlReceive&
* RETURNVALUE  : void
* HISTORY      : 08.10.2015 Parusharam J  Initial Revision.
************************************************************************/
amcontrol_clienthandler_LCM::amcontrol_clienthandler_LCM(CAmControlSenderBase& controlSenderBase,
		am::IAmControlReceiverShadow& receiverShadow,
		am::IAmControlReceive& controlReceive)
   : CThreadSwitchingClient(SPM_COREFI_C_U16_SERVICE_ID, SPM_COREFI_C_SERVICE_VERSION_1_1, receiverShadow)
   , m_ControlSenderBase(controlSenderBase)
   , m_ControlReceive(controlReceive)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_LCM::Entered in constructor amcontrol_clienthandler_LCM()"));
}

/************************************************************************
* FUNCTION     : ~amcontrol_clienthandler_LCM
* DESCRIPTION  : Destructor
* PARAMETER    : void
* RETURNVALUE  : void
* HISTORY      : 08.10.2015 Parusharam J  Initial Revision.
************************************************************************/
amcontrol_clienthandler_LCM::~amcontrol_clienthandler_LCM()
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_LCM::Entered in destructor amcontrol_clienthandler_LCM()"));
}

/************************************************************************
* FUNCTION     : vOnServiceAvailable
* DESCRIPTION  : Get called when service becomes available
* PARAMETER    : void
* RETURNVALUE  : void
* HISTORY      : 08.10.2015 Parusharam J  Initial Revision.
************************************************************************/
void amcontrol_clienthandler_LCM::vOnServiceAvailable()
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_LCM:: vOnServiceAvailable() entered ... "));
}

/************************************************************************
* FUNCTION     : vOnServiceUnavailable
* DESCRIPTION  : Get called when service becomes unavailable
* PARAMETER    : void
* RETURNVALUE  : void
* HISTORY      : 08.10.2015 Parusharam J  Initial Revision.
************************************************************************/
void amcontrol_clienthandler_LCM::vOnServiceUnavailable()
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_LCM:: vOnServiceUnavailable() entered ... "));
}

/************************************************************************
* FUNCTION     : vDispatchMessage
* DESCRIPTION  : Dispatches message
* PARAMETER    : FIMessaging::FIMessage
* RETURNVALUE  : void
* HISTORY      : 08.10.2015 Parusharam J  Initial Revision.
************************************************************************/
void amcontrol_clienthandler_LCM::vDispatchMessage(FIMessaging::FIMessage oMsg)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_LCM:: vDispatchMessage() entered ... "));
  ETG_TRACE_USR4(("vDispatchMessage(): FIMessage for Function %x.%x.%u received"
              , oMsg.u16ServiceID, oMsg.u16FunctionID, oMsg.u8OpCode))

   bool bSuccess = false;
   switch (oMsg.u8OpCode)
   {
      case CCA_C_U8_OPCODE_STATUS:
         bSuccess = bHandleStatus(oMsg);
         break;

      case CCA_C_U8_OPCODE_ERROR:
         bSuccess = bHandleError(oMsg);
         break;

      default:
         break;
   }

   if ( ! bSuccess)
      ETG_TRACE_ERR(("vDispatchMessage() - E R R O R :  unhandled FIMessage for Function %x.%x.%u received"
              , oMsg.u16ServiceID, oMsg.u16FunctionID, oMsg.u8OpCode))
}

/************************************************************************
* FUNCTION     : vRegisterForProperties
* DESCRIPTION  : Register for LCM properties to get the status
* PARAMETER    : void
* RETURNVALUE  : void
* HISTORY      : 08.10.2015 Parusharam J  Initial Revision.
************************************************************************/
void amcontrol_clienthandler_LCM::vRegisterForProperties()
{
   ETG_TRACE_USR4(("amcontrol_clienthandler_LCM::vRegisterForProperties entered"));

   // send UpReg message for LCM audio state
   FIMessaging::FunctionInfo info(GetServiceInfo(), SPM_COREFI_C_U16_AUDIOSTATE, FIMessaging::enUpreg);
   FIMessaging::fi_tclEmptyMsg oUpreg(info);
   if (m_pSender)
      (void) m_pSender->u16PostFICommand(oUpreg);
}

/************************************************************************
* FUNCTION     : GetAutoRegisterList
* DESCRIPTION  : auto registry for LCM propeties
* PARAMETER    : void
* RETURNVALUE  : FIMessaging::ITarget::AutoRegisterList
* HISTORY      : 08.10.2015 Parusharam J  Initial Revision.
************************************************************************/
FIMessaging::ITarget::AutoRegisterList amcontrol_clienthandler_LCM::GetAutoRegisterList ()
{
   // disclose list of properties which should be UpReg'ed automatically
   static tU16 u16PropertyIDs[]
    = {
//        MIDW_AUDIO_ROUTE_MGRFI_C_U16_P_SOURCEROUTEACTIVITY
//      , MIDW_AUDIO_ROUTE_MGRFI_C_U16_SOURCEAVAILABILITY
    };

   return AutoRegisterList(u16PropertyIDs, sizeof(u16PropertyIDs) / sizeof(u16PropertyIDs[0]));
}

/************************************************************************
* FUNCTION     : bHandleStatus
* DESCRIPTION  : Handler for audio state property status.
* PARAMETER    : FIMessaging::FIMessage&
* RETURNVALUE  : bool
* HISTORY      : 08.10.2015 Parusharam J  Initial Revision.
************************************************************************/
bool amcontrol_clienthandler_LCM:: bHandleStatus (const FIMessaging::FIMessage& oMsg)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_LCM::bHandleStatus entered"));
   switch (oMsg.u16FunctionID)
   {
      case SPM_COREFI_C_U16_AUDIOSTATE   : return bGetAudioStateLCMStatus(oMsg);

      default                                                   : return false;
   }
}


/************************************************************************
* FUNCTION     : bHandleError
* DESCRIPTION  : Handler for audio state property error.
* PARAMETER    : FIMessaging::FIMessage&
* RETURNVALUE  : bool
* HISTORY      : 08.10.2015 Parusharam J  Initial Revision.
************************************************************************/
bool amcontrol_clienthandler_LCM:: bHandleError (const FIMessaging::FIMessage& oMsg)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_LCM::bHandleError entered"));
   switch (oMsg.u16FunctionID)
   {
      case SPM_COREFI_C_U16_AUDIOSTATE   : return bGetAudioStateLCMError(oMsg);

      default                                                   : return false;
   }
}

/************************************************************************
* FUNCTION     : vGetAudioStateStatus
* DESCRIPTION  : Gets the audio state status from LCM based on system state
* PARAMETER    : FIMessaging::FIMessage&
* RETURNVALUE  : bool
* HISTORY      : 08.10.2015 Parusharam J  Initial Revision.
************************************************************************/
bool amcontrol_clienthandler_LCM::bGetAudioStateLCMStatus(const FIMessaging::FIMessage& oMsg)
{
   ETG_TRACE_USR4(("amcontrol_clienthandler_LCM::bGetAudioStateLCMStatus entered"));

   //Get the data using Helper function
   spm_corefi_tclMsgAudioStateStatus oStatus;
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
     ETG_TRACE_ERR(("vGetAudioStateStatus() . E R R O R :  failed reading AudioStateStatus.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
     return false;
   }
   clGeniviAudioCtrlAdapter::vAudioStateLCMStatus(oStatus);
   return true;
}

/************************************************************************
* FUNCTION     : bGetAudioStateLCMError
* DESCRIPTION  : Gets the audio state error from LCM
* PARAMETER    : FIMessaging::FIMessage&
* RETURNVALUE  : bool
* HISTORY      : 08.10.2015 Parusharam J  Initial Revision.
************************************************************************/
bool amcontrol_clienthandler_LCM::bGetAudioStateLCMError(const FIMessaging::FIMessage& oMsg)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_LCM::bGetAudioStateLCMError entered"));
   FIMessaging::FunctionInfo info(GetServiceInfo(), SPM_COREFI_C_U16_AUDIOSTATE, FIMessaging::enError);
   FIMessaging::fi_tclErrorMsg oError(info);

   if ( ! oMsg.bPopulateFIData(oError))
   {
     ETG_TRACE_ERR(("bOnSourceAvailabilityStatus() . E R R O R :  failed reading SourceRouteActivity.Error from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
     return false;
   }
   return true;
}


