/************************************************************************
 *FILE:           amcontrol_clienthandler_DiagLog.cpp
 *SW-COMPONENT:   AmControllerPlugin
 *DESCRIPTION:    ClientHandler for Diaglog
 *AUTHOR:         Swati N
 *COPYRIGHT:      RBEI
 *HISTORY:
 *27.06.2019      Rev 1.0   ssw3kor
 ************************************************************************/

#include "include/audiomanagertypes.h"

/* Include Diagnostics FI interface */
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_SERVICEINFO
#include <midw_fi_if.h>

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"

#include "amcontrol_clienthandler_DiagLog.h"
#include "CAmControlSenderBase.h"
#include "controllerplugin_Trace.h"
#include "AudioStack/clGeniviAudioCtrlAdapter.h"

#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include <etrace_if.h>
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AMCONTROLLERPLUGIN
#include "trcGenProj/Header/amcontrol_clienthandler_DiagLog.cpp.trc.h"
#endif

#define DTC_TIMER 120
using namespace AudioStack;


/************************************************************************
* FUNCTION     : amcontrol_clienthandler_DiagLog
* DESCRIPTION  : Contructor
* PARAMETER    : CAmControlSenderBase&, am::IAmControlReceiverShadow&, am::IAmControlReceive&
* RETURNVALUE  : void
************************************************************************/
amcontrol_clienthandler_DiagLog::amcontrol_clienthandler_DiagLog(CAmControlSenderBase& controlSenderBase,
		am::IAmControlReceiverShadow& receiverShadow,
		am::IAmControlReceive& controlReceive)
   :CThreadSwitchingClient(MIDW_DIAGLOGFI_C_U16_SERVICE_ID, MIDW_DIAGLOGFI_C_SERVICE_VERSION_1_6, receiverShadow)
   , m_ControlSenderBase(controlSenderBase)
   , m_receiverShadow(receiverShadow)
   , m_ControlReceive(controlReceive)
{
  m_handle = 0 ;
  eResult = EN_ERROR ;
  // start 2 min timer to wait for AMP availability
  bStartTimer(DTC_TIMER);
  bAvailiable = false ;
  ETG_TRACE_USR4(("amcontrol_clienthandler_DiagLog::Entered in constructor amcontrol_clienthandler_DiagLog()"));
}

/************************************************************************
* FUNCTION     : ~amcontrol_clienthandler_DiagLog
* DESCRIPTION  : Destructor
* PARAMETER    : void
* RETURNVALUE  : void
* HISTORY      : 27.06.2019 Swati A N(RBEI/ECO4)  Initial Revision
************************************************************************/
amcontrol_clienthandler_DiagLog::~amcontrol_clienthandler_DiagLog()
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_DiagLog::Entered in destructor amcontrol_clienthandler_DiagLog()"));
}

/************************************************************************
* FUNCTION     : vOnServiceAvailable
* DESCRIPTION  : Get called when service becomes available
* PARAMETER    : void
* RETURNVALUE  : void
* HISTORY      : 27.06.2019 Swati A N(RBEI/ECO4)  Initial Revision
************************************************************************/
void amcontrol_clienthandler_DiagLog::vOnServiceAvailable()
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_DiagLog:: vOnServiceAvailable() entered ... "));
  bAvailiable = true;
  bSetDTC(eResult);

}

/************************************************************************
* FUNCTION     : vOnServiceUnavailable
* DESCRIPTION  : Get called when service becomes unavailable
* PARAMETER    : void
* RETURNVALUE  : void
* HISTORY      : 27.06.2019 Swati A N(RBEI/ECO4)  Initial Revision
************************************************************************/
void amcontrol_clienthandler_DiagLog::vOnServiceUnavailable()
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_DiagLog:: vOnServiceUnavailable() entered ... "));
  bAvailiable = false;
}

/************************************************************************
* FUNCTION     : vRegisterForProperties
* DESCRIPTION  : Register for Diaglog property
* PARAMETER    : void
* RETURNVALUE  : void
* HISTORY      : 27.06.2019 Swati A N(RBEI/ECO4)  Initial Revision
************************************************************************/
void amcontrol_clienthandler_DiagLog::vRegisterForProperties()
{
   ETG_TRACE_USR4(("amcontrol_clienthandler_DiagLog::vRegisterForProperties entered"));

   // send UpReg message for diaglog
   FIMessaging::FunctionInfo info(GetServiceInfo(), MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT, FIMessaging::enUpreg);
   FIMessaging::fi_tclEmptyMsg oUpreg(info);
   if (m_pSender)
      (void) m_pSender->u16PostFICommand(oUpreg);
}

/************************************************************************
* FUNCTION     : GetAutoRegisterList
* DESCRIPTION  : auto registry for Diaglog propeties
* PARAMETER    : void
* RETURNVALUE  : FIMessaging::ITarget::AutoRegisterList
* HISTORY      : 27.06.2019 Swati A N(RBEI/ECO4)  Initial Revision
************************************************************************/
FIMessaging::ITarget::AutoRegisterList amcontrol_clienthandler_DiagLog::GetAutoRegisterList ()
{
   ETG_TRACE_USR4(("amcontrol_clienthandler_DiagLog::GetAutoRegisterList entered"));
   static tU16 u16PropertyIDs[]
    = {
    };

   return AutoRegisterList(u16PropertyIDs, sizeof(u16PropertyIDs) / sizeof(u16PropertyIDs[0]));
}

/************************************************************************
* FUNCTION     : vDispatchMessage
* DESCRIPTION  : callback function invoked from Genivi deamon main thread
* PARAMETER    : FIMessaging::FIMessage&
* RETURNVALUE  : bool
* HISTORY      : 27.06.2019 Swati A N(RBEI/ECO4)  Initial Revision
************************************************************************/
void amcontrol_clienthandler_DiagLog::vDispatchMessage (FIMessaging::FIMessage oMsg)
{
   ETG_TRACE_USR1(("amcontrol_clienthandler_DiagLog::vDispatchMessage(): FIMessage for Function %x.%x.%u received"
              , oMsg.u16ServiceID, oMsg.u16FunctionID, oMsg.u8OpCode))

   //bool bSuccess = false;
   switch (oMsg.u8OpCode)
   {
      case CCA_C_U8_OPCODE_STATUS:
         ETG_TRACE_USR4(("CCA_C_U8_OPCODE_STATUS"));
         break;

      case CCA_C_U8_OPCODE_METHODRESULT:
     {
     ETG_TRACE_USR4(("CCA_C_U8_OPCODE_METHODRESULT"));
           midw_diaglogfi_tclMsgSaveTestResultMethodResult oResult;
     if ( ! oMsg.bPopulateFIData(oResult))
      ETG_TRACE_ERR(("CCA_C_U8_OPCODE_METHODRESULT message is invalid"));
     if (midw_fi_tcl_e8_MethodResultReply::FI_EN_REJECTED == oResult.Status.enType)
     {
        ETG_TRACE_ERR(("CCA_C_U8_OPCODE_METHODRESULT REJECTED"));
     }
     }
         break;

      case CCA_C_U8_OPCODE_ERROR:
         ETG_TRACE_USR4(("CCA_C_U8_OPCODE_ERROR"));
         break;

      case CCA_C_U8_OPCODE_ABORTRESULT:
      default:
         break;
   }
}

/************************************************************************
* FUNCTION     : bGetAudioStateLCMError
* DESCRIPTION  : Send test result to Diaglog
* PARAMETER    : Amp avail
* RETURNVALUE  : bool
* HISTORY      : 27.06.2019 Swati A N(RBEI/ECO4)  Initial Revision
************************************************************************/
bool amcontrol_clienthandler_DiagLog::bSetDTC(tU32 enResult)
{
	static bool bSent = false ;
	if(enResult == EN_ERROR)
		return false;
	ETG_TRACE_USR4(("amcontrol_clienthandler_DiagLog::bSetDiagResult DTC: %d ",enResult));
	m_pSocketHandler = m_receiverShadow.mpCAmSocketHandler;

	if(m_pSocketHandler && m_handle)
	{
		am_Error_e ret = m_pSocketHandler->removeTimer(m_handle);
		if(ret!=E_OK)
		{
			ETG_TRACE_ERR(("m_pSocketHandler->removeTimer(m_handle) failed with err %d",ret));
		}
		m_handle = 0;
	}
	eResult = enResult;
	midw_diaglogfi_tclMsgSaveTestResultMethodStart oFiData;
	midw_fi_tcl_TestResult oEntry;
#if defined ITC_CMC_AMPLIFIER_INIT_FAILED
	oEntry.TroubleCode = ITC_CMC_AMPLIFIER_INIT_FAILED;
	oEntry.Result.enType = (midw_fi_tcl_e8_TestResult::tenType)eResult;
	oFiData.TestResultList.TestResultList.push_back(oEntry);
	if (m_pSender && bAvailiable && bSent==false)
	{
		(void) m_pSender->u16PostFICommand(oFiData);
		bSent = true;
	}
#endif
return bSent;
}

/************************************************************************
* FUNCTION     : bStartTimer
* DESCRIPTION  : start 2min timer to see the availability of amplifier
* PARAMETER    : Amp avail
* RETURNVALUE  : bool
* HISTORY      : 27.06.2019 Swati A N(RBEI/ECO4)  Initial Revision
************************************************************************/
bool amcontrol_clienthandler_DiagLog::bStartTimer(uint32_t sec)
{
  timespec start;
  start.tv_sec = sec;
  start.tv_nsec = 0;
  m_handle = 0;

  m_pSocketHandler = m_receiverShadow.mpCAmSocketHandler;
  if(m_pSocketHandler != NULL)
  {
    if(E_OK == m_pSocketHandler->addTimer(start, this, m_handle,NULL))
    {
      ETG_TRACE_USR4(("Timer (%ds) started, p=%x, timer handle=%d",sec, (void*)this, m_handle));
      return true;
    }
    else
    {
      ETG_TRACE_ERR(("Timer could not be added for p=%x",(void*)this));
    }
  }
  else
  {
    ETG_TRACE_ERR(("Pointer to socket handler is NULL"));
  }
  return false;
}
/************************************************************************
* FUNCTION     : call
* DESCRIPTION  : This function is going to be our timer callback
* PARAMETER    :
* RETURNVALUE  : bool
* HISTORY      : 27.06.2019 Swati A N(RBEI/ECO4)  Initial Revision
************************************************************************/
void amcontrol_clienthandler_DiagLog::Call(const am::sh_timerHandle_t handle, void* )
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_DiagLog::Call timer expired,p=%x, handle=%d",(void*)this,handle));
  m_handle = 0;
  bSetDTC(EN_PASSED);
}

