/*
 * clGeniviAudioCtrlAdapter.cpp
 *
 *  Created on: Jul 25, 2013
 *      Author: vo84hi
 */
#include "audiomanagertypes.h"

#include "AudioStack/InterfaceAudioStack.h"

//#include "fc_audiomanager_service_Audio_Stub.h"
//daw2hi 23.05.2018 new path
//#include "../../GAMVolumeManager/VolumeManager/fc_audiomanager_service_Audio_Stub.h"

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "../../GAMVolumeManager/VolumeManager/Volume/VolumeManager.h"
#include "../../GAMVolumeManager/VolumeManager/fc_audiomanager_service_Audio_Stub.h"
#else
#include "../../utest/mock/include/Volume/VolumeManager.h"
#include "../../utest/mock/include/Volume/fc_audiomanager_service_Audio_Stub.h"
#endif

//#include "../config/dp/AudioUserDpIf.h"

#include "../../config/dp/AudioUserDpIfSelect.h"
#include<string>
//#define DP_DATAPOOL_ID =0xE880
#define DP_S_IMPORT_INTERFACE_FI
//#include "dp_if.h"

#ifndef VARIANT_S_FTR_ENABLE_AUDIO_STACK_UTEST
#include "dp_e880_if.h"
#else
#include "dp_e880_mock_if.h"
#endif

#include "AudioStack/clGeniviAudioCtrlAdapter.h"

#include "AudioStack/AudioSources/clAudioSourceController.h"
#include "amcontrol_clienthandler_fc_audiomanager.h"
#include "amcontrol_clienthandler_fc_audioroutemanager.h"
#include "AudioStack/AudioSources/clAudioSourceFactory.h"
#include "AudioStack/AudioSources/clFactory_AudioSourceClass.h"
#include "AudioStack/SMT/clSrcStateFactory.h"
#include "AudioStack/clInputHelper.h"
//#include "AudioStack/clXMLLoader.h".
#include "CAmControlSenderBase.h"
#include <sstream>
//use for XML Ruleset loading
//#include <string.h>
#include <algorithm>

using namespace std;

#include <stdio.h>
//#include <malloc.h>

#define PRIVATE_MODE_1 1
#define PRIVATE_MODE_2 2
#define PRIVATE_MODE_3 3


#ifndef USE_DLT_TRACE
#define ETG_I_TTFIS_CMD_PREFIX "AudioStack_"
#define ETG_I_TRACE_CHANNEL TR_TTFIS_AUDIOSTACK
#define ETG_DEFAULT_TRACE_CLASS TR_COMP_AUDIOSTACK
#include "trcGenProj/Header/clGeniviAudioCtrlAdapter.cpp.trc.h"
#endif


#define G3G_NUMBER_SOURCE_SND_PROPERTY 2
#define G3G_DEFAULT_SND_PROPERTY_VALUE 0
uint8_t g_u8SrcSoundPropertiesId[G3G_NUMBER_SOURCE_SND_PROPERTY]={
        MSP_MIC_STATUS_CONNECTION,MSP_MIC_STATUS_LEVEL
};

namespace AudioStack
{

using namespace SourceStateMachine;
using namespace AudioSource;
using namespace am;

// check if also O.K. for real build
//#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
//using namespace VolumeManager;
//#endif

std::vector<mainConnectionEntry_s> clGeniviAudioCtrlAdapter::m_mainConnectionEntries;

std::vector<am_Route_s> clGeniviAudioCtrlAdapter::m_Routes;


std::map<am_sourceID_t, SourceID >            clGeniviAudioCtrlAdapter::m_registeredSources;
std::map<am_sinkID_t, am_Sink_s>              clGeniviAudioCtrlAdapter::m_registeredSinks;
std::map<tU8, tS16>                           clGeniviAudioCtrlAdapter::m_AttenuationDBMAp;
std::map<unsigned int, struct sinkData>             clGeniviAudioCtrlAdapter::m_sinkList;
IAmControlReceive*                            clGeniviAudioCtrlAdapter::m_geniviControlIF            = NULL;
amcontrol_clienthandler_fc_audiomanager* clGeniviAudioCtrlAdapter::m_clientHandlerFcAudioMgr         = NULL;
amcontrol_clienthandler_fc_audioroutemanager* clGeniviAudioCtrlAdapter::m_clientHandlerAudioRouteMgr = NULL;
am_domainID_t                                 clGeniviAudioCtrlAdapter::m_domainID                   = 1;    //daw2hi 15.8.2018 changed from 0 to 2
CAmControlSenderBase*              clGeniviAudioCtrlAdapter::m_ControlSenderBase       = NULL;
tBool clGeniviAudioCtrlAdapter::m_bEnableAutoPlay = TRUE;
unsigned int clGeniviAudioCtrlAdapter::m_sinkIndex = 0;
tU16 clGeniviAudioCtrlAdapter::m_u16PrivateMode = 0;
tU16 clGeniviAudioCtrlAdapter::m_u16PrivateModeMixVolume = 0;

fc_audiomanager_tclService_Audio_Function_Stub audioService;

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
VolumeManager::VolumeManager aVolumeManager(audioService);
#else
VolumeManager::VolumeManager aVolumeManager(audioService);
#endif

VolumeManager::VolumeManager* clGeniviAudioCtrlAdapter::getVolumeManager()
{

    return &aVolumeManager;
}

//new method because only here we can access clientHandlerFcAudioMgr
void clGeniviAudioCtrlAdapter::sendVolumeSink17()
{
    if(m_clientHandlerFcAudioMgr)
    {
        m_clientHandlerFcAudioMgr->vSetVolume(midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_ABS,
                midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_LINE_OUT, (tU8)40);

    }
}

void clGeniviAudioCtrlAdapter::triggerPendingRequests()
{
    if(m_ControlSenderBase)
        m_ControlSenderBase->triggerPendingRequests(msgType::ConnectionRequest);
}

bool clGeniviAudioCtrlAdapter::getMapSinkNameSoundSink(std::map<std::string, tU16>& mapSinkNameSoundSink)
{
    std::vector<std::pair<am_sinkID_t, am_Sink_s>> sinkList;
    sinkList = clFactory_AudioSourceClass::GetSystemSinkList();
    for(unsigned int i=0;i<sinkList.size();i++)
    {
        mapSinkNameSoundSink[sinkList[i].second.name]=(tU16)i;
    }
    return true;
}

//register the gateway at the daemon
bool clGeniviAudioCtrlAdapter::registerGateway(const am_Gateway_s& gateway_s)
{

    ETG_TRACE_USR4(("clGateway:registerGateway %s",gateway_s.name.c_str()));
    ETG_TRACE_USR4(("clGateway:registerGateway sourceID %d",gateway_s.sourceID));
    ETG_TRACE_USR4(("clGateway:registerGateway sinkID %d",gateway_s.sinkID));

    am_gatewayID_t gatewayID=0;

    //if static ID
    if(gateway_s.gatewayID != 0)
        gatewayID = gateway_s.gatewayID;

    if(m_geniviControlIF != NULL)
    {
        ETG_TRACE_USR4(("register Gateway %s",gateway_s.name.c_str()));
        m_geniviControlIF->enterGatewayDB(gateway_s,gatewayID);
        ETG_TRACE_USR4(("registered with ID %d",gatewayID));

        //call one more time the restore, maybe for specific domain?
        ETG_TRACE_USR4(("after register Gateway -> vRestoreEntertainmentsource()"));
#if defined(VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_INF4CV ) || defined(VARIANT_S_FTR_ENABLE_UNITTEST)
        // daw2hi: smart ??
        clAudioSMEngine::vRestoreEntertainmentsource();
#endif 
    }
    return true;
}

tVoid clGeniviAudioCtrlAdapter::SetRunLevel(tU8 u8Level)
{
    clAudioSMEngine::SetRunlevel(u8Level);
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::SetRunLevel noww cll for setRoutingready"));
    vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_ControlSenderBase);
    m_ControlSenderBase->callSetRoutingReady();

}

tVoid clGeniviAudioCtrlAdapter::Invalidate()
{
    clAudioSMEngine::Invalidate();
    m_registeredSources.clear();
    m_registeredSinks.clear();
    m_sinkList.clear();
    m_geniviControlIF = NULL;

    m_ControlSenderBase = NULL;
    m_domainID = 0;

    m_mainConnectionEntries.clear();
}


am::am_Error_e clGeniviAudioCtrlAdapter::Init(CAmControlSenderBase* pSenderBase, IAmControlReceive * pGeniviCtrlIF,
        amcontrol_clienthandler_fc_audiomanager* clientHandlerFcAudioMgr,
        amcontrol_clienthandler_fc_audioroutemanager* clientHandlerAudioRouteMgr,bool bAMRoutingReady)
{
#ifndef USE_DLT_TRACE
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
    //ET_TRACE_OPEN;
    ETG_I_REGISTER_FILE();

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "SRC_ON %d %d"
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_SRC_ON)
            , tU16
            , tU16));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "SRC_OFF %d %d"
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_SRC_OFF)
            , tU16
            , tU16));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "SRC_SET_AVAILABLE %d %d"
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_SET_SRC_AVAILABLE)
            , tU16
            , tU16));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "SRC_SET_NOT_AVAILABLE %d %d"
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_SET_SRC_NOT_AVAILABLE)
            , tU16
            , tU16));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "SRC_SET_AVAILABLE_UNKNOWN %d %d"
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_SET_SRC_AVAILABLE_UNKOWN)
            , tU16
            , tU16));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "SET_RUNLVL %d "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_SET_RUNLEVEL)
            , tU16));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "GET_RUNLVL "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_GET_RUNLEVEL) ));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "RESET "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_RESET) ));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "PRINT "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_PRINT) ));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "LIST_SRCs "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_SRC_LIST) ));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "KILL_SRC %d %d "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_KILL_SRC)
            , tU16
            , tU16));
    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "PRINT_XML "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_PRINTXML) ));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "LOAD_XML "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_LOADXML) ));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "PRINT_RULES "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_PRINTRULES) ));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "CMD_REMOTE_START "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_REMOTESTART) ));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "CMD_REMOTE_END "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_REMOTEEND) ));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "PRINT_BACKUP "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_PRINT_BACKUP) ));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "LIST_MAINCON "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_LIST_MAINCON) ));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "LIST_ALLCON "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_LIST_ALLCON) ));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "PRINT_DB_SOURCE_DATA %d "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_DB_SOURCE_DATA)
            , tU16));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "PRINT_DB_SINK_DATA %d "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_DB_SINK_DATA)
            , tU16));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "LIST_ALL_DOMAINS "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_LIST_ALL_DOMAINS) ));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "LIST_ALL_SINKS "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_LIST_ALL_SINKS) ));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "LIST_ALL_SOURCES "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_LIST_ALL_SOURCES) ));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "INIT_DP_FM "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_INIT_DP_FM) ));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "SET_DP_FOR_SINK %d %d "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_SET_DP_FOR_SINK)
            , tU16, tU16));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "SET_DP_SUBID_FOR_SINK %d %d "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_SET_DP_SUBID_FOR_SINK)
            , tU16, tU16));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "CLEAR_DP_FOR_SINK %d "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_CLEAR_DP_FOR_SINK)
            , tU16));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "LIST_INTERNAL_CONNECTIONS "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_LIST_INTERNAL_CONNECTIONS) ));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "UNREGISTER_SINK_ADR_LINE_OUT "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_UNREGISTER_SINK_ADR_LINE_OUT) ));

    ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "REGISTER_SINK_ADR_LINE_OUT %d "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_REGISTER_SINK_ADR_LINE_OUT)
            , tU16));

    ETG_I_REGISTER_CHN(vTraceRxDefault);
#endif
#endif

    // add attenuation filter map
    m_AttenuationDBMAp.insert(std::make_pair(0, -480));
    m_AttenuationDBMAp.insert(std::make_pair(1, -80));
    m_AttenuationDBMAp.insert(std::make_pair(2, -56));
    m_AttenuationDBMAp.insert(std::make_pair(3, -40));
    m_AttenuationDBMAp.insert(std::make_pair(4, -32));
    m_AttenuationDBMAp.insert(std::make_pair(5, -24));
    m_AttenuationDBMAp.insert(std::make_pair(6, -18));
    m_AttenuationDBMAp.insert(std::make_pair(7, -12));
    m_AttenuationDBMAp.insert(std::make_pair(8, -8));
    m_AttenuationDBMAp.insert(std::make_pair(9, -4));
    m_AttenuationDBMAp.insert(std::make_pair(10, 0));

    if(pSenderBase == NULL)
    {
        ETG_TRACE_FATAL(("AUDIOSTACK INIT FAILED: pSenderBase == NULL"));
        return E_NOT_POSSIBLE;
    }

    //g_u8SrcSoundPropertiesId
    m_ControlSenderBase = pSenderBase;

    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::Init: domainID %d", m_domainID));
    if(pGeniviCtrlIF == NULL)
    {
        ETG_TRACE_FATAL(("AUDIOSTACK INIT FAILED: pGeniviCtrlIF == NULL"));
        return E_NOT_POSSIBLE;
    }
    AddGeniviCtrlIF(pGeniviCtrlIF);

    if(clientHandlerAudioRouteMgr == NULL)
    {
        ETG_TRACE_FATAL(("AUDIOSTACK INIT FAILED: clientHandlerAudioRouteMgr == NULL"));
        return E_NOT_POSSIBLE;
    }
    AddAudioRouteMgrIF(clientHandlerAudioRouteMgr);

    if(clientHandlerFcAudioMgr == NULL)
    {
        ETG_TRACE_FATAL(("AUDIOSTACK INIT FAILED: clientHandlerFcAudioMgr == NULL"));
        return E_NOT_POSSIBLE;
    }
    AddFcAudioMgrIF(clientHandlerFcAudioMgr);

    if(m_domainID)
    {
        //initializeSourceClasses(m_domainID);
#if !defined(VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_INF4CV ) && !defined(VARIANT_S_FTR_ENABLE_UNITTEST)
        if(bAMRoutingReady != true) // initialize sink for dbusarl called from routing
#endif
        {
            am_Error_e eCode =initializeSinks(m_domainID);
            if( eCode != E_OK)
            {
                ETG_TRACE_FATAL(("AUDIOSTACK SINK INITIALIZATION FAILED: ErrorCode %d", eCode));
                return E_NOT_POSSIBLE;
            }
        }
        if(clAudioSMEngine::SetRunlevel(3,TRUE) != clAudioSMEngine::AUDIOSM_OK)
        {
            ETG_TRACE_FATAL(("AUDIOSTACK FAILED TO SET RUNLEVEL !"));
            return E_NOT_POSSIBLE;
        }

    }else{
        ETG_TRACE_FATAL(("No Domain ID available: use clGeniviAudioCtrlAdapter::AddDomainID(...)"));
        return E_NOT_POSSIBLE;
    }

    return E_OK;
}


tVoid clGeniviAudioCtrlAdapter::vTraceRxDefault(tPCUChar pcu8Data){
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
    ETG_TRACE_FATAL(("vTraceRx() unknown trace command= %x" ,
            ETG_LIST_LEN((tU8)pcu8Data[0]), ETG_LIST_PTR_T8(&pcu8Data[1]) ));
#endif
}

tVoid clGeniviAudioCtrlAdapter::TTFisInput(tU8 cmd,tU16 value1,tU16 value2)
{
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::TTFisInput cmd %d value1 %d, value2 %d", cmd, value1, value2));
    clGeniviAudioCtrlAdapter::enCommand enCmd = static_cast<clGeniviAudioCtrlAdapter::enCommand>(cmd);
    (void) enCmd;
    switch(cmd)
    {
    case clGeniviAudioCtrlAdapter::CMD_SRC_ON:
        clAudioSMEngine::Source_On(SourceID(static_cast<sourceClassID>(value1),value2));
        break;
    case clGeniviAudioCtrlAdapter::CMD_SRC_OFF:
        clAudioSMEngine::Source_Off(SourceID(static_cast<sourceClassID>(value1),value2));
        break;
    case clGeniviAudioCtrlAdapter::CMD_RESET:
        clAudioSMEngine::ResetStack();
        break;
    case clGeniviAudioCtrlAdapter::CMD_PRINT:
        clAudioSMEngine::TraceStack();
        break;
    case clGeniviAudioCtrlAdapter::CMD_PRINT_BACKUP:
        clAudioSMEngine::TraceBackupStack();
        break;

    case clGeniviAudioCtrlAdapter::CMD_LIST_MAINCON:
        vTraceMainCon();
        break;

    case clGeniviAudioCtrlAdapter::CMD_LIST_ALLCON:
        vTraceAllCon();
        break;

    case clGeniviAudioCtrlAdapter::CMD_DB_SOURCE_DATA:
        vTraceSourceData(value1);
        break;

    case clGeniviAudioCtrlAdapter::CMD_DB_SINK_DATA:
        vTraceSinkData(value1);
        break;

    case clGeniviAudioCtrlAdapter::CMD_LIST_ALL_DOMAINS:
        vTraceAllDomains();
        break;

    case clGeniviAudioCtrlAdapter::CMD_LIST_ALL_SINKS:
        vTraceAllSinks();
        break;

    case clGeniviAudioCtrlAdapter::CMD_LIST_ALL_SOURCES:
        vTraceAllSources();
        break;

    case clGeniviAudioCtrlAdapter::CMD_INIT_DP_FM:
        vTraceInitDPwithFM();
        break;

    case clGeniviAudioCtrlAdapter::CMD_SET_DP_FOR_SINK:
        vTraceSetDPforSink(value1,value2);
        break;

    case clGeniviAudioCtrlAdapter::CMD_SET_DP_SUBID_FOR_SINK:
        vTraceSetDPSubIDforSink(value1,value2);
        break;

    case clGeniviAudioCtrlAdapter::CMD_CLEAR_DP_FOR_SINK:
        vTraceClearDPforSink(value1);
        break;

    case clGeniviAudioCtrlAdapter::CMD_LIST_INTERNAL_CONNECTIONS:
        printMainConnectionEntries();
        break;

    case clGeniviAudioCtrlAdapter::CMD_SET_RUNLEVEL:
        if(value1>3)
        {
            ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::TTFisInput : Runlevel must be 0-3"));
            return;
        }
        //vSwitchThreadContext(clAudioSMEngine, )
        clInputHelper::setValues(value1,0);
        vSwitchThreadContext<clInputHelper>(clInputHelper::getInstance(), &clInputHelper::setRunlevel);
        break;
    case clGeniviAudioCtrlAdapter::CMD_GET_RUNLEVEL:
        ETG_TRACE_ERR(("Runlevel: %d", clAudioSMEngine::GetRunlevel()));
        break;
    case clGeniviAudioCtrlAdapter::CMD_KILL_SRC:
        clAudioSMEngine::vHandleSrcActError(SourceID(static_cast<sourceClassID>(value1),value2));
        break;
    case clGeniviAudioCtrlAdapter::CMD_SRC_LIST:
    {
        clAudioSMEngine::ListSources();

        //print also the content of own m_registeredSources
        ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter content of m_registeredSources: "));
        std::map<am_sourceID_t, AudioSource::SourceID >::iterator it = m_registeredSources.begin();
        while(it != m_registeredSources.end())
        {
            ETG_TRACE_USR4(("am_sourceID_t %d, struct SourceID: SourceClass %d, SubSource %d",
                    it->first,
                    it->second.enSourceClass,
                    it->second.u16SubSource));
            ++it;
        }
    }
    break;
    case clGeniviAudioCtrlAdapter::CMD_SET_SRC_AVAILABLE:
    {
        const clSourceClass* srcClass =
                clFactory_AudioSourceClass::GetSourceClass_extID(static_cast<clSourceClass::externalID>(value1));
        if(srcClass != NULL)
        {
            ETG_TRACE_ERR(("given CCA SOURCE CLASS %d maps internal SourceClass %d"
                    , value1
                    , srcClass->SourceClassID));
            clInputHelper::setValues(srcClass->SourceClassID,value2);
            vSwitchThreadContext<clInputHelper>(clInputHelper::getInstance(), &clInputHelper::sourceAvailable);
        }else{
            ETG_TRACE_ERR(("COULD NOT MAP TO INTERNAL SOURCE CLASS"));
        }
    }
    break;
    case clGeniviAudioCtrlAdapter::CMD_SET_SRC_NOT_AVAILABLE:
    {
        const clSourceClass* srcClass =
                clFactory_AudioSourceClass::GetSourceClass_extID(static_cast<clSourceClass::externalID>(value1));

        if(srcClass != NULL)
        {
            ETG_TRACE_ERR(("given CCA SOURCE CLASS %d maps internal SourceClass %d"
                    , value1
                    , srcClass->SourceClassID));

            clAudioSMEngine::Source_AvailabilityChange(SourceID(srcClass->SourceClassID,value2),
                    clAudioSource::not_available,
                    clAudioSource::nomedia);
        }else{
            ETG_TRACE_ERR(("COULD NOT MAP TO INTERNAL SOURCE CLASS"));
        }
    }
    break;
    case clGeniviAudioCtrlAdapter::CMD_SET_SRC_AVAILABLE_UNKOWN:
    {
        const clSourceClass* srcClass =
                clFactory_AudioSourceClass::GetSourceClass_extID(static_cast<clSourceClass::externalID>(value1));

        if(srcClass != NULL)
        {
            ETG_TRACE_ERR(("given CCA SOURCE CLASS %d maps internal SourceClass %d"
                    , value1
                    , srcClass->SourceClassID));
            clAudioSMEngine::Source_AvailabilityChange(SourceID(srcClass->SourceClassID,value2),
                    clAudioSource::unkonwn,
                    clAudioSource::newmedia);
        }else{
            ETG_TRACE_ERR(("COULD NOT MAP TO INTERNAL SOURCE CLASS"));
        }
    }
    break;
    case clGeniviAudioCtrlAdapter::CMD_LOADXML:
        clFactory_AudioSourceClass::Ruleset_Load();
        break;
    case clGeniviAudioCtrlAdapter::CMD_PRINTXML:
        clFactory_AudioSourceClass::ReadXML();
        break;
    case clGeniviAudioCtrlAdapter::CMD_PRINTRULES:
        clFactory_AudioSourceClass::Ruleset_Print();
        break;
        // daw2hi: new
    case clGeniviAudioCtrlAdapter::CMD_REMOTESTART:
    {
        ETG_TRACE_USR2(("clGeniviAudioCtrlAdapter::TTFisInput REMOTE_START"));
        clAudioSourceController::vRemoteCtrlStart();
        break;
    }
    case clGeniviAudioCtrlAdapter::CMD_REMOTEEND:
    {
        ETG_TRACE_USR2(("clGeniviAudioCtrlAdapter::TTFisInput REMOTE_END"));
        clAudioSourceController::vRemoteCtrlEnd();
        break;
    }
    // end

    case clGeniviAudioCtrlAdapter::CMD_UNREGISTER_SINK_ADR_LINE_OUT:
    {
        ETG_TRACE_USR2(("clGeniviAudioCtrlAdapter::TTFisInput unregister invisible ADR_LINE_OUT with sinkID 17"));
        //std::string sinkName("ADR_3");
        //am_sinkID_t sinkID = clAudioSMEngine::getSourceIDbyName(sinkName);
        //getSinkInfoDB(const am_sinkID_t sinkID, am_Sink_s& sinkData)
        am_sinkID_t sinkID=17;
        am_Sink_s sinkData;
        if(E_OK == m_geniviControlIF->getSinkInfoDB(sinkID, sinkData))
            //if(sinkID == 17)
        {
            RemoveSink(sinkID);
        }
        else
        {
            ETG_TRACE_ERR(("Sink ADR_LINE_OUT with sinkID 17 not found"));
        }
        break;
    }

    case clGeniviAudioCtrlAdapter::CMD_REGISTER_SINK_ADR_LINE_OUT:
    {
        ETG_TRACE_USR2(("clGeniviAudioCtrlAdapter::TTFisInput register ADR_LINE_OUT with sinkID 17 as visible"));
        std::string sinkName("ADR_3");
        am_sinkID_t sinkID = clAudioSMEngine::getSinkIDbyName(sinkName);
        if(sinkID == 17)
        {
            ETG_TRACE_ERR(("Sink ADR_LINE_OUT with sinkID 17 already existing. Please unregister first"));
            return;
        }
        //prepare sink data and register it
        am_Sink_s gam_sink_s;
        gam_sink_s.domainID = 1;
        gam_sink_s.sinkID = (am_sinkID_t)17;
        gam_sink_s.available.availability = A_AVAILABLE;
        gam_sink_s.available.availabilityReason = AR_UNKNOWN;

        gam_sink_s.name = std::string("ADR_3");
        gam_sink_s.sinkClassID = (am_sinkClass_t)1;

        if(value1==0)	gam_sink_s.visible = false;
        if(value1==1)	gam_sink_s.visible = true;

        gam_sink_s.volume = 0;
        gam_sink_s.mainVolume = 0;
        gam_sink_s.muteState = MS_MUTED;

        //		  std::vector<am_CustomConnectionFormat_t> listConnectionFormats;
        //		  std::vector<am_MainSoundProperty_s> listMainSoundProperties;
        am_MainSoundProperty_s mainSoundProperty;
        for(unsigned int i = 0;i<96;i++)
        {
            mainSoundProperty.type = (am_CustomMainSoundPropertyType_t)i;
            mainSoundProperty.value = 0;
            gam_sink_s.listMainSoundProperties.push_back(mainSoundProperty);
        }

        AddSink(gam_sink_s);
        break;
    }

    default:
        ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::TTFisInput Command not handled"));
        break;
    }
}

//called for Diagnosis mode
tVoid clGeniviAudioCtrlAdapter::vRemoteControlStart()
{
    if(E_OK == clAudioSourceController::vRemoteCtrlStart())
    {
        ETG_TRACE_USR4(("vRemoteControlStart, remote control started successfully"));
    }
    else
    {
        ETG_TRACE_ERR(("vRemoteControlStart, failed to start remote control session!!"));
    }
}
//Fix for PSARCCB-3229 - paj5kor
tVoid clGeniviAudioCtrlAdapter::vRemoteControlUpdateDB(int16_t i16Type)
{
    ETG_TRACE_USR4(("vRemoteControlUpdateDB, remote control status updated successfully, updaing DB"));
    if(NULL != m_ControlSenderBase)
        m_ControlSenderBase->vUpdateSystemPropertyDB(SYP_DIAG_REMOTE_CONTROL, i16Type);
}

tVoid clGeniviAudioCtrlAdapter::vRemoteControlEnd()
{
    if(E_OK == clAudioSourceController::vRemoteCtrlEnd())
    {
        ETG_TRACE_USR4(("vRemoteControlEnd, remote control Ended successfully, updaing DB"));
        vRemoteControlUpdateDB(SYP_DIAG_REMOTE_CONTROL_OFF);
    }
    else
    {
        ETG_TRACE_ERR(("vRemoteControlEnd, failed to End remote control session!!"));
    }
}

am::am_Error_e clGeniviAudioCtrlAdapter::initializeSinks(am_domainID_t domainID)
{
    am_Error_e eCode;
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_ControlSenderBase,E_NOT_POSSIBLE);

    //create sink
    am_Sink_s sink;
    sink.domainID     = domainID; //we cannot know this when the table is created !

    //ETG_TRACE_ERR(("initializeSinks: HACK because param domainID %d not O.K. set it to 101",domainID));
    //sink.domainID=101;  //temp Hack. need to check why domainID is not valid

    sink.name         = "AMPLIFIER_MAINFIELD";
    sink.sinkID       = 1; //take fixed ids to make things easy
    sink.sinkClassID  = 1;
    sink.volume       = 0;
    sink.available.availability       = A_AVAILABLE;
    sink.available.availabilityReason = AR_UNKNOWN;
    //sink.listSoundProperties.push_back(sp);

    MapMainSoundProperty_t mapMainSoundProperty;
    std::vector<am_MainSoundProperty_s> listMainSoundProperties;
    am_MainSoundProperty_s msp;
    msp.value = G3G_DEFAULT_SND_PROPERTY_VALUE;

    for(am_CustomMainSoundPropertyType_t i16Src = 0; i16Src < MSP_MAX; i16Src++)
    {
        msp.value = G3G_DEFAULT_SND_PROPERTY_VALUE;
        /*
         * Add the properties which are not used and not required to register
         */
        switch(i16Src)
        {
        case MSP_MIC_STATUS_CONNECTION :
        case MSP_MIC_STATUS_LEVEL :
            continue;
        default :
            break;
        }
        msp.type = i16Src;
        listMainSoundProperties.push_back(msp);

        mapMainSoundProperty[msp.type] = msp.value;
        ETG_TRACE_USR4(("initializeSinks, registered sound property with %d", i16Src));
    }

    sink.listMainSoundProperties = listMainSoundProperties;

    sink.visible = true;
    sink.listConnectionFormats.push_back(CF_GENIVI_STEREO);
    sink.muteState = MS_MUTED;
    sink.mainVolume = 0;

    //sinks
    am_sinkID_t sinkID=1;  //daw2hi: 15.08.2018 seems to be a problem in new Adit AudioManager if not set
    //set the correct domainID
    //sinkIter->domainID = mListDomains[0].domainID;

    //27.07.2016 daw2hi could treat this as a static sink (always there)
    am_SinkClass_s sinkClass; //, am_sinkClass_t & sinkClassID
    am_sinkClass_t sinkClassID = 1;

    sinkClass.sinkClassID = sinkClassID;
    sinkClass.name = "Sink_Class_1";

    eCode = m_geniviControlIF->enterSinkClassDB(sinkClass, sinkClassID);
    if(eCode != E_OK)
    {
        ETG_TRACE_ERR(("failed to enter SinkClass in DB, result of enterSinkClassDB %d",eCode));
    }
    else
    {
        ETG_TRACE_USR4(("enterSinkClassDB OK")); //daw2hi: ToDo: do error print if not E_OK
    }

    if ((eCode = m_geniviControlIF->enterSinkDB(sink, sinkID)) != E_OK)
    {
        ETG_TRACE_FATAL(("syncRegisterWorker::start2work error on registering domain, failed with %d", eCode));
    }
    else
    {
        m_registeredSinks[sinkID] = sink;
        m_ControlSenderBase->m_MapMainSinkSoundProperty[sinkID] = mapMainSoundProperty;
    }

#ifdef VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_INF4CV
    rMainSinkSoundPropertySet set;
    set.mainSoundProperty.value = u16GetPrivateModeMixVolume(sink.sinkID);;
    set.mainSoundProperty.type = MSP_PRIVATE_MODE_MIX_VOLUME;
    if(NULL != m_ControlSenderBase)
        m_ControlSenderBase->vUpdateSinkSoundPropertyDB(MSP_PRIVATE_MODE_MIX_VOLUME, set.mainSoundProperty.value);
    //end
#endif
    return eCode;
}

//check if sourceID is present in m_registeredSources
am_Error_e clGeniviAudioCtrlAdapter::isValidSourceID(am_sourceID_t sourceID)
{
    //get the AudioStack SourceID of given GAM SourceID
    std::map<am_sourceID_t, SourceID >::const_iterator iter = m_registeredSources.find(sourceID);

    if(iter != m_registeredSources.end()){
        return E_OK;
    }else{
        ETG_TRACE_ERR(("isValidSourceID: SourceID: %d is not registered at clGeniviAudioCtrlAdapter" , sourceID));
        return E_NON_EXISTENT;
    }
}

//check if sinkID is present in m_registeredSinks
am_Error_e clGeniviAudioCtrlAdapter::isValidSinkID(am_sinkID_t sinkID)
{
    std::map<am_sinkID_t, am_Sink_s >::const_iterator iter = m_registeredSinks.find(sinkID);
    if(iter != m_registeredSinks.end()){
        return E_OK;
    }else{
        ETG_TRACE_ERR(("isValidSinkID: sinkID: %d is not registered at clGeniviAudioCtrlAdapter" , sinkID));
        return E_NON_EXISTENT;
    }
}

//load all the settings 
void clGeniviAudioCtrlAdapter::vLoadSettings(tU16 sinkId)
{
    rMainSinkSoundPropertySet set;
    set.mainSoundProperty.value = u16GetPrivateModeMixVolume(sinkId);
    set.mainSoundProperty.type = MSP_PRIVATE_MODE_MIX_VOLUME;

    tU16 u16PrivateMode ;
    eGetPrivateMode(u16PrivateMode);
    if(NULL != m_ControlSenderBase)
    {
        m_ControlSenderBase->vUpdateSinkSoundPropertyDB(MSP_PRIVATE_MODE_MIX_VOLUME, set.mainSoundProperty.value);
        m_ControlSenderBase->vUpdateSystemPropertyDB(SYP_PRIVATE_MODE, u16PrivateMode);
    }

    //need to forward for accessing the Soundhandler to reloading the changed DP values and update to HMI
    m_ControlSenderBase->vLoadSoundSettings();

}

// add SourceClass to daemon
am_Error_e clGeniviAudioCtrlAdapter::addSourceClass( am_SourceClass_s& srcClass, am_sourceClass_t& srcClassID)
{
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);

    return m_geniviControlIF->enterSourceClassDB(srcClassID, srcClass);
}
#if 0 //not used
tVoid clGeniviAudioCtrlAdapter::initializeSourceClasses(am_domainID_t)
{
    if(m_geniviControlIF == NULL) return;

    am_Error_e eCode;
    am_SourceClass_s srcClass;
    am_sourceClass_t srcClassID;
    stSourceType t;
    const std::vector<stSourceType>& typeList = clFactory_AudioSourceClass::GetSourceTypeList();
    //std::vector<stSourceType>::const_iterator it = typeList.begin();

    for(std::vector<stSourceType>::const_iterator it = typeList.begin();
            it != typeList.end();
            ++it)
    {
        srcClass.sourceClassID = static_cast<am_sourceClass_t>((*it).id);
        srcClass.name = (*it).name;
        ETG_TRACE_USR4(("Register SourceClass ID %d Name: %s"
                , srcClass.sourceClassID
                , srcClass.name.c_str()));
        if ((eCode =
                m_geniviControlIF->enterSourceClassDB(srcClassID, srcClass) ) != E_OK)
        {
            //This may fail because we already registered same source class previously
            ETG_TRACE_USR4(("register source class failed with error code %d", eCode));
        }
        ETG_TRACE_USR4(("Register SourceClass GeniviID %d, ID %d, Name: %s"
                , srcClassID
                , srcClass.sourceClassID
                , srcClass.name.c_str()));
    }

}
#endif
#if 0 // not used ??
tVoid clGeniviAudioCtrlAdapter::initializeSources(am_domainID_t domainID)
{
    vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF);
    vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_ControlSenderBase);

    am_Error_e eCode;
    //
    // CREATE DB SOURCE ITEM FOR EACH RULE OF THE STACKRULES
    // BUT EXCEPT GROUP IS INTERNAL
    //
    const std::vector<clSourceClass>& srcList = clFactory_AudioSourceClass::GetSourceClassList();
    for(std::vector<clSourceClass>::const_iterator it = srcList.begin();
            it !=srcList.end();
            ++it)
    {
        const AudioStack::clSourceClass & srcClass = clFactory_AudioSourceClass::GetSourceClass((*it).SourceClassID);
        if(srcClass.getRegistrationMode() == clSourceClass::registerStatic)
        {
            //create a bunch full of sources
            am_Source_s item;
            am_sourceID_t sourceID = 0;
            item.domainID = domainID; //assign the default domain we created
            item.name = srcClass.SrcClassName;
            item.sourceState = SS_OFF;
            item.sourceID = static_cast<am_sourceID_t>(srcClass.getClassID()); //take fixed ids to make thins easy
            //don't know Class ID
            item.sourceClassID = static_cast<am_sourceClass_t>(srcClass.getTypeID());
            item.volume = 0;
            item.visible = true;
            item.available.availability = A_AVAILABLE;
            item.available.availabilityReason = AR_UNKNOWN;

            am_MainSoundProperty_s msp;
            std::vector<am_MainSoundProperty_s> listMainSoundProperties;
            MapMainSoundProperty_t mapMainSoundProperty;

            msp.value = G3G_DEFAULT_SND_PROPERTY_VALUE;

            for (uint16_t i16Src = 0; i16Src < G3G_NUMBER_SOURCE_SND_PROPERTY; i16Src++)
            {
                msp.type = (uint16_t)g_u8SrcSoundPropertiesId[i16Src];
                listMainSoundProperties.push_back(msp);
                mapMainSoundProperty[msp.type] = G3G_DEFAULT_SND_PROPERTY_VALUE;
            }
            item.listMainSoundProperties = listMainSoundProperties;
            item.listConnectionFormats.push_back(CF_GENIVI_STEREO);

            if ((eCode =
                    m_geniviControlIF->enterSourceDB(item,sourceID)) != E_OK)
            {
                ETG_TRACE_ERR(("ERROR on registering source, failed with ErrorCode: %d", eCode));
            }
            else
            {
                m_ControlSenderBase->m_MapMainSourceSoundProperty[sourceID] = mapMainSoundProperty;
            }
        }
    }
}
#endif

tVoid clGeniviAudioCtrlAdapter::Reset()
{
    m_geniviControlIF = NULL;
    //m_registeredSources.clear();
}

clAudioSource::enSourceActivity clGeniviAudioCtrlAdapter::Ext2Int_Activity(midw_fi_tcl_e8_SrcActivity::tenType extActivity)
{
    switch(extActivity)
    {
    case midw_fi_tcl_e8_SrcActivity::FI_EN_ON:
        return clGeniviAudioSource::On;

    case midw_fi_tcl_e8_SrcActivity::FI_EN_PAUSE:
        return clGeniviAudioSource::Pause;

    case midw_fi_tcl_e8_SrcActivity::FI_EN_OFF:
        return clGeniviAudioSource::Off;

    default:
        ETG_TRACE_FATAL(("Ext2Int_Activity INVALID PARAMETER"));
        break;
    }
    return clGeniviAudioSource::Off;
}

clAudioSource::enSourceAvailability clGeniviAudioCtrlAdapter::Ext2Int_Availability(midw_fi_tcl_e8_SrcAvailability::tenType extAvailability)
{
    switch(extAvailability)
    {
    case midw_fi_tcl_e8_SrcAvailability::FI_EN_NOT_AVAILABLE:
        return clAudioSource::not_available;
    case midw_fi_tcl_e8_SrcAvailability::FI_EN_PLAYABLE:
        return clAudioSource::available;
    case midw_fi_tcl_e8_SrcAvailability::FI_EN_PLAYABLE_UNKNOWN:
        return clAudioSource::unkonwn;
    case midw_fi_tcl_e8_SrcAvailability::FI_EN_NOT_PLAYABLE:
        return clAudioSource::not_available;
    default:
        ETG_TRACE_FATAL(("Ext2Int_Availability INVALID PARAMETER"));
        break;
    }
    return clAudioSource::not_available;
}

clAudioSource::enSourceAvailabilityReason clGeniviAudioCtrlAdapter::Ext2Int_AvailabilityReason(
        midw_fi_tcl_e8_SrcAvailabilityReason::tenType extAvailabilityReason)
{
    switch(extAvailabilityReason)
    {
    case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_ERROR:
        return clAudioSource::error;
    case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_NEWMEDIA:
        return clAudioSource::newmedia;
    case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_NOMEDIA:
        return clAudioSource::nomedia;
    case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_NO_CONTENT:
        return clAudioSource::no_content;
    case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_SAMEMEDIA:
        return clAudioSource::samemedia;
    case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_TEMPERATURE:
        return clAudioSource::temperature;
    case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_VOLTAGE:
        return clAudioSource::voltage;
    case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_OVERCURRENT:
        return clAudioSource::overcurrent;
    case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_INTERNALDISCONNECT:
        return clAudioSource::internaldisconnect;
    default:
        ETG_TRACE_FATAL(("Ext2Int_AvailabilityReason INVALID PARAMETER"));
        break;
    }
    return clAudioSource::error;
}

// add source in other domain
am_sourceID_t clGeniviAudioCtrlAdapter::AddExternalSource(SourceID srcID, const am_Source_s& gam_source_s)
{
    ETG_TRACE_USR4(("AddExternalSource: SourceClass: %d subID %d, GeniviID %d "
            , srcID.enSourceClass
            , (tU16)srcID.u16SubSource
            , gam_source_s.sourceID));

    //check for sources from other domain
    if(gam_source_s.domainID != GetDomainID())    //daw2hi 23.08.2017 outcommented just for a test register Source from CCA routingPlugin
    {
        std::map<am_sourceID_t, SourceID >::const_iterator iter = m_registeredSources.find(gam_source_s.sourceID);
        if((iter == m_registeredSources.end()) || (gam_source_s.sourceID==0))
        {

            // ToDo check how solve this. We pass gam_sourceID
            am_sourceID_t gam_sourceID = gam_source_s.sourceID;
            //am_Error_e retVal = m_geniviControlIF->enterSourceDB(gam_source_s,gam_sourceID);
            //but now the gam_source_s.sourceID remains unchanged. (in utest it is filled)
            // need to do the above later, from inside of the clExtGeniviAudioSource (daw2hi: 27.02.2017)

            ETG_TRACE_USR4(("AddExternalSource: Source registered"));
            //not yet registered here, do it
            //m_registeredSources[gam_sourceID] = srcID;
            //if(gam_source_s.visible)   // ToDo check if correct to create only if visible ???
            {
                //we create also a AudioSourceObject. ToDo: should we support multiple AudioSources of same class (only for dynamic ??)
                //clAudioSource* pSrc = clAudioSourceFactory::getAudioSource(gam_source_s.sourceClassID);
                // could also use this
                //clAudioSource* pSrc = clAudioSourceFactory::getAudioSource(srcID,gam_source_s.sourceID,true);

                //daw2hi 15.09.2017 transport am_Source_s sourceData down to clExtAudioSource
#if defined(VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_INF4CV ) || defined(VARIANT_S_FTR_ENABLE_UNITTEST)
                const am_Source_s* pSourceData = &gam_source_s;
#endif
                clAudioSource* pSrc = clAudioSourceFactory::getAudioSource(srcID,gam_source_s.sourceID,true, &gam_source_s);


                //now we should have it in m_registeredSources, let's check it

                iter = m_registeredSources.begin();
                while(iter != m_registeredSources.end())
                {
                    if((*iter).second == srcID)
                    {
                        //yes we have it
                        gam_sourceID = iter->first;
                        ETG_TRACE_USR4(("B: found gamSrcId %d in m_registeredSources",gam_sourceID));
                        break;
                    }
                    ++iter;
                }
                //can we inform gateways about new source?
#if defined(VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_INF4CV ) || defined(VARIANT_S_FTR_ENABLE_UNITTEST)
                clFactory_AudioSourceClass::SetDynamicSourceID(gam_sourceID, *pSourceData);
#endif
                return gam_sourceID; //this would do ?

                // check if we have the source in our m_registeredSources
                clGeniviAudioSource* pGamSrc = static_cast<clGeniviAudioSource*>(pSrc);
                //clExtGeniviAudioSource* pGamSrc2 = static_cast<clExtGeniviAudioSource* >(clAudioSourceFactory::getAudioSource(srcID));

                return pGamSrc->u16GetGeniviSourceID(); //daw2hi 27.03.2017
            }
        }
        else
        {
            ETG_TRACE_ERR(("AddExternalSource: Source was already registered"));
        }
    }

    else
    {
        //Error, should not call this for own domain
        ETG_TRACE_ERR(("AddExternalSource: hould not call this for own domain"));
    }

    return 0;
}
am_sourceID_t clGeniviAudioCtrlAdapter::AddSource(SourceID srcID, am_Source_s& gam_source_s)
{
    ETG_TRACE_USR4(("AddSource: SourceClass: %d subID %d, GeniviID %d "
            , srcID.enSourceClass
            , (tU16)srcID.u16SubSource
            , gam_source_s.sourceID));
    if(m_geniviControlIF == NULL)
    {
        ETG_TRACE_ERR(("Error: Genivi Receive Interface not available! SourceClass: %d subID %d "
                , srcID.enSourceClass
                , (tU16)srcID.u16SubSource));
        return 0;
    }
    {
        //for other domains already done in ExtGeniviAudioSource
        am_sourceID_t gam_sourceID = gam_source_s.sourceID;
        //am_Error_e retVal = m_geniviControlIF->enterSourceDB(gam_source_s,gam_sourceID);
        am_Error_e retVal = m_geniviControlIF->enterSourceDB(gam_source_s,gam_source_s.sourceID);
        gam_sourceID = gam_source_s.sourceID;
        //gam_source_s.sourceID = gam_sourceID; //daw2hi 24.03.2017: check if we can give enterSourceDB(gam_source_s, gam_source_s.sourceID)
        if(retVal == E_OK)
        {
            m_registeredSources[gam_sourceID] = srcID;
            ETG_TRACE_USR4(("AddSource: SourceClass: %d subID %d assigned GeniviSourceID %d "
                    , srcID.enSourceClass
                    , (tU16)srcID.u16SubSource
                    , (tU16)static_cast<tU16>(gam_sourceID)));
            return gam_sourceID;
        }
        else
        {
            ETG_TRACE_ERR(("AddSource for GeniviSourceID %d returns Error %d",gam_sourceID,retVal));
        }
    }
    return 0;
}



tVoid clGeniviAudioCtrlAdapter::RemoveSource(am_sourceID_t gam_sourceID)
{
    if(m_geniviControlIF == NULL) return;

    ETG_TRACE_USR4(("RemoveSource: amSourceID: %d", gam_sourceID));
    am_Error_e retVal = m_geniviControlIF->removeSourceDB(gam_sourceID);
    m_registeredSources.erase(gam_sourceID);
    if(retVal != E_OK)
    {
        ETG_TRACE_ERR(("RemoveSource: ERROR could not remove source from DB %d", gam_sourceID));
    }
}

tVoid clGeniviAudioCtrlAdapter::SourceAvailabilityChange(const am_sourceID_t sourceID, const am_Availability_s & availability)
{
    std::map<am_sourceID_t, SourceID >::const_iterator iter = m_registeredSources.find(sourceID);

    if(iter == m_registeredSources.end())
        return;
    SourceID srcID = iter->second;
    clAudioSource* pSrc = clAudioSourceFactory::isSourceInstantiated(srcID);

    const clSourceClass srcClass =  pSrc->getSourceClass();

    ETG_TRACE_USR4(("SourceAvailabilityChange: SourceClass: %d, subID %#x(%d), Availability %d, Reason %d"
            , srcID.enSourceClass
            , srcID.u16SubSource
            , srcID.u16SubSource
            , availability.availability
            , availability.availabilityReason
    ));
    if(clFactory_AudioSourceClass::GetRegistrationMode(srcID) == clSourceClass::registerDynamic || clFactory_AudioSourceClass::GetRegistrationMode(srcID) == clSourceClass::registerExtDynamic)
    {
        ETG_TRACE_USR4(("SourceAvailabilityChange: SourceAvailability change requested for dynamic source: Accepted"));
        ETG_TRACE_USR4(("ADD_REMOVED src_remove_avail = %u",(tU8)srcClass.src_remove_avail));

        if((availability.availability == A_UNAVAILABLE) && (srcClass.src_remove_avail == false))
        {
            clAudioSMEngine::Source_Removed(srcID);
        }
        else
        {
            clAudioSMEngine::Source_AvailabilityChange(srcID,
                    (clAudioSource::enSourceAvailability)availability.availability,
                    (clAudioSource::enSourceAvailabilityReason)availability.availabilityReason);
        }
    }
    else
    {
        ETG_TRACE_USR4(("SourceAvailabilityChange: SourceAvailability change requested for static or none source: Ignored"));
    }
}


tVoid clGeniviAudioCtrlAdapter::SourceAvailabilityChange(midw_fi_tcl_e8_AudSource::tenType Source,
        tU16 SubSource,
        midw_fi_tcl_e8_SrcAvailability::tenType Availability,
        midw_fi_tcl_e8_SrcAvailabilityReason::tenType Reason)
{
    ETG_TRACE_USR4(("SourceAvailabilityChange: SourceClass: %d, subID %#x(%d), Availability %d, Reason %d"
            ,ETG_CENUM(midw_fi_tcl_e8_AudSource::tenType,Source)
            , SubSource
            , SubSource
            , ETG_CENUM(midw_fi_tcl_e8_SrcAvailability::tenType, Availability)
            , ETG_CENUM(midw_fi_tcl_e8_SrcAvailabilityReason::tenType, Reason)
    ));
#if 0 // there should be no more need to do this. It is clear why reset happened.
    const std::vector<clSourceClass>& srcList = clFactory_AudioSourceClass::GetSourceClassList();
    for(std::vector<clSourceClass>::const_iterator it = srcList.begin();
            it !=srcList.end();
            ++it)
    {
        const AudioStack::clSourceClass & srcClass = clFactory_AudioSourceClass::GetSourceClass((*it).SourceClassID);
        if(Ext2Int_SrcClass(Source) == srcClass.getClassID())
        {
            if(srcClass.getRegistrationMode() == clSourceClass::registerDynamic)
            {
                ETG_TRACE_USR4(("SourceAvailabilityChange: SourceAvailability change requested for dynamic source: Accepted"));
                clAudioSMEngine::Source_AvailabilityChange(
                        SourceID( Ext2Int_SrcClass(Source) ,SubSource),
                        Ext2Int_Availability(Availability),
                        Ext2Int_AvailabilityReason(Reason));
            }
            else
            {
                ETG_TRACE_USR4(("SourceAvailabilityChange: SourceAvailability change requested for static or none source: Ignored"));
            }
            break;
        }
    }
#endif
    const AudioStack::clSourceClass & srcClass = clFactory_AudioSourceClass::GetSourceClass(Ext2Int_SrcClass(Source));
    if(srcClass.getRegistrationMode() == clSourceClass::registerDynamic)
    {
        ETG_TRACE_USR4(("SourceAvailabilityChange: SourceAvailability change requested for dynamic source: Accepted"));
        clAudioSMEngine::Source_AvailabilityChange(
                SourceID( Ext2Int_SrcClass(Source) ,SubSource),
                Ext2Int_Availability(Availability),
                Ext2Int_AvailabilityReason(Reason));
    }
    else
    {
        ETG_TRACE_USR4(("SourceAvailabilityChange: SourceAvailability change requested for static or none source: Ignored"));
    }
}

// Sink handling

am_sinkID_t clGeniviAudioCtrlAdapter::AddSink(const am_Sink_s& gam_sink_s)
{
    ETG_TRACE_USR4(("AddSink: %s",gam_sink_s.name.c_str()));
    ETG_TRACE_USR4(("AddSink: gam_sink_s.sinkID: %d, domainID %d, sinkClassID %d, volume %d, mainVolume %d",
            gam_sink_s.sinkID, gam_sink_s.domainID, gam_sink_s.sinkClassID, gam_sink_s.volume, gam_sink_s.mainVolume));
    am_Sink_s tmp_sink_s;

    tmp_sink_s = gam_sink_s;
    tmp_sink_s.sinkID = 0;

    if(m_geniviControlIF == NULL)
    {
        ETG_TRACE_ERR(("Error: Genivi Receive Interface not available! SinkClassID: %d SinkID: %d, name %s"
                , tmp_sink_s.sinkClassID
                , tmp_sink_s.sinkID
                , tmp_sink_s.name.c_str()));
        return 0;
    }
    am_Error_e retVal = m_geniviControlIF->enterSinkDB(gam_sink_s,tmp_sink_s.sinkID);
    if(retVal == E_OK)
    {
        //m_registeredSinks[gam_sink_s.sinkID] = gam_sink_s;  //daw2hi 29.06.2018 not O.k: for dyn Sink
        m_registeredSinks[tmp_sink_s.sinkID] = gam_sink_s;
    }
    else if(retVal == E_ALREADY_EXISTS)
    {
        //if we do not have this sink in our list we should add it
        std::map<am_sinkID_t, am_Sink_s>::iterator it = m_registeredSinks.find(gam_sink_s.sinkID);
        if(it == m_registeredSinks.end())
        {
            ETG_TRACE_USR4(("Adding Sink %d, known in Database but not yet known here", gam_sink_s.sinkID));
            m_registeredSinks[gam_sink_s.sinkID] = gam_sink_s;
        }
        else
        {
            ETG_TRACE_ERR(("Sink %d already known here", gam_sink_s.sinkID));
        }
    }
    else if(retVal == E_NOT_POSSIBLE)
    {
        ETG_TRACE_ERR(("Adding Sink %d E_NOT_POSSIBLE",gam_sink_s.sinkID));
    }

    //check where we need to enter the new known sinkID
    //std::vector<std::pair<tU16,std::string>> systemSinks = clFactory_AudioSourceClass::GetSystemSinkList();
    std::vector<std::pair<am_sinkID_t, am_Sink_s>> systemSinks = clFactory_AudioSourceClass::GetSystemSinkList();
    for(unsigned int i=0; i<systemSinks.size();i++)
    {
        if(systemSinks[i].second.name.compare(gam_sink_s.name)==0)
        {
            //found it
            if(systemSinks[i].first==0)
            {
                //and it is not yet set, we set it now
                systemSinks[i].first = tmp_sink_s.sinkID;
                break; //we can leave here
            }
        }
    }
    //update AudioStack for dynamic sinks
    if(tmp_sink_s.sinkID >= 100)
    {
        clAudioSourceController::getInstance().vUpdateAudioStackSinkID(tmp_sink_s.sinkID,gam_sink_s.name);
    }
    //now find sink name in all source classes and set the sinkID there as well.
    //do it in the clFactory_AudioSourceClass
    //clFactory_AudioSourceClass::SetDynamicSinkID(tmp_sink_s.sinkID,gam_sink_s.name);
    // better to pass the whole structure
    clFactory_AudioSourceClass::SetDynamicSinkID(tmp_sink_s.sinkID,gam_sink_s);

    if(retVal == E_OK) return tmp_sink_s.sinkID; //daw2hi 3.7.2018

    ETG_TRACE_ERR(("Error: enterSinkDB returned error %d for SinkClassID: %d SinkID %d"
            , retVal
            , (tU16)tmp_sink_s.sinkClassID
            , tmp_sink_s.sinkID));
    return 0;
}

tVoid clGeniviAudioCtrlAdapter::AddSinkIndex(am_Sink_s s_sink,bool bRestore)
{
    struct sinkData sinkLSM;
    ETG_TRACE_USR4(("Adding Sink, known at index %d sink name %s",m_sinkIndex,s_sink.name.c_str()));
    sinkLSM.s_sink= s_sink;
    sinkLSM.bLastMode = FALSE;
    sinkLSM.bRestore = bRestore;
    s_sink.sinkID == 0?sinkLSM.sSinkType = dynamicType:sinkLSM.sSinkType = staticType;
    m_sinkList[m_sinkIndex++] = sinkLSM;
    PrintSinkMap();
}



tVoid clGeniviAudioCtrlAdapter::AddDynSinkIndex(std::string sName,am_sinkID_t sinkId)
{
    if(m_sinkList.size()>0)
    {
        std::map<unsigned int, struct sinkData>::iterator it = m_sinkList.begin();
        for(it=m_sinkList.begin(); it!=m_sinkList.end();it++){
            if((it->second).s_sink.sinkID == 0)
            {
                if (((it->second).s_sink).name.compare(sName)==0)
                {
                    ETG_TRACE_USR4(("Adding SinkID %d, known at index %d sink name %s",sinkId,(it->first),sName.c_str()));
                    (it->second).s_sink.sinkID = sinkId;
                    return;
                }
            }
        }
    }
}

// we keep a map of sinkData
// index -> sinkData
// the index is our order in the Datapool
// here we search for the sinkID and find out the index for accessing the DP at this index
int clGeniviAudioCtrlAdapter::GetSinkIndex(am_sinkID_t sinkId)
{
    ETG_TRACE_USR4(("GetSinkIndex for sinkID %d",sinkId));
    if(sinkId == 0)
        return UNKNOWN_SINK;
    if(m_sinkList.size()>0)
    {
        std::map<unsigned int, struct sinkData>::iterator it = m_sinkList.begin();
        for(it=m_sinkList.begin(); it!=m_sinkList.end();it++){
            if((it->second).s_sink.sinkID == sinkId)
            {
                ETG_TRACE_USR4(("GetSinkIndex for sinkID %d returns index %d",sinkId,it->first));
                return (it->first);
            }
        }
    }
    ETG_TRACE_ERR(("GetSinkIndex for sinkID %d not found in m_sinkList",sinkId));
    return UNKNOWN_SINK;
}
int clGeniviAudioCtrlAdapter::SetLSM(am_sinkID_t sinkId,bool flag)
{
    if(sinkId == 0)
        return UNKNOWN_SINK;
    if(m_sinkList.size()>0)
    {
        std::map<unsigned int, struct sinkData>::iterator it = m_sinkList.begin();
        for(it=m_sinkList.begin(); it!=m_sinkList.end();it++)
        {
            if((it->second).s_sink.sinkID == sinkId)
                (it->second).bLastMode = flag;
        }
    }
    return 0; //daw2hi: is this OK ?
}

bool clGeniviAudioCtrlAdapter::GetLSM(am_sinkID_t sinkId)
{
    if(sinkId == 0)
        return false;
    if(m_sinkList.size()>0)
    {
        std::map<unsigned int, struct sinkData>::iterator it = m_sinkList.begin();
        for(it=m_sinkList.begin(); it!=m_sinkList.end();it++)
        {
            if((it->second).s_sink.sinkID == sinkId)
                return (it->second).bLastMode;
        }
    }
    return false ;
}

tVoid clGeniviAudioCtrlAdapter::PrintSinkMap()
{
    if(m_sinkList.size()>0)
    {
        std::map<unsigned int, struct sinkData>::iterator it = m_sinkList.begin();
        for(it=m_sinkList.begin(); it!=m_sinkList.end();it++){
            ETG_TRACE_USR4(("Adding SinkID %d, known at index %d sink name %s",(it->second).s_sink.sinkID,(it->first),((it->second).s_sink).name.c_str()));
        }
    }
}

tVoid clGeniviAudioCtrlAdapter::RemoveSink(am_sinkID_t gam_sinkID)
{
    if(m_geniviControlIF == NULL) return;

    ETG_TRACE_USR4(("RemoveSink: gam_sinkID: %d",gam_sinkID));
    //fetch the name first
    am_Sink_s sinkData;
    am_Error_e retVal;
    retVal = m_geniviControlIF->getSinkInfoDB(gam_sinkID, sinkData);

    retVal = m_geniviControlIF->removeSinkDB(gam_sinkID);

    auto it = m_registeredSinks.find(gam_sinkID);
    //if we do not have this sink, return here
    if(it == m_registeredSinks.end()) return;

    m_registeredSinks.erase(gam_sinkID);
    //ToDo should check for the corresponding Stack and clean it
    clAudioSMEngine::vResetStack(gam_sinkID);

    //reset dynamic ID
    if(gam_sinkID>=100)
    {
        ETG_TRACE_ERR(("RemoveSink for %d %s",gam_sinkID,sinkData.name.c_str()));
        clAudioSourceController::getInstance().vUpdateAudioStackSinkID(0, sinkData.name);
        //better to pass the whole structure
        clFactory_AudioSourceClass::SetDynamicSinkID((am_sinkID_t)0, sinkData);
    }
    else
    {
        ETG_TRACE_ERR(("RemoveSink but sink %d is not dynamic",gam_sinkID));
    }

    if(retVal != E_OK)
    {
        ETG_TRACE_ERR(("RemoveSink: ERROR could not remove sinkID from DB %d",(int)gam_sinkID));
    }
}

//tVoid clGeniviAudioCtrlAdapter::SinkAvailabilityChange()
// end
tVoid clGeniviAudioCtrlAdapter::AddAudioRouteMgrIF(amcontrol_clienthandler_fc_audioroutemanager* clientHandlerAudioRouteMgr)
{
    m_clientHandlerAudioRouteMgr = clientHandlerAudioRouteMgr;
}

tVoid clGeniviAudioCtrlAdapter::RemoveAudioRouteMgrIF()
{
    m_clientHandlerAudioRouteMgr = NULL;
}

tVoid clGeniviAudioCtrlAdapter::AddFcAudioMgrIF(amcontrol_clienthandler_fc_audiomanager* clientHandlerFcAudiMgr)
{
    m_clientHandlerFcAudioMgr = clientHandlerFcAudiMgr;
}

tVoid clGeniviAudioCtrlAdapter::RemoveFcAudioMgrIF()
{
    m_clientHandlerFcAudioMgr = NULL;
}

tVoid clGeniviAudioCtrlAdapter::AddGeniviCtrlIF(IAmControlReceive* pGeniviCtrlIF)
{
    m_geniviControlIF = pGeniviCtrlIF;
}

tVoid clGeniviAudioCtrlAdapter::RemoveGeniviCtrlIF()
{
    m_geniviControlIF = NULL;
}

IAmControlReceive* clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()
{
    return m_geniviControlIF;
}

tVoid clGeniviAudioCtrlAdapter::AddDomainID(am_domainID_t domainID)
{
    ETG_TRACE_USR1(("AddDomainID: m_domainID: %d, (old value %d)", domainID,m_domainID));
    if(m_domainID ==0) //only if not set yet. Once it was set it should no more be modified to avoid taking the DBus domain
        //m_domainID = domainID;
        m_domainID = 1; //daw2hi 30.01.2018 strange, now DBus domain comes first with ID 1 (maybe because we used 0 in our AsyncRoutingPlugin?)
}

void clGeniviAudioCtrlAdapter::printMainConnectionEntries()
{
    for(unsigned int i =0; i<m_mainConnectionEntries.size();i++)
    {
        ETG_TRACE_USR1(("-------------------------------------------------------"));
        ETG_TRACE_USR1(("m_mainConnectionEntries[%d].mainID = %d",i,m_mainConnectionEntries[i].mainID));
        //found our main connection
        for(unsigned int k=0;k<m_mainConnectionEntries[i].subConnectionList.size();k++)
        {
            ETG_TRACE_USR1(("mainID %d: SubConID %d",m_mainConnectionEntries[i].mainID,m_mainConnectionEntries[i].subConnectionList[k].connectionID));
        }
        ETG_TRACE_USR1(("-------------------------------------------------------"));
    }
}

//check if SubConID is part of any other mainCon other than MainID
bool clGeniviAudioCtrlAdapter::bIsSubConInOtherMain(const am_mainConnectionID_t MainID, am_connectionID_t SubConID)
{
    ETG_TRACE_USR4(("bIsSubConInOtherMain start searching SubConID %d in other MainID than %d",SubConID,MainID));
    std::vector<am_MainConnection_s> listMainConnections;
    if(E_OK == m_geniviControlIF->getListMainConnections(listMainConnections))
    {
        for(unsigned int i=0;i<listMainConnections.size();i++)
        {
            for(unsigned int k = 0;k<listMainConnections[i].listConnectionID.size();k++)
            {
                if(listMainConnections[i].listConnectionID[k] == SubConID)
                {
                    if(listMainConnections[i].mainConnectionID != MainID)
                    {
                        ETG_TRACE_USR4(("bIsSubConInOtherMain found SubConID %d in MainID %d",SubConID,MainID));
                        return true;
                    }
                }
            }
        }
    }

    ETG_TRACE_USR4(("bIsSubConInOtherMain SubConID %d not found in other than MainID %d",SubConID,MainID));
    return false;
}

//daw2hi added 16.6.2017
am_Error_e clGeniviAudioCtrlAdapter::hookUserDisconnectionRequest(const am_mainConnectionID_t MainID, am_connectionID_t SubConID)
{
    ETG_TRACE_USR1(("####new### clGeniviAudioCtrlAdapter::hookUserDisconnectionRequest MainID %d, SubConID %d",MainID,SubConID));
    //ToDo: we can get this also from the daemon

    //debug
    printMainConnectionEntries();

    bool bFound = false;
    // we can now go through our data or we get data from daemon
    for(unsigned int i =0; i<m_mainConnectionEntries.size();i++)
    {
        if(m_mainConnectionEntries[i].mainID == MainID)
        {
            bFound=true;
            //found our main connection
            for(unsigned int k=0;k<m_mainConnectionEntries[i].subConnectionList.size();k++)
            {
                if(m_mainConnectionEntries[i].subConnectionList[k].connectionID==SubConID)
                {
                    //found our SubCon but now we need to take corresponding element from m_registeredSources
                    std::map<am_sourceID_t, SourceID >::const_iterator iter = m_registeredSources.find(m_mainConnectionEntries[i].subConnectionList[k].sourceID);
                    if(iter != m_registeredSources.end()) //daw2hi 23.10.2017
                    {
                        //this content should not impact DBus ARL as they do not have sub connections (yet?)

                        //if this subID is used in another Main,
                        //then we should just remove it here (and from the mainConnectionData.listConnectionID)
                        if(false==bIsSubConInOtherMain(MainID,SubConID))
                        {
                            ETG_TRACE_USR1(("####new### call clAudioSMEngine::Source_Off()"));
                            (void)clAudioSMEngine::Source_Off((*iter).second,
                                    m_mainConnectionEntries[i].subConnectionList[k].sinkID,0);
                        }
                        else
                        {
                            // we can just remove the subCon
                            am_MainConnection_s mainConnectionData;
                            m_geniviControlIF->getMainConnectionInfoDB(MainID,mainConnectionData);
                            removeConnectionFromMainConnection(mainConnectionData.sourceID, mainConnectionData.sinkID,SubConID);
                        }
                        return E_OK;
                    }
                    else
                    {
                        return E_NON_EXISTENT;
                    }
                }
            }
        }
    }
    if(bFound==false)
    {
        //pass it to usual disconnect
        hookUserDisconnectionRequest(MainID);
    }
    return E_NON_EXISTENT;
}
//daw2hi added 16.6.2017
am_Error_e clGeniviAudioCtrlAdapter::hookUserDisconnectionRequest(am_sourceID_t sourceID, am_sinkID_t sinkID, const am_mainConnectionID_t connectionID)
{
    ETG_TRACE_USR1(("####new### clGeniviAudioCtrlAdapter::hookUserDisconnectionRequest sourceID %d, sinkID %d mainConnectionID %d",sourceID,sinkID, connectionID));
    //get the AudioStack SourceID of given GAM SourceID
    std::map<am_sourceID_t, SourceID >::const_iterator iter = m_registeredSources.find(sourceID);
    if(iter != m_registeredSources.end()) //daw2hi 23.10.2017
    {
        //retVal =  clAudioSMEngine::Source_Off((*iter).second);
        (void)clAudioSMEngine::Source_Off((*iter).second, sinkID,0);
    }else{
        //There is no mapping to AudioStack SourceID
        ETG_TRACE_ERR(("hookUserDisconnectionRequest: No registered SourceID found for GAM Source ID %d", sourceID));
    }

    return E_OK;
}
//end
am_Error_e clGeniviAudioCtrlAdapter::hookUserDisconnectionRequest(const am_mainConnectionID_t mainConnectionID)
{
    ETG_TRACE_USR1(("clGeniviAudioCtrlAdapter::hookUserDisconnectionRequest mainConnectionID %d", mainConnectionID));

    if(m_geniviControlIF==NULL)
    {
        ETG_TRACE_ERR(("m_geniviControlIF==NULL"));
        return E_UNKNOWN;
    }
    clAudioSMEngine::enErrorCode retVal = clAudioSMEngine::AUDIOSM_ERROR;
    am_MainConnection_s mainConnectionData;
    if(E_OK == m_geniviControlIF->getMainConnectionInfoDB(mainConnectionID, mainConnectionData))
    {
        //get the AudioStack SourceID of given GAM SourceID
        std::map<am_sourceID_t, SourceID >::const_iterator iter = m_registeredSources.find(mainConnectionData.sourceID);
        if(iter != m_registeredSources.end())
        {
            retVal =  clAudioSMEngine::Source_Off((*iter).second,mainConnectionData.sinkID,0);
        }else{
            //There is no mapping to AudioStack SourceID
            ETG_TRACE_ERR(("hookUserDisconnectionRequest: No registered SourceID found for GAM Source ID %d", mainConnectionData.sourceID));
        }
        //Check if AudioStack was able to remove
        if(retVal != clAudioSMEngine::AUDIOSM_OK)
        {
            return E_NOT_POSSIBLE;
        }else{
            return E_OK;
        }
    }
    //Connection was not found in Genivi DB
    return E_NON_EXISTENT;
}

am_Error_e clGeniviAudioCtrlAdapter::bSourceConnect(am_sourceID_t SourceId,clAudioSMEngine::enErrorCode & retval)
{
    ETG_TRACE_ERR(("bSourceConnect use sink 1"));
    return bSourceConnect(SourceId,1,retval);
}

am_Error_e clGeniviAudioCtrlAdapter::bSourceConnect(am_sourceID_t SourceId, am_sinkID_t SinkID, clAudioSMEngine::enErrorCode & retval)
{
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::bSourceConnect sourceID %d, sinkID %d",SourceId,SinkID));
    //get the AudioStack SourceID of given GAM SourceID
    std::map<am_sourceID_t, SourceID >::const_iterator iterSource = m_registeredSources.find(SourceId);
    std::map<am_sinkID_t, am_Sink_s >::const_iterator iterSink    = m_registeredSinks.find(SinkID);

    // ToDo: we should also chekc if the sink is registered and reject if it is not
    if(iterSink == m_registeredSinks.end())
    {
        ETG_TRACE_ERR(("Sink %d not found in m_registeredSinks",SinkID));
        //return E_NOT_POSSIBLE;
    }

    if(iterSource != m_registeredSources.end())
    {
        if(clAudioSourceController::bIsSourceOnStack((*iterSource).second,SinkID))
        {
            /*
             * accept src change always (applying stack rules is blocked if project want to
             * accept/deny src change request depending on configuration parameter) (SUZUKI-30143)
             */

            ETG_TRACE_ERR(("bSourceConnect, connection exists, source already on stack, ACCEPTING SRC CHANGE REQUEST"));

        }
        retval = clAudioSMEngine::Source_On((*iterSource).second,SinkID,0); //no defaults anymore
        if(retval != clAudioSMEngine::AUDIOSM_OK)
        {
            ETG_TRACE_ERR(("Source_On() gave error %d",retval));
            return E_NOT_POSSIBLE;
        }

    }
    else
    {
        ETG_TRACE_ERR(("hookUserConnectionRequest: SourceID: %d is not registered at clGeniviAudioCtrlAdapter" , SourceId));
        return E_NOT_POSSIBLE;
    }
    return E_OK;
}

// in this variant we store the route elements
am_Error_e clGeniviAudioCtrlAdapter::setUpRoute(am_Route_s /* route */, am_mainConnectionID_t& /* mainConnectionID */)
{
    //we need to keep also the sub IDs
    return E_OK;
}

//this is to keep track of gateway connections
am_Error_e clGeniviAudioCtrlAdapter::setUpRoute(const am_sourceID_t sourceID,
        const am_sinkID_t sinkID,
        am_mainConnectionID_t& mainConnectionID)
{

    ETG_TRACE_USR4(("setUpRoute mainConnectionID set to %d",mainConnectionID));

    //check if this connection is already existing

    am_connectionID_t connectionID = 0;
    // ToDo: clean up getSubConID() versus bIsSubConnection(), nearly same.
    (void)getSubConID(sourceID, sinkID, connectionID);
    if(connectionID != 0)
    {
        ETG_TRACE_USR4(("setUpRoute connection %d existing in Daemon Database",connectionID));
    }


    //### can we put this in separate function ???? BEGIN

    //Now check if we know already internally about this connection and if we already have a connectionID
    for(unsigned int i = 0; i<m_mainConnectionEntries.size(); i++)
    {
        for(unsigned int k = 0; k<m_mainConnectionEntries[i].subConnectionList.size(); k++)
        {
            if( (m_mainConnectionEntries[i].subConnectionList[k].sourceID == sourceID)
                    && (m_mainConnectionEntries[i].subConnectionList[k].sinkID == sinkID) )
            {
                ETG_TRACE_USR4(("setUpRoute sourceID %d -> sinkID %d known in m_mainConnectionEntries with mainID %d and conID %d",
                        sourceID, sinkID, m_mainConnectionEntries[i].mainID,m_mainConnectionEntries[i].subConnectionList[k].connectionID));
                //we have this mainID already
                if(connectionID==0)
                    connectionID = m_mainConnectionEntries[i].subConnectionList[k].connectionID;
                break;
            }
            else if(m_mainConnectionEntries[i].subConnectionList[k].sinkID == sinkID)
            {
                ETG_TRACE_USR4(("This sink with ID %d already in use in mainID %d and subID %d",sinkID,
                        m_mainConnectionEntries[i].mainID,
                        m_mainConnectionEntries[i].subConnectionList[k].connectionID));
            }
        }
    }
    //### can we put this in separate function ????  END


    //ToDo: search if we have this MainID already. If not create. Else add

    //need to check first if this has to be added or if it is new
    //ToDo: clean this up just temp for one run
    bool bMainID = false;
    unsigned int index=0;
    for(index = 0; index<m_mainConnectionEntries.size(); index++)
    {
        if(m_mainConnectionEntries[index].mainID == mainConnectionID)
        {
            ETG_TRACE_USR4(("setUpRoute mainConnectionID %d already present at pos %d",mainConnectionID,index));
            //we have this mainID already
            bMainID=true;
            break;
        }
    }

    //if(m_mainConnectionEntries.size()==0)
    if(bMainID==false)
    {
        ETG_TRACE_USR4(("add new entry"));
        //its the first

        mainConnectionEntry_s newEntry;
        newEntry.mainID = mainConnectionID;
        am_Connection_s newSubConnection;
        newSubConnection.connectionID=0; //not yet announced (pending)
        if(connectionID != 0)
        {
            ETG_TRACE_USR4(("Using known SubConnection %d",connectionID));
            newSubConnection.connectionID=connectionID;
        }
        newSubConnection.sourceID = sourceID;
        newSubConnection.sinkID = sinkID;
        newEntry.subConnectionList.push_back(newSubConnection);
        m_mainConnectionEntries.push_back(newEntry);
        ETG_TRACE_USR4(("first entry done for MainID %d, SubID %d, Src %d -- Sink %d",mainConnectionID,newSubConnection.connectionID,sourceID,sinkID));
        ETG_TRACE_USR4(("m_mainConnectionEntries.size() =%d",m_mainConnectionEntries.size()));
    }
    else
    {
        ETG_TRACE_USR4(("additional entry for m_mainConnectionEntries[%d].MainID %d (size=%d)",
                index,m_mainConnectionEntries[index].mainID,m_mainConnectionEntries.size()));
        //should be added
        //if(m_mainConnectionEntries[0].mainID == mainConnectionID)
        //MainID at pos index
        bool bSubCon=false;
        for(unsigned int i=0;i<m_mainConnectionEntries[index].subConnectionList.size();i++)
        {
            if(   (m_mainConnectionEntries[index].subConnectionList[i].sourceID == sourceID)
                    &&(m_mainConnectionEntries[index].subConnectionList[i].sinkID == sinkID))
            {
                ETG_TRACE_USR4(("m_mainConnectionEntries[%d].mainID %d: SubCon Src %d -- Sink %d already present",
                        index,mainConnectionID,sourceID,sinkID));
                //we have it already
                bSubCon=true;
                break;
            }
        }
        if(bSubCon==false)
        {
            am_Connection_s newSubConnection;
            newSubConnection.connectionID=0; //not yet announced (pending)
            if(connectionID != 0)
            {
                ETG_TRACE_USR4(("Using known SubConnection %d",connectionID));
                newSubConnection.connectionID=connectionID;
                //need to remove a known sub connection from previous mainConnectionEntry
                removeSubConnectionFromPreviousMainConnectionInternalData(connectionID);
            }
            newSubConnection.sourceID = sourceID;
            newSubConnection.sinkID = sinkID;
            ETG_TRACE_USR4(("Adding SubConnection Src %d -- Sink %d to MainCon %d",sourceID,sinkID,mainConnectionID));
            m_mainConnectionEntries[index].subConnectionList.push_back(newSubConnection);
            ETG_TRACE_USR4(("after adding we have m_mainConnectionEntries[%d].subConnectionList.size() %d",index,m_mainConnectionEntries[index].subConnectionList.size()));
        }

    }

    //end

    return E_OK;
}

am_Error_e clGeniviAudioCtrlAdapter::removeSubConnectionFromPreviousMainConnectionInternalData(am_connectionID_t subConID)
{
    ETG_TRACE_USR4(("removeSubConnectionFromPreviousMainConnectionInternalData for subConID %d",subConID));
    auto it = m_mainConnectionEntries.begin();
    while(it!=m_mainConnectionEntries.end())
    {
        //go through sub connetion list
        for(auto subIt=it->subConnectionList.begin();subIt!=it->subConnectionList.end();subIt++)
        {
            if(subIt->connectionID == subConID)
            {
                ETG_TRACE_USR4(("Found SubConID %d in MainID %d with SubConList size %d",
                        subConID,it->mainID,it->subConnectionList.size()));
                ETG_TRACE_USR4(("sourceID %d, sinkID %d",subIt->sourceID,subIt->sinkID));
                //this is the old one, we remove it from here
                it->subConnectionList.erase(subIt);
                ETG_TRACE_USR4(("New SubConList size %d",it->subConnectionList.size()));
                return E_OK;
            }
        }
        it++;
    }

    ETG_TRACE_USR4(("SubConID %d not found",subConID));
    return E_NON_EXISTENT;
}

tVoid clGeniviAudioCtrlAdapter::vUpdateMultiUsrDataPool(bool bUserProfileChanged)
{
    clAudioSMEngine::vWriteDataPool(bUserProfileChanged);
}


am_Error_e clGeniviAudioCtrlAdapter::getSubConID(const am_sourceID_t sourceID, const am_sinkID_t sinkID, am_connectionID_t& connectionID)
{
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);

    std::vector<am_Connection_s> listConnections;
    if(E_OK != m_geniviControlIF->getListConnections(listConnections))
    {
        return E_DATABASE_ERROR;
    }
    for(unsigned int i=0;i<listConnections.size();i++)
    {
        if( (listConnections[i].sourceID == sourceID) && (listConnections[i].sinkID == sinkID))
        {
            connectionID = listConnections[i].connectionID;
            return E_OK;
        }
    }
    //it is not known
    return E_UNKNOWN;
}

// This returns the first found main connection ID where the given sub connection ID is part of
// ToDo: do we need a list if a sub connection is part of several main connections? (e.g. HU Source to ADR LineOut used twice)
am_Error_e clGeniviAudioCtrlAdapter::getMainConIDFromSubConID(const am_connectionID_t connectionID, am_mainConnectionID_t& mainConnectionID)
{
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);

    //virtual am_Error_e getListMainConnections(std::vector<am_MainConnection_s>& listMainConnections) const =0;
    std::vector<am_MainConnection_s> listMainConnections;
    if(E_OK != m_geniviControlIF->getListMainConnections(listMainConnections))
    {
        return E_DATABASE_ERROR;
    }
    for(unsigned int i=0;i<listMainConnections.size();i++)
    {
        //loop through SubConIDList
        for(unsigned int k=0;k<listMainConnections[i].listConnectionID.size();k++)
        {
            if(listMainConnections[i].listConnectionID[k] == connectionID)
            {
                //This is the main connection which has this sub connection in its connection list
                mainConnectionID=listMainConnections[i].mainConnectionID;
                return E_OK;
            }
        }
    }
    return E_UNKNOWN;
}

// Add the connectionID to the connection list of the given mainConnectionID.
// ToDo: do we need to check if the sub connection is already part of the list
am_Error_e clGeniviAudioCtrlAdapter::updateMainConnectionRoute(const am_mainConnectionID_t mainConnectionID, const am_connectionID_t connectionID)
{
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);
    am_MainConnection_s mainConnectionData;
    if(E_OK == m_geniviControlIF->getMainConnectionInfoDB(mainConnectionID, mainConnectionData))
    {
        mainConnectionData.listConnectionID.push_back(connectionID);
        if(E_OK == m_geniviControlIF->changeMainConnectionRouteDB(mainConnectionID,mainConnectionData.listConnectionID))
        {
            //OK, updated the new mainConnection
            ETG_TRACE_USR2(("Updated MainConnectionID %d, with SubConnectionID %d, new size of SubConList %d",
                    mainConnectionID,connectionID,mainConnectionData.listConnectionID.size()));
            return E_OK;
        }
        else
        {
            return E_UNKNOWN;
        }
    }
    else  return E_DATABASE_ERROR;
}

bool clGeniviAudioCtrlAdapter::isRemoveConnectionRequired(const am_mainConnectionID_t mainConnectionID)
{
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,false);
    //if(m_geniviControlIF==NULL) return false;

    am_MainConnection_s mainConnectionData;
    if(E_OK == m_geniviControlIF->getMainConnectionInfoDB(mainConnectionID, mainConnectionData))
    {
        am_sourceID_t sourceID = mainConnectionData.sourceID;
        am_sinkID_t sinkID = mainConnectionData.sinkID;
        am_Source_s sourceData;
        am_Sink_s sinkData;
        m_geniviControlIF->getSourceInfoDB(sourceID,sourceData);
        m_geniviControlIF->getSinkInfoDB(sinkID,sinkData);
        if(sourceData.domainID != sinkData.domainID)
        {
            //OK now we search for other main Con with same sink
            std::vector<am_MainConnection_s> listMainConnections;
            m_geniviControlIF->getListMainConnections(listMainConnections);
            for(unsigned int i=0;i<listMainConnections.size();i++)
            {
                if(   (listMainConnections[i].mainConnectionID != mainConnectionID)
                        && (listMainConnections[i].sinkID == sinkID) )
                {
                    //yes, same sink for a different main connection
                    return true;
                }
            }
        }
    }
    return false;
}

// Remove a connectionID from the sub connection list of the given mainConnectionID
am_Error_e clGeniviAudioCtrlAdapter::updateMainConnectionRouteRemove(const am_mainConnectionID_t mainConnectionID, const am_connectionID_t connectionID)
{
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);
    //virtual am_Error_e getMainConnectionInfoDB(const am_mainConnectionID_t mainConnectionID, am_MainConnection_s& mainConnectionData) const =0;
    am_MainConnection_s mainConnectionData;
    if(E_OK == m_geniviControlIF->getMainConnectionInfoDB(mainConnectionID, mainConnectionData))
    {
        std::vector<am_connectionID_t>::iterator it;
        it = find(mainConnectionData.listConnectionID.begin(), mainConnectionData.listConnectionID.end(),connectionID);

        if(it != mainConnectionData.listConnectionID.end())
        {
            //we have it, now remove it
            mainConnectionData.listConnectionID.erase(it);

            //virtual am_Error_e changeMainConnectionRouteDB(const am_mainConnectionID_t mainconnectionID, const std::vector<am_connectionID_t>& listConnectionID) =0;
            if(E_OK == m_geniviControlIF->changeMainConnectionRouteDB(mainConnectionID,mainConnectionData.listConnectionID))
            {
                //OK, updated the new mainConnection
                ETG_TRACE_USR2(("Updated MainConnectionID %d, removed SubConnectionID %d, new size of SubConList %d",
                        mainConnectionID,connectionID,mainConnectionData.listConnectionID.size()));
                return E_OK;
            }
            else
            {
                return E_UNKNOWN;
            }
        }
        else
        {
            ETG_TRACE_ERR(("MainConnectionID %d has no SubConnectionID %d",mainConnectionID,connectionID));
            return E_UNKNOWN;
        }
    }
    else  return E_DATABASE_ERROR;
}

// Getter for the member (we need it sometimes outside)
std::vector<mainConnectionEntry_s> clGeniviAudioCtrlAdapter::getMainConnectionEntries()
{
    return m_mainConnectionEntries;
}

// Update the member m_mainConnectionEntries
// we assign the connectionID of an entry in m_mainConnectionEntries based on given sourceID and sinkID.
bool clGeniviAudioCtrlAdapter::updateMainConnectionEntry(const am_mainConnectionID_t mainConnectionID, const am_connectionID_t connectionID,
        const am_sourceID_t sourceID,
        const am_sinkID_t sinkID)
{
    std::vector<mainConnectionEntry_s>::iterator it;
    for(it=m_mainConnectionEntries.begin();it!=m_mainConnectionEntries.end();it++)
    {
        if(it->mainID == mainConnectionID)
        {
            //this is the mainConnection
            std::vector<am::am_Connection_s> subConnectionList = it->subConnectionList;
            std::vector<am::am_Connection_s>::iterator subIt;
            for(subIt=it->subConnectionList.begin();subIt!=it->subConnectionList.end();subIt++)
            {
                //we should have this subConnection, but not yet with a known ID.
                // We want to reuse the old one, hence we need sourceID and sinkID to find it
                if(subIt->sourceID==sourceID && subIt->sinkID==sinkID)
                {
                    if(subIt->connectionID == 0)
                    {
                        //yes, we should update it
                        subIt->connectionID = connectionID;
                        return true;
                    }
                    else
                    {
                        //oh oh, it has already an ID.
                        ETG_TRACE_ERR(("ERROR: Found SubCon but it has ID %d. Will not overwrite",subIt->connectionID));
                        return false;
                    }
                }
            }
            ETG_TRACE_ERR(("ERROR: SubCon %d not found",connectionID));
            return false;
        }

    }
    ETG_TRACE_ERR(("ERROR: MainCon %d not found",mainConnectionID));
    return false;
}

// Remove the subConnection given as connectionID, sourceID, sinkID from the mainConnection given as mainConnectionID
// This is only for the internal Data m_mainConnectionEntries
// ToDo: maybe we do not need to provide all the input parameters (see Fkt. removeSubConnectionFromPreviousMainConnectionInternalData).
bool clGeniviAudioCtrlAdapter::updateMainConnectionEntryRemove(const am_mainConnectionID_t mainConnectionID, const am_connectionID_t connectionID,
        const am_sourceID_t /* sourceID */,
        const am_sinkID_t /* sinkID */)
{
    std::vector<mainConnectionEntry_s>::iterator it;
    for(it=m_mainConnectionEntries.begin();it!=m_mainConnectionEntries.end();it++)
    {
        if(it->mainID == mainConnectionID)
        {
            //this is the mainConnection
            std::vector<am::am_Connection_s>::iterator subIt;
            for(subIt=it->subConnectionList.begin();subIt!=it->subConnectionList.end();subIt++)
            {
                ETG_TRACE_USR4(("we have connectionID %d",subIt->connectionID));
                //we should have this SubCon
                if(subIt->connectionID == connectionID)
                {
                    //yes its here, set it 0 (is that enough?)
                    subIt->connectionID =0;
                    //not enough, we delete it
                    ETG_TRACE_USR4(("Erasing connectionID %d, size before %d",connectionID,it->subConnectionList.size()));
                    it->subConnectionList.erase(subIt);
                    ETG_TRACE_USR4(("Erasing connectionID size after %d",it->subConnectionList.size()));
                    return true;
                }
            }
            //we can leave if it is not in the list But that should be an error
            ETG_TRACE_ERR(("SubID %d not active in MainCon %d",connectionID,mainConnectionID));
            return false;
        }
        ETG_TRACE_ERR(("MainCon %d not found",mainConnectionID));
        return false;
    }
    ETG_TRACE_ERR(("No m_mainConnectionEntries at all ??"));

    return false;
}

void clGeniviAudioCtrlAdapter::printInternalMainConnectionEntries()
{
    std::vector<mainConnectionEntry_s>::iterator it;
    for(it = m_mainConnectionEntries.begin();it != m_mainConnectionEntries.end(); it++)
    {
        ETG_TRACE_USR4(("m_mainConnectionEntries.mainID = %d",(*it).mainID));
        for(unsigned int i=0;i<(*it).subConnectionList.size();i++)
        {
            ETG_TRACE_USR4(("SubID %d: sourceID %d, sinkID %d",
                    (*it).subConnectionList[i].connectionID,
                    (*it).subConnectionList[i].sourceID,
                    (*it).subConnectionList[i].sinkID));
        }
    }

}

am_Error_e clGeniviAudioCtrlAdapter::hookUserConnectionRequest(const am_sourceID_t sourceID,
        const am_sinkID_t sinkID,
        am_mainConnectionID_t& mainConnectionID)
{
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);
    //check if sinkID is valid
    if(E_OK != clGeniviAudioCtrlAdapter::isValidSinkID(sinkID))
    {
        ETG_TRACE_ERR(("hookUserConnectionRequest: sinkID: %d is not registered at clGeniviAudioCtrlAdapter" , sinkID));
        return E_NOT_POSSIBLE;
    }

    ETG_TRACE_USR4(("hookUserConnectionRequest: SourceID %d -> SinkID %d with mainConnectionID %d",sourceID,sinkID,mainConnectionID));

    //if this SubConnection is existing in some other main, then just enter it here and update the daemon
    am_mainConnectionID_t tempMainID = 0;
    if(false == clAudioSourceController::getInstance().bIsTopOfBackUpStackMuteAndOn())
    {

        if(false == bIsMainConnection(sourceID,sinkID,tempMainID))
        {
            am_connectionID_t connectionID=0;
            //this gives the sub connectionID from daemon data if it exists
            if(E_OK == getSubConID(sourceID,sinkID,connectionID))
            {
                //already existing ??
                ETG_TRACE_USR4(("hookUserConnectionRequest: SourceID %d -> SinkID %d is existing as sub connactionID %d",
                        sourceID,sinkID,connectionID));
                //already known, then get mainConnID
                //get the first mainConnectionID which has this sub connection
                //ToDo: we could have more than one main connection. This is not yet considered
                if(E_OK == getMainConIDFromSubConID(connectionID, tempMainID))
                {
                    ETG_TRACE_USR4(("hookUserConnectionRequest: SourceID %d -> SinkID %d found sub connectionID %d in mainConnectionID %d",
                            sourceID,sinkID,connectionID,tempMainID));

                    //this subConID is known in tempMainID
                    if(tempMainID != mainConnectionID)
                    {
                        //and it is different
                        updateMainConnectionRoute(mainConnectionID, connectionID);
                        //update our tracking
                        updateMainConnectionEntry(mainConnectionID,connectionID, sourceID, sinkID);


                        //we can do this only if we have still two main connections with gateway and with same sink or different source
                        // FM -> AMP_A
                        // FM -> ADR
                        // AVB_In -> AMP_A (this one has to be removed just from lists, not the connection itself)
                        //
                        // AUX -> AMP_A
                        // AUX -> ADR
                        // AVB_In -> AMP_A

                        //enable for debug if needed
                        //std::vector<am_MainConnection_s> listMainConnections;
                        //am_Error_e err = m_geniviControlIF->getListMainConnections(listMainConnections);

                        if(true == isRemoveConnectionRequired(tempMainID))
                        {
                            updateMainConnectionRouteRemove(tempMainID, connectionID);
                            updateMainConnectionEntryRemove(tempMainID,connectionID, sourceID, sinkID);
                        }
                    }
                }
            }
            else
            {
                ETG_TRACE_USR4(("Connection sourceID %d -> sinkID %d not known",sourceID,sinkID));
            }

        }
        else
        {
            //it is a main connection but is it a different one?
            if(tempMainID != mainConnectionID)
            {
                //mainConnectionID = tempMainID; //ToDo: check if needed for DBus RAL and if OK for Inf4CV
                ETG_TRACE_USR4(("hookUserConnectionRequest: SourceID %d -> SinkID %d is existing as mainConnectionID %d",
                        sourceID,sinkID,tempMainID));
                return E_OK;
            }
        }
    }

    ETG_TRACE_USR4(("hookUserConnectionRequest: Source %d --> Sink %d for MainConn %d",sourceID,sinkID,mainConnectionID));
    clAudioSMEngine::enErrorCode retVal = clAudioSMEngine::AUDIOSM_ERROR;

    am_Error_e errFlag = E_UNKNOWN;

    clAudioSource* poAudioSource = NULL;
    poAudioSource = clAudioSourceFactory::getAudioSource(sourceID);

    clSourceClass oSrcClass = poAudioSource->getSourceClass();
    //check if we have
    am_Source_s sourceData;

    sourceData.name = "EMPTY";
    sourceData.name = poAudioSource->pacGetName();
    ETG_TRACE_USR4(("hookUserConnectionRequest: Source %s",sourceData.name.c_str()));
    if((sourceData.name == "MIC_PRIVATE") && ((sinkID == 101) || (sinkID == midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_LINE_OUT)))
    {
       am_Error_e ret = E_UNKNOWN;
       bool bMutestate = true;
       ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::pSrcClass_Mute, ADDED setting MUTE_MICROPHONE %d",bMutestate));
       const clSourceClass* pSrcClass_MuteNonCabin = clFactory_AudioSourceClass::GetSourceClass("MUTE_MICROPHONE_NON_CABIN");
       iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_UNKNOWN);
       iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(pSrcClass_MuteNonCabin,E_UNKNOWN);

       if(m_sinkList.size()>0)
       {
          std::map<unsigned int, struct sinkData>::iterator it = m_sinkList.begin();
          for(it=m_sinkList.begin(); it!=m_sinkList.end();it++)
          {
            if((it->second).s_sink.sinkID != 0 && (it->second).s_sink.visible == true)
            {
                 if((it->second).s_sink.domainID == 1)
                 {
                    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::pSrcClass_MuteNonCabin, ADDED setting MUTE_MICROPHONE_NON_CABIN ON Early for SinkID %d",(it->second).s_sink.sinkID));
                    ret = RequestSourceOn(SourceID(pSrcClass_MuteNonCabin->getClassID(),0),(it->second).s_sink.sinkID);
                 }
            }
          }
       }
       errFlag = ret ;
       ETG_TRACE_USR4(("hookUserConnectionRequest: bSourceConnect Called with sourceID %d",sourceID));
       usleep(200000); //HACK to avoid fast update
       errFlag = bSourceConnect(sourceID,sinkID,retVal);
    }
    else
    {
       ETG_TRACE_USR4(("hookUserConnectionRequest: bSourceConnect Called"));
       errFlag = bSourceConnect(sourceID,sinkID,retVal);
    }

    if(E_OK == errFlag)
    {
        //OK, connection is allowed
        if(retVal == clAudioSMEngine::AUDIOSM_OK)
        {
            if(bIsMainConnection(sourceID, sinkID, mainConnectionID) == true)
            {
                ETG_TRACE_USR4(("Ups, we think this Src %d -- Sink %d is a main connection (%d) ???",sourceID,sinkID,mainConnectionID));
                //if this is a MainConnection
                return E_OK;
            }
            else
            {
                //ETG_TRACE_USR4(("Err(%d): No MainConnection need to add to MainConnectionID %d",tmpErr,mainConnectionID));
                ETG_TRACE_USR4(("No MainConnection"));
                am_Source_s sourceData;
                am_Error_e err = m_geniviControlIF->getSourceInfoDB(sourceID,sourceData);
                ETG_TRACE_USR4(("Source %s",sourceData.name.c_str()));
                ETG_TRACE_USR4(("is visible %d",sourceData.visible));

                am_Sink_s sinkData;
                am_Error_e sinkErr = m_geniviControlIF->getSinkInfoDB(sinkID,sinkData);
                if(sinkErr != E_OK)
                {
                    ETG_TRACE_ERR(("m_geniviControlIF->getSinkInfoDB for sinkID %d, gave sinkErr %d",sinkID,sinkErr));
                }
                ETG_TRACE_USR4(("Sink %s",sinkData.name.c_str()));
                ETG_TRACE_USR4(("is visible %d",sinkData.visible));

                //daw2hi 9.8.2017 if sink is visible, would this be the right place to call VolumeManager with StartAudioSource
                //but then we need to use the visible source and need to convert it first to CCA values

                //daw2hi 1.12.2017 start
                //enable for debug start
                //				am_mainConnectionID_t dummyMainID = 0;;
                //				if(false == bIsMainConnection(sourceID,sinkID,dummyMainID))
                //				{
                //					ETG_TRACE_USR4(("bIsMainConnection for SourceID %d - SinkID %d gave false",sourceID,sinkID));
                //				}
                //				else
                //				{
                //					ETG_TRACE_USR4(("bIsMainConnection for SourceID %d - SinkID %d gave true MainID %d",sourceID,sinkID,dummyMainID));
                //				}

                //				std::vector<am_mainConnectionID_t> dummyMainIDList;
                //				am_connectionID_t subConnectionID=0;
                //				if(false == bIsSubConnection(sourceID,sinkID,subConnectionID,dummyMainIDList))
                //				{
                //					ETG_TRACE_USR4(("bIsSubConnection for SourceID %d - SinkID %d gave false",sourceID,sinkID));
                //				}
                //				else
                //				{
                //					//check for all in list
                //					for(int i=0;i<dummyMainIDList.size();i++)
                //					{
                //						ETG_TRACE_USR4(("bIsSubConnection for SourceID %d - SinkID %d gave true and is in MainID[%d] %d",
                //								sourceID,sinkID,i,dummyMainIDList[i]));
                //					}
                //				}
                //enable for debug end
                //just for Debug
                printInternalMainConnectionEntries();

                if((sourceData.visible) && (sinkData.visible))  //daw2hi 6.6.2017 add check for sink visible
                {
                    ETG_TRACE_USR4(("Adding MainConnection for Source %s",sourceData.name.c_str()));
                    ETG_TRACE_USR4(("Src %d --> Sink %d, MainCon %d",sourceID, sinkID, mainConnectionID));
                    err = addMainConnection(sourceID,sinkID, mainConnectionID);
                    ETG_TRACE_USR4(("After addMainConnection: MainCon %d, err %d",mainConnectionID,err));
                    return err;
                }
                else
                {
                    ETG_TRACE_USR4(("Source ID %d %s",sourceData.sourceID,sourceData.name.c_str()));
                    ETG_TRACE_USR4(("Sink ID %d %s",sinkData.sinkID,sinkData.name.c_str()));
                    ETG_TRACE_USR4(("Source and or Sink not visible, is this a SubConnection of MainConnectionID %d",mainConnectionID));
                    //need to add it as sub conn

                    am_MainConnection_s mainConnectionData;
                    err = m_geniviControlIF->getMainConnectionInfoDB(mainConnectionID,mainConnectionData);
                    ETG_TRACE_USR4(("MainConID %d, SubCon size %d, err %d",mainConnectionID,mainConnectionData.listConnectionID.size(),err));
                    printSubConnections(mainConnectionData.listConnectionID);
                    printAllConnections();
                    return E_OK;
                }
            }
        }
        else
        {
            ETG_TRACE_ERR(("hookUserConnectionRequest: AudioStack returns Error %d for connection request of SourceID: %d" , sourceID, retVal));
            return E_UNKNOWN;
        }
        return E_UNKNOWN; //to fix lint
    }
    else
    {
        ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::hookUserConnectionRequest: bSourceConnect for mainConnectionID %d, gave error %d",mainConnectionID,errFlag));
        //need to clean up mainConnectionID??
        ETG_TRACE_ERR(("m_geniviControlIF->removeMainConnectionDB(%d)",mainConnectionID));
        m_geniviControlIF->removeMainConnectionDB(mainConnectionID);
    }
    return errFlag;
}

am_Error_e clGeniviAudioCtrlAdapter::RequestSourceOff(midw_fi_tcl_e8_AudSource::tenType , tU16 )
{
    return E_OK;
}

am_Error_e clGeniviAudioCtrlAdapter::RequestSourceOff(SourceID srcID)
{
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::RequestSourceOff u8GetSinkID(srcID) %d",u8GetSinkID(srcID)));
    
    clAudioSource* pSrc = clAudioSourceFactory::isSourceInstantiated(srcID);
    if(pSrc!=NULL)
    {
        const clSourceClass srcClass =  pSrc->getSourceClass();
        ETG_TRACE_USR1(("Sink class %s",srcClass.getName().c_str()));
        
	if(srcClass.m_u16PrivateModeList.size()!=0)
        {
            ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::RequestSourceOff for Source, off on sink 1 and sink 2"));
            RequestSourceOff(srcID,1);
            RequestSourceOff(srcID,2);
            return E_OK;
        }
        if(u8GetSinkID(srcID) != pSrc->u16GetCurActSink()) //this could be used in general
        {
            // Limit special handling to phone, maybe we need it for all
            ETG_TRACE_USR2(("Source %s",pSrc->pacGetName()));
            ETG_TRACE_USR2(("Off Request: priv mode sinkID %d, but source is active on %d, removing from active sinkID",
                    u8GetSinkID(srcID),pSrc->u16GetCurActSink()));
            return RequestSourceOff(srcID,pSrc->u16GetCurActSink());
        }
        else
        {
            ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::RequestSourceOff srcClassID %d, SubSource %d, u8GetSinkID %d",
                    srcID.enSourceClass,srcID.u16SubSource,u8GetSinkID(srcID)));

            return RequestSourceOff(srcID,(tU16)u8GetSinkID(srcID));
        }
    }
    return E_NOT_POSSIBLE;
}

am_Error_e clGeniviAudioCtrlAdapter::RequestSourceOff(SourceID srcID, tU16 sinkID)
{
    const stSourceType& srcType = clFactory_AudioSourceClass::GetType(srcID);
    if((srcType.exclusive) && (!srcType.stackable))
    {
        // we are not allowing source off for Entertainment (previously only blocked in SMEngine,
        // but now conflicting with CRQ CMG3G-10573, (related bug NCG3D-23032)
        ETG_TRACE_USR4(("This is Entertainment. Would block it for calls via ARL here"));
        return E_NOT_POSSIBLE;
    }
    if( clAudioSMEngine::Source_Off(srcID, sinkID) == clAudioSMEngine::AUDIOSM_OK)
    {
        return E_OK;
    }
    return E_NOT_POSSIBLE;
}

am_Error_e clGeniviAudioCtrlAdapter::RequestSourceOff(const am_sourceID_t sourceID)
{
    std::map<am_sourceID_t, SourceID >::const_iterator iter = m_registeredSources.find(sourceID);
    if(iter != m_registeredSources.end())
    {
        return RequestSourceOff((*iter).second);
    }
    return E_NOT_POSSIBLE;
}

am_Error_e clGeniviAudioCtrlAdapter::RequestSourcePause(SourceID srcID)
{
    (void) srcID;
    ETG_TRACE_ERR(("ERROR: RequestSourcePause actually not supported"));
    return E_NOT_USED;
}

am_Error_e clGeniviAudioCtrlAdapter::RequestSourceOn(SourceID srcID)
{
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::RequestSourceOn for sink %d, but source has mode dependant sinks",u8GetSinkID(srcID)));
    const clSourceClass srcClass = clFactory_AudioSourceClass::GetSourceClass(srcID.enSourceClass);

    clAudioSource* poAudioSource = NULL;
    poAudioSource = clAudioSourceFactory::getAudioSource(srcID);

    clSourceClass oSrcClass = poAudioSource->getSourceClass();
    //check if we have
    am_Source_s sourceData;
    am_Error_e err= E_OK;

    sourceData.name = "EMPTY";
    sourceData.name = poAudioSource->pacGetName();

    if(srcClass.m_u16PrivateModeList.size()!=NULL)
    {
    	if((sourceData.name.compare(0,6,"PHONE#")==0)
           || (sourceData.name.compare(0,9,"INTERCOM#")==0)
           || (sourceData.name == "PHONE_OUTBAND_RING")
           || (sourceData.name == "SDS_SPEECHRECOGNITION") )
        {
            ETG_TRACE_USR4(("RequestSourceOn source %s",sourceData.name.c_str()));
            if(clFactory_AudioSourceClass::GetType(srcID).name.compare("mix")==0)
            {
                ETG_TRACE_USR4(("source is a mix"));
                if(u8GetSinkID(srcID)==1)
                {
                    ETG_TRACE_USR4(("mute mix on sink 2"));
                    //mute mix on HP
                    m_clientHandlerFcAudioMgr->vSetMute(
                                               midw_fi_tcl_e8_MuteRequester::FI_EN_GENIVIAUDIOMANAGER,
                                               midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_HP,
                                               midw_fi_tcl_e8MuteAction::FI_EN_MUTE,
                                               1,//not used
                                               midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_MIX);
                }
                else if(u8GetSinkID(srcID)==2)
                {
                    ETG_TRACE_USR4(("mute mix on sink 1"));
                    //mute mix on LS
                    m_clientHandlerFcAudioMgr->vSetMute(
                                               midw_fi_tcl_e8_MuteRequester::FI_EN_GENIVIAUDIOMANAGER,
                                               midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS,
                                               midw_fi_tcl_e8MuteAction::FI_EN_MUTE,
                                               1,//not used
                                               midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_MIX);
               }
           }
       }
    }
    return RequestSourceOn(srcID, (tU16)u8GetSinkID(srcID));
}

am_Error_e clGeniviAudioCtrlAdapter::RequestSourceOn(SourceID srcID, tU16 sinkID)
{
    // we could check for the sinks here and reject if sink not found
    if(E_OK != isValidSinkID(sinkID))
    {
        //Sink not found, reject
        return E_NOT_POSSIBLE;
    }

    am_sourceID_t gamSrcID = getGeniviSourceIDFromInternalSourceID(srcID);
    if(gamSrcID != 0)
    {
        if(true == m_ControlSenderBase->checkMicrophoneConflict(gamSrcID, sinkID))
        {
            //we have to reject
            return E_NOT_POSSIBLE;
        }
    }



    if( clAudioSMEngine::Source_On(srcID, sinkID, 0) == clAudioSMEngine::AUDIOSM_OK)
    {
        return E_OK;
    }
    return E_NOT_POSSIBLE;
}

//ToDo check if we have already something like this
am_sourceID_t clGeniviAudioCtrlAdapter::getGeniviSourceIDFromInternalSourceID(SourceID srcID)
{
    std::map<am_sourceID_t, SourceID >::const_iterator iter;
    for(auto it=m_registeredSources.begin();it !=m_registeredSources.end();it++)
    {
        if(it->second == srcID)
        {
            return it->first;
        }
    }
    return (am_sourceID_t)0;
}


am_Error_e clGeniviAudioCtrlAdapter::RequestSourceOn(const am_sourceID_t sourceID)
{
    std::map<am_sourceID_t, SourceID >::const_iterator iter = m_registeredSources.find(sourceID);
    if(iter != m_registeredSources.end())
    {
        return RequestSourceOn((*iter).second);
    }
    return E_NOT_POSSIBLE;
}

#if 1
am_Error_e clGeniviAudioCtrlAdapter::SourceActivityRequest(midw_fi_tcl_e8_AudSource::tenType source
        , tU16 subSource
        , midw_fi_tcl_e8_AudSource::tenType possibleNextSource
        , midw_fi_tcl_e8_SrcActivity::tenType activity
        , midw_fi_tcl_e8_ResourceNo::tenType sink)
{
    am_Error_e retVal = E_OK;
    if(m_clientHandlerAudioRouteMgr != NULL)
    {
        m_clientHandlerAudioRouteMgr->vSourceRouteActivity_Set(
                static_cast<uint8_t>(source)
                , static_cast<uint16_t>(subSource)
                , static_cast<uint8_t>(possibleNextSource)
                , static_cast<uint8_t>(sink)
                , static_cast<uint8_t>(activity));
    }
    return retVal;
}
#endif
am_Error_e clGeniviAudioCtrlAdapter::SourceActivityRequest(midw_fi_tcl_e8_AudSource::tenType source
        , tU16 subSource
        , midw_fi_tcl_e8_AudSource::tenType possibleNextSource
        , midw_fi_tcl_e8_SrcActivity::tenType activity)
{

    ETG_TRACE_ERR(("SourceActivityRequest called without sink"));
    am_Error_e retVal = E_OK;
    if(m_clientHandlerAudioRouteMgr != NULL)
    {
        m_clientHandlerAudioRouteMgr->vSourceRouteActivity_Set(
                static_cast<uint8_t>(source)
                , static_cast<uint16_t>(subSource)
                , static_cast<uint8_t>(possibleNextSource)
                , static_cast<uint8_t>(midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS)
                , static_cast<uint8_t>(activity));
    }
    return retVal;
}

am_Error_e clGeniviAudioCtrlAdapter::removeConnectionIDFromMainConnectionEntry(am::am_connectionID_t connectionID)
{
    ETG_TRACE_USR4(("removeConnectionIDFromMainConnectionEntry connectionID = %d",connectionID));

    std::vector<mainConnectionEntry_s>::iterator it;
    for(it=m_mainConnectionEntries.begin();it!=m_mainConnectionEntries.end();it++)
    {
        //this is the mainConnection
        std::vector<am::am_Connection_s> subConnectionList = it->subConnectionList;
        std::vector<am::am_Connection_s>::iterator subIt;
        for(subIt=it->subConnectionList.begin();subIt!=it->subConnectionList.end();subIt++)
        {
            //we should have this subConnection, but not yet with a known ID.
            // We want to reuse the old one, hence we need sourceID and sinkID to find it
            if(subIt->connectionID == connectionID)
            {
                ETG_TRACE_USR4(("removeConnectionIDFromMainConnectionEntry found connectionID %d in mainID %d, remove it",connectionID, it->mainID));
                it->subConnectionList.erase(subIt);
                break; //can be there only once but might be present also in another main connection
            }
        }
    }
    return E_OK;
}

am_Error_e clGeniviAudioCtrlAdapter::informVolumeManager(am_connectionID_t connectionID)
{
    ETG_TRACE_USR4(("informVolumeManager connectionID %d",connectionID));

    static am_Source_s sourceData;
    static am_Sink_s sinkData;

    sourceData.name = "EMPTY";
    sinkData.name = "EMPTY";

    ETG_TRACE_USR4(("informVolumeManager source %s",sourceData.name.c_str()));
    ETG_TRACE_USR4(("informVolumeManager sink   %s",sinkData.name.c_str()));

    std::vector<am_Connection_s> listConnections;
    (void)m_geniviControlIF->getListConnections(listConnections);
    for(unsigned int i =0; i<listConnections.size();i++)
    {
        if(listConnections[i].connectionID == connectionID)
        {
            ETG_TRACE_USR4(("informVolumeManager found connection"));
            //this is our connection. We need to forom for all connection towards sink17 and all with sources AVB_Mic2/3
            m_geniviControlIF->getSourceInfoDB(listConnections[i].sourceID, sourceData);
            if( (sourceData.name == "AVB_Mic2") || (sourceData.name == "AVB_Mic3") )
            {
                m_geniviControlIF->getSinkInfoDB(listConnections[i].sinkID, sinkData);
                // inform VolumeManager
                //clGeniviAudioCtrlAdapter::getVolumeManager()->vDisconnectAudioSource(sinkData.name,sourceData.name);
                ETG_TRACE_USR4(("call audioSourceRequest"));
                clGeniviAudioCtrlAdapter::getVolumeManager()->audioSourceRequest(sourceData.name,"MUTE",sinkData.name);
            }
            else
            {
                m_geniviControlIF->getSinkInfoDB(listConnections[i].sinkID, sinkData);
                if(listConnections[i].sinkID == 17)
                {
                    m_geniviControlIF->getSourceInfoDB(listConnections[i].sourceID, sourceData);
                    //inform VolumeManager
                    std::string sinkNameToUse("AMP_A");
                    //clGeniviAudioCtrlAdapter::getVolumeManager()->vDisconnectAudioSource(sinkNameToUse,sourceData.name);
                    ETG_TRACE_USR4(("call audioSourceRequest sinkID 17"));
                    //clGeniviAudioCtrlAdapter::getVolumeManager()->audioSourceRequest(sinkNameToUse,"MUTE",sourceData.name);
                    //daw2hi 10.12.2020
                    clGeniviAudioCtrlAdapter::getVolumeManager()->audioSourceRequest(sourceData.name,"MUTE",sinkNameToUse);
                }
            }
        }

    }

    return E_OK;
}

am_Error_e clGeniviAudioCtrlAdapter::disconnect(am_Handle_s& handle, am_connectionID_t connectionID)
{
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);
    am_Error_e retVal = E_UNKNOWN;
    if(m_geniviControlIF==NULL)
    {
        return retVal;
    }
    ETG_TRACE_USR4(("disconnect: request at GAM  with handle (type %d/%d), connectionID: %d", handle.handleType, handle.handle, connectionID));
    //ToDo check the corresponding mainConnection
    printAllConnections();
    //bAckdisconnect is called before returning from method call

    clGeniviAudioCtrlAdapter::informVolumeManager(connectionID);

    retVal = m_geniviControlIF->disconnect(handle, connectionID);
    ETG_TRACE_USR4(("disconnect: after daemon call with err %d",retVal));
    printAllConnections();

    ETG_TRACE_USR4(("disconnect: executed at GAM with handle (type %d/%d), connectionID: %d", handle.handleType, handle.handle, connectionID));
    return retVal;
}

am_Error_e clGeniviAudioCtrlAdapter::connect(am_Handle_s& handle,
        am_connectionID_t& connectionID,
        am_CustomConnectionFormat_t format,
        am_sourceID_t sourceID,
        am_sinkID_t sinkID)
{
    am_Error_e err = E_UNKNOWN;
    if(m_geniviControlIF==NULL)
    {
        return E_UNKNOWN;
    }

    //ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::connect"));
    //ETG_TRACE_USR4(("handle %d.%d",handle.handleType, handle.handle));
    //ETG_TRACE_USR4(("connectionID %d, sourceID %d --> sinkID %d",connectionID,sourceID,sinkID));

    connectionID=0;
    handle.handleType = H_UNKNOWN;
    handle.handle = 0;

    if(clGeniviAudioCtrlAdapter::getSubConID(sourceID,sinkID,connectionID)!=E_OK)
    {

        err = m_geniviControlIF->connect(handle, connectionID, format, sourceID, sinkID);

        ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::connect after m_geniviControlIF->connect() with ret %d",err));
        ETG_TRACE_USR4(("handle %d.%d",handle.handleType, handle.handle));
        ETG_TRACE_USR4(("connectionID %d, sourceID %d --> sinkID %d",connectionID,sourceID,sinkID));
    }
    else
        err = E_ALREADY_EXISTS;

    printAllMainConnections();
    printAllConnections();

    //OK, now check if this is in our subconnection list
    bool bFound=false;
    am_mainConnectionID_t mainID=0;
    std::vector<mainConnectionEntry_s>::iterator it;
    for(it=m_mainConnectionEntries.begin();it!=m_mainConnectionEntries.end();it++)
    {
        ETG_TRACE_USR4(("Loop m_mainConnectionEntries: MainID %d",it->mainID));
        std::vector<am::am_Connection_s> subConnectionList = it->subConnectionList;
        std::vector<am::am_Connection_s>::iterator subIt;

        for(subIt=it->subConnectionList.begin();subIt!=it->subConnectionList.end();subIt++)
        {
            ETG_TRACE_USR4(("Loop subConnectionList: ID %d: source %d -- sink %d",subIt->connectionID,subIt->sourceID,subIt->sinkID));
            if((subIt->sourceID==sourceID) && (subIt->sinkID==sinkID))
            {
                ETG_TRACE_USR4(("Found SubConnection, assign ID %d",connectionID));
                //yes, this is pending
                subIt->connectionID = connectionID;
                mainID = it->mainID;
                bFound=true;
                break;
            }
        }
    }
    ETG_TRACE_USR4(("mainID is %d, bFound is %d",mainID,bFound));
    printAllMainConnections();

    return err;
}



tVoid clGeniviAudioCtrlAdapter::cbAckDisconnect(const am_Handle_s handle, const am_Error_e errorID)
{
    ETG_TRACE_USR4(("cbAckDisconnect: Handletype: 0x%x Handlevalue: %d Error: %d", handle.handleType, handle.handle, errorID));
    printAllConnections();
    //Let's see if we find out for whom this is
    std::map<am_sourceID_t, SourceID >::iterator it;
    for(it = m_registeredSources.begin(); it != m_registeredSources.end(); ++it)
    {
        clAudioSource* pSrc = clAudioSourceFactory::getAudioSource(it->second);
        if(pSrc) pSrc->vCbAckDisconnect(&handle);

    }
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::cbAckDisConnect: handle (type %d/%d) Error: %d", handle.handleType, handle.handle, errorID));
}

tVoid clGeniviAudioCtrlAdapter::cbAckConnect(const am_Handle_s handle, const am_Error_e errorID)
{
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::cbAckConnect handle %d.%d",handle.handleType,handle.handle));
    //Let's see if we find out for whom this is
    std::map<am_sourceID_t, SourceID >::iterator it;
    for(it = m_registeredSources.begin(); it != m_registeredSources.end(); ++it)
    {
        clAudioSource* pSrc = clAudioSourceFactory::getAudioSource(it->second);

        if((pSrc) && (errorID != E_OK))
        {
            tU16 sink = pSrc->u16GetCurActSink();
            const tChar* pName = pSrc->pacGetName();
            const am_Handle_s* pHandle = pSrc->getHandle(&handle);
            if(    (pHandle != NULL)
                && (pHandle->handleType == handle.handleType)
                && (pHandle->handle     == handle.handle))
            {
                std::vector<am_MainConnection_s> listMainConnections;

                ETG_TRACE_USR4(("Searching all main connections for...."));
                am_Error_e err = m_geniviControlIF->getListMainConnections(listMainConnections);
                for(unsigned int i=0;i<listMainConnections.size();i++)
                {
                    if(listMainConnections[i].sinkID == (am_sinkID_t)sink)
                    {
                        //ETG_TRACE_USR4(("Reset Stack for sink %d",sink));
                        //clAudioSMEngine::vResetStack(sink);
                        //removeMainConnectionDB(listMainConnections[i].mainConnectionID);
                        //or better
                        ETG_TRACE_USR4(("removeConnectionFromMainConnectionInternal sourceID %d, sinkID %d, MainID %d",
                                listMainConnections[i].sourceID,
                                listMainConnections[i].sinkID,
                                listMainConnections[i].mainConnectionID));

                        removeFailedConnectionFromInternalData(listMainConnections[i].sourceID,
                                listMainConnections[i].sinkID,listMainConnections[i].mainConnectionID);
                        pSrc->vReset();
                    }
                }


                //Try to disconnect if ack was received with error
                //find corresponding main ID
                //disConnectionMsg_t disConnectionMsg;
                //disConnectionMsg.mainConnectionID=4;
                //m_ControlSenderBase->disConnectionMsgList.push_back(disConnectionMsg);
            }
        }
        // It should be valid only for one AudioSource
        else if(pSrc) pSrc->vCbAckConnect(&handle);

#if 0
        //ToDo: check if it is worth to call AudioSource with handle and to receive back a true if it is the right AudioSource
        // then we can leave the loop after first hit, there should not be another one
        am_Handle_s* pHandle = pSrc->getHandle(&handle);
        if(pHandle != NULL)
        {
            pSrc->vCbAckConnect(&handle);
            break;
        }
#endif
    }
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::cbAckConnect: Handletype: 0x%x Handlevalue: 0x%x Error: %d", handle.handleType, handle.handle, errorID));
}

am_Error_e clGeniviAudioCtrlAdapter::removeFailedConnectionFromInternalData(am_sourceID_t sourceID, am_sinkID_t sinkID, am_mainConnectionID_t mainConnectionID)
{
    for(unsigned int i =0; i<m_mainConnectionEntries.size();i++)
    {
        if(m_mainConnectionEntries[i].mainID == mainConnectionID)
        {
            ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::removeFailedConnectionFromInternalData"));
            ETG_TRACE_USR4(("mainID %d, sourceID %d, sinkID %d, subConList size %d",
                    mainConnectionID,sourceID,sinkID,m_mainConnectionEntries[i].subConnectionList.size()));
            //found our main connection in the internal data
            for(unsigned int k=0;k<m_mainConnectionEntries[i].subConnectionList.size();k++)
            {
                if(   (m_mainConnectionEntries[i].subConnectionList[k].sourceID == sourceID)
                   && (m_mainConnectionEntries[i].subConnectionList[k].sinkID == sinkID) )
                {
                    ETG_TRACE_USR4(("Found matching SubConnection %d",m_mainConnectionEntries[i].subConnectionList[k].connectionID));
                    //erase the main ID with the sub connection
                    m_mainConnectionEntries.erase(m_mainConnectionEntries.begin()+i);
                    return E_OK;
                }
            }
        }
    }
    return E_NOT_POSSIBLE;
}

am_Error_e clGeniviAudioCtrlAdapter::changeMainConnectionRouteDB(am_sourceID_t sourceID,  std::vector<am_connectionID_t>& listConnectionID)
{
    ETG_TRACE_USR4(("changeMainConnectionRouteDB sourceID %d use default sinkID 1",sourceID));
    return changeMainConnectionRouteDB(sourceID, (am_sinkID_t)1, listConnectionID);
}
am_Error_e clGeniviAudioCtrlAdapter::changeMainConnectionRouteDB(am_sourceID_t sourceID, am_sinkID_t sinkID, std::vector<am_connectionID_t>& listConnectionID)
{
    ETG_TRACE_USR4(("changeMainConnectionRouteDB sourceID %d --> sinkID %d, listConnectionID.size %d",sourceID,sinkID,listConnectionID.size()));

    for(unsigned int i=0;i<listConnectionID.size();i++)
    {
        ETG_TRACE_USR4(("listConnectionID[%d]=%d",i,listConnectionID[i]));
    }

    printAllConnections();
    printSubConnections(listConnectionID);
    if(m_geniviControlIF==NULL)
    {
        return E_UNKNOWN;
    }
    am_mainConnectionID_t mainconnectionID=0;
    am_Error_e ret = E_OK;
    // new
    if(bIsMainConnection(sourceID,sinkID,mainconnectionID)==false)
    {
        am_connectionID_t subConnectionID=0;
        std::vector<am_mainConnectionID_t> mainConnectionIDList;
        //if it is not a main connection, we check ifsourceID / sinkID is involved in another main connection
        if(bIsSubConnection(sourceID, sinkID, subConnectionID, mainConnectionIDList))
        {
            ETG_TRACE_USR4(("sourceID %d -> sinkID %d is connectionID %d",sourceID,sinkID,subConnectionID));
            for(unsigned int i=0;i<mainConnectionIDList.size();i++)
            {
                ETG_TRACE_USR4(("mainConnectionIDList[%d] = %d",i, mainConnectionIDList[i]));
            }
        }
        else
        {
            ETG_TRACE_USR4(("sourceID %d -> sinkID %d is no connection",sourceID,sinkID));
        }
        if(bIsSourcOrSinkPartOfMainConnection(sourceID,sinkID,mainConnectionIDList))
        {
            ETG_TRACE_USR4(("sourceID %d -> sinkID %d is part of main connection(s)",sourceID,sinkID));
            for(unsigned int i=0;i<mainConnectionIDList.size();i++)
            {
                ETG_TRACE_USR4(("mainConnectionIDList[%d] = %d",i, mainConnectionIDList[i]));
            }
            //take the first, maybe not enough on the long run
            if(mainConnectionIDList.size()>0) mainconnectionID=mainConnectionIDList[0];
        }
        else
        {
            ETG_TRACE_USR4(("sourceID %d or sinkID %d not part of a main connection",sourceID,sinkID));
            ret = E_NON_EXISTENT;
        }
    }
    else
    {
        ETG_TRACE_USR4(("sourceID %d -> sinkID %d is mainConnectionID %d",sourceID,sinkID,mainconnectionID));
    }
    // new end

    if(ret != E_OK) return E_OK;


    am_Sink_s sinkData;
    am_Source_s sourceData;
    m_geniviControlIF->getSinkInfoDB(sinkID,sinkData);
    m_geniviControlIF->getSourceInfoDB(sourceID,sourceData);

    ETG_TRACE_USR4(("changeMainConnectionRouteDB sourceID %d mainconnectioID %d",sourceID,mainconnectionID));
    //check what list has the main connection now
    //{
    //virtual am_Error_e getMainConnectionInfoDB(const am_mainConnectionID_t mainConnectionID, am_MainConnection_s& mainConnectionData) const =0;
    am_MainConnection_s mainConnectionData;
    am_Error_e err = m_geniviControlIF->getMainConnectionInfoDB(mainconnectionID,mainConnectionData);
    if(err != E_OK)
    {
        ETG_TRACE_ERR(("getMainConnectionInfoDB for ID %d gave err %d",mainconnectionID,err));
    }
    ETG_TRACE_USR4(("mainConnectionData: ID %d, Src %d - Sink %d, listConnectionID.size()=%d",
            mainConnectionData.mainConnectionID,mainConnectionData.sourceID,mainConnectionData.sinkID,mainConnectionData.listConnectionID.size()));
    for(unsigned int i=0;i<mainConnectionData.listConnectionID.size();i++)
    {
        ETG_TRACE_USR4(("mainConnectionData: SubID %d",mainConnectionData.listConnectionID[i]));
    }
    printSubConnections(mainConnectionData.listConnectionID);
    //print also all connections to see if some is missing
    printAllConnections();
    mainConnectionData.listConnectionID = listConnectionID;

    ETG_TRACE_USR4(("BEFORE m_geniviControlIF->changeMainConnectionRouteDB() for mainID %d,  listConnectionID.size =%d",mainconnectionID,listConnectionID.size()));
    for(unsigned int i=0;i<listConnectionID.size();i++)
    {
        ETG_TRACE_USR4(("listConnectionID[%d] = %d",i,listConnectionID[i]));
    }
    ret = m_geniviControlIF->changeMainConnectionRouteDB(mainconnectionID, listConnectionID);

    //check what list has the main connection now
    {
        ETG_TRACE_USR4(("AFTER m_geniviControlIF->changeMainConnectionRouteDB() for mainID %d,  listConnectionID.size =%d",mainconnectionID,listConnectionID.size()));
        //virtual am_Error_e getMainConnectionInfoDB(const am_mainConnectionID_t mainConnectionID, am_MainConnection_s& mainConnectionData) const =0;
        am_MainConnection_s mainConnectionData;
        am_Error_e err = m_geniviControlIF->getMainConnectionInfoDB(mainconnectionID,mainConnectionData);
        if(err != E_OK)
        {
            ETG_TRACE_ERR(("m_geniviControlIF->getMainConnectionInfoDB for mainconnectionID %d gave err %d",mainconnectionID,err));
        }
        ETG_TRACE_USR4(("mainConnectionData: ID %d, Src %d - Sink %d, listConnectionID.size()=%d",
                mainConnectionData.mainConnectionID,mainConnectionData.sourceID,
                mainConnectionData.sinkID,mainConnectionData.listConnectionID.size()));
        for(unsigned int i=0;i<mainConnectionData.listConnectionID.size();i++)
        {
            ETG_TRACE_USR4(("mainConnectionData.listConnectionID[%d]: SubID %d",i,mainConnectionData.listConnectionID[i]));
        }
        for(unsigned int i=0;i<listConnectionID.size();i++)
        {
            ETG_TRACE_USR4(("listConnectionID[%d]: ID %d",i,listConnectionID[i]));
        }
        printSubConnections(mainConnectionData.listConnectionID);
    }


    ETG_TRACE_USR4(("changeMainConnectionRouteDB after daemon call"));
    printSubConnections(listConnectionID);

    return ret;
}

am_Error_e clGeniviAudioCtrlAdapter::removeMainConnection(am_sourceID_t sourceID)
{
    if(m_geniviControlIF==NULL)
    {
        return E_UNKNOWN;
    }

    ETG_TRACE_USR4(("removeMainConnection for sourceID %d connected to any sink",sourceID));
    am_Source_s sourceData;
    am_Error_e err = m_geniviControlIF->getSourceInfoDB(sourceID,sourceData);
    if(err != E_OK)
    {
        ETG_TRACE_ERR(("m_geniviControlIF->getSourceInfoDB for sourceID %d gave err %d",sourceID,err));
    }

    ETG_TRACE_USR4(("sourceID %d (sourceData.sourceID %d), sourceState %d",sourceID, sourceData.sourceID, sourceData.sourceState));

    // ToDo daw2hi: need to find all connections of this sourceID.  search and take all sinks from m_registeredSinks
    am_Error_e ret = E_OK;
    for (std::map<am_sinkID_t, am_Sink_s>::iterator it=m_registeredSinks.begin(); it!=m_registeredSinks.end(); ++it)
    {
        am_mainConnectionID_t mainConnectionID=0;
        //		ret = getMainConnectionOfSource(sourceID, it->first, mainConnectionID);
        //		if(E_OK == ret)
        if(bIsMainConnection(sourceID, it->first, mainConnectionID) == true)
        {
            ret = removeMainConnectionDB(mainConnectionID);
            ETG_TRACE_USR4(("removeMainConnection %d for sourceID %d -- sinkID %d with result %d",mainConnectionID, sourceID, it->first, ret));
        }
        else
        {
            ETG_TRACE_USR4(("sourceID %d not connected to sinkID %d,  skipping, map size is %d",sourceID, it->first, m_registeredSinks.size()));
        }
    }

    return ret; //daw2hi: check how to handle ret. NOK if any error occured and else OK ??

}

//
am_Error_e clGeniviAudioCtrlAdapter::removeConnectionFromMainConnection(
        am_sourceID_t sourceID,
        am_sinkID_t sinkID,
        am::am_connectionID_t connectionId)
{

    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);
    if(connectionId == 0)
    {
        ETG_TRACE_ERR(("ERROR: removeConnectionFromMainConnection called with connectionId 0, no action"));
        return E_OK; //maybe we should change this to E_NOT_POSSIBLE
    }

    std::vector<am_MainConnection_s> listMainConnections;
    std::vector<am_connectionID_t> listConnectionID;

    ETG_TRACE_USR4(("Searching all main connections for connection ID %d",connectionId));
    am_Error_e err = m_geniviControlIF->getListMainConnections(listMainConnections);
    if(err != E_OK)
    {
        ETG_TRACE_ERR(("m_geniviControlIF->getListMainConnections gave err %d",err));
    }

    //loop through all main connection
    for(unsigned int i=0; i<listMainConnections.size();i++)
    {

        //This is main Connection i
        ETG_TRACE_USR4(("This is mainConnectionID %d",listMainConnections[i].mainConnectionID));
        for(unsigned int k=0;k<listMainConnections[i].listConnectionID.size();k++)
        {
            if(     (listMainConnections[i].listConnectionID[k]==connectionId)
                    && (listMainConnections[i].sourceID == sourceID)
                    && (listMainConnections[i].sinkID == sinkID) )
            {
                //found a main connection "listMainConnections[i].mainConnectionID" with this sub connection "connectionId"

                ETG_TRACE_USR4(("mainConnectionID %d has connectionID %d",listMainConnections[i].mainConnectionID,connectionId));
                listConnectionID = listMainConnections[i].listConnectionID;
                listConnectionID.erase(listConnectionID.begin()+k);
                ETG_TRACE_USR4(("calling m_geniviControlIF->changeMainConnectionRouteDB"));
                err = m_geniviControlIF->changeMainConnectionRouteDB(listMainConnections[i].mainConnectionID,listConnectionID);

                // remove it also from the member data
                (void)updateMainConnectionEntryRemove(listMainConnections[i].mainConnectionID,connectionId,sourceID,sinkID);
                break;
            }
        }
    }
    return E_OK;
}

// we search for a sub connection defined by SourceID - SinkID from the given main connection with ID mainConnectionID
// in the internal Data m_mainConnectionEntries[]
// and remove this sub connection from the Daemon's Data
am_Error_e clGeniviAudioCtrlAdapter::removeConnectionFromMainConnectionInternal(am_sourceID_t sourceID, am_sinkID_t sinkID, am_mainConnectionID_t mainConnectionID)
{
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);

    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::removeConnectionFromMainConnection"));

    bool bFound=false;
    am_connectionID_t connectionID=0;

    for(unsigned int i =0; i<m_mainConnectionEntries.size();i++)
    {
        if(m_mainConnectionEntries[i].mainID == mainConnectionID)
        {
            //found our main connection in the internal data
            for(unsigned int k=0;k<m_mainConnectionEntries[i].subConnectionList.size();k++)
            {
                if(   (m_mainConnectionEntries[i].subConnectionList[k].sourceID == sourceID)
                        && (m_mainConnectionEntries[i].subConnectionList[k].sinkID == sinkID) )
                {
                    connectionID=m_mainConnectionEntries[i].subConnectionList[k].connectionID;
                    m_mainConnectionEntries[i].subConnectionList.erase(m_mainConnectionEntries[i].subConnectionList.begin()+k);
                    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::removeConnectionFromMainConnection found connectionID %d",connectionID));
                    bFound=true;
                    break;
                }
            }
            if(bFound) break;
        }
    }
    //if we found a sub connection with sourceID - sinkID and main connection with ID mainConnectionID
    // inside internal data, we search for teh same in daemon data
    if(connectionID >0)
    {
        am_MainConnection_s mainConnectionData;
        am_Error_e err = m_geniviControlIF->getMainConnectionInfoDB(mainConnectionID, mainConnectionData);
        if(err != E_OK)
        {
            ETG_TRACE_ERR(("m_geniviControlIF->getMainConnectionInfoDB for ID %d gave err %d",mainConnectionID,err));
        }
        else
        {
            //we only need to do this if Daemon has this data
            for(unsigned int i = 0;i<mainConnectionData.listConnectionID.size();i++)
            {
                if(mainConnectionData.listConnectionID[i] == connectionID)
                {
                    //and we erase it there
                    ETG_TRACE_USR4(("erasing connectionID %d, size %d",connectionID,mainConnectionData.listConnectionID.size()));
                    mainConnectionData.listConnectionID.erase(mainConnectionData.listConnectionID.begin()+i);
                    ETG_TRACE_USR4(("after erasing size %d",mainConnectionData.listConnectionID.size()));
                    break;
                }
            }
            //update daemon data
            err = m_geniviControlIF->changeMainConnectionRouteDB(mainConnectionID, mainConnectionData.listConnectionID);
            ETG_TRACE_USR4((" err %d after changeMainConnectionRouteDB",err));
        }
    }
    return E_OK;
}


//This should be better called removeConnection as it is called for sourceID - sinkID and it might be a subconnection
// 1. search for all connections in listConnection with this sourceID - sinkID
// 2. search all main connections with this sub connection and remove from there
// 3. if any main connection i snow empty (no sub connections) remove that main connection
am_Error_e clGeniviAudioCtrlAdapter::removeMainConnection(am_sourceID_t sourceID, am_sinkID_t sinkID)
{
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);

    ETG_TRACE_USR4(("removeMainConnection: GAM SourceID: %d, SinkID: %d", sourceID, sinkID));
    am_Source_s sourceData;
    am_Sink_s sinkData;
    am_Error_e err = m_geniviControlIF->getSourceInfoDB(sourceID,sourceData);
    if(err != E_OK)
    {
        ETG_TRACE_ERR(("m_geniviControlIF->getSourceInfoDB for sourceID %d gave err %d",sourceID,err));
    }
    err = m_geniviControlIF->getSinkInfoDB(sinkID,sinkData);
    if(err != E_OK)
    {
        ETG_TRACE_ERR(("m_geniviControlIF->getSinkInfoDB for sinkID %d gave err %d",sinkID,err));
    }
    ETG_TRACE_USR4(("sourceID %d (sourceData.sourceID %d), sourceState %d",sourceID, sourceData.sourceID, sourceData.sourceState));
    //Check active main connections
    am_mainConnectionID_t mainConnectionID=0;
    am_Error_e ret = getMainConnectionOfSourceSink(sourceID, sinkID, mainConnectionID);

    // if not a main connection and also not a sub connection that is used in any main connection
    if((E_OK != ret) && (mainConnectionID==0))
    {
        //OK, what is left here
        ETG_TRACE_USR4(("removeMainConnection can not find sub connection for sourceID %d - sinkID %d",sourceID,sinkID));
        vTraceMainCon();
        vTraceAllCon();
        printMainConnectionEntries();
        getMainConnectionOfSourceSinkFromInternalData(sourceID, sinkID, mainConnectionID);

        ETG_TRACE_USR4(("removeMainConnection got mainID %d",mainConnectionID));
        removeConnectionFromMainConnectionInternal(sourceID, sinkID, mainConnectionID);
    }
    //check first
    bool bSubConnectionEmpty = false;
    std::vector<mainConnectionEntry_s>::iterator it;
    for(it = m_mainConnectionEntries.begin();it != m_mainConnectionEntries.end();++it)
    {
        ETG_TRACE_USR3(("check MainID %d in m_mainConnectionEntries",it->mainID));
        if(it->mainID == mainConnectionID)
        {
            ETG_TRACE_USR3(("OK this is our MainID %d",it->mainID));
            if(it->subConnectionList.size()==0)
            {
                ETG_TRACE_USR3(("subConnectionList already 0"));
                bSubConnectionEmpty=true;
                break;
            }
            //found the main ID
            //go through sub and check
            std::vector<am::am_Connection_s>::iterator subIt;
            for(subIt = it->subConnectionList.begin();subIt != it->subConnectionList.end();++subIt)
            {
                ETG_TRACE_USR3(("check SubCon %d for Src %d -- Sink %d",subIt->connectionID,subIt->sourceID,subIt->sinkID));
                if((subIt->sourceID==sourceID) && (subIt->sinkID==sinkID))
                {
                    ETG_TRACE_USR3(("SubCon remove size before %d",it->subConnectionList.size()));
                    it->subConnectionList.erase(subIt);
                    ETG_TRACE_USR3(("SubCon remove size after %d",it->subConnectionList.size()));
                    if(it->subConnectionList.size()==0)
                    {
                        bSubConnectionEmpty=true;
                    }
                    break;
                }
            }
            //if we found the main connection we leave
            break;
        }
    }
    if(bSubConnectionEmpty==true)
    {
        ETG_TRACE_USR3(("RemoveMainCon from internal data"));
        m_mainConnectionEntries.erase(it);
        ETG_TRACE_USR3(("MainCon size %d",m_mainConnectionEntries.size()));

        ETG_TRACE_USR3(("SubCon empty, update mainConnectionID %d to CS_DISCONNECTED",mainConnectionID));
        err = m_geniviControlIF->changeMainConnectionStateDB(mainConnectionID, CS_DISCONNECTED);
        ret = m_geniviControlIF-> removeMainConnectionDB(mainConnectionID);
        ETG_TRACE_ERR(("removeMainConnectionDB: Failed with: %d ",ret));
        //return m_geniviControlIF->changeMainConnectionStateDB(mainConnectionID, CS_DISCONNECTED);
        //lets trigger pending requests
        m_ControlSenderBase->triggerPendingRequests(msgType::DisConnectionRequest);
    }
    else
    {

        ETG_TRACE_USR3(("removeMainConnection but bSubConnectionEmpty still false"));
        ETG_TRACE_USR3(("Maybe it is a not tracked main connection with ID %d (ret was %d)", mainConnectionID,ret));
        if(ret==E_OK)
        {
            if(    (sourceData.domainID == sinkData.domainID)
                    && (sourceData.visible == true)
                    && (sinkData.visible == true)
                    && (mainConnectionID != 0) )
            {
                ETG_TRACE_USR3(("Temporary Hack: we change to disconnected and remove it mainConnectionID %d",mainConnectionID));
                //lets print the data
                am_MainConnection_s mainConnectionData;
                err = m_geniviControlIF->getMainConnectionInfoDB(mainConnectionID,mainConnectionData);

                ETG_TRACE_USR3(("mainConnectionData.mainConnectionID =%d",mainConnectionData.mainConnectionID));
                ETG_TRACE_USR3(("mainConnectionData.connectionState =%d",mainConnectionData.connectionState));
                ETG_TRACE_USR3(("mainConnectionData sourceID %d -> sinkID %d",mainConnectionData.sourceID,mainConnectionData.sinkID));
                for(unsigned int i=0;i<mainConnectionData.listConnectionID.size();i++)
                {
                    ETG_TRACE_USR3(("mainConnectionData listConnectionID[%d] %d",i,mainConnectionData.listConnectionID[i]));
                    am_Handle_s handle;
                    handle.handleType = H_UNKNOWN;
                    handle.handle = 0;

                    clGeniviAudioCtrlAdapter::informVolumeManager(mainConnectionData.listConnectionID[i]);

                    err = m_geniviControlIF->disconnect(handle,mainConnectionData.listConnectionID[i]);
                    ETG_TRACE_USR3(("called disconnect with err %d",err));
                }
                err = m_geniviControlIF->changeMainConnectionStateDB(mainConnectionID, CS_DISCONNECTED);
                ret = m_geniviControlIF-> removeMainConnectionDB(mainConnectionID);
                ETG_TRACE_USR3(("we got changeMainConnectionStateDB err %d",err));
                ETG_TRACE_USR3(("we got removeMainConnectionDB err %d",ret));
                //lets trigger pending requests
                m_ControlSenderBase->triggerPendingRequests(msgType::DisConnectionRequest);
            }
            else
            {
                ETG_TRACE_USR3(("Temporary Hack: we change to disconnected but no remove mainConnectionID %d",mainConnectionID));
                err = m_geniviControlIF->changeMainConnectionStateDB(mainConnectionID, CS_DISCONNECTED);
                ETG_TRACE_USR3(("we got changeMainConnectionStateDB err %d",err));
                printAllMainConnections();

                if(    (sourceData.domainID == sinkData.domainID)
                        && (sourceData.domainID == m_domainID) )
                {
                    //domain 1 connection we will remove
                    am_MainConnection_s mainConnectionData;
                    m_geniviControlIF->getMainConnectionInfoDB(mainConnectionID,mainConnectionData);
                    if(mainConnectionData.listConnectionID.size()==1)
                    {
                        ret = m_geniviControlIF-> removeMainConnectionDB(mainConnectionID);
                    }
                }
            }
        }
    }

    //end
    return ret;
}

am_Error_e clGeniviAudioCtrlAdapter::removeMainConnectionDB(const am_mainConnectionID_t mainConnectionID)
{
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::removeMainConnectionDB: mainConnectionID: %d ", mainConnectionID));
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);
    //return m_geniviControlIF->removeMainConnectionDB( mainConnectionID);
    am_Error_e err = m_geniviControlIF->removeMainConnectionDB( mainConnectionID);
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::removeMainConnectionDB gave err %d",err));
    return err;
}

am_Error_e clGeniviAudioCtrlAdapter::addMainConnection(am_sourceID_t sourceID, am_sinkID_t sinkID)
{
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::addMainConnection_1 sourceID = %d, sinkID = %d",sourceID, sinkID));
    am_mainConnectionID_t mainConnectionID=0;
    return addMainConnection(sourceID, sinkID, mainConnectionID);
}
am_Error_e clGeniviAudioCtrlAdapter::addMainConnection(am_sourceID_t sourceID)
{
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::addMainConnection_2 hard coded sink 1"));
    am_mainConnectionID_t mainConnectionID=0;
    return addMainConnection(sourceID, GAM_AUDIO_SINK_ID, mainConnectionID);
}


am_Error_e clGeniviAudioCtrlAdapter::addMainConnection(const am_sourceID_t sourceID,
        const am_sinkID_t sinkID,
        am_mainConnectionID_t& mainConnectionID)
{
    ETG_TRACE_USR1(("addMainConnection: sourceID %d --> sinkID %d, mainConnectionID %d",sourceID,sinkID,mainConnectionID));
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);

    //if(E_OK == getMainConnectionOfSourceSink(sourceID, sinkID, mainConnectionID))
    if(true == bIsMainConnection(sourceID, sinkID, mainConnectionID))
    {
        ETG_TRACE_USR1(("addMainConnection: return E_ALREADY_EXISTS, mainConnectionID=%d",mainConnectionID));
        return E_ALREADY_EXISTS;
    }

    //if it is not yet a mainConnection, we announce it now

    am_MainConnection_s mainConnectionData;// = new am_MainConnection_s();
    mainConnectionData.mainConnectionID = 0;
    am_Source_s sourceData;
    m_geniviControlIF->getSourceInfoDB(sourceID,sourceData);

    if(sourceData.name == "AVB_Mic3")
    {
        mainConnectionData.connectionState = CS_CONNECTING;
        std::vector<am::am_Connection_s> tempSubConnectionList;
        tempSubConnectionList.clear();
        bool bFound = false;
        bool bComplete = true;
        for(unsigned int id = 0;id<m_mainConnectionEntries.size();id++)
        {
            for(unsigned int subID=0;subID<m_mainConnectionEntries[id].subConnectionList.size();subID++)
            {
                ETG_TRACE_USR4(("Checking mainID %d",m_mainConnectionEntries[id].mainID));
                ETG_TRACE_USR4(("m_mainConnectionEntries[%d].subConnectionList[%d] sourceID %d, sinkID %d, MainConID %d, subConID %d ",
                        id,subID,
                        m_mainConnectionEntries[id].subConnectionList[subID].sourceID,
                        m_mainConnectionEntries[id].subConnectionList[subID].sinkID,
                        m_mainConnectionEntries[id].mainID,
                        m_mainConnectionEntries[id].subConnectionList[subID].connectionID));

                m_geniviControlIF->getSourceInfoDB(m_mainConnectionEntries[id].subConnectionList[subID].sourceID,sourceData);

                if(sourceData.name == "AVB_Mic2")
                {
                    ETG_TRACE_USR4(("This is for mainID %d and subConnectionList size is %d",
                            m_mainConnectionEntries[id].mainID,
                            m_mainConnectionEntries[id].subConnectionList.size()));

                    ETG_TRACE_USR4(("MIC Source %s",sourceData.name.c_str()));
                    mainConnectionData.connectionState = CS_SUSPENDED;//CS_CONNECTING;
                    break;
                }
            }
        }
    }
    else
       mainConnectionData.connectionState = CS_CONNECTING;

    mainConnectionData.sinkID = sinkID;
    mainConnectionData.sourceID = sourceID;
    mainConnectionData.delay = 0;

    ETG_TRACE_USR1(("addMainConnection: enterMainConnectionDB: ID %d, MainConnID %d, Src %d, Snk %d, listConnectionID.size %d", (int)mainConnectionID,
            mainConnectionData.mainConnectionID,
            mainConnectionData.sourceID,
            mainConnectionData.sinkID,
            mainConnectionData.listConnectionID.size()));
    ETG_TRACE_USR1(("addMainConnection: m_geniviControlIF->enterMainConnectionDB()"));
    am_Error_e ret = m_geniviControlIF->enterMainConnectionDB(mainConnectionData, mainConnectionID);
    //now we should have a mainConnectionID
    ETG_TRACE_USR1(("addMainConnection: new MainConnection: ID %d, Src %d, Sink %d, ret(%d)", mainConnectionID, sourceID, sinkID, ret));
    ETG_TRACE_USR1(("addMainConnection: listConnectionID.size %d (mainConnectionData.mainConnectionID %d",
            mainConnectionData.listConnectionID.size(),mainConnectionData.mainConnectionID));
    mainConnectionData.mainConnectionID = mainConnectionID;
    return ret;
}

void clGeniviAudioCtrlAdapter::printAllConnections()
{
    if(m_geniviControlIF==NULL) return;
    //Print all known connections
    std::vector<am_Connection_s>listConnections;
    std::vector<am_Connection_s>::iterator itSubCon;
    am_Error_e err = m_geniviControlIF->getListConnections(listConnections);
    ETG_TRACE_USR4(("### Printing All connections size is %d, (err %d)",listConnections.size(),err));
    itSubCon= listConnections.begin();
    while(itSubCon!=listConnections.end())
    {
        ETG_TRACE_USR4(("SubConnection ID: %d, Src %d --> Sink %d",(*itSubCon).connectionID,(*itSubCon).sourceID, (*itSubCon).sinkID));
        ++itSubCon;
    }
    ETG_TRACE_USR4(("### done ###"));
}

void clGeniviAudioCtrlAdapter::printSubConnections(std::vector<am_connectionID_t>& listConnectionID)
{
    if(m_geniviControlIF==NULL) return;

    if(listConnectionID.size()==0)
    {
        ETG_TRACE_USR4(("\tno subconnections"));
        return;
    }
    //Read in all known connections from daemon
    std::vector<am_Connection_s>listConnections;
    am_Error_e err = m_geniviControlIF->getListConnections(listConnections);
    if(err!=E_OK)
    {
        ETG_TRACE_ERR(("m_geniviControlIF->getListConnections returned err %d",err));
    }

    //loop through all entries from listConnectionID
    std::vector<am_connectionID_t>::iterator it = listConnectionID.begin();
    while(it != listConnectionID.end())
    {
        std::vector<am_Connection_s>::iterator itSubCon = listConnections.begin();
        while(itSubCon != listConnections.end())
        {
            if(*it == (*itSubCon).connectionID)
            {
                ETG_TRACE_USR4(("\t SubCon %d: Src %d --> Sink %d",(*itSubCon).connectionID,(*itSubCon).sourceID, (*itSubCon).sinkID));
                break;
            }
            ++itSubCon;
        }
        ++it;
    }
    ETG_TRACE_USR4(("printSubConnections for listConnectionID.size %d done",listConnectionID.size()));

}

void clGeniviAudioCtrlAdapter::printAllMainConnections()
{
    if(m_geniviControlIF==NULL) return;

    std::vector<am_MainConnection_s> listMainConnections;
    am_Error_e err = m_geniviControlIF->getListMainConnections(listMainConnections);

    ETG_TRACE_USR4(("Printing Main Connections size is %d, (err %d)",listMainConnections.size(),err));
    std::vector<am_MainConnection_s>::iterator it = listMainConnections.begin();
    while(it != listMainConnections.end())
    {
        ETG_TRACE_USR4(("MainConnection ID: %d, Src %d --> Sink %d",(*it).mainConnectionID,(*it).sourceID, (*it).sinkID));
        printSubConnections((*it).listConnectionID);
        ++it;
    }
    ETG_TRACE_USR4(("### done ###"));
}

//check if Source - Sink is a main connection. If yes, then return true and provide the mainConnectionID
bool clGeniviAudioCtrlAdapter::bIsMainConnection(am_sourceID_t sourceID, am_sinkID_t sinkID, am_mainConnectionID_t& mainConnectionID)
{
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,false);

    std::vector<am_MainConnection_s> listMainConnections;
    am_Error_e err = m_geniviControlIF->getListMainConnections(listMainConnections);
    if(err != E_OK)
    {
        ETG_TRACE_USR4(("Daemon gave error (%d) for getListMainConnections()",err));
        return false;
    }

    std::vector<am_MainConnection_s>::iterator iter = listMainConnections.begin();
    //Check for equal MainConnections
    while(iter != listMainConnections.end())
    {
        if( ((*iter).sourceID == sourceID) && ((*iter).sinkID == sinkID) )
        {
            ETG_TRACE_USR4(("bIsMainConnection: Found MainConnection: ID %d, Src %d, Snk %d"
                    ,(*iter).mainConnectionID
                    ,(*iter).sourceID
                    ,(*iter).sinkID));
            mainConnectionID = (*iter).mainConnectionID;
            return true;
        }
        iter++;
    }
    return false;
}

//check if Source - Sink is a known sub connection and if so, assign corresponding main
bool clGeniviAudioCtrlAdapter::bIsSubConnection(am_sourceID_t sourceID, am_sinkID_t sinkID, am_mainConnectionID_t& mainConnectionID)
{
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,false);

    //Print all known connections
    std::vector<am_Connection_s>listConnections;
    std::vector<am_Connection_s>::iterator itSubCon;
    am_connectionID_t subConnectionID=0;

    am_Error_e err = m_geniviControlIF->getListConnections(listConnections);
    if(err != E_OK)
    {
        ETG_TRACE_USR4(("m_geniviControlIF->getListConnections gave err %d",err));
    }
    itSubCon= listConnections.begin();
    while(itSubCon!=listConnections.end())
    {
        if( (sourceID == (*itSubCon).sourceID) && (sinkID == (*itSubCon).sinkID) )
        {
            ETG_TRACE_USR4(("isSubConnection(): found subconnectionID: %d, Src %d --> Sink %d",(*itSubCon).connectionID,(*itSubCon).sourceID, (*itSubCon).sinkID));
            subConnectionID = (*itSubCon).connectionID;
            break;
        }
        ++itSubCon;
    }
    if(subConnectionID!=0)
    {
        //search main connection where this subcon is part of
        std::vector<am_MainConnection_s> listMainConnections;
        err = m_geniviControlIF->getListMainConnections(listMainConnections);
        if(err != E_OK)
        {
            ETG_TRACE_USR4(("m_geniviControlIF->getListMainConnections gave err %d",err));
        }
        std::vector<am_MainConnection_s>::iterator it = listMainConnections.begin();
        while(it != listMainConnections.end())
        {
            for(unsigned int i=0;i<(*it).listConnectionID.size();i++)
            {
                if((*it).listConnectionID[i] == subConnectionID)
                {
                    ETG_TRACE_USR4(("Found SubCon %d in MainCon %d",subConnectionID,(*it).mainConnectionID));
                    mainConnectionID = (*it).mainConnectionID;
                    return true;
                }
            }
            it++;
        }
    }

    if(subConnectionID!=0) return true;
    return false;
}


bool clGeniviAudioCtrlAdapter::bIsSubConnection(am_sourceID_t sourceID, am_sinkID_t sinkID, am_connectionID_t& subConnectionID, std::vector<am_mainConnectionID_t>& mainConnectionIDList)
{
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,false);

    //Print all known connections
    std::vector<am_Connection_s>listConnections;
    std::vector<am_Connection_s>::iterator itSubCon;
    subConnectionID=0;

    am_Error_e err = m_geniviControlIF->getListConnections(listConnections);
    if(err != E_OK)
    {
        ETG_TRACE_USR4(("m_geniviControlIF->getListConnections gave err %d",err));
        return false;
    }
    itSubCon= listConnections.begin();
    while(itSubCon!=listConnections.end())
    {
        if( (sourceID == (*itSubCon).sourceID) && (sinkID == (*itSubCon).sinkID) )
        {
            ETG_TRACE_USR4(("isSubConnection(): found subconnectionID: %d, Src %d --> Sink %d",(*itSubCon).connectionID,(*itSubCon).sourceID, (*itSubCon).sinkID));
            subConnectionID = (*itSubCon).connectionID;
            break;
        }
        ++itSubCon;
    }
    //if it is a sub connection ..
    if(subConnectionID!=0)
    {
        //...search all main connections where this subcon is part of
        std::vector<am_MainConnection_s> listMainConnections;
        err = m_geniviControlIF->getListMainConnections(listMainConnections);
        if(err != E_OK)
        {
            ETG_TRACE_USR4(("m_geniviControlIF->getListMainConnections gave err %d",err));
        }
        std::vector<am_MainConnection_s>::iterator it = listMainConnections.begin();
        while(it != listMainConnections.end())
        {
            for(unsigned int i=0;i<(*it).listConnectionID.size();i++)
            {
                if((*it).listConnectionID[i] == subConnectionID)
                {
                    ETG_TRACE_USR4(("Found SubCon %d in MainCon %d",subConnectionID,(*it).mainConnectionID));
                    mainConnectionIDList.push_back((*it).mainConnectionID);
                    //return true;
                }
            }
            it++;
        }
    }

    if(subConnectionID!=0) return true;
    return false;
}


bool clGeniviAudioCtrlAdapter::bIsSourcOrSinkPartOfMainConnection(am_sourceID_t sourceID, am_sinkID_t sinkID, std::vector<am_mainConnectionID_t>& listMainConnectionID)
{
    bool bFound=false;
    std::vector<am_MainConnection_s> listMainConnections;
    am_Error_e err = m_geniviControlIF->getListMainConnections(listMainConnections);
    if(err != E_OK)
    {
        ETG_TRACE_USR4(("m_geniviControlIF->getListMainConnections gave err %d",err));
    }

    std::vector<am_MainConnection_s>::iterator iter = listMainConnections.begin();
    iter = listMainConnections.begin();
    while(iter != listMainConnections.end())
    {
        ETG_TRACE_USR4(("getMainConnectionOfSource: check mainConID %d, sourceID %d -- sinkID %d, subCons %d",
                (*iter).mainConnectionID,(*iter).sourceID,(*iter).sinkID,(*iter).listConnectionID.size()));
        //To prevent mismatching of MIC's MainconID and subconID RTC1-2171668
        if( ((*iter).sourceID == sourceID) && ((*iter).sinkID == sinkID) )
        {
            ETG_TRACE_USR4(("sourceID or sinkID matches, adding mainConID %d to list",(*iter).mainConnectionID));
            listMainConnectionID.push_back((*iter).mainConnectionID);
            bFound = true;
            //break; //daw2hi 28.11.2017 check if O.K. for other usecases
        }
        ++iter;
    }
    return bFound;
}




//ToDo: should be changed to not mix logic with other context.
am_Error_e clGeniviAudioCtrlAdapter::getMainConnectionOfSourceSink(am_sourceID_t sourceID, am_sinkID_t sinkID, am_mainConnectionID_t& mainConnectionID)
{

    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);

    ETG_TRACE_USR4(("getMainConnectionOfSourceSink: Search MainConnection for Source %d --> SinkID %d, mainConnectionID %d"
            ,sourceID, sinkID, mainConnectionID));

    //just check first if this is a pure main connection
    bool bIsMainID = bIsMainConnection(sourceID,sinkID,mainConnectionID);
    if(bIsMainID == true)
    {
        //ETG_TRACE_USR4(("This is a main connection with ID %d",tmpMainID));
        am_MainConnection_s tmpMainConnectionData;
        //just for debug
        if(E_OK == m_geniviControlIF->getMainConnectionInfoDB(mainConnectionID,tmpMainConnectionData))
        {
            ETG_TRACE_USR4(("This is a main connection with ID %d in state %d",mainConnectionID,tmpMainConnectionData.connectionState));
        }
        //debug end
        return E_OK;
    }

    //it is not a pure main connection, so check for sub connection
    am_connectionID_t subConnectionID=0;
    std::vector<am_mainConnectionID_t> mainConnectionIDList; //we are not interested in this list
    bool bIsSubID = bIsSubConnection(sourceID,sinkID,subConnectionID,mainConnectionIDList);
    if(bIsSubID == false)
    {
        ETG_TRACE_ERR(("getMainConnectionOfSourceSink could not find sub connection"));
        return E_NOT_POSSIBLE;
    }

    //we should have a subConnectionID and hopefully a corresponding mainID
    if(mainConnectionIDList.size() == 0)
    {
        ETG_TRACE_USR4(("this is not part of any MainConnection"));
        //return E_OK; // is this return code correct?
        return E_NOT_POSSIBLE;
    }

    //assign this first from the list
    mainConnectionID = mainConnectionIDList[0];
    //check if only one in list
    if(mainConnectionIDList.size() == 1)
    {
        ETG_TRACE_USR4(("this is part of MainConnectionID %d",mainConnectionIDList[0]));
        return E_OK;
    }

    ETG_TRACE_ERR(("Warning: this is part of several MainConnections"));
    for(unsigned int idx=0;idx<mainConnectionIDList.size();idx++)
    {
        ETG_TRACE_ERR(("subConnectionID %d is part of MainConID %d",subConnectionID,mainConnectionIDList[idx]));
    }
    // ToDo: what if we find multiple main connections? Caller of this function is not expecting this
    return E_OK;
}

#if 0 //no one is usig this anymore
am_Error_e clGeniviAudioCtrlAdapter::getConnectionOfSource(clGeniviAudioSource* pSrc, am_connectionID_t& connectionID)
{
    if(pSrc == NULL)
    {
        ETG_TRACE_ERR(("getConnectionOfSource: SOURCE POINTER == NULL"))
    						          return E_UNKNOWN;
    }

    ETG_TRACE_USR4(("getConnectionOfSource: Search Connection for SourceClass %d SubID %d "
            , pSrc->sGetId().enSourceClass
            , pSrc->sGetId().u16SubSource));

    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);

    std::vector<am_Connection_s> listConnections;
    m_geniviControlIF->getListConnections(listConnections);
    std::vector<am_Connection_s>::iterator iter = listConnections.begin();
    //Check for equal MainConnections
    while(iter != listConnections.end())
    {
        if((*iter).sourceID == pSrc->u16GetGeniviSourceID())
        {
            ETG_TRACE_USR4(("getMainConnectionOfSource: Found Connection: ID %d, Src %d, Snk %d"
                    ,(*iter).connectionID
                    ,(*iter).sourceID
                    ,(*iter).sinkID));
            connectionID = (*iter).connectionID;
            return E_OK;
        }
        ++iter;
    }
    ETG_TRACE_USR4(("getConnectionOfSource: No Connection for SourceClass %d SubID %d "
            , pSrc->sGetId().enSourceClass
            , pSrc->sGetId().u16SubSource));
    return E_NON_EXISTENT;
}
#endif

am_Error_e clGeniviAudioCtrlAdapter::changeSourceAvailabilityDB(am_Availability_s& availability, am_sourceID_t sourceID)
{

    ETG_TRACE_USR3(("changeSourceAvailabilityDB: GeniviSourceID %d, availability-state: 0x%x availability-reason: 0x%x "
            , sourceID
            , availability.availability
            , availability.availabilityReason));

    //iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);
    if(m_geniviControlIF == NULL)
    {
        ETG_TRACE_ERR(("m_geniviControlIF==NULL"));
        return E_NOT_POSSIBLE;
    }
    //return m_geniviControlIF->changeSourceAvailabilityDB(availability, sourceID);
    am_Error_e GamDBErr = m_geniviControlIF->changeSourceAvailabilityDB(availability, sourceID);

    return GamDBErr;
}

//search if we have this sourceID - sinkID somewhere in our internal Data.
bool clGeniviAudioCtrlAdapter::getMainConnectionOfSourceSinkFromInternalData(am_sourceID_t sourceID, am_sinkID_t sinkID, am_mainConnectionID_t& mainConnectionID)
{
    ETG_TRACE_USR4(("getMainConnectionOfSourceSinkFromInternalData"));

    std::vector<am::am_Connection_s> tempSubConnectionList;
    tempSubConnectionList.clear();
    bool bFound = false;
    bool bComplete = true;
    for(unsigned int id = 0;id<m_mainConnectionEntries.size();id++)
    {
        for(unsigned int subID=0;subID<m_mainConnectionEntries[id].subConnectionList.size();subID++)
        {
            ETG_TRACE_USR4(("Checking mainID %d",m_mainConnectionEntries[id].mainID));
            ETG_TRACE_USR4(("m_mainConnectionEntries[%d].subConnectionList[%d] sourceID %d, sinkID %d, MainConID %d, subConID %d ",
                    id,subID,
                    m_mainConnectionEntries[id].subConnectionList[subID].sourceID,
                    m_mainConnectionEntries[id].subConnectionList[subID].sinkID,
                    m_mainConnectionEntries[id].mainID,
                    m_mainConnectionEntries[id].subConnectionList[subID].connectionID));

            if(  (m_mainConnectionEntries[id].subConnectionList[subID].sourceID == sourceID)
                    && (m_mainConnectionEntries[id].subConnectionList[subID].sinkID == sinkID) )
            {
                ETG_TRACE_USR4(("This is for mainID %d and subConnectionList size is %d",
                        m_mainConnectionEntries[id].mainID,
                        m_mainConnectionEntries[id].subConnectionList.size()));
                tempSubConnectionList = m_mainConnectionEntries[id].subConnectionList;
                bFound=true;
                mainConnectionID = m_mainConnectionEntries[id].mainID;
                break;
            }
        }

        if(bFound==true)
        {
            for(unsigned int i=0;i<tempSubConnectionList.size();i++)
            {
                ETG_TRACE_USR4(("Found mainID %d",mainConnectionID));
                ETG_TRACE_USR4(("tempSubConnectionList[%d] connectionID = %d: sourceID %d -> sinkID %d",
                        i,tempSubConnectionList[i].connectionID,tempSubConnectionList[i].sourceID,tempSubConnectionList[i].sinkID));
                if(tempSubConnectionList[i].connectionID==0) bComplete=false;
            }
            break;
        }
    }

    return bComplete;
}
am_Error_e clGeniviAudioCtrlAdapter::changeMainConnectionStateDB(const am_sourceID_t sourceID,
        const am_sinkID_t sinkID,
        const am_ConnectionState_e connectionState)
{
    ETG_TRACE_USR3(("changeMainConnectionStateDB: source %d --> sink %d, connectionState %d"
            , sourceID
            , sinkID
            , ETG_CENUM(am_ConnectionState_e, connectionState)));

    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);

    am_mainConnectionID_t mainConnectionID=0;
    am_Error_e ret = getMainConnectionOfSourceSink(sourceID, sinkID, mainConnectionID);

    // if not a main connection and also not a sub connection that is used in any main connection
    if((E_OK != ret) && (mainConnectionID==0))
    {
        //check also our internal data
        bool bComplete =  getMainConnectionOfSourceSinkFromInternalData(sourceID, sinkID, mainConnectionID);
        if(bComplete && (mainConnectionID!=0))
        {
            ETG_TRACE_USR4(("m_geniviControlIF->changeMainConnectionStateDB mainConnectionID %d connectionState %d",mainConnectionID,connectionState));
            ret = m_geniviControlIF->changeMainConnectionStateDB(mainConnectionID, connectionState);
            if(connectionState == CS_CONNECTED)
                m_ControlSenderBase->triggerPendingRequests(msgType::ConnectionRequest);
            return ret;

        }
        ETG_TRACE_ERR(("changeMainConnectionStateDB exit sourecID %d, sinkID %d, conState %d",sourceID,sinkID,connectionState));
        return ret;
    }


    ETG_TRACE_USR3(("changeMainConnectionStateDB sourceID %d, sinkID %d, mainConnectionID %d, connectionState %d",sourceID,sinkID,mainConnectionID,connectionState));
    // we should do this only if all subcons are done

    //temp check if all subconns have an ID assigned -> means all subconns called connect
    if(ret != E_OK)
    {
        //std::vector<mainConnectionEntry_s> m_mainConnectionEntries;
        bool bSubConnectionComplete = true;
        std::vector<mainConnectionEntry_s>::iterator it;
        for(it = m_mainConnectionEntries.begin();it != m_mainConnectionEntries.end();++it)
        {
            ETG_TRACE_USR3(("check MainID %d",it->mainID));
            if(it->mainID == mainConnectionID)
            {
                ETG_TRACE_USR3(("OK this is our MainID %d",it->mainID));
                //found the main ID
                //go through sub and check
                //std::vector<am::am_Connection_s> subConnectionList;
                std::vector<am::am_Connection_s>::iterator subIt;
                for(subIt = it->subConnectionList.begin();subIt != it->subConnectionList.end();++subIt)
                {
                    ETG_TRACE_USR3(("check SubCon %d for Src %d -- Sink %d",subIt->connectionID,subIt->sourceID,subIt->sinkID));
                    if(subIt->connectionID==0)
                    {
                        ETG_TRACE_USR3(("SubCon not complete no update"));
                        //ups, not yet assigned -> no update
                        bSubConnectionComplete=false;
                        break;
                    }
                }
                if(bSubConnectionComplete==false)
                {
                    break;
                }

            }
        }
        if(bSubConnectionComplete==true)
        {
            ETG_TRACE_USR3(("SubCon complete update mainConnectionID %d to state %d",mainConnectionID, connectionState));
            clAudioSMEngine::printMainConnectionList();

            ret = m_geniviControlIF->changeMainConnectionStateDB(mainConnectionID, connectionState);
            if(connectionState == CS_CONNECTED)
                m_ControlSenderBase->triggerPendingRequests(msgType::ConnectionRequest);
            return ret;
        }
    }
    else
    {
        // simple main connection
        ETG_TRACE_USR3(("m_geniviControlIF->changeMainConnectionStateDB MainID %d, state %d",mainConnectionID, connectionState));


        am_MainConnection_s mainConnectionData;
        m_geniviControlIF->getMainConnectionInfoDB(mainConnectionID,mainConnectionData);
        if(    (mainConnectionData.listConnectionID.size()>1) //if it is a gateway
                && (connectionState == CS_CONNECTED) ) //do it only for CS_CONNECTED
        {
            //new to get the source information, we have only sourceID here
            am_Source_s sourceData;
            m_geniviControlIF->getSourceInfoDB(mainConnectionData .sourceID, sourceData);

            if(sourceData.name.find('#') != string::npos)
            {
                sourceData.name = sourceData.name.erase(sourceData.name.find('#'));
            }

            //can do the same for sink name
            am_Sink_s sinkData;
            m_geniviControlIF->getSinkInfoDB(mainConnectionData.sinkID, sinkData);

            //now we know it
            ETG_TRACE_USR3(("Inform VolumeManager: source %s",sourceData.name.c_str()));
            ETG_TRACE_USR3(("Inform VolumeManager: sink %s",sinkData.name.c_str()));

            clGeniviAudioCtrlAdapter::getVolumeManager()->audioSourceRequest(sourceData.name,"DEMUTE",sinkData.name);
        }


        //return m_geniviControlIF->changeMainConnectionStateDB(mainConnectionID, connectionState);
        ret = m_geniviControlIF->changeMainConnectionStateDB(mainConnectionID, connectionState);
        //Connection got established by new/device audtoplay. Now
        //HACK VOLUME for LINE OUT
        if((sinkID==17) && (connectionState==CS_CONNECTED))
        {
            ETG_TRACE_ERR(("!!! HACK VOLUME for Cabine Out to 40 when connected to Sink 17 !!!"));
            (void)m_ControlSenderBase->hookUserVolumeChange(17,40);

        }
        //need to trigger
        if(connectionState == CS_CONNECTED)
            m_ControlSenderBase->triggerPendingRequests(msgType::ConnectionRequest);


        return ret;
    }
    return ret;
}

am_Error_e clGeniviAudioCtrlAdapter::changeSinkMuteStateDB(const am_MuteState_e muteState,
        const am_sinkID_t sinkId)
{
    ETG_TRACE_USR3(("changeSinkMuteStateDB: sinkId: %d, muteState: %d"
            , sinkId
            , ETG_CENUM(am_MuteState_e, muteState)));

    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);

    am_Sink_s sinkData;
    m_geniviControlIF->getSinkInfoDB(sinkId,sinkData);

    if(sinkData.muteState == muteState){
        ETG_TRACE_USR4(("changeSinkMuteStateDB::muteState is not changed, No need to send update !!"));
        return E_NO_CHANGE;
    }

    return m_geniviControlIF->changeSinkMuteStateDB(muteState, sinkId);
}

/**
 * update system property
 */
void clGeniviAudioCtrlAdapter::updateSystemPropertyDB(am_CustomSystemPropertyType_t etype,int16_t ivalue)
{
    ETG_TRACE_USR3(("updateSystemPropertyDB: property type: %d, value: %d", ETG_CENUM(am_CustomSystemPropertyType_t, etype),ivalue));
    if(m_ControlSenderBase==NULL)
    {
        ETG_TRACE_ERR(("m_ControlSenderBase==NULL"));
        return;
    }
    m_ControlSenderBase->vUpdateSystemPropertyDB(etype,ivalue);
    return;
}

am_Error_e clGeniviAudioCtrlAdapter::updateConnect(std::string SrcName,tU16 sinkID)
{

    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);

    //and establish this source also for Sink2
    am_mainConnectionID_t mainConnectionID = 0;
    std::vector<am_Source_s> listSources;
    ETG_TRACE_USR3(("updateConnect sinkID %d: %s", sinkID,SrcName.c_str()));
    //sourceID to gamsource id
    //go to registered sources
    if(m_geniviControlIF->getListSources(listSources)== E_OK)
    {
        for (std::vector<am_Source_s>::iterator it = listSources.begin() ; it != listSources.end(); ++it)
        {
            if ((it->name).compare(SrcName)==0 && (it->available).availability == A_AVAILABLE)
                return m_ControlSenderBase->hookUserConnectionRequest(it->sourceID,sinkID,mainConnectionID);

        }
    }
    ETG_TRACE_ERR(("updateConnect: genivi source not found for Source :%s", SrcName.c_str()));
    return E_NOT_POSSIBLE;
}

am_Error_e clGeniviAudioCtrlAdapter::setSinkVolume(am_Handle_s& handle, const am_sinkID_t sinkID, const am_volume_t volume, const am_CustomRampType_t ramp, const am_time_t time)
{
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);

    ETG_TRACE_USR3(("m_geniviControlIF->setSinkVolume: GAM sink %d, volume %d, ramp %d, time %d",sinkID, volume, ramp, time));
    handle.handleType=H_UNKNOWN;
    handle.handle =0;
    return m_geniviControlIF->setSinkVolume(handle, sinkID, volume, ramp, time);
}

#if defined(VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_INF4CV ) || defined(VARIANT_S_FTR_ENABLE_UNITTEST)
//we do not have source volume in Inf4CV
#else
am_Error_e clGeniviAudioCtrlAdapter::setSourceVolume(am_Handle_s& handle, const am_sourceID_t sourceID, const am_volume_t volume, const am_CustomRampType_t ramp, const am_time_t time)
{
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);

    ETG_TRACE_USR3(("m_geniviControlIF->setSourceVolume: GAM sink %d, volume %d, ramp %d, time %d",sourceID, volume, ramp, time));
    //ToDO: Swati, please check if O.K. for DUS ARL
    handle.handleType=H_UNKNOWN;
    handle.handle =0;

    return m_geniviControlIF->setSourceVolume(handle, sourceID, volume, ramp, time);
}
#endif
// ###################### need rework ###################
am_Error_e clGeniviAudioCtrlAdapter::setSourceState(am_Handle_s& handle,
        const am_sourceID_t sourceID, am_SourceState_e state)
{
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);

    ETG_TRACE_USR3(("setSourceState %d: GAM source %d, state %d"
            , (int)handle.handleType
            , (int)sourceID
            , ETG_CENUM(am_SourceState_e, state)));

    //this is only debug info
    if(state == am_SourceState_e::SS_OFF)
    {
        ETG_TRACE_USR3(("state = am_SourceState_e::SS_OFF"));
        //ToDo: check if this source is involved in some gateway.
        std::vector<am_MainConnection_s> listMainConnections;
        std::vector<am_MainConnection_s>::const_iterator mainCon_it;
        am_Error_e err = m_geniviControlIF->getListMainConnections(listMainConnections);
        if(err!=E_OK)
        {
            ETG_TRACE_ERR(("m_geniviControlIF->getListMainConnections gave err %d",err));
        }
        std::vector<am_Connection_s> listConnections;
        std::vector<am_Connection_s>::const_iterator con_it;
        err = m_geniviControlIF->getListConnections(listConnections);

        //find connection with sourceID
        am_connectionID_t connectionID=0;
        for(con_it = listConnections.begin();con_it != listConnections.end(); ++con_it)
        {
            ETG_TRACE_USR3(("setSourceState listConnections ID %d for sourceID %d --> SinkID %d",con_it->connectionID, con_it->sourceID, con_it->sinkID));
            if(con_it->sourceID == sourceID)
            {
                connectionID = con_it->connectionID;
                ETG_TRACE_USR3(("setSourceState SS_OFF: found connectionID = %d with matching sourceID = %d",connectionID, sourceID));
                //break;
            }
        }
        //what if we have more than one?


        if(connectionID!=0)
        {
            tBool bLeaveLoops = false;
            std::vector<am_connectionID_t>::const_iterator conID_it;
            for(mainCon_it = listMainConnections.begin();mainCon_it != listMainConnections.end(); ++mainCon_it)
            {
                ETG_TRACE_USR3(("setSourceState SS_OFF: found mainConnectionID = %d for source %d -> sink %d",mainCon_it->mainConnectionID,mainCon_it->sourceID,mainCon_it->sinkID));
                //inner loop through ConnectionIDs of each main connection
                for(conID_it = mainCon_it->listConnectionID.begin();conID_it != mainCon_it->listConnectionID.end(); ++conID_it)
                {
                    ETG_TRACE_USR3(("setSourceState SS_OFF: found sub connectionID = %d",*conID_it));
                    if(*conID_it == connectionID)
                    {
                        ETG_TRACE_USR3(("setSourceState SS_OFF: need to check for mainConnectionID %d: Src %d -> Sink %d",
                                mainCon_it->mainConnectionID,mainCon_it->sourceID,mainCon_it->sinkID));
                        ETG_TRACE_USR3(("Try removing main conn %d",mainCon_it->mainConnectionID));
                        ETG_TRACE_USR3(("containing SubCon %d",connectionID));

                        //ToDo?? Below is not working

                        //ControlSenderBase will check for possible route to bring down both
                        //m_ControlSenderBase->hookUserDisconnectionRequest(mainCon_it->mainConnectionID);
                        bLeaveLoops = true;
                        break;
                    }
                }
            } //for(mainCon_it
            ETG_TRACE_USR3(("We left the loop through main Connections (bLeaveLoops %d)",bLeaveLoops));
        }
        else
        {
            ETG_TRACE_USR3(("no connection ID found"));
        }
    } //if state == OFF

    ETG_TRACE_USR3(("Call m_geniviControlIF->setSourceState sourceID %d, state %d",sourceID, state));
    handle.handleType=H_UNKNOWN;
    handle.handle =0;
    return m_geniviControlIF->setSourceState(handle, sourceID, state);
}

void clGeniviAudioCtrlAdapter::cbAckSetVolumeChange(const am_Handle_s handle, const am_volume_t volume, const am_Error_e error)
{
    ETG_TRACE_USR3(("cbAckSetVolumeChange handle %d.%d, volume %d",handle.handleType, handle.handle, volume));

    //Let's see if we find out for whom this is
    std::map<am_sourceID_t, SourceID >::iterator it;
    for(it = m_registeredSources.begin(); it != m_registeredSources.end(); ++it)
    {
        clAudioSource* pSrc = clAudioSourceFactory::getAudioSource(it->second);
        if(pSrc == NULL) continue;
        //ETG_TRACE_USR3(("cbAckSetVolumeChange: for other source %s",pSrc->pacGetName()));
        const am_Handle_s* pHandle = pSrc->getSinkHandle(&handle); //daw2hi 8.3.2018 use sink handle
        if(pHandle != NULL)
        {
            ETG_TRACE_USR3(("cbAckSetVolumeChange for ExtGAM source %s",pSrc->pacGetName()));
            am_sinkID_t sinkID = pSrc->getSinkIDByHandle(pHandle);
            ETG_TRACE_USR3(("for sinkID %d in state %s",sinkID,pSrc->pacGetState(sinkID)));

            //daw2hi 9.3.2018 ToDo: check if better to call source with SinkVolumeChange and let source decide dependent on its state
            if(pSrc->pclGetState(sinkID) == clSrcStateFactory::pclCreateStartUnMute())
            {
                ETG_TRACE_USR3(("volume is %d call vMW_UnMuted",volume));
                pSrc->vMW_UnMuted(&handle,sinkID);
                ETG_TRACE_USR3(("new state %s",pSrc->pacGetState()));
                break;
            }
            else if(    (pSrc->pclGetState(sinkID) == clSrcStateFactory::pclCreateStartMute())
                    && (volume == MUTE_VOLUME) )
            {
                ETG_TRACE_USR3(("volume is %d call vMW_Muted",volume));
                pSrc->vMW_Muted(&handle,sinkID);
                ETG_TRACE_USR3(("new state %s",pSrc->pacGetState()));
                break;
            }
            else if(pSrc->pclGetState(sinkID) == clSrcStateFactory::pclCreateRampDownToPause())
            {
                pSrc->cbAckSetVolumeChange(&handle,sinkID);
                break;
            }
            else
            {
                std::string srcAndState(pSrc->pacGetName());
                srcAndState = srcAndState + " in state: ";
                if(pSrc->pclGetState(sinkID) != NULL)
                    srcAndState = srcAndState + pSrc->pclGetState(sinkID)->m_pacName;
                else
                    srcAndState = srcAndState + "NULL";

                ETG_TRACE_ERR(("WARNING: Pending Handle %d.%d, memory leak in source %s",
                        handle.handleType, handle.handle, srcAndState.c_str()));

                (void)pSrc->eraseSinkHandle(handle);
            }

        } //if(pHandle != NULL)

    } //for()

    ETG_TRACE_USR4(("cbAckSetVolumeChange: handle %d, handleType %d, errorID: %d"
            , handle.handle
            , handle.handleType
            , error));

}

void clGeniviAudioCtrlAdapter::cbAckSetSourceState(const am_Handle_s handle, const am_Error_e error)
{
    //Let's see if we find out for whom this is
    std::map<am_sourceID_t, SourceID >::iterator it;
    for(it = m_registeredSources.begin(); it != m_registeredSources.end(); ++it)
    {
        clAudioSource* pSrc = clAudioSourceFactory::getAudioSource(it->second);
        if(pSrc) pSrc->vCbAckSetSourceState(&handle);
    }

    ETG_TRACE_USR4(("cbAckSetSourceState: handle %d, handleType %d, errorID: %d"
            , handle.handle
            , handle.handleType
            , error));
}

sourceClassID clGeniviAudioCtrlAdapter::Ext2Int_SrcClass(midw_fi_tcl_e8_AudSource::tenType enSrcExt)
{
    //sourceClassID enSrcInternal = clFactory_AudioSourceClass::GetInvalidSourceClass();
    ETG_TRACE_USR4(("ExternalSrcClass_2_InternalSrcClass: External/midw_fi source id %d",
            ETG_CENUM(midw_fi_tcl_e8_AudSource::tenType, enSrcExt)));

    const clSourceClass* srcClass = clFactory_AudioSourceClass::GetSourceClass_extID(static_cast<midw_fi_tcl_e8_AudSource::tenType>(enSrcExt));
    //midw_fi_tcl_e8_AudSource::tenType extSrcID = static_cast<midw_fi_tcl_e8_AudSource::tenType>(clStackRules::rules[i].externalID);
    if(srcClass != NULL)
    {
        sourceClassID intID = srcClass->getClassID();
        ETG_TRACE_USR4(("Ext2Int_SrcClass: clStackRules=>ExtSrcID : %d, Mapped to IntSrcID : %d",
                ETG_CENUM(midw_fi_tcl_e8_AudSource::tenType,enSrcExt),
                intID));
        return intID;
    }else{
        ETG_TRACE_ERR(("Ext2Int_SrcClass: ERROR could not map ExternalID %d to internal SourceClass"
                , static_cast<tU16>(enSrcExt)));
        return clFactory_AudioSourceClass::GetInvalidSourceClass();
    }
}

clAudioSource* clGeniviAudioCtrlAdapter::pcoGetTopOfStack(tU16 sinkID)
{
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::pcoGetTopOfStack : %d", sinkID));
    return clAudioSourceController::getInstance().pcoGetTopOfStack(sinkID);
}

tBool clGeniviAudioCtrlAdapter::bIsCurrentActiveAudiosource(SourceID srcID,tU16 sinkID)
{
    tBool retVal = clAudioSourceController::getInstance().bIsCurrentActiveAudiosource(srcID,sinkID);
    ETG_TRACE_USR4(("bIsCurrentActiveAudiosource: SourceClass: %d subID %d: %d"
            , srcID.enSourceClass
            , srcID.u16SubSource
            , retVal));
    return retVal;
}

//rjk2kor : fix for Fix for SUZUKI-16966
clAudioSource* clGeniviAudioCtrlAdapter::pcoGetTopOfStackMixsource(tU16 sinkID)
{
    return clAudioSourceController::pcoGetTopOfStackMixsource(sinkID);
}

void clGeniviAudioCtrlAdapter::vHandleSourceError(midw_fi_tcl_e8_AudSource::tenType source, tU16 subSrc, tU16 ErrorCode)
{
    // daw2hi: we have now sufficient information via modified status message
    ETG_TRACE_ERR(("vHandleSourceError: Src=%d, SubSrc=%d, Error=%d",
            source,subSrc,ErrorCode));
    // need to get sourceClassID  enSourceClass from receive source
    SourceID srcID(Ext2Int_SrcClass(source), subSrc);
    clAudioSMEngine::vHandleSrcActError(srcID);
}

tBool clGeniviAudioCtrlAdapter::bIsCurrentSourceStackable(midw_fi_tcl_e8_AudSource::tenType source,tU16 subID)
{
    bool bIsStackable = false;
    if(source == midw_fi_tcl_e8_AudSource::FI_EN_NONE)
    {
        ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::bIsCurrentSourceStackable(),Ignoring source(0)/midw_fi_tcl_e8_AudSource::FI_EN_NONE"));
        return true;
    }

    sourceClassID srcClassID = (sourceClassID)clGeniviAudioCtrlAdapter::Ext2Int_SrcClass(source);
    const AudioStack::clSourceClass & srcClass = clFactory_AudioSourceClass::GetSourceClass(srcClassID);
    clAudioSource* pSrc = clAudioSourceFactory::getAudioSource(srcClass.SourceClassID,(tU8)subID);

    if(pSrc != NULL){
        if(pSrc->getSourceType().stackable){
            bIsStackable = true;
            ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::bIsCurrentSourceStackable(),new source is mix/announcement source"));
        }
        else{
            ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::bIsCurrentSourceStackable(),new source is not mix/announcement source"));
        }
    }
    return bIsStackable;
}

// daw2hi: keep for backward compatibility
void clGeniviAudioCtrlAdapter::handleSourceStatus(midw_fi_tcl_e8_SrcActivity::tenType activity, midw_fi_tcl_e8_AudSource::tenType source, tU16 subSrc)
{
    midw_fi_tcl_e8_ResourceNo::tenType sinkID = (midw_fi_tcl_e8_ResourceNo::tenType)1;
    handleSourceStatus(activity, source, subSrc, sinkID);
}


void clGeniviAudioCtrlAdapter::handleSourceStatus(midw_fi_tcl_e8_SrcActivity::tenType activity,
        midw_fi_tcl_e8_AudSource::tenType source, tU16 subSrc, midw_fi_tcl_e8_ResourceNo::tenType sinkID)
{
    //tBool bAttenuate = FALSE;
    ETG_TRACE_USR3(("handleSourceStatus: external sourceID %d, subID %d, activity %d, sinkID = %d"
            , ETG_CENUM(midw_fi_tcl_e8_AudSource::tenType, source)
            , subSrc
            , ETG_CENUM(midw_fi_tcl_e8_SrcActivity::tenType, activity)
            , sinkID));


    // We go to all registered source
    // and notify all with the corresponding SourceClass
    // because there might be more than one that matches
    std::map<am_sourceID_t, SourceID >::iterator iter = m_registeredSources.begin();
    while(iter != m_registeredSources.end())
    {
        clAudioSource* pSrc = clAudioSourceFactory::getAudioSource((*iter).second);
        ++iter;
        if((pSrc != NULL )
                && (clFactory_AudioSourceClass::GetExternalID(pSrc->sGetId()) == static_cast<tU32>(source))
                && (pSrc->sGetId().u16SubSource == subSrc))
        {
            ETG_TRACE_USR4(("handleSourceStatus: Inform internal sourceClass %d, subID %d, activity %d"
                    , pSrc->sGetId().enSourceClass
                    , pSrc->sGetId().u16SubSource
                    , ETG_CENUM(clGeniviAudioSource::enSourceActivity,activity)));

            //save the name here
            std::string tmpSrcName = pSrc->pacGetName();
            pSrc->vMW_CCAResponse(static_cast<tS32>(source), subSrc, Ext2Int_Activity(activity), static_cast<tU16>(sinkID));
            //here the pSrc might be invalid (not NULL, just invalid because the object it points to was destroyed)
            //temp. hack
            if(sinkID == 17)
            {
                //std::string srcName(pSrc->pacGetName());
                if(activity != midw_fi_tcl_e8_SrcActivity::FI_EN_ON)
                {
                    ETG_TRACE_USR4(("HACK: Call audioSourceRequest MUTE for Source %s",tmpSrcName.c_str()));
                    clGeniviAudioCtrlAdapter::getVolumeManager()->audioSourceRequest(tmpSrcName,"MUTE","AMP_A");
                }
                else
                {
                    ETG_TRACE_USR4(("HACK: No Call audioSourceRequest DEMUTE for Source %s",tmpSrcName.c_str()));
                    //clGeniviAudioCtrlAdapter::informVolumeManagerAboutMixActive();
                    //clGeniviAudioCtrlAdapter::getVolumeManager()->audioSourceRequest(srcName,"DEMUTE","AMP_A");
                }

            }
            //temp. hack end



            //handled in on_done and off_done
            break; //Solve blocking of Genivi Main loop (NCG3D-78107)   (daw2hi can not be the reason)
        }

    }
}

clGeniviAudioSource* clGeniviAudioCtrlAdapter::getAudioSource(SourceID srcID)
{
    std::map<am_sourceID_t, SourceID >::iterator iter = m_registeredSources.begin();
    while(iter != m_registeredSources.end())
    {
        if((*iter).second == srcID)
        {
            return static_cast<clGeniviAudioSource* >(clAudioSourceFactory::getAudioSource((*iter).second));
        }
        ++iter;
    }
    ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::getAudioSource: No Source found with SrcClass %d SubID %d"
            , srcID.enSourceClass
            , srcID.u16SubSource));
    return NULL;
}



void clGeniviAudioCtrlAdapter::SetAudioState(tS16 audioState)
{
    if(audioState == AM_MSP_AUDIO_OFF_MUTE_OFF)
    {
        clAudioSMEngine::vResetTime_Init();
    }
}

am_Error_e clGeniviAudioCtrlAdapter::vSetAmplifierMute(tU16 u16MuteValue)
{
    am_Error_e ret = E_UNKNOWN;
    const clSourceClass* pSrcClass_AmplifierMute = clFactory_AudioSourceClass::GetSourceClass("MUTE_NO_AUD_DEV");

    if(pSrcClass_AmplifierMute == NULL)
    {
        ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::vSetAmplifierMute MUTE_NO_AUD_DEV not found !!!"));
        return E_NON_EXISTENT;
    }

    switch(u16MuteValue)
    {
    case MUTE_NO_AUD_DEV_OFF :
    {
        ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::vSetAmplifierMute, Removing MUTE_NO_AUD_DEV"));
        ret = RequestSourceOff(SourceID(pSrcClass_AmplifierMute->getClassID(),0),1);
        break;
    }
    case MUTE_NO_AUD_DEV_ON :
    {
        ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::vSetAmplifierMute, Adding MUTE_NO_AUD_DEV"));
        ret = RequestSourceOn(SourceID(pSrcClass_AmplifierMute->getClassID(),0),1);
        break;
    }
    default :
    {
        ret = E_NON_EXISTENT;
        ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::vSetAmplifierMute, called for Non Existent value of MUTE_NO_AUD_DEV"));
        break;
    }
    }
    return ret;
}
/************************************************************************
 *FUNCTION     : vSetMuteOnStartUp
 *DESCRIPTION  : Apply "MUTE_HMISTARTUP" on stack on startup to mute the system on startup
             HMI should remove "MUTE_HMISTARTUP" once it is ready by calling setSystemSoundProperty()
 *PARAMETER    : tU16 uiValue
 *RETURN VALUE : am_Error_e
 *HISTORY      :
 *01.06.2015   Rev 1.0     RBEI/ECV2 - Vyankatesh VD  Initial Revision
 ************************************************************************/
am_Error_e clGeniviAudioCtrlAdapter::vSetMuteOnStartUp(tU16 uiValue, bool bStartup)
{
    am_Error_e ret = E_UNKNOWN;
    if(m_clientHandlerFcAudioMgr!=NULL)
    {
        ETG_TRACE_USR4(("Give dummy Trigger to fc_audiomanager to achieve volume update for sink 2"));
        m_clientHandlerFcAudioMgr->vSetAudioSource(midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_HP,
                (tU8)midw_fi_tcl_e8_AudSource::FI_EN_FM,
                (tU8)midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC);
    }

    return E_OK; // daw2hi Hack to not get this Mute


    const clSourceClass* pSrcClass_HmiStartupMute = clFactory_AudioSourceClass::GetSourceClass("MUTE_HMISTARTUP");

    if(pSrcClass_HmiStartupMute == NULL)
    {
        ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::vSetMuteOnStartUp MUTE_HMISTARTUP not found !!!"));
        return E_NON_EXISTENT;
    }

    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_UNKNOWN);

    am_SystemProperty_s systemproperty = {SYP_HMISTARTUP_MUTE,SYP_HMISTARTUP_MUTE_OFF};

    switch(uiValue)
    {
    case SYP_HMISTARTUP_MUTE_OFF :
    {
        ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::vSetMuteOnStartUp, setting SYP_HMISTARTUP_MUTE_OFF"));
        ret = RequestSourceOff(SourceID(pSrcClass_HmiStartupMute->getClassID(),0));
        m_geniviControlIF->changeSystemPropertyDB(systemproperty);

        break;
    }
    case SYP_HMISTARTUP_MUTE_ON :
    {
        if(bStartup) {
            ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::vSetMuteOnStartUp, setting SYP_HMISTARTUP_MUTE_ON"));
            ret = RequestSourceOn(SourceID(pSrcClass_HmiStartupMute->getClassID(),0));

            systemproperty.value = SYP_HMISTARTUP_MUTE_ON;
            m_geniviControlIF->changeSystemPropertyDB(systemproperty);
        }
        else{
            ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::vSetMuteOnStartUp,Not possible to set SYP_HMISTARTUP_MUTE_ON"));
            return E_NOT_POSSIBLE;
        }
        break;
    }
    default :
    {
        ret = E_NON_EXISTENT;
        ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::vSetMuteOnStartUp, called for Non Existent value of SYP_HMISTARTUP_MUTE"));
        break;
    }
    }
    return ret;
}

am_sinkID_t clGeniviAudioCtrlAdapter::getSinkID(std::string SinkName)
{

    std::vector<am_Sink_s> listSinks;
    am_Error_e err = m_geniviControlIF->getListSinks(listSinks);
    if(err != E_OK)
    {
        ETG_TRACE_USR4(("getListSinks() got error %d from daemon", err));
    }
    if(err == E_OK)
    {
        for (std::vector<am_Sink_s>::iterator it = listSinks.begin() ; it != listSinks.end(); ++it)
        {
            if ((it->name).compare(SinkName)==0)
                return it->sinkID ;

        }
    }

    return 0;
}


/************************************************************************
 *FUNCTION     : vSetMicMute
 *DESCRIPTION  : Apply "MUTE_MICROPHONE" on stack on startup to mute the system on startup
             HMI should remove "MUTE_HMISTARTUP" once it is ready by calling setSystemSoundProperty()
 *PARAMETER    : tU16 uiValue
 *RETURN VALUE : am_Error_e
 *HISTORY      :
 *01.06.2015   Rev 1.0     RBEI/ECV2 - Vyankatesh VD  Initial Revision
 ************************************************************************/
am_Error_e clGeniviAudioCtrlAdapter::vSetMicMute(bool bMutestate)
{
    am_Error_e ret = E_UNKNOWN;

    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::pSrcClass_Mute, setting MUTE_MICROPHONE %d",bMutestate));

    const clSourceClass* pSrcClass_Mute = clFactory_AudioSourceClass::GetSourceClass("MUTE_MICROPHONE");
    const clSourceClass* pSrcClass_MuteNonCabin = clFactory_AudioSourceClass::GetSourceClass("MUTE_MICROPHONE_NON_CABIN");


    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_UNKNOWN);
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(pSrcClass_Mute,E_UNKNOWN);
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(pSrcClass_MuteNonCabin,E_UNKNOWN);


    if(m_sinkList.size()>0)
    {
        std::map<unsigned int, struct sinkData>::iterator it = m_sinkList.begin();
        for(it=m_sinkList.begin(); it!=m_sinkList.end();it++)
        {
            if((it->second).s_sink.sinkID != 0 && (it->second).s_sink.visible == true)
            {
                if(bMutestate == false)
                {
                    if((it->second).s_sink.domainID == 1)
                    {
                        ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::pSrcClass_MuteNonCabin, setting MUTE_MICROPHONE_NON_CABIN OFF"));
                        ret = RequestSourceOff(SourceID(pSrcClass_MuteNonCabin->getClassID(),0),(it->second).s_sink.sinkID);
                    }
                    else if((it->second).s_sink.domainID == 101)
                    {
                        ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::pSrcClass_Mute, setting MUTE_MICROPHONE OFF"));
                        ret = RequestSourceOff(SourceID(pSrcClass_Mute->getClassID(),0),(it->second).s_sink.sinkID);

                    }
                }
                else
                {
                    /*if((it->second).s_sink.domainID == 1)
                    {
                        ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::pSrcClass_MuteNonCabin, setting MUTE_MICROPHONE_NON_CABIN ON"));
                        ret = RequestSourceOn(SourceID(pSrcClass_MuteNonCabin->getClassID(),0),(it->second).s_sink.sinkID);
                    }
                    else */if((it->second).s_sink.domainID == 101)
                    {
                        ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::pSrcClass_Mute, setting MUTE_MICROPHONE ON"));
                        ret = RequestSourceOn(SourceID(pSrcClass_Mute->getClassID(),0),(it->second).s_sink.sinkID);
                    }
                }
            }
        }
        // inform Volume Manager
        if(bMutestate == true)
        {
            static std::string srcMicPriv("MIC_PRIVATE");
            static std::string sinkAmpA("AMP_A");

            //clGeniviAudioCtrlAdapter::getVolumeManager()->vSetAudioSource(sinkAmpA,srcMicPriv,(tU8)midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC);
            ETG_TRACE_USR4(("Call audioSourceRequest"));
            clGeniviAudioCtrlAdapter::getVolumeManager()->audioSourceRequest(srcMicPriv,"DEMUTE",sinkAmpA);
        }
        else
        {
            //ToDo: check if AMP_A stack is empty, if yes send 0 Volume to Daemon (-> HMI)
            am_Sink_s sinkData;
            std::string sinkAmpA("AMP_A");
            am_sinkID_t sinkID= getSinkIDByName(sinkAmpA);

            if(sinkID != 0)
            {
                clStack * pStack = clAudioSourceController::pcoGetStack(sinkID);
                clAudioSource* pSrc = pStack->GetTopSource();
                if(pSrc == NULL)
                {
                    ETG_TRACE_USR4(("Stack AMP_A is empty, we send 0 volume"));
                    //Nothing on the Stack. Update with Volume 0
                    (void)m_geniviControlIF->changeSinkMainVolumeDB((am_mainVolume_t)0, sinkID);
                }
                else
                {
                    ETG_TRACE_USR4(("Stack AMP_A has TopSource %s",pSrc->pacGetName()));
                    ETG_TRACE_USR4(("handleed by VolumeManager"));
                }
            }
            else
            {
                ETG_TRACE_ERR(("could not get sinkID for AMP_A"));
            }
            //        	static std::string srcMicPriv("TUNER_FM");
            //       	    static std::string sinkAmpA("AMP_A");
            //
            //        	clGeniviAudioCtrlAdapter::getVolumeManager()->vSetAudioSource(sinkAmpA,srcMicPriv,(tU8)midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC);

        }
    }

    return ret;
}

am_sinkID_t clGeniviAudioCtrlAdapter::getSinkIDByName(std::string sinkName)
{
    //am_Error_e getListSinks(std::vector<am_Sink_s>& listSinks);
    std::vector<am_Sink_s> listSinks;
    if(E_OK == m_geniviControlIF->getListSinks(listSinks))
    {
        for(auto it=listSinks.begin();it!=listSinks.end();it++)
        {
            if(it->name == sinkName)
                return it->sinkID;
        }
    }
    return 0;


}



am_Error_e clGeniviAudioCtrlAdapter::vSetPersistentMute()
{
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);

    am_MuteState_e muteState = MS_MUTED;
    m_geniviControlIF->changeSinkMuteStateDB(muteState, 1);
    return E_OK;
}

/************************************************************************
 *FUNCTION     : vAudioStateLCMStatus
 *DESCRIPTION  : Set auto play parameter to TURE or FALSE based on
 *         audio state received from LCM.
 *PARAMETER    : spm_corefi_tclMsgAudioStateStatus&
 *RETURN VALUE : tVoid
 *HISTORY      :
 *08.10.2015   Rev 1.0     RBEI/ECV2 - Parusharam J  Initial Revision
 ************************************************************************/
tVoid clGeniviAudioCtrlAdapter::vAudioStateLCMStatus(spm_corefi_tclMsgAudioStateStatus& oStatus)
{
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::vAudioStateLCMStatus() entered"));
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::vAudioStateLCMStatus() audiostate=%d", oStatus.AudioState.enType));
    switch(oStatus.AudioState.enType)
    {
    case spm_fi_tcl_SPM_e32_AUDIO_STATE::FI_EN_SPM_U32_AUDIOSTATE_OFF:
    case spm_fi_tcl_SPM_e32_AUDIO_STATE::FI_EN_SPM_U32_AUDIOSTATE_LIMITED:
    {
        m_bEnableAutoPlay = FALSE;
    }
    break;
    case spm_fi_tcl_SPM_e32_AUDIO_STATE::FI_EN_SPM_U32_AUDIOSTATE_EMERGENCY:
    case spm_fi_tcl_SPM_e32_AUDIO_STATE::FI_EN_SPM_U32_AUDIOSTATE_NORMAL:
    {
        m_bEnableAutoPlay = TRUE;
    }
    break;
    default:
    {
        m_bEnableAutoPlay = TRUE;
    }
    break;
    }
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::vAudioStateLCMStatus() m_bEnableAutoPlay=%d", m_bEnableAutoPlay));
}

/************************************************************************
 *FUNCTION     : LoadVolContext
 *DESCRIPTION  : function to load correct volume context in volume manager
 *PARAMETER    : clAudioSource*, clAudioSource*
 *RETURN VALUE : Void
 *HISTORY      :
 *30.06.2016   Rev 1.0     RBEI/ECO12 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid clGeniviAudioCtrlAdapter::vLoadVolumeContext(clAudioSource* pSrcRemoved)
{
    vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_clientHandlerFcAudioMgr);
    vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(pSrcRemoved);

    ETG_TRACE_USR1(("vLoadVolumeContext: Entered for source %s",pSrcRemoved->pacGetName()));

    clAudioSource* pNextPossibleSource  = clAudioSourceController::getInstance().pcoGetFirstNonMuteSrcFromStack();
    clAudioSource* pCurrActiveSource = clAudioSourceController::getInstance().pcoGetCurrentActiveAudiosource();

    if((NULL != pNextPossibleSource) && (NULL != pCurrActiveSource))
    {
        ETG_TRACE_USR1(("vLoadVolumeContext: pNextPossibleSource: %d,pCurrActiveSource: %d",
                pNextPossibleSource->getSourceClass().getClassID(),pCurrActiveSource->getSourceClass().getClassID()));

        if((pCurrActiveSource->pclGetState(midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS) ==  clSrcStateFactory::pclCreateRampUpRequesting()))
        {//For Bug: 1433896 
            ETG_TRACE_USR1(("vLoadVolumeContext: Loading Volume Context as Current active source is in Rampup requesting For SrcID: %d",
                        pNextPossibleSource->getSourceClass().getClassID()));
                        m_clientHandlerFcAudioMgr->vSetAudioSource(midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS,
                                (tU8)clFactory_AudioSourceClass::GetExternalID(pNextPossibleSource->sGetId()),
                                (tU8)midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC);
        }
        /*
         *  AST:  --------TOP--------
         *  AST:      TUNER_TA_FM : on
         *  AST:   MUTE_ENTERTAIN : pause
         *  AST:         MEDIA : pause
         *  AST:  ------BOTTOM-------
         *
         *  Case1: Media Removed : pSrcRemoved->Media, pNextPossibleSource->TUNER_TA_FM, pCurrActiveSource->TUNER_TA_FM
         */
        if(pCurrActiveSource->getSourceClass().getClassID() == pNextPossibleSource->getSourceClass().getClassID())
        {
            ETG_TRACE_USR1(("vLoadVolumeContext: No Need to Load Volume Context, as it is Active source : %d",
                    pNextPossibleSource->getSourceClass().getClassID()));
        }
        else if(clSrcStateFactory::pclCreateOn() != pNextPossibleSource->pclGetState())
        {
            ETG_TRACE_USR1(("vLoadVolumeContext: Loading Volume Context For SrcID: %d",
                    pNextPossibleSource->getSourceClass().getClassID()));
            m_clientHandlerFcAudioMgr->vSetAudioSource(midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS,
                    (tU8)clFactory_AudioSourceClass::GetExternalID(pNextPossibleSource->sGetId()),
                    (tU8)midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC);
        }
        else
        {
            /*
             *  AST:  --------TOP--------
             *  AST:      NAVI_SPEECH :  on
             *  AST:      TUNER_TA_FM :  on
             *  AST:  SDS_SPEECHRECOGNITION :pause
             *  AST:   MEDIA_PLAYER#1 :pause
             *  AST:  ------BOTTOM-------
             *
             *  If Media is removed then pSrcRemoved->Media, pNextPossibleSource->NAVI_SPEECH, pCurrActiveSource->TUNER_TA_FM
             */
            ETG_TRACE_USR1(("vLoadVolumeContext: No Need to Load Volume Context, as possible Next source is already ON"));
        }
    }
    else
    {
        /*
         * Use case when source report error for SrcActOn() request
         * In this case when error is reported, src is removed from stack and stack became empty.
         * If volume operation is performed when stack is empty,it should be applied to default source
         */
        ETG_TRACE_USR1(("vLoadVolumeContext: pNextPossibleSource is NULL, May be STACK is EMPTY !!"));
        if(pSrcRemoved->u16GetCurActSink() >= 100) //for dyn sink we don't do anything
        {
            ETG_TRACE_USR1(("No action for source connected to dyn SinkID %d",pSrcRemoved->u16GetCurActSink()));
        }
        else
        {
            SourceID lastSource (clFactory_AudioSourceClass::GetDefaultSourceClass(),0);

            if (clAudioSMEngine::bIsSourceAvailable(lastSource)){
                ETG_TRACE_USR1(("vLoadVolumeContext: Loading Volume Context For Default Source: %d skipped",lastSource.enSourceClass));
                //m_clientHandlerFcAudioMgr->vSetAudioSource(midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS,(tU8)clFactory_AudioSourceClass::GetExternalID(lastSource),midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC);
            }
            else{
                ETG_TRACE_USR1(("vLoadVolumeContext: Default Source: %d is not Available !!",lastSource.enSourceClass));
            }
        }

    }
}
/************************************************************************
 *FUNCTION     : bIsAutoplayEnabled
 *DESCRIPTION  : returns TRUE if auto play is enabled otherwise FALSE
 *PARAMETER    : void
 *RETURN VALUE : tBool
 *HISTORY      :
 *08.10.2015  Rev 1.0     RBEI/ECV2 - Parusharam J  Initial Revision
 ************************************************************************/
tBool clGeniviAudioCtrlAdapter::bIsAutoplayEnabled()
{
    //No autoplay if we are in Diag Session
    if(true == clAudioSourceController::getInstance().bIsTopOfBackUpStackMuteAndOn())
    {
        ETG_TRACE_USR4(("DiagMode is active, autoplay is disabled for all sources"));
        return false;
    }

    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::bIsAutoplayEnabled() m_bEnableAutoPlay=%d", m_bEnableAutoPlay));
    return m_bEnableAutoPlay;
}

tBool clGeniviAudioCtrlAdapter::bAudioDeviceAvailability()
{
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_clientHandlerFcAudioMgr,false);
    return(m_clientHandlerFcAudioMgr->bGetbAudioDeviceAvailability());
}

/************************************************************************
 *FUNCTION     : vSetEntertainmentMute
 *DESCRIPTION  : method to inform fc_audiMgr about Entertainment Mute/DeMute
 *PARAMETER    : void
 *RETURN VALUE : tBool
 *HISTORY      :
 *21.08.2017  Rev 1.0     RBEI/ECO1 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid clGeniviAudioCtrlAdapter::vSetEntertainmentMute(const am_MuteState_e muteState)
{
    ETG_TRACE_USR4(("CAmControlSenderBase::vSetEntertainmentMute called with muteState= %d",muteState));
    vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_clientHandlerFcAudioMgr);

    switch (muteState)
    {
    case MS_MUTED:
    {
        ETG_TRACE_USR4(("CAmControlSenderBase::vSetEntertainmentMute, Calling vSetEntertainmentMute(MUTE) to mute all main streams"));
        m_clientHandlerFcAudioMgr->vSetEntertainmentMute(
                midw_fi_tcl_e8_MuteRequester::FI_EN_GENIVIAUDIOMANAGER,
                midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS,
                midw_fi_tcl_e8MuteAction::FI_EN_MUTE,
                midw_fi_tcl_b32MuteReason::FI_C_U32_BIT_MUTE_REAS_OTHER);

        break;
    }
    case MS_UNMUTED:
    {
        ETG_TRACE_USR4(("CAmControlSenderBase::vSetEntertainmentMute, Calling vSetEntertainmentMute(DEMUTE) to mute all main streams"));
        m_clientHandlerFcAudioMgr->vSetEntertainmentMute(
                midw_fi_tcl_e8_MuteRequester::FI_EN_GENIVIAUDIOMANAGER,
                midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS,
                midw_fi_tcl_e8MuteAction::FI_EN_DEMUTE,
                midw_fi_tcl_b32MuteReason::FI_C_U32_BIT_MUTE_REAS_OTHER);

        break;
    }
    default:
        ETG_TRACE_USR4(("CAmControlSenderBase::vSetEntertainmentMute, default"));
    }
}




//Want to use this for triggering delayed ON state to tell source to start streaming
void clGeniviAudioCtrlAdapter::SetMainSourceSoundProperty(const am_sourceID_t sourceID, const am_MainSoundProperty_s & /* soundProperty */)
{
    //std::map<am_sourceID_t, SourceID >            clGeniviAudioCtrlAdapter::m_registeredSources;
    std::map<am_sourceID_t, SourceID >::const_iterator iter = m_registeredSources.find(sourceID);

    if(iter != m_registeredSources.end())
    {
        clAudioSource* pAudioSource = clAudioSourceFactory::getAudioSource(iter->second);
        if(pAudioSource!=NULL)
        {
            pAudioSource->setMainSourceSoundProperty();
        }
    }
}

//############################ all trace methods ##########################
void clGeniviAudioCtrlAdapter::vTraceMainCon()
{
    if(m_geniviControlIF==NULL) return;

    std::vector<am_MainConnection_s> listMainConnections;
    m_geniviControlIF->getListMainConnections(listMainConnections);
    std::vector<am_MainConnection_s>::iterator iter = listMainConnections.begin();
    std::vector<am_connectionID_t>::const_iterator conID_it;
    ETG_TRACE_USR4(("List Main Connections"));
    while(iter != listMainConnections.end())
    {
        ETG_TRACE_USR4(("\nMainConID %d: SourcID %d -> SinkID %d : listConnectionID size %d",
                iter->mainConnectionID,iter->sourceID,iter->sinkID, iter->listConnectionID.size()));
        ETG_TRACE_USR4(("listConnectionIDs:"));
        for(conID_it = iter->listConnectionID.begin();conID_it != iter->listConnectionID.end(); ++conID_it)
        {
            ETG_TRACE_USR4(("ID %d",*conID_it));
        }
        ++iter;
    }
}
void clGeniviAudioCtrlAdapter::vTraceAllCon()
{
    if(m_geniviControlIF==NULL) return;

    std::vector<am_Connection_s> listConnections;
    m_geniviControlIF->getListConnections(listConnections);
    std::vector<am_Connection_s>::iterator iter = listConnections.begin();
    ETG_TRACE_USR4(("List Connections"));
    while(iter != listConnections.end())
    {
        ETG_TRACE_USR4(("ConID %d: SourcID %d -> SinkID %d",iter->connectionID,iter->sourceID,iter->sinkID));
        ++iter;
    }
}

void clGeniviAudioCtrlAdapter::vTraceAllDomains()
{
    if(m_geniviControlIF==NULL) return;

    //virtual am_Error_e getListDomains(std::vector<am_Domain_s>& listDomains) const =0;
    std::vector<am_Domain_s> listDomains;
    am_Error_e err = m_geniviControlIF->getListDomains(listDomains);
    if(err != E_OK)
    {
        ETG_TRACE_USR4(("getListDomains() got error %d from daemon", err));
    }
    std::vector<am_Domain_s>::iterator iter = listDomains.begin();
    ETG_TRACE_USR4(("List All Domains"));
    while(iter != listDomains.end())
    {
        ETG_TRACE_USR4(("ID %d",iter->domainID));
        ETG_TRACE_USR4(("Name %s",iter->name.c_str()));
        ETG_TRACE_USR4(("BusName %s",iter->busname.c_str()));
        ETG_TRACE_USR4(("NodeName %s",iter->nodename.c_str()));
        ETG_TRACE_USR4(("-------------------------------------"));
        ++iter;
    }

}

void clGeniviAudioCtrlAdapter::vTraceAllSources()
{
    if(m_geniviControlIF==NULL) return;

    //am_Error_e getListSources(std::vector<am_Source_s>& listSources) const =0;
    std::vector<am_Source_s> listSources;
    am_Error_e err = m_geniviControlIF->getListSources(listSources);
    if(err != E_OK)
    {
        ETG_TRACE_USR4(("getListSources() got error %d from daemon", err));
    }

    std::vector<am_Source_s>::iterator iter = listSources.begin();
    ETG_TRACE_USR4(("List All Sources"));
    while(iter != listSources.end())
    {
        ETG_TRACE_USR4(("sourceID %d: %s",iter->sourceID,iter->name.c_str()));
        ETG_TRACE_USR4(("domainID %d",iter->domainID));
        ETG_TRACE_USR4(("sourceClassID %d",iter->sourceClassID));
        ETG_TRACE_USR4(("visible %d",iter->visible));
        ETG_TRACE_USR4(("available %d / %d",iter->available.availability,iter->available.availabilityReason));
        ETG_TRACE_USR4(("sourceState %d",iter->sourceState));
        ETG_TRACE_USR4(("volume %d",iter->volume));
        ETG_TRACE_USR4(("-------------------------------------"));
        ++iter;
    }
}

void clGeniviAudioCtrlAdapter::vTraceInitDPwithFM()
{
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::vTraceInitDPwithFM() call clAudioSMEngine::SetDP()"));
    clAudioSMEngine::SetDP();
}

void clGeniviAudioCtrlAdapter::vTraceSetDPforSink(tU16 sink, tU16 lastSource)
{
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::vTraceSetDPforSink() call clAudioSMEngine::SetDPForSinkID(sink %d, lastSource %d)",sink,lastSource));
    clAudioSMEngine::SetDPForSinkID(sink,lastSource);
}

void clGeniviAudioCtrlAdapter::vTraceSetDPSubIDforSink(tU16 sink, tU16 subID)
{
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::vTraceSetDPforSink() call clAudioSMEngine::SetDPForSinkID(sink %d, subID %d)",sink,subID));
    clAudioSMEngine::SetDPSubIDForSinkID(sink,subID);
}

void clGeniviAudioCtrlAdapter::vTraceClearDPforSink(tU16 sink)
{
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::vTraceClearDPforSink() call clAudioSMEngine::ClearDPForSinkID(sink %d)",sink));
    clAudioSMEngine::ClearDPForSinkID(sink);
}

void clGeniviAudioCtrlAdapter::vTraceAllSinks()
{
    if(m_geniviControlIF==NULL) return;

    //am_Error_e getListSinks(std::vector<am_Sink_s>& listSinks) const =0;
    std::vector<am_Sink_s> listSinks;
    am_Error_e err = m_geniviControlIF->getListSinks(listSinks);
    if(err != E_OK)
    {
        ETG_TRACE_USR4(("getListSinks() got error %d from daemon", err));
    }
    std::vector<am_Sink_s>::iterator iter = listSinks.begin();
    ETG_TRACE_USR4(("List All Sinks"));
    while(iter != listSinks.end())
    {
        ETG_TRACE_USR4(("sinkID %d: %s",iter->sinkID,iter->name.c_str()));
        ETG_TRACE_USR4(("domainID %d",iter->domainID));
        ETG_TRACE_USR4(("sinkClassID %d",iter->sinkClassID));
        ETG_TRACE_USR4(("visible %d",iter->visible));
        ETG_TRACE_USR4(("available %d / %d",iter->available.availability,iter->available.availabilityReason));
        ETG_TRACE_USR4(("muteState %d",iter->muteState));
        ETG_TRACE_USR4(("volume %d",iter->volume));
        ETG_TRACE_USR4(("mainVolume %d",iter->mainVolume));
        ETG_TRACE_USR4(("-------------------------------------"));
        ++iter;
    }
}

void clGeniviAudioCtrlAdapter::vTraceSourceData(tU16 sourceID)
{
    if(m_geniviControlIF==NULL) return;

    am_Source_s sourceData;
    sourceData.sourceID = 0;
    sourceData.domainID=0;
    sourceData.sourceClassID = 0;
    sourceData.sourceState = SS_OFF;
    sourceData.visible = false;
    sourceData.volume = 0;
    sourceData.interruptState = IS_UNKNOWN;
    sourceData.listConnectionFormats.clear();
    sourceData.listMainNotificationConfigurations.clear();
    sourceData.listMainSoundProperties.clear();
    sourceData.listNotificationConfigurations.clear();
    sourceData.name = std::string("");
    sourceData.sourceClassID = 0;
    sourceData.sourceID = 0;
    sourceData.sourceState = SS_UNKNNOWN;
    sourceData.visible = false;
    sourceData.volume = (am_volume_t)0;


    am_Error_e err = m_geniviControlIF->getSourceInfoDB(sourceID,sourceData);
    if(err != E_OK)
    {
        ETG_TRACE_ERR(("err = %d, below data not reliable",err));
    }
    ETG_TRACE_USR4(("Data for SourceID %d",sourceData.sourceID));
    ETG_TRACE_USR4(("DomainID %d",sourceData.domainID));
    ETG_TRACE_USR4(("name %s",sourceData.name.c_str()));
    ETG_TRACE_USR4(("classID %d",sourceData.sourceClassID));
    ETG_TRACE_USR4(("state %d",sourceData.sourceState));
    ETG_TRACE_USR4(("visible %d",sourceData.visible));
    ETG_TRACE_USR4(("volume %d",sourceData.volume));
    ETG_TRACE_USR4(("availability %d, reason %d\n",sourceData.available.availability,sourceData.available.availabilityReason));

    std::vector<am_MainSoundProperty_s>::iterator itMsp;
    for(itMsp=sourceData.listMainSoundProperties.begin();itMsp!=sourceData.listMainSoundProperties.end();++itMsp)
    {
        ETG_TRACE_USR4(("MainSoundProperty: type %d (0x%x), value %d",itMsp->type,itMsp->type,itMsp->value));
    }
    ETG_TRACE_USR4(("\n"));

    std::vector<am_SoundProperty_s>::iterator itSp;
    for(itSp=sourceData.listSoundProperties.begin();itSp!=sourceData.listSoundProperties.end();++itSp)
    {
        ETG_TRACE_USR4(("SoundProperty: type %d (0x%x), value %d",itSp->type,itSp->type,itSp->value));
    }
    ETG_TRACE_USR4(("\n"));

    std::vector<am_CustomConnectionFormat_t> ::iterator itCf;
    for(itCf=sourceData.listConnectionFormats.begin();itCf!=sourceData.listConnectionFormats.end();++itCf)
    {
        ETG_TRACE_USR4(("ConnectionFormat: %d",*itCf));
    }
    ETG_TRACE_USR4(("\n"));
}
void clGeniviAudioCtrlAdapter::vTraceSinkData(tU16 sinkID)
{
    if(m_geniviControlIF==NULL) return;

    am_Sink_s sinkData;
    am_Error_e err = m_geniviControlIF->getSinkInfoDB(sinkID,sinkData);
    if(err!=E_OK)
    {
        ETG_TRACE_ERR(("m_geniviControlIF->getSinkInfoDB for sinkID %d gave err %d",sinkID,err));
    }

    ETG_TRACE_USR4(("Data for SinkID %d",sinkData.sinkID));
    ETG_TRACE_USR4(("DomainID %d",sinkData.domainID));
    ETG_TRACE_USR4(("name %s",sinkData.name.c_str()));
    ETG_TRACE_USR4(("classID %d",sinkData.sinkClassID));
    ETG_TRACE_USR4(("visible %d",sinkData.visible));
    ETG_TRACE_USR4(("volume %d",sinkData.volume));
    ETG_TRACE_USR4(("mainVolume %d",sinkData.mainVolume));
    ETG_TRACE_USR4(("muteState %d",sinkData.muteState));
    ETG_TRACE_USR4(("availability %d, reason %d",sinkData.available.availability,sinkData.available.availabilityReason));

    std::vector<am_MainSoundProperty_s>::iterator itMsp;
    for(itMsp=sinkData.listMainSoundProperties.begin();itMsp!=sinkData.listMainSoundProperties.end();++itMsp)
    {
        ETG_TRACE_USR4(("MainSoundProperty: type %d (0x%x), value %d",itMsp->type,itMsp->type,itMsp->value));
    }
    ETG_TRACE_USR4(("\n"));

    std::vector<am_SoundProperty_s>::iterator itSp;
    for(itSp=sinkData.listSoundProperties.begin();itSp!=sinkData.listSoundProperties.end();++itSp)
    {
        ETG_TRACE_USR4(("SoundProperty: type %d (0x%x), value %d",itSp->type,itSp->type,itSp->value));
    }
    ETG_TRACE_USR4(("\n"));

    std::vector<am_CustomConnectionFormat_t> ::iterator itCf;
    for(itCf=sinkData.listConnectionFormats.begin();itCf!=sinkData.listConnectionFormats.end();++itCf)
    {
        ETG_TRACE_USR4(("ConnectionFormat: %d",*itCf));
    }
    ETG_TRACE_USR4(("\n"));
}

void clGeniviAudioCtrlAdapter::privateModeAdditionalActions(tU16 u16PrivateMode)
{
    ETG_TRACE_USR4(("privateModeAdditionalActions mode %d",u16PrivateMode));
    //check if phone is active on sink matching this priv mode
    clAudioSource* pSrcSink1 = pcoGetTopOfStack(1);
    clAudioSource* pSrcSink2 = pcoGetTopOfStack(2);
    if(pSrcSink1)
    {
        //check if we have priv mode dependant different sinks
        const clSourceClass srcClass =  pSrcSink1->getSourceClass();
        ETG_TRACE_USR1(("Sink class %s",srcClass.getName().c_str()));
        for(unsigned int i=0;i<srcClass.m_u16PrivateModeList.size();i++)
        {
            ETG_TRACE_USR1(("mode[%d] -> Sink %d",i,srcClass.m_u16PrivateModeList[i]));
        }
    }
    if(pSrcSink2)
    {
        //check if we have priv mode dependant different sinks
        const clSourceClass srcClass =  pSrcSink2->getSourceClass();
        ETG_TRACE_USR1(("Sink class %s",srcClass.getName().c_str()))
        for(unsigned int i=0;i<srcClass.m_u16PrivateModeList.size();i++)
        {
            ETG_TRACE_USR1(("mode[%d] -> Sink %d",i,srcClass.m_u16PrivateModeList[i]));
        }
    }

    if( (pSrcSink1) && (pSrcSink1->getSourceClass().m_u16PrivateModeList.size() != 0) )
    {
        ETG_TRACE_USR4(("Source on Sink 1 %s",pSrcSink1->pacGetName()));
        ETG_TRACE_USR4(("has private mode dependant sinks. Source type is %s",pSrcSink1->getSourceType().name.c_str()));

        std::string srcName(pSrcSink1->pacGetName());
        std::string srcTypeName = pSrcSink1->getSourceType().name;
        //midw_fi_tcl_e8_AudioChannel channel(midw_fi_tcl_e8_AudioChannel::tenType::FI_EN_AUDIO_CHANNEL_EXC);
        //channel.enType = midw_fi_tcl_e8_AudioChannel::tenType::FI_EN_AUDIO_CHANNEL_EXC;

        if(pSrcSink1->getSourceType().name.compare("mix")==0)
        {
            //lets mute the other
            SourceID srcID = pSrcSink1->sGetId();
            tU16 sink = u8GetSinkID(srcID);
            if(sink!=1)
            {
                m_clientHandlerFcAudioMgr->vSetMute(
                                        midw_fi_tcl_e8_MuteRequester::FI_EN_GENIVIAUDIOMANAGER,
                                        midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS,
                                        midw_fi_tcl_e8MuteAction::FI_EN_MUTE,
                                        1,//not used
                                        midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_MIX);
            }

        }
        //if(srcName.compare(0,6,"PHONE#")==0)
        //Phone on Sink 1
        SourceID srcID = pSrcSink1->sGetId();
        tU16 sink = u8GetSinkID(srcID);
        if(sink!=1)
        {
            m_clientHandlerFcAudioMgr->vSetMute(
                    midw_fi_tcl_e8_MuteRequester::FI_EN_GENIVIAUDIOMANAGER,
                    midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_HP,
                    midw_fi_tcl_e8MuteAction::FI_EN_DEMUTE,
                    1,//not used
                    midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC);

            ETG_TRACE_USR4(("Phone or SDS active on Sink %d, privModeChange needs Sink %d",1,sink));
            // source name, old sink, new sink
            clAudioSourceController::setPrivateModeSourceSwitch(srcName,1,sink);
            RequestSourceOn(srcID,sink);
            ETG_TRACE_USR4(("MUTE Sink 1"));
            m_clientHandlerFcAudioMgr->vSetMute(
                    midw_fi_tcl_e8_MuteRequester::FI_EN_GENIVIAUDIOMANAGER,
                    midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS,
                    midw_fi_tcl_e8MuteAction::FI_EN_MUTE,
                    1,//not used
                    midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC);
        }
    }
    else
    {
        ETG_TRACE_USR4(("This source has no mode dependant sinks, no action"));
    }

    if( (pSrcSink2) && (pSrcSink2->getSourceClass().m_u16PrivateModeList.size() != 0) )
    {
        ETG_TRACE_USR4(("Source on Sink 2 %s",pSrcSink2->pacGetName()));
        ETG_TRACE_USR4(("has private mode dependant sinks. Source type name = %s",pSrcSink2->getSourceType().name));

        std::string srcName(pSrcSink2->pacGetName());
        std::string srcTypeName = pSrcSink2->getSourceType().name;
        if(pSrcSink2->getSourceType().name.compare("mix")==0)
        {
             //lets mute the other
             SourceID srcID = pSrcSink1->sGetId();
             tU16 sink = u8GetSinkID(srcID);
             if(sink!=2)
             {
                 m_clientHandlerFcAudioMgr->vSetMute(
                                         midw_fi_tcl_e8_MuteRequester::FI_EN_GENIVIAUDIOMANAGER,
                                         midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_HP,
                                         midw_fi_tcl_e8MuteAction::FI_EN_MUTE,
                                         1,//not used
                                         midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC);
             }
        }
        //Phone on Sink 2
        SourceID srcID = pSrcSink2->sGetId();
        tU16 sink = u8GetSinkID(srcID);
        if(sink!=2)
        {
            m_clientHandlerFcAudioMgr->vSetMute(
                    midw_fi_tcl_e8_MuteRequester::FI_EN_GENIVIAUDIOMANAGER,
                    midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS,
                    midw_fi_tcl_e8MuteAction::FI_EN_DEMUTE,
                    1,//not used
                    midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC);
            ETG_TRACE_USR4(("Phone or SDS active on Sink %d, privModeChange needs Sink %d",2,sink));
            clAudioSourceController::setPrivateModeSourceSwitch(srcName,2,sink);
            RequestSourceOn(srcID,sink);
            ETG_TRACE_USR4(("MUTE Sink 2"));
            m_clientHandlerFcAudioMgr->vSetMute(
                    midw_fi_tcl_e8_MuteRequester::FI_EN_GENIVIAUDIOMANAGER,
                    midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_HP,
                    midw_fi_tcl_e8MuteAction::FI_EN_MUTE,
                    1,//not used
                    midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC);
         }
    }
    else
    {
        ETG_TRACE_USR4(("This source has no mode dependant sinks, no action"));
    }
    
    return;
}

am_Error_e clGeniviAudioCtrlAdapter::eSetPrivateMode(tU16 u16PrivateMode)
{
    if(u16PrivateMode >= PRIVATE_MODE_1 && u16PrivateMode <= PRIVATE_MODE_3)
    {
        m_u16PrivateMode = u16PrivateMode;
        ETG_TRACE_USR4(("eSetPrivateMode::m_u16PrivateMode = %d", m_u16PrivateMode));

        AudioUserDpIf* pAudUsrDpIf = AudioUserDpIfSelect::pGetAudUsrDpIf();
        if(pAudUsrDpIf && m_ControlSenderBase)
        {
            pAudUsrDpIf->s32SetPrivateMode(m_u16PrivateMode);
            m_ControlSenderBase->vUpdateSystemPropertyDB(SYP_PRIVATE_MODE, m_u16PrivateMode);
	    //Commented the private mode switching RTC1-2176345
           // clGeniviAudioCtrlAdapter::privateModeAdditionalActions(u16PrivateMode);
            return E_OK;
        }
    }

    return E_NOT_POSSIBLE;
}
am_Error_e clGeniviAudioCtrlAdapter::eGetPrivateMode(tU16& u16PrivateMode)
{
    AudioUserDpIf* pAudUsrDpIf = AudioUserDpIfSelect::pGetAudUsrDpIf();
    if(pAudUsrDpIf)
    {
        pAudUsrDpIf->s32GetPrivateMode(u16PrivateMode);
        return E_OK;
    }
    return E_NOT_POSSIBLE;
}

void clGeniviAudioCtrlAdapter::vSetPrivateModeMixVolume(tU16 u16PrivateModeMixVolume,tU16 sinkID)
{
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::vSetPrivateModeMixVolume, u16PrivateModeMixVolume = %d for sinkID %d",
            u16PrivateModeMixVolume, sinkID));
    m_u16PrivateModeMixVolume = u16PrivateModeMixVolume;
    AudioUserDpIf* pAudUsrDpIf = AudioUserDpIfSelect::pGetAudUsrDpIf();
    int sinkIndex = clGeniviAudioCtrlAdapter::GetSinkIndex(sinkID);
    if(sinkIndex <= -1) return;
    if(pAudUsrDpIf)
    {
        pAudUsrDpIf->s32SetPrivateModeMixVolume(u16PrivateModeMixVolume,(tU16)sinkIndex);

        // For ADR domain we check if any source is active on Sink 2 (private Speaker). Only then we should call.
        // Otherwise we modify the main volume like a volume bar change
        if(   (sinkID == midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS)
           && (NULL != clAudioSourceController::pcoGetTopOfStack(midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_HP)))
        {
            ETG_TRACE_USR4(("Call AddAttenuationFilter for ADR domain"));
            AddAttenuationFilter(sinkID);
        }
        // For AVB domain we check if mix source is active on the sink. Only then we should call.
        // Otherwise we modify the main volume like a volume bar change
        else if( (sinkID>100) && (NULL != clAudioSourceController::pcoGetTopOfStackMixsource(sinkID)) )
        {
            ETG_TRACE_USR4(("Call AddAttenuationFilter for AVB domain"));
            AddAttenuationFilter(sinkID);
        }
    }
    if(m_ControlSenderBase)
        m_ControlSenderBase->vUpdateSinkSoundPropertyDB(MSP_PRIVATE_MODE_MIX_VOLUME, u16PrivateModeMixVolume,sinkID);
}

tU16 clGeniviAudioCtrlAdapter::u16GetPrivateModeMixVolumeBySinkName(std::string sinkName)
{
    tU16 u16PrivateModeMixVolume=0;
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::u16GetPrivateModeMixVolume for sink = %s",sinkName.c_str()));

    AudioUserDpIf* pAudUsrDpIf = AudioUserDpIfSelect::pGetAudUsrDpIf();
    ETG_TRACE_USR4(("GetSinkIndex for sink name %s",sinkName.c_str()));
    tU16 sinkIdx = 0xFFFF; //not clear if 0 is valid index, so better use this as invalid
    if(m_sinkList.size()>0)
    {
        std::map<unsigned int, struct sinkData>::iterator it = m_sinkList.begin();
        for(it=m_sinkList.begin(); it!=m_sinkList.end();it++){
            if((it->second).s_sink.name == sinkName)
            {
                ETG_TRACE_USR4(("Sink found at index %d",it->first));
                sinkIdx = it->first;
                break;
            }
        }
    }

    if((pAudUsrDpIf != NULL) && (sinkIdx != 0xFFFF))
    {
        pAudUsrDpIf->u32GetPrivateModeMixVolume(u16PrivateModeMixVolume,sinkIdx);
        ETG_TRACE_USR4(("u16GetPrivateModeMixVolumeBySinkName DP gave %d",u16PrivateModeMixVolume));
    }
    ETG_TRACE_USR4(("u16GetPrivateModeMixVolumeBySinkName returns %d",u16PrivateModeMixVolume));
    return u16PrivateModeMixVolume;
}

tU8 clGeniviAudioCtrlAdapter::u8GetSinkID(SourceID srcID)
{
    int index=0;
    tU8 u8SinkID = 1;
    std::vector<tU16>::const_iterator it;
    clAudioSource* poAudioSource = NULL;
    poAudioSource = clAudioSourceFactory::getAudioSource(srcID);

    clSourceClass oSrcClass = poAudioSource->getSourceClass();
    ETG_TRACE_USR1(("Private mode = %d",m_u16PrivateMode));
    if(m_u16PrivateMode == 0)
    {

        AudioUserDpIf* pAudUsrDpIf = AudioUserDpIfSelect::pGetAudUsrDpIf();
        if(pAudUsrDpIf)
        {
            pAudUsrDpIf->s32GetPrivateMode(m_u16PrivateMode);
        }
        ETG_TRACE_USR1(("Private mode changed = %d",m_u16PrivateMode));
    }

    for(it=oSrcClass.m_u16PrivateModeList.begin(); it != oSrcClass.m_u16PrivateModeList.end(); ++it)
    {
        ETG_TRACE_USR1(("Private mode = %d and &(oSrcClass.Sinks[%d])=%d (0x%p)",(*it),index,oSrcClass.Sinks[index],&(oSrcClass.Sinks[index])));
        if(m_u16PrivateMode == (*it))
        {
            u8SinkID = (tU8)oSrcClass.Sinks[index];
        }
        index = index + 1;
    }
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::u8GetSinkID u8SinkID = %d, for source %s",u8SinkID,poAudioSource->pacGetName()));

    return u8SinkID;
}
tU16 clGeniviAudioCtrlAdapter::u16GetPrivateModeMixVolume(tU16 sinkID)
{
    AudioUserDpIf* pAudUsrDpIf = AudioUserDpIfSelect::pGetAudUsrDpIf();
    PrintSinkMap();
    int sink = clGeniviAudioCtrlAdapter::GetSinkIndex(sinkID);
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::u8GetSinkID u8SinkID = %d", sink));
    if(sink <= -1) return 0;
    if(pAudUsrDpIf)
        pAudUsrDpIf->u32GetPrivateModeMixVolume(m_u16PrivateModeMixVolume,(tU16)sink);
    return m_u16PrivateModeMixVolume;
}
void clGeniviAudioCtrlAdapter::AddAttenuationFilter(tU16 sinkID)
{
    tU8 u16PMMixVol = (tU8)u16GetPrivateModeMixVolume(sinkID);
    tS16 u16PMMixVoldB=0;
    PrintSinkMap();
    if(m_AttenuationDBMAp.find(u16PMMixVol) != m_AttenuationDBMAp.end())
    {
        u16PMMixVoldB = m_AttenuationDBMAp.find(u16PMMixVol)->second;
    }
    if(sinkID == 1)
        m_clientHandlerFcAudioMgr->vPrivateModeAttenuateMainSpeakers(true,u16PMMixVoldB);
    else
    {
        CalculateAttenuationFilter(sinkID,u16PMMixVoldB,true);
    }

}
void clGeniviAudioCtrlAdapter::CalculateAttenuationFilter(tU16 sinkID,int u16PMMixVoldB, bool Attenuate)
{
    //do this as part of volume manager
    std::vector<am_Sink_s> listsinks;
    am_Error_e err = m_geniviControlIF->getListSinks(listsinks);
    if(err != E_OK)
    {
        ETG_TRACE_USR4(("getListSources() got error %d from daemon", err));
    }
#if defined(VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_INF4CV ) || defined(VARIANT_S_FTR_ENABLE_UNITTEST)
    std::vector<am_Sink_s>::iterator iter = listsinks.begin();
    while(iter != listsinks.end())
    {
        if(iter->sinkID == sinkID)
        {
            //attenuate
            if(Attenuate == true)
            {
                //u16PMMixVoldB-=iter->volume;
                if(clGeniviAudioCtrlAdapter::getVolumeManager() !=NULL )
                    clGeniviAudioCtrlAdapter::getVolumeManager()->enableMixSourceAttenuation(iter->name, u16PMMixVoldB);
            }
            //			else
            //			{
            //				//u16PMMixVoldB=0;
            //				if(clGeniviAudioCtrlAdapter::getVolumeManager() !=NULL )
            //					clGeniviAudioCtrlAdapter::getVolumeManager()->disableMixSourceAttenuation(iter->name);
            //			}
            //send
            am_Handle_s handle;
            am_Error_e error;
            /*if((error = IAmControlReceiverShadow::getInstance()->setSinkVolume(handle, sinkID, (am_volume_t)u16PMMixVoldB, RAMP_GENIVI_NO_PLOP, 20)) != E_OK)
          {
            ETG_TRACE_USR4(("mControlReceiveInterface->setSinkVolume() got error %d from daemon", error));
          }*/
            ETG_TRACE_USR4(("mControlReceiveInterface->setSinkVolume() got volume %d from daemon", u16PMMixVoldB));

        }
        ++iter;
    }
#endif
    (void)sinkID;
    (void)Attenuate;
    (void)u16PMMixVoldB;
}
void clGeniviAudioCtrlAdapter::RemoveAttenuationFilter(tU16 sinkID)
{
    tU16 u16PMMixVol = u16GetPrivateModeMixVolume(sinkID);
    ETG_TRACE_USR4(("RemoveAttenuationFilter for sinkID %d got u16PMMixVol %d",sinkID,u16PMMixVol));

    int u16PMMixVoldB=0;
    if(m_AttenuationDBMAp.find((tU8)u16PMMixVol) != m_AttenuationDBMAp.end())
    {
        u16PMMixVoldB = m_AttenuationDBMAp.find((tU8)u16PMMixVol)->second;
        ETG_TRACE_USR4(("u16PMMixVoldB set to %d",u16PMMixVoldB));
    }
    if(sinkID == 1)
        m_clientHandlerFcAudioMgr->vPrivateModeAttenuateMainSpeakers(false,u16PMMixVoldB);
    else
    {
        clAudioSource* pSrc = pcoGetTopOfStackMixsource(sinkID);
        if(pSrc)
        {
        	ETG_TRACE_USR4(("keep attenuation, TopOfStackMixSource is %s",pSrc->pacGetName()));
        }
        else
        {
        	ETG_TRACE_USR1(("call disableMixSourceAttenuation for AMP_A"));
        	getVolumeManager()->disableMixSourceAttenuation("AMP_A"); // ToDo: fetch sink name from helper
        }
    }

}

midw_fi_tcl_e8_AudSource::tenType  clGeniviAudioCtrlAdapter::GenSrc2ExtSrc (  const am_sourceID_t & genSrc)
{
    std::map<am_sourceID_t, SourceID >::const_iterator it = m_registeredSources.find(genSrc);
    sourceClassID IntSrc = it->second.enSourceClass;
    clSourceClass enSourceClass = clFactory_AudioSourceClass::GetSourceClass(IntSrc);

    tU16 ExtID =  enSourceClass.getExtID();
    ETG_TRACE_USR1(("clGeniviAudioCtrlAdapter::GenSrc2ExtSr ExtID %d", ExtID));
    return (midw_fi_tcl_e8_AudSource::tenType)ExtID;

}


//find source Class by name
bool clGeniviAudioCtrlAdapter::isTunerSourceClass(std::string className)
{
    const clSourceClass* pSrcClass = clFactory_AudioSourceClass::GetSourceClass(className.c_str());
    if(pSrcClass != NULL)
    {
        if(pSrcClass->SourceGroupID == clSourceClass::group_tuner)
            return true;
    }
    return false;

}

//find source Class by class ID
bool clGeniviAudioCtrlAdapter::isTunerSourceClassByClassID(am_sourceClass_t srcClassID)
{
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,false);

    //find name by srcClassID
    std::vector<am_SourceClass_s> listSourceClasses;
    m_geniviControlIF->getListSourceClasses(listSourceClasses);
    for(unsigned int i =0;i<listSourceClasses.size();i++)
    {
        if(listSourceClasses[i].sourceClassID==srcClassID)
        {
            return(isTunerSourceClass(listSourceClasses[i].name));
        }
    }
    return false;
}

//find source Class by source ID
bool clGeniviAudioCtrlAdapter::isTunerSourceClassBySourceID(am_sourceID_t sourceID)
{
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,false);
    am_SourceClass_s classInfo;
    if (E_OK == m_geniviControlIF->getSourceClassInfoDB(sourceID, classInfo))
    {
        return(isTunerSourceClass(classInfo.name));
    }

    return false;
}

bool clGeniviAudioCtrlAdapter::isMediaPlayerSourceClassBySourceID(am_sourceID_t sourceID)
{
    const std::string strMediaPlayer("MEDIA_PLAYER");
    const std::string strMediaBtAudio("PHONE_BTAUDIO");

    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,false);
    am_SourceClass_s classInfo;
    if (E_OK == m_geniviControlIF->getSourceClassInfoDB(sourceID, classInfo))
    {
        //check if it is MEDIA_PLAYER#1,MEDIA_PLAYER#2, ...
        if(
                (classInfo.name.compare(0,strMediaPlayer.size(),strMediaPlayer)==0)
                || (classInfo.name.compare(0,strMediaBtAudio.size(),strMediaBtAudio)==0) )
        {
            //request is for MEDIA_PLAYER or PHONE_BTAUDIO
            return true;
        }
    }

    return false;
}

void clGeniviAudioCtrlAdapter::cbAckSetSinkSoundProperty(const am_Handle_s handle, const am_Error_e error)
{
    ETG_TRACE_USR3(("cbAckSetSinkSoundProperty with handle %d, %d",handle.handleType, handle.handle));
    //Let's see if we find out for whom this is
    std::map<am_sourceID_t, SourceID >::iterator it;
    for(it = m_registeredSources.begin(); it != m_registeredSources.end(); ++it)
    {
        clAudioSource* pSrc = clAudioSourceFactory::getAudioSource(it->second);
        if(pSrc)
        {
            ETG_TRACE_USR3(("cbAckSetSinkSoundProperty: for other source %s",pSrc->pacGetName()));
            const am_Handle_s* pHandle = pSrc->getSinkHandle(&handle); //daw2hi 8.3.2018 use sink handle
            if(pHandle != NULL)
            {
                ETG_TRACE_USR3(("cbAckSetSinkSoundProperty: ExtGAM source %s",pSrc->pacGetName()));
                am_sinkID_t sinkID = pSrc->getSinkIDByHandle(pHandle);
                ETG_TRACE_USR3(("for sinkID %d in state %s",sinkID,pSrc->pacGetState(sinkID)));
                std::string stateName(pSrc->pacGetState(sinkID));
                std::string startUnMute("StartUnMute");
                std::string startMute("StartMute");
                if(stateName.compare(startUnMute)==0)
                    pSrc->vMW_UnMuted(&handle,sinkID);
                else if(stateName.compare(startMute)==0)
                    pSrc->vMW_Muted(&handle,sinkID);

                ETG_TRACE_USR3(("new state %s",pSrc->pacGetState()));
                break; //we can leave here

            }
        }

    }
    ETG_TRACE_USR4(("cbAckSetSinkSoundProperty: handle %d, handleType %d, errorID: %d"
            , handle.handle
            , handle.handleType
            , error));

}

//static
void clGeniviAudioCtrlAdapter::getTopOfGatewaySink(std::string& nameOfMainSource)
{
    ETG_TRACE_USR3(("getTopOfGatewaySink"));
    tU16 SinkID = 17;
    clStack * pStack = clAudioSourceController::pcoGetStack(SinkID);
    clAudioSource* pSrc = pStack->GetTopSource();
    if(pSrc != NULL)
    {
        ETG_TRACE_USR3(("getTopOfGatewaySink is %s",pSrc->pacGetName()));
        nameOfMainSource = pSrc->pacGetName();
    }
    else
    {
        ETG_TRACE_USR3(("getTopOfGatewaySink is empty"));
    }
}

void clGeniviAudioCtrlAdapter::vSetMutePrivateMode(tU16 sinkID, bool active)
{
    //just forward to SenderBase
    if(m_ControlSenderBase)
    {
        (void)m_ControlSenderBase->setMutePrivateMode((am_sinkID_t)sinkID,active);
    }
}

std::map<am_sinkID_t, am_Sink_s> clGeniviAudioCtrlAdapter::getRegisteredSinks()
{
    return m_registeredSinks;
}

void clGeniviAudioCtrlAdapter::callHookUserDisconnectionRequest(am::am_mainConnectionID_t mainConnectionID)
{
    if(m_ControlSenderBase != NULL) m_ControlSenderBase->hookUserDisconnectionRequest(mainConnectionID);
}

void clGeniviAudioCtrlAdapter::muteSinkIfEntertain(am_Source_s sourceData, am_sinkID_t sinkID, const am_MuteState_e muteState)
{
    ETG_TRACE_USR3(("muteSinkIfEntertain source %s",sourceData.name.c_str()));
    if(sourceData.name.find('#') != string::npos)
    {
        sourceData.name = sourceData.name.erase(sourceData.name.find('#'));
    }
    ETG_TRACE_USR3(("muteSinkIfEntertain source %s",sourceData.name.c_str()));
    const clSourceClass* pSrcClass = clFactory_AudioSourceClass::GetSourceClass(sourceData.name.c_str());
    if(pSrcClass == NULL) return;
    ETG_TRACE_USR3(("sourceGroupID %d and group_media %d",pSrcClass->SourceGroupID,clSourceClass::group_media));
    if(pSrcClass->SourceGroupID == clSourceClass::group_media)
    {
        ETG_TRACE_USR3(("sourceGroupID %d and group_media %d",pSrcClass->SourceGroupID,clSourceClass::group_media));
        //we can apply mute this
        const clSourceClass* pSrcClass = clFactory_AudioSourceClass::GetSourceClass("MUTE_ENTERTAIN");
        if(pSrcClass == NULL) return;
        if(muteState == MS_MUTED)
            (void)clGeniviAudioCtrlAdapter::RequestSourceOn(SourceID(pSrcClass->getClassID(),0),sinkID);
        else if(muteState == MS_UNMUTED)
            (void)clGeniviAudioCtrlAdapter::RequestSourceOff(SourceID(pSrcClass->getClassID(),0),sinkID);
    }
}

am::am_Error_e clGeniviAudioCtrlAdapter::getSystemPropertyValue(am_SystemProperty_s& systemProperty)
{
    // ToDo: Fix this for uTest
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
    return E_NOT_POSSIBLE;
#endif
    std::vector<am_SystemProperty_s> listSystemProperties;
    if(E_OK == m_geniviControlIF->getListSystemProperties(listSystemProperties))
    {
        auto it = listSystemProperties.begin();
        while(it != listSystemProperties.end())
        {
            if((*it).type == systemProperty.type)
            {
                ETG_TRACE_USR4(("Found SystemProperty Type %d with value %d",systemProperty.type,(*it).value));
                systemProperty.value = (*it).value;
                return E_OK;
            }
            it++;
        }
    }
    return E_NOT_POSSIBLE;

}

} //namespace
