#include "AudioStack/SMT/clSrcState_SourceAvailableCheck.h"
#include "AudioStack/clAudioSMEngine.h"
#include "AudioStack/AudioSources/clAudioSource.h"
#include "AudioStack/SMT/clSrcStateFactory.h"
#include "AudioStack/AudioSources/clFactory_AudioSourceClass.h"

// Unorganised traces
#ifndef USE_DLT_TRACE
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_COMP_AUDIOSTACK
#include "trcGenProj/Header/clSrcState_SourceAvailableCheck.cpp.trc.h"
#endif
#endif


namespace AudioStack { namespace SourceStateMachine
{

using namespace AudioSource;

tVoid clSrcState_SourceAvailableCheck::vEnter(clAudioSource* pclAudioSource, tU32 u32UserData, tU8 /*VVD lint fix*/ /*enEntryCondition*/, tU16 SinkID )
{
   vMsg_SrcAvailabilityChg(pclAudioSource, u32UserData,SinkID);

}

//tVoid clSrcState_SourceAvailableCheck::vMsg_Off(clAudioSource* pclAudioSource, tU32 u32UserData)
//{
//   // simple transition from waitFor to off
//   vSetState(pclAudioSource, clSrcStateFactory::pclCreateOff(), u32UserData, ENTRYCONDITION_NONE);
//}

tVoid clSrcState_SourceAvailableCheck::vMsg_SrcAvailabilityChg(clAudioSource* pclAudioSource, tU32 u32UserData, tU16 SinkID )
{
  ETG_TRACE_USR1(("vMsg_SrcAvailabilityChg: entered"));
  if (NULL != pclAudioSource)
  {
    clAudioSource::enSourceAvailability srcAvail = pclAudioSource->enIsSourceAvailable();
    SourceID srcID = pclAudioSource->sGetId();
    if(srcAvail == clAudioSource::available)
    {
      vHandleTrigger(clSrcState::SrcAvailabilityChg, pclAudioSource, u32UserData,SinkID);
    }
    if(srcAvail == clAudioSource::not_available)
    {
      pclAudioSource->vSrcChgUnAvailabilityReason();
    }
    /*
     * function vMsg_SrcAvailabilityChg() is called for below instances
     * 1. availability Message received
     * 2. state changed from SrcAvailCheck_Pause --> SrcAvailCheck_On
     * In case of use case 2 : No need to remove source if source availability is unknown (NCG3D-33888)
     */

    if(srcAvail == clAudioSource::unkonwn)
    {
      if(false == pclAudioSource->bIsSourceLSM()){
        ETG_TRACE_USR4(("vMsg_SrcAvailabilityChg(): Remove Source"));
        clAudioSMEngine::Source_Removed(srcID);
      }
      else{
        ETG_TRACE_USR1(("vMsg_SrcAvailabilityChg(): Restoring LSM, No need to remove !!"));
      }
    }
  }
}
}}//namespace

