/*
 * clGeniviAudioSource.cpp
 *
 *  Created on: Jul 25, 2013
 *      Author: vo84hi
 *
 */

#include "include/audiomanagertypes.h"
#include "IAmControlReceiverShadow.h"
#include "AudioStack/AudioSources/clGeniviAudioSource.h"
#include "AudioStack/clGeniviAudioCtrlAdapter.h"
#include "AudioStack/SMT/clSrcStateFactory.h"
#include "AudioStack/AudioSources/clFactory_AudioSourceClass.h"

using namespace am;

#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_COMP_AUDIOSTACK
#include "trcGenProj/Header/clGeniviAudioSource.cpp.trc.h"
#endif

namespace AudioStack
{
namespace AudioSource
{

using namespace SourceStateMachine;

   clGeniviAudioSource::clGeniviAudioSource(SourceID srcId) :
      clAudioSource(srcId),
      m_gam_handle(new am_Handle_s()),
    m_gam_SinkHandle(new am_Handle_s()),
      m_gam_connectionId(0)
   {
      const clSourceClass& srcClass = clFactory_AudioSourceClass::GetSourceClass(srcId.enSourceClass);

      am_SourceClass_s am_SrcClass;
      am_sourceClass_t srcClassID = static_cast<am_sourceClass_t>(srcId.enSourceClass);
      am_SrcClass.sourceClassID = srcClassID;
      am_SrcClass.name          = srcClass.getName();
      //This will fail for dynamic sources (
      am_Error_e retVal = clGeniviAudioCtrlAdapter::addSourceClass(am_SrcClass, srcClassID);
      if(retVal!=E_OK)
      {
    	  ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::addSourceClass for srcClassID %d gave retVal %d",srcClassID,retVal));
      }

      m_gam_source_s.domainID = clGeniviAudioCtrlAdapter::GetDomainID();

      m_gam_source_s.available.availability = A_AVAILABLE;

      m_gam_source_s.available.availabilityReason = AR_UNKNOWN;
      //TODO
      //move this to configuration -> StackRules Table!?

      //quickly avoid compiler warning
      //TODO make this more beautiful -> maybe in configuration!?
      am_MainSoundProperty_s msp = {MSP_MIC_STATUS_CONNECTION,0};
      m_gam_source_s.listMainSoundProperties.push_back(msp);
      am_MainSoundProperty_s msp_A = {MSP_MIC_STATUS_LEVEL,0};
      m_gam_source_s.listMainSoundProperties.push_back(msp_A);

      m_gam_source_s.name = srcClass.getName();
      m_gam_source_s.sourceID = 0;
      m_gam_source_s.visible = true;

      if(srcClass.getRegistrationMode() == clSourceClass::registerStatic)
      {
         //For static source we'll provide a SourceID
         m_gam_source_s.sourceID = static_cast<am_sourceID_t>(srcClass.SourceClassID); //take fixed ids to make thins easy
         am_Availability_s sAvail;
         sAvail.availabilityReason = AR_UNKNOWN;
         sAvail.availability = A_AVAILABLE;
         m_gam_source_s.available = sAvail;
      }

      //only when SubIDs are used we'll register with SubID(alias DeviceTag) as Genivi Name
      if((srcClass.getRegistrationMode() == clSourceClass::registerDynamic) && (srcClass.bSupressSubSource == false))
      {
         //m_gam_source_s.sourceID = 0; //moved above to ensure it for all dynamic sources. Otherwise it might crash due to assert in Daemon.
         const tU16 n = (tU16)snprintf(NULL, 0, "#%d", srcId.u16SubSource);
         //ASSERT_NORMAL(n > 0)
         char buf[n+1];

     //VVD lint fix
     memset(buf,0,sizeof(buf));

     //VVD lint fix
     (void)snprintf(buf, n+1, "#%d", srcId.u16SubSource);

         //assert(buf[n] == '\0');
         //assert(c == n);
         m_gam_source_s.name.append(buf);
      }
      ETG_TRACE_USR4(("clGeniviAudioSource: Name %s", m_gam_source_s.name.c_str()));
      delete[] m_pacName;
      char *cstr = new char[m_gam_source_s.name.length() + 1];

    //VVD lint fix
    if(cstr){
      strcpy(cstr, m_gam_source_s.name.c_str());
      m_pacName = cstr;
    }
    ETG_TRACE_USR4(("clAudioSource: Changed Name %s", clAudioSource::pacGetName()));
      m_gam_source_s.sourceState = SS_OFF;
      m_gam_source_s.sourceClassID = srcId.enSourceClass;
      m_gam_source_s.volume = 0;
      m_gam_source_s.listConnectionFormats.push_back(CF_GENIVI_STEREO);
      // item.listMainSoundProperties.push_back(am_MainSoundProperty_s{MSP_MIC_STATUS_CONNECTION,0});
      // item.listMainSoundProperties.push_back(am_MainSoundProperty_s{MSP_MIC_STATUS_LEVEL,0});

      m_gam_source_s.sourceID = clGeniviAudioCtrlAdapter::AddSource(m_SrcId, m_gam_source_s);
      ETG_TRACE_USR4(("clAudioSource: SourceClass: %d subID %d, GeniviID %d, Name %s"
            , m_SrcId.enSourceClass
            , (tU16)m_SrcId.u16SubSource
            , m_gam_source_s.sourceID
            , clAudioSource::pacGetName()));
   }

   void clGeniviAudioSource::setSinkHandle(const am_Handle_s* p, tU16 a)
   {
	   (void)p;
	   (void)a;
   }



   clGeniviAudioSource::~clGeniviAudioSource()
   {
      clGeniviAudioCtrlAdapter::RemoveSource(m_gam_source_s.sourceID);
      delete(m_gam_handle);
   }

   void clGeniviAudioSource::vPrint()
   {
     ETG_TRACE_USR4(("%s", m_pacName));
     ETG_TRACE_USR4(("  | SourceClass: 0x%02x(%03d), SubID 0x%02x(%03d),"
         , m_SrcId.enSourceClass
         , m_SrcId.enSourceClass
         , m_SrcId.u16SubSource
         , m_SrcId.u16SubSource));
     ETG_TRACE_USR4(("  | MidwID 0x%02x(%03d)"
         , (tU16)clFactory_AudioSourceClass::GetExternalID(sGetId())
         , (tU16)clFactory_AudioSourceClass::GetExternalID(sGetId())));
     ETG_TRACE_USR4(("  | GeniviSrcID 0x%02x(%03d)"
         , m_gam_source_s.sourceID
         , m_gam_source_s.sourceID));

   //daw2hi: 8.8.2016 print only for sink 1
   const tChar* pStateName = pacGetState(1);
   ETG_TRACE_USR2(("  | State: %d (%s)"
         , ETG_CENUM(AudioStates::enAudioStates, pclGetState(1)->m_enStateID),pStateName));

   ETG_TRACE_USR4(("  | State: %d", ETG_CENUM(AudioStates::enAudioStates, m_pclState->m_enStateID)));
   ETG_TRACE_USR4(("  | Availability: %d", ETG_CENUM(clAudioSource::enSourceAvailability, m_availability)));
   ETG_TRACE_USR4(("  | AutoPlay: %d", ETG_CENUM(clSourceClass::autoplay_t, clFactory_AudioSourceClass::GetAutoPlayMode(sGetId()))));
   ETG_TRACE_USR4(("                "));
}

tVoid clGeniviAudioSource::vMW_CCAResponse(tS32 extSourceId, tU16 subSrc, enSourceActivity activity)
{
   tU8 sinkID = 1;
   // use m_curActSinkID instead ??
   ETG_TRACE_ERR(("called vMW_CCAResponse without SinkID, using SinkID 1"));
   vMW_CCAResponse(extSourceId,subSrc,activity, sinkID);
}

// return the connectionID for a given sourceID - sinkID based on the daemon data
// if there is no connection we return 0
am::am_connectionID_t clGeniviAudioSource::connectionExisting(am_sourceID_t sourceID, am_sinkID_t sinkID)
{
	am::am_connectionID_t conID = 0;
	std::vector<am_Connection_s> listConnections;
	am_Error_e err = clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->getListConnections(listConnections);
	if(err!=E_OK)
	{
		ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->getListConnections gave err %d",err));
	}
	for(unsigned int i = 0;i<listConnections.size();i++)
	{
		ETG_TRACE_USR4(("connectionExisting ID %d, sourceID %d, sinkID %d",listConnections[i].connectionID,listConnections[i].sourceID,listConnections[i].sinkID));
		if( (listConnections[i].sourceID == sourceID) && (listConnections[i].sinkID == sinkID) )
		{
			ETG_TRACE_USR4(("yes"));
			conID = listConnections[i].connectionID;
			break;
		}
	}
	return conID;
}

// return the connectionID for a given sourceID - sinkID based on internal data (mainConnectionEntries)
// if there is no connection we return 0

am::am_connectionID_t clGeniviAudioSource::connectionKnown(am_sourceID_t sourceID, am_sinkID_t sinkID)
{
	am::am_connectionID_t conID = 0;
	std::vector<mainConnectionEntry_s> mainConnectionEntries =clGeniviAudioCtrlAdapter::getMainConnectionEntries();
	ETG_TRACE_USR4(("Checking m_gam_source_s.sourceID %d, sinkID %d",m_gam_source_s.sourceID, sinkID));
	for(unsigned int mainID = 0;mainID<mainConnectionEntries.size();mainID++ )
	{
		for(unsigned int subID=0;subID<mainConnectionEntries[mainID].subConnectionList.size();subID++)
		{
			ETG_TRACE_USR4(("Checking mainID %d",mainConnectionEntries[mainID].mainID));
			ETG_TRACE_USR4(("mainConnectionEntries[%d].subConnectionList[%d] sourceID %d, sinkID %d, subConID %d ",
					mainID,subID,
					mainConnectionEntries[mainID].subConnectionList[subID].sourceID,
					mainConnectionEntries[mainID].subConnectionList[subID].sinkID,
					mainConnectionEntries[mainID].subConnectionList[subID].connectionID));

			if(  (mainConnectionEntries[mainID].subConnectionList[subID].sourceID == sourceID)
					&& (mainConnectionEntries[mainID].subConnectionList[subID].sinkID == sinkID) )
			{
				ETG_TRACE_USR4(("Known as ConID %d",mainConnectionEntries[mainID].subConnectionList[subID].connectionID));
				conID = mainConnectionEntries[mainID].subConnectionList[subID].connectionID;
			}
			if(conID != 0) break;
		}
		if(conID != 0) break;
	}
	return conID;

}

// daw2hi we need the sinkID also to identify for which sink the CCA Response was called
tVoid clGeniviAudioSource::vMW_CCAResponse(tS32 extSourceId, tU16 subSrc, enSourceActivity activity, tU16 sinkID)
{
	//VVD lint fix
	if(NULL == m_gam_handle)
		return;

	//SourceStateMachine::clSrcState* clActSrcState = pclGetState(m_curActSinkID);
	SourceStateMachine::clSrcState* clActSrcState = pclGetState(sinkID);

	// daw2hi: ToDo get the clActSrcState based on the sinkID we get
	//    if(m_curActSinkID<=1) clActSrcState = m_pclState;
	//    else clActSrcState = m_pclStateRSE;

	ETG_TRACE_USR4(("vMW_CCAResponse: Ext-SourceID : %d (CCA), SubID: %d Activity: %d Sink %d, state %s", extSourceId, subSrc, activity, sinkID,clActSrcState->m_pacName));
	ETG_TRACE_USR4(("vMW_CCAResponse: sourceID %d : %s",m_gam_source_s.sourceID,this->pacGetName()));
	switch(activity)
	{
	case clGeniviAudioSource::On:
		ETG_TRACE_USR4(("vMW_CCAResponse: On for %s",this->pacGetName()));
		if( clActSrcState == clSrcStateFactory::pclCreateRampUpRequesting())
		{
			// not clear if we need this
			if(0 != connectionKnown(m_gam_source_s.sourceID,static_cast<am_sinkID_t>(sinkID)) )
			{
				ETG_TRACE_USR4(("vMW_CCAResponse: connection known -> no action return"));
				//return;
			}

			// we will not call connect if already existing in daemon database
			m_gam_connectionId = connectionExisting(m_gam_source_s.sourceID,static_cast<am_sinkID_t>(sinkID));
			if(0 != m_gam_connectionId)
			{
				ETG_TRACE_USR4(("vMW_CCAResponse: connection existing as ID %d -> skip connect",m_gam_connectionId));
				//return;
			}
			else
			{
				if(m_gam_handle->handleType == H_CONNECT) m_gam_handle->handleType = H_UNKNOWN;

				//m_gam_connectionId=0; //it is 0
				ETG_TRACE_USR4(("vMW_CCAResponse: call clGeniviAudioCtrlAdapter::connect handle (type %d/%d) sourceID %d, sinkID %d, connectionID %d",
						m_gam_handle->handleType, m_gam_handle->handle, m_gam_source_s.sourceID, sinkID,m_gam_connectionId));
				clGeniviAudioCtrlAdapter::connect((*m_gam_handle), m_gam_connectionId,
						CF_GENIVI_STEREO,
						m_gam_source_s.sourceID,
						static_cast<am_sinkID_t>(sinkID));

				ETG_TRACE_USR4(("vMW_CCAResponse: after call connectionID %d",m_gam_connectionId));
			}
			//25.07.2016 daw2hi check if we have already an ON
			tBool bAlreadyOn = false;
			for(std::map<tU16,am_SourceState_e>::iterator it = m_logicalSourceStates.begin(); it != m_logicalSourceStates.end();++it)
			{
				if((it->first != sinkID) && (it->second == SS_ON))
				{
					bAlreadyOn = true;
					break;
				}
			}
			if(!bAlreadyOn)
				clGeniviAudioCtrlAdapter::setSourceState(*m_gam_handle, m_gam_source_s.sourceID, SS_ON);
			//should we check if any is not visible then we need to get mainCon of the visible and add the conID
			am_Sink_s sinkData;
			am_Error_e err = clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->getSinkInfoDB(static_cast<am_sinkID_t>(sinkID), sinkData);
			if((m_gam_source_s.visible==true) && (sinkData.visible==true))
			{
				ETG_TRACE_USR4(("Main Connection SourceID %d -> SinkID %d",m_gam_source_s.sourceID, sinkID));
				//daw2hi this is a main connection
				std::vector<am_connectionID_t> connectionList;
				connectionList.push_back(m_gam_connectionId);
				clGeniviAudioCtrlAdapter::changeMainConnectionRouteDB(m_gam_source_s.sourceID, sinkID, connectionList);
				clGeniviAudioCtrlAdapter::changeMainConnectionStateDB(m_gam_source_s.sourceID,static_cast<am_sinkID_t>(sinkID),CS_CONNECTED);
			}
			else //daw2hi no else before 15.6.2017
			{
				//oops, no main connection we have to find it
				std::vector<mainConnectionEntry_s> mainConnectionEntries =clGeniviAudioCtrlAdapter::getMainConnectionEntries();
				std::vector<tU16> mainIds;
				ETG_TRACE_USR4(("Checking m_gam_source_s.sourceID %d, sinkID %d",m_gam_source_s.sourceID, sinkID));
				for(unsigned int mainID = 0;mainID<mainConnectionEntries.size();mainID++ )
				{
					for(unsigned int subID=0;subID<mainConnectionEntries[mainID].subConnectionList.size();subID++)
					{
						ETG_TRACE_USR4(("Checking mainID %d",mainConnectionEntries[mainID].mainID));
						ETG_TRACE_USR4(("mainConnectionEntries[%d].subConnectionList[%d] sourceID %d, sinkID %d, MainConID %d, subConID %d ",
								mainID,subID,
								mainConnectionEntries[mainID].subConnectionList[subID].sourceID,
								mainConnectionEntries[mainID].subConnectionList[subID].sinkID,
								mainConnectionEntries[mainID].mainID,
								mainConnectionEntries[mainID].subConnectionList[subID].connectionID));

						if(  (mainConnectionEntries[mainID].subConnectionList[subID].sourceID == m_gam_source_s.sourceID)
								&& (mainConnectionEntries[mainID].subConnectionList[subID].sinkID == sinkID) )
						{
							ETG_TRACE_USR4(("Pushing mainID %d to mainIds",mainConnectionEntries[mainID].mainID));
							mainIds.push_back(mainConnectionEntries[mainID].mainID);
						}
					}
				}

				//am_sourceID_t mainSourceID=0;
				//am_sinkID_t mainSinkID=0;

				std::vector<am_MainConnection_s> listMainConnections;
				std::vector<am_MainConnection_s>::iterator it;
				err = clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->getListMainConnections(listMainConnections);
				bool bLeave=false;
				for(unsigned int id=0;id<listMainConnections.size();id++)
				{
					for(unsigned int i=0;i<mainIds.size();i++)
					{
						if(listMainConnections[id].mainConnectionID == mainIds[i])
						{
							ETG_TRACE_USR4(("MainConID %d: Source %d -> Sink %d, try pushing connectionID %d to list (size %d)",
									listMainConnections[id].mainConnectionID,
									listMainConnections[id].sourceID,
									listMainConnections[id].sinkID,
									m_gam_connectionId,
									listMainConnections[id].listConnectionID.size()));
							std::vector<am_connectionID_t> connectionList = listMainConnections[id].listConnectionID;
							bool bAlreadyInList = false;
							for(unsigned int i=0;i<connectionList.size();i++)
							{
								if(connectionList[i]==m_gam_connectionId)
								{
									bAlreadyInList=true;
									break;
								}
							}
							if(bAlreadyInList == false)
							{
								ETG_TRACE_USR4(("pushed connectionID %d to list with size %d",m_gam_connectionId,connectionList.size()));
								connectionList.push_back(m_gam_connectionId);

								am_Error_e err = clGeniviAudioCtrlAdapter::changeMainConnectionRouteDB(listMainConnections[id].sourceID, listMainConnections[id].sinkID, connectionList);
								if(err!=E_OK)
								{
									ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::changeMainConnectionRouteDB sourceID %d- sinkID %d gave err %d",
											listMainConnections[id].sourceID, listMainConnections[id].sinkID,err));

								}
							}
							else
							{
								ETG_TRACE_USR4(("not pushed, already in list"));
							}


                                                         clAudioSource* pCurrActiveSource = clAudioSourceController::getInstance().pcoGetCurrentActiveAudiosource(listMainConnections[id].sinkID);
                                                         if(NULL != pCurrActiveSource)
                                                         {
                                                             ETG_TRACE_USR1(("clGeniviAudioCtrlAdapter::pCurrActiveSource: %d ",pCurrActiveSource->getSourceClass().getClassID()));
                                                             ETG_TRACE_USR1(("clGeniviAudioCtrlAdapter::changeMainConnectionRouteDB has Active Source %s",pCurrActiveSource->pacGetName()));
                                                          }
                                                          else
                                                          {
                                                             ETG_TRACE_USR1(("clGeniviAudioCtrlAdapter::changeMainConnectionRouteDB NO Active Source"));
                                                          }


                                                          //HACK: Here for MICPRIVATE Bug_2073611: Avoid Connected state when MIC1 and Make it Connected in Ama_Analog is Done.
                                                          if((NULL != pCurrActiveSource) && (0 == OSAL_s32StringCompare(this->pacGetName(),"MIC_PRIVATE"))
                                                                         && ((0 == OSAL_s32StringCompare(pCurrActiveSource->pacGetName(),"CMP1_USB_VIDEO"))
                                                                         || (0 == OSAL_s32StringCompare(pCurrActiveSource->pacGetName(),"CMP1_HDMI_Class"))))
                                                          {
                                                             ETG_TRACE_USR4(("HACK: for MICPRIVATE avoid CS_Connected here for Sink %d listMainConnections[id].sinkID %d",sinkID,listMainConnections[id].sinkID));
                                                          }
                                                          else
                                                          {
                                                             ETG_TRACE_USR4(("ADDED  CS_Connected here for SinkID %d listMainConnections[id].sinkID %d",sinkID,listMainConnections[id].sinkID));
                                                             (void)clGeniviAudioCtrlAdapter::changeMainConnectionStateDB(listMainConnections[id].sourceID,listMainConnections[id].sinkID,CS_CONNECTED);
                                                          }

						}
					}
				} //for()


				if(sinkID==17)
				{
					ETG_TRACE_USR4(("HACK: Apply absolute volume 40 for Sink 17"));
					clGeniviAudioCtrlAdapter::sendVolumeSink17();
				}
				ETG_TRACE_USR4(("vMW_CCAResponse changeMainConnectionStateDB gave err %d (bLeave %d)",err,bLeave));

				ETG_TRACE_USR4(("vMW_CCAResponse: End for loop"));
			}

			vSetCurActSink(sinkID); //daw2hi 21.07.2016
			m_logicalSourceStates[sinkID]=SS_ON; //22.07.2016

			vMW_OnDone(sinkID);
		} //if
		break;
	case clGeniviAudioSource::Pause:
		ETG_TRACE_USR4(("vMW_CCAResponse: Pause for %s",this->pacGetName()));
		if( clActSrcState == clSrcStateFactory::pclCreateRampDownToPause())
		{
			//25.07.2016 daw2hi check if we have already an ON
			tBool bAnotherOn = false;
			for(std::map<tU16,am_SourceState_e>::iterator it = m_logicalSourceStates.begin(); it != m_logicalSourceStates.end();++it)
			{
				if((it->first != sinkID) && (it->second == SS_ON))
				{
					bAnotherOn = true;
					break;
				}
			}
			if(!bAnotherOn)
				// All of them are synchronously
				clGeniviAudioCtrlAdapter::setSourceState(*m_gam_handle, m_gam_source_s.sourceID, SS_PAUSED);

			//VVD need not to disconnect,
			//clGeniviAudioCtrlAdapter::disconnect(*m_gam_handle, m_gam_connectionId);

			//VVD need not to remove, change it to CS_SUSPENDED
			//clGeniviAudioCtrlAdapter::removeMainConnectionDB(m_u8Id);
			clGeniviAudioCtrlAdapter::changeMainConnectionStateDB(m_gam_source_s.sourceID, static_cast<am_sinkID_t>(sinkID), CS_SUSPENDED);

			vSetCurActSink(sinkID); //daw2hi 21.07.2016
			m_logicalSourceStates[sinkID]=SS_PAUSED; //22.07.2016
			vMW_PauseDone(sinkID);


		}
		break;
	case clGeniviAudioSource::Off:
		ETG_TRACE_USR4(("vMW_CCAResponse: Off for %s",this->pacGetName()));
		ETG_TRACE_USR4(("updating m_gam_connectionId %d",m_gam_connectionId));
		clGeniviAudioCtrlAdapter::getSubConID(m_gam_source_s.sourceID,sinkID,m_gam_connectionId);
		ETG_TRACE_USR4(("to m_gam_connectionId %d",m_gam_connectionId));
		if(  (clActSrcState == clSrcStateFactory::pclCreateRampDownToOff())
				||(clActSrcState == clSrcStateFactory::pclCreateOff()))
		{
			//25.07.2016 daw2hi check if we have already an ON
			tBool bAnotherOn = false;
			for(std::map<tU16,am_SourceState_e>::iterator it = m_logicalSourceStates.begin(); it != m_logicalSourceStates.end();++it)
			{
				if((it->first != sinkID) && (it->second == SS_ON))
				{
					bAnotherOn = true;
					break;
				}
			}
			if(!bAnotherOn)
			{
				ETG_TRACE_USR4(("no bAnotherOn, we can set genivi source state to OFF"));
				clGeniviAudioCtrlAdapter::setSourceState(*m_gam_handle, m_gam_source_s.sourceID, SS_OFF);

			}
			clGeniviAudioCtrlAdapter::disconnect(*m_gam_handle, m_gam_connectionId);
			clGeniviAudioCtrlAdapter::removeMainConnection(m_gam_source_s.sourceID,static_cast<am_sinkID_t>(sinkID));
			vSetCurActSink(sinkID); //daw2hi 21.07.2016
			m_logicalSourceStates[sinkID]=SS_OFF; //22.07.2016
			vMW_OffDone(sinkID);
		}
		break;
	default:
		break;
	}
}

tVoid clGeniviAudioSource::vMW_Pause(SourceID possibleNextSrc,tU16 sinkID)
{
	ETG_TRACE_USR4(("clGeniviAudioSource::vMW_Pause(), sinkID = %d",sinkID));
	am_mainConnectionID_t mainConnectionID;
	clSourceClass::externalID extID = clFactory_AudioSourceClass::GetSourceClass(possibleNextSrc.enSourceClass).getExtID();
	clSourceClass::externalID myExtID = clFactory_AudioSourceClass::GetSourceClass(sGetId().enSourceClass).getExtID();
	//      int ruleIndex = clStackRules::ruleIndex(possibleNextSrc);
	//      int extID = clStackRules::rules[ruleIndex].externalID;
	am_Sink_s sinkData;
	(void)clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->getSinkInfoDB(m_curActSinkID, sinkData);

	//Check if we have a MainConnection
    //if(clGeniviAudioCtrlAdapter::getMainConnectionOfSource(m_gam_source_s.sourceID, mainConnectionID) != E_OK)
	if( (false == clGeniviAudioCtrlAdapter::bIsMainConnection(m_gam_source_s.sourceID,sinkID,mainConnectionID))
			&& (sinkData.visible == true)
			&& (m_gam_source_s.visible == true) 
	  )
	{
		ETG_TRACE_USR4(("vMW_Pause(): Add MainConnection for Source %d, sinkID = %d", m_gam_source_s.sourceID,sinkID));
		//e.g. restore LSM we need to add a connection initiation by our own
		am_Error_e retVal = clGeniviAudioCtrlAdapter::addMainConnection(m_gam_source_s.sourceID,sinkID);
		if(retVal != E_OK)
		{
			ETG_TRACE_ERR(("vMW_Pause(): ERROR %d Add MainConnection for Source %d"
					, ETG_CENUM(am::am_Error_e, retVal)
					, m_gam_source_s.sourceID));
		}
	}
	ETG_TRACE_USR4(("GAS vMW_Pause: SourceClass: %d subID %d, ExtId %d, PNSClass %d PNSsubID %d"
			, sGetId().enSourceClass
			, sGetId().u16SubSource
			, myExtID
			, possibleNextSrc.enSourceClass
			, possibleNextSrc.u16SubSource));

	clGeniviAudioCtrlAdapter::SourceActivityRequest(static_cast<midw_fi_tcl_e8_AudSource::tenType> (myExtID)
			, m_SrcId.u16SubSource
			,static_cast<midw_fi_tcl_e8_AudSource::tenType> (extID)
			,midw_fi_tcl_e8_SrcActivity::FI_EN_PAUSE
			,static_cast<midw_fi_tcl_e8_ResourceNo::tenType> (sinkID));
}

tVoid clGeniviAudioSource::vMW_Off(SourceID possibleNextSrc,tU16 sinkID)
{
	clSourceClass::externalID extID = clFactory_AudioSourceClass::GetSourceClass(possibleNextSrc.enSourceClass).getExtID();
	clSourceClass::externalID myExtID = clFactory_AudioSourceClass::GetSourceClass(sGetId().enSourceClass).getExtID();
	//      int ruleIndex = clStackRules::ruleIndex(possibleNextSrc);
	//      int extID = clStackRules::rules[ruleIndex].externalID;
	ETG_TRACE_USR4(("GAS vMW_Off: SourceClass: %d subID %d, ExtId %d, PNSClass %d PNSsubID %d PNSextID %d"
			, sGetId().enSourceClass
			, (tU16)sGetId().u16SubSource
			, myExtID
			, possibleNextSrc.enSourceClass
			, possibleNextSrc.u16SubSource
			, extID));

	clGeniviAudioCtrlAdapter::SourceActivityRequest(static_cast<midw_fi_tcl_e8_AudSource::tenType> (myExtID)
			, m_SrcId.u16SubSource
			,static_cast<midw_fi_tcl_e8_AudSource::tenType> (extID)
			,midw_fi_tcl_e8_SrcActivity::FI_EN_OFF
			,static_cast<midw_fi_tcl_e8_ResourceNo::tenType> (sinkID));
	clGeniviAudioCtrlAdapter::changeMainConnectionStateDB(m_gam_source_s.sourceID,static_cast<am_sinkID_t>(sinkID),CS_DISCONNECTING);
}

tVoid clGeniviAudioSource::vMW_On(tU16 sinkID)
{
	ETG_TRACE_USR4(("clGeniviAudioSource::vMW_On()"));
	am_mainConnectionID_t mainConnectionID;
	clSourceClass::externalID myExtID = clFactory_AudioSourceClass::GetSourceClass(sGetId().enSourceClass).getExtID();
	am_Source_s sourceData;
	am_Error_e err = clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->getSourceInfoDB(m_gam_source_s.sourceID,sourceData);
	if(err!=E_OK)
	{
		ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->getSourceInfoDB for ID %d gave err %d",m_gam_source_s.sourceID,err));
	}
	ETG_TRACE_USR4(("Source %s",sourceData.name.c_str()));
	ETG_TRACE_USR4(("is visible %d",sourceData.visible));

	am_Sink_s sinkData;
	am_Error_e sinkErr = clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->getSinkInfoDB(sinkID,sinkData);
	if(sinkErr!=E_OK)
	{
		ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()->getSinkInfoDB for sinID %d gave err %d",sinkID,sinkErr));
	}
	ETG_TRACE_USR4(("Sink %s",sinkData.name.c_str()));
	ETG_TRACE_USR4(("is visible %d",sinkData.visible))
	//Check if we have a MainConnection
//	if( (clGeniviAudioCtrlAdapter::getMainConnectionOfSource(m_gam_source_s.sourceID, sinkID, mainConnectionID) != E_OK)
//			&& (sourceData.visible)
//			&& (sinkData.visible)
//	)
	if( (clGeniviAudioCtrlAdapter::bIsMainConnection(m_gam_source_s.sourceID, sinkID, mainConnectionID) == false)
			&& (sourceData.visible)
			&& (sinkData.visible)
	)

	{
		ETG_TRACE_USR4(("vMW_On(): Add MainConnection for Source %d, Sink %d", m_gam_source_s.sourceID, sinkID));
		//e.g. restore LSM we need to add a connection initiation by our own
		am_Error_e retVal = clGeniviAudioCtrlAdapter::addMainConnection(m_gam_source_s.sourceID,sinkID);
		if(retVal != E_OK)
		{
			ETG_TRACE_ERR(("vMW_On(): ERROR %d Add MainConnection for Source %d"
					, ETG_CENUM(am::am_Error_e, retVal)
					, m_gam_source_s.sourceID));
		}
	}
	// call connect to Genivi AudioManager

	// interact with AudioRouteMgr
	clGeniviAudioCtrlAdapter::SourceActivityRequest(static_cast<midw_fi_tcl_e8_AudSource::tenType> (myExtID)
			, m_SrcId.u16SubSource
			,static_cast<midw_fi_tcl_e8_AudSource::tenType> (myExtID)
			,midw_fi_tcl_e8_SrcActivity::FI_EN_ON
			,static_cast<midw_fi_tcl_e8_ResourceNo::tenType> (sinkID));
}

//virtual
void clGeniviAudioSource::vReset()
{
	ETG_TRACE_USR1(("vReset: Reset SourceClass: %d subID %d "
			, m_SrcId.enSourceClass
			, m_SrcId.u16SubSource));
	//TODO
	//remove Genivi Connections
	//remove Genivi MainConnection
	//ToDo consider also all connected sinks
	clGeniviAudioCtrlAdapter::removeMainConnection(m_gam_source_s.sourceID);
	//finally call reset within base class
	clAudioSource::vReset();
}

clAudioSource::enSourceAvailability clGeniviAudioSource::mapAvailability(am_Availability_e avail)
{
	enSourceAvailability retVal = unkonwn;
	switch(avail)
	{
	case A_AVAILABLE:
		retVal = available;
		break;
	case A_UNAVAILABLE:
		retVal = not_available;
		break;
	case A_UNKNOWN:
		retVal = unkonwn;
		break;
	default:
		ETG_TRACE_FATAL(("clGeniviAudioSource::enIsSourceAvailable unkown value in m_gam_source_s.available.availability: %d",
				avail));
		break;
	}
	return retVal;
}

   am_Availability_e clGeniviAudioSource::mapAvailability(clAudioSource::enSourceAvailability avail)
   {
      for(tU16 i = static_cast<tU16>(A_MAX)-1; i!=0; --i)
      {
         if(mapAvailability(static_cast<am_Availability_e>(i)) ==  avail)
            return static_cast<am_Availability_e>(i);
      }
      ETG_TRACE_FATAL(("clGeniviAudioSource::enIsSourceAvailable unkown value in clAudioSource::enSourceAvailability: %d",
            avail));
      return A_UNKNOWN;
   }

   clAudioSource::enSourceAvailability clGeniviAudioSource::enIsSourceAvailable()
   {
      clAudioSource::enSourceAvailability retVal = mapAvailability(m_gam_source_s.available.availability);
      ETG_TRACE_USR4(("enIsSourceAvailable: SourceClass: %d subID %d Available: %d"
               , m_SrcId.enSourceClass
               , (tU16)m_SrcId.u16SubSource
               , ETG_CENUM(enSourceAvailability, retVal)));
      return retVal;
   }

   tVoid clGeniviAudioSource::vSourceAvailablilityChange(enSourceAvailability availability,
         enSourceAvailabilityReason availabilityReason)
   {
      m_gam_source_s.available.availability = mapAvailability(availability);

    //VVD lint fix
    //am_Availability_e e;
      //am_AvailabilityReason_e r;
      am_Availability_s GAM_availability;
      switch(availability)
      {
         case clAudioSource::available:
            GAM_availability.availability = A_AVAILABLE;
            break;
         case clAudioSource::not_available:
            GAM_availability.availability = A_UNAVAILABLE;
            break;
         case clAudioSource::unkonwn:
            GAM_availability.availability = A_UNKNOWN;
            break;
         default:
            ETG_TRACE_ERR(("vSourceAvailablilityChange: availability %d is not handled"
                  , availability));
            GAM_availability.availability = A_UNKNOWN;
            break;
      }
      switch(availabilityReason)
      {
         case clAudioSource::voltage:
            GAM_availability.availabilityReason = AR_GENIVI_VOLTAGE;
            break;
         case clAudioSource::newmedia:
            GAM_availability.availabilityReason = AR_GENIVI_NEWMEDIA;
            break;
         case clAudioSource::samemedia:
            GAM_availability.availabilityReason = AR_GENIVI_SAMEMEDIA;
            break;
         case clAudioSource::nomedia:
            GAM_availability.availabilityReason = AR_GENIVI_NOMEDIA;
            break;
         case clAudioSource::temperature:
            GAM_availability.availabilityReason = AR_GENIVI_TEMPERATURE;
            break;
         case clAudioSource::error:
            GAM_availability.availabilityReason = AR_GENIVI_ERRORMEDIA;
            break;
         case clAudioSource::no_content:
            GAM_availability.availabilityReason = AR_GENIVI_MEDIA_NOCONTENT;
            break;
     case clAudioSource::overcurrent:
            GAM_availability.availabilityReason = AR_GENIVI_OVER_CURRENT;
            break;
     case clAudioSource::internaldisconnect:
            GAM_availability.availabilityReason = AR_GENIVI_INTERNAL_DISCONNECT;
            break;
         default:
            ETG_TRACE_ERR(("vSourceAvailablilityChange: availabilityReason %d is not handled"
                              , availabilityReason));
            GAM_availability.availabilityReason = AR_UNKNOWN;
            break;
      }
      clGeniviAudioCtrlAdapter::changeSourceAvailabilityDB(GAM_availability, m_gam_source_s.sourceID);

      //Call base class implementation
      clAudioSource::vSourceAvailablilityChange(availability, availabilityReason);
   }
}} //namespace


