#include "AMMultiDomainControlBase.h"

#include "controllerplugin_Trace.h"
#include "amcontrol_clienthandler_fc_audioroutemanager.h"
#include "amcontrol_clienthandler_fc_audiomanager.h"

#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AMCONTROLLERPLUGIN
#include "trcGenProj/Header/AMMultiDomainControlBase.cpp.trc.h"
#endif

using namespace Sound;
using namespace am;

using namespace AudioStack;
using namespace AudioStack::AudioSource;
using namespace SourceStateMachine;

//am_SoundProperty_s AMMultiDomainControlBase::soundProperty = {MSP_MAX,0};

am_SoundProperty_s AMMultiDomainControlBase::soundPropertyAVB_MicVolume = {MSP_MAX,0};
am_SoundProperty_s AMMultiDomainControlBase::soundPropertyAVB_Mic1Gain  = {MSP_MAX,0};
bool AMMultiDomainControlBase::bExtSourceGain = false;
/************************************************************************
 * FUNCTION        : AMMultiDomainControlBase
 * DESCRIPTION     : Contructor
 * PARAMETER       :
 * RETURNVALUE     :
 * HISTORY         : GENIVI
 ************************************************************************/
AMMultiDomainControlBase::AMMultiDomainControlBase():IF_MessageObserver<PO_MessageConfig::enID>("CAmControlSenderBase"),m_pSoundHandler(NULL),pVolumeManager(NULL)
{
  ETG_TRACE_USR4(("AMMultiDomainControlBase::Entered in constructor AMMultiDomainControlBase()"));
  PostOffice<PO_MessageConfig::enID>* pPO = InternalCommunicationAdapter::POMessages;
  if (pPO)
  {
      pPO->AddObserver(this, PO_MessageConfig::ID_Amp_SetVolume);
  }

  m_VolumeHandle.handleType = H_UNKNOWN;
  m_VolumeHandle.handle=0;
  m_AVBMicVolumeHandle.handleType = H_UNKNOWN;
  m_AVBMicVolumeHandle.handle=0;

  m_AVBMic1GainHandle.handleType = H_UNKNOWN;
  m_AVBMic1GainHandle.handle=0;

  m_startUpHandle.handleType = H_UNKNOWN;
  m_startUpHandle.handle=0;

  for(unsigned int i=0;i<MIC_MAX;i++)
      m_AvbMixProperties_On[i] = false;
  createSourceMapForGain();
}

/************************************************************************
 * FUNCTION        : ~AMMultiDomainControlBase
 * DESCRIPTION     : Desructor
 * PARAMETER       :
 * RETURNVALUE     :
 * HISTORY         : GENIVI
 ************************************************************************/
AMMultiDomainControlBase::~AMMultiDomainControlBase()
{
  ETG_TRACE_USR4(("AMMultiDomainControlBase::Entered in destructor AMMultiDomainControlBase()"));
  PostOffice<PO_MessageConfig::enID>* pPO = InternalCommunicationAdapter::POMessages;
  if (pPO)
     try
     {
        pPO->RemoveObserver(this, PO_MessageConfig::ID_Amp_SetVolume);

     }
     catch(...)  {}
}

//MIC_PRIVATE
//CMP1_HDMI,
//CMP2_HDMI,
//CMP3_HDMI,
//CMP1_USB_VIDEO,
//CMP1_USB_AUDIO,
//CMR1_USB1_VIDEO,
//CMR1_USB2_VIDEO,
//CMR1_USB1_AUDIO,
//CMR1_USB2_AUDIO
void AMMultiDomainControlBase::createSourceMapForGain()
{
	m_SourceMapForGain["MIC_PRIVATE"]=1;
	m_SourceMapForGain["CMP1_HDMI"]=2;
	m_SourceMapForGain["CMP2_HDMI"]=3;
	m_SourceMapForGain["CMP3_HDMI"]=4;
	m_SourceMapForGain["CMP1_USB_VIDEO"]=5;
	m_SourceMapForGain["CMP1_USB_AUDIO"]=6;
	m_SourceMapForGain["CMR1_USB1_VIDEO"]=7;
	m_SourceMapForGain["CMR1_USB2_VIDEO"]=8;
	m_SourceMapForGain["CMR1_USB1_AUDIO"]=9;
	m_SourceMapForGain["CMR1_USB2_AUDIO"]=10;
}

/************************************************************************
 * FUNCTION     : startupController
 * DESCRIPTION  :
 * PARAMETER    : IAmControlReceive*
 * RETURNVALUE  : am_Error_e
 * HISTORY      :
 ************************************************************************/
am_Error_e AMMultiDomainControlBase::startupController(IAmControlReceive *controlreceiveinterface)
{
  ETG_TRACE_USR4(("AMMultiDomainControlBase::startupController Entered"));
  am_Error_e error = CAmControlSenderBase::startupController(controlreceiveinterface);
#if defined(VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_INF4CV ) || defined(VARIANT_S_FTR_ENABLE_UNITTEST)
  m_pSoundHandler = new SoundHandler();
  pVolumeManager = clGeniviAudioCtrlAdapter::getVolumeManager();
  if(m_pSoundHandler)
    m_pSoundHandler->vOnLoadSettings();
#endif
  ETG_TRACE_USR4(("AMMultiDomainControlBase::Entered in startupController, returning"));
  return error;
}

/************************************************************************
 * FUNCTION     : hookUserConnectionRequest
 * DESCRIPTION  : to establish new connection
 * PARAMETER    : const am_sourceID_t,const am_sinkID_t, am_mainConnectionID_t &,
 * RETURNVALUE  : am_Error_e
 * HISTORY      :
 ************************************************************************/
am_Error_e AMMultiDomainControlBase::hookUserConnectionRequest(const am_sourceID_t sourceID, const am_sinkID_t sinkID, am_mainConnectionID_t & mainConnectionID)
{
    //am_sourceID_t SrcID;
    ETG_TRACE_USR4(("AMMultiDomainControlBase::hookUserConnectionRequest entered source ID %d, sinkID %d",sourceID,sinkID));

    if(SYP_AM_SRV_STS_AVAILABLE != m_eGAM_ServiceAvailability)
    {
        ETG_TRACE_USR4(("AMMultiDomainControlBase::hookUserConnectionRequest(), m_eGAM_ServiceAvailability= %d", m_eGAM_ServiceAvailability));

        m_bIsPendingConnectRequest = true;
        mPendingConnectionRequest.sourceID = sourceID;
        mPendingConnectionRequest.sinkID = sinkID;
        mPendingConnectionRequest.mainConnectionID = mainConnectionID;
        ETG_TRACE_ERR(("AMMultiDomainControlBase::hookUserConnectionRequest, GAM Service is not available.."));
        return E_NOT_POSSIBLE;
    }
#if defined(VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_INF4CV ) || defined(VARIANT_S_FTR_ENABLE_UNITTEST)
    am::am_Error_e err = E_OK;

    if(bIsDiagSessionActive())
        return CAmControlSenderBase::hookUserConnectionRequest(sourceID,sinkID, mainConnectionID);

    if(disConnectionMsgList.size() > 0)
    {
    	ETG_TRACE_ERR(("disConnectionMsgList.size %d, we should reject",disConnectionMsgList.size()));
    }
    if(connectionMsgList.size() > 0)
    {
    	ETG_TRACE_ERR(("connectionMsgList.size %d, we should reject (rejecting, return E_NOT_POSSIBLE)",connectionMsgList.size()));
    	return E_NOT_POSSIBLE;
    }


    if(checkConflicts(sourceID,sinkID) == true)
    {
        //we have conflicts, start with the first action
        if(disConnectionMsgList.size() != 0)
        {
            (void)CAmControlSenderBase::hookUserDisconnectionRequest(disConnectionMsgList[0].mainConnectionID);
            // RTC-1 989832 CMC went for a reset when source change was done during mic 1 activation
            if(disConnectionMsgList.size() > 0)
                disConnectionMsgList.erase(disConnectionMsgList.begin());
        }
    }
    else
    {
        // we have no conflicts and can proceed
        err = hookUserConnectionRequestNoConflict(sourceID,sinkID, mainConnectionID);
    }
    return err;
#else
    //Dbus ARL, never has conflicts
    return hookUserConnectionRequestNoConflict(sourceID,sinkID,mainConnectionID);
#endif

}

am_Error_e AMMultiDomainControlBase::checkForMainConnectionOnGatewayConnection(const am_sourceID_t sourceID, const am_sinkID_t sinkID, am_mainConnectionID_t & mainConnectionID)
{
    //if sinkID is already in use, and if it is a gateway, we have to free the other part

    ETG_TRACE_USR4(("AMMultiDomainControlBase::checkForMainConnectionOnGatewayConnection sourceID %d, sinkID %d",sourceID,sinkID));

    //1. get the sub connection for this sinkID
    //virtual am_Error_e getListConnections(std::vector<am_Connection_s>& listConnections) const =0;
    std::vector<am_Connection_s> listConnections;
    std::vector<am_connectionID_t> listConnectionIDs;
    (void)mControlReceiveInterface->getListConnections(listConnections);
    for(unsigned int i=0;i<listConnections.size();i++)
    {
        if(listConnections[i].sinkID == sinkID)
        {
            ETG_TRACE_USR4(("found sub connection %d",listConnections[i].connectionID));
            //ignore AVB_Mic
            am_Source_s sourceData;
            (void)mControlReceiveInterface->getSourceInfoDB(listConnections[i].sourceID,sourceData);
            if( (sourceData.name != "AVB_Mic2") && (sourceData.name != "AVB_Mic3") )
            {
                listConnectionIDs.push_back(listConnections[i].connectionID);
            }
            else
            {
                ETG_TRACE_USR4(("ignoring source %s",sourceData.name.c_str()));
            }
        }
    }

    // if the sinkID is used in another sub connection (currently only one other is expected)
    if(listConnectionIDs.size() == 1)
    {
        //get corresponding main Connection
        am_Error_e err = AudioStack::clGeniviAudioCtrlAdapter::getMainConIDFromSubConID(listConnectionIDs[0], mainConnectionID);
        (void)err; //sometimes nice to see error code in debug session
        //ToDo: check return value and check for mainConnectionID !=0
        am_MainConnection_s mainConnectionData;
        mainConnectionData.mainConnectionID=0;
        mainConnectionData.listConnectionID.clear(); // clear to avoid random data

        (void)mControlReceiveInterface->getMainConnectionInfoDB(mainConnectionID, mainConnectionData);

        //disconnect the other part of the main connection, but only if not involved in any other main connection
        // use case: Main ID 2: FM -> ADR_LineOut AMP_AnalogIn_A -> AMP_A
        // request CMP_1_USB_AUDIO -> AMP_A
        // -> need to disconnect FM -> ADR_LineOut and source  change on AMP_A
        // ###################################################################
        // use case: 	 Main ID 2: FM -> ADR_LineOut AMP_AnalogIn_A -> AMP_A
        //				 Main ID 3: FM -> ADR_LineOut AMP_AnalogIn_A -> AMP_B
        // request CMP_1_USB_AUDIO -> AMP_A
        // -> no disconnect FM -> ADR_LineOut because it is needed for AMP_B in Main ID 3
        // but we need to remove the sub connection FM -> ADR_LineOut from  the list in Main ID 3
        for(unsigned int i=0;i<mainConnectionData.listConnectionID.size();i++)
        {
            if(listConnectionIDs[0] != mainConnectionData.listConnectionID[i])
            {
                ETG_TRACE_USR4(("listConnectionIDs[0] %d and mainConnectionData.listConnectionID[%d] %d",listConnectionIDs[0],i,mainConnectionData.listConnectionID[i]));
                //should be this that we want to disconnect. Other part can go via source switch?
                //ToDo: disconnect only if not used in any other main
                am_mainConnectionID_t otherMainConnectionID =0;
                if(bIsSubIdInOtherMainID(mainConnectionData.listConnectionID[i],mainConnectionID,otherMainConnectionID) == false)
                {
                    //getSourceInfoDB(const am_sourceID_t sourceID, am_Source_s& sourceData) const =0;
                    am_Source_s sourceData;
                    (void)mControlReceiveInterface->getSourceInfoDB(sourceID,sourceData);
                    AudioStack::AudioSource::clAudioSource* pSrc = clGeniviAudioCtrlAdapter::getAudioSource(AudioSource::SourceID(static_cast<sourceClassID>(sourceData.sourceClassID),0));
                    if(!pSrc->getSourceType().stackable)
                        err = AudioStack::clGeniviAudioCtrlAdapter::hookUserDisconnectionRequest(mainConnectionID,mainConnectionData.listConnectionID[i]);
                }
                else
                {
                    ETG_TRACE_USR4(("Sub Connection %d used in another main with ID %d",mainConnectionData.listConnectionID[i],otherMainConnectionID));
                    //need to remove it from this list
                    mainConnectionData.listConnectionID.erase(mainConnectionData.listConnectionID.begin()+i);
                    // and update the daemon
                    (void)mControlReceiveInterface->changeMainConnectionRouteDB(mainConnectionData.mainConnectionID,mainConnectionData.listConnectionID);
                }
                break;
            }
        }
    }
    else
    {
        ETG_TRACE_ERR(("We do not support cases when source is connected to multiple sinks in AVB domain"));
        //dummy statement
        (void)listConnectionIDs.size();
    }

    return E_OK;
}
// Will be called if requested connection has no conflicts and can be processed
am_Error_e AMMultiDomainControlBase::hookUserConnectionRequestNoConflict(const am_sourceID_t sourceID, const am_sinkID_t sinkID, am_mainConnectionID_t & mainConnectionID)
{
    if(mControlReceiveInterface == NULL)
    {
        //should never happen
        ETG_TRACE_ERR(("mControlReceiveInterface is NULL"));
        return E_UNKNOWN;
    }

    //am_sourceID_t SrcID=0;
    ETG_TRACE_USR4(("AMMultiDomainControlBase::hookUserConnectionRequestNoConflict entered source ID %d, sinkID %d",sourceID,sinkID));
    // GAM is available

    ETG_TRACE_USR4(("AMMultiDomainControlBase::hookUserConnectionRequestNoConflict, GAM Service is available.."));
    am_Source_s sourceData;
    am_Sink_s sinkData;

    am_Error_e sourceErr = mControlReceiveInterface->getSourceInfoDB(sourceID,sourceData);
    am_Error_e sinkErr   = mControlReceiveInterface->getSinkInfoDB(sinkID,sinkData);

    if((sourceErr == E_OK) && (sinkErr == E_OK))
    {
        ETG_TRACE_USR4(("hookUserConnectionRequest: Domain of SourceID %d is %d",sourceID,sourceData.domainID));
        ETG_TRACE_USR4(("hookUserConnectionRequest: Domain of SinkID %d is %d",sinkID,sinkData.domainID));
        ETG_TRACE_USR4(("hookUserConnectionRequest: Domain of Controller is %d",(int)clGeniviAudioCtrlAdapter::GetDomainID()));
        //SrcID = sourceID;
    }
    else
    {
        ETG_TRACE_ERR(("hookUserConnectionRequest: daemon returned error for sourceID %d (Err %d) and/or sinkID %d (Err%d)",
                sourceID,sourceErr,sinkID,sinkErr));
    }

    //ToDo: if we use gateway, need to check if gateway already in use:
    //    a) if in use and source and sink is different then not allowed. One AVB sink should not destroy the other
    //       if in use and source is same but sink is different then allowed (we want to stream from head unit to both AVB sinks)
    //    b) if in use and sink is same but source is different it is allowed. This is a typical source change
    //       -> need to destroy old route and set up new route.
    //    if no gateway involved, check if sink already in use
    //    c) if in use we need to destroy old route. This can be a route with gateway where both sub-routes need to be destroyed

    if(    (clGeniviAudioCtrlAdapter::GetDomainID() != sourceData.domainID) //source belongs to other (DBus) RoutingPlugin
        || (clGeniviAudioCtrlAdapter::GetDomainID() != sinkData.domainID) ) //daw2hi 18.10.2017 added
    {

        //check for possible (sub)routes
        //virtual am_Error_e getRoute(const bool onlyfree, const am_sourceID_t sourceID, const am_sinkID_t sinkID, std::vector<am_Route_s>& returnList) =0;
        am_Error_e getRoutErr;
        bool onlyfree = false;
        std::vector<am_Route_s> routeList;
        getRoutErr= mControlReceiveInterface->getRoute(onlyfree,sourceID,sinkID,routeList);

        ETG_TRACE_USR4(("hookUserConnectionRequest: getRoute with Error %d, routeList.size() = %d",getRoutErr,routeList.size()));
        ETG_TRACE_USR4(("we should have 1 possible Route: (Source -> GatewaySink) -> (GatewaySource -> Sink)"));

        if(routeList.size() == 0) //if we have no route we can not process
        {
            //daw2hi 01.12.2017 No route, this should be an error, maybe better to return with NOT_POSSIBLE
            ETG_TRACE_USR4(("ERROR No route for multi domain!!!"));
            return E_NOT_POSSIBLE;
        }
        //if we have a route


        //get the type
        AudioSource::clGeniviAudioSource* pSrc = clGeniviAudioCtrlAdapter::getAudioSource(AudioSource::SourceID(sourceData.sourceClassID,0));

        if(   (routeList.size()==1)
                && (routeList[0].route.size() == 1)    //only a main connection in AVB
                && (pSrc!=NULL)
                && (pSrc->getSourceType().name != "mix"))
        {
            //we know, it is main connection in other domain
            std::string topOfGatewaySink;
            clGeniviAudioCtrlAdapter::getTopOfGatewaySink(topOfGatewaySink);
            if(topOfGatewaySink == "MIC_PRIVATE")
                return E_NOT_POSSIBLE;
        }

        ETG_TRACE_USR4(("**Print Route details: routeList[0].sourceID %d, routeList[0].sinkID %d",routeList[0].sourceID, routeList[0].sinkID));
        for(unsigned int routeEl=0;routeEl<routeList[0].route.size();routeEl++)
        {
            ETG_TRACE_USR4(("routeList[0].route[%d].sourceID %d -- routeList[0].route[%d].sinkID %d, routeList[0].route[%d].domainID %d",
                    routeEl,routeList[0].route[routeEl].sourceID,
                    routeEl,routeList[0].route[routeEl].sinkID,
                    routeEl,routeList[0].route[routeEl].domainID));
        }
        ETG_TRACE_USR4(("Route details done **\n"));

        //store DP
        if((routeList.size()>0) && (routeList[0].route.size()==2))
        {
            ETG_TRACE_USR4(("Store DP for gateway connection"));
            clAudioSMEngine::vWriteDPexternalSink(sourceData.name,(tU16)sinkID);
        }

        ETG_TRACE_USR4(("calling clGeniviAudioCtrlAdapter::addMainConnection() for sourceID %d --> sinkID %d",sourceID, sinkID));

        //add the main connection
        am_Error_e err = E_OK;
        err= AudioStack::clGeniviAudioCtrlAdapter::addMainConnection(sourceID,sinkID, mainConnectionID);
        ETG_TRACE_USR4(("ControllerPlugin: called clGeniviAudioCtrlAdapter::addMainConnection got mainConnectionID %d and Error %d",mainConnectionID,err));



        //##############################
        // Need special handling for use case
        //
        // FM - ADR_3 = ON        AMP_AnalogIn_A------AMP_A = ON
        //
        //                        CMP1_USB_AUDIO----AMP_A = OFF
        // FM - ADR_3 = ON        AMP_AnalogIn_A------AMP_A = ON      //need to clean up the first part from FM -> AMP_A
        //
        //
        //##############################
        //##############################
        // and special handling for use case
        //
        // FM - ADR_3 = ON        AMP_AnalogIn_A------AMP_A = ON
        // FM - ADR_3 = ON                                        AMP_AnalogIn_A------AMP_B = ON
        //
        //
        //                        CMP1_USB_AUDIO----AMP_A = OFF
        // FM - ADR_3 = ON        AMP_AnalogIn_A------AMP_A = ON      //we must not clean up the first part from FM -> AMP_A because its shared with FM -> AMP_B
        // FM - ADR_3 = ON                                        AMP_AnalogIn_A------AMP_B = ON
        //
        //
        //##############################


        if(routeList[0].route.size()==1) //if it is a main connection
        {
            //use tmpMainConnectionID to not overwrite mainConnectionID
            am_mainConnectionID_t  tmpMainConnectionID =mainConnectionID;

            //check if sinkID is used in a gateway and take action
            (void)checkForMainConnectionOnGatewayConnection(sourceID,sinkID,tmpMainConnectionID);
        }

        //##############################
        //##############################



        // now check the subroutes
        for(unsigned int i=0;i<routeList[0].route.size();++i)
        {
            //            ETG_TRACE_USR4(("calling clGeniviAudioCtrlAdapter::setUpRoute(): sourceID %d -- sinkID %d, mainConnID %d",
            //                routeList[0].route[i].sourceID,
            //                routeList[0].route[i].sinkID,
            //                mainConnectionID));
            //this is to keep track (maybe we should store routeList / routeElements instead ?)
            AudioStack::clGeniviAudioCtrlAdapter::setUpRoute(routeList[0].route[i].sourceID,routeList[0].route[i].sinkID,mainConnectionID);
        }
        for(unsigned int i=0;i<routeList[0].route.size();++i)
        {
            //            ETG_TRACE_USR4(("RouteElement[%d] source %d, sink %d, domain %d, format %d",i,routeList[0].route[i].sourceID, routeList[0].route[i].sinkID,
            //                routeList[0].route[i].domainID, routeList[0].route[i].connectionFormat));
            //
            //            ETG_TRACE_USR4(("calling clGeniviAudioCtrlAdapter::hookUserConnectionRequest for subroute in Domain %d",routeList[0].route[i].domainID));
            //            ETG_TRACE_USR4(("sourceID %d --> sink ID %d  (mainConnectionID %d)",
            //                routeList[0].route[i].sourceID, routeList[0].route[i].sinkID, mainConnectionID));

            err = AudioStack::clGeniviAudioCtrlAdapter::hookUserConnectionRequest(routeList[0].route[i].sourceID,routeList[0].route[i].sinkID,mainConnectionID);
            ETG_TRACE_USR4(("hookUserConnectionRequest() for mainConnectionID %d gave err %d",mainConnectionID,err));
            if(err != E_OK)
            {
                ETG_TRACE_USR4(("hookUserConnectionRequest() not possible -> return"));
                return err;
            }


        } //for()

        //          ETG_TRACE_USR4(("CAmControlSenderBase::hookUserConnectionRequest() other domain end returning %d",(int)err));
        //should we leave here


        am_Sink_s sinkData;
        mControlReceiveInterface->getSinkInfoDB(sinkID, sinkData);
        ETG_TRACE_ERR(("AMMultiDomainControlBase::hookUserConnectionRequest sinkData.domainID %d, g_domainId %d sourceID %d", sinkData.domainID, g_domainId , sourceID));
        VolumeSinkData s;
        s.sink_Id = sinkID;
        s.sink_name = sinkData.name;
        ETG_TRACE_USR4(("AMMultiDomainControlBase::hookUserConnectionRequest s.sinkID: %d  s.sinkName: %s ",s.sink_Id, s.sink_name.c_str()));
        ID_SinkDetail SinkDetailPOMessage(s);
        iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(InternalCommunicationAdapter::getInstance(), E_UNKNOWN);
        iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(InternalCommunicationAdapter::getInstance()->POMessages, E_UNKNOWN);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&SinkDetailPOMessage);


        return E_OK;




        // dead code ???
        ETG_TRACE_USR4(("Change MainID %d to CS_CONNECTED",mainConnectionID));
        (void)mControlReceiveInterface->changeMainConnectionStateDB(mainConnectionID, CS_CONNECTED);

        return E_OK;
    } //if domains


    //domains are same as controller (connection inside controller domain)
    //return clGeniviAudioCtrlAdapter::hookUserConnectionRequest(sourceID,sinkID,mainConnectionID);
    am_Error_e retGAM = AudioStack::clGeniviAudioCtrlAdapter::hookUserConnectionRequest(sourceID,sinkID,mainConnectionID);
    ETG_TRACE_USR4(("AMMultiDomainControlBase::hookUserConnectionRequest() end returning %d",(int)retGAM));
    ETG_TRACE_USR4(("domains are same"));
    return retGAM;
}


bool AMMultiDomainControlBase::checkMediaPlayerConflicts(const am_sourceID_t sourceID, const am_sinkID_t sinkID,
		am_Source_s sourceData, am_Sink_s sinkData, am_Source_s activeSourceData, std::vector<am_sinkID_t> sinkList)
{

	bool bRet = false;
	//active source is MEDIA_PLAYER# and another MEDIA_PLAYER# is active too
	ETG_TRACE_USR4(("AMMultiDomainControlBase::checkMediaPlayerConflicts for sourceID %d - sinkkID %d",sourceID,sinkID));
	ETG_TRACE_USR4(("Requested MEDIA_PLAYER is %s",sourceData.name.c_str()));
	ETG_TRACE_USR4(("Active MEDIA_PLAYER is %s",activeSourceData.name.c_str()));
	ETG_TRACE_USR4(("connected on %d sinks",sinkList.size()));

	if(sinkList.size()>0)
	{
		//MEDIA_PLAYER is active on one or more Sinks
		bRet = true;

		ETG_TRACE_USR4(("MEDIA_PLAYER Conflict handling. We create disconnection and connection requests to solve it"));

		if(    (sinkList.size()>1)
				//if it is only one but on different sink we also have to take action
			|| ((sinkList.size()==1) && (sinkList[0]!=sinkData.sinkID)) )
		{
			//Need to fetch all MainConIDs
			std::vector<am_connectionID_t> mainConIDList;
			std::vector<am_sinkID_t> mainConIDSinkList;

			//get the list of main connections which are in conflict with current request
			getMainConnectionConflictList(activeSourceData.sourceID,sinkList,mainConIDList,mainConIDSinkList);
			for(unsigned int i=0;i<mainConIDList.size();i++)
			{
				ETG_TRACE_USR4(("Disconnect MainID %d",mainConIDList[i]));
				if(mainConIDSinkList[i] != (am_sinkID_t)midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS)
				{
					// this main connection has to be disconnected first, so put it into the disonnection list
					disConnectionMsg_t disConMsg;
					disConMsg.mainConnectionID = mainConIDList[i];
					disConnectionMsgList.push_back(disConMsg);
				}
				else
				{
					ETG_TRACE_USR4(("no hookUserDisconnectionRequest for %d on Sink 1",mainConIDList[i]));
					ETG_TRACE_USR4(("will be done by usual source change, put it into connection list as first entry"));
					ETG_TRACE_USR4(("Adding Connection sourceID %d, sinkID %d to front",sourceID,mainConIDSinkList[i]));

					connectionMsg_t conMsg;
					conMsg.sourceID = sourceID;
					conMsg.sinkID = mainConIDSinkList[i];
					connectionMsgList.insert(connectionMsgList.begin(),conMsg);
				}
			}
            ETG_TRACE_USR4(("Build Connect List from mainConIDList size %d",mainConIDList.size()));
			for(unsigned int i=0;i<mainConIDList.size();i++)
			{
				// connection list for all previous connections. Sink 1 is different and handled by source change
				if(mainConIDSinkList[i] != (am_sinkID_t)midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS)
				{
					ETG_TRACE_USR4(("Connect SourceID %d SinkID %d",sourceID,mainConIDSinkList[i]));
					connectionMsg_t conMsg;
					conMsg.sourceID = sourceID;
					conMsg.sinkID = mainConIDSinkList[i];
					connectionMsgList.push_back(conMsg);
				}
			}

			// If we have to do disconnects, then we should check if current request is for sink 1.
			// Then we need to add it to the connectionMsgList
			if(disConnectionMsgList.size()>0)
			{
				ETG_TRACE_USR4(("We have a disConnectionMsgList with size %d",disConnectionMsgList.size()));
				if(sinkID == (am_sinkID_t)midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS)
				{
					ETG_TRACE_USR4(("hookUserConnectionRequest is for sink 1"));
					bool bSkip=false;
					//check if sinkID = 1 is already in the list, if yes then skip it
					for(unsigned int i = 0;i<connectionMsgList.size();i++)
					{
						if(connectionMsgList[i].sinkID == (am_sinkID_t)midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS)
						{
							// it is already in the connection list
							bSkip=true;
							break;
						}
					}
					if(bSkip==false)
					{
						//just ensure that action for source change is considered. If not in list yet, add it here
						ETG_TRACE_USR4(("Adding Connection sourceID %d, sinkID %d to front",sourceID,sinkID));
						connectionMsg_t conMsg;
						conMsg.sourceID = sourceID;
						conMsg.sinkID = sinkID;
						connectionMsgList.insert(connectionMsgList.begin(),conMsg);
					}
					else
					{
						ETG_TRACE_USR4(("Skipped sourceID %d, sinkID %d, already in list",sourceID,sinkID));
					}
				}
			}
			else if(connectionMsgList.size() >0)
			{
				// Source AUX_1 			-> Sink AMP_A
				// Source MEDIA_PLAYER#1	-> Sink 1
				// request MEDIA_PLAYER#2	-> Sink AMP_A
				//---------------------------
				// solved by: SourceChange MEDIA_PLAYER#2 -> Sink 1 and Connect MEDIA_PLAYER#2 -> AMP_A
				ETG_TRACE_USR4(("MediaPlayer Conflict where no disconnect is required. connectionMsgList.size() %d",connectionMsgList.size()));

				//just ensure that action for source change is considered. If not in list yet, add it here
				ETG_TRACE_USR4(("Adding current Request sourceID %d, sinkID %d to end of list",sourceID,sinkID));
				connectionMsg_t conMsg;
				conMsg.sourceID = sourceID;
				conMsg.sinkID = sinkID;
				connectionMsgList.push_back(conMsg);

				am_mainConnectionID_t connectionID = 0;
				hookUserConnectionRequestNoConflict(connectionMsgList[0].sourceID, connectionMsgList[0].sinkID, connectionID);
			}

		}
		else
		{
			ETG_TRACE_USR4(("Calling additional Source Change SourceID %d -> SinkID %d",sourceID,sinkList[0]));
			am_mainConnectionID_t connectionID = 0;
			hookUserConnectionRequestNoConflict(sourceID,sinkList[0],connectionID);
		}

	} //if(sinkList.size()>0)
	else
	{
		ETG_TRACE_USR4(("No active MEDIA_PLAYER found on sinks. No MEDIA_PLAYER Conflict"));
	}

	return bRet;

}


// Possible Use Case
//
// Main ID 1	TUNER_FM -> Sink 1
// Main ID 2    TUNER_FM -> Sink 17 - AMP_AnalogIn_A -> Sink 105 (AMP_A)
// MAIN ID 3	TUNER_FM -> Sink 17 - AMP_AnalogIn_A -> Sink 106 (AMP_B)

// Request connect TUNER_AM -> Sink 1

// The sinkList should contain 3 entries: sinkList {1, 105, 106}
// The mainConIDSinkList should have: 	mainConIDSinkList {1,2,3}

// We have to create disConnectionMsgList {2,3}
// and connectionList {(TUNER_AM -> Sink 1),(TUNER_AM -> Sink 105),(TUNER_AM -> Sink 106)}

//This will create necessary disconnection and connection list for TunerConflict source change
bool AMMultiDomainControlBase::checkTunerConflicts(const am_sourceID_t sourceID, const am_sinkID_t sinkID,
        am_Source_s sourceData, am_Sink_s sinkData, am_Source_s activeSourceData, std::vector<am_sinkID_t> sinkList)
{
    bool bRet = false;

    //active source is a Tuner and another Tuner is active too
    ETG_TRACE_USR4(("AMMultiDomainControlBase::checkTunerConflicts for sourceID %d - sinkkID %d",sourceID,sinkID));
    ETG_TRACE_USR4(("Requested Tuner is %s",sourceData.name.c_str()));
    ETG_TRACE_USR4(("Active Tuner is %s",activeSourceData.name.c_str()));
    ETG_TRACE_USR4(("connected on %d sinks",sinkList.size()));

    if(sinkList.size()>0)
    {
        //Tuner is active on one or more Sinks
        bRet = true;

        ETG_TRACE_USR4(("Tuner Conflict handling. We create disconnection and connection requests to solve it"));

        if(    (sinkList.size()>1)
                //if it is only one but on different sink we also have to take action
            || ((sinkList.size()==1) && (sinkList[0]!=sinkData.sinkID)) )
        {
            //Need to fetch all MainConIDs
            std::vector<am_connectionID_t> mainConIDList;
            std::vector<am_sinkID_t> mainConIDSinkList;

            //get the list of main connections which are in conflict with current request
            getMainConnectionConflictList(activeSourceData.sourceID,sinkList,mainConIDList,mainConIDSinkList);
            for(unsigned int i=0;i<mainConIDList.size();i++)
            {
                ETG_TRACE_USR4(("Disconnect MainID %d",mainConIDList[i]));
                if(mainConIDSinkList[i]!=1)
                {
                    // this main connection has to be disconnected first, so put it into the disonnection list
                    disConnectionMsg_t disConMsg;
                    disConMsg.mainConnectionID = mainConIDList[i];
                    disConnectionMsgList.push_back(disConMsg);
                }
                else
                {
                    ETG_TRACE_USR4(("no hookUserDisconnectionRequest for %d on Sink 1",mainConIDList[i]));
                    ETG_TRACE_USR4(("will be done by usual source change, put it into connection list as first entry"));
                    ETG_TRACE_USR4(("Adding Connection sourceID %d, sinkID %d to front",sourceID,mainConIDSinkList[i]));

                    connectionMsg_t conMsg;
                    conMsg.sourceID = sourceID;
                    conMsg.sinkID = mainConIDSinkList[i];
                    connectionMsgList.insert(connectionMsgList.begin(),conMsg);
                }
            }
            ETG_TRACE_USR4(("Build Connect List from mainConIDList size %d",mainConIDList.size()));
            for(unsigned int i=0;i<mainConIDList.size();i++)
            {
                // connection list for all previous connections. Sink 1 is different and handled by source change
                if(mainConIDSinkList[i]!=1)
                {
                    ETG_TRACE_USR4(("Connect SourceID %d SinkID %d",sourceID,mainConIDSinkList[i]));
                    connectionMsg_t conMsg;
                    conMsg.sourceID = sourceID;
                    conMsg.sinkID = mainConIDSinkList[i];
                    connectionMsgList.push_back(conMsg);
                }
            }

            // If we have to do disconnects, then we should check if current request is for sink 1.
            // Then we need to add it to the connectionMsgList
            if(disConnectionMsgList.size()>0)
            {
                ETG_TRACE_USR4(("We have a disConnectionMsgList with size %d",disConnectionMsgList.size()));
                if(sinkID == 1)
                {
                    ETG_TRACE_USR4(("hookUserConnectionRequest is for sink 1"));
                    bool bSkip=false;
                    //check if sinkID = 1 is already in the list, if yes then skip it
                    for(unsigned int i = 0;i<connectionMsgList.size();i++)
                    {
                        if(connectionMsgList[i].sinkID==1)
                        {
                            // it is already in the connection list
                            bSkip=true;
                            break;
                        }
                    }
                    if(bSkip==false)
                    {
                        //just ensure that action for source change is considered. If not in list yet, add it here
                        ETG_TRACE_USR4(("Adding Connection sourceID %d, sinkID %d to front",sourceID,sinkID));
                        connectionMsg_t conMsg;
                        conMsg.sourceID = sourceID;
                        conMsg.sinkID = sinkID;
                        connectionMsgList.insert(connectionMsgList.begin(),conMsg);
                    }
                    else
                    {
                        ETG_TRACE_USR4(("Skipped sourceID %d, sinkID %d, already in list",sourceID,sinkID));
                    }
                }
            }
            else if(connectionMsgList.size() >0)
            {
                // Source AUX_1 -> Sink AMP_A
                // Source AM    -> Sink 1
                // request FM -> Sink AMP_A
                //---------------------------
                // solved by: SourceChange FM -> Sink 1 and Connect FM -> AMP_A
                ETG_TRACE_USR4(("Tuner Conflict where no disconnect is required. connectionMsgList.size() %d",connectionMsgList.size()));

                //just ensure that action for source change is considered. If not in list yet, add it here
                ETG_TRACE_USR4(("Adding current Request sourceID %d, sinkID %d to end of list",sourceID,sinkID));
                connectionMsg_t conMsg;
                conMsg.sourceID = sourceID;
                conMsg.sinkID = sinkID;
                connectionMsgList.push_back(conMsg);

                am_mainConnectionID_t connectionID = 0;
                hookUserConnectionRequestNoConflict(connectionMsgList[0].sourceID, connectionMsgList[0].sinkID, connectionID);
            }

        }
        else
        {
            ETG_TRACE_USR4(("Calling additional Source Change SourceID %d -> SinkID %d",sourceID,sinkList[0]));
            am_mainConnectionID_t connectionID = 0;
            hookUserConnectionRequestNoConflict(sourceID,sinkList[0],connectionID);
        }
    } //if(sinkList.size()>0)
    else
    {
        ETG_TRACE_USR4(("No active Tuner found on sinks. No Tuner Conflict"));
    }
	return bRet;
}

bool AMMultiDomainControlBase::isMediaPlayerSourceClass(std::string sourceName)
{
	const std::string strMediaPlayer("MEDIA_PLAYER");
	const std::string strMediaBtAudio("PHONE_BTAUDIO");
	//find if it is any MEDIA_PLAYER
	if(
		   (sourceName.compare(0,strMediaPlayer.size(),strMediaPlayer)==0)
		|| (sourceName.compare(0,strMediaBtAudio.size(),strMediaBtAudio)==0) )
	{
		//request is for MEDIA_PLAYER or PHONE_BTAUDIO
		return true;
	}
	return false;
}

// check if the request causes any conflict with existing connections due to resource limitations
// Only one Tuner can be active at a time
// Only one source can be given towards AVB domain
// CAM Port can create only one stream at a time
bool AMMultiDomainControlBase::checkConflicts(const am_sourceID_t sourceID, const am_sinkID_t sinkID)
{
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface,false);
    bool bRet = false;

    am_Source_s sourceData;
    am_Sink_s sinkData;
    am_Source_s activeSourceData;
    std::vector<am_sinkID_t> sinkList;
    //if source is of type TUNER (AM,FM,DAB)
    //check if any other TUNER is active

    //get sourceData of requested sourceID
    am_Error_e sourceErr = mControlReceiveInterface->getSourceInfoDB(sourceID,sourceData);
    (void)sourceErr; //sometimes nice to see value of error code in debug session
    //get sinkData of requested sinkID
    am_Error_e sinkErr = mControlReceiveInterface->getSinkInfoDB(sinkID,sinkData);
    (void)sinkErr; //sometimes nice to see value of error code in debug session
    //get source class info of requested SourceID
    am_SourceClass_s classInfo;
    am_Error_e sourceClassErr = mControlReceiveInterface->getSourceClassInfoDB(sourceID, classInfo);
    (void)sourceClassErr; //sometimes nice to see value of error code in debug session

    // check if it is a Tuner Source Class
    if(AudioStack::clGeniviAudioCtrlAdapter::isTunerSourceClass(classInfo.name)==true)
	{
    	ETG_TRACE_USR4(("it is Tuner Source Class %s",sourceData.name.c_str()));
    	// get the source Data of the active Tuner and its connected sinks
		getActiveTunerAndSinkList(activeSourceData,sinkList);
		// check if active Tuner and requested Tuner is different ...
		if(sourceData.name.compare(activeSourceData.name)!= 0)
		{
			// ... it is different, call TunerConflict
			if(true == checkTunerConflicts(sourceID, sinkID, sourceData, sinkData, activeSourceData,sinkList))
			{
				//if we have already a Tuner conflict we can not have additional Gateway conflict
				return true;
			}
		}
	} // if TUNER_AM, FM, DAB, ..

	//check for other conflicts: HU MediaPlayer only one stream at a time
	// check if it is a MediaPlayer Source Class: "MEDIA_PLAYER#"
    else if(isMediaPlayerSourceClass(classInfo.name)==true)
	{
    	ETG_TRACE_USR4(("it is MediaPlayer Source Class %s",sourceData.name.c_str()));
    	// get the source Data of the active Tuner and its connected sinks
		getActiveMediaPlayerAndSinkList(activeSourceData,sinkList);
		// check if active Tuner and requested Tuner is different ...
		if(sourceData.name.compare(activeSourceData.name)!= 0)
		{
			// ... it is different, call MediaPlayerConflict
			if(true == checkMediaPlayerConflicts(sourceID, sinkID, sourceData, sinkData, activeSourceData,sinkList))
			{
				//if we have  a MediaPlayer conflict we can have additional Gateway conflict
				// e.g.
				// MEDIA_PLAYER#1 	-> AST
				// FM 				-> AMP_A

				// request: MEDIA_PLAYER#2 	-> AMP_B
				return true;
			}
		}
	} // if MEDIA_PLAYER, ..


	else if(checkGatewayConflict(sourceData,sinkData))
	{
		ETG_TRACE_USR4(("GatewayConflict detected"));
		return true;
	}
	else if(checkCamPortConflict(sourceData,sinkData))
	{
		ETG_TRACE_USR4(("CamPortConflict detected"));
		return true;

	}
	//need to cover the case where source in Pause has to be disconnect first before connecting the new request
	else if(checkSrcChangeOnPausedSource(sourceData,sinkData))
	{
		ETG_TRACE_USR4(("Source change on paused source detected"));
		return true;
	}

	return bRet;

}


// This will be used if an existing sub connection can be re-used. Currently only for re use of AVB domain connection
// example:
//
//  MainID 2: FM  -> AMP_A
//      SubID 3: FM             -> ADR3
//      SubID 4: AMP_AnalogIn_A -> AMP_A
//
// we request connection AM -> AMP_A, SubID 4 from MainOD 2 can be reused in  MainID 3
//
//  MainID 3: AM    -> AMP_A
//      SubID 5: AM             -> ADR3
//      SubID 4: AMP_AnalogIn_A -> AMP_A
//
// Change will be done in daemon data and in internal data

am_Error_e AMMultiDomainControlBase::moveConnectionFromMainToOtherMain(am_MainConnection_s& fromMainConnectionData, am_MainConnection_s& toMainConnectionData)
{

	am_sourceID_t srcID = getSourceID(std::string("AMP_AnalogIn_A"));


	std::vector<am_Connection_s> listConnections;
	am_Connection_s movingConnection;

	mControlReceiveInterface->getListConnections(listConnections);
	for(unsigned int i=0;i<listConnections.size();i++)
	{
		if(listConnections[i].sourceID==srcID)
		{
			ETG_TRACE_USR4(("listConnections[%d]: connectionID %d, sourceID %d, sinkID %d",i,listConnections[i].connectionID,listConnections[i].sourceID,listConnections[i].sinkID));
			movingConnection = listConnections[i];
			ETG_TRACE_USR4(("movingConnection: conID %d, sourceID %d, sinkID %d",movingConnection.connectionID,movingConnection.sourceID, movingConnection.sinkID));

			break;
		}
	}
	//std::vector<am_connectionID_t> listConnectionID;
	std::vector<am_connectionID_t>::iterator it;
	ETG_TRACE_USR4(("moveConnectionFromMainToOtherMain from MainID %d to MainID %d",fromMainConnectionData.mainConnectionID,toMainConnectionData.mainConnectionID));
	for(it=fromMainConnectionData.listConnectionID.begin();it!=fromMainConnectionData.listConnectionID.end();it++)
	{
		if(*it == movingConnection.connectionID)
		{
			am_Error_e error = clGeniviAudioCtrlAdapter::removeConnectionFromMainConnectionInternal(movingConnection.sourceID,movingConnection.sinkID,fromMainConnectionData.mainConnectionID);

			ETG_TRACE_USR4(("moveConnectionFromMainToOtherMain *it=%d, movingConnection.connectionID %d -> erase (err %d)",*it, movingConnection.connectionID,error));
			//remove the connection from the old one
			fromMainConnectionData.listConnectionID.erase(it);
			mControlReceiveInterface->changeMainConnectionRouteDB(fromMainConnectionData.mainConnectionID,fromMainConnectionData.listConnectionID);
			break;
		}
	}

	for(it=fromMainConnectionData.listConnectionID.begin();it!=fromMainConnectionData.listConnectionID.end();it++)
	{
		ETG_TRACE_USR4(("fromMainConnectionData.listConnectionID: %d",*it));
	}

	//Debug
	am_MainConnection_s dbgMainConnection;
	mControlReceiveInterface->getMainConnectionInfoDB(fromMainConnectionData.mainConnectionID,dbgMainConnection);
	for(it=dbgMainConnection.listConnectionID.begin();it!=dbgMainConnection.listConnectionID.end();it++)
	{
		ETG_TRACE_USR4(("dbgMainConnection.listConnectionID: %d",*it));
	}
	//Debug end


	//add the connection to the new
	toMainConnectionData.listConnectionID.push_back(movingConnection.connectionID);
	mControlReceiveInterface->changeMainConnectionRouteDB(toMainConnectionData.mainConnectionID,toMainConnectionData.listConnectionID);
	//ToDo: update internal
    clGeniviAudioCtrlAdapter::setUpRoute(movingConnection.sourceID,movingConnection.sinkID,toMainConnectionData.mainConnectionID);

	ETG_TRACE_USR4(("After adding ID %d to MainID %d we have",movingConnection.connectionID,toMainConnectionData.mainConnectionID));

    //Debug
	mControlReceiveInterface->getMainConnectionInfoDB(toMainConnectionData.mainConnectionID,dbgMainConnection);
	ETG_TRACE_USR4(("dbgMainConnection.mainConnectionID %d",dbgMainConnection.mainConnectionID));
	for(it=dbgMainConnection.listConnectionID.begin();it!=dbgMainConnection.listConnectionID.end();it++)
	{
		ETG_TRACE_USR4(("dbgMainConnection.listConnectionID: %d",*it));
	}
	//Debug end

	return E_OK;

}

// tell if given source and sink are in different domains
// return true if different domains
// return false if same domains
bool AMMultiDomainControlBase::bIsSourceSinkInDifferentDomain(am_sourceID_t sourceID, am_sinkID_t sinkID)
{
	  ETG_TRACE_USR4(("bIsSourceSinkInDifferentDomain sourceID %d, sinkID %d",sourceID,sinkID));
	  am_Source_s sourceData;
	  am_Sink_s sinkData;
	  (void)mControlReceiveInterface->getSourceInfoDB(sourceID, sourceData);
	  (void)mControlReceiveInterface->getSinkInfoDB(sinkID, sinkData);
	  if(sourceData.domainID != sinkData.domainID)
	  {
		  ETG_TRACE_USR4(("bIsSourceSinkInDifferentDomain true"));
		  return true;
	  }
	  ETG_TRACE_USR4(("bIsSourceSinkInDifferentDomain false"));
	  return false;
}

//find out if we have another connection that needs gateway and has only one sub connection
am_Error_e AMMultiDomainControlBase::checkForAdditionalConnectionActions(am_MainConnection_s& mainConnectionData, std::vector<am_MainConnection_s> listMainConnections)
{
	ETG_TRACE_USR4(("checkForAdditionalConnectionActions: mainConnectionData ID %d, listConnectionID.size() %d",mainConnectionData.mainConnectionID, mainConnectionData.listConnectionID.size()));
	if(mainConnectionData.listConnectionID.size() > 1)
	{
		//only for gateway connections
		//go through listMainConnections
		for(unsigned int i=0; i<listMainConnections.size();i++)
		{
			//only other main connections need to be considered and only those where gateway is needed (different domains)
			if(   (listMainConnections[i].mainConnectionID != mainConnectionData.mainConnectionID)
			   && (true == bIsSourceSinkInDifferentDomain(listMainConnections[i].sourceID,listMainConnections[i].sinkID)) )
			{
				ETG_TRACE_USR4(("getMainConnectionInfoDB for ID %d",listMainConnections[i].mainConnectionID));
				//try to move a connection from one main into other
				am_MainConnection_s toMainConnectionData;
				mControlReceiveInterface->getMainConnectionInfoDB(listMainConnections[i].mainConnectionID, toMainConnectionData);
				//ToDo: update internal data

				moveConnectionFromMainToOtherMain(mainConnectionData,toMainConnectionData);

				break;
			}
		}
	}
	return E_OK;
}

//virtual
am_Error_e AMMultiDomainControlBase::hookUserDisconnectionRequest(const am_mainConnectionID_t mainConnectionID)
{
  iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface,E_UNKNOWN);
  ETG_TRACE_USR4(("AMMultiDomainControlBase::hookUserDisconnectionRequest entered mainConnectionID %d",mainConnectionID));
  //##### daw2hi added 16.6.2017

  am_Error_e err = E_OK;
  std::vector<am_Connection_s> listConnections;
  err = mControlReceiveInterface->getListConnections(listConnections);
  for(unsigned int i=0; i<listConnections.size();i++)
  {
	  ETG_TRACE_USR4(("ID %d, SourceID %d -> SinkID %d",listConnections[i].connectionID,listConnections[i].sourceID,listConnections[i].sinkID));
  }

  std::vector<am_MainConnection_s> listMainConnections;
  err = mControlReceiveInterface->getListMainConnections(listMainConnections);
  for(unsigned int i=0; i<listMainConnections.size();i++)
  {
	  ETG_TRACE_USR4(("MainID %d, SourceID %d -> SinkID %d, connection in state %d",
			  listMainConnections[i].mainConnectionID,listMainConnections[i].sourceID,listMainConnections[i].sinkID,listMainConnections[i].connectionState));

	  for(unsigned int k=0; k<listMainConnections[i].listConnectionID.size();k++)
	  {
		  ETG_TRACE_USR4(("\t ID %d",listMainConnections[i].listConnectionID[k]));
	  }
  }

  (void)err; //sometimes nice to see the value of err in debug session

  //get data for the main connection
  am_MainConnection_s mainConnectionData;
  mControlReceiveInterface->getMainConnectionInfoDB(mainConnectionID, mainConnectionData);

  //Need to check for condition where gateway connection can be kept for next connection
  //e.g.
  //ADR_3: MIC_PRIVATE : ON
  //ADR_3: TUNER_FM :    PAUSE

  //AMP_A:   AMP_AnalogIn_A :  ON

  //Daemon Data should have
  // Main ID A:  TUNER_FM -> AMP_A	(CS_SUSPENDED)
  //   SubID  :  TUNER_FM -> ADR_3
  // (the gateway connection was given to MIC_PRIVATE)

  // Main ID B:  MIC_PRIVATE    -> AMP_A	(CS_CONNECTED)
  //   SubID  :  TUNER_FM       -> ADR_3
  //   SubID  :  AMP_AnalogIn_A -> AMP_A

  // When Main ID B gets disconnected we have to identify that Main ID A needs the Gateway
  // Before disconnecting all Sub IDs of Main ID A we move the Gateway back to Main ID A.
  // This will prevent a disconnection and reconnection of the Gateway
  // When source change operation is done on Stack ADR_3 there is no knowledge about
  // a necessary Gateway. Thats why we need to consider it here in advance.

  //call for the check of further activities
  checkForAdditionalConnectionActions(mainConnectionData,listMainConnections);
  //end

  //call again as it might have been updated (SubIDs might be moved for reuse)
  mControlReceiveInterface->getMainConnectionInfoDB(mainConnectionID, mainConnectionData);


  //if we have no connection for this we can just remove it
  if(mainConnectionData.listConnectionID.size() == 0)
  {
      //const am_sourceID_t sourceID, am_Source_s& sourceData)
      am_Source_s sourceData;
      mControlReceiveInterface->getSourceInfoDB(mainConnectionData.sourceID,sourceData);
      if( (sourceData.name == "AVB_Mic2") || (sourceData.name == "AVB_Mic3") )
      {
    	  ETG_TRACE_USR4(("hookUserDisconnectionRequest for AVB_Mic without connection -> RequestSourceOff for AVB_Mic"));
          AudioStack::clGeniviAudioCtrlAdapter::RequestSourceOff(mainConnectionData.sourceID);
          return E_OK;
      }
  }


  if(mainConnectionData.listConnectionID.size()==0 && mainConnectionData.connectionState==CS_CONNECTING)
	  clGeniviAudioCtrlAdapter::hookUserDisconnectionRequest(mainConnectionID);

  //daw2hi 2.11.2017 we now have correct mainConnectionData.listConnectionID with multiple entries
  // no need to to use get Route
  for(unsigned int i=0; i<mainConnectionData.listConnectionID.size();i++)
  {
    ETG_TRACE_USR4(("MainID %d: SubCon %d",mainConnectionID,mainConnectionData.listConnectionID[i]));
  }

  for(unsigned int i=0; i<mainConnectionData.listConnectionID.size();i++)
  {
    ETG_TRACE_USR4(("Call Disconnect for MainID %d: SubCon %d",mainConnectionID,mainConnectionData.listConnectionID[i]));
    am_Error_e err = clGeniviAudioCtrlAdapter::hookUserDisconnectionRequest(mainConnectionID,mainConnectionData.listConnectionID[i]);
    (void) err; //sometimes nice to see the value of err in debug session
  }
  return E_OK;
}

/************************************************************************
 * FUNCTION     : cbAckSetSinkSoundProperty
 * DESCRIPTION     : ack for SetSinkSoundProperty
 * PARAMETER    : const am_Handle_s , const am_Error_e
 * RETURNVALUE     : void
 * HISTORY         : GENIVI
 ************************************************************************/
void AMMultiDomainControlBase::cbAckSetSinkSoundProperty(const am_Handle_s handle, const am_Error_e error)
{
    ETG_TRACE_USR4(("AMMultiDomainControlBase::cbAckSetSinkSoundProperty entered with handle (type %d/%d) and error = %d",handle.handleType,handle.handle,error));
    //(void) handle;
    //vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface);

    ETG_TRACE_USR4(("m_AVBMicVolumeHandle %d.%d",m_AVBMicVolumeHandle.handleType,m_AVBMicVolumeHandle.handle));
    ETG_TRACE_USR4(("m_AVBMic1GainHandle  %d.%d",m_AVBMic1GainHandle.handleType,m_AVBMic1GainHandle.handle));
    ETG_TRACE_USR4(("m_AVBMixBassHandle   %d.%d",m_AVBMixBassHandle.handleType,m_AVBMixBassHandle.handle));
    ETG_TRACE_USR4(("m_AVBMixTrebleHandle %d.%d",m_AVBMixTrebleHandle.handleType,m_AVBMixTrebleHandle.handle));
    ETG_TRACE_USR4(("\n"));
    //ETG_TRACE_USR4(("soundProperty %d = %d",soundProperty.type,soundProperty.value));
    ETG_TRACE_USR4(("\n"));

    ETG_TRACE_USR4(("Dump m_MapHandle"));
    for(auto it=m_MapHandle.begin();it!=m_MapHandle.end();it++)
    {
        ETG_TRACE_USR4(("m_MapHandle[%d] = %d.%d",it->first,it->second.handle.handleType,it->second.handle.handle));
    }

    //give trigger to FlowControl
    m_FlowControl.cbAckSetSinkSoundProperty(handle, error);


    MapHandleIterator_t it;
    tU16 key = (tU16)((handle.handleType)<<10);
    key = (tU16)(key + handle.handle);
    it = m_MapHandle.find(key);
    if(it != m_MapHandle.end())
    {
        //if it is found, then it cannot be MSP_AVB_MIC_VOLUME
        ETG_TRACE_USR4(("Found handle in map, pass to CAmControlSenderBase"));
        CAmControlSenderBase::cbAckSetSinkSoundProperty(handle,error);
        return;
    }


    if(    (handle.handleType == m_AVBMicVolumeHandle.handleType)
        && (handle.handle == m_AVBMicVolumeHandle.handle) )
    {
        //ETG_TRACE_USR4(("soundProperty %d = %d (might be wrong !!!)",soundProperty.type,soundProperty.value));
        ETG_TRACE_USR4(("call cbAckSetVolumeChange with AVB_MicVolume %d = %d",
                soundPropertyAVB_MicVolume.type,soundPropertyAVB_MicVolume.value));
        clGeniviAudioCtrlAdapter::cbAckSetVolumeChange(handle, soundPropertyAVB_MicVolume.value, error);
        soundPropertyAVB_MicVolume.type = MSP_MAX;
        soundPropertyAVB_MicVolume.value = 0;
        m_AVBMicVolumeHandle.handleType= H_UNKNOWN;
        m_AVBMicVolumeHandle.handle=0;

    }
    else if(    (handle.handleType == m_AVBMic1GainHandle.handleType)
            && (handle.handle == m_AVBMic1GainHandle.handle) )
    {
        //ETG_TRACE_USR4(("soundProperty %d = %d (might be wrong !!!)",soundProperty.type,soundProperty.value));
        ETG_TRACE_USR4(("call cbAckSetVolumeChange with AVB_Mic1Gain %d = %d",
                soundPropertyAVB_Mic1Gain.type,soundPropertyAVB_Mic1Gain.value));
        clGeniviAudioCtrlAdapter::cbAckSetVolumeChange(handle, soundPropertyAVB_Mic1Gain.value, error);
        soundPropertyAVB_Mic1Gain.type = MSP_MAX;
        soundPropertyAVB_Mic1Gain.value = 0;
        m_AVBMic1GainHandle.handleType= H_UNKNOWN;
        m_AVBMic1GainHandle.handle=0;

    }


}

void AMMultiDomainControlBase::applyMic1Gain(const AmpVolumeData& ampData, unsigned int dBLevel,bool bMicGainLevel)
{
    static bool bMicGain = false;

    if(!bMicGain)
    bMicGain = bMicGainLevel;

    if( (bMicGain == false) && (dBLevel ==  0))
    {
        ETG_TRACE_USR2(("MIC_PRIVATE gain is already off, no action"));
        return;
    }
    else if( (bMicGain == true) && (dBLevel != 0))
    {
        ETG_TRACE_USR2(("MIC_PRIVATE gain is already on, no action"));
        return;
    }
    if(dBLevel == 0)
    {
        ETG_TRACE_USR2(("Switch off MIC_PRIVATE gain (0)"));
        bMicGain = false;
    }
    else if(dBLevel != 0)
    {
        ETG_TRACE_USR2(("Switch on MIC_PRIVATE gain(%d)",dBLevel));
        bMicGain = true;
    }

    //ETG_TRACE_USR2(("For MIC_PRIVATE we apply extra gain(%d) = %d dB to AMP_A", MSP_AVB_MIC1_GAIN, dBLevel));
    //soundProperty.type = MSP_AVB_MIC1_GAIN;
    //soundProperty.value = (am_volume_t)dBLevel;

    soundPropertyAVB_Mic1Gain.type = MSP_AVB_MIC1_GAIN;
    soundPropertyAVB_Mic1Gain.value = (am_volume_t)dBLevel;

    m_AVBMic1GainHandle.handleType = H_UNKNOWN;
    m_AVBMic1GainHandle.handle = 0;
    if (E_OK != mControlReceiveInterface->setSinkSoundProperty(m_AVBMic1GainHandle, ampData.m_Sink, soundPropertyAVB_Mic1Gain))
    {
        ETG_TRACE_USR1(("mControlReceiveInterface->setSinkSoundProperty MSP_AVB_MIC1_GAIN failed"));
    }
    else
    {
        ETG_TRACE_USR4(("mControlReceiveInterface->setSinkSoundProperty MSP_AVB_MIC1_GAIN with handle  %d.%d",m_AVBMic1GainHandle.handleType,m_AVBMic1GainHandle.handle));
    }
}


void AMMultiDomainControlBase::applyExtSourceGain(const AmpVolumeData& ampData, unsigned int dBLevel)
{

    if( (bExtSourceGain == false) && (dBLevel ==  0) )
    {
        ETG_TRACE_USR2(("EXT_SOURCE gain is already off, no action"));
        return;
    }
    else if( (bExtSourceGain == true) && (dBLevel != 0))
    {
        ETG_TRACE_USR2(("EXT_SOURCE gain is already on, no action"));
        return;
    }
    if(dBLevel == 0)
    {
        ETG_TRACE_USR2(("Switch off EXT_SOURCE gain (0)"));
        bExtSourceGain = false;
    }
    else if(dBLevel != 0)
    {
        ETG_TRACE_USR2(("Switch on EXT_SOURCE gain(%d)",dBLevel));
        bExtSourceGain = true;
    }

    //ETG_TRACE_USR2(("For MIC_PRIVATE we apply extra gain(%d) = %d dB to AMP_A", MSP_AVB_MIC1_GAIN, dBLevel));
    //soundProperty.type = MSP_AVB_MIC1_GAIN;
    //soundProperty.value = (am_volume_t)dBLevel;

    soundPropertyAVB_Mic1Gain.type = MSP_AVB_MIC1_GAIN;
    soundPropertyAVB_Mic1Gain.value = (am_volume_t)dBLevel;

    m_AVBMic1GainHandle.handleType = H_UNKNOWN;
    m_AVBMic1GainHandle.handle = 0;
    if (E_OK != mControlReceiveInterface->setSinkSoundProperty(m_AVBMic1GainHandle, ampData.m_Sink, soundPropertyAVB_Mic1Gain))
    {
        ETG_TRACE_USR1(("mControlReceiveInterface->setSinkSoundProperty MSP_AVB_MIC1_GAIN failed"));
    }
    else
    {
        ETG_TRACE_USR1(("mControlReceiveInterface->setSinkSoundProperty MSP_AVB_MIC1_GAIN with handle %d.%d",
                m_AVBMic1GainHandle.handleType,m_AVBMic1GainHandle.handle));
    }
}


void AMMultiDomainControlBase::switchAvbMixProperties(bool bOn, am_sinkID_t sinkID)
{

    unsigned char activeMic=0;
    if(bIsAnyMicActive(activeMic))
    {
        ETG_TRACE_USR1(("switchAvbMixProperties active Mic %d",activeMic));
    }

    if(bOn == true)
    {
        if(m_AvbMixProperties_On[activeMic] == true)
        {
            ETG_TRACE_USR1(("AVB Mix Properties for Mic%d already on, no action",activeMic));
            return;
        }
        else
        {

            ETG_TRACE_USR1(("AVB Mix Properties for Mic%d will be switched on",activeMic));
            m_AvbMixProperties_On[activeMic] = true;

            rMainSinkSoundPropertySet set;
            set.handle.handleType = H_UNKNOWN;
            set.handle.handle = 0;
            set.sinkID = sinkID;
            set.mainSoundProperty.type = MSP_AVB_MIX_BASS;  //Check: use this or MSP_SOUND_BASS_RELATIVE ??
            set.mainSoundProperty.value = 0;
            vHandleSinkSoundProperty_Bass(set);

            rMainSinkSoundPropertySet setTreble;
            setTreble.handle.handleType = H_UNKNOWN;
            setTreble.handle.handle = 0;
            setTreble.sinkID = sinkID;
            setTreble.mainSoundProperty.type = MSP_AVB_MIX_TREBLE;
            setTreble.mainSoundProperty.value = 0;
            vHandleSinkSoundProperty_Treble(setTreble);
        }
    }
    else
    {
        ETG_TRACE_USR1(("switchAvbMixProperties Off"));
        if(   (m_AvbMixProperties_On[MIC_1]==false)
           && (m_AvbMixProperties_On[MIC_2]==false)
           && (m_AvbMixProperties_On[MIC_3]==false) )
        {
            ETG_TRACE_USR1(("Already off for all Mic (1,2,3), no action"));
            return;
        }

        m_AvbMixProperties_On[MIC_1]=false;
        m_AvbMixProperties_On[MIC_2]=false;
        m_AvbMixProperties_On[MIC_3]=false;

        rMainSinkSoundPropertySet setBass;
        setBass.handle.handleType = H_UNKNOWN;
        setBass.handle.handle = 0;
        setBass.sinkID = sinkID;
        setBass.mainSoundProperty.type = MSP_SOUND_BASS_RELATIVE; //this should trigger update to HMI when no Mic is On
        setBass.mainSoundProperty.value = 0;
        vHandleSinkSoundProperty_Bass(setBass);

        rMainSinkSoundPropertySet setTreble;
        setTreble.handle.handleType = H_UNKNOWN;
        setTreble.handle.handle = 0;
        setTreble.sinkID = sinkID;
        setTreble.mainSoundProperty.type = MSP_SOUND_TREBLE_RELATIVE;   //this should trigger update to HMI when no Mic is On
        setTreble.mainSoundProperty.value = 0;
        vHandleSinkSoundProperty_Treble(setTreble);
    }
}


void AMMultiDomainControlBase::applySourceSpecificGain(const AmpVolumeData& ampData)
{
	ETG_TRACE_USR1(("applySourceSpecificGain with status %d for source %s",ampData.m_status,ampData.m_Source.c_str()));
	auto it = m_SourceMapForGain.find(ampData.m_Source);

	if(it==m_SourceMapForGain.end())
	{
		ETG_TRACE_USR1(("Source not found in map: status %d name %s",ampData.m_status,ampData.m_Source.c_str()));
		//if not MIC
		if(ampData.m_status != 0)
		{
                    ETG_TRACE_USR1(("call to switch off the AvbMixProperties"));
                    switchAvbMixProperties(AVB_MIX_PROPERTIES_OFF,ampData.m_Sink);
                    ETG_TRACE_USR1(("call to switch off the gain"));

                    unsigned char activeMic=0;
                    if(!bIsAnyMicActive(activeMic)) // Avoid setting ExtSource Gain 0 when MIC is Active For Bug1296695:  
                    {
                         applyMic1Gain(ampData,MSP_MIC1_GAIN_LEVEL_OFF,true);
                         ETG_TRACE_USR1(("call to switch off ExtSourceGain"));
                         applyExtSourceGain(ampData,MSP_MIC1_GAIN_LEVEL_OFF);
                    }

		}
		return;
	}

	ETG_TRACE_USR1(("Source found in Map: ID %d with name %s",it->second,it->first.c_str()));
	switch (it->second)
	{
		case 1: //MIC
		{
			if(ampData.m_status != 0)
			{
				ETG_TRACE_USR1(("Mic1 and status not 0"));
				switchAvbMixProperties(AVB_MIX_PROPERTIES_ON,ampData.m_Sink);
				applyMic1Gain(ampData,MSP_MIC1_GAIN_LEVEL_ON);
			}
			break;
		}
		case 2:
		case 3:
		case 4:
		case 5:
		case 6:
		case 7:
		case 8:
		case 9:
		case 10:
		{
			//if not MIC
			if(ampData.m_status != 0)
			{
				ETG_TRACE_USR1(("Ext Source and status not 0"));
				switchAvbMixProperties(AVB_MIX_PROPERTIES_ON,ampData.m_Sink);
				applyMic1Gain(ampData,MSP_MIC1_GAIN_LEVEL_OFF);

				//we have to apply -6dB
                                bExtSourceGain = false;
				applyExtSourceGain(ampData,MSP_AVB_SOURCE_GAIN_LEVEL_ON);
			}

			break;
		}
		default :
		{
			// Should never happen because it should return when not found in map
			ETG_TRACE_ERR(("Default should never happen here"));
			//if not MIC
			if(ampData.m_status != 0)
			{
				ETG_TRACE_USR1(("Other source and status not 0"));
				switchAvbMixProperties(AVB_MIX_PROPERTIES_ON,ampData.m_Sink);
				applyMic1Gain(ampData,MSP_MIC1_GAIN_LEVEL_OFF);
				applyExtSourceGain(ampData,MSP_MIC1_GAIN_LEVEL_OFF);
			}
		}
	} //switch

}

void AMMultiDomainControlBase::MessageNotification(PO_MessageConfig::enID MsgId)
{
    vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface);
    PostOffice<PO_MessageConfig::enID>* pPO = InternalCommunicationAdapter::POMessages;
    vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(pPO);
    switch (MsgId)
    {
    case PO_MessageConfig::ID_Amp_SetVolume:
    {
        vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(pPO->QueryMessage<ID_Amp_SetVolume>(MsgId));
        const AmpVolumeData& ampData = pPO->QueryMessage<ID_Amp_SetVolume>(MsgId)->value;
        ETG_TRACE_USR2(("AMMultiDomainControlBase::MessageNotification"
                " - launched amplifier volume command for stream = %u, Step = %d"
                " , dB = %d, Ramp (lin/log) = %d/%d  SinkID %d Source %s"
                , ampData.m_enStream, ampData.m_VolStep
                , ampData.m_VoldB, ampData.m_RampLin, ampData.m_RampdB, ampData.m_Sink, ampData.m_Source.c_str()));

        ETG_TRACE_USR2(("AMMultiDomainControlBase::MessageNotification status %d",ampData.m_status));

        if(ampData.m_Source == "NONE")
        {
        	ETG_TRACE_USR2(("Volume for source NONE ignored"));
            unsigned char activeMic=0;
            if(bIsAnyMicActive(activeMic))
            {
                ETG_TRACE_USR1(("bIsAnyMicActive: Mic %d is active",activeMic));
            }
            else
            {
                ETG_TRACE_USR1(("bIsAnyMicActive: No Mic is active"));
                switchAvbMixProperties(AVB_MIX_PROPERTIES_OFF,ampData.m_Sink);
            }

       		return;
        }

        applySourceSpecificGain(ampData);
#if 0
        if ((ampData.m_Source == "MIC_PRIVATE") && (ampData.m_status != 0))
        {
            switchAvbMixProperties(AVB_MIX_PROPERTIES_ON,ampData.m_Sink);
            applyMic1Gain(ampData,MSP_MIC1_GAIN_LEVEL_ON);
        }
        else if ((ampData.m_Source != "MIC_PRIVATE") && (ampData.m_status != 0))
        {
            switchAvbMixProperties(AVB_MIX_PROPERTIES_OFF,ampData.m_Sink);
            applyMic1Gain(ampData,MSP_MIC1_GAIN_LEVEL_OFF);

        }
#endif
        //Check if we have Gateway connection. If yes, than change the source and use gateway source
        //am_sourceID_t clAudioSMEngine::getSourceIDbyName(ampData.m_Source);
        am_Source_s sourceData;
        mControlReceiveInterface->getSourceInfoDB(getSourceID(ampData.m_Source), sourceData);
        am_Sink_s sinkData;
        mControlReceiveInterface->getSinkInfoDB((am_sinkID_t)ampData.m_Sink, sinkData);

        std::string sourceNameToUse = ampData.m_Source;
        if(sourceData.domainID != sinkData.domainID)
        {
            sourceNameToUse = "AMP_AnalogIn_A";
        }

        std::string topOfStackMixSrcName("EMPTY");
        std::string topOfStackMixSrcState("EMPTY");

        if(clGeniviAudioCtrlAdapter::pcoGetTopOfStackMixsource(ampData.m_Sink) != NULL)
        {
            ETG_TRACE_USR1(("Mix Source not NULL"));
            if(clGeniviAudioCtrlAdapter::pcoGetTopOfStackMixsource(ampData.m_Sink)->pacGetName() != NULL)
            {
                ETG_TRACE_USR1(("Mix Source Name not NULL, %s",clGeniviAudioCtrlAdapter::pcoGetTopOfStackMixsource(ampData.m_Sink)->pacGetName()));
                topOfStackMixSrcName = std::string(clGeniviAudioCtrlAdapter::pcoGetTopOfStackMixsource(ampData.m_Sink)->pacGetName());
                topOfStackMixSrcState = std::string(clGeniviAudioCtrlAdapter::pcoGetTopOfStackMixsource(ampData.m_Sink)->pacGetState(ampData.m_Sink));
                ETG_TRACE_USR1(("Mix Source State not NULL, %s",clGeniviAudioCtrlAdapter::pcoGetTopOfStackMixsource(ampData.m_Sink)->pacGetState(ampData.m_Sink)));
            }
        }

        ETG_TRACE_USR1(("sourceNameToUse = %s",sourceNameToUse.c_str()));
        ETG_TRACE_USR1(("topOfStackMixSrcName = %s",topOfStackMixSrcName.c_str()));

        bool bMuteEntertainOn=false;
        clAudioSource* pSrc =  clGeniviAudioCtrlAdapter::pcoGetTopOfStack(ampData.m_Sink);
        if(pSrc != NULL)
        {
            std::string topSrc(pSrc->pacGetName());
            std::string srcState(pSrc->pacGetState(ampData.m_Sink));
            ETG_TRACE_USR1(("topSrc %s",topSrc.c_str()));
            ETG_TRACE_USR1(("srcState %s",srcState.c_str()));

            if( (topSrc=="MUTE_ENTERTAIN") && (srcState =="on") )
            {
                bMuteEntertainOn=true;
            }

        }

        if(    (clGeniviAudioCtrlAdapter::pcoGetTopOfStackMixsource(ampData.m_Sink) != NULL)
                && (bMuteEntertainOn==true)
                && (ampData.m_Source != "AVB_Mic2")
                && (ampData.m_Source != "AVB_Mic3") )
        {
            ETG_TRACE_USR1(("No AVB_Mic volume when bMuteEntertain On and source is not AVB_Mic"));
            return;
        }

        am_Error_e error;
        if(   ampData.m_Source == "AVB_Mic2"
           || ampData.m_Source == "AVB_Mic3"
           || ((clGeniviAudioCtrlAdapter::pcoGetTopOfStackMixsource(ampData.m_Sink) != NULL) && (bMuteEntertainOn==true) )
        )
        {
        	//ToDo: Set also Bass and Treble
        	//setAVBMixBassTreble(ampData.m_Sink);

            switchAvbMixProperties(AVB_MIX_PROPERTIES_ON,ampData.m_Sink);

            //soundProperty.type = 0x4716;
            soundPropertyAVB_MicVolume.type = MSP_AVB_MIC_VOLUME;
            soundPropertyAVB_MicVolume.value = (am_volume_t)ampData.m_VoldB;

            m_AVBMicVolumeHandle.handleType = H_UNKNOWN;
            m_AVBMicVolumeHandle.handle=0;
            if((error = mControlReceiveInterface->setSinkSoundProperty(m_AVBMicVolumeHandle,ampData.m_Sink,soundPropertyAVB_MicVolume)) != E_OK)
            {
                ETG_TRACE_USR1(("mControlReceiveInterface->setSinkSoundProperty instead of volume failed"));
            }
            else
            {
                ETG_TRACE_USR1(("mControlReceiveInterface->setSinkSoundProperty with value %d instead of volume success handle %d, %d",
                        soundPropertyAVB_MicVolume.value,m_AVBMicVolumeHandle.handleType,m_AVBMicVolumeHandle.handle));
                //inform source with new handle
                am_SourceClass_s classInfo;
                mControlReceiveInterface->getSourceClassInfoDB(getSourceID(ampData.m_Source), classInfo);


                ETG_TRACE_USR1(("mControlReceiveInterface->setSinkSoundProperty instead of volume SourceClass %s",classInfo.name.c_str()));

                if(AudioStack::clGeniviAudioCtrlAdapter::pcoGetTopOfStackMixsource(ampData.m_Sink) != NULL)
                {
                    ETG_TRACE_USR4(("Top of Stack %d (Mix)AudioSource %s",ampData.m_Sink,
                            AudioStack::clGeniviAudioCtrlAdapter::pcoGetTopOfStackMixsource(ampData.m_Sink)->pacGetName()));
                    ETG_TRACE_USR4(("Top of Stack %d (Mix)AudioSource in State %s",ampData.m_Sink,
                            AudioStack::clGeniviAudioCtrlAdapter::pcoGetTopOfStackMixsource(ampData.m_Sink)->pacGetState(ampData.m_Sink)));
                }
                if(AudioStack::clGeniviAudioCtrlAdapter::getAudioSource(AudioStack::AudioSource::SourceID(static_cast<sourceClassID>(classInfo.sourceClassID),0)) != NULL)
                {
                    //inform source with sink handle
                    AudioStack::clGeniviAudioCtrlAdapter::getAudioSource(AudioStack::AudioSource::SourceID(static_cast<sourceClassID>(classInfo.sourceClassID),0))->setSinkHandle(&m_AVBMicVolumeHandle,ampData.m_Sink);
                }
                else
                {
                    ETG_TRACE_ERR(("AudioStack::clGeniviAudioCtrlAdapter::getAudioSource(AudioStack::AudioSource::SourceID(static_cast<sourceClassID>(classInfo.sourceClassID),0) gave NULL"));
                }
            }
        }
        else
        {
            ETG_TRACE_USR1(("called with correct source"));
            //suppress this for top of stack source when it is still OFF
            if(    (clGeniviAudioCtrlAdapter::pcoGetTopOfStack(ampData.m_Sink) != NULL)
                    && (true == clGeniviAudioCtrlAdapter::pcoGetTopOfStack(ampData.m_Sink)->bIsOff(ampData.m_Sink))
                    && (sourceNameToUse ==  clGeniviAudioCtrlAdapter::pcoGetTopOfStack(ampData.m_Sink)->pacGetName()))
            {
                ETG_TRACE_USR1(("no setSinkVolume for sink %d and source %s in state off",ampData.m_Sink,
                        clGeniviAudioCtrlAdapter::pcoGetTopOfStack(ampData.m_Sink)->pacGetName()));
            }
            else
            {
                m_VolumeHandle.handleType = H_UNKNOWN;
                m_VolumeHandle.handle=0;

                //don't even send volume if MUTE_ENTERTAINMENT is ON stack
                ETG_TRACE_USR1(("mControlReceiveInterface->changeSinkMainVolumeDB call volume %d, sinkID %d",ampData.m_VolStep,ampData.m_Sink));
                if(clGeniviAudioCtrlAdapter::pcoGetTopOfStack(ampData.m_Sink)!=NULL)
                {
                    std::string topSrc(clGeniviAudioCtrlAdapter::pcoGetTopOfStack(ampData.m_Sink)->pacGetName());
                    if( (topSrc.compare("MUTE_ENTERTAIN")==0) && (ampData.m_VolStep != 0) )
                    {
                        ETG_TRACE_USR1(("no setSinkVolume if MUTE_ENTERTAIN on top and volume is not 0 (mute level)"));
                        //just call again the mute update for test
                        mControlReceiveInterface->changeSinkMuteStateDB(MS_MUTED,ampData.m_Sink);
                    }
                    //cover RTC 1184403 no Volume when MUTE_SYSTEM is active
                    else if((topSrc.compare("MUTE_SYSTEM")==0) && (ampData.m_VolStep != 0))
                    {
                        ETG_TRACE_USR1(("no setSinkVolume if MUTE_SYSTEM on top and volume is not 0"));
                    }
                    else
                    {
                        //For Bug_1211799, When Switching between MIC2 and MIC3 or vice versa,volume set for main source in between is disabled with below change
                    	if((topOfStackMixSrcName == "AVB_Mic2") && ((topOfStackMixSrcState == "off") || (topOfStackMixSrcState == "StartMute") || (topOfStackMixSrcState == "rampdownToOff")))
                    	{
                            ETG_TRACE_USR1(("no setSinkVolume Called, if MIC is Still Active Here"));
			}
			else
			{
                            am_Error_e tmpErr = mControlReceiveInterface->setSinkVolume(m_VolumeHandle, ampData.m_Sink, (am_volume_t)ampData.m_VoldB, RAMP_GENIVI_NO_PLOP, 20);
                            ETG_TRACE_USR4(("Called setSinkVolume sinkID %d, volume %d with handle %d.%d and error %d",
                                ampData.m_Sink,ampData.m_VoldB,m_VolumeHandle.handleType,m_VolumeHandle.handle,tmpErr));
			}
                    }
                }
                else
                {
                	ETG_TRACE_USR4(("Top of Stack for sinkID %d is NULL, can not send volume",ampData.m_Sink));
                }

                //need to inform the source with this handle (temp. Solution)
                am_SourceClass_s classInfo;
                mControlReceiveInterface->getSourceClassInfoDB(getSourceID(sourceNameToUse), classInfo);

                if(clGeniviAudioCtrlAdapter::pcoGetTopOfStack(ampData.m_Sink)!=NULL)
                {
                    ETG_TRACE_USR4(("Top of Stack %d AudioSource %s",ampData.m_Sink,
                            clGeniviAudioCtrlAdapter::pcoGetTopOfStack(ampData.m_Sink)->pacGetName()));
                    ETG_TRACE_USR4(("Top of Stack %d AudioSource in State %s",ampData.m_Sink,
                            clGeniviAudioCtrlAdapter::pcoGetTopOfStack(ampData.m_Sink)->pacGetState(ampData.m_Sink)));
                }
                if(clGeniviAudioCtrlAdapter::getAudioSource(SourceID(static_cast<sourceClassID>(classInfo.sourceClassID),0))!=NULL)
                    clGeniviAudioCtrlAdapter::getAudioSource(SourceID(static_cast<sourceClassID>(classInfo.sourceClassID),0))->setSinkHandle(&m_VolumeHandle,ampData.m_Sink);

            }
        }

        if(ampData.m_status)
        {
            bool bDoUpdate=true;
            // no update if mute on this sink?
            ETG_TRACE_USR1(("mControlReceiveInterface->changeSinkMainVolumeDB call volume %d, sinkID %d",ampData.m_VolStep,ampData.m_Sink));
            if(clGeniviAudioCtrlAdapter::pcoGetTopOfStack(ampData.m_Sink)!=NULL)
            {
                std::string topSrc(clGeniviAudioCtrlAdapter::pcoGetTopOfStack(ampData.m_Sink)->pacGetName());
                if((ampData.m_VolStep == 0) && (topSrc.compare("MUTE_ENTERTAIN")==0) )
                {
                    bDoUpdate=false;
                }
            }

            if(bDoUpdate)
            {
                if((error = mControlReceiveInterface->changeSinkMainVolumeDB((am_mainVolume_t)ampData.m_VolStep, (am_sinkID_t)ampData.m_Sink )) != E_OK)
                {
                    ETG_TRACE_USR1(("mControlReceiveInterface->changeSinkMainVolumeDB failed"));
                }
            }
        }
        else
        {
            ETG_TRACE_USR1(("called with wrong source, no update"));
        }


        //print if mic is active
        unsigned char activeMic=0;
        if(bIsAnyMicActive(activeMic))
        {
            ETG_TRACE_USR1(("bIsAnyMicActive: Mic %d is active",activeMic));
            switchAvbMixProperties(AVB_MIX_PROPERTIES_ON,ampData.m_Sink);
        }
        else
        {
            ETG_TRACE_USR1(("bIsAnyMicActive: No Mic is active"));
            switchAvbMixProperties(AVB_MIX_PROPERTIES_OFF,ampData.m_Sink);
        }

    }
    break;
    default:
    {
        ETG_TRACE_USR2(("AMMultiDomainControlBase::MessageNotification ID %d not handled here",MsgId));
    }

    } //switch()
}

//return the Genivi sourceID from a given source name
am_sourceID_t AMMultiDomainControlBase::getSourceID(std::string SrcName)
{

    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface,E_UNKNOWN);
    std::vector<am_Source_s> listSources;

    if(mControlReceiveInterface->getListSources(listSources)== E_OK)
    {
        for (std::vector<am_Source_s>::iterator it = listSources.begin() ; it != listSources.end(); ++it)
        {
            if ((it->name).compare(SrcName)==0)
                return it->sourceID;

        }
     }

    return 0;
}
am_sinkID_t AMMultiDomainControlBase::getSinkID(std::string SinkName)
{
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface,E_UNKNOWN);
    std::vector<am_Sink_s> listSinks;

    if(mControlReceiveInterface->getListSinks(listSinks)== E_OK)
    {
        for (std::vector<am_Sink_s>::iterator it = listSinks.begin() ; it != listSinks.end(); ++it)
        {
            if ((it->name).compare(SinkName)==0)
                return it->sinkID;
        }
    }
    return 0;
}

bool AMMultiDomainControlBase::checkGatewayConflict(am_Source_s sourceData, am_Sink_s sinkData)
{
	ETG_TRACE_USR4(("checkGatewayConflict sourceData.domainID %d, sinkData.domainID %d",sourceData.domainID,sinkData.domainID));
	iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface,true);

	bool bRet=false;
	if(   (sourceData.domainID == AudioStack::clGeniviAudioCtrlAdapter::GetDomainID())
	   && (sourceData.domainID != sinkData.domainID) )
	{
		//this requires gateway, now check if gateway already in use
		std::vector<am_MainConnection_s> tmpListMainConnections;
		(void)mControlReceiveInterface->getListMainConnections(tmpListMainConnections);
		for(unsigned int i=0;i<tmpListMainConnections.size();i++)
		{
			if(tmpListMainConnections[i].listConnectionID.size()==2)
			{
                ETG_TRACE_USR4(("checkGatewayConflict() sourceID %d -> sinkID %d in conflict with Main ID %d: sourceID %d -> sinkID %d",
						sourceData.sourceID,sinkData.sinkID, tmpListMainConnections[i].mainConnectionID,
						tmpListMainConnections[i].sourceID,tmpListMainConnections[i].sinkID));						

				if(tmpListMainConnections[i].sinkID == sinkData.sinkID)
				{
					ETG_TRACE_USR4(("No conflict because sinks are same??"));
				}
				else if(tmpListMainConnections[i].sourceID == sourceData.sourceID)
				{
					ETG_TRACE_USR4(("No conflict because source is same??"));
				}
				else
				{
					ETG_TRACE_USR4(("Conflict because sinks are different"));
					//gateway in use and different sink requested
					// this main connection has to be disconnected first, so put it into the disconnection list
					disConnectionMsg_t disConMsg;
					disConMsg.mainConnectionID = tmpListMainConnections[i].mainConnectionID;
					disConnectionMsgList.push_back(disConMsg);

					connectionMsg_t conMsg;
					conMsg.sourceID = sourceData.sourceID;
					conMsg.sinkID = sinkData.sinkID;
					//connectionMsgList.insert(connectionMsgList.begin(),conMsg);
					connectionMsgList.push_back(conMsg);

					//old conflicting sink will get new source
					conMsg.sourceID = sourceData.sourceID;
					conMsg.sinkID = tmpListMainConnections[i].sinkID;
					//connectionMsgList.insert(connectionMsgList.begin(),conMsg);
					connectionMsgList.push_back(conMsg);

					//flag the conflict
					bRet=true;
					break;
				}
			}
		}
	}
	return bRet;

}

bool AMMultiDomainControlBase::checkCamPortConflict(am_Source_s sourceData, am_Sink_s sinkData)
{
	ETG_TRACE_USR4(("checkCamPortConflict sourceData.domainID %d, sinkData.domainID %d",sourceData.domainID,sinkData.domainID));
	iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface,true);

	// only one of below active at a time
	// CMPx_USB_AUDIO
	// CMPx_USB_VIDEO
	// CMPx_HDMI
	bool bRet=false;
	std::vector<am_MainConnection_s> tmpListMainConnections;
	(void)mControlReceiveInterface->getListMainConnections(tmpListMainConnections);

	std::string CMPx_USB_AUDIO("CMP");
	std::string CMPx_USB_VIDEO("CMP");
	std::string CMPx_HDMI("CMP");
	for(int cmpIdx=1;cmpIdx<=4;cmpIdx++)
	{
		CMPx_USB_AUDIO = CMPx_USB_AUDIO + std::to_string(cmpIdx) + "_USB_AUDIO";
		CMPx_USB_VIDEO = CMPx_USB_VIDEO + std::to_string(cmpIdx) + "_USB_VIDEO";
		CMPx_HDMI = CMPx_HDMI + std::to_string(cmpIdx) + "_HDMI";

		if(   (sourceData.name.compare(CMPx_USB_AUDIO)==0)
		   || (sourceData.name.compare(CMPx_USB_VIDEO)==0)
		   || (sourceData.name.compare(CMPx_HDMI)==0) )
		{
			ETG_TRACE_USR4(("Request is for %s",sourceData.name.c_str()));

			//check if any of this is active
			am_Source_s activeSourceData;
			for(unsigned int i=0;i<tmpListMainConnections.size();i++)
			{
				(void)mControlReceiveInterface->getSourceInfoDB(tmpListMainConnections[i].sourceID,activeSourceData);
				if(   (activeSourceData.name.compare(CMPx_USB_AUDIO) == 0)
				   || (activeSourceData.name.compare(CMPx_USB_VIDEO) == 0)
				   || (activeSourceData.name.compare(CMPx_HDMI) == 0) )
				{
					ETG_TRACE_USR4(("We have an active CMP1_xxx audio source"));
					//now, are they different
					if(sourceData.name.compare(activeSourceData.name) != 0)
					{
						std::string trace("Requested ");
						trace = trace + sourceData.name +" is different to active " + activeSourceData.name + " audio source";
						ETG_TRACE_USR4(("%s",trace.c_str()));
						ETG_TRACE_USR4(("Requested CMP1_xxx is different to active CMP1_xxx audio source"));
						//yes, different. Also different sink?
						if(tmpListMainConnections[i].sinkID != sinkData.sinkID)
						{
							//yes, then it is a conflict
							ETG_TRACE_USR4(("CMP1 Conflict detected"));
							ETG_TRACE_USR4(("sourceID %d -> sinkID %d in conflict with Main ID %d: sourceID %d -> sinkID %d",
									sourceData.sourceID, sinkData.sinkID,tmpListMainConnections[i].mainConnectionID,tmpListMainConnections[i].sourceID,tmpListMainConnections[i].sinkID));

							//ToDo: create action List
							disConnectionMsg_t disConMsg;
							disConMsg.mainConnectionID = tmpListMainConnections[i].mainConnectionID;
							disConnectionMsgList.push_back(disConMsg);

							connectionMsg_t conMsg;
							conMsg.sourceID = sourceData.sourceID;
							conMsg.sinkID = sinkData.sinkID;
							connectionMsgList.push_back(conMsg);

#if 0 //we have trouble to start same source on another sink until we got the ack for volume
      //this is because of our m_CuractiveSink which gets changed too early. So I deactivate this for the moment
							//old conflicting sink will get new source
							conMsg.sourceID = sourceData.sourceID;
							conMsg.sinkID = tmpListMainConnections[i].sinkID;
							connectionMsgList.push_back(conMsg);
#endif
							//flag conflict
							bRet=true;
						}

					}
				}
			}

		}
	}
	return bRet;
}

bool AMMultiDomainControlBase::checkSrcChangeOnPausedSource(am_Source_s sourceData, am_Sink_s sinkData)
{
    ETG_TRACE_USR4(("checkSrcChangeOnPausedSource"));
    bool bRet=false;
    std::string searchSource("None");
    am_Source_s searchSourceData;

    if( (sinkData.name != "AMP_A") && (sinkData.muteState != MS_MUTED) )
    {
        return bRet;
    }
    if((sourceData.name != "CMP1_USB_VIDEO") && (sourceData.name != "CMP1_HDMI"))
    {
        return bRet;
    }

    if(sourceData.name == "CMP1_USB_VIDEO") searchSource="CMP1_HDMI";
    else if(sourceData.name == "CMP1_HDMI") searchSource="CMP1_USB_VIDEO";

    std::vector<am_MainConnection_s> tmpListMainConnections;
    (void)mControlReceiveInterface->getListMainConnections(tmpListMainConnections);

    for(unsigned int i=0;i<tmpListMainConnections.size();i++)
    {
        am_Error_e sourceErr = mControlReceiveInterface->getSourceInfoDB(tmpListMainConnections[i].sourceID,searchSourceData);
        ETG_TRACE_USR4(("checkSrcChangeOnPausedSource: sourceErr = %d",sourceErr));
        if( (searchSourceData.name == searchSource) && (tmpListMainConnections[i].connectionState == CS_SUSPENDED) )
        {
            ETG_TRACE_USR4(("found source %s",searchSource.c_str()));
            ETG_TRACE_USR4(("we have to disconnect mainID %d",tmpListMainConnections[i].mainConnectionID));
            disConnectionMsg_t disConMsg;
            disConMsg.mainConnectionID = tmpListMainConnections[i].mainConnectionID;
            disConnectionMsgList.push_back(disConMsg);

            connectionMsg_t conMsg;
            conMsg.sourceID = sourceData.sourceID;
            conMsg.sinkID = sinkData.sinkID;
            connectionMsgList.push_back(conMsg);

            bRet=true;
            break;
        }
    }

    return bRet;
}

bool AMMultiDomainControlBase::bIsAnyMicActive(unsigned char& mic)
{
    am_sourceID_t sourceID=0;
    std::string mic1("MIC_PRIVATE");
    std::string mic2("AVB_Mic2");
    std::string mic3("AVB_Mic3");

    am_Source_s sourceData;
    std::vector<unsigned char> micList;

    std::vector<am_MainConnection_s> listMainConnections;
    am_Error_e err = mControlReceiveInterface->getListMainConnections(listMainConnections);
    for(unsigned int i=0;i<listMainConnections.size();i++)
    {
        if(listMainConnections[i].connectionState==CS_CONNECTED)
        {
            mControlReceiveInterface->getSourceInfoDB(listMainConnections[i].sourceID,sourceData);
            if(sourceData.name == mic1)
            {
                ETG_TRACE_USR4(("Found Mic 1, push to vector"));
                //mic=1;
                //return true;
                micList.push_back(MIC_1);
            }
            else if(sourceData.name == mic2)
            {
                ETG_TRACE_USR4(("Found Mic 2, push to vector"));
                //mic=2;
                //return true;
                micList.push_back(MIC_2);
            }
            else if(sourceData.name == mic3)
            {
                ETG_TRACE_USR4(("Found Mic 3, push to vector"));
                //mic=3;
                //return true;
                micList.push_back(MIC_3);
            }
        }
    }

    if(micList.end() != find(micList.begin(), micList.end(), MIC_1))
    {
        ETG_TRACE_USR4(("return Mic 1"));
        mic = MIC_1;
        return true;
    }

    if(micList.end() != find(micList.begin(), micList.end(), MIC_2))
    {
        ETG_TRACE_USR4(("return Mic 2"));
        mic = MIC_2;
        return true;
    }

    if(micList.end() != find(micList.begin(), micList.end(), MIC_3))
    {
        ETG_TRACE_USR4(("return Mic 3"));
        mic = MIC_3;
        return true;
    }

    mic=0;
    return false;
}

/************************************************************************
 *FUNCTION     : vHandleSinkSoundProperty_Bass
 *DESCRIPTION  : Handler for Bass and Bass relative sound property
 *PARAMETER    : rMainSinkSoundPropertySet &set
 *RETURN VALUE : void
 *HISTORY      :
 *27.01.2014   Rev 1.0     RBEI/ECG4 - Ranjit Susal  Initial Revision
 ************************************************************************/
void AMMultiDomainControlBase::vHandleSinkSoundProperty_Bass(rMainSinkSoundPropertySet &set)
{
    ETG_TRACE_USR4(("AMMultiDomainControlBase::vHandleSinkSoundProperty_Bass Entered for sink %d",set.sinkID));
    vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface);

    am_Sink_s sinkData;
    mControlReceiveInterface->getSinkInfoDB(set.sinkID, sinkData);
    ETG_TRACE_USR4(("AMMultiDomainControlBase::vHandleSinkSoundProperty_Bass sinkData.domainID %d",sinkData.domainID));

    //now for all domains
    if(sinkData.domainID != clGeniviAudioCtrlAdapter::GetDomainID() && m_pSoundHandler)
    {
        vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_pSoundHandler);
        //we give this to SoundHandler, but we map before to an internal sink in SoundHandler
        rMainSinkSoundPropertySet setCopy = set;
        MapSinkNameSoundSinkIterator_t it = m_MapSinkNameSoundSink.find(sinkData.name);
        if(it != m_MapSinkNameSoundSink.end())
        {
            std::string text = sinkData.name + " to " + std::to_string(it->second);
            ETG_TRACE_USR4(("Mapping sink %s",text.c_str()));
            setCopy.sinkID = it->second;
        }
        else
        {
            ETG_TRACE_ERR(("SinkID %d not found, no action",set.sinkID));
            return;
        }


        //ToDo: Check if Mic1,2,3 active: if active call MixBass
        unsigned char mic=0;
        if(bIsAnyMicActive(mic))
        {
            set.mainSoundProperty.type = MSP_AVB_MIX_BASS;
            setCopy.mainSoundProperty.type = MSP_AVB_MIX_BASS;
            (void)m_pSoundHandler->bSetMixBass(setCopy,mic);
        }
        else
        {
            (void)m_pSoundHandler->bSetBass(setCopy);
        }

        if(mic==MIC_1) //hack property type back if it is MIC_1 (Mic1 does not use MSP_AVB_MIX_BASS, but it uses own BASS)
        {
            set.mainSoundProperty.type = MSP_SOUND_BASS_RELATIVE;
            setCopy.mainSoundProperty.type = MSP_SOUND_BASS_RELATIVE;
        }

        //write back value
        set.mainSoundProperty.value = setCopy.mainSoundProperty.value;

        ETG_TRACE_USR4(("Bass mainSoundProperty is now %d",set.mainSoundProperty.value));
        // From set.mainSoundProperty which is of type am_MainSoundProperty_s we have to create a variable of type
        am_SoundProperty_s soundProperty; //maybe we need to change some values? Then we could use this to give back am_SoundProperty_s used by ControlReceive
        soundProperty.type = (am_CustomSoundPropertyType_t)set.mainSoundProperty.type;


        am_Error_e error = E_UNKNOWN;
        //ToDo: we might have to map the value range HMI values --> AVB values
        //soundProperty.value = set.mainSoundProperty.value;
        soundProperty.value = m_pSoundHandler->getMappedBassValue(set.mainSoundProperty.value, error);
        if(error==E_OK)
        {
            // this should now be done when we get the reply from Routing, then we know it is done
            //error = mControlReceiveInterface->changeMainSinkSoundPropertyDB(set.mainSoundProperty, set.sinkID);
            //give it also to the Routing?
            ETG_TRACE_USR4(("Bass mainSoundProperty send to Routing as soundProperty %d (0x%x) with value %d, handle %d.%d",
                    soundProperty.type,soundProperty.type,soundProperty.value,set.handle.handleType,set.handle.handle));
            (void)mControlReceiveInterface->setSinkSoundProperty(set.handle, set.sinkID, soundProperty);


            tU16 key = static_cast<tU16>((set.handle.handleType)<<10);
            key = static_cast<tU16>(key + set.handle.handle);
            m_MapHandle[key] = set;

            //dump the Map
            ETG_TRACE_USR4(("Dump m_MapHandle"));
            for(auto it=m_MapHandle.begin();it!=m_MapHandle.end();it++)
            {
            	ETG_TRACE_USR4(("m_MapHandle[%d] = %d.%d",it->first,it->second.handle.handleType,it->second.handle.handle));
            }
        }
        else
        {
            ETG_TRACE_ERR(("Bass mainSoundProperty failed. Could not map value %d",set.mainSoundProperty.value));
        }
        return;
    }
    else
        CAmControlSenderBase::vHandleSinkSoundProperty_Bass(set);
}
/************************************************************************
 *FUNCTION     : vHandleSinkSoundProperty_Treble
 *DESCRIPTION  : Handler for Treble and Treble relative sound property
 *PARAMETER    : rMainSinkSoundPropertySet &set
 *RETURN VALUE : void
 *HISTORY      :
 *27.01.2014   Rev 1.0     RBEI/ECG4 - Ranjit Susal  Initial Revision
 ************************************************************************/
void AMMultiDomainControlBase::vHandleSinkSoundProperty_Treble(rMainSinkSoundPropertySet &set)
{
    ETG_TRACE_USR4(("AMMultiDomainControlBase::vHandleSinkSoundProperty_Treble Entered for sink %d",set.sinkID));
    vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface);

    am_Sink_s sinkData;
    mControlReceiveInterface->getSinkInfoDB(set.sinkID, sinkData);
    ETG_TRACE_USR4(("AMMultiDomainControlBase::vHandleSinkSoundProperty_Treble sinkData.domainID %d",sinkData.domainID));

    //now for all domains
    if(sinkData.domainID != clGeniviAudioCtrlAdapter::GetDomainID())
    {
        vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_pSoundHandler);
        //we give this to SoundHandler, but we map before to an internal sink in SoundHandler
        rMainSinkSoundPropertySet setCopy = set;
        MapSinkNameSoundSinkIterator_t it = m_MapSinkNameSoundSink.find(sinkData.name);
        if(it != m_MapSinkNameSoundSink.end())
        {
            std::string text = sinkData.name + " to " + std::to_string(it->second);
            ETG_TRACE_USR4(("Mapping sink %s",text.c_str()));
            setCopy.sinkID = it->second;
        }
        else
        {
            ETG_TRACE_ERR(("SinkID %d not found, no action",set.sinkID));
            return;
        }


        //ToDo: Check if Mic1,2,3 active: if active call MixBass
        unsigned char mic=0;
        if(bIsAnyMicActive(mic))
        {
            set.mainSoundProperty.type = MSP_AVB_MIX_TREBLE;
            setCopy.mainSoundProperty.type = MSP_AVB_MIX_TREBLE;
            (void)m_pSoundHandler->bSetMixTreble(setCopy,mic);
        }
        else
        {
            (void)m_pSoundHandler->bSetTreble(setCopy);
        }

        if(mic==MIC_1) //hack property type back if it is MIC_1 (Mic1 does not use MSP_AVB_MIX_TREBLE, but it uses own TREBLE)
        {
            set.mainSoundProperty.type = MSP_SOUND_TREBLE_RELATIVE;
            setCopy.mainSoundProperty.type = MSP_SOUND_TREBLE_RELATIVE;
        }

        //write back value
        set.mainSoundProperty.value = setCopy.mainSoundProperty.value;

        ETG_TRACE_USR4(("Treble mainSoundProperty is now %d",set.mainSoundProperty.value));
        // From set.mainSoundProperty which is of type am_MainSoundProperty_s we have to create a variable of type
        am_SoundProperty_s soundProperty; //maybe we need to change some values? Then we could use this to give back am_SoundProperty_s used by ControlReceive
        soundProperty.type = (am_CustomSoundPropertyType_t)set.mainSoundProperty.type;


        am_Error_e error = E_UNKNOWN;
        //ToDo: we might have to map the value range HMI values --> AVB values
        //soundProperty.value = set.mainSoundProperty.value;
        soundProperty.value = m_pSoundHandler->getMappedTrebleValue(set.mainSoundProperty.value, error);

        if(error==E_OK)
        {
            // this should now be done when we get the reply from Routing, then we know it is done
            //error = mControlReceiveInterface->changeMainSinkSoundPropertyDB(set.mainSoundProperty, set.sinkID);
            //give it also to the Routing?
            ETG_TRACE_USR4(("Treble mainSoundProperty send to Routing as soundProperty %d (0x%x) with value %d, handle %d.%d",
                    soundProperty.type,soundProperty.type,soundProperty.value,set.handle.handleType,set.handle.handle));
            (void)mControlReceiveInterface->setSinkSoundProperty(set.handle, set.sinkID, soundProperty);

            //keep handle for reply
            tU16 key = static_cast<tU16>((set.handle.handleType)<<10);
            key = static_cast<tU16>(key + set.handle.handle);
            m_MapHandle[key] = set;

            //dump the Map
            ETG_TRACE_USR4(("Dump m_MapHandle"));
            for(auto it=m_MapHandle.begin();it!=m_MapHandle.end();it++)
            {
            	ETG_TRACE_USR4(("m_MapHandle[%d] = %d.%d",it->first,it->second.handle.handleType,it->second.handle.handle));
            }
        }
        else
        {
            ETG_TRACE_ERR(("Treble mainSoundProperty could not map value %d",set.mainSoundProperty.value));
        }

        return;
    }
    else
        CAmControlSenderBase::vHandleSinkSoundProperty_Treble(set);
}

/************************************************************************
 *FUNCTION     : vHandleSinkSoundProperty_Balance
 *DESCRIPTION  : Handler for Balance and Balance relative sound property
 *PARAMETER    : rMainSinkSoundPropertySet &set
 * RETURNVALUE  : void
 * HISTORY      :
 *27.01.2014   Rev 1.0     RBEI/ECG4 - Ranjit Susal  Initial Revision
 ************************************************************************/
void AMMultiDomainControlBase::vHandleSinkSoundProperty_Balance(rMainSinkSoundPropertySet &set)
{
    ETG_TRACE_USR4(("AMMultiDomainControlBase::vHandleSinkSoundProperty_Balance Entered for sink %d",set.sinkID));
    vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface);

    am_Sink_s sinkData;
    mControlReceiveInterface->getSinkInfoDB(set.sinkID, sinkData);
    ETG_TRACE_USR4(("AMMultiDomainControlBase::vHandleSinkSoundProperty_Balance sinkData.domainID %d",sinkData.domainID));

    //now for all domains
    if(sinkData.domainID != clGeniviAudioCtrlAdapter::GetDomainID())
    {
        vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_pSoundHandler);
        //we give this to SoundHandler, but we map before to a sink in SoundHandler
        rMainSinkSoundPropertySet setCopy = set;
        MapSinkNameSoundSinkIterator_t it = m_MapSinkNameSoundSink.find(sinkData.name);
        if(it != m_MapSinkNameSoundSink.end())
        {
            std::string text = sinkData.name + " to " + std::to_string(it->second);
            ETG_TRACE_USR4(("Mapping sink %s",text.c_str()));
            setCopy.sinkID = it->second;
        }
        else
        {
            ETG_TRACE_ERR(("SinkID %d not found, no action",set.sinkID));
            return;
        }
        //we give this to SoundHandler
        (void)m_pSoundHandler->bSetBalance(setCopy);

        //write back value
        set.mainSoundProperty.value = setCopy.mainSoundProperty.value;;

        ETG_TRACE_USR4(("Balance mainSoundProperty is now %d",set.mainSoundProperty.value));
        // From set.mainSoundProperty which is of type am_MainSoundProperty_s we have to create a variable of type
        am_SoundProperty_s soundProperty; //maybe we need to change some values? Then we could use this to give back am_SoundProperty_s used by ControlReceive
        soundProperty.type = set.mainSoundProperty.type;

        am_Error_e error = E_UNKNOWN;
        //ToDo: we might have to map the value range HMI values --> AVB values
        //soundProperty.value = set.mainSoundProperty.value;
        soundProperty.value = m_pSoundHandler->getMappedBalanceValue(set.mainSoundProperty.value, error);
        if(error!=E_OK)
        {
            // this should now be done when we get the reply from Routing, then we know it is done
            //error = mControlReceiveInterface->changeMainSinkSoundPropertyDB(set.mainSoundProperty, set.sinkID);
            //give it also to the Routing?
            ETG_TRACE_USR4(("Balance mainSoundProperty send to Routing as soundProperty %d (0x%x) with value %d, handle %d.%d",
                    soundProperty.type,soundProperty.type,soundProperty.value,set.handle.handleType,set.handle.handle));
            error = mControlReceiveInterface->setSinkSoundProperty(set.handle, set.sinkID, soundProperty);
            tU16 key = static_cast<tU16>((set.handle.handleType)<<10);
            key = static_cast<tU16>(key + set.handle.handle);
            m_MapHandle[key] = set;

            //dump the Map
            ETG_TRACE_USR4(("Dump m_MapHandle"));
            for(auto it=m_MapHandle.begin();it!=m_MapHandle.end();it++)
            {
            	ETG_TRACE_USR4(("m_MapHandle[%d] = %d.%d",it->first,it->second.handle.handleType,it->second.handle.handle));
            }
        }
        else
        {
            ETG_TRACE_ERR(("Balance mainSoundProperty could not map value %d",set.mainSoundProperty.value));
        }
        return;
    }
    else
        CAmControlSenderBase::vHandleSinkSoundProperty_Balance(set);
}

/************************************************************************
 *FUNCTION     : vHandleSinkSoundProperty_Fader
 *DESCRIPTION  : Handler for Fader and Fader relative sound property
 *PARAMETER    : rMainSinkSoundPropertySet &set
 *RETURN VALUE : void
 *HISTORY      :
 *27.01.2014   Rev 1.0     RBEI/ECG4 - Ranjit Susal  Initial Revision
 ************************************************************************/
void AMMultiDomainControlBase::vHandleSinkSoundProperty_Fader(rMainSinkSoundPropertySet &set)
{
    ETG_TRACE_USR4(("AMMultiDomainControlBase::vHandleSinkSoundProperty_Fader Entered for sink %d",set.sinkID));
    vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface);

    am_Sink_s sinkData;
    mControlReceiveInterface->getSinkInfoDB(set.sinkID, sinkData);
    ETG_TRACE_USR4(("AMMultiDomainControlBase::vHandleSinkSoundProperty_Fader sinkData.domainID %d",sinkData.domainID));

    //now for all domains
    if(sinkData.domainID != clGeniviAudioCtrlAdapter::GetDomainID())
    {
        vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_pSoundHandler);
        //we give this to SoundHandler, but we map before to an internal sink in SoundHandler
        rMainSinkSoundPropertySet setCopy = set;
        MapSinkNameSoundSinkIterator_t it = m_MapSinkNameSoundSink.find(sinkData.name);
        if(it != m_MapSinkNameSoundSink.end())
        {
          std::string text = sinkData.name + " to " + std::to_string(it->second);
          ETG_TRACE_USR4(("Mapping sink %s",text.c_str()));
          setCopy.sinkID = it->second;
        }
        else
        {
            ETG_TRACE_ERR(("SinkID %d not found, no action",set.sinkID));
            return;
        }
        //we give this to SoundHandler
        (void)m_pSoundHandler->bSetFader(setCopy);
        //write back value
        set.mainSoundProperty.value = setCopy.mainSoundProperty.value;

        ETG_TRACE_USR4(("Fader mainSoundProperty is now %d",set.mainSoundProperty.value));

        //We are not sending this to routing plugin, it is not supported there. So we reply immediately to HMI
        if(set.mainSoundProperty.type == MSP_SOUND_FADER_RELATIVE)
        {
            ETG_TRACE_USR4(("CAmControlSenderBase::MSP_SOUND_FADER_RELATIVE map to MSP_SOUND_FADER to HMI"));
            set.mainSoundProperty.type = MSP_SOUND_FADER;
        }

        if(E_OK != mControlReceiveInterface->changeMainSinkSoundPropertyDB(set.mainSoundProperty, set.sinkID))
        {
            ETG_TRACE_USR4(("Error, changeMainSinkSoundPropertyDB for fader failed"));
        }

        return;
    }
    else
        CAmControlSenderBase::vHandleSinkSoundProperty_Fader(set);
}
/************************************************************************
 * FUNCTION        : hookUserVolumeChange
 * DESCRIPTION     : to set user volume
 * PARAMETER       : const am_sinkID_t, const am_mainVolume_t
 * RETURNVALUE     : am_Error_e
 * HISTORY         :
 *     04.09.12 Vyankatesh VD  Initial Revision.
 ************************************************************************/
am_Error_e AMMultiDomainControlBase::hookUserVolumeChange(const am_sinkID_t SinkID, const am_mainVolume_t newVolume)
{
    ETG_TRACE_USR4(("AMMultiDomainControlBase::hookUserVolumeChange called with sinkID= %d, newVolume= %d", SinkID, newVolume));

    assert(SinkID==0);
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mClientHandlerFCAudioMgr,E_UNKNOWN);
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveShadowInterface,E_UNKNOWN);
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface,E_UNKNOWN);

    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(pVolumeManager,E_UNKNOWN);
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_pSoundHandler,E_UNKNOWN);

    if(E_OK != clGeniviAudioCtrlAdapter::isValidSinkID(SinkID))
    {
        ETG_TRACE_ERR(("AMMultiDomainControlBase::hookUserVolumeChange,Invalid SinkID =%d", SinkID));
        return E_NOT_POSSIBLE;
    }

    uint8_t u8VolumeType = midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_ABS;

    if(pVolumeManager && m_pSoundHandler)
    {
        //for other sinks
        am_Sink_s sinkData;
        mControlReceiveInterface->getSinkInfoDB(SinkID, sinkData);
        ETG_TRACE_ERR(("AMMultiDomainControlBase::hookUserVolumeChange sinkData.domainID %d, g_domainId %d",sinkData.domainID, g_domainId));

        VolumeSinkData s;
        s.sink_Id = SinkID;
        s.sink_name = sinkData.name;
        ETG_TRACE_USR4(("AMMultiDomainControlBase::hookUserVolumeStep_Other_Projects s.sinkID: %d  s.sinkName: %s ",s.sink_Id, s.sink_name.c_str()));
        ID_SinkDetail SinkDetailPOMessage(s);
        iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(InternalCommunicationAdapter::getInstance(),E_UNKNOWN);
        iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(InternalCommunicationAdapter::getInstance()->POMessages, E_UNKNOWN);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&SinkDetailPOMessage);

        if(sinkData.domainID != clGeniviAudioCtrlAdapter::GetDomainID())
        {
            ETG_TRACE_USR4(("AMMultiDomainControlBase::hookUserVolumeChange for other domain %d, own domain %d",sinkData.domainID, clGeniviAudioCtrlAdapter::GetDomainID()));

            ETG_TRACE_USR4(("AMMultiDomainControlBase::hookUserVolumeChange getVolumeManager p= %p, sinkID %d",pVolumeManager,SinkID));

            if(sinkData.mainVolume == newVolume)
                return E_NO_CHANGE;

            pVolumeManager->vSetVolume(u8VolumeType,static_cast<tU8>(SinkID), static_cast<tU16>(abs(newVolume)));

            unsigned short newSinkVolume=0;
            //bool bRet=false;
            //bRet = pVolumeManager->bGetVolumeStatus(3074,&newSinkVolume);
            (void)pVolumeManager->bGetVolumeStatus(3074,&newSinkVolume);

            return E_OK;
        }
        else
        {
            ETG_TRACE_ERR(("AMMultiDomainControlBase::hookUserVolumeChange should not be called for sinks in own domain"));
        }
    }
    ETG_TRACE_USR4(("AMMultiDomainControlBase::hookUserVolumeChange ADR Domain, Calling vSetVolume()"));
    mClientHandlerFCAudioMgr->vSetVolume(u8VolumeType,static_cast<tU8>(SinkID),static_cast<tU8>(newVolume));

    ETG_TRACE_USR4(("AMMultiDomainControlBase::After calling setSinkVolume(),successfully returned"));
    return E_OK;
}

//virtual
am_Error_e AMMultiDomainControlBase::hookUserVolumeStep_Other_Projects(const am_sinkID_t SinkID, const int16_t i16Step)
{
    ETG_TRACE_USR4(("AMMultiDomainControlBase:: Entered in hookUserVolumeStep_Other_Projects"));

    //const clSourceClass* pSrcClass_MuteZeroVol = clFactory_AudioSourceClass::GetSourceClass("MUTE_ZERO_VOLUME");
    const clSourceClass* pSrcClass_MuteEntertain = clFactory_AudioSourceClass::GetSourceClass("MUTE_ENTERTAIN");


    //iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mClientHandlerFCAudioMgr,E_UNKNOWN);
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface,E_UNKNOWN);
    //daw2hi filter out sinks from other domain
    am_Sink_s sinkData;
    mControlReceiveInterface->getSinkInfoDB(SinkID, sinkData);

    if(clGeniviAudioCtrlAdapter::bIsCurrentActiveAudiosource(SourceID(pSrcClass_MuteEntertain->SourceClassID,0),SinkID))
    {
        if(SinkID > 100)
        {
            //Do not remove MUTE_ENTERTAIN if Mix source is active
            bool bMixIsOn = false;
            clAudioSource* pSrc = clGeniviAudioCtrlAdapter::pcoGetTopOfStackMixsource(SinkID);
            if(pSrc != NULL)
            {
                std::string mic2("AVB_Mic2");
                std::string mic3("AVB_Mic3");
                std::string stateOn("on");
                if( (mic2 == pSrc->pacGetName()) || (mic3 == pSrc->pacGetName()) )
                {
                    if(stateOn == pSrc->pacGetState(SinkID))
                    {
                        ETG_TRACE_USR4(("AMMultiDomainControlBase::hookUserVolumeStep_Other_Projects AVB_Mic: %s is on",pSrc->pacGetName()));
                        bMixIsOn = true;
                    }
                }
            }
            if(bMixIsOn == false)
            {
                //Unmute the system for AVB Sink ...
                ETG_TRACE_USR4(("AMMultiDomainControlBase::hookUserVolumeStep_Other_Projects, Volume change requested when MUTE_ENTERTAINMENT is active and no Mix active, Treating as DEMUTE request "));
                //request for sourceOFF for logical source "MUTE_ENTERTAIN"
                clGeniviAudioCtrlAdapter::RequestSourceOff(SourceID(pSrcClass_MuteEntertain->SourceClassID,0),SinkID);
                //ToDo: Check if we have Amp_AnalgIn below Mute, then we have to check for MUTE_ENTERTAIN on ADR3
                AudioStack::AudioSource::clAudioSource* pSrc = clGeniviAudioCtrlAdapter::pcoGetTopOfStack(SinkID);
                if(pSrc)
                {
                    ETG_TRACE_USR4(("bMixIsOn is false: Source on sinkID %d is now %s",SinkID,pSrc->pacGetName()));

                    std::string topSrcName(pSrc->pacGetName());
                    if(topSrcName == "AMP_AnalogIn_A")
                    {
                        AudioStack::AudioSource::clAudioSource* pSrcSink17 = clGeniviAudioCtrlAdapter::pcoGetTopOfStack(midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_LINE_OUT);
                        if(pSrcSink17)
                        {
                            ETG_TRACE_USR4(("bMixIsOn is false: Source on sinkID 17 is now %s",pSrcSink17->pacGetName()));
                        }

                        clGeniviAudioCtrlAdapter::RequestSourceOff(SourceID(pSrcClass_MuteEntertain->SourceClassID,0),midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_LINE_OUT);
                    }
                }
            }
        }
        else
        {
            //Unmute the system...
            ETG_TRACE_USR4(("AMMultiDomainControlBase::hookUserVolumeStep_Other_Projects, Volume change requested when MUTE_ENTERTAINMENT is active, Treating as DEMUTE request "));
            //request for sourceOFF for logical source "MUTE_ENTERTAIN"
            clGeniviAudioCtrlAdapter::RequestSourceOff(SourceID(pSrcClass_MuteEntertain->SourceClassID,0),SinkID);
            uint8_t u8Volume_Type = midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_INC;
            if(i16Step < 0)
            {
                u8Volume_Type = midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_DEC;
            }
#if defined(VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_INF4CV ) || defined(VARIANT_S_FTR_ENABLE_UNITTEST)
            //we inform with sink name
            pVolumeManager->vSetVolume(u8Volume_Type,sinkData.name,static_cast<tU16>(abs(i16Step)));
#else
            //ToDo: is this O.K. for DBus ARL ?
            pVolumeManager->vSetVolume(u8Volume_Type,(tU8)SinkID,static_cast<tU16>(abs(i16Step)));
#endif
            return E_OK;
        }
    }

    ETG_TRACE_ERR(("AMMultiDomainControlBase::hookUserVolumeStep_Other_Projects sinkData.domainID %d, g_domainId %d",sinkData.domainID, g_domainId));

    if(sinkData.domainID != clGeniviAudioCtrlAdapter::GetDomainID() && pVolumeManager && m_pSoundHandler)
    {
        VolumeSinkData s;
        s.sink_Id = SinkID;
        s.sink_name = sinkData.name;
        ETG_TRACE_USR4(("AMMultiDomainControlBase::hookUserVolumeStep_Other_Projects s.sinkID: %d  s.sinkName: %s ",s.sink_Id, s.sink_name.c_str()));
        ID_SinkDetail SinkDetailPOMessage(s);
        iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(InternalCommunicationAdapter::getInstance(), E_UNKNOWN);
        iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(InternalCommunicationAdapter::getInstance()->POMessages, E_UNKNOWN);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&SinkDetailPOMessage);
        uint8_t u8VolumeType = midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_INC;
        if(i16Step < 0)
        {
            u8VolumeType = midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_DEC;
        }
        ETG_TRACE_ERR(("AMMultiDomainControlBase::hookUserVolumeChange getVolumeManager p= %p, sinkID %d",pVolumeManager,SinkID));
#if defined(VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_INF4CV ) || defined(VARIANT_S_FTR_ENABLE_UNITTEST)
        //we inform with sink name
        pVolumeManager->vSetVolume(u8VolumeType,sinkData.name,static_cast<tU16>(abs(i16Step)));
#else
        //ToDo: is this O.K. for DBus ARL ?
        pVolumeManager->vSetVolume(u8VolumeType,(tU8)SinkID,static_cast<tU16>(abs(i16Step)));
#endif
        return E_OK;
    }
    else
    {
        ETG_TRACE_ERR(("AMMultiDomainControlBase::hookUserVolumeChange should not be called for SinkID %d, passing it to CAmControlSenderBase",SinkID));
        return CAmControlSenderBase::hookUserVolumeStep_Other_Projects(SinkID,i16Step);
    }
}
/************************************************************************
 * FUNCTION        : hookSystemRegisterSink
 * DESCRIPTION     : to register sink
 * PARAMETER       : const am_Sink_s , am_sinkID_t
 * RETURNVALUE     :  am_Error_e
 * HISTORY         : GENIVI
 ************************************************************************/
am_Error_e AMMultiDomainControlBase::hookSystemRegisterSink(const am_Sink_s & sinkData, am_sinkID_t & sinkID)
{
    ETG_TRACE_USR4(("AMMultiDomainControlBase::hookSystemRegisterSink called with sinkID= %d,(sinkData.sinkID %d, name %s)", sinkID,sinkData.sinkID, sinkData.name.c_str()));
    am_Error_e error = E_UNKNOWN;
    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface,E_UNKNOWN);

    am_Sink_s sinkDataCopy = sinkData;

    if(sinkID == SINK_ID_ADR3 && sinkDataCopy.domainID == DBUSARL_DOMAIN_ID)
    {
        error = clGeniviAudioCtrlAdapter::initializeSinks(sinkDataCopy.domainID);
        if(false == clGeniviAudioCtrlAdapter::bAudioDeviceAvailability())
        {
            clGeniviAudioCtrlAdapter::vSetAmplifierMute(MUTE_NO_AUD_DEV_ON);
        }
        clAudioSMEngine::vRestoreEntertainmentsource();
        return E_OK;

    }

    //set this to 0 as it might come with wrong value
    sinkDataCopy.volume = 0;
    sinkDataCopy.mainVolume = 0;

    if(((sinkData.name == "AMP_A") || (sinkData.name == "AMP_B")) && m_pSoundHandler!= NULL)
    {
        MapSinkNameSoundSinkIterator_t it = m_MapSinkNameSoundSink.find(sinkData.name);
        if(it != m_MapSinkNameSoundSink.end())
        {
            rMainSinkSoundPropertySet property;
            property.sinkID = it->second;
            bool bIsMsp = false;
            for(unsigned int i=0;i<sinkData.listSoundProperties.size();i++)
            {
                bIsMsp = false;
                property.mainSoundProperty.type = (am_CustomMainSoundPropertyType_t)sinkData.listSoundProperties[i].type;
                //take value that we get but for the known MSP we will overwrite with DP values below
                property.mainSoundProperty.value = sinkData.listSoundProperties[i].value;
                switch(property.mainSoundProperty.type)
                {
                // ToDo: should we put this switch case into SoundHandler and offer a general bGet for all properties?
                case MSP_SOUND_BASS:
                case MSP_SOUND_BASS_RELATIVE:
                {
                    ETG_TRACE_USR4(("MSP_SOUND_BASS (OK) or MSP_SOUND_BASS_RELATIVE (NOK)"));
                    //get values from SoundHandler, but for MSP_SOUND_BASS
                    property.mainSoundProperty.type = MSP_SOUND_BASS;
                    m_pSoundHandler->bGetBass(property);

                    bIsMsp = true;
                    break;
                }
                case MSP_SOUND_BALANCE:
                case MSP_SOUND_BALANCE_RELATIVE:
                {
                    ETG_TRACE_USR4(("MSP_SOUND_BALANCE (OK) or MSP_SOUND_BALANCE_RELATIVE (NOK)"));
                    //get values from SoundHandler, but for MSP_SOUND_BALANCE
                    property.mainSoundProperty.type = MSP_SOUND_BALANCE;
                    m_pSoundHandler->bGetBalance(property);

                    bIsMsp = true;
                    break;
                }
                case MSP_SOUND_TREBLE:
                case MSP_SOUND_TREBLE_RELATIVE:
                {
                    ETG_TRACE_USR4(("MSP_SOUND_TREBLE (OK) or MSP_SOUND_TREBLE_RELATIVE (NOK)"));
                    //get values from SoundHandler, but for MSP_SOUND_TREBLE
                    property.mainSoundProperty.type = MSP_SOUND_TREBLE;
                    m_pSoundHandler->bGetTreble(property);
                    ETG_TRACE_USR4(("MSP_SOUND_TREBLE or MSP_SOUND_TREBLE_RELATIVE got value %d",property.mainSoundProperty.value));

                    bIsMsp = true;
                    break;
                }
                case MSP_SOUND_FADER:
                case MSP_SOUND_FADER_RELATIVE:
                {
                    ETG_TRACE_USR4(("MSP_SOUND_FADER (OK) or MSP_SOUND_FADER_RELATIVE (NOK)"));
                    //get values from SoundHandler, but for MSP_SOUND_FADER
                    property.mainSoundProperty.type = MSP_SOUND_FADER;
                    m_pSoundHandler->bGetFader(property);
                    ETG_TRACE_USR4(("MSP_SOUND_FADER or MSP_SOUND_FADER_RELATIVE got value %d",property.mainSoundProperty.value));

                    bIsMsp = true;
                    break;
                }

                case MSP_AVB_MIX_BASS:
                {
                    ETG_TRACE_USR4(("MSP_AVB_MIX_BASS"));
                    property.mainSoundProperty.type = MSP_AVB_MIX_BASS;
                    bIsMsp = true;
                    break;
                }
                case MSP_AVB_MIX_TREBLE:
                {
                    ETG_TRACE_USR4(("MSP_AVB_MIX_TREBLE"));
                    property.mainSoundProperty.type = MSP_AVB_MIX_TREBLE;
                    bIsMsp = true;
                    break;
                }
                case MSP_AVB_MIC1_GAIN:
                {
                    ETG_TRACE_USR4(("MSP_AVB_MIC1_GAIN not handled here, not shown to HMI"));
                    break;
                }
                default:
                    break; //no action
                } //switch()

                //push to list but only if it is a known MSP
                if(bIsMsp==true)
                {
                    sinkDataCopy.listMainSoundProperties.push_back(property.mainSoundProperty);
                    ETG_TRACE_USR4(("Pushed MSP to list, size is %d",sinkDataCopy.listMainSoundProperties.size()));
                }
                else
                {
                    ETG_TRACE_USR4(("This is not a MSP: type %d, value %d (0x%x)",
                            property.mainSoundProperty.type,property.mainSoundProperty.value,
                            property.mainSoundProperty.value));
                }
            }// for()

            //user mute
            property.mainSoundProperty.type = MSP_USER_MUTE_STATUS;
            property.mainSoundProperty.value = MSP_USER_MUTE_STATUS_OFF;
            sinkDataCopy.listMainSoundProperties.push_back(property.mainSoundProperty);

            //min on Volume
            //property.mainSoundProperty.type = MSP_ENTSTARTUPMINVOLUME_RELATIVE;
            property.mainSoundProperty.type = MSP_ENTSTARTUPMINVOLUME;
            //get value form VolumeManager
            property.mainSoundProperty.value = pVolumeManager->getOnVolumeMinLimit(sinkData.name);
            sinkDataCopy.listMainSoundProperties.push_back(property.mainSoundProperty);
            ETG_TRACE_USR4(("Pushed MSP_ENTSTARTUPMINVOLUME (%d) with value %d to list",
                    property.mainSoundProperty.type,property.mainSoundProperty.value));

            //max on Volume
            //property.mainSoundProperty.type = MSP_ENTSTARTUPVOLUME_RELATIVE;
            property.mainSoundProperty.type = MSP_ENTSTARTUPVOLUME;
            property.mainSoundProperty.value = pVolumeManager->getOnVolumeMaxLimit(sinkData.name);
            sinkDataCopy.listMainSoundProperties.push_back(property.mainSoundProperty);
            ETG_TRACE_USR4(("Pushed MSP_ENTSTARTUPVOLUME (%d) with value %d to list",
                    property.mainSoundProperty.type,property.mainSoundProperty.value));


            //add also MSP_PRIVATE_MODE_MIX_VOLUME
            property.mainSoundProperty.type = MSP_PRIVATE_MODE_MIX_VOLUME;
            property.mainSoundProperty.value = clGeniviAudioCtrlAdapter::u16GetPrivateModeMixVolumeBySinkName(sinkData.name);
            sinkDataCopy.listMainSoundProperties.push_back(property.mainSoundProperty);
            ETG_TRACE_USR4(("Pushed MSP_PRIVATE_MODE_MIX_VOLUME (%d) with value %d to list",
                    property.mainSoundProperty.type,property.mainSoundProperty.value));

            //###################### FADER is not within the sink registration, add it here #########
            //ETG_TRACE_USR4(("MSP_SOUND_FADER (OK) or MSP_SOUND_FADER_RELATIVE (NOK)"));
            property.mainSoundProperty.type = MSP_SOUND_FADER;
            m_pSoundHandler->bGetFader(property);
            ETG_TRACE_USR4(("MSP_SOUND_FADER or MSP_SOUND_FADER_RELATIVE got value %d",property.mainSoundProperty.value));
            sinkDataCopy.listMainSoundProperties.push_back(property.mainSoundProperty);
            ETG_TRACE_USR4(("Pushed MSP_SOUND_FADER (%d) with value %d to list",
                    property.mainSoundProperty.type,property.mainSoundProperty.value));
            //########################################################


            //final register the Sink
            sinkID = clGeniviAudioCtrlAdapter::AddSink(sinkDataCopy);
            //      property.mainSoundProperty.value = clGeniviAudioCtrlAdapter::u16GetPrivateModeMixVolume(sinkID);
            //      property.mainSoundProperty.type = MSP_PRIVATE_MODE_MIX_VOLUME;
            //      if(mControlReceiveInterface)
            //       mControlReceiveInterface->changeMainSinkSoundPropertyDB(property.mainSoundProperty, sinkID);
            (void)sendVolumeZeroToAvbAmp(sinkID);
            updateExtAmpSinkSoundProperties(sinkDataCopy, sinkID);
        }
        else
        {
            ETG_TRACE_ERR(("Unknown Sink %s",sinkData.name.c_str()));
            //can not find sink Name in Map for SoundHandler
            //ToDo can we do anything here?
        }
    }
    else
    {
        //daw2hi 9.3.2017 order changed: first AddSink then enterSinkDB. ToDo: should that be done here or in AddSink?
        sinkID = clGeniviAudioCtrlAdapter::AddSink(sinkDataCopy);
    }

    //just a hack. Need to change above return to am_Error
    if(sinkID != 0)
    {
        // clAudioSMEngine::vRestoreEntertainmentsource();
        error = E_OK;
    }
    //hack end

    //this application does not do anything with it -> but some product might want to take influence here
    //error = mControlReceiveInterface->enterSinkDB(sinkData, sinkID);  //dw2hi 05.04.2017 no more needed, already done
    am_Sink_s sinkInfo;
    am_Error_e sinkErr   = mControlReceiveInterface->getSinkInfoDB(sinkID,sinkInfo);

    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mClientHandlerDiagLog,E_UNKNOWN);

    if(((sinkData.name == "AMP_A") || (sinkData.name == "AMP_B")) && (sinkErr == E_OK))
    {
        ETG_TRACE_ERR(("Sending DTC with EN_FAILED"));
        mClientHandlerDiagLog->bSetDTC(EN_FAILED);

    }

    return error;
}

am_Error_e AMMultiDomainControlBase::sendVolumeZeroToAvbAmp(const am_sinkID_t sinkID)
{
    if(m_bVolumeZeroToAmpAtStartUpMap.find(sinkID) == m_bVolumeZeroToAmpAtStartUpMap.end())
    {
        m_VolumeHandle.handleType = H_UNKNOWN;
        m_VolumeHandle.handle =0;

        ETG_TRACE_USR4(("sendVolumeZeroToAvbAmp sending once %d for sinkID %d",MUTE_VOLUME,sinkID));

        //we use flow control for this
        //am_Error_e err = mControlReceiveInterface->setSinkVolume(m_VolumeHandle, sinkID, (am_volume_t)MUTE_VOLUME, RAMP_GENIVI_NO_PLOP, 20);
        m_FlowControl.setSinkVolume(m_VolumeHandle, sinkID, (am_volume_t)MUTE_VOLUME, RAMP_GENIVI_NO_PLOP, 20);
        am_Error_e err = E_OK; //dummy

        ETG_TRACE_USR4(("with handle %d.%d result %d",m_VolumeHandle.handleType,m_VolumeHandle.handle,err));
        //disable further volumes
        m_bVolumeZeroToAmpAtStartUpMap[sinkID] = true;
    }

    return E_OK;
}


void AMMultiDomainControlBase::updateExtAmpSinkSoundProperties(am_Sink_s sinkData, am_sinkID_t sinkID)
{
    am_Error_e error=E_OK;
    am_MainSoundProperty_s mainSoundProperty;

    vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_pSoundHandler);
    vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface);

    ETG_TRACE_USR3(("updateExtAmpSinkSoundProperties sinkData.sinkID %d, sinkID %d",sinkData.sinkID, sinkID));
    if( (sinkData.name == "AMP_A") || (sinkData.name == "AMP_B") )
    {
        //only for AMP Sinks
        am_SoundProperty_s soundProperty;

        //Loop through sound properties
        for(unsigned int i=0;i<sinkData.listMainSoundProperties.size();i++)
        {
            mainSoundProperty=sinkData.listMainSoundProperties[i];
            m_startUpHandle.handleType = H_UNKNOWN;
            m_startUpHandle.handle = 0;
            soundProperty.type = mainSoundProperty.type;
            switch(mainSoundProperty.type)
            {
            case MSP_SOUND_BASS:
            {
            	soundProperty.type = MSP_SOUND_BASS_RELATIVE;
                soundProperty.value = m_pSoundHandler->getMappedBassValue(mainSoundProperty.value,error);
                ETG_TRACE_USR4(("Send Bass with type %d, mapped value %d for sink %d, error %d",
                        soundProperty.type,soundProperty.value,sinkID,error));

                // we use flow control for this
                //(void)mControlReceiveInterface->setSinkSoundProperty(m_startUpHandle, sinkID, soundProperty);
                m_FlowControl.setSinkSoundProperty(m_startUpHandle, sinkID, soundProperty);

                ETG_TRACE_USR4(("Bass StartUp handle (type %d/%d)",m_startUpHandle.handleType,m_startUpHandle.handle));
                break;
            }
            case MSP_SOUND_TREBLE:
            {
            	soundProperty.type = MSP_SOUND_TREBLE_RELATIVE;
                soundProperty.value = m_pSoundHandler->getMappedTrebleValue(mainSoundProperty.value,error);
                ETG_TRACE_USR4(("Send Treble with type %d, mapped value %d for sink %d, error %d",
                        soundProperty.type,soundProperty.value,sinkID,error));

                // we use flow control for this
                //(void)mControlReceiveInterface->setSinkSoundProperty(m_startUpHandle, sinkID, soundProperty);
                m_FlowControl.setSinkSoundProperty(m_startUpHandle, sinkID, soundProperty);

                ETG_TRACE_USR4(("Treble StartUp handle (type %d/%d)",m_startUpHandle.handleType,m_startUpHandle.handle));
                break;
            }
            case MSP_SOUND_BALANCE:
            {
            	soundProperty.type = MSP_SOUND_BALANCE_RELATIVE;
                soundProperty.value = m_pSoundHandler->getMappedBalanceValue(mainSoundProperty.value,error);

                ETG_TRACE_USR4(("Disabled Balance with type %d, mapped value %d for sink %d, error %d",
                        soundProperty.type,soundProperty.value,sinkID,error));

                //ETG_TRACE_USR4(("Send Balance with type %d, mapped value %d for sink %d, error %d",
                //        soundProperty.type,soundProperty.value,sinkID,error));
                //(void)mControlReceiveInterface->setSinkSoundProperty(m_startUpHandle, sinkID, soundProperty);
                //ETG_TRACE_USR4(("Balance StartUp handle (type %d/%d)",m_startUpHandle.handleType,m_startUpHandle.handle));
                break;
            }
            case MSP_AVB_MIX_TREBLE:
            {
                ETG_TRACE_USR4(("MSP_AVB_MIX_TREBLE not handled here"));
                break;
            }
            case MSP_AVB_MIX_BASS:
            {
                ETG_TRACE_USR4(("MSP_AVB_MIX_BASS not handled here"));
                break;
            }
            case MSP_AVB_MIC1_GAIN:
            {
                 ETG_TRACE_USR4(("MSP_AVB_MIC1_GAIN not handled here"));
                 break;
            }
            default:
            {
                ETG_TRACE_USR4(("SoundProperty type %d no supported",mainSoundProperty.type));
            }

            }

        }
    }

}
/************************************************************************
 * FUNCTION     : hookUserSetSinkMuteState
 * DESCRIPTION  : to set sink in MUTE/DEMUTE state
 * PARAMETER    : am_sinkID_t, am_MuteState_e
 * RETURNVALUE  : am_Error_e
 * HISTORY      :
 *     04.09.12 Vyankatesh VD  Initial Revision.
 ************************************************************************/
am_Error_e AMMultiDomainControlBase::hookUserSetSinkMuteState(const am_sinkID_t sinkID, const am_MuteState_e muteState)
{
  ETG_TRACE_USR4(("AMMultiDomainControlBase::hookUserSetSinkMuteState called with sinkID= %d, muteState= %d", sinkID, muteState));

  iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface,E_UNKNOWN);

  am_Error_e error = E_UNKNOWN;

  if(E_OK != clGeniviAudioCtrlAdapter::isValidSinkID(sinkID))
    return E_NOT_POSSIBLE;

  am_Sink_s sinkData;
  mControlReceiveInterface->getSinkInfoDB(sinkID, sinkData);
  if((sinkData.domainID != clGeniviAudioCtrlAdapter::GetDomainID()) && pVolumeManager)
  {
      error = setDynamicSinkMuteState(sinkID, muteState); // to handle mute and unmute for dynamic sink
      (void)muteOnOtherSinkNeeded(sinkID,muteState);
      return error;
  }
  else
    return CAmControlSenderBase::hookUserSetSinkMuteState(sinkID, muteState);
}

am_Error_e AMMultiDomainControlBase::muteOnOtherSinkNeeded(const am_sinkID_t sinkID, const am_MuteState_e muteState)
{
    ETG_TRACE_USR4(("AMMultiDomainControlBase::muteOnOtherSinkNeeded sinkID %d",sinkID));
    //check for gateway entertainment connections on this sink
    std::vector<am_MainConnection_s> listMainConnections;
    am_Error_e err = mControlReceiveInterface->getListMainConnections(listMainConnections);
    for(unsigned int i=0;i<listMainConnections.size();i++)
    {
        if(listMainConnections[i].sinkID == sinkID)
        {
            ETG_TRACE_USR4(("AMMultiDomainControlBase::muteOnOtherSinkNeeded sinkID match"));
            am_Sink_s sinkData;
            am_Source_s sourceData;
           //get data of source and sink
            mControlReceiveInterface->getSinkInfoDB(listMainConnections[i].sinkID,sinkData);
            mControlReceiveInterface->getSourceInfoDB(listMainConnections[i].sourceID,sourceData);
            if(sinkData.domainID != sourceData.domainID)
            {
                ETG_TRACE_USR4(("AMMultiDomainControlBase::muteOnOtherSinkNeeded domains are different"));
                if(false == bIsSourceAsMainConOnOtherSink(listMainConnections[i].sourceID,listMainConnections[i].sinkID,listMainConnections))
                {
                    ETG_TRACE_USR4(("AMMultiDomainControlBase::muteOnOtherSinkNeeded not on other sinks"));
                    //source not active on other sink, we can apply mute if it is entertain
                    clGeniviAudioCtrlAdapter::muteSinkIfEntertain(sourceData, (am_sinkID_t)17,muteState); // we can fetch the sinkID
                }
            }
        }
    }

    return E_OK;
}

bool AMMultiDomainControlBase::bIsSourceAsMainConOnOtherSink(const am_sourceID_t sourceID, const am_sinkID_t sinkID,std::vector<am_MainConnection_s>& listMainConnections)
{
    ETG_TRACE_USR4(("AMMultiDomainControlBase:bIsSourceAsMainConOnOtherSink sourceID %d, sinkID %d",sourceID,sinkID));
    for(unsigned int i=0;i<listMainConnections.size();i++)
    {
        if( (listMainConnections[i].sourceID == sourceID) && (listMainConnections[i].sinkID != sinkID) )
        {
            ETG_TRACE_USR4(("AMMultiDomainControlBase:bIsSourceAsMainConOnOtherSink true"));
            return true;
        }
    }
    ETG_TRACE_USR4(("AMMultiDomainControlBase:bIsSourceAsMainConOnOtherSink false"));
    return false;
}

/*****************************************************************************************************
 *FUNCTION      : setDynamicSinkMuteState
 * DESCRIPTION  : to set sink in MUTE/DEMUTE state for Dynamic sinks
 * PARAMETER    : am_sinkID_t, am_MuteState_e
 * RETURNVALUE  : am_Error_e

 *****************************************************************************************************/

am_Error_e AMMultiDomainControlBase::setDynamicSinkMuteState(const am_sinkID_t& sinkID, const am_MuteState_e& muteState)
{
    ETG_TRACE_USR4(("AMMultiDomainControlBase::setDynamicSinkMuteState called with sinkID= %d, muteState= %d", sinkID, muteState));

    iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface,E_UNKNOWN);
    am_Error_e error = E_UNKNOWN;

    if(E_OK != clGeniviAudioCtrlAdapter::isValidSinkID(sinkID))
      return E_NOT_POSSIBLE;

    const clSourceClass* pSrcClass = clFactory_AudioSourceClass::GetSourceClass("MUTE_ENTERTAIN");
    if(pSrcClass == NULL)
      return E_UNKNOWN;

    const clSourceClass* pSrcClass_MuteZeroVol = clFactory_AudioSourceClass::GetSourceClass("MUTE_ZERO_VOLUME");
    if(pSrcClass_MuteZeroVol == NULL)
      return E_UNKNOWN;

    bool bMuteZeroActive = false;
    bool bMuteEntActive = false;

    am_Sink_s sinkData;
    mControlReceiveInterface->getSinkInfoDB(sinkID, sinkData);
    if((sinkData.domainID != clGeniviAudioCtrlAdapter::GetDomainID()) && (sinkData.name == "AMP_A" || sinkData.name == "AMP_B" ))
    {

        switch(muteState)
        {
        case MS_MUTED:
            {
#if 0 // For Inf4CV: check if this order is needed. If yes, then below #if 1 is not needed
                //do first the mute before SourceOn for MUTE_ENTERTAIN
                clGeniviAudioCtrlAdapter::getVolumeManager()->vSetMute(sinkData.name);
#endif
                bMuteZeroActive = clGeniviAudioCtrlAdapter::bIsCurrentActiveAudiosource(SourceID(pSrcClass_MuteZeroVol->SourceClassID,0),sinkID);
                error = clGeniviAudioCtrlAdapter::RequestSourceOn(SourceID(pSrcClass->getClassID(),0),sinkID);
#if 1 // Inf4CV: check the order with above #if 0
                if(E_OK == error && pVolumeManager!= NULL)
                    pVolumeManager->vSetMute(sinkData.name);
#endif
                if((NULL != clGeniviAudioCtrlAdapter::pcoGetTopOfStackMixsource(sinkID))
                  || (false == clGeniviAudioCtrlAdapter::bIsCurrentActiveAudiosource(SourceID(pSrcClass->SourceClassID,0),sinkID)))
                {
                  ETG_TRACE_USR4(("AMMultiDomainControlBase::hookUserSetSinkMuteState,Either Mute_Ent not active OR mix source active, \
                          No need to call changeSinkMuteStateDB !!"));
                  return error;
                }
                break;
            }
        case MS_UNMUTED:
            {
                bMuteEntActive = clGeniviAudioCtrlAdapter::bIsCurrentActiveAudiosource(SourceID(pSrcClass->SourceClassID,0), sinkID);
#if 1 //Inf4CV: check if needed. Was outcommented in Inf4CV
                if( pVolumeManager!= NULL)
                    pVolumeManager->vClearMute(sinkData.name);
#endif
                error = clGeniviAudioCtrlAdapter::RequestSourceOff(SourceID(pSrcClass->getClassID(),0), sinkID);
                bMuteZeroActive = clGeniviAudioCtrlAdapter::bIsCurrentActiveAudiosource(SourceID(pSrcClass_MuteZeroVol->SourceClassID,0), sinkID);
                break;
            }
        default:
          return E_OUT_OF_RANGE;
        }

        if((E_OK == error) && ((true == bMuteZeroActive) || (false == bMuteEntActive)))
                mControlReceiveInterface->changeSinkMuteStateDB(muteState, sinkID);
        else if(!bMuteZeroActive && muteState ==  MS_UNMUTED)
                mControlReceiveInterface->changeSinkMuteStateDB(muteState, sinkID);
        else
            ETG_TRACE_USR1((" No Update sent"));

        return error;
    }
    else
    {
        ETG_TRACE_USR4(("AMMultiDomainControlBase::setDynamicSinkMuteState not hanlde for this sink %s",sinkData.name.c_str()));
        return E_OUT_OF_RANGE;
    }

}
bool AMMultiDomainControlBase::sinkIDinList(am_sinkID_t sinkID, std::vector<am_sinkID_t>& sinkListTuner)
{
	for(unsigned int i=0;i<sinkListTuner.size();i++)
	{
		if(sinkID == sinkListTuner[i]) return true;
	}
	return false;

}
// Find the active Tuner and give the list of connected sinks and fetch source data for the Tuner Source
void AMMultiDomainControlBase::getActiveTunerAndSinkList(am_Source_s& sourceData, std::vector<am_sinkID_t>& sinkListTuner)
{

	vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface);

    std::vector<am_MainConnection_s> listMainConnections;
    std::vector<am_Source_s> listSources;

    am_sourceID_t sourceID_Tuner=0;
    am_Error_e err=E_OK;

    // just for trace info. data is not needed and can be removed later
    std::vector<am_sourceID_t> sourceIDListTuner; // all SourceID of type Tuner
    // get the list of all sources
    err = mControlReceiveInterface->getListSources(listSources);
    // loop through the list and find the source ID for all Tuner: FM, AM, DAB, ....
    for(unsigned int id=0;id<listSources.size();id++)
    {
        if(AudioStack::clGeniviAudioCtrlAdapter::isTunerSourceClassByClassID(listSources[id].sourceClassID) == true)
        {
            //collect all sourceID of type Tuner in a vector
            sourceIDListTuner.push_back(listSources[id].sourceID);
            ETG_TRACE_USR4(("This source is a Tuner with sourceID %d",listSources[id].sourceID));
        }
    }
    // end of trace info

    // get all current  main connections
    err = mControlReceiveInterface->getListMainConnections(listMainConnections);
    // go through the list and find out if any of the Tuner sourceID is involved. Only one can be active at a time,
    // but on more than one sink. So we need to loop through the whole list to get all involved sinks
    for(unsigned int id=0;id<listMainConnections.size();id++)
    {
        // this is for any Tuner (only one can be active at a time)
        // check if this MainConnection sourceID is a Tuner sourceID
        if(AudioStack::clGeniviAudioCtrlAdapter::isTunerSourceClassBySourceID(listMainConnections[id].sourceID)==true)
		{
			//do not add same sink twice (we might have two tuner on same sink, usually sink 1, during source change)
        	if(!sinkIDinList(listMainConnections[id].sinkID,sinkListTuner))
			{
				sinkListTuner.push_back(listMainConnections[id].sinkID);
				if((sourceID_Tuner != 0) && (sourceID_Tuner != listMainConnections[id].sourceID))
				{
					// We should not find more than one active Tuner. Give Error Trace
					ETG_TRACE_ERR(("AMMultiDomainControlBase::getActiveTunerAndSinkList ERROR: more than one active Tuner found ???"));
					ETG_TRACE_ERR(("Active Tuner SourceID is %d and now additional Tuner SourceID %d found",sourceID_Tuner,listMainConnections[id].sourceID));
				}
			}
			sourceID_Tuner = listMainConnections[id].sourceID;
		}
	}
	// Do we have a Tuner active on one or more sinks?
	if(sinkListTuner.size() > 0)
	{
		ETG_TRACE_USR4(("AMMultiDomainControlBase::getActiveTunerAndSinkList found active TunerID %d on %d sinks",
			sourceID_Tuner,sinkListTuner.size()));
		// get the source Data for this Tuner source from Daemon
		err = mControlReceiveInterface->getSourceInfoDB(sourceID_Tuner,sourceData);
	}
	(void)err; //sometimes nice to see value of err in debug session
}

//Get the active MediaPlayer and the list of its connected sinks and fetch source data for the MediaPlayer Source
void AMMultiDomainControlBase::getActiveMediaPlayerAndSinkList(am_Source_s& sourceData, std::vector<am_sinkID_t>& sinkList)
{
	vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface);

	std::vector<am_MainConnection_s> listMainConnections;
	std::vector<am_Source_s> listSources;

	am_sourceID_t sourceID_MediaPlayer=0;
	std::vector<am_sinkID_t> sinkListMediaPlayer;

	am_Error_e err=E_OK;

	// get all current  main connections
	err = mControlReceiveInterface->getListMainConnections(listMainConnections);
	// go through the list and find out if any of the MediaPlayer# sourceID is involved. Only one can be active at a time.
	// But on more than one sink, so we need to loop through the whole list to get all involved sinks
	for(unsigned int id=0;id<listMainConnections.size();id++)
	{
		//this is for any MediaPlayer# (only one can be active at a time)

		// check if this MainConnection sourceID is a MediaPlayer sourceID
        if(AudioStack::clGeniviAudioCtrlAdapter::isMediaPlayerSourceClassBySourceID(listMainConnections[id].sourceID)==true)
		{
			//do not add same sink twice (we might have two Media sources on same sink, usually sink 1, during source change)
        	if(!sinkIDinList(listMainConnections[id].sinkID,sinkListMediaPlayer))
			{
        		sinkListMediaPlayer.push_back(listMainConnections[id].sinkID);
				if((sourceID_MediaPlayer != 0) && (sourceID_MediaPlayer != listMainConnections[id].sourceID))
				{
					// We should not find more than one active Media. Give Error Trace
					ETG_TRACE_ERR(("AMMultiDomainControlBase::getActiveMediaPlayerAndSinkList ERROR: more than one active Media/BT found ???"));
					ETG_TRACE_ERR(("Active Media SourceID is %d and now additional Media SourceID %d found",sourceID_MediaPlayer,listMainConnections[id].sourceID));
				}
			}
        	else
			{
        		ETG_TRACE_USR4(("#################### sinkIDinList gave true, no push_back ###################"));
			}
			sourceID_MediaPlayer = listMainConnections[id].sourceID;
		}
	}
	if(sinkListMediaPlayer.size() > 0)
	{
		sinkList = sinkListMediaPlayer;
		err = mControlReceiveInterface->getSourceInfoDB(sourceID_MediaPlayer,sourceData);
	}
	(void)err;
}

// This will give a list of MainConnectionID where the given conflicting sourceID and a corresponding sink list are involved
void AMMultiDomainControlBase::getMainConnectionConflictList(const am_sourceID_t sourceID, std::vector<am_sinkID_t> sinkList,
        std::vector<am_connectionID_t>& mainConIDList, std::vector<am_sinkID_t>& mainConIDSinkList)
{
	vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface);

    std::vector<am_MainConnection_s> listMainConnections;
    // get list of currenct active main connections
    mControlReceiveInterface->getListMainConnections(listMainConnections);
    // loop through the list
    for(unsigned int i=0; i<listMainConnections.size();i++)
    {
        // if source ID is matching
        if(listMainConnections[i].sourceID==sourceID)
        {
            // go through the given sink list
            for(unsigned int k=0;k<sinkList.size();k++)
            {
                if(listMainConnections[i].sinkID==sinkList[k])
                {
                    ETG_TRACE_USR4(("getMainConnectionConflictList() mainConIDList add MainConID %d, SinkID %d",
                            listMainConnections[i].mainConnectionID, listMainConnections[i].sinkID));
                    mainConIDList.push_back(listMainConnections[i].mainConnectionID);
                    mainConIDSinkList.push_back(listMainConnections[i].sinkID);
                }
            }
        }
    }
    ETG_TRACE_USR4(("getMainConnectionConflictList() we found %d IDs",listMainConnections.size()));
}

bool AMMultiDomainControlBase::bIsSubIdInOtherMainID(const am_connectionID_t connectionID, const am_mainConnectionID_t mainConnectionID, am_mainConnectionID_t& otherMainConnectionID)
{
	iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface,false);

    std::vector<am_MainConnection_s> listMainConnections;
    listMainConnections.clear();
    am_Error_e err = mControlReceiveInterface->getListMainConnections(listMainConnections);
    (void)err; // sometimes nice to see value of err in debug session
    // loop through all main
    for(unsigned int i = 0;i<listMainConnections.size();i++)
    {
        //loop through sub connection list of this main
        for(unsigned int k=0;k<listMainConnections[i].listConnectionID.size();k++)
        {
            //sub connection is here. Is main different
            if(    (listMainConnections[i].listConnectionID[k] == connectionID)
                && (listMainConnections[i].mainConnectionID != mainConnectionID) )
            {
                //fprintf(stderr,"we can not disconnect. Used also in mainID %d\n",listMainConnections[i].mainConnectionID);
                //.. yes
                otherMainConnectionID = listMainConnections[i].mainConnectionID;
                return true;
            }
        }
    }
    return false;
}

void AMMultiDomainControlBase::vHandleSinkSoundProperty_EntStartupVolume(rMainSinkSoundPropertySet &set)
{
	ETG_TRACE_USR4(("AMMultiDomainControlBase::vHandleSinkSoundProperty_EntStartupVolume  Entered"));

	vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface);

	am_Sink_s sinkData;
	mControlReceiveInterface->getSinkInfoDB(set.sinkID, sinkData);
	ETG_TRACE_USR4(("AMMultiDomainControlBase::vHandleSinkSoundProperty_EntMinimumStartupVolume sinkData.domainID %d for SinkID %d",sinkData.domainID,set.sinkID));
	ETG_TRACE_USR4(("AMMultiDomainControlBase::vHandleSinkSoundProperty_EntMinimumStartupVolume pointer values of VolumeManager: %p, and sound handler: %p",pVolumeManager,m_pSoundHandler));

	if(sinkData.domainID != clGeniviAudioCtrlAdapter::GetDomainID() && pVolumeManager && m_pSoundHandler)
	{
		VolumeSinkData s;
		s.sink_Id = set.sinkID;
		s.sink_name = sinkData.name;
		ETG_TRACE_USR4(("AMMultiDomainControlBase::vHandleSinkSoundProperty_EntStartupVolume s.sinkID: %d  s.sinkName: %s ",s.sink_Id, s.sink_name.c_str()));
		ID_SinkDetail SinkDetailPOMessage(s);
		vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(InternalCommunicationAdapter::getInstance());
		vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(InternalCommunicationAdapter::getInstance()->POMessages);
		InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&SinkDetailPOMessage);

		if (MSP_ENTSTARTUPVOLUME_RELATIVE == set.mainSoundProperty.type)
		{
			ETG_TRACE_USR4(("AMMultiDomainControlBase::vHandleSinkSoundProperty_EntStartupVolume called relative"));

			if(set.mainSoundProperty.value > 0)
			{
				ETG_TRACE_USR4(("vhandleVolume_OnVolume_Max Called for MSP_ENTSTARTUPVOLUME_RELATIVE with increment by %d", set.mainSoundProperty.value));
				pVolumeManager->vhandleVolume_OnVolume_Max((midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_INC),sinkData.name,int8_t(set.mainSoundProperty.value));
			}
			else
			{
				ETG_TRACE_USR4(("vhandleVolume_OnVolume_Max Called for MSP_ENTSTARTUPVOLUME_RELATIVE with decrement by %d", abs(set.mainSoundProperty.value)));
				pVolumeManager->vhandleVolume_OnVolume_Max((midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_DEC),sinkData.name,static_cast<tU8>(abs(set.mainSoundProperty.value)));
			}
		}
		//read back what we have
		tU16 maxVolume = pVolumeManager->getOnVolumeMaxLimit(sinkData.name);
		ETG_TRACE_USR4(("maxVolume is now %d",maxVolume));
		set.mainSoundProperty.value = maxVolume;

		//reply to daemon with MSP_ENTSTARTUPVOLUME
		set.mainSoundProperty.type = MSP_ENTSTARTUPVOLUME;
		am_Error_e error = mControlReceiveInterface->changeMainSinkSoundPropertyDB(set.mainSoundProperty, set.sinkID);

	}
	else
	{
		CAmControlSenderBase::vHandleSinkSoundProperty_EntStartupVolume(set);
	}
}

void AMMultiDomainControlBase::vHandleSinkSoundProperty_EntMinimumStartupVolume(rMainSinkSoundPropertySet &set)
{
	ETG_TRACE_USR4(("AMMultiDomainControlBase::vHandleSinkSoundProperty_EntMinimumStartupVolume Entered"));

	vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(mControlReceiveInterface);

	am_Sink_s sinkData;
	mControlReceiveInterface->getSinkInfoDB(set.sinkID, sinkData);
	ETG_TRACE_USR4(("AMMultiDomainControlBase::vHandleSinkSoundProperty_EntMinimumStartupVolume sinkData.domainID %d for SinkID %d",sinkData.domainID,set.sinkID));
	ETG_TRACE_USR4(("AMMultiDomainControlBase::vHandleSinkSoundProperty_EntMinimumStartupVolume pointer values of VolumeManager: %p, and sound handler: %p",pVolumeManager,m_pSoundHandler));

	if(sinkData.domainID != clGeniviAudioCtrlAdapter::GetDomainID() && pVolumeManager && m_pSoundHandler)
	{
		VolumeSinkData s;
		s.sink_Id = set.sinkID;
		s.sink_name = sinkData.name;
		ETG_TRACE_USR4(("AMMultiDomainControlBase::vHandleSinkSoundProperty_EntMinimumStartupVolume s.sinkID: %d  s.sinkName: %s ",s.sink_Id, s.sink_name.c_str()));
		ID_SinkDetail SinkDetailPOMessage(s);
		vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(InternalCommunicationAdapter::getInstance());
		vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(InternalCommunicationAdapter::getInstance()->POMessages);
		InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&SinkDetailPOMessage);

		if (MSP_ENTSTARTUPMINVOLUME_RELATIVE == set.mainSoundProperty.type)
		{
			ETG_TRACE_USR4(("AMMultiDomainControlBase::vHandleSinkSoundProperty_EntMinimumStartupVolume called relative"));

			if(set.mainSoundProperty.value > 0)
			{
				ETG_TRACE_USR4(("vhandleVolume_OnVolume_Min Called for MSP_ENTSTARTUPMINVOLUME_RELATIVE with increment by %d", set.mainSoundProperty.value));
				pVolumeManager->vhandleVolume_OnVolume_Min((midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_INC),sinkData.name,int8_t(set.mainSoundProperty.value));
			}
			else
			{
				ETG_TRACE_USR4(("vhandleVolume_OnVolume_Min Called for MSP_ENTSTARTUPMINVOLUME_RELATIVE with decrement by %d", abs(set.mainSoundProperty.value)));
				pVolumeManager->vhandleVolume_OnVolume_Min((midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_DEC),sinkData.name,static_cast<tU8>(abs(set.mainSoundProperty.value)));
			}
		}
		//read back what we have
		tU16 minVolume = pVolumeManager->getOnVolumeMinLimit(sinkData.name);
		ETG_TRACE_USR4(("minVolume is now %d",minVolume));
		set.mainSoundProperty.value = minVolume;

		//reply to daemon, with type MSP_ENTSTARTUPMINVOLUME
		set.mainSoundProperty.type = MSP_ENTSTARTUPMINVOLUME;
		am_Error_e error = mControlReceiveInterface->changeMainSinkSoundPropertyDB(set.mainSoundProperty, set.sinkID);

	}
	else
	{
		CAmControlSenderBase::vHandleSinkSoundProperty_EntMinimumStartupVolume(set);
	}
}

// ToDo: maybe this function can be improved. Currently it should onyl provide the missing functionality
// We will provide a get function in SoundHandler to call it with the different properties.
void AMMultiDomainControlBase::vLoadSoundSettings()
{
    ETG_TRACE_USR4(("AMMultiDomainControlBase::vLoadSoundSettings"));
    if(m_pSoundHandler == NULL) return;

    am_Error_e error = E_OK;
    m_pSoundHandler->vOnLoadSettings();


    auto it = m_MapSinkNameSoundSink.find("AMP_A");
    if(it == m_MapSinkNameSoundSink.end())
    {
        ETG_TRACE_ERR(("Error, could not find sinkID for AMP_A"));
        return;
    }

    tU16 sinkIndex = it->second; // used to access DP array
    //am_sinkID_t sinkID = getSinkID(std::string("AMP_A"));
    am_sinkID_t sinkID = getSinkID("AMP_A");

    std::string text = "AMP_A with sinkID " + std::to_string(sinkID) + " to index " + std::to_string(it->second);
    ETG_TRACE_USR4(("Mapping sink %s",text.c_str()));

    //Need to send to AMP
    rMainSinkSoundPropertySet mainPropertySet;
    am_SoundProperty_s propertySet;
    mainPropertySet.handle.handleType = H_SETSINKSOUNDPROPERTY; //should not change
    // ##################### BASS ######################
    mainPropertySet.sinkID = sinkIndex; //need index for SoundHandler access
    propertySet.type = MSP_SOUND_BASS; //maybe we have to do a mapping here later
    //am_CustomMainSoundPropertyType_t (HMI)  <-> am_SoundProperty_s (ROUTING)
    mainPropertySet.mainSoundProperty.type = MSP_SOUND_BASS;
    mainPropertySet.handle.handle =0;
    m_pSoundHandler->bGetBass(mainPropertySet);
    //do the mapping
    tS16 resultBass = m_pSoundHandler->getMappedBassValue(mainPropertySet.mainSoundProperty.value, error);
    if(error==E_OK)
    {
        //propertySet.value = mainPropertySet.mainSoundProperty.value;
        propertySet.value = (int16_t)resultBass;
        //virtual am_Error_e setSinkSoundProperty(am_Handle_s& handle, const am_sinkID_t sinkID, const am_SoundProperty_s& soundProperty) =0;

        // #### hack the type
        propertySet.type = MSP_SOUND_BASS_RELATIVE;

        (void)mControlReceiveInterface->setSinkSoundProperty(mainPropertySet.handle, sinkID, propertySet);
        // #### hack it back
        propertySet.type = MSP_SOUND_BASS;

        ETG_TRACE_USR4(("Bass mainSoundProperty sent to Routing as soundProperty %d (0x%x) with value %d",
                propertySet.type,propertySet.type,propertySet.value));

        //Need to keep the handle and the value for the reply which comes only with handle
        tU16 key = static_cast<tU16>((mainPropertySet.handle.handleType)<<10);
        key = static_cast<tU16>(key + mainPropertySet.handle.handle);
        mainPropertySet.sinkID = sinkID; //set back
        m_MapHandle[key] = mainPropertySet;

        //dump the Map
        ETG_TRACE_USR4(("Dump m_MapHandle"));
        for(auto it=m_MapHandle.begin();it!=m_MapHandle.end();it++)
        {
        	ETG_TRACE_USR4(("m_MapHandle[%d] = %d.%d",it->first,it->second.handle.handleType,it->second.handle.handle));
        }

    }

    // ##################### BALANCE ######################
    mainPropertySet.sinkID = sinkIndex; //need index for SoundHandler access
    propertySet.type = MSP_SOUND_BALANCE; //maybe we have to do a mapping here later
    //am_CustomMainSoundPropertyType_t (HMI)  <-> am_SoundProperty_s (ROUTING)
    mainPropertySet.mainSoundProperty.type = MSP_SOUND_BALANCE;
    mainPropertySet.handle.handle =0;
    m_pSoundHandler->bGetBalance(mainPropertySet);
    //do the mapping
    tS16 resultBalance = m_pSoundHandler->getMappedBalanceValue(mainPropertySet.mainSoundProperty.value, error);
    if(error==E_OK)
    {
        //propertySet.value = mainPropertySet.mainSoundProperty.value;
        propertySet.value = (int16_t)resultBalance;

        // #### hack the type
        propertySet.type = MSP_SOUND_BALANCE_RELATIVE;

        (void)mControlReceiveInterface->setSinkSoundProperty(mainPropertySet.handle, sinkID, propertySet);
        // #### hack it back
        propertySet.type = MSP_SOUND_BALANCE;

        ETG_TRACE_USR4(("Balance mainSoundProperty sent to Routing as soundProperty %d (0x%x) with value %d",
                propertySet.type,propertySet.type,propertySet.value));

        //Need to keep the handle and the value for the reply which comes only with handle
        tU16 key = static_cast<tU16>((mainPropertySet.handle.handleType)<<10);
        key = static_cast<tU16>(key + mainPropertySet.handle.handle);
        mainPropertySet.sinkID = sinkID; //set back
        m_MapHandle[key] = mainPropertySet;

        //dump the Map
        ETG_TRACE_USR4(("Dump m_MapHandle"));
        for(auto it=m_MapHandle.begin();it!=m_MapHandle.end();it++)
        {
        	ETG_TRACE_USR4(("m_MapHandle[%d] = %d.%d",it->first,it->second.handle.handleType,it->second.handle.handle));
        }
    }

    // ##################### TREBLE ######################
    mainPropertySet.sinkID = sinkIndex; //need index for SoundHandler access
    propertySet.type = MSP_SOUND_TREBLE; //maybe we have to do a mapping here later
    //am_CustomMainSoundPropertyType_t (HMI)  <-> am_SoundProperty_s (ROUTING)
    mainPropertySet.mainSoundProperty.type = MSP_SOUND_TREBLE;
    mainPropertySet.handle.handle =0;
    m_pSoundHandler->bGetTreble(mainPropertySet);
    //do the mapping
    tS16 resultTreble = m_pSoundHandler->getMappedTrebleValue(mainPropertySet.mainSoundProperty.value, error);
    if(error==E_OK)
    {
        //propertySet.value = mainPropertySet.mainSoundProperty.value;
        propertySet.value = (int16_t)resultTreble;

        // #### hack the type
        propertySet.type = MSP_SOUND_TREBLE_RELATIVE;

        //ETG_TRACE_USR4(("Treble mainSoundProperty send to Routing as soundProperty %d (0x%x) with value %d",soundProperty.type,soundProperty.type,soundProperty.value));
        ETG_TRACE_USR4(("Treble mainSoundProperty send to Routing as soundProperty %d (0x%x) with value %d",
                propertySet.type,propertySet.type,propertySet.value));
        (void)mControlReceiveInterface->setSinkSoundProperty(mainPropertySet.handle, sinkID, propertySet);
        // #### hack it back
        propertySet.type = MSP_SOUND_TREBLE;

        //Need to keep the handle and the value for the reply which comes only with handle
        tU16 key = static_cast<tU16>((mainPropertySet.handle.handleType)<<10);
        key = static_cast<tU16>(key + mainPropertySet.handle.handle);
        mainPropertySet.sinkID = sinkID; //set back
        m_MapHandle[key] = mainPropertySet;

        //dump the Map
        ETG_TRACE_USR4(("Dump m_MapHandle"));
        for(auto it=m_MapHandle.begin();it!=m_MapHandle.end();it++)
        {
        	ETG_TRACE_USR4(("m_MapHandle[%d] = %d.%d",it->first,it->second.handle.handleType,it->second.handle.handle));
        }
    }

    // ##################### FADER ######################
    mainPropertySet.sinkID = sinkIndex; //need index for SoundHandler access
    propertySet.type = MSP_SOUND_FADER; //maybe we have to do a mapping here later
    //am_CustomMainSoundPropertyType_t (HMI)  <-> am_SoundProperty_s (ROUTING)
    mainPropertySet.mainSoundProperty.type = MSP_SOUND_FADER;
    mainPropertySet.handle.handle =0;
    m_pSoundHandler->bGetFader(mainPropertySet);
    //do the mapping
    tS16 resultFader = m_pSoundHandler->getMappedFaderValue(mainPropertySet.mainSoundProperty.value, error);
    if(error==E_OK)
    {
        //propertySet.value = mainPropertySet.mainSoundProperty.value;
        propertySet.value = (int16_t)resultFader;
        // #### hack the type
        propertySet.type = MSP_SOUND_FADER_RELATIVE;

        ETG_TRACE_USR4(("Fader mainSoundProperty send to Routing as soundProperty %d (0x%x) with value %d",
                propertySet.type,propertySet.type,propertySet.value));
        (void)mControlReceiveInterface->setSinkSoundProperty(mainPropertySet.handle, sinkID, propertySet);
        // #### hack the type
        propertySet.type = MSP_SOUND_FADER;

        //Need to keep the handle and the value for the reply which comes only with handle
        tU16 key = static_cast<tU16>((mainPropertySet.handle.handleType)<<10);
        key = static_cast<tU16>(key + mainPropertySet.handle.handle);
        mainPropertySet.sinkID = sinkID; //set back
        m_MapHandle[key] = mainPropertySet;

        //dump the Map
        ETG_TRACE_USR4(("Dump m_MapHandle"));
        for(auto it=m_MapHandle.begin();it!=m_MapHandle.end();it++)
        {
        	ETG_TRACE_USR4(("m_MapHandle[%d] = %d.%d",it->first,it->second.handle.handleType,it->second.handle.handle));
        }
    }
    //any property missing?
    // Add here

    // Cabin mode mix volume
    am_MainSoundProperty_s mainSoundProperty;
    mainSoundProperty.type = MSP_PRIVATE_MODE_MIX_VOLUME;
    mainSoundProperty.value = clGeniviAudioCtrlAdapter::u16GetPrivateModeMixVolume(sinkID);

    (void)mControlReceiveInterface->changeMainSinkSoundPropertyDB(mainSoundProperty,sinkID);

    // Min. on Volume
    // Max. on Volume
    if(pVolumeManager)
    {
        std::string sinkName("AMP_A");
        mainSoundProperty.type =MSP_ENTSTARTUPMINVOLUME;
        mainSoundProperty.value = pVolumeManager->getOnVolumeMinLimit(sinkName);
        ETG_TRACE_USR4(("MSP_ENTSTARTUPMINVOLUME value %d",mainSoundProperty.value));
        (void)mControlReceiveInterface->changeMainSinkSoundPropertyDB(mainSoundProperty,sinkID);

        mainSoundProperty.type =MSP_ENTSTARTUPVOLUME;
        mainSoundProperty.value = pVolumeManager->getOnVolumeMaxLimit(sinkName);
        ETG_TRACE_USR4(("MSP_ENTSTARTUPVOLUME value %d",mainSoundProperty.value));
        (void)mControlReceiveInterface->changeMainSinkSoundPropertyDB(mainSoundProperty,sinkID);

        if(0 != getSinkID("AMP_A"))
        {
        	tU8 ampVol = pVolumeManager->getEntVolumeForSink("AMP_A");
        	pVolumeManager->vSetVolume(midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_ABS,"AMP_A",ampVol);
            ETG_TRACE_USR4(("After Reset to Factory: AMP_A vol %d",ampVol));

        }
        if(0 != getSinkID("AMP_B"))
        {
        	tU8 ampVol = pVolumeManager->getEntVolumeForSink("AMP_B");
        	pVolumeManager->vSetVolume(midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_ABS,"AMP_B",ampVol);
        	ETG_TRACE_USR4(("After Reset to Factory: AMP_B vol %d",ampVol));
        }
    }
}

