/************************************************************************
 *FILE:           amcontrol_clienthandler_DiagLog.h
 *SW-COMPONENT:   AmControllerPlugin
 *DESCRIPTION:    ClientHandler for Diaglog
 *AUTHOR:         Swati A N(RBEI/ECO4)
 *COPYRIGHT:      RBEI
 *HISTORY:
*08.10.2015      Rev 1.0   Swati A N(RBEI/ECO4)  Initial Revision
 ************************************************************************/

#ifndef INCLUDE_AMCONTROL_CLIENT_DIAGLOG_H_
#define INCLUDE_AMCONTROL_CLIENT_DIAGLOG_H_

class CAmControlSenderBase;

#include "CThreadSwitchingClient.h"

using namespace am;
#define EN_ERROR 2
#define EN_PASSED 0
#define EN_FAILED 1

class amcontrol_clienthandler_DiagLog : public CThreadSwitchingClient, public am::IAmShTimerCallBack
{

private:
  CAmControlSenderBase& m_ControlSenderBase;
  am::IAmControlReceiverShadow& m_receiverShadow;
  am::IAmControlReceive& m_ControlReceive;

  tU32 eResult;
  bool bAvailiable;

public:

  // callback functions for new messages invoked from Genivi Audiomanager thread
  virtual void vDispatchMessage (FIMessaging::FIMessage oMsg);
  virtual void vOnServiceAvailable();
  virtual void vOnServiceUnavailable();

public:
  //Default Constructor
  amcontrol_clienthandler_DiagLog(CAmControlSenderBase&,am::IAmControlReceiverShadow&, am::IAmControlReceive& controlReceive);
  virtual ~amcontrol_clienthandler_DiagLog();
  void vRegisterForProperties();

   // - - - - - - - - - - - - - - - - - - - -
   //
   //      ITarget implementation

   // disclose list of properties which should be UpReg'ed automatically
   virtual FIMessaging::ITarget::AutoRegisterList GetAutoRegisterList (void);


private:
  am::CAmSocketHandler*    m_pSocketHandler;
  am::sh_timerHandle_t m_handle;//Handle for the timer
  bool bStartTimer(uint32_t seconds);//Helper function to start the timer
  //Callback from mainloop, to inform that the timer has expired
  virtual void Call(const am::sh_timerHandle_t handle, void* userData);
public:
  bool bSetDTC(tU32);
};

#endif
