/*
 * clGeniviAudioCtrlAdapter.h
 *
 *  Created on: Jul 25, 2013
 *      Author: vo84hi
 */

#ifndef CLGENIVIAUDIOCTRLADAPTER_H_
#define CLGENIVIAUDIOCTRLADAPTER_H_

#define LOGFILE_CTRL "/var/opt/bosch/dynamic/ffs/Controller.log"

#include "InterfaceAudioStack.h"

#include "include/audiomanagertypes.h"
#include "IAmControlReceiverShadow.h"
#include "AudioStack/AudioSources/clGeniviAudioSource.h"
#include "AudioStack/AudioSources/clExtGeniviAudioSource.h"  //daw2hi 28.03.2017 added
#include "AudioStack/clAudioSMEngine.h"
//#include "amcontrol_clienthandler_fc_audioroutemanager.h"

//#include "Volume/VolumeManager.h"
//daw2hi 23.05.2018 new path
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "../../GAMVolumeManager/VolumeManager/Volume/VolumeManager.h"
#else
#include "../../utest/mock/include/Volume/VolumeManager.h"
#endif

#ifndef _DO_NOT_USE_BOSCH_OSAL_
#include <list>
#include <algorithm>

#else
#include <list>
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_SERVICEINFO
#include "midw_fi_if.h"

#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_TYPES
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_SERVICEINFO
#include "spm_fi_if.h"
#include <libxml/parser.h>
#include <libxml/tree.h>

//includes for loading XML ruleset
#include <string.h>

#define GAM_AUDIO_SINK_ID 1
#define GAM_AUDIO_DOMAIN_ID 1
#define UNKNOWN_SINK -1
#define MUTE_NO_AUD_DEV_OFF 0
#define MUTE_NO_AUD_DEV_ON  1
#define DBUSARL_DOMAIN_ID  2
#define DBUSARL_DOMAIN_NAME  "AudioDomain"

class amcontrol_clienthandler_fc_audiomanager;
class amcontrol_clienthandler_fc_audioroutemanager;
class CAmControlSenderBase;

namespace AudioStack
{


/**
 * GeniviAudioControlAdapter_mainConnectionItem
 */
struct stGACA_mainConnectionItem
{
   am::am_Handle_s* handle;
   am::am_MainConnection_s* mainConnection;
   am::am_connectionID_t connectionID;
};
enum sinkType
{
  staticType,
  dynamicType
};
struct sinkData{
  am_Sink_s s_sink;
/*  //sink name
  std::string name;
  //sinkid
  am_sinkID_t sinkID;
  //sink class
  am_sinkClass_t sinkClassID;
  //sink type
  registration_t eSinkRegistrationType;
  //last mode */
  sinkType sSinkType;
  bool bRestore;
  bool bLastMode;
};
struct mainConnectionEntry_s
{
  am::am_mainConnectionID_t mainID;
  std::vector<am::am_Connection_s> subConnectionList;
};

/**
 * Facade for Genivi Audiomanager  AudioStack
 */
class clGeniviAudioCtrlAdapter
{

private:
   clGeniviAudioCtrlAdapter();
   ~clGeniviAudioCtrlAdapter();

   static std::vector<mainConnectionEntry_s> m_mainConnectionEntries; // first variant
   static std::vector<am_Route_s>m_Routes; //second variant

   /**
    * source observer listing
    */
   static std::map<am_sourceID_t, AudioSource::SourceID > m_registeredSources;

   /*
    * registered sink list
    */
   static std::map<am_sinkID_t, am_Sink_s> m_registeredSinks;


   static amcontrol_clienthandler_fc_audioroutemanager* m_clientHandlerAudioRouteMgr;
   static amcontrol_clienthandler_fc_audiomanager* m_clientHandlerFcAudioMgr;


   //static VolumeManager::VolumeManager* m_VolumeManager;

   static am::am_domainID_t m_domainID;
   //attenuation map
   static std::map<tU8, tS16> m_AttenuationDBMAp;

//daw2hi changed to public to call it from CAmControlSenderBase
public:
   /**
    * pointer to Genivi AudioManager Control Interface
   */
   static am::IAmControlReceive * m_geniviControlIF;
   static am::am_Error_e addMainConnection(const am::am_sourceID_t sourceID,
                                                          const am::am_sinkID_t sinkID,
                                                          am::am_mainConnectionID_t& mainConnectionID);

   static VolumeManager::VolumeManager* getVolumeManager(void);
   static CAmControlSenderBase* m_ControlSenderBase;
   static bool registerGateway(const am_Gateway_s& gateway_s);
   static std::vector<mainConnectionEntry_s> getMainConnectionEntries();

   static void callHookUserDisconnectionRequest(am::am_mainConnectionID_t mainConnectionID);

   /**
    * sink mapping to index
    */
   static std::map<unsigned int, struct sinkData> m_sinkList;
   static unsigned int m_sinkIndex;


private:
   static am::am_Error_e removeMainConnectionDB(const am_mainConnectionID_t mainConnectionID);

   // no more used
   //static am::am_Error_e getConnectionOfSource(AudioSource::clGeniviAudioSource* sourceID, am_connectionID_t& connectionID);

   // not used ???
   //static tVoid initializeSourceClasses(am::am_domainID_t domainID);

   // not used ???
   //static tVoid initializeSources(am::am_domainID_t domainID);

   static am_sinkID_t getSinkIDByName(std::string sinkName);

   static tBool  m_bEnableAutoPlay;
   static tU16 m_u16PrivateMode;
   static tU16 m_u16PrivateModeMixVolume;
   //static void initializeSinkRSE(am_domainID_t domainID);

   // no more used
   //static void initializeSinkRSE(am_domainID_t domainID, am_sinkID_t sinkID, bool visible);

   //for debug
   static void printMainConnectionEntries();
   static void printInternalMainConnectionEntries();

   static am_Error_e removeSubConnectionFromPreviousMainConnectionInternalData(am_connectionID_t subConID);

public:

   typedef enum
   {
      CMD_SRC_OFF
      , CMD_SRC_ON
      , CMD_SRC_LIST
      , CMD_RESET
      , CMD_PRINT
      , CMD_SET_RUNLEVEL
      , CMD_GET_RUNLEVEL
      , CMD_KILL_SRC
      , CMD_SET_SRC_AVAILABLE
      , CMD_SET_SRC_NOT_AVAILABLE
      , CMD_SET_SRC_AVAILABLE_UNKOWN
      , CMD_LOADXML
      , CMD_PRINTXML
      , CMD_PRINTRULES
      , CMD_REMOTESTART
      , CMD_REMOTEEND
      , CMD_PRINT_BACKUP
    , CMD_LIST_MAINCON
    , CMD_LIST_ALLCON
    , CMD_DB_SOURCE_DATA
    , CMD_DB_SINK_DATA
     , CMD_LIST_ALL_DOMAINS
     , CMD_LIST_ALL_SINKS
     , CMD_LIST_ALL_SOURCES
   , CMD_INIT_DP_FM
   , CMD_SET_DP_FOR_SINK
   , CMD_CLEAR_DP_FOR_SINK
   , CMD_SET_DP_SUBID_FOR_SINK
   , CMD_LIST_INTERNAL_CONNECTIONS

   , CMD_REGISTER_SINK_ADR_LINE_OUT
   , CMD_UNREGISTER_SINK_ADR_LINE_OUT
   } enCommand;

   static unsigned int sinkSize;
   static tVoid Invalidate();

   /*
    * function to load correct volume context in fc_AudioManager->VolumeManager
    */
   static tVoid vLoadVolumeContext(clAudioSource* srcRemoved);
   static std::map<am_sinkID_t, am_Sink_s> getRegisteredSinks();

   static am::am_Error_e initializeSinks(am_domainID_t domainID);
   static void SetRunLevel(tU8 u8Level);
   static am::am_Error_e Init(CAmControlSenderBase* pSenderBase,am::IAmControlReceive* pGeniviCtrlIF,
   amcontrol_clienthandler_fc_audiomanager* clientHandlerFcAudioMgr,
   amcontrol_clienthandler_fc_audioroutemanager* clientHandlerAudioRouteMgr, bool bAMRoutingReady);
   static void inline Check_IAmControlReceive();

   template<class TClass>
   static void vSwitchThreadContext(TClass* instance, void (TClass::*function)())
   {
      IAmControlReceiverShadow* pReceiveShadow = IAmControlReceiverShadow::getInstance();
      if(pReceiveShadow != NULL)
      {
         pReceiveShadow->vSwitchThreadContext<TClass>(instance, function);
      }
      //m_geniviControlIF->vSwitchThreadContext<TClass>(instance, function);
   }

   static am_domainID_t GetDomainID() {return m_domainID;}

   static AudioSource::clAudioSource::enSourceActivity           Ext2Int_Activity          (midw_fi_tcl_e8_SrcActivity::tenType extActivity);
   static sourceClassID                             Ext2Int_SrcClass          (midw_fi_tcl_e8_AudSource::tenType enSrcExt);
   static AudioSource::clAudioSource::enSourceAvailability       Ext2Int_Availability      (midw_fi_tcl_e8_SrcAvailability::tenType extAvailability);
   static AudioSource::clAudioSource::enSourceAvailabilityReason Ext2Int_AvailabilityReason(midw_fi_tcl_e8_SrcAvailabilityReason::tenType extAvailabilityReason);
   static midw_fi_tcl_e8_AudSource::tenType                             GenSrc2ExtSrc          ( const am_sourceID_t & genSrc);

   static void Reset();
   /**
    * Adds a Source to a observer list. Incoming events that are
    * destined for source will be forwarded to all objects in the
    * observer list
    *
    * @param pSource source that is added to observer list
    */
   static am_sourceID_t AddSource(AudioSource::SourceID srcID, am_Source_s& gam_source_s);
   static void vLoadSettings(tU16 sinkId=1);

   static am_sourceID_t AddExternalSource(SourceID srcID, const am_Source_s& gam_source_s);
   /**
    * Removes a Source from the observer list.
    * @param pSource
    * @return TRUE if source is removed or not listed. FALSE if source could
    * not be removed.
    */
   static tVoid RemoveSource(am_sourceID_t gam_sourceID);

   /**
    * Notification that a Source has send notification about
    * its availability state
    * @param Source whom the given availability state belongs to
    * @param SubSource SubSourceID
    * @param Availability state of the source
    * @param Reason why this availability was announced
    */
   static tVoid SourceAvailabilityChange(midw_fi_tcl_e8_AudSource::tenType Source,
                                         tU16 SubSource,
                                         midw_fi_tcl_e8_SrcAvailability::tenType Availability,
                                         midw_fi_tcl_e8_SrcAvailabilityReason::tenType Reason);


   static tVoid SourceAvailabilityChange(const am_sourceID_t sourceID, const am_Availability_s & availability);

   // Sink handling

   static am_sinkID_t AddSink(const am_Sink_s& gam_sink_s);
   static tVoid AddSinkIndex(am_Sink_s,bool bRestore);
   static void AddDynSinkIndex(std::string,am_sinkID_t);
   static int GetSinkIndex(am_sinkID_t);
   static int SetLSM(am_sinkID_t sinkId,bool flag);

   static bool GetLSM(am_sinkID_t sinkId);
   static tVoid PrintSinkMap();
   static tVoid RemoveSink(am_sinkID_t gam_sinkID);
   static void AddAttenuationFilter(am_sinkID_t sinkID=1);
   static void RemoveAttenuationFilter(am_sinkID_t sinkID=1);
   static void CalculateAttenuationFilter(tU16 sinkID,int u16PMMixVoldB, bool Attenuate);

   static am_Error_e informVolumeManager(am_connectionID_t connectionID);
   //sinkAvailability??


   /**
    * Adds Genivi AudioManager Control Interface for interaction with
    * Genivi AudioManager. When Interface becomes invalid (e.g. due
    * to destruction) the Interface needs to be removed.
    * @note when assigning NULL the interface won't get called.
    *
    * @param pGeniviCtrlIF pointer to Genivi AudioManager Control Interface
    * @return void
    */
   static tVoid AddGeniviCtrlIF(am::IAmControlReceive* pGeniviCtrlIF);

   /**
    * Removes the Genivi AudioManager Control Interface.
    * @return void
    */
   static tVoid RemoveGeniviCtrlIF();

   /**
    * Add Interface to INC Gateway to AudioRouteManager
    */
   static tVoid AddAudioRouteMgrIF(amcontrol_clienthandler_fc_audioroutemanager* clientHandlerAudioRouteMgr);

   /**
    * Remove Interface to INC Gateway to AudioRouteManager
    */
   static tVoid RemoveAudioRouteMgrIF();

   /**
    * Add Interface to FcAudioManager
    */
   static tVoid AddFcAudioMgrIF(amcontrol_clienthandler_fc_audiomanager* clientHandlerFcAudioMgr);

   /**
    * Remove Interface to FcAudioManager
    */
   static tVoid RemoveFcAudioMgrIF();


   static tVoid AddDomainID(am_domainID_t domainID);


   /**
    *
    * @return Pointer to Genivi AudioManager Ctrl Interface
    */
   static am::IAmControlReceive* GetGeniviCtrlIF();

   /**
    * Request by Genivi AudioManager to disconnect MainConnection (SourceOFF)
    * @param connectionID
    * @return
    */
   static am::am_Error_e hookUserDisconnectionRequest(const am::am_mainConnectionID_t mainConnectionID);

   //added 16.06.2017
   static am::am_Error_e hookUserDisconnectionRequest(am_sourceID_t sourceID, am_sinkID_t sinkID, const am::am_mainConnectionID_t connectionID);

   static am::am_Error_e hookUserDisconnectionRequest(const am_mainConnectionID_t MainID, am_connectionID_t SubConID);
   /**
    * Request by Genivi AudioManager to establish MainConnection (SourceOn)
    * @param sourceID
    * @param sinkID
    * @param mainConnectionID
    * @return
    */
   static am::am_Error_e hookUserConnectionRequest(const am::am_sourceID_t sourceID, const am::am_sinkID_t sinkID, am::am_mainConnectionID_t& mainConnectionID);



   //this is just to track the route

   //2nd version
   static am::am_Error_e setUpRoute(am_Route_s route,am_mainConnectionID_t& mainConnectionID);
   //first version
   static am::am_Error_e setUpRoute(const am::am_sourceID_t sourceID, const am::am_sinkID_t sinkID, am::am_mainConnectionID_t& mainConnectionID);

   static am_Error_e getSubConID(const am_sourceID_t sourceID, const am_sinkID_t sinkID, am_connectionID_t& connectionID);
   static am_Error_e getMainConIDFromSubConID(const am_connectionID_t connectionID, am_mainConnectionID_t& mainConnectionID);
   static am_Error_e updateMainConnectionRoute(const am_mainConnectionID_t mainConnectionID, const am_connectionID_t connectionID);
   static am_Error_e updateMainConnectionRouteRemove(const am_mainConnectionID_t mainConnectionID, const am_connectionID_t connectionID);

   static bool updateMainConnectionEntry(const am_mainConnectionID_t mainConnectionID, const am_connectionID_t connectionID,
       const am_sourceID_t sourceID,
         const am_sinkID_t sinkID);

   static bool updateMainConnectionEntryRemove(const am_mainConnectionID_t mainConnectionID, const am_connectionID_t connectionID,
       const am_sourceID_t sourceID,
         const am_sinkID_t sinkID);

   static bool isRemoveConnectionRequired(const am_mainConnectionID_t mainConnectionID);

   static am_Error_e removeConnectionFromMainConnection(const am_sourceID_t sourceID, const am_sinkID_t sinkID, am::am_connectionID_t connectionId);
   static am_Error_e removeConnectionIDFromMainConnectionEntry(am::am_connectionID_t connectionID);

   static am_Error_e removeConnectionFromMainConnectionInternal(am_sourceID_t sourceID, am_sinkID_t sinkID, am_mainConnectionID_t mainConnectionID);

   //checks if subConID is present in any other main connection, other than MainID
   static bool bIsSubConInOtherMain(const am_mainConnectionID_t MainID, am_connectionID_t SubConID);

   /**
    * Request from source to Genivi AudioManager Receive IF
    * @param handle
    * @param connectionID
    * @return
    */
   static am::am_Error_e disconnect(am::am_Handle_s& handle, am::am_connectionID_t connectionID);

   /**
    * from source/AudioStack to AudioManager
    * @param handle
    * @param errorID
    */
   static void cbAckDisconnect(const am::am_Handle_s handle, const am::am_Error_e errorID);

   /**
    * Request from source to Genivi AudioManager Receive IF
    * @param handle
    * @param connectionID
    * @param format
    * @param sourceID
    * @param sinkID
    * @return
    */
   static am::am_Error_e connect(am::am_Handle_s&, am::am_connectionID_t&, am::am_CustomConnectionFormat_t, am::am_sourceID_t, am::am_sinkID_t);

   /**
    * From Genivi AudioManager to source
    * @param handle
    * @param errorID
    */
   static void cbAckConnect(const am::am_Handle_s handle, const am::am_Error_e errorID);

   /**
       * From Genivi AudioManager to source
       * @param handle
       * @param errorID
       */
   static void cbAckSetSourceState(const am_Handle_s handle, const am_Error_e error);

   /**
    * From AudioRoutingMgr via INC Adapter to AudioStack
    * @param sourceClassID MidwFI Value
    * @param sourceState source state of the source
    */
   static void handleSourceStatus(midw_fi_tcl_e8_SrcActivity::tenType activity, midw_fi_tcl_e8_AudSource::tenType source, tU16 subSrc = 0);

   static void handleSourceStatus(midw_fi_tcl_e8_SrcActivity::tenType activity,
       midw_fi_tcl_e8_AudSource::tenType source,
       tU16 subSrc,
       midw_fi_tcl_e8_ResourceNo::tenType sinkID);

   /**
    * From AudioRoutingMgr via INC Adapter to AudioStack
    * @param enAudioSources
    * !!!! No more supported !!!
    */
   //static void vHandleSourceError(midw_fi_tcl_e8_AudSource::tenType);

   /**
    * From AudioRoutingMgr via INC Adapter to AudioStack
    * @param enAudioSources
    * @param subSource
    */
   static void vHandleSourceError(midw_fi_tcl_e8_AudSource::tenType source, tU16 subSrc, tU16 ErrorCode);


   /**
    * From AudioStack to GeniviAudioManager
    */
   static am::am_Error_e setSourceState(am::am_Handle_s& handle,
         const am::am_sourceID_t sourceID,
         am::am_SourceState_e state);

   /**
    * add a source class
    */
   static am::am_Error_e addSourceClass( am_SourceClass_s& srcClass, am_sourceClass_t& srcClassID);

   /**
    * get the main connection id
    */
   // no more needed ?

   static am::am_Error_e getMainConnectionOfSourceSink(am_sourceID_t sourceID, am_sinkID_t sinkID, am_mainConnectionID_t& mainConnectionID);

   //not needed. Can be achieved with getMainConnectionInfoDB
   //static am::am_Error_e getSourceSinkOfMainConnection(am_sourceID_t& sourceID, am_sinkID_t& sinkID, am_mainConnectionID_t mainConnectionID);

   static bool getMainConnectionOfSourceSinkFromInternalData(am_sourceID_t sourceID, am_sinkID_t sinkID, am_mainConnectionID_t& mainConnectionID);
   static am_Error_e removeFailedConnectionFromInternalData(am_sourceID_t sourceID, am_sinkID_t sinkID, am_mainConnectionID_t mainConnectionID);

   static bool bIsMainConnection(am_sourceID_t sourceID, am_sinkID_t sinkID, am::am_mainConnectionID_t& mainConnectionID);
   static bool bIsSubConnection(am_sourceID_t sourceID, am_sinkID_t sinkID, am_mainConnectionID_t& mainConnectionID);

   static bool bIsSubConnection(am_sourceID_t sourceID, am_sinkID_t sinkID, am_connectionID_t& subConnectionID, std::vector<am_mainConnectionID_t>& mainConnectionIDList);

   static bool bIsSourcOrSinkPartOfMainConnection(am_sourceID_t sourceID, am_sinkID_t sinkID, std::vector<am_mainConnectionID_t>& listMainConnectionID);

   /**
    * from source/AudioStack to AudioManager
    * @param mainconnectionID
    * @param connectionState
    * @return
    */
   static am::am_Error_e changeMainConnectionStateDB(const am::am_sourceID_t sourceID,
                                                  const am::am_sinkID_t sinkID,
                                                  const am::am_ConnectionState_e connectionState);

   /**
    * update mute status of sink in DB
    */
   static am::am_Error_e changeSinkMuteStateDB(const am::am_MuteState_e muteState,
                                               const am::am_sinkID_t sinkId);

   /**
     * update system property
     */
    static void updateSystemPropertyDB(am_CustomSystemPropertyType_t etype,int16_t ivalue);
  static am_Error_e updateConnect(std::string SrcName,tU16 sinkID);


   /**
    * Request Source deactivation at AudioStack
    */
   static am::am_Error_e RequestSourceOff(midw_fi_tcl_e8_AudSource::tenType source, tU16 subID);
   static am::am_Error_e RequestSourceOff(const am_sourceID_t source);
   static am::am_Error_e RequestSourceOff(const AudioSource::SourceID srcID);
   static am::am_Error_e RequestSourceOff(const AudioSource::SourceID srcID, const tU16 sinkID);

   /**
    * Request Source pausing at AudioStack
    * ATTENTION: Actually not supported
    */
   static am::am_Error_e RequestSourcePause(AudioSource::SourceID srcID);

   /**
    * Request Source activation at AudioStack
    */
   static am::am_Error_e RequestSourceOn(midw_fi_tcl_e8_AudSource::tenType source, tU16 subID);
   static am::am_Error_e RequestSourceOn(const am_sourceID_t source);
   static am::am_Error_e RequestSourceOn(const AudioSource::SourceID srcID);
   static am::am_Error_e RequestSourceOn(const AudioSource::SourceID srcID, tU16 sinkID);

   /**
    * Send SourceActivity requests to FC_AudioRouteMgr via INC Gateway
    */
   static am::am_Error_e SourceActivityRequest(midw_fi_tcl_e8_AudSource::tenType source
                                                , tU16 subSource
                                                , midw_fi_tcl_e8_AudSource::tenType possibleNextSource
                                                , midw_fi_tcl_e8_SrcActivity::tenType activity);

   // with aditional Sink Parameter
   static am::am_Error_e SourceActivityRequest(midw_fi_tcl_e8_AudSource::tenType source
                                                , tU16 subSource
                                                , midw_fi_tcl_e8_AudSource::tenType possibleNextSource
                                                , midw_fi_tcl_e8_SrcActivity::tenType activity
                                                , midw_fi_tcl_e8_ResourceNo::tenType sink);
   /**
    * From AudioStack to Genivi
    * When restoring last source a main connections is established
    */
   static am::am_Error_e addMainConnection(am_sourceID_t sourceID);
   static am::am_Error_e addMainConnection(am_sourceID_t sourceID, am_sinkID_t sinkID);
   /**
    * From AudioStack to Genivi
    * when a source has changed to Pause or Off state
    */
   static am::am_Error_e removeMainConnection(am_sourceID_t sourceID);
   static am::am_Error_e removeMainConnection(am_sourceID_t sourceID, am_sinkID_t sinkID);

   /**
    * From AudioStack to Genivi
    * attach or remove connections to MainConnections
    */
   static am::am_Error_e changeMainConnectionRouteDB(am_sourceID_t sourceID,  std::vector<am_connectionID_t>& listConnectionID);
   static am::am_Error_e changeMainConnectionRouteDB(am_sourceID_t sourceID, am_sinkID_t sinkID, std::vector<am_connectionID_t>& listConnectionID);

   static void printAllConnections();
   static void printAllMainConnections();
   static void printSubConnections(std::vector<am_connectionID_t>& listConnectionID);


   static void sendVolumeSink17();
   /**
    * To Map External(midw_fi) source ID to
    * Internal source ID used in Genivi Audio Manager
    */
   static am::am_Error_e changeSourceAvailabilityDB(am_Availability_s& availability, am_sourceID_t sourceID);

   /**
    * To check if system is already Muted
    */
   //static tBool bIsAudioMuted();

   /**
    * To check if source is current active source
    */
   static tBool bIsCurrentActiveAudiosource(AudioSource::SourceID srcID,tU16 sinkID=0);
   static AudioSource::clAudioSource* pcoGetTopOfStackMixsource(tU16 sinkID=0);

   static AudioSource::clAudioSource* pcoGetTopOfStack(tU16 sinkID = 0);

   static tVoid TTFisInput(tU8 cmd,tU16 value1 = 0xFFFF,tU16 value2 = 0xFFFF);
   static tVoid vTraceRxDefault(tPCUChar pcu8Data);

   static am_Error_e isValidSourceID(am_sourceID_t sourceID);
   static am_Error_e isValidSinkID(am_sinkID_t sinkID);

   static AudioSource::clGeniviAudioSource* getAudioSource(AudioSource::SourceID srcID);

   static tVoid vRemoteControlStart();
   static tVoid vRemoteControlEnd();
   static tVoid vRemoteControlUpdateDB(int16_t i16Type);

   static tBool bIsCurrentSourceStackable(midw_fi_tcl_e8_AudSource::tenType source,tU16 subID);
   static tVoid SetAudioState(tS16 audioState);
   static am_Error_e bSourceConnect(am_sourceID_t SourceId,clAudioSMEngine::enErrorCode & retval);
   static am_Error_e bSourceConnect(am_sourceID_t SourceId, am_sinkID_t SinkId, clAudioSMEngine::enErrorCode & retval);
   static am_Error_e vSetMuteOnStartUp(tU16,bool bStartup = false);

   static am_Error_e vSetAmplifierMute(tU16);
   static am_Error_e vSetPersistentMute();
   static tVoid vAudioStateLCMStatus(spm_corefi_tclMsgAudioStateStatus& oStatus);

   static tBool bIsAutoplayEnabled();
   static am_Error_e setSinkVolume(am_Handle_s& handle, const am_sinkID_t sinkID, const am_volume_t volume, const am_CustomRampType_t ramp, const am_time_t time);

#if !defined(VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_INF4CV ) && !defined(VARIANT_S_FTR_ENABLE_UNITTEST)   
   static am_Error_e setSourceVolume(am_Handle_s& handle, const am_sourceID_t sourceID, const am_volume_t volume, const am_CustomRampType_t ramp, const am_time_t time);
   //static void cbAckSetSourceVolumeChange(const am_Handle_s handle, const am_volume_t voulme, const am_Error_e error);
#endif
   static void cbAckSetVolumeChange(const am_Handle_s handle, const am_volume_t volume, const am_Error_e error);

   static tVoid vSetEntertainmentMute(const am_MuteState_e muteState);
   static tVoid vUpdateMultiUsrDataPool(bool bProfileChanged);
   static tBool bAudioDeviceAvailability();
   static void SetMainSourceSoundProperty(const am_sourceID_t sourceID, const am_MainSoundProperty_s & soundProperty);
   static void vTraceMainCon();
   static void vTraceAllCon();

   static void vTraceSourceData(tU16 sourceID);
   static void vTraceSinkData(tU16 sinkID);
   static void vTraceAllDomains();
   static void vTraceAllSinks();
   static void vTraceAllSources();

   static void vTraceInitDPwithFM();
   static void vTraceSetDPforSink(tU16 sink, tU16 lastSource);
   static void vTraceClearDPforSink(tU16 sink);
   static void vTraceSetDPSubIDforSink(tU16 sink, tU16 subID);
   static am_Error_e vSetMicMute(bool bMutestate);
   static am_sinkID_t getSinkID(std::string SinkName);
//ToDo try to make more clean
   static bool getMapSinkNameSoundSink(std::map<std::string, tU16>& mapSinkNameSoundSink);
   static am_Error_e eSetPrivateMode(tU16 u16PrivateMode);
   static am_Error_e eGetPrivateMode(tU16 &u16PrivateMode);
   static void vSetPrivateModeMixVolume(tU16 u16PrivateModeMixVolume,tU16 sinkID=1);
   static tU16 u16GetPrivateModeMixVolume(tU16 sinkID=1);

   static tU16 u16GetPrivateModeMixVolumeBySinkName(std::string sinkName);

   static tU8 u8GetSinkID(SourceID srcID);

   static bool isTunerSourceClass(std::string className);
   static bool isTunerSourceClassByClassID(am_sourceClass_t srcClassID);
   static bool isTunerSourceClassBySourceID(am_sourceID_t sourceID);

   //what about this ?
   static void triggerPendingRequests();

   static bool isMediaPlayerSourceClassBySourceID(am_sourceID_t sourceID);

   static void cbAckSetSinkSoundProperty(const am_Handle_s handle, const am_Error_e error);

   static void getTopOfGatewaySink(std::string& nameOfMainSource);

   static am_sourceID_t getGeniviSourceIDFromInternalSourceID(SourceID srcID);
   static void vSetMutePrivateMode(tU16 sinkID,bool active);
   static void muteSinkIfEntertain(am_Source_s sourceData, am_sinkID_t sinkID, const am_MuteState_e muteState);

   static am::am_Error_e getSystemPropertyValue(am_SystemProperty_s& systemProperty);
   static void privateModeAdditionalActions(tU16 u16PrivateMode);
};


}//namespace


#endif /* CLGENIVIAUDIOCTRLADAPTER_H_ */
