#ifndef _AUDIOSOURCECONTROLLEROBSERVER_H_
#define _AUDIOSOURCECONTROLLEROBSERVER_H_

/*!****************************************************************************
 * FILE :      clIAudioSourceControllerObserver.h
 * SW-COMPONENT:  AudioEngine
 * DESCRIPTION:  Interface for callbacks from AudioSourceController
 * AUTHOR:
 * COPYRIGHT:    (c) 2007 Blaupunkt Werke
 * HISTORY:
 *****************************************************************************/



#include "AudioStack/InterfaceAudioStack.h"

namespace AudioStack
{
namespace AudioSource
{

/**
 * Provides Interface of
 * AudioSourceController-Observer
 */
class clIAudioSourceControllerObserver
{
public:

   /* Destructor needed to get no Lint Warning 1510 */
   virtual ~clIAudioSourceControllerObserver(){};


   virtual tVoid vAudioSourceStarted(SourceID srcID) = 0;
   virtual tVoid vAudioSourceStopped(SourceID srcID) = 0;
   virtual tVoid vAudioSourceInitStarted(SourceID srcID) = 0;
   virtual tVoid vEntertainmentSourceExchanged(SourceID srcID, tBool bBackground) = 0;
   virtual tVoid vAudioSourceStartMute(SourceID srcID) = 0;
   virtual tVoid vAudioSourceStartUnMute(SourceID srcID) = 0;
 };

}}


#endif // _AUDIOSOURCECONTROLLEROBSERVER_H_
