/*
 * clGeniviAudioSource.h
 *
 *  Created on: Jul 25, 2013
 *      Author: vo84hi
 */

#ifndef CLGENIVIAUDIOSOURCE_H_
#define CLGENIVIAUDIOSOURCE_H_


#include "IAmControlReceiverShadow.h"
#include "AudioStack/AudioSources/clAudioSource.h"



namespace AudioStack
{
namespace AudioSource
{

class clGeniviAudioSource : public clAudioSource
{
public:
   /**
    * Get the Genivi SourceID of the Source provided by Parameter
    * @param enSrcId ID of the AudioStackInternal Identifier
    * @param u8SubSource the SubSource ID
    * @return tU16 Genivi AudioManager sourceID of given AudioSource, Subsource tupel
    */
   //static tU16 u16GetGeniviSourceID(SourceID srcID);

   /**
    * Get the Genivi SourceID of this Source
    * @return tU16 Genivi AudioManager sourceID of this Object
    */
   tU16 u16GetGeniviSourceID() {return m_gam_source_s.sourceID;}
   tU16 u16GetGeniviDomainID() {return m_gam_source_s.domainID;}

   /**
    * Get the Subsource ID of this this Source
    * @return tU16 Genivi AudioManager sourceID of this Object
    */
   tU8 u8GetSubsourceID();

   /**
    * Get the availability state of source
    */
   clAudioSource::enSourceAvailability enIsSourceAvailable();


   clGeniviAudioSource(SourceID srcId);
   virtual ~clGeniviAudioSource();
   virtual tVoid vMW_CCAResponse(tS32 extSrcID, tU16 subSrc, enSourceActivity activity);
   virtual tVoid vMW_CCAResponse(tS32 extSrcID, tU16 subSrc, enSourceActivity activity, tU16 sinkID);

   virtual tVoid vMW_On(tU16 sinkID);
   virtual tVoid vMW_Off(SourceID possibleNextSrc,tU16 sinkID);
   virtual tVoid vMW_Pause(SourceID possibleNextSrc,tU16 sinkID);
   virtual tVoid vReset();
   virtual tVoid vPrint();
   virtual tVoid vSourceAvailablilityChange(enSourceAvailability availability, enSourceAvailabilityReason availabilityReason);

   virtual am::am_Handle_s* getHandle() {return m_gam_handle;}
   virtual am::am_Handle_s* getSinkHandle() {return m_gam_SinkHandle;} //This has no handle;
   virtual am::am_sinkID_t getSinkIDByHandle(const am_Handle_s* pHandle) {(void)pHandle; return (am_sinkID_t)1;} //This has no handle;
   virtual void setSinkHandle(const am_Handle_s* p, tU16 a);

   //not overridden as we do not use it for clGeniviAudioSource
   //virtual tVoid vCbAckConnect() {return;}  //this is not doing anything in the base
   //virtual tVoid vCbAckSetSourceState() {return;} //this is not doing anything in the base


protected:
   clAudioSource::enSourceAvailability mapAvailability(am_Availability_e avail);
   am_Availability_e mapAvailability(clAudioSource::enSourceAvailability);

   am::am_Handle_s*            m_gam_handle;
   am::am_Handle_s*            m_gam_SinkHandle; //daw2hi 7.3.2018 added to not conflict with source handle. Not clear if needed
   am::am_connectionID_t       m_gam_connectionId;
   am::am_Source_s             m_gam_source_s;
private:
   clGeniviAudioSource();

   am::am_connectionID_t connectionExisting(am_sourceID_t sourceID, am_sinkID_t sinkID);
   am::am_connectionID_t connectionKnown(am_sourceID_t sourceID, am_sinkID_t sinkID);

   // 22.07.2016 daw2hi lets keep a map of logical source states (a state for each sink)
   std::map<tU16,am_SourceState_e> m_logicalSourceStates;
};

}}//namespace


#endif /* CLGENIVIAUDIOSOURCE_H_ */

