/*
 * clGeniviAudioSource.h
 *
 *  Created on: Jul 25, 2013
 *      Author: vo84hi
 */

#ifndef CLEXTGENIVIAUDIOSOURCE_H_
#define CLEXTGENIVIAUDIOSOURCE_H_


#include "IAmControlReceiverShadow.h"
#include "AudioStack/AudioSources/clAudioSource.h"



namespace AudioStack
{
namespace AudioSource
{

class clExtGeniviAudioSource : public clAudioSource
{
public:
   /**
    * Get the Genivi SourceID of the Source provided by Parameter
    * @param enSrcId ID of the AudioStackInternal Identifier
    * @param u8SubSource the SubSource ID
    * @return tU16 Genivi AudioManager sourceID of given AudioSource, Subsource tupel
    */
   //static tU16 u16GetGeniviSourceID(SourceID srcID);

   /**
    * Get the Genivi SourceID of this Source
    * @return tU16 Genivi AudioManager sourceID of this Object
    */
   tU16 u16GetGeniviSourceID() {return m_gam_source_s.sourceID;}

   /**
    * Get the Subsource ID of this this Source
    * @return tU16 Genivi AudioManager sourceID of this Object
    */
   tU8 u8GetSubsourceID();

   /**
    * Get the availability state of source
    */
   clAudioSource::enSourceAvailability enIsSourceAvailable();

   // added am_sourceID_t needed for static registration where gam_sourceID is not the same as the sourceClassID
   //clExtGeniviAudioSource(SourceID srcId, am_sourceID_t gam_sourceID=0);
   clExtGeniviAudioSource(SourceID srcId, am_sourceID_t gam_sourceID, const am_Source_s* pSourceData);

   virtual ~clExtGeniviAudioSource();
   virtual tVoid vMW_CCAResponse(tS32 extSrcID, tU16 subSrc, enSourceActivity activity);
   virtual tVoid vMW_CCAResponse(tS32 extSrcID, tU16 subSrc, enSourceActivity activity, tU16 sinkID);

  // virtual tVoid vMW_On();
   virtual tVoid vMW_On(tU16 sinkID);
   //virtual tVoid vMW_Off(SourceID possibleNextSrc);
   virtual tVoid vMW_Off(SourceID possibleNextSrc,tU16 sinkID);
   virtual void cbAckSetVolumeChange(const am_Handle_s* pHandle,tU16 SinkID);//swati 
   //virtual tVoid vMW_Pause(SourceID possibleNextSrc);
   virtual tVoid vMW_Pause(SourceID possibleNextSrc,tU16 sinkID);
   virtual tVoid vReset();
   virtual tVoid vPrint();
   virtual tVoid vSourceAvailablilityChange(enSourceAvailability availability, enSourceAvailabilityReason availabilityReason);

   virtual const am::am_Handle_s* getHandle(const am_Handle_s* pHandle);
   virtual const am::am_Handle_s* getSinkHandle(const am_Handle_s* pHandle);

   virtual bool eraseSinkHandle(am_Handle_s handle);

   virtual am::am_sinkID_t getSinkIDByHandle(const am_Handle_s* pHandle);

   virtual void setSinkHandle(const am_Handle_s* pHandle, tU16 sinkID);
   virtual void setMainSourceSoundProperty();


   virtual tVoid vCbAckDisconnect(const am_Handle_s* pHandle);
   virtual tVoid vCbAckConnect(const am_Handle_s* pHandle);
   virtual tVoid vCbAckSetSourceState(const am_Handle_s* pHandle);
   tVoid vSetSourceState(am_SourceState_e state);

   // new overrides
   virtual tVoid vMW_StartMute(const am_Handle_s* pHandle,tU16 SinkID);
   virtual tVoid vMW_StartUnMute(const am_Handle_s* pHandle,tU16 SinkID);

   //additional function
   void disconnect( am_sourceID_t sourceID,  am_sinkID_t sinkID);
#if 0
   virtual tVoid vMW_UnMuted(const am_Handle_s* pHandle);
#endif
   virtual tVoid vMW_UnMuted(const am_Handle_s* pHandle,tU16 SinkID=1);
   // new overrides end

protected:
   clAudioSource::enSourceAvailability mapAvailability(am_Availability_e avail);
   am_Availability_e mapAvailability(clAudioSource::enSourceAvailability);

   am::am_Handle_s*            m_gam_handle;
   am::am_Handle_s*            m_gam_SinkHandle; //daw2hi 7.3.2018 added to not conflict with source handle. Not clear if needed
   am::am_connectionID_t       m_gam_connectionId;
   am::am_Source_s             m_gam_source_s;
private:
   clExtGeniviAudioSource();

   //only debug
   bool print_handleSinkSinkMap(void);

   bool bIsMuteEnetrtainOnStackInOnState(am_sinkID_t sinkID);

   // 22.07.2016 daw2hi lets keep a map of logical source states (a state for each sink)
   std::map<tU16,am_SourceState_e> m_logicalSourceStates;
   // handle -> sink
   //std::map<tU16,am_sinkID_t> m_handleSinkMap;
   std::map<tU16,am_sinkID_t> m_handleSourceSinkMap;
   std::map<tU16,am_sinkID_t> m_handleSinkSinkMap; //ToDO: can we have them in one Map ? Looks like yes


   bool eraseHandleSinkSinkMap(tU16 SinkID);

   bool eraseHandleSourceSinkMap(const am_Handle_s* pHandle);
   bool findHandleSourceSinkMap(const am_Handle_s* pHandle);
   tVoid vCbAckSetSourceState_PAUSE();
   tVoid vCbAckSetSourceState_ON();
   tVoid vCbAckSetSourceState_OFF();
   //we keep some data
   //am_sinkID_t m_activeSinkID;

};

}}//namespace


#endif /* CLEXTGENIVIAUDIOSOURCE_H_ */

