/*
 * AudioUserDpSMART.h
 *
 * Generic implementation of AudioUserDpIf interface
 * Can be used by G3G, Suzuki etc. (where there is no "multi" user storage is needed)
 *
 * Author : oni1kor
 */

#include "../../include/controllerplugin_Trace.h"
#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

//#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AMCONTROLLERPLUGIN
#include "trcGenProj/Header/AudioUserDpSMART.cpp.trc.h"
#endif

#include "AudioUserDpIf.h"
#include "AudioUserDpSMART.h"
#include "AudioStack_dp_if.h"

#define DP_S_IMPORT_INTERFACE_FI
//#include "dp_audio_if.h"

#ifndef VARIANT_S_FTR_ENABLE_AUDIO_STACK_UTEST
#include "dp_e880_if.h"
#else
#include "dp_e880_mock_if.h"
#endif


/*****************GET FUNCTIONS**********************/

tS32 AudioUserDpSMART::s32GetLastSourceClassOfSink(std::string &sLastSrc , tU16 sink)
{
  ETG_TRACE_USR4(("AudioUserDpSMART::s32GetLastSoureClassOfSink for sink %d (MaxSize %d)",sink,Number_of_Sinks));
  dpSourceName tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  memset(tmpArray,'\0',sizeof(tmpArray));
  dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_Class oLastSource_Class;
  tS32 res =oLastSource_Class.s32GetData(tmpArray,sizeof(tmpArray)/sizeof(dpSourceName));
  ETG_TRACE_USR4(("DP read res = %d",res));

  if(sink >=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpSMART::s32GetLastSoureClassOfSink sink out of range"));
    return 0;
  }

  sLastSrc = tmpArray[sink].sSrcName;
  ETG_TRACE_USR4(("AudioUserDpSMART::s32GetLastSoureClassOfSink u8LastSource = res = %d, str = %s",res,tmpArray[sink].sSrcName));

  if(!sLastSrc.empty())
  {
    res = 1;
  }
  else
    res = 0;

  return res;
}

tS32 AudioUserDpSMART::s32GetLastSourceSubIDOfSink(tU16& u16SubID, tU16 sink)
{

  ETG_TRACE_USR4(("AudioUserDpSMART::s32GetLastSoureSubIDOfSink for sink %d",sink));
  tU16 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  memset(tmpArray,0,sizeof(tmpArray));
  dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_SubID oLastSource_SubID;
  tS32 res =oLastSource_SubID.s32GetData(tmpArray,(tU32)sizeof(tmpArray));

  if(sink >=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpSMART::s32GetLastSoureClassOfSink sink out of range"));
    return 0;
  }

  ETG_TRACE_USR4(("AudioUserDpSMART::s32GetLastSoureSubIDOfSink u16SubID = %d, res = %d",tmpArray[sink],res));
  u16SubID = tmpArray[sink];

  return res;
}


tS32 AudioUserDpSMART::s32GetNumberOfSinks(tU8& u8Sinks)
{
  dp_tclAudioStackMultiUsrDPNumber_of_Sinks oSinks;
  tS32 res = oSinks.s32GetData(u8Sinks);
  if(u8Sinks != Number_of_Sinks)
  {
    ETG_TRACE_ERR(("SoundHandler mismatch check Number_of_Sinks (%d) and datapool definitons Number_of_Sinks (%d)",Number_of_Sinks,(int)u8Sinks));
  }
  return res;
}

//############################# Treble ###########################
tS32 AudioUserDpSMART::s32GetTrebleMin(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPTreble_Min oTrebleMin;
  tS32 res = oTrebleMin.s32GetData(ps8Value,u8Size);
  return res;
}

tS32 AudioUserDpSMART::s32GetTrebleMax(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPTreble_Max oTrebleMax;
  tS32 res = oTrebleMax.s32GetData(ps8Value,u8Size);
  return res;
}


tS32 AudioUserDpSMART::s32GetTreble(tS8& s8Value)
{
  return s32GetTreble(s8Value,1);
}

tS32 AudioUserDpSMART::s32GetTreble(tS8& s8Value, tU16 sink)
{
  tS8 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  dp_tclAudioStackMultiUsrDPTreble oTreble;
  tS32 res =oTreble.s32GetData(tmpArray,sizeof(tmpArray));

  if(sink ==17) sink =3;
  if(sink >=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpSMART::s32GetTreble sink out of range"));
    return 0;
  }
  s8Value = tmpArray[sink];

  return res;
}
tS32 AudioUserDpSMART::s32GetTreble(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPTreble oTreble;
  tS32 res =oTreble.s32GetData(ps8Value,u8Size);

  return res;
}

tS32 AudioUserDpSMART::s32GetMixTreble(tS8* ps8Value, tU8 u8Size, unsigned char mic)
{
  ETG_TRACE_ERR(("s32GetMixTreble  not used in SMART"));
  return 0;
}
//############################# Bass ###########################
tS32 AudioUserDpSMART::s32GetBassMin(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPBass_Min oBassMin;
  tS32 res = oBassMin.s32GetData(ps8Value,u8Size);
  return res;
}

tS32 AudioUserDpSMART::s32GetBassMax(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPBass_Max oBassMax;
  tS32 res = oBassMax.s32GetData(ps8Value,u8Size);
  return res;
}

tS32 AudioUserDpSMART::s32GetBass(tS8& s8Value)
{
  return s32GetBass(s8Value,1);
}
tS32 AudioUserDpSMART::s32GetBass(tS8& s8Value, tU16 sink)
{
  tS8 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  dp_tclAudioStackMultiUsrDPBass oBass;
  tS32 res =oBass.s32GetData(tmpArray,sizeof(tmpArray));

  if(sink ==17) sink =3;
  if(sink >=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpSMART::s32GetTreble sink out of range"));
    return 0;
  }
  s8Value = tmpArray[sink];
  return res;
}

tS32 AudioUserDpSMART::s32GetBass(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPBass oBass;
  tS32 res = oBass.s32GetData(ps8Value,u8Size);
  return res;
}

tS32 AudioUserDpSMART::s32GetMixBass(tS8* ps8Value, tU8 u8Size, unsigned char mic)
{
  ETG_TRACE_ERR(("s32GetMixBass  not used in SMART"));
  return 0;
}


//############################# MidRange ###########################

tS32 AudioUserDpSMART::s32GetMidRangeMin(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPMidRange_Min oMidRangeMin;
  tS32 res = oMidRangeMin.s32GetData(ps8Value,u8Size);
  return res;

}
tS32 AudioUserDpSMART::s32GetMidRangeMax(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPMidRange_Max oMidRangeMax;
  tS32 res = oMidRangeMax.s32GetData(ps8Value,u8Size);
  return res;
}

tS32 AudioUserDpSMART::s32GetMidRange(tS8& s8Value)
{
  return s32GetMidRange(s8Value,1);
}
tS32 AudioUserDpSMART::s32GetMidRange(tS8& s8Value, tU16 sink)
{
  //ToDo take array size from number of sinks?
  tS8 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  dp_tclAudioStackMultiUsrDPMidRange oMidRange;
  tS32 res =oMidRange.s32GetData(tmpArray,sizeof(tmpArray));

  if(sink ==17) sink =3;
  if(sink >=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpSMART::s32GetMidRange sink out of range"));
    return 0;
  }
  s8Value = tmpArray[sink];

  return res;
}

tS32 AudioUserDpSMART::s32GetMidRange(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPMidRange oMidRange;
  tS32 res = oMidRange.s32GetData(ps8Value,u8Size);
  return res;
}

//############################# Balance ###########################
tS32 AudioUserDpSMART::s32GetBalanceMin(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPBalance_Min oBalanceMin;
  tS32 res = oBalanceMin.s32GetData(ps8Value,u8Size);
  return res;
}
tS32 AudioUserDpSMART::s32GetBalanceMax(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPBalance_Max oBalanceMax;
  tS32 res = oBalanceMax.s32GetData(ps8Value,u8Size);
  return res;
}
tS32 AudioUserDpSMART::s32GetBalance(tS8& s8Value)
{
  return s32GetBalance(s8Value,1);
}
tS32 AudioUserDpSMART::s32GetBalance(tS8& s8Value, tU16 sink)
{
  tS8 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  dp_tclAudioStackMultiUsrDPBalance oBalance;
  tS32 res =oBalance.s32GetData(tmpArray,sizeof(tmpArray));
  if(sink ==17) sink =3;
  if(sink >=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpSMART::s32GetBalance sink out of range"));
    return 0;
  }
  s8Value = tmpArray[sink];
  //return oBalance.s32GetData(s8Value);
  return res;
}

tS32 AudioUserDpSMART::s32GetBalance(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPBalance oBalance;
  tS32 res = oBalance.s32GetData(ps8Value,u8Size);
  return res;
}

//############################# Fader ###########################
tS32 AudioUserDpSMART::s32GetFaderMin(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPFader_Min oFaderMin;
  tS32 res = oFaderMin.s32GetData(ps8Value,u8Size);
  return res;
}
tS32 AudioUserDpSMART::s32GetFaderMax(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPFader_Max oFaderMax;
  tS32 res = oFaderMax.s32GetData(ps8Value,u8Size);
  return res;
}
tS32 AudioUserDpSMART::s32GetFader(tS8& s8Value)
{

  return s32GetFader(s8Value,1);
}
tS32 AudioUserDpSMART::s32GetFader(tS8& s8Value, tU16 sink)
{
  tS8 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  dp_tclAudioStackMultiUsrDPFader oFader;
  tS32 res =oFader.s32GetData(tmpArray,sizeof(tmpArray));
  if(sink ==17) sink =3;
  if(sink >=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpSMART::s32GetBalance sink out of range"));
    return 0;
  }
  s8Value = tmpArray[sink];
  //return oFader.s32GetData(s8Value);
  return res;
}
tS32 AudioUserDpSMART::s32GetFader(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPFader oFader;
  tS32 res = oFader.s32GetData(ps8Value,u8Size);
  return res;
}

//################################## others, not yet supported ################
tS32 AudioUserDpSMART::s32GetBeepLevel(tU8& u8Value)
{
  return s32GetBeepLevel(u8Value,1);
}
tS32 AudioUserDpSMART::s32GetBeepLevel(tU8& u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpSMART::s32GetEquPreset(tU8& u8Value)
{
  return s32GetEquPreset(u8Value,1);
}
tS32 AudioUserDpSMART::s32GetEquPreset(tU8& u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpSMART::s32GetOptimization(tU8& u8Value)
{
  return s32GetOptimization(u8Value,1);
}
tS32 AudioUserDpSMART::s32GetOptimization(tU8& u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpSMART::s32GetGala(tU8& u8Value)
{
  return s32GetGala(u8Value,1);
}
tS32 AudioUserDpSMART::s32GetGala(tU8& u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpSMART::s32GetLoudness(tU8& u8Value)
{
  return s32GetLoudness(u8Value,1);
}
tS32 AudioUserDpSMART::s32GetLoudness(tU8& u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpSMART::s32GetSurroundLevel(tU8& u8Value)
{
  return s32GetSurroundLevel(u8Value,1);
}
tS32 AudioUserDpSMART::s32GetSurroundLevel(tU8& u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpSMART::s32GetCenterGain(tS16& s16Value)
{
  return s32GetCenterGain(s16Value,(tU16)1);
}
tS32 AudioUserDpSMART::s32GetCenterGain(tS16& s16Value, tU16 sink)
{
	(void)s16Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpSMART::s32GetSubwoofer(tS16& s16Value)
{
  return s32GetSubwoofer(s16Value,(tU16)1);
}
tS32 AudioUserDpSMART::s32GetSubwoofer(tS16& s16Value, tU16 sink)
{
	(void)s16Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpSMART::s32GetAutomaticGainControl(tBool& bValue)
{
  return s32GetAutomaticGainControl(bValue,(tU16)1);
}
tS32 AudioUserDpSMART::s32GetAutomaticGainControl(tBool& bValue, tU16 sink)
{
	(void)bValue;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpSMART::s32GetRoomEffect(tU8& u8Value)
{
  return s32GetRoomEffect(u8Value,(tU16)1);
}
tS32 AudioUserDpSMART::s32GetRoomEffect(tU8& u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpSMART::s32GetSoundStaging(tU8& u8Value)
{
  return s32GetSoundStaging(u8Value,1);
}
tS32 AudioUserDpSMART::s32GetSoundStaging(tU8& u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpSMART::s32GetGeometryMode(tU8& u8Value)
{
  return s32GetGeometryMode(u8Value,(tU16)1);
}
tS32 AudioUserDpSMART::s32GetGeometryMode(tU8& u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}
/*****************SET FUNCTIONS**********************/

tS32 AudioUserDpSMART::s32GetPrivateMode(tU16& u16PrivateMode)
{
  u16PrivateMode = (tU16)1;
  ETG_TRACE_USR4(("GetPrivateMode for SMART Called"));
  //dp_tclAudioStackMultiDPPrivateMode oDPPrivateMode;
  return 0;
}

tS32 AudioUserDpSMART::s32SetPrivateMode(tU16 u16PrivateMode)
{
   ETG_TRACE_USR4(("SetPrivateMode for SMART Called with %d",u16PrivateMode));
   return 0;
}


tS32 AudioUserDpSMART::s32GetSinkID(tU16& u16PrivateMode)
{
  (void)u16PrivateMode;
  return 0;
}

tS32 AudioUserDpSMART::s32SetSinkID(tU16 u16PrivateMode)
{
  (void)u16PrivateMode;
  return 0;
}



tS32 AudioUserDpSMART::s32SetLastSourceClassOfSink(tString u8LastSource, tU16 sink)
{
  ETG_TRACE_USR4(("AudioUserDpSMART::s32SetLastSoureClassOfSink for sink %d (MaxSize %d)",sink,Number_of_Sinks));
  dpSourceName tmpArray[Number_of_Sinks]; //max possible in system
  memset(tmpArray,'\0',sizeof(tmpArray));
  dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_Class oLastSource_Class;
  tS32 res =oLastSource_Class.s32GetData(tmpArray,sizeof(tmpArray)/sizeof(dpSourceName));
  ETG_TRACE_USR4(("DP read res = %d",res));

  if(sink==17) sink =(tU16)3;  //Hack Sink17 to be 3

  if(sink>=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpSMART::s32SetLastSoureClassOfSink sink out of Range"));
    return 0;
  }

  memset(tmpArray[sink].sSrcName,'\0',sizeof(tmpArray[sink].sSrcName));
  strncpy(tmpArray[sink].sSrcName, u8LastSource , MAX_SRC_LEN);


  res = oLastSource_Class.s32SetData(tmpArray,sizeof(tmpArray)/sizeof(dpSourceName));
  ETG_TRACE_USR4(("DP write res = %d",res));

  //O.K. now just read immediately back for test
  memset(tmpArray,0,sizeof(tmpArray));
  oLastSource_Class.s32GetData(tmpArray,sizeof(tmpArray)/sizeof(dpSourceName));

  ETG_TRACE_USR4(("DP read_back res = %d and source %s",res,tmpArray[sink].sSrcName));

  return res;
  //return oLastSource_Class.s32SetData(tmpArray,sizeof(tmpArray));

}

tS32 AudioUserDpSMART::s32SetLastSourceSubIDOfSink(tU16 u16SubID, tU16 sink)
{
  ETG_TRACE_USR4(("AudioUserDpSMART::s32SetLastSoureSubIDOfSink for sink %d",sink));
  tU16 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  memset(tmpArray,0,sizeof(tmpArray));
  dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_SubID oLastSource_SubID;
  tS32 res =oLastSource_SubID.s32GetData(tmpArray,(tU32)Number_of_Sinks);
  ETG_TRACE_USR4(("DP read res = %d",res));

  if(sink>=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpSMART::s32SetLastSourceSubIDOfSink sink out of Range"));
    return 0;
  }
  tmpArray[sink] = u16SubID;
  res = oLastSource_SubID.s32SetData(tmpArray,Number_of_Sinks);
  return res;
}


tS32 AudioUserDpSMART::s32SetTreble(tS8 s8Value)
{
  return s32SetTreble(s8Value,(tU16)1);
}
tS32 AudioUserDpSMART::s32SetTreble(tS8 s8Value, tU16 sink)
{
  tS8 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  memset(tmpArray,0,sizeof(tmpArray));
  dp_tclAudioStackMultiUsrDPTreble oTreble;
  //tS32 res =oTreble.s32GetData(tmpArray,sizeof(tmpArray));
  (void)oTreble.s32GetData(tmpArray,sizeof(tmpArray));

  if(sink==17) sink =(tU16)3;  //Hack Sink17 to be 3

  if(sink>=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpSMART::s32SetTreble sink out of Range"));
    return 0;
  }
  tmpArray[sink] = s8Value;
  //return oTreble.s32SetData(s8Value);
  return oTreble.s32SetData(tmpArray,sizeof(tmpArray));
}

tS32 AudioUserDpSMART::s32SetMixTreble(tS8 s8Value, tU16 sink, unsigned char mic)
{
    ETG_TRACE_ERR(("s32SetMixTreble not used in SMART"));
    return 0;
}

tS32 AudioUserDpSMART::s32SetBass(tS8 s8Value)
{
  return s32SetBass(s8Value,(tU16)1);
}
tS32 AudioUserDpSMART::s32SetBass(tS8 s8Value, tU16 sink)
{
  tS8 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  memset(tmpArray,0,sizeof(tmpArray));
  dp_tclAudioStackMultiUsrDPBass oBass;
  //tS32 res =oBass.s32GetData(tmpArray,sizeof(tmpArray));
  (void)oBass.s32GetData(tmpArray,sizeof(tmpArray));

  if(sink==17) sink =(tU16)3;  //Hack Sink17 to be 3

  if(sink>=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpSMART::s32SetBass sink %d out of Range",sink));
    return 0;
  }
  tmpArray[sink] = s8Value;
  //return oBass.s32SetData(s8Value);
  return oBass.s32SetData(tmpArray,sizeof(tmpArray));
}

tS32 AudioUserDpSMART::s32SetMixBass(tS8 s8Value, tU16 sink, unsigned char mic)
{
  ETG_TRACE_ERR(("s32SetMixBass not used in SMART"));
  return 0;
}

tS32 AudioUserDpSMART::s32SetMidRange(tS8 s8Value)
{
  return s32SetMidRange(s8Value,1);
}
tS32 AudioUserDpSMART::s32SetMidRange(tS8 s8Value, tU16 sink)
{
  tS8 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  memset(tmpArray,0,sizeof(tmpArray));
  dp_tclAudioStackMultiUsrDPMidRange oMidRange;
  //tS32 res =oMidRange.s32GetData(tmpArray,sizeof(tmpArray));
  (void)oMidRange.s32GetData(tmpArray,sizeof(tmpArray));

  if(sink==17) sink =(tU16)3;  //Hack Sink17 to be 3

  if(sink>=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpSMART::s32SetMidRange sink out of Range"));
    return 0;
  }

  tmpArray[sink] = s8Value;
  //return oMidRange.s32SetData(s8Value);
  return oMidRange.s32SetData(tmpArray,sizeof(tmpArray));
}

tS32 AudioUserDpSMART::s32SetBalance(tS8 s8Value)
{
  return s32SetBalance(s8Value,1);
}
tS32 AudioUserDpSMART::s32SetBalance(tS8 s8Value, tU16 sink)
{
  tS8 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  memset(tmpArray,0,sizeof(tmpArray));
  dp_tclAudioStackMultiUsrDPBalance oBalance;
  //tS32 res =oBalance.s32GetData(tmpArray,sizeof(tmpArray));
  (void)oBalance.s32GetData(tmpArray,sizeof(tmpArray));

  if(sink==17) sink =(tU16)3;  //Hack Sink17 to be 3

  if(sink>=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpSMART::s32SetBalance sink %d out of Range",sink));
    return 0;
  }

  tmpArray[sink] = s8Value;
  //return oBalance.s32SetData(s8Value);
  return oBalance.s32SetData(tmpArray,sizeof(tmpArray));
}

tS32 AudioUserDpSMART::s32SetFader(tS8 s8Value)
{
  return s32SetFader(s8Value,1);
}
tS32 AudioUserDpSMART::s32SetFader(tS8 s8Value, tU16 sink)
{
  tS8 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  memset(tmpArray,0,sizeof(tmpArray));
  dp_tclAudioStackMultiUsrDPFader oFader;
  //tS32 res =oFader.s32GetData(tmpArray,sizeof(tmpArray));
  (void)oFader.s32GetData(tmpArray,sizeof(tmpArray));

  if(sink==17) sink =(tU16)3;  //Hack Sink17 to be 3

  if(sink>=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpSMART::s32SetFader sink out of Range"));
    return 0;
  }
  tmpArray[sink] = s8Value;
  //return oFader.s32SetData(s8Value);
  return oFader.s32SetData(tmpArray,sizeof(tmpArray));
}

tS32 AudioUserDpSMART::s32SetBeepLevel(tU8 u8Value)
{
  return s32SetBeepLevel(u8Value,1);
}
tS32 AudioUserDpSMART::s32SetBeepLevel(tU8 u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpSMART::s32SetEquPreset(tU8 u8Value)
{
  return s32SetEquPreset(u8Value,1);
}
tS32 AudioUserDpSMART::s32SetEquPreset(tU8 u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpSMART::s32SetOptimization(tU8 u8Value)
{
  return s32SetOptimization(u8Value,1);
}
tS32 AudioUserDpSMART::s32SetOptimization(tU8 u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpSMART::s32SetGala(tU8 u8Value)
{
  return s32SetGala(u8Value,1);
}
tS32 AudioUserDpSMART::s32SetGala(tU8 u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpSMART::s32SetLoudness(tU8 u8Value)
{
  return s32SetLoudness(u8Value,1);
}
tS32 AudioUserDpSMART::s32SetLoudness(tU8 u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpSMART::s32SetSurroundLevel(tU8 u8Value)
{
  return s32SetSurroundLevel(u8Value,(tU16)1);
}
tS32 AudioUserDpSMART::s32SetSurroundLevel(tU8 u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpSMART::s32SetCenterGain(tS16 s16Value)
{
  return s32SetCenterGain(s16Value,1);
}
tS32 AudioUserDpSMART::s32SetCenterGain(tS16 s16Value, tU16 sink)
{
	(void)s16Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpSMART::s32SetSubwoofer(tS16 s16Value)
{
  return s32SetSubwoofer(s16Value,1);
}
tS32 AudioUserDpSMART::s32SetSubwoofer(tS16 s16Value, tU16 sink)
{
	(void)s16Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpSMART::s32SetAutomaticGainControl(tBool bValue)
{
  return s32SetAutomaticGainControl(bValue,1);
}
tS32 AudioUserDpSMART::s32SetAutomaticGainControl(tBool bValue, tU16 sink)
{
	(void)bValue;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpSMART::s32SetRoomEffect(tU8 u8Value)
{
  return s32SetRoomEffect(u8Value,(tU16)1);
}
tS32 AudioUserDpSMART::s32SetRoomEffect(tU8 u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpSMART::s32SetSoundStaging(tU8 u8Value)
{
  return s32SetSoundStaging(u8Value,(tU16)1);
}
tS32 AudioUserDpSMART::s32SetSoundStaging(tU8 u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpSMART::s32SetGeometryMode(tU8 u8Value)
{
  return s32SetGeometryMode(u8Value,(tU16)1);
}
tS32 AudioUserDpSMART::s32SetGeometryMode(tU8 u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

//privatemodemix volume based on sink
tS32 AudioUserDpSMART::u32GetPrivateModeMixVolume(tU16& u16PrivateModeMixVolume, tU16 Sink)
{
  ETG_TRACE_USR4(("AudioUserDpSMART::u32GetPrivateModeMixVolume for sink %d (MaxSize %d)",Sink,Number_of_Sinks));
  tU16 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  memset(tmpArray,0,sizeof(tmpArray));
  dp_tclAudioStackMultiDPPrivateModeMixVolume oPrivateModeMixVol;
  tS32 res =oPrivateModeMixVol.s32GetData(tmpArray,sizeof(tmpArray)/sizeof(tU16));
  ETG_TRACE_USR4(("DP read res = %d",res));

  if(Sink >=Number_of_Sinks)
  {
      ETG_TRACE_ERR(("AudioUserDpSMART::s32GetLastSoureClassOfSink sink out of range"));
      return 0;
  }

  u16PrivateModeMixVolume = tmpArray[Sink];
  ETG_TRACE_USR4(("AudioUserDpSMART::s32GetLastSoureClassOfSink u8LastSource u16PrivateModeMixVolume = %d",u16PrivateModeMixVolume));
  return res;
}

tS32 AudioUserDpSMART::s32SetPrivateModeMixVolume(tU16 u16PrivateModeMixVolume, tU16 sink)
{
  ETG_TRACE_USR4(("AudioUserDpSMART::s32SetPrivateModeMixVolume for sink %d (MaxSize %d)",sink,Number_of_Sinks));
  tU16 tmpArray[Number_of_Sinks]; //max possible in system
  memset(tmpArray,0,sizeof(tmpArray));
  dp_tclAudioStackMultiDPPrivateModeMixVolume oPrivateModeMixVol;
  tS32 res =oPrivateModeMixVol.s32GetData(tmpArray,sizeof(tmpArray)/sizeof(tU16));
  ETG_TRACE_USR4(("DP read res = %d",res));

    if(sink>=Number_of_Sinks)
  {
      ETG_TRACE_ERR(("AudioUserDpSMART::s32SetLastSoureClassOfSink sink out of Range"));
      return 0;
  }

  tmpArray[sink] = u16PrivateModeMixVolume;

  res = oPrivateModeMixVol.s32SetData(tmpArray,sizeof(tmpArray)/sizeof(tU16));
  ETG_TRACE_USR4(("DP write res = %d",res));

    //O.K. now just read immediately back for test
  memset(tmpArray,0,sizeof(tmpArray));
  res = oPrivateModeMixVol.s32GetData(tmpArray,sizeof(tmpArray)/sizeof(tU16));

  ETG_TRACE_USR4(("DP read_back res = %d and source %d",res,tmpArray[sink]));
  return res;
}

