/*
 * AudioUserDpIf.h
 *
 * Storing some of the settings varies across projects. The difference is mainly due to the datapools.
 * Some settings are to be stored in to "multi" user datapool elements for some projects.
 * Here is an interface file for such settings. Each project can implement and specify the datapool for these settings, based on if the item to be personalized for each user.
 *
 * Author : prm4kor
 */
#ifndef AUDIOUSERDPIF_H_
#define AUDIOUSERDPIF_H_

#define OSAL_S_IMPORT_INTERFACE_TYPES
#include <osal_if.h>

class AudioUserDpIf
{
public:
   virtual ~AudioUserDpIf() {}


   virtual tS32 s32GetPrivateMode(tU16& u16PrivateMode)=0;
   virtual tS32 s32SetPrivateMode(tU16 u16PrivateMode)=0;


   virtual tS32 s32GetSinkID(tU16& u16PrivateMode)=0;
   virtual tS32 s32SetSinkID(tU16 u16PrivateMode)=0;


   virtual tS32 s32GetLastSourceClassOfSink(std::string &sLastSrc, tU16 sink) = 0;
   virtual tS32 s32GetLastSourceSubIDOfSink(tU16& u16SubID, tU16 Sink) = 0;

   virtual tS32 s32GetNumberOfSinks(tU8& u8Value) = 0;

   virtual tS32 s32GetTrebleMin(tS8* ps8Value, tU8 u8Size) = 0;
   virtual tS32 s32GetTrebleMax(tS8* ps8Value, tU8 u8Size) = 0;
   virtual tS32 s32GetTreble(tS8* ps8Value, tU8 u8Size) = 0;
   virtual tS32 s32GetTreble(tS8& s8Value) = 0;
   virtual tS32 s32GetTreble(tS8& s8Value, tU16 sink) = 0;

   virtual tS32 s32GetMixTreble(tS8* ps8Value, tU8 u8Size, unsigned char mic) = 0;

   virtual tS32 s32GetBassMin(tS8* ps8Value, tU8 u8Size) = 0;
   virtual tS32 s32GetBassMax(tS8* ps8Value, tU8 u8Size) = 0;
   virtual tS32 s32GetBass(tS8* ps8Value, tU8 u8Size) = 0;
   virtual tS32 s32GetBass(tS8& s8Value) = 0;
   virtual tS32 s32GetBass(tS8& s8Value, tU16 sink) = 0;

   virtual tS32 s32GetMixBass(tS8* ps8Value, tU8 u8Size, unsigned char mic) = 0;

   virtual tS32 s32GetMidRangeMin(tS8* ps8Value, tU8 u8Size) = 0;
   virtual tS32 s32GetMidRangeMax(tS8* ps8Value, tU8 u8Size) = 0;
   virtual tS32 s32GetMidRange(tS8* ps8Value, tU8 u8Size) = 0;
   virtual tS32 s32GetMidRange(tS8& s8Value) = 0;
   virtual tS32 s32GetMidRange(tS8& s8Value, tU16 sink) = 0;


   virtual tS32 s32GetBalanceMin(tS8* ps8Value, tU8 u8Size) = 0;
   virtual tS32 s32GetBalanceMax(tS8* ps8Value, tU8 u8Size) = 0;
   virtual tS32 s32GetBalance(tS8* ps8Value, tU8 u8Size) = 0;
   virtual tS32 s32GetBalance(tS8& s8Value) = 0;
   virtual tS32 s32GetBalance(tS8& s8Value, tU16 sink) = 0;


   virtual tS32 s32GetFaderMin(tS8* ps8Value, tU8 u8Size) = 0;
   virtual tS32 s32GetFaderMax(tS8* ps8Value, tU8 u8Size) = 0;
   virtual tS32 s32GetFader(tS8* ps8Value, tU8 u8Size) = 0;
   virtual tS32 s32GetFader(tS8& s8Value) = 0;
   virtual tS32 s32GetFader(tS8& s8Value, tU16 sink) = 0;


   virtual tS32 s32GetBeepLevel(tU8& u8Value) = 0;
   virtual tS32 s32GetBeepLevel(tU8& u8Value, tU16 sink) = 0;

   virtual tS32 s32GetEquPreset(tU8& u8Value) = 0;
   virtual tS32 s32GetEquPreset(tU8& u8Value, tU16 sink) = 0;

   virtual tS32 s32GetOptimization(tU8& u8Value) = 0;
   virtual tS32 s32GetOptimization(tU8& u8Value, tU16 sink) = 0;

   virtual tS32 s32GetGala(tU8& u8Value) = 0;
   virtual tS32 s32GetGala(tU8& u8Value, tU16 sink) = 0;

   virtual tS32 s32GetLoudness(tU8& u8Value) = 0;
   virtual tS32 s32GetLoudness(tU8& u8Value, tU16 sink) = 0;

   virtual tS32 s32GetSurroundLevel(tU8& u8Value) = 0;
   virtual tS32 s32GetSurroundLevel(tU8& u8Value, tU16 sink) = 0;

   virtual tS32 s32GetCenterGain(tS16& s16Value) = 0;
   virtual tS32 s32GetCenterGain(tS16& s16Value, tU16 sink) = 0;

   virtual tS32 s32GetSubwoofer(tS16& s16Value) = 0;
   virtual tS32 s32GetSubwoofer(tS16& s16Value, tU16 sink) = 0;

   virtual tS32 s32GetAutomaticGainControl(tBool& bValue) = 0;
   virtual tS32 s32GetAutomaticGainControl(tBool& bValue, tU16 sink) = 0;

   virtual tS32 s32GetRoomEffect(tU8& u8Value) = 0;
   virtual tS32 s32GetRoomEffect(tU8& u8Value, tU16 sink) = 0;

   virtual tS32 s32GetSoundStaging(tU8& u8Value) = 0;
   virtual tS32 s32GetSoundStaging(tU8& u8Value, tU16 sink) = 0;

   virtual tS32 s32GetGeometryMode(tU8& u8Value) = 0;
   virtual tS32 s32GetGeometryMode(tU8& u8Value, tU16 sink) = 0;


   virtual tS32 s32SetLastSourceClassOfSink(tString u8LastSource, tU16 Sink) = 0;
   virtual tS32 s32SetLastSourceSubIDOfSink(tU16 u16SubID, tU16 Sink) = 0;

   virtual tS32 s32SetTreble(tS8 s8Value) = 0;
   virtual tS32 s32SetTreble(tS8 s8Value, tU16 sink) = 0;

   virtual tS32 s32SetMixTreble(tS8 s8Value, tU16 sink, unsigned char mic) = 0;

   virtual tS32 s32SetBass(tS8 s8Value) = 0;
   virtual tS32 s32SetBass(tS8 s8Value, tU16 sink) = 0;

   virtual tS32 s32SetMixBass(tS8 s8Value, tU16 sink, unsigned char mic) = 0;

   virtual tS32 s32SetMidRange(tS8 s8Value) = 0;
   virtual tS32 s32SetMidRange(tS8 s8Value, tU16 sink) = 0;

   virtual tS32 s32SetBalance(tS8 s8Value) = 0;
   virtual tS32 s32SetBalance(tS8 s8Value, tU16 sink) = 0;

   virtual tS32 s32SetFader(tS8 s8Value) = 0;
   virtual tS32 s32SetFader(tS8 s8Value, tU16 sink) = 0;

   virtual tS32 s32SetBeepLevel(tU8 u8Value) = 0;
   virtual tS32 s32SetBeepLevel(tU8 u8Value, tU16 sink) = 0;

   virtual tS32 s32SetEquPreset(tU8 u8Value) = 0;
   virtual tS32 s32SetEquPreset(tU8 u8Value, tU16 sink) = 0;

   virtual tS32 s32SetOptimization(tU8 u8Value) = 0;
   virtual tS32 s32SetOptimization(tU8 u8Value, tU16 sink) = 0;

   virtual tS32 s32SetGala(tU8 u8Value) = 0;
   virtual tS32 s32SetGala(tU8 u8Value, tU16 sink) = 0;

   virtual tS32 s32SetLoudness(tU8 u8Value) = 0;
   virtual tS32 s32SetLoudness(tU8 u8Value, tU16 sink) = 0;

   virtual tS32 s32SetSurroundLevel(tU8 u8Value) = 0;
   virtual tS32 s32SetSurroundLevel(tU8 u8Value, tU16 sink) = 0;

   virtual tS32 s32SetCenterGain(tS16 s16Value) = 0;
   virtual tS32 s32SetCenterGain(tS16 s16Value, tU16 sink) = 0;

   virtual tS32 s32SetSubwoofer(tS16 s16Value) = 0;
   virtual tS32 s32SetSubwoofer(tS16 s16Value, tU16 sink) = 0;

   virtual tS32 s32SetAutomaticGainControl(tBool bValue) = 0;
   virtual tS32 s32SetAutomaticGainControl(tBool bValue, tU16 sink) = 0;

   virtual tS32 s32SetRoomEffect(tU8 u8Value) = 0;
   virtual tS32 s32SetRoomEffect(tU8 u8Value, tU16 sink) = 0;

   virtual tS32 s32SetSoundStaging(tU8 u8Value) = 0;
   virtual tS32 s32SetSoundStaging(tU8 u8Value, tU16 sink) = 0;

   virtual tS32 s32SetGeometryMode(tU8 u8Value) = 0;
   virtual tS32 s32SetGeometryMode(tU8 u8Value, tU16 sink) = 0;

   //privatemodemix volume based on sink
   virtual tS32 u32GetPrivateModeMixVolume(tU16& u16SubID, tU16 Sink) = 0;
   virtual tS32 s32SetPrivateModeMixVolume(tU16 u16SubID, tU16 Sink) = 0;

};

#endif //AUDIOUSERDPIF_H_
