/*
 * AudioUserDpINV4CV.h
 *
 * Generic implementation of AudioUserDpIf interface
 * Can be used by G3G, Suzuki etc. (where there is no "multi" user storage is needed)
 *
 * Author : prm4kor
 */

#include "../../include/controllerplugin_Trace.h"
#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

//#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AMCONTROLLERPLUGIN
#include "trcGenProj/Header/AudioUserDpINF4CV.cpp.trc.h"
#endif

#include "AudioUserDpIf.h"
#include "AudioUserDpINF4CV.h"
#include "AudioStack_dp_if.h"

#define DP_S_IMPORT_INTERFACE_FI
//#include "dp_audio_if.h"

#ifndef VARIANT_S_FTR_ENABLE_AUDIO_STACK_UTEST
#include "dp_e880_if.h"
#else
#include "dp_e880_mock_if.h"
#endif


/*****************GET FUNCTIONS**********************/

tS32 AudioUserDpINF4CV::s32GetLastSourceClassOfSink(std::string &sLastSrc , tU16 sink)
{
  ETG_TRACE_USR4(("AudioUserDpINF4CV::s32GetLastSoureClassOfSink for sink %d (MaxSize %d)",sink,Number_of_Sinks));
  dpSourceName tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  memset(tmpArray,'\0',sizeof(tmpArray));
  dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_Class oLastSource_Class;
  tS32 res =oLastSource_Class.s32GetData(tmpArray,sizeof(tmpArray)/sizeof(dpSourceName));
  ETG_TRACE_USR4(("DP read res = %d",res));

  if(sink >=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpINF4CV::s32GetLastSoureClassOfSink sink out of range"));
    return 0;
  }

  sLastSrc = tmpArray[sink].sSrcName;
  ETG_TRACE_USR4(("AudioUserDpINF4CV::s32GetLastSoureClassOfSink u8LastSource = res = %d, str = %s",res,tmpArray[sink].sSrcName));

  if(!sLastSrc.empty())
  {
    res = 1;
  }
  else
    res = 0;

  return res;
}

tS32 AudioUserDpINF4CV::s32GetLastSourceSubIDOfSink(tU16& u16SubID, tU16 sink)
{

  ETG_TRACE_USR4(("AudioUserDpINF4CV::s32GetLastSoureSubIDOfSink for sinkIndex %d",sink));
  tU16 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  memset(tmpArray,0,sizeof(tmpArray));
  dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_SubID oLastSource_SubID;
  tS32 res =oLastSource_SubID.s32GetData(tmpArray,(tU32)sizeof(tmpArray));

  if(sink >=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpINF4CV::s32GetLastSoureClassOfSink sink out of range"));
    return 0;
  }

  ETG_TRACE_USR4(("AudioUserDpINF4CV::s32GetLastSoureSubIDOfSink u16SubID = %d, res = %d",tmpArray[sink],res));
  u16SubID = tmpArray[sink];

  return res;
}


tS32 AudioUserDpINF4CV::s32GetNumberOfSinks(tU8& u8Sinks)
{
  dp_tclAudioStackMultiUsrDPNumber_of_Sinks oSinks;
  tS32 res = oSinks.s32GetData(u8Sinks);
  if(u8Sinks != Number_of_Sinks)
  {
    ETG_TRACE_ERR(("SoundHandler mismatch check Number_of_Sinks (%d) and datapool definitons Number_of_Sinks (%d)",Number_of_Sinks,(int)u8Sinks));
  }
  return res;
}

//############################# Treble ###########################
tS32 AudioUserDpINF4CV::s32GetTrebleMin(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPTreble_Min oTrebleMin;
  tS32 res = oTrebleMin.s32GetData(ps8Value,u8Size);
  return res;
}

tS32 AudioUserDpINF4CV::s32GetTrebleMax(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPTreble_Max oTrebleMax;
  tS32 res = oTrebleMax.s32GetData(ps8Value,u8Size);
  return res;
}


tS32 AudioUserDpINF4CV::s32GetTreble(tS8& s8Value)
{
  return s32GetTreble(s8Value,1);
}

tS32 AudioUserDpINF4CV::s32GetTreble(tS8& s8Value, tU16 sink)
{
  tS8 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  dp_tclAudioStackMultiUsrDPTreble oTreble;
  tS32 res =oTreble.s32GetData(tmpArray,sizeof(tmpArray));

  if(sink ==17) sink =3;
  if(sink >=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpINF4CV::s32GetTreble sink out of range"));
    return 0;
  }
  s8Value = tmpArray[sink];

  return res;
}
tS32 AudioUserDpINF4CV::s32GetTreble(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPTreble oTreble;
  tS32 res =oTreble.s32GetData(ps8Value,u8Size);

  return res;
}

tS32 AudioUserDpINF4CV::s32GetMixTreble(tS8* ps8Value, tU8 u8Size, unsigned char mic)
{
    if(mic == 1)
    {
        dp_tclAudioStackMultiUsrDPTrebleMic1 oTrebleMic;
        return oTrebleMic.s32GetData(ps8Value,u8Size);
    }
    else if(mic == 2)
    {
        dp_tclAudioStackMultiUsrDPMixTrebleMic2 oTrebleMic;
        return oTrebleMic.s32GetData(ps8Value,u8Size);
    }
    else if(mic == 3)
    {
        dp_tclAudioStackMultiUsrDPMixTrebleMic3 oTrebleMic;
        return oTrebleMic.s32GetData(ps8Value,u8Size);
    }

    ETG_TRACE_ERR(("AudioUserDpINF4CV::s32GetMixTreble wrong mic %d",mic));
    return 0;

}

//############################# Bass ###########################
tS32 AudioUserDpINF4CV::s32GetBassMin(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPBass_Min oBassMin;
  tS32 res = oBassMin.s32GetData(ps8Value,u8Size);
  return res;
}

tS32 AudioUserDpINF4CV::s32GetBassMax(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPBass_Max oBassMax;
  tS32 res = oBassMax.s32GetData(ps8Value,u8Size);
  return res;
}

tS32 AudioUserDpINF4CV::s32GetBass(tS8& s8Value)
{
  return s32GetBass(s8Value,1);
}

tS32 AudioUserDpINF4CV::s32GetBass(tS8& s8Value, tU16 sink)
{
  tS8 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  dp_tclAudioStackMultiUsrDPBass oBass;
  tS32 res =oBass.s32GetData(tmpArray,sizeof(tmpArray));

  if(sink ==17) sink =3;
  if(sink >=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpINF4CV::s32GetTreble sink out of range"));
    return 0;
  }
  s8Value = tmpArray[sink];
  return res;
}

tS32 AudioUserDpINF4CV::s32GetBass(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPBass oBass;
  tS32 res = oBass.s32GetData(ps8Value,u8Size);
  return res;
}

tS32 AudioUserDpINF4CV::s32GetMixBass(tS8* ps8Value, tU8 u8Size, unsigned char mic)
{
    if(mic == 1)
    {
        dp_tclAudioStackMultiUsrDPBassMic1 oBassMic;
        return oBassMic.s32GetData(ps8Value,u8Size);
    }
    else if(mic == 2)
    {
        dp_tclAudioStackMultiUsrDPMixBassMic2 oBassMic;
        return oBassMic.s32GetData(ps8Value,u8Size);
    }
    else if(mic == 3)
    {
        dp_tclAudioStackMultiUsrDPMixBassMic3 oBassMic;
        return oBassMic.s32GetData(ps8Value,u8Size);
    }

    ETG_TRACE_ERR(("AudioUserDpINF4CV::s32GetMixBass wrong mic %d",mic));
    return 0;

}


//############################# MidRange ###########################

tS32 AudioUserDpINF4CV::s32GetMidRangeMin(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPMidRange_Min oMidRangeMin;
  tS32 res = oMidRangeMin.s32GetData(ps8Value,u8Size);
  return res;

}
tS32 AudioUserDpINF4CV::s32GetMidRangeMax(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPMidRange_Max oMidRangeMax;
  tS32 res = oMidRangeMax.s32GetData(ps8Value,u8Size);
  return res;
}

tS32 AudioUserDpINF4CV::s32GetMidRange(tS8& s8Value)
{
  return s32GetMidRange(s8Value,1);
}
tS32 AudioUserDpINF4CV::s32GetMidRange(tS8& s8Value, tU16 sink)
{
  //ToDo take array size from number of sinks?
  tS8 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  dp_tclAudioStackMultiUsrDPMidRange oMidRange;
  tS32 res =oMidRange.s32GetData(tmpArray,sizeof(tmpArray));

  if(sink ==17) sink =3;
  if(sink >=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpINF4CV::s32GetMidRange sink out of range"));
    return 0;
  }
  s8Value = tmpArray[sink];

  return res;
}

tS32 AudioUserDpINF4CV::s32GetMidRange(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPMidRange oMidRange;
  tS32 res = oMidRange.s32GetData(ps8Value,u8Size);
  return res;
}

//############################# Balance ###########################
tS32 AudioUserDpINF4CV::s32GetBalanceMin(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPBalance_Min oBalanceMin;
  tS32 res = oBalanceMin.s32GetData(ps8Value,u8Size);
  return res;
}
tS32 AudioUserDpINF4CV::s32GetBalanceMax(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPBalance_Max oBalanceMax;
  tS32 res = oBalanceMax.s32GetData(ps8Value,u8Size);
  return res;
}
tS32 AudioUserDpINF4CV::s32GetBalance(tS8& s8Value)
{
  return s32GetBalance(s8Value,1);
}
tS32 AudioUserDpINF4CV::s32GetBalance(tS8& s8Value, tU16 sink)
{
  tS8 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  dp_tclAudioStackMultiUsrDPBalance oBalance;
  tS32 res =oBalance.s32GetData(tmpArray,sizeof(tmpArray));
  if(sink ==17) sink =3;
  if(sink >=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpINF4CV::s32GetBalance sink out of range"));
    return 0;
  }
  s8Value = tmpArray[sink];
  //return oBalance.s32GetData(s8Value);
  return res;
}

tS32 AudioUserDpINF4CV::s32GetBalance(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPBalance oBalance;
  tS32 res = oBalance.s32GetData(ps8Value,u8Size);
  return res;
}

//############################# Fader ###########################
tS32 AudioUserDpINF4CV::s32GetFaderMin(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPFader_Min oFaderMin;
  tS32 res = oFaderMin.s32GetData(ps8Value,u8Size);
  return res;
}
tS32 AudioUserDpINF4CV::s32GetFaderMax(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPFader_Max oFaderMax;
  tS32 res = oFaderMax.s32GetData(ps8Value,u8Size);
  return res;
}
tS32 AudioUserDpINF4CV::s32GetFader(tS8& s8Value)
{

  return s32GetFader(s8Value,1);
}
tS32 AudioUserDpINF4CV::s32GetFader(tS8& s8Value, tU16 sink)
{
  tS8 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  dp_tclAudioStackMultiUsrDPFader oFader;
  tS32 res =oFader.s32GetData(tmpArray,sizeof(tmpArray));
  if(sink ==17) sink =3;
  if(sink >=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpINF4CV::s32GetBalance sink out of range"));
    return 0;
  }
  s8Value = tmpArray[sink];
  //return oFader.s32GetData(s8Value);
  return res;
}
tS32 AudioUserDpINF4CV::s32GetFader(tS8* ps8Value, tU8 u8Size)
{
  dp_tclAudioStackMultiUsrDPFader oFader;
  tS32 res = oFader.s32GetData(ps8Value,u8Size);
  return res;
}

//################################## others, not yet supported ################
tS32 AudioUserDpINF4CV::s32GetBeepLevel(tU8& u8Value)
{
  return s32GetBeepLevel(u8Value,1);
}
tS32 AudioUserDpINF4CV::s32GetBeepLevel(tU8& u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpINF4CV::s32GetEquPreset(tU8& u8Value)
{
  return s32GetEquPreset(u8Value,1);
}
tS32 AudioUserDpINF4CV::s32GetEquPreset(tU8& u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpINF4CV::s32GetOptimization(tU8& u8Value)
{
  return s32GetOptimization(u8Value,1);
}
tS32 AudioUserDpINF4CV::s32GetOptimization(tU8& u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpINF4CV::s32GetGala(tU8& u8Value)
{
  return s32GetGala(u8Value,1);
}
tS32 AudioUserDpINF4CV::s32GetGala(tU8& u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpINF4CV::s32GetLoudness(tU8& u8Value)
{
  return s32GetLoudness(u8Value,1);
}
tS32 AudioUserDpINF4CV::s32GetLoudness(tU8& u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpINF4CV::s32GetSurroundLevel(tU8& u8Value)
{
  return s32GetSurroundLevel(u8Value,1);
}
tS32 AudioUserDpINF4CV::s32GetSurroundLevel(tU8& u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpINF4CV::s32GetCenterGain(tS16& s16Value)
{
  return s32GetCenterGain(s16Value,1);
}
tS32 AudioUserDpINF4CV::s32GetCenterGain(tS16& s16Value, tU16 sink)
{
	(void)s16Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpINF4CV::s32GetSubwoofer(tS16& s16Value)
{
  return s32GetSubwoofer(s16Value,1);
}
tS32 AudioUserDpINF4CV::s32GetSubwoofer(tS16& s16Value, tU16 sink)
{
	(void)s16Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpINF4CV::s32GetAutomaticGainControl(tBool& bValue)
{
  return s32GetAutomaticGainControl(bValue,1);
}
tS32 AudioUserDpINF4CV::s32GetAutomaticGainControl(tBool& bValue, tU16 sink)
{
	(void)bValue;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpINF4CV::s32GetRoomEffect(tU8& u8Value)
{
  return s32GetRoomEffect(u8Value,1);
}
tS32 AudioUserDpINF4CV::s32GetRoomEffect(tU8& u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpINF4CV::s32GetSoundStaging(tU8& u8Value)
{
  return s32GetSoundStaging(u8Value,1);
}
tS32 AudioUserDpINF4CV::s32GetSoundStaging(tU8& u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpINF4CV::s32GetGeometryMode(tU8& u8Value)
{
  return s32GetGeometryMode(u8Value,1);
}
tS32 AudioUserDpINF4CV::s32GetGeometryMode(tU8& u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}
/*****************SET FUNCTIONS**********************/

tS32 AudioUserDpINF4CV::s32GetPrivateMode(tU16& u16PrivateMode)
{
  dp_tclAudioStackMultiDPPrivateMode oDPPrivateMode;
  return oDPPrivateMode.s32GetData(u16PrivateMode);
}

tS32 AudioUserDpINF4CV::s32SetPrivateMode(tU16 u16PrivateMode)
{
   dp_tclAudioStackMultiDPPrivateMode oDPPrivateMode;
   return oDPPrivateMode.s32SetData(u16PrivateMode);
}


tS32 AudioUserDpINF4CV::s32GetSinkID(tU16& u16PrivateMode)
{
	(void)u16PrivateMode;
  return 0;
}

tS32 AudioUserDpINF4CV::s32SetSinkID(tU16 u16PrivateMode)
{
(void)u16PrivateMode;
  return 0;
}



tS32 AudioUserDpINF4CV::s32SetLastSourceClassOfSink(tString u8LastSource, tU16 sink)
{
  ETG_TRACE_USR4(("AudioUserDpINF4CV::s32SetLastSoureClassOfSink for sinkIndex %d (MaxSize %d)",sink,Number_of_Sinks));
  dpSourceName tmpArray[Number_of_Sinks]; //max possible in system
  memset(tmpArray,'\0',sizeof(tmpArray));
  dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_Class oLastSource_Class;
  tS32 res =oLastSource_Class.s32GetData(tmpArray,sizeof(tmpArray)/sizeof(dpSourceName));
  ETG_TRACE_USR4(("DP read res = %d",res));

  if(sink==17) sink =(tU16)3;  //Hack Sink17 to be 3

  if(sink>=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpINF4CV::s32SetLastSoureClassOfSink sink out of Range"));
    return 0;
  }

  memset(tmpArray[sink].sSrcName,'\0',sizeof(tmpArray[sink].sSrcName));
  strncpy(tmpArray[sink].sSrcName, u8LastSource , MAX_SRC_LEN);


  res = oLastSource_Class.s32SetData(tmpArray,sizeof(tmpArray)/sizeof(dpSourceName));
  ETG_TRACE_USR4(("DP write res = %d",res));

  //O.K. now just read immediately back for test
  memset(tmpArray,0,sizeof(tmpArray));
  oLastSource_Class.s32GetData(tmpArray,sizeof(tmpArray)/sizeof(dpSourceName));

  ETG_TRACE_USR4(("DP read_back res = %d and source %s",res,tmpArray[sink].sSrcName));

  return res;
  //return oLastSource_Class.s32SetData(tmpArray,sizeof(tmpArray));

}

tS32 AudioUserDpINF4CV::s32SetLastSourceSubIDOfSink(tU16 u16SubID, tU16 sink)
{
  ETG_TRACE_USR4(("AudioUserDpINF4CV::s32SetLastSoureSubIDOfSink for sinkIndex %d",sink));
  tU16 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  memset(tmpArray,0,sizeof(tmpArray));
  dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_SubID oLastSource_SubID;
  tS32 res =oLastSource_SubID.s32GetData(tmpArray,(tU32)Number_of_Sinks);



  if(sink>=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpINF4CV::s32SetLastSourceSubIDOfSink sink out of Range"));
    return 0;
  }
  tmpArray[sink] = u16SubID;
  res = oLastSource_SubID.s32SetData(tmpArray,Number_of_Sinks);
  return res;
}


tS32 AudioUserDpINF4CV::s32SetTreble(tS8 s8Value)
{
  return s32SetTreble(s8Value,1);
}
tS32 AudioUserDpINF4CV::s32SetTreble(tS8 s8Value, tU16 sink)
{
  tS8 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  memset(tmpArray,0,sizeof(tmpArray));
  dp_tclAudioStackMultiUsrDPTreble oTreble;
  //tS32 res =oTreble.s32GetData(tmpArray,sizeof(tmpArray));
  (void)oTreble.s32GetData(tmpArray,sizeof(tmpArray));

  if(sink==17) sink =(tU16)3;  //Hack Sink17 to be 3

  if(sink>=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpINF4CV::s32SetTreble sink out of Range"));
    return 0;
  }
  tmpArray[sink] = s8Value;
  //return oTreble.s32SetData(s8Value);
  return oTreble.s32SetData(tmpArray,sizeof(tmpArray));
}

tS32 AudioUserDpINF4CV::s32SetMixTreble(tS8 s8Value, tU16 sink, unsigned char mic)
{
    ETG_TRACE_USR4(("s32SetMixTreble for mic %d, called with value %d for sink %d",mic,s8Value,sink));

    tS8 tmpArray[Number_of_Sinks];
    memset(tmpArray,0,sizeof(tmpArray));

    dp_tclAudioStackMultiUsrDPTrebleMic1 oMixTrebleMic1;    // this does not use the MIX TREBLE Property
    dp_tclAudioStackMultiUsrDPMixTrebleMic2 oMixTrebleMic2;
    dp_tclAudioStackMultiUsrDPMixTrebleMic3 oMixTrebleMic3;

    if(mic==1)      (void)oMixTrebleMic1.s32GetData(tmpArray,sizeof(tmpArray));
    else if(mic==2) (void)oMixTrebleMic2.s32GetData(tmpArray,sizeof(tmpArray));
    else if(mic==3) (void)oMixTrebleMic3.s32GetData(tmpArray,sizeof(tmpArray));
    else return 0;

    ETG_TRACE_USR4(("s32SetMixTrebleMic%d dump tmpArray after DP read",mic));
    for(unsigned int i=0;i<Number_of_Sinks;i++)
    {
        ETG_TRACE_USR4(("tmpArray[%d] = %d",i,tmpArray[i]));
    }
    ETG_TRACE_USR4(("s32SetMixTreble dump tmpArray end"));

    if(sink==17) sink =(tU16)3;  //Hack Sink17 to be 3

    if(sink>=Number_of_Sinks)
    {
        ETG_TRACE_ERR(("AudioUserDpINF4CV::s32SetMixTreble sink out of Range"));
        return 0;
    }
    tmpArray[sink] = s8Value;
    ETG_TRACE_USR4(("Writing back tmpArray[%d] = %d",sink,s8Value));

    if(mic==1)      return oMixTrebleMic1.s32SetData(tmpArray,sizeof(tmpArray));
    else if(mic==2) return oMixTrebleMic2.s32SetData(tmpArray,sizeof(tmpArray));
    else if(mic==3) return oMixTrebleMic3.s32SetData(tmpArray,sizeof(tmpArray));

    return 0;
}

tS32 AudioUserDpINF4CV::s32SetBass(tS8 s8Value)
{
  return s32SetBass(s8Value,1);
}
tS32 AudioUserDpINF4CV::s32SetBass(tS8 s8Value, tU16 sink)
{
  tS8 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  memset(tmpArray,0,sizeof(tmpArray));
  dp_tclAudioStackMultiUsrDPBass oBass;
  //tS32 res =oBass.s32GetData(tmpArray,sizeof(tmpArray));
  (void)oBass.s32GetData(tmpArray,sizeof(tmpArray));

  if(sink==17) sink =(tU16)3;  //Hack Sink17 to be 3

  if(sink>=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpINF4CV::s32SetBass sinkIndex %d out of Range",sink));
    return 0;
  }
  tmpArray[sink] = s8Value;
  //return oBass.s32SetData(s8Value);
  return oBass.s32SetData(tmpArray,sizeof(tmpArray));
}

tS32 AudioUserDpINF4CV::s32SetMixBass(tS8 s8Value, tU16 sink, unsigned char mic)
{
	ETG_TRACE_USR4(("s32SetMixBass for mic %d, called with value %d for sink %d",mic,s8Value,sink));

	tS8 tmpArray[Number_of_Sinks];
	memset(tmpArray,0,sizeof(tmpArray));

	dp_tclAudioStackMultiUsrDPBassMic1 oMixBassMic1;    //this does note use the MixBass Property
	dp_tclAudioStackMultiUsrDPMixBassMic2 oMixBassMic2;
	dp_tclAudioStackMultiUsrDPMixBassMic3 oMixBassMic3;

	if(mic==1)      (void)oMixBassMic1.s32GetData(tmpArray,sizeof(tmpArray));
	else if(mic==2) (void)oMixBassMic2.s32GetData(tmpArray,sizeof(tmpArray));
	else if(mic==3) (void)oMixBassMic3.s32GetData(tmpArray,sizeof(tmpArray));
	else return 0;

	ETG_TRACE_USR4(("s32SetMixBassMic%d dump tmpArray after DP read",mic));
	for(unsigned int i=0;i<Number_of_Sinks;i++)
	{
		ETG_TRACE_USR4(("tmpArray[%d] = %d",i,tmpArray[i]));
	}
	ETG_TRACE_USR4(("s32SetMixBass dump tmpArray end"));

	if(sink==17) sink =(tU16)3;  //Hack Sink17 to be 3

	if(sink>=Number_of_Sinks)
	{
		ETG_TRACE_ERR(("AudioUserDpINF4CV::s32SetMixBass sinkIndex %d out of Range",sink));
		return 0;
	}
	tmpArray[sink] = s8Value;
	ETG_TRACE_USR4(("Writing back tmpArray[%d] = %d",sink,s8Value));

    if(mic==1)      return oMixBassMic1.s32SetData(tmpArray,sizeof(tmpArray));
    else if(mic==2) return oMixBassMic2.s32SetData(tmpArray,sizeof(tmpArray));
    else if(mic==3) return oMixBassMic3.s32SetData(tmpArray,sizeof(tmpArray));

    return 0;
}

tS32 AudioUserDpINF4CV::s32SetMidRange(tS8 s8Value)
{
  return s32SetMidRange(s8Value,1);
}
tS32 AudioUserDpINF4CV::s32SetMidRange(tS8 s8Value, tU16 sink)
{
  tS8 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  memset(tmpArray,0,sizeof(tmpArray));
  dp_tclAudioStackMultiUsrDPMidRange oMidRange;
  //tS32 res =oMidRange.s32GetData(tmpArray,sizeof(tmpArray));
  (void)oMidRange.s32GetData(tmpArray,sizeof(tmpArray));

  if(sink==17) sink =(tU16)3;  //Hack Sink17 to be 3

  if(sink>=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpINF4CV::s32SetMidRange sinkIndex out of Range"));
    return 0;
  }

  tmpArray[sink] = s8Value;
  //return oMidRange.s32SetData(s8Value);
  return oMidRange.s32SetData(tmpArray,sizeof(tmpArray));
}

tS32 AudioUserDpINF4CV::s32SetBalance(tS8 s8Value)
{
  return s32SetBalance(s8Value,1);
}
tS32 AudioUserDpINF4CV::s32SetBalance(tS8 s8Value, tU16 sink)
{
  tS8 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  memset(tmpArray,0,sizeof(tmpArray));
  dp_tclAudioStackMultiUsrDPBalance oBalance;
  //tS32 res =oBalance.s32GetData(tmpArray,sizeof(tmpArray));
  (void)oBalance.s32GetData(tmpArray,sizeof(tmpArray));

  if(sink==17) sink =(tU16)3;  //Hack Sink17 to be 3

  if(sink>=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpINF4CV::s32SetBalance sinkIndex %d out of Range",sink));
    return 0;
  }

  tmpArray[sink] = s8Value;
  //return oBalance.s32SetData(s8Value);
  return oBalance.s32SetData(tmpArray,sizeof(tmpArray));
}

tS32 AudioUserDpINF4CV::s32SetFader(tS8 s8Value)
{
  return s32SetFader(s8Value,1);
}
tS32 AudioUserDpINF4CV::s32SetFader(tS8 s8Value, tU16 sink)
{
  tS8 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  memset(tmpArray,0,sizeof(tmpArray));
  dp_tclAudioStackMultiUsrDPFader oFader;
  //tS32 res =oFader.s32GetData(tmpArray,sizeof(tmpArray));
  (void)oFader.s32GetData(tmpArray,sizeof(tmpArray));

  if(sink==17) sink =(tU16)3;  //Hack Sink17 to be 3

  if(sink>=Number_of_Sinks)
  {
    ETG_TRACE_ERR(("AudioUserDpINF4CV::s32SetFader sinkIndex %d out of Range",sink));
    return 0;
  }
  tmpArray[sink] = s8Value;
  return oFader.s32SetData(tmpArray,sizeof(tmpArray));
}

tS32 AudioUserDpINF4CV::s32SetBeepLevel(tU8 u8Value)
{
  return s32SetBeepLevel(u8Value,1);
}
tS32 AudioUserDpINF4CV::s32SetBeepLevel(tU8 u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpINF4CV::s32SetEquPreset(tU8 u8Value)
{
  return s32SetEquPreset(u8Value,1);
}
tS32 AudioUserDpINF4CV::s32SetEquPreset(tU8 u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpINF4CV::s32SetOptimization(tU8 u8Value)
{
  return s32SetOptimization(u8Value,1);
}
tS32 AudioUserDpINF4CV::s32SetOptimization(tU8 u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;

  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpINF4CV::s32SetGala(tU8 u8Value)
{
  return s32SetGala(u8Value,1);
}
tS32 AudioUserDpINF4CV::s32SetGala(tU8 u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpINF4CV::s32SetLoudness(tU8 u8Value)
{
  return s32SetLoudness(u8Value,1);
}
tS32 AudioUserDpINF4CV::s32SetLoudness(tU8 u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpINF4CV::s32SetSurroundLevel(tU8 u8Value)
{
  return s32SetSurroundLevel(u8Value,1);
}
tS32 AudioUserDpINF4CV::s32SetSurroundLevel(tU8 u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpINF4CV::s32SetCenterGain(tS16 s16Value)
{
  return s32SetCenterGain(s16Value,1);
}
tS32 AudioUserDpINF4CV::s32SetCenterGain(tS16 s16Value, tU16 sink)
{
	(void)s16Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpINF4CV::s32SetSubwoofer(tS16 s16Value)
{
  return s32SetSubwoofer(s16Value,1);
}
tS32 AudioUserDpINF4CV::s32SetSubwoofer(tS16 s16Value, tU16 sink)
{
	(void)s16Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpINF4CV::s32SetAutomaticGainControl(tBool bValue)
{
  return s32SetAutomaticGainControl(bValue,1);
}
tS32 AudioUserDpINF4CV::s32SetAutomaticGainControl(tBool bValue, tU16 sink)
{
	(void)bValue;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpINF4CV::s32SetRoomEffect(tU8 u8Value)
{
  return s32SetRoomEffect(u8Value,1);
}
tS32 AudioUserDpINF4CV::s32SetRoomEffect(tU8 u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;

  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpINF4CV::s32SetSoundStaging(tU8 u8Value)
{
  return s32SetSoundStaging(u8Value,1);
}
tS32 AudioUserDpINF4CV::s32SetSoundStaging(tU8 u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

tS32 AudioUserDpINF4CV::s32SetGeometryMode(tU8 u8Value)
{
  return s32SetGeometryMode(u8Value,1);
}
tS32 AudioUserDpINF4CV::s32SetGeometryMode(tU8 u8Value, tU16 sink)
{
	(void)u8Value;
	(void)sink;
  //Needed??
  return (tS32)0;
}

//privatemodemix volume based on sink
tS32 AudioUserDpINF4CV::u32GetPrivateModeMixVolume(tU16& u16PrivateModeMixVolume, tU16 Sink)
{
  ETG_TRACE_USR4(("AudioUserDpINF4CV::u32GetPrivateModeMixVolume for sinkIndex %d (MaxSize %d)",Sink,Number_of_Sinks));
  tU16 tmpArray[Number_of_Sinks]; //ToDo get number of sinks from somewhere (DP KDS ??) Array size is number of sink +1 (ignore inikID 0 ?)
  memset(tmpArray,0,sizeof(tmpArray));
  dp_tclAudioStackMultiDPPrivateModeMixVolume oPrivateModeMixVol;
  tS32 res =oPrivateModeMixVol.s32GetData(tmpArray,sizeof(tmpArray)/sizeof(tU16));
  ETG_TRACE_USR4(("DP read res = %d",res));

  if(Sink >=Number_of_Sinks)
  {
      ETG_TRACE_ERR(("AudioUserDpINF4CV::s32GetLastSoureClassOfSink sinkIndex out of range"));
      return 0;
  }

  u16PrivateModeMixVolume = tmpArray[Sink];
  ETG_TRACE_USR4(("AudioUserDpINF4CV::s32GetLastSoureClassOfSink u8LastSource u16PrivateModeMixVolume = %d",u16PrivateModeMixVolume));
  return res;
}

tS32 AudioUserDpINF4CV::s32SetPrivateModeMixVolume(tU16 u16PrivateModeMixVolume, tU16 sink)
{
  ETG_TRACE_USR4(("AudioUserDpINF4CV::s32SetPrivateModeMixVolume for sinkIndex %d (MaxSize %d)",sink,Number_of_Sinks));
  tU16 tmpArray[Number_of_Sinks]; //max possible in system
  memset(tmpArray,0,sizeof(tmpArray));
  dp_tclAudioStackMultiDPPrivateModeMixVolume oPrivateModeMixVol;
  tS32 res =oPrivateModeMixVol.s32GetData(tmpArray,sizeof(tmpArray)/sizeof(tU16));
  ETG_TRACE_USR4(("DP read res = %d",res));

    if(sink>=Number_of_Sinks)
  {
      ETG_TRACE_ERR(("AudioUserDpINF4CV::s32SetLastSoureClassOfSink sinkIndex out of Range"));
      return 0;
  }

  tmpArray[sink] = u16PrivateModeMixVolume;

  res = oPrivateModeMixVol.s32SetData(tmpArray,sizeof(tmpArray)/sizeof(tU16));
  ETG_TRACE_USR4(("DP write res = %d",res));

    //O.K. now just read immediately back for test
  memset(tmpArray,0,sizeof(tmpArray));
  res = oPrivateModeMixVol.s32GetData(tmpArray,sizeof(tmpArray)/sizeof(tU16));

  ETG_TRACE_USR4(("DP read_back res = %d sinkIndex %d value %d",res,sink,tmpArray[sink]));
  return res;
}

