/*
 * Macro.h
 *
 *  Created on: 31.05.2012
 *      Author: mor2hi
 */

#ifndef MACRO_H_
#define MACRO_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AUD_POINTER_CHECK_CALL(ptr) if ( OSAL_NULL == ptr ) \
   {\
   return (0);\
   }

#define AUD_POINTER_CHECK_CALL_NO_RET_VALUE(ptr) if ( OSAL_NULL == ptr ) \
   {\
   return;\
   }

#define AUD_POINTER_CHECK_FATAL_ON_NULL_NO_RET(ptr) if (OSAL_NULL == ptr) \
   {\
      FATAL_M_ASSERT_ALWAYS();\
      return;\
   }
#define AUD_POINTER_CHECK_FATAL_ON_NULL(ptr) if (OSAL_NULL == ptr) \
   {\
      FATAL_M_ASSERT_ALWAYS();\
      return (0);\
   }

//lint -emacro(572, AUD_SET_U16) prio2: Excessive shift
//lint -emacro(778, AUD_SET_U16) prio2: Constant expression evaluates to 0 in operation '>>'
#define AUD_GET_U16(pu8) ((tU16)(((tU16)((pu8)[0])<<8) + (pu8)[1]))
#define AUD_SET_U16(pu8, u16)   \
      (pu8)[0]=(tU8)(((tU16)(u16)>>8) & 0xFF);         \
      (pu8)[1]=(tU8)(((tU16)(u16))    & 0xFF);

#endif /* MACRO_H_ */
