/************************************************************************
 * FILE:         fc_audiomanager_trace.h
 * PROJECT:      LCN2kai
 * SW-COMPONENT: DemoServer
 *----------------------------------------------------------------------
 *
 * DESCRIPTION: handle trace outputs efficiently
 * This class is used as template for all middleware server to provide
 * trace output in an efficient way.
 *
 * Places where the code may be enhanced is marked with:
 *  / * +++  Enter your private Data and functions here +++ * /
 *
 * copy header and cpp into your directory and replace "ipod_" at all
 * occrences.
 *
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2007 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author            | Modification
 * 2007-09-10| M. Hessling       | initial version
 *************************************************************************/
#ifndef FC_AUDIOMANAGER_TCLTRACE_H
#define FC_AUDIOMANAGER_TCLTRACE_H


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
//#if defined (__AUDIO_UNIT_TESTING__)
//#include "../UnitTest/AudioManager_GUTest/Mock/trace_if.h"
//#endif

//  tri_types.h (di_trace) -> not used!
#include "trace_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

/******************************************************************************/
enum tenTrcTraceClassfc_audiomanager {
   TR_CLASS_FC_AUDIOMANAGER_APPLICATION = TR_COMP_AUDIOMANAGEMENT + 0,
   TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION = TR_COMP_AUDIOMANAGEMENT + 1,
   TR_CLASS_FC_AUDIOMANAGER_AUDIO_DIAGNOSIS = TR_COMP_AUDIOMANAGEMENT + 2,
   TR_CLASS_FC_AUDIOMANAGER_TRACE = TR_COMP_AUDIOMANAGEMENT + 3,
   TR_CLASS_FC_AUDIOMANAGER_INTERNALCOMADAPTER = TR_COMP_AUDIOMANAGEMENT + 4,
   TR_CLASS_FC_AUDIOMANAGER_VOLUME = TR_COMP_AUDIOMANAGEMENT + 5,
   TR_CLASS_HMI_POSTOFFICE = TR_COMP_AUDIOMANAGEMENT + 6,
   TR_CLASS_FC_AUDIOMANAGER_SOUND = TR_COMP_AUDIOMANAGEMENT + 7,
   TR_CLASS_FC_AUDIOMANAGER_SOUND_TOOL_CLIENT = TR_COMP_AUDIOMANAGEMENT + 8,
   // This trace class is only used to communicate with Soundtool on PC via TTFisLib.dll
   TR_CLASS_SOUND_TOOL_COMMUNICATION = TR_COMP_AUDIOMANAGEMENT + 9,
   TR_CLASS_FC_AUDIOMANAGER_CLIPPING= TR_COMP_AUDIOMANAGEMENT + 16,
   TR_CLASS_FC_AUDIOMANAGER_BEEP= TR_COMP_AUDIOMANAGEMENT + 17,
   TR_CLASS_FC_AUDIOMANAGER_FADING= TR_COMP_AUDIOMANAGEMENT + 18,
   TR_CLASS_FC_AUDIOMANAGER_SDVC= TR_COMP_AUDIOMANAGEMENT + 19,
   TR_CLASS_FC_AUDIOMANAGER_MIC_DIAGNOSIS = TR_COMP_AUDIOMANAGEMENT + 20,
   // ###### remember we have also ARL Trace classes defined as follow #######
   // #define TR_COMP_ARL                 (TR_COMP_AUDIOMANAGEMENT + 10)
   // ########################################################################
   TR_CLASS_CONTROLLER_VOLUME = TR_COMP_AUDIOMANAGEMENT + 0x30,

   TR_CLASS_AUD_SINKMGR_APPLICATION = TR_COMP_AUDIOMANAGEMENT + 80,
   TR_CLASS_AUD_SINKMGR_CLIENTHANDLER_MEDIAPLAYER = TR_COMP_AUDIOMANAGEMENT + 81,
   TR_CLASS_AUD_SINKMGR_SERVICE_AUDIOROUTEMGR = TR_COMP_AUDIOMANAGEMENT + 82,
   TR_CLASS_AUD_SINKMGR_TRACE = TR_COMP_AUDIOMANAGEMENT + 83,
   TR_CLASS_VD_ADR3MSG_IF = TR_COMP_AUDIOMANAGEMENT + 84,
   TR_CLASS_VD_ADR3_IF = TR_COMP_AUDIOMANAGEMENT + 85,
   TR_CLASS_VD_ADR3_MAIN = TR_COMP_AUDIOMANAGEMENT + 86,
   TR_CLASS_VD_ADR3_PAYLOAD= TR_COMP_AUDIOMANAGEMENT + 87,
   TR_CLASS_FC_AUDIOMANAGER_VOLUME_DBCALC = TR_COMP_AUDIOMANAGEMENT + 88,
   TR_CLASS_FC_AUDIOMANAGER_SPEAKER_DIAGNOSIS = TR_COMP_AUDIOMANAGEMENT + 89,
   TR_CLASS_FC_AUDIOMANAGER_TUNING_DATA_SERVICE = TR_COMP_AUDIOMANAGEMENT + 90,
   TR_CLASS_FC_AUDIOMANAGER_ARKAMYS = TR_COMP_AUDIOMANAGEMENT + 91,
   TR_CLASS_FC_AUDIOMANAGER_VEHICLEDOMAIN = TR_COMP_AUDIOMANAGEMENT + 92,
   TR_CLASS_FC_AUDIOMANAGER_ENGINESOUND = TR_COMP_AUDIOMANAGEMENT + 93,
   TR_CLASS_FC_AUDIOMANAGER_REAR_MUTE = TR_COMP_AUDIOMANAGEMENT + 94,
   TR_CLASS_VD_ADR3MSG_MUTECHANNEL = TR_COMP_AUDIOMANAGEMENT + 95,
   TR_CLASS_AUDIOMANAGER_AUDPROCPROXY = TR_COMP_AUDIOMANAGEMENT + 96,
   // ### to be used by other components e.g. SPI as well ####
   TR_CLASS_AUDIO_SRC_CHANGE_MEAS = 0x7FF0
};

namespace TRC
{
   enum tenTrcCompInput
   {
      enSinkMgr = 0,
      enAudMgrApp = 1,
      enAudMgrServiceAudioFunc = 2,
      enAdr3MsgIf = 3,
      enSoundToolClient          = 4,
      enSoundToolPropertyIF_Base = 5,
      enClientHandlerPhone = 6,
      enSoundToolClient_MIB          = 7,
      enAmpIf = 8,
      enVehicleDomainHandler = 9,
    enBeepFilePlayer = 10,
    enAudioTuning = 11,
    //enBeepCSMIf = 12,
    enAudioProcessProxy = 13,
    enECNRProxy = 14,
      enMAX_INTRACE_NAMES
   };

   // used for subComponent enSinkMgr
   enum tenTrcFuncIn_SinkMgr
   {
      SendAdrData = 1,
      SendGpioData = 2,
      PrintSoundConfigFile = 8
   };
  // all defines for SoundTool communication
  enum tenTrcParam_SoundToolClient
   {
      MsgCode     = 1, //u8
      PropertyID  = 2, //u8
      Value       = 3, //u16
      Sum         = 5
  };
  enum tenTrcFuncIn_SoundToolClient
   {
      SetConfigFile           = 0x02,
      GetConfigFile           = 0x03,
      SaveConfigFile          = 0x04,
      GetPropertyListLength   = 0x1D,
      SetProperty             = 0x1E,
      GetProperty             = 0x1F
  };
   // used for subComponent enAudMgrApp
   enum tenTrcFuncIn_AudMgrApp
   {
   };

   // used for subComponent enAudMgrServiceAudioFunc
   // these defines must match the commands of fc_audiomanager.trc
   // the value is the reference for CMD AUDIOMANAGER_... ::0f ff 02 89 02 XX
   enum tenTrcFuncIn_AudSrvFun
   {
      enSetAudioSource = 2,
      enSetAmpDeviceAudioRoute= 3,
      enSetVolume = 4,
      enSetVolumeMode = 5,
      NotifyADRMute = 7,
      ARMMute = 8,
      SetBeep = 9,
      AudioTestTone = 10,
      enSetSource = 11,
      enSetCCAAudioSource = 12,
      enSetPowerState = 13,
      SetAuxInLevel = 14,
      CCA_Cue = 15,
      enIntSource = 16,
      enSetSourceType = 17,
     SpeedStatus     = 18,
     enAudLinSetting_HMI = 19,
     enAudLinSetting_Diagnostics = 20,
     enDiagAudioGain = 21,
     RemoteSession = 22,
     PerformOnVolumeLimit = 23,
     PDCAttenuation = 24,
     PDCAttenuationLevel = 25,
     VolumeLock = 26,
     InputGainOffset = 27,
     OverTempReduction = 28,
     DiagnosisSpeaker =29,
     SpiAttenuation = 30,
     SpeakerDiagnosisStart = 31,
     BeepLevel = 32,
     ArkamysSetParameter = 33,
     ArkamysDebug = 34,
     ArkamysFeature = 35,
     EngineSoundVersion = 36,
   BeepFromFile = 37,
   SetSoundProperty = 38,
   SetSoundSystemConfig = 39,
   EngineSoundFeature = 40,
   SetAdasBeep = 41,
   AmpAvailability = 42,
   SetOnEntVol = 43,
   GetDiagResult = 44
   };
   enum tenTrcFuncIn_Adr3MsgIf
   {
      enADRResponse = 0,
      enADRDataCon,
      enADRArkamysFunc,
      enADRArkamysVolume,
      enADREngineSoundFunc
   };

   enum tenTrcSoundProperty
   {
      enBass = 0,
      enTreble,
      enMiddle,
      enFader,
      enEqualizer,
    enGala,
    enBalance,
    enOptimization,
    enSurround,
    enAudioPilot,
    enStaging,
    enLoudness,
    enRoomEffect,
    enAGC,
    enMidRange,
    enSubwoofer
   };

   enum tenTrcBeepSpeaker
   {
    enNone=0,
      enLF = 1,
      enRF = 2,
      enLR = 4,
      enRR = 8,
    enCE = 16,
    enSUB = 32,
    enFront = 3,
    enRear = 12,
    enCenter_sub = 48,
    enAll = 63
   };

   enum tenTrcFuncIn_AmpMsgIf
      {
     enAmpResponse = 1
   };
   // Only for measuring src change timing, needed by different moduls
   enum tenTrcAudioSrcChangeMeas_Module
   {
     enModule_fc_audiomanager=1,
     enModule_Reserved
   };
   enum tenTrcAudioSrcChangeMeas_File
   {
     enFile_vd_adr3Msg_mute = 1,
     enFile_Reserved
     //enFile_Reserved
   };
   enum tenTrcAudioSrcChangeMeas_Fkt
   {
     enFkt_vSendADRResponse = 1,
     enFkt_Reserved
     //enFkt_Reserved
   };
   enum tenTrcFuncIn_VehicleDomain
   {
     enVehicleDomainResponse = 0
   };

   enum tenTrcFuncIn_TuningData
   {
     enAudioTuningFunc = 0
   };

   //BeepPlayer Trace enums
   enum tenTrcBeepFilePlayStatus
   {
   enFilePlaying = 4,
   enFilePaused = 3,
   enFileReady = 2,
   enFileStopped = 1
   };
   enum tenTrcFuncIn_CSMMsgIf
   {
      enCSMResponse = 1
   };
}

class fc_audiomanager_tclTraceInput; // interface for receiving TTFis inputs
/*----------------------------------- trace channel comunication-------------------*/
class fc_audiomanager_tclTraceChannel
{
public:
   fc_audiomanager_tclTraceChannel();
   virtual ~fc_audiomanager_tclTraceChannel();

   // Receive the data
   static tVoid vTrace_Rx_Callback(tPCUChar pcu8Data);
   static tVoid vTrace_Rx(tU32 size, tPCUChar pcu8Data);

   // at runtime application adds intefaces to the call back interface
   tVoid vRegisterTraceService(tU32 uInputNum, fc_audiomanager_tclTraceInput* pclInput) const;

   // at runtime application activates the trace channel with the right id
   tVoid vRegisterTraceCallBack(TR_tenTraceChan eChan );

   // when closing the applicaiton call back and trace channel are closed with it
   tVoid vUnregisterTraceCallBack(tVoid) const;

private:

   //forbidden
   fc_audiomanager_tclTraceChannel(const fc_audiomanager_tclTraceChannel& rhs);//lint !e1704 prio3 reviewed: constructor has private access specification: its use is forbidden
   fc_audiomanager_tclTraceChannel& operator=(const fc_audiomanager_tclTraceChannel& rhs);

   // channel number is stored to be able to close without second time transmitting
   // the parameter
   TR_tenTraceChan _eChannel;

   // the channel is reentrant however the second instance will have to close
   // the first channel because we have foreseen only one.
   static OSAL_tIODescriptor _fdTrace;

   // trace input interface list
   // used to switch into the different services, clienthandler or main class
   // number is fixed because we know where we want to use it
   static fc_audiomanager_tclTraceInput* _paReceiver[TRC::enMAX_INTRACE_NAMES];

}; // class trace channel
#endif // FC_AUDIOMANAGER_TCLTRACE_H
