/*
 * IF_MessageObserver.h
 *
 *  Created on: 03.02.2012
 *      Author: vo84hi
 */

#ifndef IF_MESSAGEOBSERVER_H_
#define IF_MESSAGEOBSERVER_H_

/**
 * Pure virtual class defining the Inferface
 * of MessageObservers
 */
template <typename msgIDType>
class IF_MessageObserver
{
protected:
   const char *m_name;

public:
     /**
      *This Method is called by PostOffice when new Messages are incoming
      * @param msgID new Messages with the given ID are incoming
      */
     virtual void MessageNotification(msgIDType msgID) = 0;
     virtual ~IF_MessageObserver() {m_name = NULL;}
     /**
      * @param name a Name for identification, e.g. in Traces
      */
     IF_MessageObserver(const char *name) : m_name(name) {}
     const char* getName() {return m_name;}
};

#endif /* IF_MESSAGEOBSERVER_H_ */
