
#ifndef POSTOFFICE_BASEMESSAGE_H_
#define POSTOFFICE_BASEMESSAGE_H_

#include "Message.h"
/**
 * @brief Abstract Base class for Messages that are delivered by PostOffice
 *
 */
template <typename ID>
class BaseMessage : public Message<ID>
{
public:

  /**
   *
   * @param msgID The Message ID which Observers will register by
   * PostOffice to receive the corresponding Messages
   */
  BaseMessage(ID msgID) : Message<ID>(msgID) {}

  /**
   *
   * @return Should return a deep copy of the
   * object itself. Derived Classes with complex
   * members should take care of correct design and
   * implemention in respect to copy functionality
   */
  BaseMessage *clone() const { return new BaseMessage<ID>(this->m_MsgID);}
};

#endif
