//
// VolumeManager/PropertyStore.h
//
// hold current values of all properties VolumeManager is responsible for
//
//  Created on: Jul 3, 2014

#pragma once

class fc_audiomanager_tclService_Audio_Function_Stub;

#include <map>

#include "osal_if.h"
#include "Volume/KDSHelper.h"
#include "Volume/PersistenceStore/PersistenceStore.h"


namespace VolumeManager
{

   // --------------------------------------------------------------------------

   class  Configuration;
   class  SourceConfig;
   class  Attenuation;

   // --------------------------------------------------------------------------

   class PropertyStore  : private Uncopyable
   {

   public:
      /* constructor */ PropertyStore(fc_audiomanager_tclService_Audio_Function_Stub& service);
      /* destructor */ ~PropertyStore();

      void setCurrentVolume(const std::string &sinkname, const tU16 & volumeStep);
      void setCurrentSource(const std::string &sinkname, const std::string & source );
      tU16 getCurrentVolume(const std::string &sinkname);
      std::string getCurrentSource(const std::string &sinkname);

      void setDynamicSinkMuteflag(const std::string &sinkname);
      void clearDynamicSinkMuteflag(const std::string &sinkname);
      bool isDynamicSinkMuteActive(const std::string &sinkname);

      void storePersistentVolume(const std::string &source, const std::string &sinkname, tU8 vol);
      tU8  getPersistentVolume(const std::string &source, const std::string &sinkname);

      Attenuation*& getAttenuation() ;
      void setAttenuation(Attenuation*& attenuation);

      Configuration*& getConfiguration() ;
      void setConfiguration( Configuration*& configuration);

      void updateSourceOnStack(const std::string & sinkName, const std::string & sourceName, bool state);
      std::map<std::string , std::map<std::string  , std::string > > getSourceOnStack(void);
      bool volumeStatus(const std::string & sinkName, const std::string & source);

   public:
      KDSHelper kdsHelper;
      PersistenceStore  persistenceStore;
   private:

      // member variables
      fc_audiomanager_tclService_Audio_Function_Stub& _service;
      std::map<std::string, std::pair<std::string, tU16 /*Current volume*/> >  DynamicSinkSourceVolumeMap;
      std::map<std::string, bool> DynamicSinkMuteState;
      std::map<std::string , std::map<std::string  , std::string > > sourcesOnStack;
      Attenuation * attenuation;
      Configuration * configuration;
   };

   // --------------------------------------------------------------------------

}

