/*
 * DPHelper.h
 *
 *  Created on: Sep 12, 2019
 *      Author: wma5kor
 */
#pragma once

#define DP_S_IMPORT_INTERFACE_FI
#include<string>

#ifndef LinuxX86Make
#include "dp_e880_if.h"
#endif

namespace VolumeManager
{
class DPHelper {
    public:
        DPHelper();
        virtual ~DPHelper();

        unsigned char get_group_volume(const unsigned char & groupId, const unsigned char &groupCount, const std::string &sinkname);
        void set_group_volume(const unsigned char & groupId, const unsigned char &groupCount, const std::string& sinkname,  const unsigned char vol);

        unsigned char get_onvolume_sink(const std::string& sinkname, const std::string &onvolume);
        void set_onvolume_sink(const std::string& sinkname, const std::string& onvolume, const unsigned char vol);

        template<typename dpObject, typename Index, typename Length>
        unsigned char get_from_list(dpObject& obj, Index index, Length lenght);

        template<typename dpObject, typename Index, typename Length, typename Vol>
        void set_to_list(dpObject& obj, Index index, Length lenght, Vol vol);

};

}


