/*
 * DPHelper.cpp
 *
 *  Created on: Sep 12, 2019
 *      Author: wma5kor
 */



#include "DPHelper.h"


namespace VolumeManager
{



DPHelper::DPHelper()
{
    // TODO Auto-generated constructor stub

}

DPHelper::~DPHelper()
{
    // TODO Auto-generated destructor stub
}



unsigned char DPHelper::get_group_volume(const unsigned char& groupId, const unsigned char &groupCount, const std::string& sinkname)
{
    unsigned char vol = 0;

#ifndef LinuxX86Make
    dp_tclAudioStackMultiDPgroup_volume_list_for_amp_a amp_a;
    dp_tclAudioStackMultiDPgroup_volume_list_for_amp_b amp_b;

    if(sinkname == "AMP_A")
    {
        vol = get_from_list(amp_a, groupId, groupCount);
    }
    else if(sinkname == "AMP_B")
    {
        vol = get_from_list(amp_b, groupId, groupCount);
    }

#else
    vol = 15;
#endif
    return vol;
}

void DPHelper::set_group_volume(const unsigned char& groupId, const unsigned char &groupCount, const std::string& sinkname, const unsigned char vol)
{

#ifndef LinuxX86Make
    dp_tclAudioStackMultiDPgroup_volume_list_for_amp_a amp_a;
    dp_tclAudioStackMultiDPgroup_volume_list_for_amp_b amp_b;

    if(sinkname == "AMP_A")
    {
        set_to_list(amp_a, groupId, groupCount, vol);
    }
    else if(sinkname == "AMP_B")
    {
        set_to_list(amp_b, groupId, groupCount, vol);
    }

#endif
}

unsigned char DPHelper::get_onvolume_sink(const std::string& sinkname, const std::string& onvolume)
{
    unsigned char vol = 0;
    unsigned char cabinId = 0;
    const unsigned char &cabinCount = 2;

#ifndef LinuxX86Make
    dp_tclAudioStackMultiDPOnVolume_Min OnVolume_Min;
    dp_tclAudioStackMultiDPOnVolume_Max OnVolume_Max;

    if(sinkname == "AMP_A")
    {
        if(onvolume == "OnVolumeMin")
        {
            vol = get_from_list(OnVolume_Min, cabinId, cabinCount);
        }
        else if(onvolume == "OnVolumeMax")
        {
            vol = get_from_list(OnVolume_Max, cabinId, cabinCount);
        }
    }

    else if(sinkname == "AMP_B")
    {
        cabinId = 1;
        if(onvolume == "OnVolumeMin")
        {
            vol = get_from_list(OnVolume_Min, cabinId, cabinCount);
        }
        else if(onvolume == "OnVolumeMax")
        {
            vol = get_from_list(OnVolume_Max, cabinId, cabinCount);
        }
    }
#endif
    return vol;
}

void DPHelper::set_onvolume_sink(const std::string& sinkname, const std::string& onvolume, const unsigned char vol)
{
    unsigned char cabinId = 0;
    const unsigned char &cabinCount = 2;

#ifndef LinuxX86Make
    dp_tclAudioStackMultiDPOnVolume_Min OnVolume_Min;
    dp_tclAudioStackMultiDPOnVolume_Max OnVolume_Max;

    if(sinkname == "AMP_A")
    {
        if(onvolume == "OnVolumeMin")
        {
            set_to_list(OnVolume_Min, cabinId, cabinCount, vol);
        }
        else if(onvolume == "OnVolumeMax")
        {
            set_to_list(OnVolume_Max, cabinId, cabinCount, vol);
        }
    }
    else if(sinkname == "AMP_B")
    {
        cabinId = 1;
        if(onvolume == "OnVolumeMin")
        {
            set_to_list(OnVolume_Min, cabinId, cabinCount, vol);
        }
        else if(onvolume == "OnVolumeMax")
        {
            set_to_list(OnVolume_Max, cabinId, cabinCount, vol);
        }
    }
#endif
}

template<typename dpObject, typename Index, typename Length>
inline unsigned char DPHelper::get_from_list(dpObject& obj, Index index, Length lenght)
{
    unsigned char vol = 0;

    unsigned char temp[lenght];
    (void)obj.s32GetData(temp, (unsigned int)sizeof(temp)/sizeof(unsigned char));

    vol = temp[index] ;
    return vol;
}

template<typename dpObject, typename Index, typename Length, typename Vol>
inline void DPHelper::set_to_list(dpObject& obj, Index index, Length lenght, Vol vol)
{
     unsigned char temp[lenght];
     (void)obj.s32GetData(temp, (unsigned int)sizeof(temp)/sizeof(unsigned char));
     temp[index] = vol;
     (void)obj.s32SetData(temp, (unsigned int)sizeof(temp)/sizeof(unsigned char));
}

}//namespace


