//
// VolumeAdjustmentFunctionBase.cpp
//
//  Created on: Sep 23, 2014
//      Author: Martin Koch, Fa. ESE
//




// framework
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>

#include "Volume/Types.h"
#include "Volume/Utilities/Uncopyable.h"
#include "./IFunction.h"
#include "./FunctionBase.h"
// - - - - - - - - - - - - -


#include "fc_audiomanager_trace.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CONTROLLER_VOLUME
#include "trcGenProj/Header/FunctionBase.cpp.trc.h"

//#include "../fc_audiomanager_service_Audio_Stub.h"
#include "Volume/PropertyStore.h"
#include "Volume/Configuration/Configuration.h"
#include "Volume/Configuration/ConfigDetails.hpp"
#include "Volume/Engine/StreamSet.h"

namespace VolumeManager
{

   // -----------------------------------------------------------------------------
   //
   //    class   V o l u m e   A d j u s t m e n t   F u n c t i o n   B a s e
   //

   /* constructor */ FunctionBase:: FunctionBase (PropertyStore& properties, const Configuration& config, const FunctionConfig& functionCfg, StreamSet& streamSet)
      : _properties(properties)
      , _config(config)
      , _streamSet(streamSet)
      , _pFunctionName(functionCfg.name)
      , _groupRefs((unsigned int)config.getSourceGroupCount())
   {
      vPopulateGroupRefs(functionCfg.groupRefs);
   }

   // -----------------------------------------------------------------------------

   /* virtual destructor */ FunctionBase:: ~FunctionBase ()
   {
      _pFunctionName = NULL;
   }

   // -----------------------------------------------------------------------------

   /* virtual */ void FunctionBase:: vAdjustVolume (tenFadingReason /* enReason */, VolumeData& /* volumeData */)
   {

   }

   // -----------------------------------------------------------------------------


   /* virtual */ void FunctionBase:: vAdjustAmplifierVolume (tenFadingReason /* enReason */
         , const VolumeData& /* volumeData */, bool& /* useStandardAmplifierCommand */)
   {

   }

   // -----------------------------------------------------------------------------

   /* static */ const char* FunctionBase:: pGetParameterValue (const char* pParams, const char* pParamName)
   {
      // scans the parameter line for first occurrence of given parameter name
      // and returns the position of its value (behind opening ')
      //
      // Note: this function always returns a valid string

      // provide a default empty string
      static const char pEmpty[] = "";

      if ((NULL == pParams) || (NULL == pParamName))
         return pEmpty;

      unsigned nameLength = (unsigned int)strlen(pParamName);
      if (strlen(pParams) < nameLength + 3)  // assume at least empty assignment: =''
         return pEmpty;

      const char* p = strstr(pParams, pParamName);
      if (NULL == p)
         return pEmpty;

      // skip parameter name, = and '
      p += nameLength;
      if (p[0] == '=')
         p++;
      if (p[0] == '\'')
         p++;
      return p;
   }

   // -----------------------------------------------------------------------------

   /* static */ unsigned FunctionBase:: getParameterLength (const char* pParam)
   {
      // assume pParam points to first character of parameter value behind opening '
      // and search for terminating ' and return the length unto it

      if (NULL == pParam)
         return 0;
      else if (strlen(pParam) < 1)
         return 0;

      const char* p = strchr(pParam, '\'');
      if (p && (p >= pParam))
         return (unsigned int)(p - pParam);
      else
         return (unsigned int)strlen(pParam);
   }

   // -----------------------------------------------------------------------------

   void FunctionBase:: vPopulateGroupRefs (const char* pGroupRefString)
   {
      _groupRefs.setSize(0);  // indicate 0 valid elements

      if ((NULL == pGroupRefString) || (0 == strlen(pGroupRefString)))
         return;

      const GroupConfig* pGroupsConfigs;
      size_t NumberOfGroups;
      _config.vGetSourceGroupConfigs (pGroupsConfigs, NumberOfGroups);
      if ((NULL == pGroupsConfigs) || (0 == NumberOfGroups))
         return;  // no chance to find a matching group

      const char* pEntryPosition = pGroupRefString;
      while (pEntryPosition)
      {
         unsigned len = getEntryLength (pEntryPosition);
         if (len)
         {
            // scan group-configurations for a name match
            for (unsigned i = 0; i < NumberOfGroups; ++i)
               if (pGroupsConfigs[i].name && (0 == strncmp(pEntryPosition, pGroupsConfigs[i].name, len)))
               {
                  // check if found group is valid for our StreamSet
                  for (unsigned j = 0; j < pGroupsConfigs[i].sinkCount; ++j)
                     if (pGroupsConfigs[i].ppSinks[j] && pGroupsConfigs[i].ppSinks[j]->pStreamSet
                           && (_streamSet.enGetResource() == pGroupsConfigs[i].ppSinks[j]->pStreamSet->enResource))
                     {
                        // append found entry
                        unsigned groupRefIndex = _groupRefs.size();
                        _groupRefs[groupRefIndex] = &pGroupsConfigs[i];
                        _groupRefs.setSize(1 + groupRefIndex);
                     }
                  break;
               }

            pEntryPosition = pGetNextEntry(pEntryPosition + len);
         }
      }

      // log
      ETG_TRACE_USR1(("FunctionBase::vPopulateGroupRefs() : %u related source groups found for special function '%s'"
            , _groupRefs.size(), _pFunctionName))
      for (unsigned i = 0; i < _groupRefs.size(); ++i)
         if (_groupRefs[i]->name)
            ETG_TRACE_USR3(("FunctionBase::vPopulateGroupRefs() : \t\t %u: '%s'", i, _groupRefs[i]->name))
   }

   // -----------------------------------------------------------------------------

   bool FunctionBase:: affectsVolumeGroup (tU8 volumeGroup)
   {
      // affect all if no sourceGroup list specified
      if ( 0 == _groupRefs.size())
         return true;

      // search sourceGroup list for matching entry
      for (unsigned i = 0; i < _groupRefs.size(); ++i)
         if (_groupRefs[i] && (_groupRefs[i]->typeId == volumeGroup))
            return true;

      // not found in list
      return false;
   }

   // -----------------------------------------------------------------------------

   // accept tab-stop, newline, blank, comma, colon, semi-colon, vertical bar,
   // slash and backslash in any combination as separating characters
   static const char separators[] = {'\t', '\n', ',', ' ', ';', ':', '|', '\\', '/'};

   // -----------------------------------------------------------------------------

   /* static */ unsigned FunctionBase:: getEntryLength (const char* pGroupRefEntry)
   {
      // assuming pGroupRefEntry points to first character of parameter value
      // returns length to either next occurrence of blank or terminating zero

      if (NULL == pGroupRefEntry)
         return 0;
      else if (strlen(pGroupRefEntry) < 1)
         return 0;

      const char* p = strpbrk(pGroupRefEntry, separators);
      if (p && (p >= pGroupRefEntry))
         return (unsigned int)(p - pGroupRefEntry);
      else
         return (unsigned int)strlen(pGroupRefEntry);
   }

   // -----------------------------------------------------------------------------

   /* static */ const char* FunctionBase:: pGetNextEntry (const char* pGroupRefEntry)
   {
      // assume pGroupRefEntry points to a separating character
      // and length to either next occurrence of blank or terminating zero

      if (NULL == pGroupRefEntry)
         return NULL;

      for (unsigned i = 0; i < strlen(pGroupRefEntry); ++i)
         if (NULL == strchr(separators, pGroupRefEntry[i]))
            return &pGroupRefEntry[i];

      return NULL;             // end of string encountered
   }

   // -----------------------------------------------------------------------------

}  // namespace VolumeManager

