//
// VolumeManager/Engine/Engine.h   for sub-component VolumeManager
//
//
//  Created on: Jun 17, 2014
//      Author: Martin Koch, Fa. ESE
//

#if !defined(EA_F3E8E4C0_D3FB_4a06_AAED_B30D7CE1FCFB__INCLUDED_)
#define EA_F3E8E4C0_D3FB_4a06_AAED_B30D7CE1FCFB__INCLUDED_
//#ifndef OBSERVER_H_
//#define OBSERVER_H_

#include "../../../PostOfficeAdapter/InternalComponentCommunication/DataTypes/TypeDefines/SourceDefines.h"
class Fading_IF;
class midw_fi_tcl_Aud_VolumeStatusList;


namespace VolumeManager
{

   class StreamSet;
   class IAction;
   class ActionFactory;
   class IFunction;
   class PropertyStore;
   class SourceList;
   class Configuration;
   class PDCAttenuator;
   class HeatProtector;
   class SPIDuckingFilter;
   struct FunctionConfig;


   class Engine : private Uncopyable, public IF_MessageObserver<PO_MessageConfig::enID>
   {
      public:
         Engine(PropertyStore& store, const Configuration& config, Fading_IF* pFader);
         virtual  ~Engine();
         virtual void MessageNotification(PO_MessageConfig::enID MsgId);
         void vApplyOnVolumeLimits ();
      private:
         PropertyStore&  _properties;
         const Configuration&  _config;
         ActionFactory*    _pActionFactory;

         IFunction* createSpecialFunction (const FunctionConfig& functionCfg, unsigned streamSetIndex);
         bool bExecuteAction (IAction& action, tenResource enResource);
         bool bExecuteAction (IAction& action, const std::string &sinkName);
   };

}

//#endif // OBSERVER_H_
#endif // !defined(EA_F3E8E4C0_D3FB_4a06_AAED_B30D7CE1FCFB__INCLUDED_)
