#pragma once

class VolumeData;

class AmpVolumeData;
namespace VolumeManager
{

   // -----------------------------------------------------------------------------

   class Configuration;
   class SourceConfig;
   struct VolumeConstraints;
   // -----------------------------------------------------------------------------

   class VolumeSetAction  : public ActionBase
   {
   public:
      /* constructor */ VolumeSetAction (PropertyStore& properties, const Configuration& config
            , const VolumeData& data, tenFadingReason enReason);
      virtual /* destructor */ ~VolumeSetAction ();

      // IAction implementation
      virtual void vExecute (StreamSet& streamSet);

      static tenActions enGetFadingAction (tenFadingReason enReason);

   private:
      // member variables
      const VolumeData& _data;

      // helper functions
      void vApply (StreamSet& streamSet, VolumeData& nextVolume);
      void vUpdate (const VolumeData& nextVolume, const SourceConfig* pSourceConfig);

      const SourceConfig* pGetTargetSourceConfig (const StreamSet& streamSet);
      tU8 u8GetCurrentVolume (const StreamSet& streamSet);
      tU8 u8GetCalculatedTargetStep (const VolumeData& data, tU8 currentVol);
      void vApplyLimits (VolumeData& nextVolume, const SourceConfig* pSourceConfig, tU8 currentVol);

   };

   // -----------------------------------------------------------------------------

}  // namespace VolumeManager



