
//
// VolumeManager/Engine/Actions/VolumeSetAction.h
//
//  Created on: Jul 3, 2014
//      Author: Martin Koch, Fa. ESE
//



// framework
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>

#include "Volume/Types.h"  // implicitly links midw_fi alltypes.h and stl_pif.h vector
#include "Volume/VolumeManager.h"
#include "Volume/Utilities/Uncopyable.h"
#include "Volume/Utilities/Array.hpp"
#include "./IAction.h"
#include "./ActionBase.h"
#include "./VolumeSetAction.h"
// - - - - - - - - - - - - -

#include "Volume/Engine/Stream.h"
#include "Volume/Engine/StreamSet.h"
#include "Volume/Engine/Functions/IFunction.h"
#include "Volume/Configuration/ConfigDetails.hpp"
#include "Volume/Configuration/dBCalculator.h"
#include "Volume/Configuration/Configuration.h"
#include "Volume/PropertyStore.h"
#include "Volume/TypeConversions/Functions.h"
#include "Volume/DynamicSinkStore.h"
#include "Volume/Attenuation/Attenuation.h"

#include "../../../../PostOfficeAdapter/InternalComponentCommunication/DataTypes/MessageDataTypes/VolumeData.h"
#include "../../../../PostOfficeAdapter/InternalComponentCommunication/DataTypes/TypeDefines/SourceDefines.h"
#include "../../../../PostOfficeAdapter/InternalComponentCommunication/DataTypes/MessageDataTypes/AmpVolumeData.h"

#include "controllerplugin_Trace.h"
#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_CONTROLLER_VOLUME
#include "trcGenProj/Header/VolumeSetAction.cpp.trc.h"



namespace VolumeManager
{

   // -----------------------------------------------------------------------------

   /* constructor */ VolumeSetAction:: VolumeSetAction (PropertyStore& properties, const Configuration& config
         , const VolumeData& data, tenFadingReason /* enReason */)
      : ActionBase(properties, config)
      , _data(data)
   {
//      ETG_TRACE_USR3(("VolumeSetAction() invoked for reason %u while in mode %u with active source %u"
//            , ETG_CENUM(tenFadingReason, _enReason), ETG_CENUM(tenVolumeMode, _enMode)
//            , ETG_CENUM(tenInternalSource, 1)))
      _data.printData();
   }

   // -----------------------------------------------------------------------------

   /* virtual destructor */ VolumeSetAction:: ~VolumeSetAction ()
   {
      ETG_TRACE_USR4(("VolumeSetAction() completed."))
   }

   // -----------------------------------------------------------------------------

   /* virtual */ void VolumeSetAction:: vExecute (StreamSet& streamSet)
   {
      //tenResource enResource = streamSet.enGetResource();
      tU8 currentVol = u8GetCurrentVolume(streamSet);
     // ETG_TRACE_USR4(("VolumeSetAction()::vExecute enResource %d, (_data.m_Channel %d)",enResource,_data.m_Channel));


      VolumeData nextVolume;
      if (midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_NOT_DEF == _data.m_Channel)
         nextVolume.m_Channel = fiAudioChannel_StreamID_Map::getFirst(streamSet.enGetActiveStreamID());
      else
         nextVolume.m_Channel = _data.m_Channel;

     // nextVolume.m_Resource.setResource((midw_fi_tcl_e8_ResourceNo::tenType)DynamicSinkStore::getInstance().getSinkID(enResource));
      nextVolume.m_VolumeType.setVolumeType(midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_ABS);
      nextVolume.m_Volume = u8GetCalculatedTargetStep (_data, currentVol);
      nextVolume.m_VolumeGain = _data.m_VolumeGain;
      nextVolume.sinkName = _data.sinkName;

    //  streamSet.vApplyVolumeFilters(_enReason, nextVolume);

      // find configuration of active source on target stream
     // const SourceConfig* pSourceCfg =  pGetTargetSourceConfig(streamSet);

      const SourceConfig* pSourceCfg =  _config.pGetSourceConfig(_properties.getCurrentSource(_data.sinkName));

      // determine intended volume according to change direction
      vApplyLimits (nextVolume, pSourceCfg, currentVol);

      // apply external filtering on intended amplifier command (invisible to the user)
      bool useStandardAmplifierCommand = true;
     // streamSet.vApplyAmplifierFilters(_enReason, nextVolume, useStandardAmplifierCommand);

      if (useStandardAmplifierCommand)
      {
         vApply(streamSet, nextVolume);
         //vUpdate(nextVolume, pSourceCfg);

      }
   }

   // -----------------------------------------------------------------------------

   void VolumeSetAction::vApply (StreamSet& streamSet, VolumeData& nextVolume)
   {
//        ETG_TRACE_USR4(("VolumeSetAction()::vApply VolumeData.m_Resource %d, channel %d",
//         nextVolume.m_Resource.getResource(),nextVolume.m_Channel));


      tenStream enStreamID = fiAudioChannel_StreamID_Map::getSecond(_data.m_Channel);

      Ramp ramp = {0,0};
      Stream* pStream = streamSet.pGetStream(enStreamID);
      std::string sourceName = _properties.getCurrentSource(_data.sinkName);
      std::string group = _config.getGroupName(sourceName);


      const dBCalculator* pCalcSink = streamSet.pGetCalculator();
      if(pCalcSink == NULL) return;

      AmpVolumeData ampData= pStream->setVolume(*pCalcSink, nextVolume.m_Volume, ramp, sourceName, group );
      ampData.m_status = _properties.volumeStatus(ampData.m_SinkName, ampData.m_Source);
      VolumeManager::vLaunchAmplifierCommand(ampData);

      if(!_properties.isDynamicSinkMuteActive(nextVolume.sinkName)){
          _properties.setCurrentVolume(nextVolume.sinkName, nextVolume.m_Volume);
          _properties.storePersistentVolume(_properties.getCurrentSource(_data.sinkName), nextVolume.sinkName, nextVolume.m_Volume);


          if(group == "Entertain" )
          {
             // _attenuation->updateEntVolume(sourceName,_data.sinkName,nextVolume.m_Volume, 30/*pCalcSink->s16GetdBValue(nextVolume.m_Volume, EN_AUDIO_SOURCE_STREAM_MAIN)*/);
              _properties.getAttenuation()->updateEntVolume(sourceName,_data.sinkName,nextVolume.m_Volume, pCalcSink->s16GetdBValue(nextVolume.m_Volume, EN_AUDIO_SOURCE_STREAM_MAIN));

          }


      }

   }

   // -----------------------------------------------------------------------------

   void VolumeSetAction:: vUpdate (const VolumeData& nextVolume, const SourceConfig* pSourceConfig)
   {
      tU8 volume = nextVolume.getVolume();
      (void)volume;

      if (pSourceConfig)
      {
        //tenResource enResource = DynamicSinkStore::getInstance().getenResource(_data.m_Resource.getResource());

      }
   }

   // -----------------------------------------------------------------------------

   const SourceConfig* VolumeSetAction:: pGetTargetSourceConfig (const StreamSet& streamSet)
   {

     // tenResource enResource = streamSet.enGetResource();
      return _config.pGetSourceConfig(_properties.getCurrentSource(streamSet.getSinkName()));
   }

   // -----------------------------------------------------------------------------

   tU8 VolumeSetAction:: u8GetCurrentVolume (const StreamSet& streamSet)
   {
          return (tU8)(_properties.getCurrentVolume(streamSet.getSinkName()));
   }

   // -----------------------------------------------------------------------------

   tU8 VolumeSetAction:: u8GetCalculatedTargetStep (const VolumeData& data, tU8 currentVol)
   {
      // determine intended volume according to change direction
      switch (data.m_VolumeType.getVolumeType())
      {
         case midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_ABS:
            return data.m_Volume;

         case midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_INC:
            return (tS16)(currentVol + data.m_Volume) <= 255
                  ? (tU8)(currentVol + data.m_Volume)
                  : (tU8)255;

         case midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_DEC:
            return (tS16)(currentVol - data.m_Volume) >= 0
                  ? (tU8)(currentVol - data.m_Volume)
                  : 0;

         default:
            ETG_TRACE_ERR(("VolumeSetAction undefined change direction: leaving current volume %u untouched ..."
                  , currentVol))
            return currentVol;  // skip further processing
      }
   }

   // -----------------------------------------------------------------------------

   void VolumeSetAction:: vApplyLimits (VolumeData& nextVolume, const SourceConfig* pSourceConfig, tU8 currentVol)
   {

      const tU8 u8TargetVol = nextVolume.getVolume();


      VolumeConstraints limits;
      if (pSourceConfig)
         limits = pSourceConfig->getVolumeLimits();
      else
         ETG_TRACE_ERR(("vApplyLimits() - E R R O R :  no source"))



       //If no persistance tag, set to default volume in case of source selection.
       const GroupConfig* pConfig;
       size_t groupCount = 0;
      _config.vGetSourceGroupConfigs(pConfig, groupCount);

if(pConfig != NULL && pSourceConfig != NULL)
 {
    _config.vGetSourceGroupConfigs(pConfig, groupCount);
  for (unsigned i = 0; i < groupCount; ++i)
  {
   if (!pConfig[i].persistent)
     {
          if(pConfig[i].typeId == pSourceConfig->u8GetGroupType())
            {
            nextVolume.setVolume(pConfig[i].constraints.defaultStep);
            ETG_TRACE_ERR(("VolumeSetAction leads to default volume : current = %u, intended = %i, setting to %u (default)"
                           , currentVol, u8TargetVol, pConfig[i].constraints.defaultStep));
            return;
               }
     }
  }
}

      if (u8TargetVol < limits.minStep)
      {
         ETG_TRACE_ERR(("VolumeSetAction leads to underrange: current = %u, intended = %i, setting to %u (min)"
               , currentVol, u8TargetVol, limits.minStep))
         nextVolume.setVolume(limits.minStep);
      }
      else if (u8TargetVol > limits.maxStep)
      {
         ETG_TRACE_ERR(("VolumeSetAction leads to overrange: current = %u, intended = %i, setting to %u (max)"
               , currentVol, u8TargetVol, limits.maxStep))
         nextVolume.setVolume(limits.maxStep);
      }
      else
      {
         ETG_TRACE_USR3(("VolumeSetAction changing volume %u to %i ..."
               , currentVol,  u8TargetVol))
         nextVolume.setVolume(u8TargetVol);
      }

   }



   /* static */ tenActions VolumeSetAction:: enGetFadingAction (tenFadingReason enReason)
   {
      switch (enReason)
      {
         case EN_AUDIO_FADING_RES_SOURCESEL:
            return EN_AUDIO_FADING_ACTION_SEND_VOL;

         default:
            return EN_AUDIO_FADING_NOTIFY_CHG_VOL;
      }
   }

   // -----------------------------------------------------------------------------

}  // namespace VolumeManager
