//
// VolumeManager/Engine/Actions/SourceSwitchAction.cpp
//
//  Created on: Jul 30, 2014
//      Author: Martin Koch, Fa. ESE
//


// framework
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>

#include "Volume/Types.h"  // implicitly links <midw_fi_if.h> for alltypes.h and <stl_pif.h> for vector
#include "Volume/Utilities/Uncopyable.h"
#include "Volume/Utilities/Array.hpp"
#include "./IAction.h"
#include "./ActionBase.h"
#include "./SourceSwitchAction.h"
// - - - - - - - - - - - - -

#include "./VolumeSetAction.h"
#include "Volume/Configuration/Configuration.h"
#include "Volume/Engine/Stream.h"
#include "Volume/Engine/StreamSet.h"
#include "Volume/Configuration/ConfigDetails.hpp"
#include "Volume/Configuration/dBCalculator.h"
#include "Volume/PropertyStore.h"
#include "Volume/TypeConversions/Functions.h"
#include "Volume/DynamicSinkStore.h"

#include "../../../../PostOfficeAdapter/InternalComponentCommunication/DataTypes/MessageDataTypes/VolumeData.h"
#include "../../../../PostOfficeAdapter/InternalComponentCommunication/DataTypes/MessageDataTypes/VolumeSourceData.h"

#include "controllerplugin_Trace.h"
#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_CONTROLLER_VOLUME
#include "trcGenProj/Header/SourceSwitchAction.cpp.trc.h"



namespace VolumeManager
{

   // -----------------------------------------------------------------------------

   /* constructor */ SourceSwitchAction:: SourceSwitchAction (PropertyStore& properties, const Configuration& config, const VolumeSourceData& data)
      : ActionBase(properties, config)
      , _pNextSource(_config.pGetSourceConfig(data.m_SourceName))
   	  ,  volumeSourceData(data)
   {

//        auto sink_name =DynamicSinkStore().getSinkName(data.m_Resource.getResource());
//       _enLastSource = _properties.getCurrentSource(sink_name);
//       ETG_TRACE_USR4(("SourceSwitchAction() invoked for switching from %u to %u: on Sink %d"
//             , ETG_CENUM(tenInternalSource, _enLastSource), ETG_CENUM(tenInternalSource, data.m_Source), data.m_Resource.getResource()))


      if (NULL == _pNextSource)
         ETG_TRACE_ERR(("SourceSwitchAction() - E R R O R  :  target source configuration not found!"))
   }

   // -----------------------------------------------------------------------------

   /* virtual destructor */ SourceSwitchAction:: ~SourceSwitchAction ()
   {
      _pNextSource = NULL;
   }

   // -----------------------------------------------------------------------------

   /* virtual */ void SourceSwitchAction:: vExecute (StreamSet& streamSet)
   {


     //  tenResource enResource = streamSet.enGetResource();
       VolumeData data;
       data.m_Channel = fiAudioChannel_StreamID_Map::getFirst(streamSet.enGetActiveStreamID());
      // data.m_Resource.setResource((midw_fi_tcl_e8_ResourceNo::tenType)DynamicSinkStore::getInstance().getSinkID(enResource));
       data.m_VolumeType.setVolumeType(midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_ABS);
       data.m_Volume = _properties.getPersistentVolume(volumeSourceData.m_SourceName, volumeSourceData.m_ResourceName);
       data.sinkName = volumeSourceData.m_ResourceName;

       _properties.setCurrentVolume(data.sinkName, data.m_Volume);
       _properties.setCurrentSource(data.sinkName, volumeSourceData.m_SourceName);

       VolumeSetAction(_properties, _config, data, EN_AUDIO_FADING_RES_SOURCESEL).vExecute(streamSet);
      return;
}


}  // namespace VolumeManager
