/*
 * DynamicSinkStore.cpp
 *
 *  Created on: Mar 28, 2019
 *      Author: WMA5KOR
 */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"





#include "controllerplugin_Trace.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CONTROLLER_VOLUME
#include "trcGenProj/Header/DynamicSinkStore.cpp.trc.h"

#include "Types.h"
#include "DynamicSinkStore.h"

namespace VolumeManager
{

DynamicSinkStore::DynamicSinkStore()
{
  resource.insert(std::make_pair("AST  ",    std::make_pair<tenResource, tU16>(Speaker,    1)));
  resource.insert(std::make_pair("ADR_2",    std::make_pair<tenResource, tU16>(Headphone,  2)));
  resource.insert(std::make_pair("ADR_3",    std::make_pair<tenResource, tU16>(Sink17,    17)));
  resource.insert(std::make_pair("AMP_A",    std::make_pair<tenResource, tU16>(AMP_A,      0)));
  resource.insert(std::make_pair("AMP_B",    std::make_pair<tenResource, tU16>(AMP_B,      0)));
  resource.insert(std::make_pair("Glass_A1", std::make_pair<tenResource, tU16>(Glass_A1,   0)));
  resource.insert(std::make_pair("Glass_A2", std::make_pair<tenResource, tU16>(Glass_A2,   0)));
  resource.insert(std::make_pair("Glass_B1", std::make_pair<tenResource, tU16>(Glass_B1,   0)));
  resource.insert(std::make_pair("Glass_B2", std::make_pair<tenResource, tU16>(Glass_B2,   0)));

}

std::string DynamicSinkStore::getSinkName(const tU16& sink)
{
  for(auto &it : resource)
  {
    if((it.second).second == sink)
    {
      return it.first;
    }
  }

  return "UnknownSink";

}

std::string DynamicSinkStore::getSinkName(const tenResource& enResource)
{
    for(auto &it : resource)
    {
        if((it.second).first == enResource)
        {
            return it.first;
        }
    }

    return "UnknownSink";

}

tenResource DynamicSinkStore::getenResource(const tU16& sink)
{
  for(auto &it : resource)
  {
    if((it.second).second == sink)
    {
      return (it.second).first;
    }
  }

  return UndefinedResource;
}

tU16 DynamicSinkStore::getSinkID(const tenResource& enResource)
{
  for(auto &it : resource)
  {
    if((it.second).first == enResource)
    {
      return (it.second).second;
    }
  }

  return 0;
}

tU16 DynamicSinkStore::getSinkID(const std::string& name)
{
   auto it = resource.find(name);
   return (it->second).second;

}

void DynamicSinkStore::updateDynamicSinkStore(const std::string& name, tU16 sink)
{
  for(auto &it : resource)
  {
    if(it.first == name)
    {
      (it.second).second = sink;
    }
  }
}

tenResource DynamicSinkStore::getenResource(const std::string& name)
{
    for(auto &it : resource)
    {
      if(it.first == name)
      {
        return (it.second).first;
      }
    }

    return UndefinedResource;
}

} //VolumeManager


