//
// CCAListener.cpp   for sub-component VolumeManager
//
//  Created on: Jun 18, 2014
//      Author: Martin Koch, Fa. ESE
//


// framework
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>


//Include public FI interface of this service.
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE   // import fi_tclVisitorMessage
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_SERVICEINFO
#include <midw_fi_if.h>


#define AMT_S_IMPORT_INTERFACE_GENERIC
#include <amt_if.h>


#include "CCAListener.h"
// - - - - - - - - - - -
//include datapool files
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"

// local headers
#include "Volume/Types.h"
#include "Volume/TypeConversions/Functions.h"
#include "../../PostOfficeAdapter/InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../PostOfficeAdapter/InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CCA_Start_Volume.h"
#include "../../PostOfficeAdapter/InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CCA_Start_VolumeMode.h"
#include "../../PostOfficeAdapter/InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CCA_Start_VolumeLock.h"


#include "fc_audiomanager_trace.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CONTROLLER_VOLUME
#include "trcGenProj/Header/CCAListener.cpp.trc.h"

#define MIN_ON_ENT_VOl 10
#define MAX_ON_ENT_VOl 20

namespace VolumeManager
{

   // =============================================================================
   //
   //                      ---   file-scoped helper functions   ---
   //

   // --------------------------------------------------------------------------

   void handleVolumeMode_MethodStart (const midw_mascffi_tclMsgVolumeModeMethodStart& data)
   {
      // launch PO message for incoming CCA message:  VolumeMode.MethodStart

      // setup outgoing PO message
      VolumeModeData outData;
      switch (data.VolumeMode.enType)  //#ma.wka.currently CCA message don't pass the channel
      {
         case midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_NAV_ANNOUCEMENT:
         case midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_SETUP_NAV_VOL:
         case midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_SETUP_NAV_ANNOUNCEMENT_VOL:
            outData.m_Channel = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_MIX;
            break;

         default:
            outData.m_Channel = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC;
            break;
      }
      outData.m_Resource = data.Resource.enType;
//      midw_fi_tcl_e8_SourceNo::tenType m_Source;
     outData.m_VolumeModeType = fiVolumeMode_Map::getSecond(data.VolumeMode.enType);

      ID_CCA_Start_VolumeMode outMsg(outData);
      InternalCommunicationAdapter::POMessages->DeliverMsg(&outMsg);

      ETG_TRACE_USR2(("VolumeManager - CCAListener - forwarded VolumeMode.MethodStart for Mode = %u"
            , ETG_CENUM(tenVolumeMode, outData.m_VolumeModeType)))
   }

   // --------------------------------------------------------------------------

   void handleVolume_Set (const midw_mascffi_tclMsgVolumeSet& data)
   {
      // launch PO message for incoming CCA message:  Volume.Set

      // filter for invalid messages
      if (data.VolumeType.enType == midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_NOT_DEF )
      {
         ETG_TRACE_USR1(("VolumeManager - CCAListener: invalid VolumeType: request rejected"))
         return;
      }

      // setup outgoing PO message
      VolumeData out;
      out.setVolume(data.Volume);
      out.setResource(data.Resource.enType);
      out.setVolumeType(data.VolumeType.enType);
      out.m_Channel = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_NOT_DEF;  // don't have this information here
      //tS16 m_VolumeGain;


      ID_CCA_Start_Volume outMsg(out);
      InternalCommunicationAdapter::POMessages->DeliverMsg(&outMsg);

      ETG_TRACE_USR2(("VolumeManager - CCAListener: - forwarded Volume.Set for Type = %d, Resource = %d, Volume = %d"
         , out.getVolumeType(), out.getResource(), out.getVolume() ))
   }

   // --------------------------------------------------------------------------

   void handleVolumeLock_Set (const midw_mascffi_tclMsgVolumeLockSet& data)
   {
      // launch PO message for incoming CCA message:  VolumeLock.Set

      ID_CCA_Start_VolumeLock outMsg(fiVolumeLockState_Map::getSecond(data.VolumeLockType.enType)
         , fiVolumeLockRequester_Map::getSecond(data.Requester.enType));
      InternalCommunicationAdapter::POMessages->DeliverMsg(&outMsg);
   }
   //--------------------------------------------------------------------------------
   void vhandleVolume_EntOnVolume (const midw_mascffi_tclMsgEntOnVolumeSetupSet& data)
      {
     dp_tclAudioManagerDPEntOnVolumeSet limitvolume;
     tU8 val = 0;

     if (data.SoundType.enType == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_ABS)
     {
      if((data.LimitValue >= MIN_ON_ENT_VOl) && (data.LimitValue <= MAX_ON_ENT_VOl))
      {
        val = data.LimitValue;
       limitvolume.s32SetData(val);
       ETG_TRACE_USR2(("VolumeManager - CCAListener: - Ent On Volume limit = %d", val ))
      }
      else if (data.LimitValue > MAX_ON_ENT_VOl)
      {
        val = MAX_ON_ENT_VOl;
        limitvolume.s32SetData(val);
      }
      else if(data.LimitValue < MIN_ON_ENT_VOl)
      {
        val = MIN_ON_ENT_VOl;
        limitvolume.s32SetData(val);
      }
     }
     else if(data.SoundType.enType  == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_INC)
     {
         limitvolume.s32GetData(val);
         val = (tU8)(data.LimitValue + val);
         if(val >= MAX_ON_ENT_VOl)
         {
           val = MAX_ON_ENT_VOl;
           limitvolume.s32SetData(val);
         }
         else
         {
           limitvolume.s32SetData(val);
         }
         ETG_TRACE_USR2(("VolumeManager - CCAListener: - Ent On Volume limit = %d", val ))
     }
     else if (data.SoundType.enType  == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_DEC)
     {
       limitvolume.s32GetData(val);
       val =  (tU8)(val- data.LimitValue);
       if(val <= MIN_ON_ENT_VOl)
       {
         val = MIN_ON_ENT_VOl;
         limitvolume.s32SetData(val);
       }
       else
       {
         limitvolume.s32SetData(val);
       }
       ETG_TRACE_USR2(("VolumeManager - CCAListener: - Ent On Volume limit = %d", val ))
     }

      }

   //--------------------------------------------------------------------------------

   // =============================================================================
   //
   //                 ---   class implementation   ---
   //

   // --------------------------------------------------------------------------

   /* constructor */ CCAListener::CCAListener()
   {
      ETG_TRACE_USR2(("VolumeManager - CCAListener established"))
//#ifndef LinuxX86Make
//  FILE* dbg_write_ptr = fopen("/var/opt/bosch/dynamic/ffs/VolumeManagerLib.log","a");
//  fprintf (dbg_write_ptr, "----------------- VolumeManager CCAListener::CCAListener() ---------------\n");
//  fprintf (dbg_write_ptr, "----------------- Start and End                            ---------------\n");
//  fclose(dbg_write_ptr);
//#endif
   }

   // --------------------------------------------------------------------------

   /* virtual destructor */ CCAListener:: ~CCAListener ()
   {
      ETG_TRACE_USR2(("VolumeManager - CCAListener terminated"))
   }

   // --------------------------------------------------------------------------

   tVoid CCAListener:: vOnMethodStart (tU16 u16FunctionId, amt_tclServiceData& inMessage)
   {
      fi_tclVisitorMessage visitor(&inMessage);

      switch (u16FunctionId)
      {
         case MIDW_MASCFFI_C_U16_VOLUMEMODE:
            {
               // get local data structure from incoming message
               midw_mascffi_tclMsgVolumeModeMethodStart data;
               visitor.s32GetData(data);

               handleVolumeMode_MethodStart(data);

               // cleanup
               data.vDestroy();
            }
            break;

         default:
            ETG_TRACE_FATAL(("VolumeManager - CCAListener::vOnMethodStart: unsupported FunctionID 0x%X", u16FunctionId))
            break;
      }
   }

   // --------------------------------------------------------------------------

   tBool CCAListener:: bProcessSet (amt_tclServiceData& inMessage, tBool& bPropertyChanged, tU16& u16Error)
   {
      // avoid automatic CCA client notification - inform caller that we handle this ourselves
      bPropertyChanged = FALSE;

      tU16 functionID = inMessage.u16GetFunctionID();
      fi_tclVisitorMessage visitor(&inMessage);
      ETG_TRACE_USR4(("VolumeManager - CCAListener:: bProcessSet got FktID %d",functionID));
      switch (functionID)
      {
         case MIDW_MASCFFI_C_U16_VOLUME:
            {
               // get local data structure from incoming message
               midw_mascffi_tclMsgVolumeSet data;
               visitor.s32GetData(data);

               handleVolume_Set(data);

               // cleanup
               data.vDestroy();
            }
            break;

         case MIDW_MASCFFI_C_U16_VOLUMELOCK:
            {
               // get local data structure from incoming message
               midw_mascffi_tclMsgVolumeLockSet data;
               visitor.s32GetData(data);

               handleVolumeLock_Set(data);

               // cleanup
               data.vDestroy();
            }
            break;

         case MIDW_MASCFFI_C_U16_PDCATTENUATION:
         case MIDW_MASCFFI_C_U16_PDCATTENUATIONLEVEL:
            // nothing to do here; they are forwarded by Engine directly to PDCAttenuator
            u16Error = MIDW_MASCFFI_C_U16_ERROR_INTERNALFAILURE;
            ETG_TRACE_FATAL(("VolumeManager - CCAListener::vOnMethodStart: accidentally received PDC-command %u"
                  , inMessage.u16GetFunctionID()))
            break;

         case MIDW_MASCFFI_C_U16_OVERTEMPREDUCTION:
            // nothing to do here; should be forwarded by Engine directly to HeatProtector
            u16Error = MIDW_MASCFFI_C_U16_ERROR_INTERNALFAILURE;
            ETG_TRACE_FATAL(("VolumeManager - CCAListener::vOnMethodStart: accidentally received HeatProtector-command %u"
                  , inMessage.u16GetFunctionID()))
            break;
         case MIDW_MASCFFI_C_U16_ENTONVOLUMESETUP:
         {
           midw_mascffi_tclMsgEntOnVolumeSetupSet data;
           visitor.s32GetData(data);
           vhandleVolume_EntOnVolume(data);
           data.vDestroy();
         }
        break;
         default:
            u16Error = MIDW_MASCFFI_C_U16_ERROR_INTERNALFAILURE;
            ETG_TRACE_FATAL(("VolumeManager - CCAListener::vOnMethodStart: unsupported FunctionID 0x%X", inMessage.u16GetFunctionID()))
            break;
      }

      return TRUE;
   }

   // --------------------------------------------------------------------------


}  // namespace VolumeManager
