///////////////////////////////////////////////////////////
//  ApplicationStateTypeConverter.cpp
//  Implementation of the Class ApplicationStateTypeConverter
//  Created on:      06.12.2012
///////////////////////////////////////////////////////////
// Include SPM interface to get the COPRO defines
#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_TYPES
#include "cfc_fi_if.h"

// Include SPM interface to get the COPRO defines
#include "ApplicationStateTypeConverter.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#include "controllerplugin_Trace.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CONTROLLER_VOLUME
#include "trcGenProj/Header/ApplicationStateTypeConverter.cpp.trc.h"




ApplicationStateTypeConverter* ApplicationStateTypeConverter::pInstance = NULL;

tVoid ApplicationStateTypeConverter::attachData()
{
#define CCA_APP_STATE
#define addData(a,b) m_TypeConverterMapAppStateTypeToInternalType.attachEntity(a, b);
#include "ApplicationStateConverter.conf"
#undef addData
#undef CCA_APP_STATE

#define PROC_STATE
#define addData(a,b) m_TypeConverterMapProcStateToInternalState.attachEntity(a, b);
#include "ApplicationStateConverter.conf"
#undef addData
#undef PROC_STATE
/*
#define CVM_STATE
#define addData(a,b) m_TypeConverterMapCVMStateToInternalState.attachEntity(a, b);
#include "ApplicationStateConverter.conf"
#undef addData
#undef CVM_STATE
*/
}

ApplicationStateTypeConverter::ApplicationStateTypeConverter()
{

}
tenApplicationStates ApplicationStateTypeConverter::getInternalUsedTypeForApplicationState(tU32 seachEntity)
{
   tenApplicationStates OutData = AUD_APP_PWR_EVENT_UNDEFINED;
   OutData = m_TypeConverterMapAppStateTypeToInternalType.getSecond(seachEntity);
   return (OutData);
}

tenApplicationStates ApplicationStateTypeConverter::getInternalUsedTypeForVoltageState(tU32 seachEntity)
{
   tenApplicationStates OutData = AUD_APP_PWR_EVENT_UNDEFINED;
   OutData = m_TypeConverterMapProcStateToInternalState.getSecond(seachEntity);

   return (OutData);
}

tenApplicationStates ApplicationStateTypeConverter::getInternalUsedTypeForCoproState(tU32 seachEntity)
{
   tenApplicationStates OutData = AUD_APP_PWR_EVENT_UNDEFINED;
   OutData = m_TypeConverterMapCVMStateToInternalState.getSecond(seachEntity);

   return (OutData);
}


ApplicationStateTypeConverter* ApplicationStateTypeConverter::getInstance()
{
   if (NULL == ApplicationStateTypeConverter::pInstance)
   {
      ETG_TRACE_USR4(("getInstance ApplicationStateTypeConverter"));
      ApplicationStateTypeConverter::pInstance = new ApplicationStateTypeConverter;
      pInstance->attachData();
   }
   return (ApplicationStateTypeConverter::pInstance);
}
