/**
 * VolumeSourceData.cpp
 *
 *  Created on: Jul 21, 2012
 *      Author: mor2hi
 */

#include "VolumeSourceData.h"
#include "util/Macro.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "controllerplugin_Trace.h"
//#include "fc_audiomanager_trace_macros.h"

#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_CONTROLLER_VOLUME
#include "trcGenProj/Header/VolumeSourceData.cpp.trc.h"

VolumeSourceData::VolumeSourceData()
{
   vSetToDefault();
}

VolumeSourceData::VolumeSourceData(const VolumeSourceData& DataToBeCopied)
{
   copyData(DataToBeCopied);
}

VolumeSourceData::~VolumeSourceData()
{
   // TODO Auto-generated destructor stub
}

tVoid VolumeSourceData::vSetToDefault()
{
   m_Channel = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_NOT_DEF;
   m_Resource.setResource(midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_NOT_DEF);
   m_Source = AUD_INT_SRC_UNDEFINED;
   m_Source_Type = AUD_INT_SRC_UNDEFINED;
   m_ClientSource = 0xFF;
   m_SourceName = "NONE";
   m_ResourceName = "NONE";
}

tVoid VolumeSourceData::printData() const
{
   ETG_TRACE_USR4(("VolumeSourceData: Data: Resource: %d, Channel: %d, Source: %d, SourceType: %d, ClientSource: %d ",
               ETG_CENUM(midw_fi_tcl_e8_ResourceNo::tenType, m_Resource.getResource()),
               ETG_CENUM(midw_fi_tcl_e8_AudioChannel::tenType, m_Channel),
               ETG_CENUM(tenInternalSource, m_Source),
               ETG_CENUM(tenInternalSource, m_Source_Type),
               m_ClientSource
         ));
   ETG_TRACE_USR4(("ResourceName : %s ", m_ResourceName.c_str()));
   ETG_TRACE_USR4(("SourceName : %s \n", m_SourceName.c_str()));
}

VolumeSourceData& VolumeSourceData::operator=(const VolumeSourceData& data)
{
   // protection again copy on itself
   if( &data == this)
   {
      ETG_TRACE_USR4(("VolumeSourceData: self compare!"));
      NORMAL_M_ASSERT_ALWAYS();
   }

   copyData(data);
   return (*this);
}

tVoid VolumeSourceData::copyData(const VolumeSourceData& data)
{
   m_Resource.setResource(data.m_Resource.getResource());
   m_Channel = data.m_Channel;
   m_Source = data.m_Source;
   m_Source_Type = data.m_Source_Type;
   m_ClientSource = data.m_ClientSource;
   m_SourceName = data.m_SourceName;
   m_ResourceName = data.m_ResourceName;
}

