/**
 * AmpVolumeData.h
 *
 *  Created on: Jul 21, 2012
 *      Author: mor2hi
 */

#ifndef AMP_VOLUME_H_
#define AMP_VOLUME_H_
#include "../../DataTypes/MessageDataTypes/VolumeData.h"
#include "../../DataTypes/TypeDefines/ADR3StreamType.h"
#include <string>


class AmpVolumeData
{
private:
   /**
    * Converter to transform the incoming CCA stream type into ADR3 defines
    */
   int m_StreamMapping_Adr3ToCCA;

public:
   tVoid vSetToDefault()const;
   AmpVolumeData();
   AmpVolumeData(AmpVolumeData* DataToBeCopied);
   AmpVolumeData(VolumeData* VolumeDataSet);
   ~AmpVolumeData();
   tenStream m_enStream;
   tU8 m_VolStep;
   tS16 m_VoldB;
   tU16 m_RampLin;
   tU16 m_RampdB;
   tU16 m_Sink;
   std::string m_SinkName;
   std::string m_Source;
   std::string m_Group;
   bool m_status;
};
#endif
