#include "AudioStack/SMT/clSrcState_Pause.h"
#include "AudioStack/AudioSources/clAudioSource.h"
#include "AudioStack/SMT/clSrcStateFactory.h"
#include "AudioStack/AudioSources/clFactory_AudioSourceClass.h"

namespace AudioStack { namespace SourceStateMachine
{
using namespace AudioSource;

void clSrcState_Pause::vEnter(clAudioSource* pclAudioSource, tU32 , tU8 )
{
   if (NULL != pclAudioSource)
   {
      pclAudioSource->vNotifyPauseDone();
   }
}

void clSrcState_Pause::vMsg_Off(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampDownToOff(), u32UserData, ENTRYCONDITION_NONE);
   if (NULL != pclAudioSource)
   {
      tU32 extID = clFactory_AudioSourceClass::GetExternalID(pclAudioSource->sGetId());
      pclAudioSource->vMW_CCAResponse(extID ,pclAudioSource->sGetId().u16SubSource, clAudioSource::Off);
   }
         //tS32 extSourceId, enSourceActivity activity)
   // simple transition from pause to off is just used to differentiate background and foreground-states
   // of sources in MW. No intermediate state required.

   //vSetState(pclAudioSource, clSrcStateFactory::pclCreateOff(), u32UserData, ENTRYCONDITION_NONE);
}

void clSrcState_Pause::vMsg_On(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   // sequence is:
   // 1) init() -> init_done()
   // 2) on() -> requesConfirmed() -> on_done()
   // as long as request is not confirmed from FC-Audio, an incoming off-request
   // is not delegated to FC-Audio. It has to be confirmed manually.
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateSrcAvailableCheck_On(), u32UserData, ENTRYCONDITION_NONE);
}

void clSrcState_Pause::vMsg_Pause(clAudioSource* pclAudioSource, tU32 )
{
   // no state change, just userdefined action for running src
   // This message in this state makes only sense for user defined actions
   // e.g. Tuner-Preset-Actions
   if (pclAudioSource != NULL &&  pclAudioSource->u32GetUserData() != 0)
   {
      pclAudioSource->vMW_Pause(pclAudioSource->u8GetNextSource());
   }
}

void clSrcState_Pause::vMsg_ServiceAvailable(clAudioSource* pclAudioSource, tU32 u32UserData)
{
    if (NULL != pclAudioSource)
   {
      pclAudioSource->vMW_Pause(pclAudioSource->u8GetNextSource());
   }
   // begin sequence again with init
    vSetState(pclAudioSource, clSrcStateFactory::pclCreatePause(), u32UserData);
}

}}//namespace

