/*
 * aud_dbus_lcm_proxy.h
 *
 *  Created on: 6th October, 2016
 *      Author: paj5kor
 */

#ifndef AUD_DBUS_LCM_PROXY_H_
#define AUD_DBUS_LCM_PROXY_H_

#include "aud_dbus_lcm_interface.h"
#include "aud_dbus_lcm_bus_watcher.h"

class CAmControlSenderBase;

#include "CThreadSwitchingClient.h"

using namespace am;

#include <stdint.h>

enum AudproState
{
  AUD_STATE_OFF      = 1,
  AUD_STATE_NORMAL    = 2,
  AUD_STATE_LIMITED    = 3,
  AUD_STATE_EMERGENCY    = 4
};


class aud_dbus_lcm_proxy: public aud_dbus_lcm_bus_watcher_IF
{
private:
  aud_dbus_lcm_proxy();
  aud_dbus_lcm_proxy(const aud_dbus_lcm_proxy&);

  /**
   * Pointer to hold gobject
   */
  static aud_dbus_lcm_proxy *m_poSelfPtr;
  OrgBoschCmLcm_dbus_fiLcm_dbus_fi_service*   m_poProxy;
 //am::IAmControlReceiverShadow *m_pControlReceiverShadowInterface;

  aud_dbus_lcm_bus_watcher*   m_pWatcher;
  bpstl::string         m_busname;
  bpstl::string        m_objpath;
  GBusType           m_bus_type;

  am::IAmControlReceiverShadow& m_receiverShadow;
  am::IAmControlReceive&        m_ControlReceive;
    CAmControlSenderBase& m_ControlSenderBase;

  void vSetAutoplay(guint audioState);
protected:
  virtual void vOnServerAvailable(GDBusConnection * connection);
  virtual void vOnServerUnAvailable(bpstl::string sBusName);

public:
  virtual ~aud_dbus_lcm_proxy();
  aud_dbus_lcm_proxy(aud_dbus_lcm_bus_watcher* pWatcher,GBusType bus_type,
    CAmControlSenderBase& controlSenderBase, am::IAmControlReceiverShadow& receiverShadow, am::IAmControlReceive& controlReceive);

  //Getters
  static void vHandle_GetLCMAudioState(OrgBoschCmLcm_dbus_fiLcm_dbus_fi_service *object, guint* audioState, gpointer pUserData);
};



#endif /* AUD_DBUS_LCM_PROXY_H_ */
