/*
 * aud_dbus_lcm_bus_watcher.h
 *
 *  Created on: 6th October, 2016
 *      Author: paj5kor
 */

#ifndef AUD_DBUS_LCM_BUS_WATCHER_H_
#define AUD_DBUS_LCM_BUS_WATCHER_H_

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#define SYSTEM_S_IMPORT_INTERFACE_MAP
#include <stl_pif.h>

#include <pthread.h>
#include <gio/gio.h>

/***
 * Interface for call backs
 */
class aud_dbus_lcm_bus_watcher_IF
{
public:
  virtual ~aud_dbus_lcm_bus_watcher_IF() {}
  virtual void vOnServerAvailable(GDBusConnection * connection) = 0;
  virtual void vOnServerUnAvailable(bpstl::string sBusName) = 0;
};

/**
 * Internal data for use by bus watcher
 */
class aud_dbus_lcm_bus_watch_data
{
public:
  guint handle;
  aud_dbus_lcm_bus_watcher_IF* pCallbackIF;
  aud_dbus_lcm_bus_watch_data()
  {
    handle = 0;
    pCallbackIF = NULL;
  }
};

/**
 * Bus Watcher class, with cpp abstraction over glib interface
 */
class aud_dbus_lcm_bus_watcher
{
private:
  GBusType m_bus_type;
  //Map to hold bus names for different bus types
  bpstl::map<bpstl::string,aud_dbus_lcm_bus_watch_data> m_bus_name_notification_table;
  pthread_mutex_t m_bus_name_notification_table_lock;

  //Explicit privates
  aud_dbus_lcm_bus_watcher();
  aud_dbus_lcm_bus_watcher(const aud_dbus_lcm_bus_watcher&);
public:
  aud_dbus_lcm_bus_watcher(GBusType bustype);
  virtual ~aud_dbus_lcm_bus_watcher();

  /**
   * Helper functions
   */
  bool bRegisterNotifyBusName(const char* busname,aud_dbus_lcm_bus_watcher_IF* pCallback);
  void vUnRegisterNotifyBusName(const char* busname);

  /**
   * Callback functions from glib mainloop
   */
  static  void on_name_appeared(GDBusConnection *connection,
       const gchar *name,
       const gchar *name_owner,
       gpointer user_data);

  static void on_name_vanished(GDBusConnection *connection,
       const gchar *name,
       gpointer user_data);
};


#endif /* AUD_DBUS_LCM_BUS_WATCHER_H_ */
